"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Provider = exports.BlockDurationMinutes = exports.InstanceInterruptionBehavior = exports.SpotInstanceType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const autoscaling = require("@aws-cdk/aws-autoscaling");
const ec2 = require("@aws-cdk/aws-ec2");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const spotone = require("cdk-spot-one");
/**
 * @stability stable
 */
var SpotInstanceType;
(function (SpotInstanceType) {
    SpotInstanceType["ONE_TIME"] = "one-time";
    SpotInstanceType["PERSISTENT"] = "persistent";
})(SpotInstanceType = exports.SpotInstanceType || (exports.SpotInstanceType = {}));
/**
 * @stability stable
 */
var InstanceInterruptionBehavior;
(function (InstanceInterruptionBehavior) {
    InstanceInterruptionBehavior["HIBERNATE"] = "hibernate";
    InstanceInterruptionBehavior["STOP"] = "stop";
    InstanceInterruptionBehavior["TERMINATE"] = "terminate";
})(InstanceInterruptionBehavior = exports.InstanceInterruptionBehavior || (exports.InstanceInterruptionBehavior = {}));
/**
 * @stability stable
 */
var BlockDurationMinutes;
(function (BlockDurationMinutes) {
    BlockDurationMinutes[BlockDurationMinutes["ONE_HOUR"] = 60] = "ONE_HOUR";
    BlockDurationMinutes[BlockDurationMinutes["TWO_HOURS"] = 120] = "TWO_HOURS";
    BlockDurationMinutes[BlockDurationMinutes["THREE_HOURS"] = 180] = "THREE_HOURS";
    BlockDurationMinutes[BlockDurationMinutes["FOUR_HOURS"] = 240] = "FOUR_HOURS";
    BlockDurationMinutes[BlockDurationMinutes["FIVE_HOURS"] = 300] = "FIVE_HOURS";
    BlockDurationMinutes[BlockDurationMinutes["SIX_HOURS"] = 360] = "SIX_HOURS";
})(BlockDurationMinutes = exports.BlockDurationMinutes || (exports.BlockDurationMinutes = {}));
/**
 * @stability stable
 */
class Provider extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id);
        this.defaultInstanceType = new ec2.InstanceType('t3.large');
    }
    /**
     * @stability stable
     */
    get amazonLinuxAmiImageId() {
        return new ec2.AmazonLinuxImage({
            generation: ec2.AmazonLinuxGeneration.AMAZON_LINUX_2,
        }).getImage(this).imageId;
    }
    /**
     * @stability stable
     */
    getOrCreateVpc(scope) {
        // use an existing vpc or create a new one
        return scope.node.tryGetContext('use_default_vpc') === '1' ?
            ec2.Vpc.fromLookup(scope, 'Vpc', { isDefault: true }) :
            scope.node.tryGetContext('use_vpc_id') ?
                ec2.Vpc.fromLookup(scope, 'Vpc', { vpcId: scope.node.tryGetContext('use_vpc_id') }) :
                new ec2.Vpc(scope, 'Vpc', { maxAzs: 3, natGateways: 1 });
    }
    /**
     * @stability stable
     */
    createInstanceProfile(id) {
        const role = new iam.Role(this, `Role${id}`, {
            assumedBy: new iam.ServicePrincipal('ec2.amazonaws.com'),
        });
        return new iam.CfnInstanceProfile(this, `InstanceProfile${id}`, {
            roles: [role.roleName],
        });
    }
    /**
     * Create Launch Template.
     *
     * @param id launch template id.
     * @param options launch template options.
     * @stability stable
     */
    createLaunchTemplate(id, options = {}) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k;
        const instanceProfileArn = options.instanceProfile ? options.instanceProfile.attrArn
            : this.createInstanceProfile('DefaultInstanceProfile').attrArn;
        return new ec2.CfnLaunchTemplate(this, id, {
            launchTemplateData: {
                imageId: ((_b = options.machineImage) === null || _b === void 0 ? void 0 : _b.getImage(this).imageId) || this.amazonLinuxAmiImageId,
                instanceType: ((_c = options.instanceType) === null || _c === void 0 ? void 0 : _c.toString()) || this.defaultInstanceType.toString(),
                userData: options.userData ? cdk.Fn.base64(options.userData.render()) : undefined,
                instanceMarketOptions: {
                    marketType: 'spot',
                    spotOptions: {
                        blockDurationMinutes: (_e = (_d = options.spotOptions) === null || _d === void 0 ? void 0 : _d.blockDurationMinutes) === null || _e === void 0 ? void 0 : _e.valueOf(),
                        instanceInterruptionBehavior: (_g = (_f = options.spotOptions) === null || _f === void 0 ? void 0 : _f.instanceInterruptionBehavior) === null || _g === void 0 ? void 0 : _g.valueOf(),
                        maxPrice: (_h = options.spotOptions) === null || _h === void 0 ? void 0 : _h.maxPrice,
                        spotInstanceType: (_k = (_j = options.spotOptions) === null || _j === void 0 ? void 0 : _j.spotInstanceType) === null || _k === void 0 ? void 0 : _k.valueOf(),
                    },
                },
                iamInstanceProfile: {
                    arn: instanceProfileArn,
                },
                tagSpecifications: [
                    {
                        resourceType: 'instance',
                        tags: [
                            {
                                key: 'Name',
                                value: `${this.node.path}/${id}`,
                            },
                        ],
                    },
                ],
            },
        });
    }
    /**
     * Create EC2 Spot Fleet.
     *
     * @param id fleet id.
     * @param options spot fleet options.
     * @stability stable
     */
    createFleet(id, options) {
        var _b, _c, _d;
        const lt = this.createLaunchTemplate(id, {
            instanceProfile: options.instanceProfile,
            instanceType: options.instanceType,
            machineImage: options.machineImage,
            spotOptions: options.spotOptions,
            userData: options.userData,
        });
        const spotFleetRole = new iam.Role(this, 'FleetRole', {
            assumedBy: new iam.ServicePrincipal('spotfleet.amazonaws.com'),
            managedPolicies: [
                iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AmazonEC2SpotFleetTaggingRole'),
            ],
        });
        const vpcSubnetSelection = (_b = options.vpcSubnet) !== null && _b !== void 0 ? _b : {
            subnetType: ec2.SubnetType.PRIVATE,
        };
        const subnetConfig = options.vpc.selectSubnets(vpcSubnetSelection).subnets.map(s => ({
            subnetId: s.subnetId,
        }));
        const fleet = new ec2.CfnSpotFleet(this, `${id}Resource`, {
            spotFleetRequestConfigData: {
                launchTemplateConfigs: [
                    {
                        launchTemplateSpecification: {
                            launchTemplateId: lt.ref,
                            version: lt.attrLatestVersionNumber,
                        },
                        overrides: subnetConfig,
                    },
                ],
                iamFleetRole: spotFleetRole.roleArn,
                targetCapacity: (_c = options.defaultCapacitySize) !== null && _c !== void 0 ? _c : 1,
                validFrom: options.validFrom,
                validUntil: options.validUntil,
                terminateInstancesWithExpiration: (_d = options.terminateInstancesWithExpiration) !== null && _d !== void 0 ? _d : true,
            },
        });
        return fleet;
    }
    /**
     * Create AutoScaling Group.
     *
     * @param id AutoScaling Group ID.
     * @param options AutoScaling Group options.
     * @stability stable
     */
    createAutoScalingGroup(id, options) {
        var _b;
        const asg = new autoscaling.AutoScalingGroup(this, id, {
            instanceType: this.defaultInstanceType,
            machineImage: new ec2.AmazonLinuxImage(),
            vpc: options.vpc,
            minCapacity: (_b = options.defaultCapacitySize) !== null && _b !== void 0 ? _b : 1,
            updatePolicy: autoscaling.UpdatePolicy.replacingUpdate(),
        });
        const cfnInstanceProfile = asg.node.tryFindChild('InstanceProfile');
        asg.role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        const lt = this.createLaunchTemplate(`LaunchTemplate${id}`, {
            instanceProfile: cfnInstanceProfile,
            instanceType: options.instanceType,
            machineImage: options.machineImage,
            spotOptions: options.spotOptions,
            userData: options.userData,
        });
        // property override
        const cfnAsg = asg.node.tryFindChild('ASG');
        cfnAsg.addPropertyDeletionOverride('LaunchConfigurationName');
        cfnAsg.addPropertyOverride('LaunchTemplate', {
            LaunchTemplateId: lt.ref,
            Version: lt.attrLatestVersionNumber,
        });
        return asg;
    }
    /**
     * @stability stable
     */
    createInstance(id, optons) {
        return new spotone.SpotInstance(this, id, optons);
    }
}
exports.Provider = Provider;
_a = JSII_RTTI_SYMBOL_1;
Provider[_a] = { fqn: "cdk-ec2spot.Provider", version: "0.1.37" };
//# sourceMappingURL=data:application/json;base64,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