"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const ec2spot = require("./index");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION || 'us-east-1',
            account: process.env.CDK_DEFAULT_ACCOUNT || '123456789012',
        };
        const stack = new cdk.Stack(app, 'integ-stack', { env });
        const provider = new ec2spot.Provider(stack, 'Provider');
        const vpc = provider.getOrCreateVpc(stack);
        // create a autoscaling group with spot instances
        provider.createAutoScalingGroup('SpotASG', {
            vpc,
            defaultCapacitySize: 2,
            instanceType: new ec2.InstanceType('m5.large'),
        });
        // create a spot fleet
        provider.createFleet('SpotFleet', {
            vpc,
            defaultCapacitySize: 2,
            instanceType: new ec2.InstanceType('t3.large'),
        });
        // create single spot instance
        provider.createInstance('SpotInstance', { vpc });
        // create another instance with new provider
        new ec2spot.Provider(stack, 'Provider2')
            .createInstance('SpotInstance2', { vpc });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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