# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc
import warnings

from . import blob_pb2 as blob__pb2

GRPC_GENERATED_VERSION = '1.63.2'
GRPC_VERSION = grpc.__version__
EXPECTED_ERROR_RELEASE = '1.65.0'
SCHEDULED_RELEASE_DATE = 'June 25, 2024'
_version_not_supported = False

try:
    from grpc._utilities import first_version_is_lower
    _version_not_supported = first_version_is_lower(GRPC_VERSION, GRPC_GENERATED_VERSION)
except ImportError:
    _version_not_supported = True

if _version_not_supported:
    warnings.warn(
        f'The grpc package installed is at version {GRPC_VERSION},'
        + f' but the generated code in blob_pb2_grpc.py depends on'
        + f' grpcio>={GRPC_GENERATED_VERSION}.'
        + f' Please upgrade your grpc module to grpcio>={GRPC_GENERATED_VERSION}'
        + f' or downgrade your generated code using grpcio-tools<={GRPC_VERSION}.'
        + f' This warning will become an error in {EXPECTED_ERROR_RELEASE},'
        + f' scheduled for release on {SCHEDULED_RELEASE_DATE}.',
        RuntimeWarning
    )


class BlobServiceStub(object):
    """BlobService is a service which provides RPCs to retrieve Git blobs from a
    specific repository.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.GetBlob = channel.unary_stream(
                '/gitaly.BlobService/GetBlob',
                request_serializer=blob__pb2.GetBlobRequest.SerializeToString,
                response_deserializer=blob__pb2.GetBlobResponse.FromString,
                _registered_method=True)
        self.GetBlobs = channel.unary_stream(
                '/gitaly.BlobService/GetBlobs',
                request_serializer=blob__pb2.GetBlobsRequest.SerializeToString,
                response_deserializer=blob__pb2.GetBlobsResponse.FromString,
                _registered_method=True)
        self.ListBlobs = channel.unary_stream(
                '/gitaly.BlobService/ListBlobs',
                request_serializer=blob__pb2.ListBlobsRequest.SerializeToString,
                response_deserializer=blob__pb2.ListBlobsResponse.FromString,
                _registered_method=True)
        self.ListAllBlobs = channel.unary_stream(
                '/gitaly.BlobService/ListAllBlobs',
                request_serializer=blob__pb2.ListAllBlobsRequest.SerializeToString,
                response_deserializer=blob__pb2.ListAllBlobsResponse.FromString,
                _registered_method=True)
        self.GetLFSPointers = channel.unary_stream(
                '/gitaly.BlobService/GetLFSPointers',
                request_serializer=blob__pb2.GetLFSPointersRequest.SerializeToString,
                response_deserializer=blob__pb2.GetLFSPointersResponse.FromString,
                _registered_method=True)
        self.ListLFSPointers = channel.unary_stream(
                '/gitaly.BlobService/ListLFSPointers',
                request_serializer=blob__pb2.ListLFSPointersRequest.SerializeToString,
                response_deserializer=blob__pb2.ListLFSPointersResponse.FromString,
                _registered_method=True)
        self.ListAllLFSPointers = channel.unary_stream(
                '/gitaly.BlobService/ListAllLFSPointers',
                request_serializer=blob__pb2.ListAllLFSPointersRequest.SerializeToString,
                response_deserializer=blob__pb2.ListAllLFSPointersResponse.FromString,
                _registered_method=True)


class BlobServiceServicer(object):
    """BlobService is a service which provides RPCs to retrieve Git blobs from a
    specific repository.
    """

    def GetBlob(self, request, context):
        """GetBlob returns the contents of a blob object referenced by its object
        ID. We use a stream to return a chunked arbitrarily large binary
        response
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetBlobs(self, request, context):
        """GetBlobs returns blobs identified via a revision and path.

        Note that the behaviour of this RPC is quite weird: it does not only return blobs, but will also return submodules
        as commits and trees. It's use is thus discouraged in favor of ListBlobs, which behaves more sanely.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListBlobs(self, request, context):
        """ListBlobs will list all blobs reachable from a given set of revisions by
        doing a graph walk. It is not valid to pass revisions which do not resolve
        to an existing object.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListAllBlobs(self, request, context):
        """ListAllBlobs retrieves all blobs pointers in the repository, including
        those not reachable by any reference.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetLFSPointers(self, request, context):
        """GetLFSPointers retrieves LFS pointers from a given set of object IDs.
        This RPC filters all requested objects and only returns those which refer
        to a valid LFS pointer.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListLFSPointers(self, request, context):
        """ListLFSPointers retrieves LFS pointers reachable from a given set of
        revisions by doing a graph walk. This includes both normal revisions like
        an object ID or branch, but also the pseudo-revisions "--all" and "--not"
        as documented in git-rev-parse(1). Revisions which don't directly or
        transitively reference any LFS pointers are ignored. It is not valid to
        pass revisions which do not resolve to an existing object.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListAllLFSPointers(self, request, context):
        """ListAllLFSPointers retrieves all LFS pointers in the repository, including
        those not reachable by any reference.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_BlobServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'GetBlob': grpc.unary_stream_rpc_method_handler(
                    servicer.GetBlob,
                    request_deserializer=blob__pb2.GetBlobRequest.FromString,
                    response_serializer=blob__pb2.GetBlobResponse.SerializeToString,
            ),
            'GetBlobs': grpc.unary_stream_rpc_method_handler(
                    servicer.GetBlobs,
                    request_deserializer=blob__pb2.GetBlobsRequest.FromString,
                    response_serializer=blob__pb2.GetBlobsResponse.SerializeToString,
            ),
            'ListBlobs': grpc.unary_stream_rpc_method_handler(
                    servicer.ListBlobs,
                    request_deserializer=blob__pb2.ListBlobsRequest.FromString,
                    response_serializer=blob__pb2.ListBlobsResponse.SerializeToString,
            ),
            'ListAllBlobs': grpc.unary_stream_rpc_method_handler(
                    servicer.ListAllBlobs,
                    request_deserializer=blob__pb2.ListAllBlobsRequest.FromString,
                    response_serializer=blob__pb2.ListAllBlobsResponse.SerializeToString,
            ),
            'GetLFSPointers': grpc.unary_stream_rpc_method_handler(
                    servicer.GetLFSPointers,
                    request_deserializer=blob__pb2.GetLFSPointersRequest.FromString,
                    response_serializer=blob__pb2.GetLFSPointersResponse.SerializeToString,
            ),
            'ListLFSPointers': grpc.unary_stream_rpc_method_handler(
                    servicer.ListLFSPointers,
                    request_deserializer=blob__pb2.ListLFSPointersRequest.FromString,
                    response_serializer=blob__pb2.ListLFSPointersResponse.SerializeToString,
            ),
            'ListAllLFSPointers': grpc.unary_stream_rpc_method_handler(
                    servicer.ListAllLFSPointers,
                    request_deserializer=blob__pb2.ListAllLFSPointersRequest.FromString,
                    response_serializer=blob__pb2.ListAllLFSPointersResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'gitaly.BlobService', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class BlobService(object):
    """BlobService is a service which provides RPCs to retrieve Git blobs from a
    specific repository.
    """

    @staticmethod
    def GetBlob(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.BlobService/GetBlob',
            blob__pb2.GetBlobRequest.SerializeToString,
            blob__pb2.GetBlobResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetBlobs(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.BlobService/GetBlobs',
            blob__pb2.GetBlobsRequest.SerializeToString,
            blob__pb2.GetBlobsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ListBlobs(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.BlobService/ListBlobs',
            blob__pb2.ListBlobsRequest.SerializeToString,
            blob__pb2.ListBlobsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ListAllBlobs(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.BlobService/ListAllBlobs',
            blob__pb2.ListAllBlobsRequest.SerializeToString,
            blob__pb2.ListAllBlobsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetLFSPointers(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.BlobService/GetLFSPointers',
            blob__pb2.GetLFSPointersRequest.SerializeToString,
            blob__pb2.GetLFSPointersResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ListLFSPointers(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.BlobService/ListLFSPointers',
            blob__pb2.ListLFSPointersRequest.SerializeToString,
            blob__pb2.ListLFSPointersResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ListAllLFSPointers(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.BlobService/ListAllLFSPointers',
            blob__pb2.ListAllLFSPointersRequest.SerializeToString,
            blob__pb2.ListAllLFSPointersResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)
