"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NumberStringUnionResolver = exports.ImplicitTokenResolver = exports.LazyResolver = exports.ResolutionContext = void 0;
exports.resolve = resolve;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const app_1 = require("./app");
const lazy_1 = require("./lazy");
/**
 * Context object for a specific resolution process.
 */
class ResolutionContext {
    constructor(
    /**
     * Which ApiObject is currently being resolved.
     */
    obj, 
    /**
     * Which key is currently being resolved.
     */
    key, 
    /**
     * The value associated to the key currently being resolved.
     */
    value) {
        this.obj = obj;
        this.key = key;
        this.value = value;
        /**
         * Whether or not the value was replaced by invoking the `replaceValue` method.
         */
        this.replaced = false;
    }
    /**
     * Replaces the original value in this resolution context
     * with a new value. The new value is what will end up in the manifest.
     */
    replaceValue(newValue) {
        this.replacedValue = newValue;
        this.replaced = true;
    }
}
exports.ResolutionContext = ResolutionContext;
_a = JSII_RTTI_SYMBOL_1;
ResolutionContext[_a] = { fqn: "cdk8s.ResolutionContext", version: "2.70.14" };
/**
 * Resolvers instanecs of `Lazy`.
 */
class LazyResolver {
    resolve(context) {
        if (context.value instanceof lazy_1.Lazy) {
            const resolved = context.value.produce();
            context.replaceValue(resolved);
        }
    }
}
exports.LazyResolver = LazyResolver;
_b = JSII_RTTI_SYMBOL_1;
LazyResolver[_b] = { fqn: "cdk8s.LazyResolver", version: "2.70.14" };
/**
 * Resolves implicit tokens.
 */
class ImplicitTokenResolver {
    resolve(context) {
        if (typeof (context.value.resolve) === 'function') {
            const resolved = context.value.resolve();
            context.replaceValue(resolved);
        }
    }
}
exports.ImplicitTokenResolver = ImplicitTokenResolver;
_c = JSII_RTTI_SYMBOL_1;
ImplicitTokenResolver[_c] = { fqn: "cdk8s.ImplicitTokenResolver", version: "2.70.14" };
/**
 * Resolves union types that allow using either number or string (as generated by the CLI).
 *
 * E.g IntOrString, Quantity, ...
 */
class NumberStringUnionResolver {
    resolve(context) {
        if (context.value.constructor === Object) {
            // we only want to resolve union classes, not plain dictionaries
            return;
        }
        if (NumberStringUnionResolver.TYPES.includes(typeof (context.value.value))) {
            // replace with a dictionary because the L1 proceeds to access the .value
            // property after resolution.
            context.replaceValue({ value: context.value.value });
        }
    }
}
exports.NumberStringUnionResolver = NumberStringUnionResolver;
_d = JSII_RTTI_SYMBOL_1;
NumberStringUnionResolver[_d] = { fqn: "cdk8s.NumberStringUnionResolver", version: "2.70.14" };
NumberStringUnionResolver.TYPES = ['number', 'string'];
/**
 * Resolves any value attached to a specific ApiObject.
 */
function resolve(key, value, apiObject) {
    const resolvers = app_1.App.of(apiObject).resolvers;
    if (value == null) {
        return value;
    }
    // give dibs to the resolvers as they are more specific
    const context = new ResolutionContext(apiObject, key, value);
    for (const resolver of resolvers) {
        resolver.resolve(context);
        if (context.replaced) {
            // stop when the first resolver replaces the value.
            return resolve(key, context.replacedValue, apiObject);
        }
    }
    // array - resolve each element
    if (Array.isArray(value)) {
        return value.map((x, i) => resolve([...key, `${i}`], x, apiObject));
    }
    // dictionrary - resolve leafs
    if (value.constructor == Object) {
        const result = {};
        for (const [k, v] of Object.entries(value)) {
            result[k] = resolve([...key, k], v, apiObject);
        }
        return result;
    }
    return value;
}
//# sourceMappingURL=data:application/json;base64,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