You are providing ongoing monitoring and alerts for portfolio holdings to stay informed of material developments and performance changes. Execute this continuous monitoring workflow:

**⚡ PERFORMANCE OPTIMIZATION (CRITICAL):**

**Phase 1: PARALLEL Core Monitoring**
Launch these key agents IN PARALLEL using the Task tool - DO NOT run them sequentially:

1. **news-sentry-market-watch** - Real-time news monitoring and material event detection
2. **ledger-performance-analyst** - Performance attribution and tracking
3. **risk-shield-manager** - Continuous risk monitoring and alerts

**CRITICAL INSTRUCTIONS:**
- Use the Task tool to launch ALL THREE core monitoring agents SIMULTANEOUSLY in a single response
- Each agent monitors portfolio from different critical perspectives in parallel
- Wait for ALL agents to complete before proceeding to secondary analysis
- This parallel approach reduces execution time by 60-70%

**WORKFLOW: Portfolio Holdings Monitoring & Alert System**

1. **PARALLEL Core Monitoring Phase (Launch Simultaneously)**

   **CRITICAL**: Use the Task tool with the EXACT subagent_type parameter as shown below:

   **Agent 1: news-sentry-market-watch** (Real-Time News Monitoring)
   - Use Task tool: `Task(subagent_type="news-sentry-market-watch", description="Real-time news monitoring", prompt="Conduct continuous news monitoring for all portfolio holdings. Filter for material events: earnings surprises, analyst actions, regulatory changes, management changes. Generate prioritized alerts with actionability ratings (IMMEDIATE/MONITOR/BACKGROUND). Track unusual volume patterns and market anomalies for holdings.")`

   **Agent 2: ledger-performance-analyst** (Performance Attribution)
   - Use Task tool: `Task(subagent_type="ledger-performance-analyst", description="Performance tracking and attribution", prompt="Provide ongoing performance tracking for all holdings. Monitor individual position performance vs sector and market benchmarks. Track contribution to overall portfolio returns (positive/negative contributors). Identify performance outliers requiring investigation.")`

   **Agent 3: risk-shield-manager** (Risk Alert System)
   - Use Task tool: `Task(subagent_type="risk-shield-manager", description="Continuous risk monitoring", prompt="Conduct continuous risk monitoring of portfolio holdings. Track position size changes due to price movements. Monitor sector concentration drift and correlation changes. Alert on VAR threshold breaches or emerging risk concentrations.")`

2. **Sequential Secondary Analysis (After Parallel Core Analysis Completes)**

   **Earnings & Guidance Tracking (Earnings Whisperer)**
   - Use Task tool: `Task(subagent_type="earnings-whisperer", description="Earnings and guidance monitoring", prompt="Monitor upcoming earnings for all holdings. Analyze earnings surprises and guidance changes. Track post-earnings price movements and analyst reaction. Identify potential post-earnings drift opportunities or risks.")`

   **Factor Exposure Drift (Factor Scout)**
   - Use Task tool: `Task(subagent_type="factor-scout", description="Factor exposure drift analysis", prompt="Monitor factor exposure changes over time. Track style drift in individual holdings (value→growth transitions, etc.). Alert on significant factor exposure changes that affect portfolio positioning. Monitor correlation breakdown between holdings.")`

   **Thesis Validation (Quill Equity Analyst)**
   - Use Task tool: `Task(subagent_type="quill-equity-analyst", description="Investment thesis validation", prompt="Conduct periodic thesis updates on major holdings. Re-evaluate investment cases based on new developments. Update fair value estimates and recommendation changes. Flag positions requiring detailed review or potential exit.")`

**Output Format:**
- Daily Dashboard: Holdings performance, news alerts, upcoming events
- Weekly Summary: Performance attribution, significant developments, action items
- Alert System: Real-time notifications for material events requiring attention
- Monthly Review: Thesis updates, position reviews, portfolio health metrics
- Watchlist Maintenance: Add/remove monitoring criteria based on portfolio changes

Maintain continuous situational awareness of portfolio holdings to enable proactive decision-making and rapid response to material developments affecting investment positions.
Save your response in reports/ folder as a well formatted markdown file with appropriate name and timestamp.