You are executing a systematic portfolio rebalancing to restore target allocations while optimizing for taxes and transaction costs. Follow this disciplined execution workflow:

**⚡ PERFORMANCE OPTIMIZATION (CRITICAL):**

**Phase 1: PARALLEL Core Planning**
Launch these key agents IN PARALLEL using the Task tool - DO NOT run them sequentially:

1. **rebalance-bot** - Rebalancing analysis and trade planning
2. **risk-shield-manager** - Risk validation and compliance
3. **tax-scout** - Tax optimization and sequencing

**CRITICAL INSTRUCTIONS:**
- Use the Task tool to launch ALL THREE core planning agents SIMULTANEOUSLY in a single response
- Each agent analyzes rebalancing from different critical perspectives in parallel
- Wait for ALL agents to complete before proceeding to execution
- This parallel approach reduces execution time by 60-70%

**WORKFLOW: Portfolio Rebalancing & Trade Execution**

1. **PARALLEL Core Planning Phase (Launch Simultaneously)**

   **CRITICAL**: Use the Task tool with the EXACT subagent_type parameter as shown below:

   **Agent 1: rebalance-bot** (Rebalancing Analysis)
   - Use Task tool: `Task(subagent_type="rebalance-bot", description="Rebalancing analysis and trade planning", prompt="Analyze current vs target allocations and identify significant portfolio drift requiring correction. Calculate specific trades needed to restore strategic targets. Consider tax implications and suggest tax-efficient rebalancing strategies. Prioritize trades by magnitude of drift and importance.")`

   **Agent 2: risk-shield-manager** (Risk Validation)
   - Use Task tool: `Task(subagent_type="risk-shield-manager", description="Risk validation and compliance", prompt="Validate rebalancing plan to ensure proposed trades don't violate risk limits or create new concentrations. Check that final allocation aligns with risk parameters and IPS guidelines. Assess market timing considerations and execution risks.")`

   **Agent 3: tax-scout** (Tax Optimization)
   - Use Task tool: `Task(subagent_type="tax-scout", description="Tax optimization and sequencing", prompt="Optimize trade sequencing for tax efficiency. Identify tax-loss harvesting opportunities within rebalancing. Consider wash-sale rule compliance and lot selection strategies. Balance rebalancing needs with tax optimization benefits.")`

2. **Sequential Execution Phase (After Parallel Planning Completes)**

   **Trade Execution (Trader Jane)**
   - Use Task tool: `Task(subagent_type="trader-jane-execution", description="Optimal trade execution", prompt="Execute rebalancing trades with optimal order routing and slicing. Apply appropriate order slicing and venue selection for each trade. Monitor execution progress and market impact. Provide real-time execution reports and cost analysis.")`

   **Cash Management (Cash Treasury Steward)**
   - Use Task tool: `Task(subagent_type="cash-treasury-steward", description="Cash flow management", prompt="Manage cash flows from rebalancing sales and ensure efficient reinvestment. Optimize cash buffers and sweep arrangements. Coordinate with trade execution timing to maintain appropriate liquidity.")`

   **Compliance Verification (Compliance Sentinel)**
   - Use Task tool: `Task(subagent_type="compliance-sentinel", description="Pre and post-trade compliance", prompt="Perform pre and post-trade compliance checks for all rebalancing trades. Validate all trades meet regulatory and account-specific requirements. Generate compliance logs and audit trail. Flag any potential issues before execution.")`

**Output Format:**
- Rebalancing Summary: Current vs target allocations and required trades
- Execution Plan: Specific trade orders with optimal routing and timing
- Tax Impact Analysis: Estimated tax consequences and optimization strategies
- Cost Estimate: Expected transaction costs and market impact
- Completion Report: Final allocations, execution quality, and performance impact

Execute rebalancing with institutional-quality precision while minimizing costs and tax impact to maximize long-term portfolio efficiency.
Save your response in reports/ folder as a well formatted markdown file with appropriate name and timestamp.