You are conducting comprehensive year-end tax optimization to minimize tax liability while maintaining strategic portfolio positioning. Execute this tax-efficient workflow:

**⚡ PERFORMANCE OPTIMIZATION (CRITICAL):**

**Phase 1: PARALLEL Core Analysis**
Launch these key agents IN PARALLEL using the Task tool - DO NOT run them sequentially:

1. **tax-scout** - Tax-loss harvesting identification
2. **risk-shield-manager** - Portfolio impact assessment
3. **rebalance-bot** - Rebalancing coordination

**CRITICAL INSTRUCTIONS:**
- Use the Task tool to launch ALL THREE core agents SIMULTANEOUSLY in a single response
- Each agent analyzes tax optimization from different perspectives in parallel
- Wait for ALL agents to complete before proceeding to execution planning
- This parallel approach reduces execution time by 60-70%

**WORKFLOW: Tax Optimization & Year-End Planning**

1. **PARALLEL Core Analysis Phase (Launch Simultaneously)**

   **CRITICAL**: Use the Task tool with the EXACT subagent_type parameter as shown below:

   **Agent 1: tax-scout** (Tax-Loss Harvesting)
   - Use Task tool: `Task(subagent_type="tax-scout", description="Tax-loss harvesting analysis", prompt="Conduct comprehensive tax-loss harvesting analysis. Identify all unrealized losses available for harvesting, calculate potential tax savings and optimal harvesting sequence, check wash-sale rule compliance, suggest compliant alternatives, and plan tax-loss harvesting to offset realized gains.")`

   **Agent 2: risk-shield-manager** (Portfolio Impact)
   - Use Task tool: `Task(subagent_type="risk-shield-manager", description="Tax optimization impact assessment", prompt="Evaluate tax optimization impact on portfolio risk. Ensure tax-driven trades don't create unwanted concentrations or exposures, validate that post-tax-optimization portfolio remains within risk parameters, and assess correlation impacts of selling losing positions.")`

   **Agent 3: rebalance-bot** (Rebalancing Coordination)
   - Use Task tool: `Task(subagent_type="rebalance-bot", description="Tax-aware rebalancing coordination", prompt="Coordinate tax optimization with strategic rebalancing. Identify opportunities to achieve rebalancing while harvesting losses, optimize trade sequencing to minimize tax impact while restoring target allocations, and consider asset location optimization across accounts.")`

2. **Sequential Execution Planning (After Parallel Analysis Completes)**

   **Execution Planning (Trader Jane)**
   - Use Task tool: `Task(subagent_type="trader-jane-execution", description="Tax-efficient trade execution planning", prompt="Plan tax-efficient trade execution. Design optimal timing for loss harvesting avoiding wash-sale windows. Coordinate lot selection strategies for tax optimization. Plan trades with minimal market impact while achieving tax objectives.")`

   **Cash Flow Management (Cash Treasury Steward)**
   - Use Task tool: `Task(subagent_type="cash-treasury-steward", description="Tax harvest cash flow optimization", prompt="Optimize cash generated from tax-loss harvesting. Plan efficient reinvestment in compliant substitute securities. Manage cash flows to maintain appropriate liquidity buffers.")`

   **Investment Thesis Preservation (Quill Equity Analyst)**
   - Use Task tool: `Task(subagent_type="quill-equity-analyst", description="Tax-aware thesis validation", prompt="Ensure tax optimization doesn't compromise investment strategy. Identify suitable substitute securities that maintain desired exposures. Validate that tax-driven sales align with fundamental investment views.")`

**Output Format:**
- Tax Optimization Summary: Total potential tax savings and harvesting opportunities
- Trade Execution Plan: Specific trades with timing and compliance considerations
- Portfolio Impact Analysis: Risk and allocation changes from tax optimization
- Reinvestment Strategy: Compliant substitute securities and allocation maintenance
- Implementation Timeline: Optimal sequencing to maximize tax benefits

Execute sophisticated tax optimization strategies that maximize after-tax returns while preserving long-term investment strategy and portfolio risk management discipline.
Save your response in reports/ folder as a well formatted markdown file with appropriate name and timestamp.