# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from toastapi.models.applied_discount import AppliedDiscount
from toastapi.models.customer import Customer
from toastapi.models.payment import Payment
from toastapi.models.selection import Selection
from typing import Optional, Set
from typing_extensions import Self

class Check(BaseModel):
    """
    Represents a single check within an order.
    """ # noqa: E501
    guid: StrictStr = Field(description="The GUID maintained by the Toast platform.")
    entity_type: StrictStr = Field(description="The type of object this is. Response only.", alias="entityType")
    external_id: Optional[StrictStr] = Field(default=None, description="External identifier string that is prefixed by the naming authority.", alias="externalId")
    created_date: Optional[datetime] = Field(default=None, description="The date and time that the Toast platform received the check.", alias="createdDate")
    opened_date: Optional[datetime] = Field(default=None, description="The date on which this check was opened.", alias="openedDate")
    selections: List[Selection]
    customer: Optional[Customer] = None
    amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The total calculated price of the check including discounts and service charges.")
    tax_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The calculated tax amount.", alias="taxAmount")
    total_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The total calculated price of this check including discounts and taxes.", alias="totalAmount")
    payments: Optional[Annotated[List[Payment], Field(min_length=0)]] = Field(default=None, description="Payments made on this check.")
    applied_discounts: Optional[Annotated[List[AppliedDiscount], Field(min_length=0)]] = Field(default=None, description="The discounts applied to this check.", alias="appliedDiscounts")
    voided: Optional[StrictBool] = Field(default=None, description="True if this check is voided. Response only.")
    void_date: Optional[datetime] = Field(default=None, description="The date when this check was voided. Response only.", alias="voidDate")
    paid_date: Optional[datetime] = Field(default=None, description="The most recent date when this check received payment.", alias="paidDate")
    __properties: ClassVar[List[str]] = ["guid", "entityType", "externalId", "createdDate", "openedDate", "selections", "customer", "amount", "taxAmount", "totalAmount", "payments", "appliedDiscounts", "voided", "voidDate", "paidDate"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Check from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in selections (list)
        _items = []
        if self.selections:
            for _item_selections in self.selections:
                if _item_selections:
                    _items.append(_item_selections.to_dict())
            _dict['selections'] = _items
        # override the default output from pydantic by calling `to_dict()` of customer
        if self.customer:
            _dict['customer'] = self.customer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in payments (list)
        _items = []
        if self.payments:
            for _item_payments in self.payments:
                if _item_payments:
                    _items.append(_item_payments.to_dict())
            _dict['payments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in applied_discounts (list)
        _items = []
        if self.applied_discounts:
            for _item_applied_discounts in self.applied_discounts:
                if _item_applied_discounts:
                    _items.append(_item_applied_discounts.to_dict())
            _dict['appliedDiscounts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Check from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "guid": obj.get("guid"),
            "entityType": obj.get("entityType"),
            "externalId": obj.get("externalId"),
            "createdDate": obj.get("createdDate"),
            "openedDate": obj.get("openedDate"),
            "selections": [Selection.from_dict(_item) for _item in obj["selections"]] if obj.get("selections") is not None else None,
            "customer": Customer.from_dict(obj["customer"]) if obj.get("customer") is not None else None,
            "amount": obj.get("amount"),
            "taxAmount": obj.get("taxAmount"),
            "totalAmount": obj.get("totalAmount"),
            "payments": [Payment.from_dict(_item) for _item in obj["payments"]] if obj.get("payments") is not None else None,
            "appliedDiscounts": [AppliedDiscount.from_dict(_item) for _item in obj["appliedDiscounts"]] if obj.get("appliedDiscounts") is not None else None,
            "voided": obj.get("voided"),
            "voidDate": obj.get("voidDate"),
            "paidDate": obj.get("paidDate")
        })
        return _obj


