# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class Discount(BaseModel):
    """
    Discount
    """ # noqa: E501
    guid: StrictStr = Field(description="The GUID maintained by the Toast platform.")
    entity_type: StrictStr = Field(description="The type of object this is. Response only.", alias="entityType")
    name: Optional[StrictStr] = Field(default=None, description="The human-readable name of the discount.")
    active: Optional[StrictBool] = Field(default=None, description="Indicates whether the discount is available and can be applied by restaurant employees. ")
    type: Optional[StrictStr] = Field(default=None, description="* `PERCENT` - the discount reduces the price by a preconfigured percent. * `FIXED` - the discount reduces the price by a preconfigured currency amount. * `OPEN_PERCENT` - the discount reduces the price by a percent entered by a restaurant employee. * `OPEN_FIXED` - the discount reduces the price by a currency amount entered by a restaurant employee. * `BOGO` - a buy one get one (BOGO) discount. * `FIXED_TOTAL` - a combo discount that reduces the price of all eligible items to a preconfigured currency amount. ")
    percentage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Percent discount applied when the `amountType` is `PERCENT`. This value will be greater than 0 and at most 100. ")
    amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The currency amount of the discount when the `amountType` is `FIXED`. This value will be greater than 0. ")
    selection_type: Optional[StrictStr] = Field(default=None, description="* `CHECK` - the discount can be applied to a check. * `BOGO` - a buy one get one (BOGO) discount. * `ITEM` - the discount can be applied to an item selection in a check. ", alias="selectionType")
    non_exclusive: Optional[StrictBool] = Field(default=None, description="Indicates whether you can apply the discount with other discounts. This value is always `false` for item and combo discounts. Set this value for check and BOGO discounts by selecting **Allow with other discounts** in the **Discounts Rules** section of the discounts configuration page of Toast Web. ", alias="nonExclusive")
    item_picking_priority: Optional[StrictStr] = Field(default=None, description="Indicates which menu item selections are discounted when you apply a BOGO discount. An item that is discounted by a BOGO discount is a \"get\" item.  * `FIRST` - the BOGO discount applies to the first matching item selection in the check or the discount is not a BOGO discount. The `itemPickingPriority` is always `FIRST` for discounts that are not BOGO discounts.  * `LEAST_EXPENSIVE` - the BOGO discount applies to the least expensive matching item selection in the check.  * `MOST_EXPENSIVE` - the BOGO discount applies to the most expensive matching item selection in the check. ", alias="itemPickingPriority")
    __properties: ClassVar[List[str]] = ["guid", "entityType", "name", "active", "type", "percentage", "amount", "selectionType", "nonExclusive", "itemPickingPriority"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PERCENT', 'FIXED', 'OPEN_PERCENT', 'OPEN_FIXED', 'BOGO', 'FIXED_TOTAL']):
            raise ValueError("must be one of enum values ('PERCENT', 'FIXED', 'OPEN_PERCENT', 'OPEN_FIXED', 'BOGO', 'FIXED_TOTAL')")
        return value

    @field_validator('selection_type')
    def selection_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['CHECK', 'ITEM', 'BOGO']):
            raise ValueError("must be one of enum values ('CHECK', 'ITEM', 'BOGO')")
        return value

    @field_validator('item_picking_priority')
    def item_picking_priority_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['FIRST', 'LEAST_EXPENSIVE', 'MOST_EXPENSIVE']):
            raise ValueError("must be one of enum values ('FIRST', 'LEAST_EXPENSIVE', 'MOST_EXPENSIVE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Discount from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Discount from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "guid": obj.get("guid"),
            "entityType": obj.get("entityType"),
            "name": obj.get("name"),
            "active": obj.get("active"),
            "type": obj.get("type"),
            "percentage": obj.get("percentage"),
            "amount": obj.get("amount"),
            "selectionType": obj.get("selectionType"),
            "nonExclusive": obj.get("nonExclusive"),
            "itemPickingPriority": obj.get("itemPickingPriority")
        })
        return _obj


