# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from toastapi.models.check import Check
from typing import Optional, Set
from typing_extensions import Self

class Order(BaseModel):
    """
    A Toast platform order is composed of one or more checks. Each check has  one or more menu item selections. 
    """ # noqa: E501
    guid: StrictStr = Field(description="The GUID maintained by the Toast platform.")
    entity_type: StrictStr = Field(description="The type of object this is. Response only.", alias="entityType")
    external_id: Optional[StrictStr] = Field(default=None, description="External identifier string that is prefixed by the naming authority.", alias="externalId")
    opened_date: Optional[datetime] = Field(default=None, description="The business date of the order. ", alias="openedDate")
    modified_date: Optional[datetime] = Field(default=None, description="The most recent date that the order, or a check or menu item selection in the order, was modified.", alias="modifiedDate")
    promised_date: Optional[datetime] = Field(default=None, description="For scheduled orders, the date and time that the order is scheduled to be fulfilled. ", alias="promisedDate")
    dining_option: Dict[str, Any] = Field(alias="diningOption")
    checks: Annotated[List[Check], Field(min_length=1)] = Field(description="The checks for this order. Most orders have one check. ")
    delivery_info: Optional[Dict[str, Any]] = Field(default=None, alias="deliveryInfo")
    number_of_guests: Optional[StrictInt] = Field(default=None, description="The number of restaurant guests that are associated with the order. ", alias="numberOfGuests")
    voided: Optional[StrictBool] = Field(default=None, description="Set to `true` if this order was voided. Response only.")
    void_date: Optional[datetime] = Field(default=None, description="The date on which this order was voided. Response only.", alias="voidDate")
    paid_date: Optional[datetime] = Field(default=None, description="The most recent date on which this order received payment.", alias="paidDate")
    business_date: Optional[StrictInt] = Field(default=None, description="The business date (yyyyMMdd) on which the order was fulfilled. Response only.", alias="businessDate")
    server: Optional[Dict[str, Any]] = None
    created_date: Optional[datetime] = Field(default=None, description="The date and time that the Toast platform received the order.", alias="createdDate")
    __properties: ClassVar[List[str]] = ["guid", "entityType", "externalId", "openedDate", "modifiedDate", "promisedDate", "diningOption", "checks", "deliveryInfo", "numberOfGuests", "voided", "voidDate", "paidDate", "businessDate", "server", "createdDate"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Order from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in checks (list)
        _items = []
        if self.checks:
            for _item_checks in self.checks:
                if _item_checks:
                    _items.append(_item_checks.to_dict())
            _dict['checks'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Order from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "guid": obj.get("guid"),
            "entityType": obj.get("entityType"),
            "externalId": obj.get("externalId"),
            "openedDate": obj.get("openedDate"),
            "modifiedDate": obj.get("modifiedDate"),
            "promisedDate": obj.get("promisedDate"),
            "diningOption": obj.get("diningOption"),
            "checks": [Check.from_dict(_item) for _item in obj["checks"]] if obj.get("checks") is not None else None,
            "deliveryInfo": obj.get("deliveryInfo"),
            "numberOfGuests": obj.get("numberOfGuests"),
            "voided": obj.get("voided"),
            "voidDate": obj.get("voidDate"),
            "paidDate": obj.get("paidDate"),
            "businessDate": obj.get("businessDate"),
            "server": obj.get("server"),
            "createdDate": obj.get("createdDate")
        })
        return _obj


