# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from toastapi.models.external_reference import ExternalReference
from typing import Optional, Set
from typing_extensions import Self

class Payment(BaseModel):
    """
    Defines a payment.
    """ # noqa: E501
    guid: StrictStr = Field(description="The GUID maintained by the Toast platform.")
    entity_type: StrictStr = Field(description="The type of object this is. Response only.", alias="entityType")
    external_id: Optional[StrictStr] = Field(default=None, description="External identifier string that is prefixed by the naming authority.", alias="externalId")
    paid_date: Optional[datetime] = Field(default=None, description="The date on which the payment was made.", alias="paidDate")
    type: StrictStr = Field(description="The payment method. ")
    amount: Union[StrictFloat, StrictInt] = Field(description="The amount of this payment, excluding tips.")
    tip_amount: Union[StrictFloat, StrictInt] = Field(description="The amount tipped on this payment.", alias="tipAmount")
    amount_tendered: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The amount tendered for this payment.", alias="amountTendered")
    card_type: Optional[StrictStr] = Field(default=None, description="The type of credit card that was used. Response only.", alias="cardType")
    last4_digits: Optional[StrictStr] = Field(default=None, description="The last 4 digits of the credit card that was used. Response only.", alias="last4Digits")
    server: Optional[Dict[str, Any]] = None
    refund_status: Optional[StrictStr] = Field(default=None, description="Indicates whether the payment was refunded. Response only. ", alias="refundStatus")
    payment_status: Optional[StrictStr] = Field(default=None, description="The status of this payment when the type is `CREDIT`. Response only. ", alias="paymentStatus")
    other_payment: Optional[ExternalReference] = Field(default=None, alias="otherPayment")
    __properties: ClassVar[List[str]] = ["guid", "entityType", "externalId", "paidDate", "type", "amount", "tipAmount", "amountTendered", "cardType", "last4Digits", "server", "refundStatus", "paymentStatus", "otherPayment"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['CASH', 'CREDIT', 'GIFTCARD', 'HOUSE_ACCOUNT', 'REWARDCARD', 'LEVELUP', 'TOAST_SV', 'OTHER', 'UNDETERMINED']):
            raise ValueError("must be one of enum values ('CASH', 'CREDIT', 'GIFTCARD', 'HOUSE_ACCOUNT', 'REWARDCARD', 'LEVELUP', 'TOAST_SV', 'OTHER', 'UNDETERMINED')")
        return value

    @field_validator('card_type')
    def card_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['VISA', 'MASTERCARD', 'AMEX', 'DISCOVER', 'JCB', 'DINERS', 'CIT', 'MAESTRO', 'LASER', 'SOLO', 'INTERAC', 'EFTPOS', 'UNKNOWN']):
            raise ValueError("must be one of enum values ('VISA', 'MASTERCARD', 'AMEX', 'DISCOVER', 'JCB', 'DINERS', 'CIT', 'MAESTRO', 'LASER', 'SOLO', 'INTERAC', 'EFTPOS', 'UNKNOWN')")
        return value

    @field_validator('refund_status')
    def refund_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NONE', 'PARTIAL', 'FULL']):
            raise ValueError("must be one of enum values ('NONE', 'PARTIAL', 'FULL')")
        return value

    @field_validator('payment_status')
    def payment_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['OPEN', 'PROCESSING', 'AUTHORIZED_AT_RISK', 'AUTHORIZED', 'ERROR', 'ERROR_NETWORK', 'DENIED', 'PROCESSING_VOID', 'VOIDED_AT_RISK', 'CANCELLED', 'CAPTURE_IN_PROGRESS', 'CAPTURED', 'VOIDED']):
            raise ValueError("must be one of enum values ('OPEN', 'PROCESSING', 'AUTHORIZED_AT_RISK', 'AUTHORIZED', 'ERROR', 'ERROR_NETWORK', 'DENIED', 'PROCESSING_VOID', 'VOIDED_AT_RISK', 'CANCELLED', 'CAPTURE_IN_PROGRESS', 'CAPTURED', 'VOIDED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Payment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of other_payment
        if self.other_payment:
            _dict['otherPayment'] = self.other_payment.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Payment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "guid": obj.get("guid"),
            "entityType": obj.get("entityType"),
            "externalId": obj.get("externalId"),
            "paidDate": obj.get("paidDate"),
            "type": obj.get("type"),
            "amount": obj.get("amount"),
            "tipAmount": obj.get("tipAmount"),
            "amountTendered": obj.get("amountTendered"),
            "cardType": obj.get("cardType"),
            "last4Digits": obj.get("last4Digits"),
            "server": obj.get("server"),
            "refundStatus": obj.get("refundStatus"),
            "paymentStatus": obj.get("paymentStatus"),
            "otherPayment": ExternalReference.from_dict(obj["otherPayment"]) if obj.get("otherPayment") is not None else None
        })
        return _obj


