# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from toastapi.models.delivery import Delivery
from toastapi.models.general import General
from toastapi.models.location import Location
from toastapi.models.online_ordering import OnlineOrdering
from toastapi.models.prep_times import PrepTimes
from toastapi.models.schedules import Schedules
from toastapi.models.urls import URLs
from typing import Optional, Set
from typing_extensions import Self

class RestaurantInfo(BaseModel):
    """
    Information about the configuration of a restaurant in the Toast POS. 
    """ # noqa: E501
    guid: Optional[StrictStr] = None
    general: Optional[General] = None
    urls: Optional[URLs] = None
    location: Optional[Location] = None
    schedules: Optional[Schedules] = None
    delivery: Optional[Delivery] = None
    online_ordering: Optional[OnlineOrdering] = Field(default=None, alias="onlineOrdering")
    prep_times: Optional[PrepTimes] = Field(default=None, alias="prepTimes")
    __properties: ClassVar[List[str]] = ["guid", "general", "urls", "location", "schedules", "delivery", "onlineOrdering", "prepTimes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RestaurantInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of general
        if self.general:
            _dict['general'] = self.general.to_dict()
        # override the default output from pydantic by calling `to_dict()` of urls
        if self.urls:
            _dict['urls'] = self.urls.to_dict()
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of schedules
        if self.schedules:
            _dict['schedules'] = self.schedules.to_dict()
        # override the default output from pydantic by calling `to_dict()` of delivery
        if self.delivery:
            _dict['delivery'] = self.delivery.to_dict()
        # override the default output from pydantic by calling `to_dict()` of online_ordering
        if self.online_ordering:
            _dict['onlineOrdering'] = self.online_ordering.to_dict()
        # override the default output from pydantic by calling `to_dict()` of prep_times
        if self.prep_times:
            _dict['prepTimes'] = self.prep_times.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RestaurantInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "guid": obj.get("guid"),
            "general": General.from_dict(obj["general"]) if obj.get("general") is not None else None,
            "urls": URLs.from_dict(obj["urls"]) if obj.get("urls") is not None else None,
            "location": Location.from_dict(obj["location"]) if obj.get("location") is not None else None,
            "schedules": Schedules.from_dict(obj["schedules"]) if obj.get("schedules") is not None else None,
            "delivery": Delivery.from_dict(obj["delivery"]) if obj.get("delivery") is not None else None,
            "onlineOrdering": OnlineOrdering.from_dict(obj["onlineOrdering"]) if obj.get("onlineOrdering") is not None else None,
            "prepTimes": PrepTimes.from_dict(obj["prepTimes"]) if obj.get("prepTimes") is not None else None
        })
        return _obj


