# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from toastapi.models.tax_rate import TaxRate
from typing import Optional, Set
from typing_extensions import Self

class ServiceCharge(BaseModel):
    """
    ServiceCharge
    """ # noqa: E501
    guid: StrictStr = Field(description="The GUID maintained by the Toast platform.")
    entity_type: StrictStr = Field(description="The type of object this is. Response only.", alias="entityType")
    external_id: Optional[StrictStr] = Field(default=None, description="External identifier string that is prefixed by the naming authority.", alias="externalId")
    name: Optional[StrictStr] = Field(default=None, description="The name of this service charge.")
    amount_type: Optional[StrictStr] = Field(default=None, description="The type of service charge.", alias="amountType")
    amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Amount in USD to be applied for `FIXED` type service charges.")
    percent: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Percent fee to be applied for `PERCENT` type service charges, based on pre-discount check amount. Must be a number between 0 and 100. ")
    criteria: Optional[Dict[str, Any]] = None
    gratuity: Optional[StrictBool] = Field(default=None, description="True if the service charge is a gratuity and is assigned to the owner of the check.")
    taxable: Optional[StrictBool] = Field(default=None, description="True if tax should be applied to the service charge.")
    applicable_taxes: Optional[List[TaxRate]] = Field(default=None, description="A reference to the taxes applied to the service charge, if the service charge is taxable.", alias="applicableTaxes")
    service_charge_calculation: Optional[StrictStr] = Field(default=None, description="Defines whether or not the service charge is applied before (PRE) or after (POST) discounts. This field is null for non-percent service charges.", alias="serviceChargeCalculation")
    destination: Optional[StrictStr] = Field(default=None, description="Final recipient of the funds from this service charge.  * `RESTAURANT` - The business owner of the restaurant receives the service charge funds. * `SERVER` - Restaurant employees receive the service charge funds e.g. gratuity. * `TOAST` - Toast receives the service charge funds. * `THIRD_PARTY` - A third party receives the service charge funds e.g. fundraising funds go to charity. ")
    __properties: ClassVar[List[str]] = ["guid", "entityType", "externalId", "name", "amountType", "amount", "percent", "criteria", "gratuity", "taxable", "applicableTaxes", "serviceChargeCalculation", "destination"]

    @field_validator('amount_type')
    def amount_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['FIXED', 'PERCENT', 'OPEN']):
            raise ValueError("must be one of enum values ('FIXED', 'PERCENT', 'OPEN')")
        return value

    @field_validator('service_charge_calculation')
    def service_charge_calculation_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PRE_DISCOUNT', 'POST_DISCOUNT']):
            raise ValueError("must be one of enum values ('PRE_DISCOUNT', 'POST_DISCOUNT')")
        return value

    @field_validator('destination')
    def destination_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['RESTAURANT', 'SERVER', 'TOAST', 'THIRD_PARTY']):
            raise ValueError("must be one of enum values ('RESTAURANT', 'SERVER', 'TOAST', 'THIRD_PARTY')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ServiceCharge from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in applicable_taxes (list)
        _items = []
        if self.applicable_taxes:
            for _item_applicable_taxes in self.applicable_taxes:
                if _item_applicable_taxes:
                    _items.append(_item_applicable_taxes.to_dict())
            _dict['applicableTaxes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ServiceCharge from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "guid": obj.get("guid"),
            "entityType": obj.get("entityType"),
            "externalId": obj.get("externalId"),
            "name": obj.get("name"),
            "amountType": obj.get("amountType"),
            "amount": obj.get("amount"),
            "percent": obj.get("percent"),
            "criteria": obj.get("criteria"),
            "gratuity": obj.get("gratuity"),
            "taxable": obj.get("taxable"),
            "applicableTaxes": [TaxRate.from_dict(_item) for _item in obj["applicableTaxes"]] if obj.get("applicableTaxes") is not None else None,
            "serviceChargeCalculation": obj.get("serviceChargeCalculation"),
            "destination": obj.get("destination")
        })
        return _obj


