# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from toastapi.models.time_entry_break import TimeEntryBreak
from typing import Optional, Set
from typing_extensions import Self

class TimeEntry(BaseModel):
    """
    A `TimeEntry` captures the actual time an employee worked or took  a break. 
    """ # noqa: E501
    guid: StrictStr = Field(description="The GUID maintained by the Toast platform.")
    entity_type: StrictStr = Field(description="The type of object this is. Response only.", alias="entityType")
    external_id: Optional[StrictStr] = Field(default=None, description="External identifier string that is prefixed by the naming authority.", alias="externalId")
    created_date: Optional[datetime] = Field(default=None, description="Date created, in UTC format (read-only). ", alias="createdDate")
    modified_date: Optional[datetime] = Field(default=None, description="Date modified, in UTC format (read-only). ", alias="modifiedDate")
    deleted: Optional[StrictBool] = Field(default=None, description="If the time entry is deleted in the Toast platform. ")
    job_reference: Optional[Dict[str, Any]] = Field(default=None, alias="jobReference")
    employee_reference: Optional[Dict[str, Any]] = Field(default=None, alias="employeeReference")
    shift_reference: Optional[Dict[str, Any]] = Field(default=None, alias="shiftReference")
    in_date: Optional[datetime] = Field(default=None, description="The date and time that an employee clocked in to a work shift. ", alias="inDate")
    out_date: Optional[datetime] = Field(default=None, description="The date and time that an employee closed a work shift. ", alias="outDate")
    auto_clocked_out: Optional[StrictBool] = Field(default=None, description="Indicates whether the Toast platform automatically clocked the employee out of their shift at the end of the restaurant business day. ", alias="autoClockedOut")
    business_date: Optional[StrictStr] = Field(default=None, description="The business date of `inDate`, in the format of  \"yyyymmdd\". ", alias="businessDate")
    regular_hours: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Regular hours worked by the employee for this time entry,  excluding breaks. ", alias="regularHours")
    overtime_hours: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Any overtime hours taken by this employee during this  time entry. ", alias="overtimeHours")
    hourly_wage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Optional, historical `hourlyWage`; that is, the wage in  effect when the time entry was made. ", alias="hourlyWage")
    breaks: Optional[Annotated[List[TimeEntryBreak], Field(min_length=0)]] = Field(default=None, description="An optional array of time entry breaks, each break  defining a clock-in date, clock-out date, and whether or  not the break was paid. ")
    declared_cash_tips: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The currency amount of tips paid in cash during the time entry. ", alias="declaredCashTips")
    non_cash_tips: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The currency amount of tips paid using non-cash tender during the time entry. ", alias="nonCashTips")
    __properties: ClassVar[List[str]] = ["guid", "entityType", "externalId", "createdDate", "modifiedDate", "deleted", "jobReference", "employeeReference", "shiftReference", "inDate", "outDate", "autoClockedOut", "businessDate", "regularHours", "overtimeHours", "hourlyWage", "breaks", "declaredCashTips", "nonCashTips"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TimeEntry from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in breaks (list)
        _items = []
        if self.breaks:
            for _item_breaks in self.breaks:
                if _item_breaks:
                    _items.append(_item_breaks.to_dict())
            _dict['breaks'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TimeEntry from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "guid": obj.get("guid"),
            "entityType": obj.get("entityType"),
            "externalId": obj.get("externalId"),
            "createdDate": obj.get("createdDate"),
            "modifiedDate": obj.get("modifiedDate"),
            "deleted": obj.get("deleted"),
            "jobReference": obj.get("jobReference"),
            "employeeReference": obj.get("employeeReference"),
            "shiftReference": obj.get("shiftReference"),
            "inDate": obj.get("inDate"),
            "outDate": obj.get("outDate"),
            "autoClockedOut": obj.get("autoClockedOut"),
            "businessDate": obj.get("businessDate"),
            "regularHours": obj.get("regularHours"),
            "overtimeHours": obj.get("overtimeHours"),
            "hourlyWage": obj.get("hourlyWage"),
            "breaks": [TimeEntryBreak.from_dict(_item) for _item in obj["breaks"]] if obj.get("breaks") is not None else None,
            "declaredCashTips": obj.get("declaredCashTips"),
            "nonCashTips": obj.get("nonCashTips")
        })
        return _obj


