# Generated by Django 5.2.7 on 2025-10-14 12:25

import django.core.validators
import django.db.models.deletion
import uuid
from decimal import Decimal
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Currency',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, help_text='When this record was created')),
                ('updated_at', models.DateTimeField(auto_now=True, help_text='When this record was last updated')),
                ('code', models.CharField(db_index=True, help_text='Currency code from provider (e.g., USDTTRC20, BTC, ETH)', max_length=20, unique=True, validators=[django.core.validators.MinLengthValidator(3), django.core.validators.MaxLengthValidator(20)])),
                ('name', models.CharField(help_text='Full currency name (e.g., USDT (TRC20), Bitcoin)', max_length=100)),
                ('token', models.CharField(help_text='Token symbol (e.g., USDT, BTC, ETH)', max_length=20)),
                ('network', models.CharField(blank=True, help_text='Network name (e.g., TRC20, ERC20, Bitcoin)', max_length=50, null=True)),
                ('symbol', models.CharField(blank=True, help_text='Currency symbol (e.g., ₮, ₿, Ξ)', max_length=10)),
                ('decimal_places', models.PositiveSmallIntegerField(default=8, help_text='Number of decimal places for this currency')),
                ('is_active', models.BooleanField(db_index=True, default=True, help_text='Whether this currency is available for payments')),
                ('provider', models.CharField(default='nowpayments', help_text='Payment provider (always nowpayments for v2.0)', max_length=50)),
                ('min_amount_usd', models.DecimalField(decimal_places=2, default=1.0, help_text='Minimum payment amount in USD', max_digits=10)),
                ('sort_order', models.PositiveIntegerField(default=0, help_text='Sort order for currency list (lower = higher priority)')),
            ],
            options={
                'verbose_name': 'Currency',
                'verbose_name_plural': 'Currencies',
                'db_table': 'payments_currencies',
                'ordering': ['sort_order', 'token', 'network'],
                'indexes': [models.Index(fields=['is_active'], name='payments_cu_is_acti_3686a4_idx'), models.Index(fields=['code'], name='payments_cu_code_2e1e62_idx'), models.Index(fields=['token'], name='payments_cu_token_e86473_idx'), models.Index(fields=['sort_order'], name='payments_cu_sort_or_aeb906_idx')],
            },
        ),
        migrations.CreateModel(
            name='Payment',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, help_text='Unique identifier for this record', primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, help_text='When this record was created')),
                ('updated_at', models.DateTimeField(auto_now=True, help_text='When this record was last updated')),
                ('internal_payment_id', models.CharField(db_index=True, help_text='Internal payment identifier (PAY_YYYYMMDDHHMMSS_UUID)', max_length=100, unique=True)),
                ('amount_usd', models.DecimalField(decimal_places=2, help_text='Payment amount in USD', max_digits=10, validators=[django.core.validators.MinValueValidator(Decimal('1.0')), django.core.validators.MaxValueValidator(Decimal('50000.0'))])),
                ('pay_amount', models.DecimalField(blank=True, decimal_places=8, help_text='Amount to pay in cryptocurrency', max_digits=20, null=True)),
                ('actual_amount', models.DecimalField(blank=True, decimal_places=8, help_text='Actual amount received in cryptocurrency', max_digits=20, null=True)),
                ('actual_amount_usd', models.DecimalField(blank=True, decimal_places=2, help_text='Actual amount received in USD', max_digits=10, null=True)),
                ('provider', models.CharField(default='nowpayments', help_text='Payment provider (always nowpayments)', max_length=50)),
                ('provider_payment_id', models.CharField(blank=True, db_index=True, help_text='NowPayments payment ID', max_length=255, null=True, unique=True)),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('confirming', 'Confirming'), ('confirmed', 'Confirmed'), ('completed', 'Completed'), ('partially_paid', 'Partially Paid'), ('failed', 'Failed'), ('expired', 'Expired'), ('cancelled', 'Cancelled')], db_index=True, default='pending', help_text='Current payment status', max_length=20)),
                ('pay_address', models.CharField(blank=True, help_text='Cryptocurrency payment address', max_length=255, null=True)),
                ('payment_url', models.URLField(blank=True, help_text='Payment page URL (if provided by provider)', null=True)),
                ('transaction_hash', models.CharField(blank=True, db_index=True, help_text='Blockchain transaction hash', max_length=256, null=True)),
                ('confirmations_count', models.PositiveIntegerField(default=0, help_text='Number of blockchain confirmations')),
                ('expires_at', models.DateTimeField(blank=True, db_index=True, help_text='When this payment expires (typically 30 minutes)', null=True)),
                ('completed_at', models.DateTimeField(blank=True, help_text='When this payment was completed', null=True)),
                ('status_changed_at', models.DateTimeField(blank=True, db_index=True, help_text='When the payment status was last changed', null=True)),
                ('description', models.TextField(blank=True, help_text='Payment description')),
                ('provider_data', models.JSONField(blank=True, default=dict, help_text='Provider-specific data (raw response, etc.)')),
                ('currency', models.ForeignKey(help_text='Payment currency (e.g., USDTTRC20)', on_delete=django.db.models.deletion.PROTECT, related_name='payments', to='payments.currency')),
                ('user', models.ForeignKey(help_text='User who created this payment', on_delete=django.db.models.deletion.CASCADE, related_name='payments', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Payment',
                'verbose_name_plural': 'Payments',
                'db_table': 'payments_payments',
                'ordering': ['-created_at'],
                'indexes': [models.Index(fields=['user', 'status'], name='payments_pa_user_id_273df2_idx'), models.Index(fields=['status', 'created_at'], name='payments_pa_status_80fb12_idx'), models.Index(fields=['provider_payment_id'], name='payments_pa_provide_bdc413_idx'), models.Index(fields=['transaction_hash'], name='payments_pa_transac_7bab3a_idx'), models.Index(fields=['expires_at'], name='payments_pa_expires_febede_idx'), models.Index(fields=['status_changed_at'], name='payments_pa_status__2067ad_idx')],
                'constraints': [models.CheckConstraint(condition=models.Q(('amount_usd__gte', 1.0)), name='payments_min_amount_check'), models.CheckConstraint(condition=models.Q(('amount_usd__lte', 50000.0)), name='payments_max_amount_check')],
            },
        ),
        migrations.CreateModel(
            name='Transaction',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, help_text='Unique identifier for this record', primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, help_text='When this record was created')),
                ('updated_at', models.DateTimeField(auto_now=True, help_text='When this record was last updated')),
                ('transaction_type', models.CharField(choices=[('deposit', 'Deposit'), ('withdrawal', 'Withdrawal'), ('payment', 'Payment'), ('refund', 'Refund'), ('fee', 'Fee'), ('bonus', 'Bonus'), ('adjustment', 'Adjustment')], db_index=True, help_text='Type of transaction', max_length=20)),
                ('amount_usd', models.DecimalField(decimal_places=2, help_text='Transaction amount in USD (positive=credit, negative=debit)', max_digits=10)),
                ('balance_after', models.DecimalField(decimal_places=2, help_text='User balance after this transaction', max_digits=10, validators=[django.core.validators.MinValueValidator(Decimal('0.00'))])),
                ('payment_id', models.CharField(blank=True, db_index=True, help_text='Related payment ID (if applicable)', max_length=100, null=True)),
                ('description', models.TextField(help_text='Transaction description')),
                ('metadata', models.JSONField(blank=True, default=dict, help_text='Additional transaction metadata')),
                ('withdrawal_request_id', models.CharField(blank=True, db_index=True, help_text='Related withdrawal request ID (if applicable)', max_length=100, null=True)),
                ('user', models.ForeignKey(help_text='User who owns this transaction', on_delete=django.db.models.deletion.CASCADE, related_name='payment_transactions_v2', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Transaction',
                'verbose_name_plural': 'Transactions',
                'db_table': 'payments_transactions',
                'ordering': ['-created_at'],
                'indexes': [models.Index(fields=['user', 'created_at'], name='payments_tr_user_id_c1c1f7_idx'), models.Index(fields=['transaction_type', 'created_at'], name='payments_tr_transac_4c7d58_idx'), models.Index(fields=['payment_id'], name='payments_tr_payment_96b00a_idx'), models.Index(fields=['withdrawal_request_id'], name='payments_tr_withdra_5610a7_idx'), models.Index(fields=['amount_usd'], name='payments_tr_amount__c7f348_idx')],
            },
        ),
        migrations.CreateModel(
            name='UserBalance',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('balance_usd', models.DecimalField(decimal_places=2, default=Decimal('0.00'), help_text='Current balance in USD', max_digits=10, validators=[django.core.validators.MinValueValidator(Decimal('0.00'))])),
                ('total_deposited', models.DecimalField(decimal_places=2, default=Decimal('0.00'), help_text='Total amount deposited (lifetime)', max_digits=10, validators=[django.core.validators.MinValueValidator(Decimal('0.00'))])),
                ('total_withdrawn', models.DecimalField(decimal_places=2, default=Decimal('0.00'), help_text='Total amount withdrawn (lifetime)', max_digits=10, validators=[django.core.validators.MinValueValidator(Decimal('0.00'))])),
                ('last_transaction_at', models.DateTimeField(blank=True, help_text='When the last transaction occurred', null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('user', models.OneToOneField(help_text='User who owns this balance', on_delete=django.db.models.deletion.CASCADE, related_name='payment_balance_v2', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'User Balance',
                'verbose_name_plural': 'User Balances',
                'db_table': 'payments_user_balances',
                'indexes': [models.Index(fields=['balance_usd'], name='payments_us_balance_32e5aa_idx'), models.Index(fields=['last_transaction_at'], name='payments_us_last_tr_935db2_idx')],
                'constraints': [models.CheckConstraint(condition=models.Q(('balance_usd__gte', 0.0)), name='payments_balance_non_negative_check')],
            },
        ),
        migrations.CreateModel(
            name='WithdrawalRequest',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, help_text='Unique identifier for this record', primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, help_text='When this record was created')),
                ('updated_at', models.DateTimeField(auto_now=True, help_text='When this record was last updated')),
                ('internal_withdrawal_id', models.CharField(db_index=True, help_text='Internal withdrawal identifier (WD_YYYYMMDDHHMMSS_UUID)', max_length=100, unique=True)),
                ('amount_usd', models.DecimalField(decimal_places=2, help_text='Withdrawal amount in USD (min $10)', max_digits=10, validators=[django.core.validators.MinValueValidator(Decimal('10.0')), django.core.validators.MaxValueValidator(Decimal('100000.0'))])),
                ('wallet_address', models.CharField(help_text='Destination wallet address', max_length=255)),
                ('network_fee_usd', models.DecimalField(decimal_places=2, default=Decimal('0.00'), help_text='Network transaction fee in USD', max_digits=10)),
                ('service_fee_usd', models.DecimalField(decimal_places=2, default=Decimal('0.00'), help_text='Service fee in USD', max_digits=10)),
                ('total_fee_usd', models.DecimalField(decimal_places=2, default=Decimal('0.00'), help_text='Total fee (network + service) in USD', max_digits=10)),
                ('final_amount_usd', models.DecimalField(decimal_places=2, help_text='Final amount to receive (amount - total_fee)', max_digits=10)),
                ('crypto_amount', models.DecimalField(blank=True, decimal_places=8, help_text='Amount in cryptocurrency (calculated at processing time)', max_digits=20, null=True)),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('approved', 'Approved'), ('processing', 'Processing'), ('completed', 'Completed'), ('rejected', 'Rejected'), ('cancelled', 'Cancelled')], db_index=True, default='pending', help_text='Withdrawal status', max_length=20)),
                ('transaction_hash', models.CharField(blank=True, db_index=True, help_text='Blockchain transaction hash (after sending)', max_length=256, null=True)),
                ('admin_notes', models.TextField(blank=True, help_text='Admin notes (reason for rejection, etc.)')),
                ('approved_at', models.DateTimeField(blank=True, help_text='When approved by admin', null=True)),
                ('completed_at', models.DateTimeField(blank=True, help_text='When withdrawal was completed', null=True)),
                ('rejected_at', models.DateTimeField(blank=True, help_text='When rejected by admin', null=True)),
                ('cancelled_at', models.DateTimeField(blank=True, help_text='When cancelled by user', null=True)),
                ('status_changed_at', models.DateTimeField(blank=True, db_index=True, help_text='When status was last changed', null=True)),
                ('metadata', models.JSONField(blank=True, default=dict, help_text='Additional metadata (validation info, etc.)')),
                ('admin_user', models.ForeignKey(blank=True, help_text='Admin who processed this withdrawal', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='processed_withdrawals_v2', to=settings.AUTH_USER_MODEL)),
                ('currency', models.ForeignKey(help_text='Withdrawal currency', on_delete=django.db.models.deletion.PROTECT, related_name='withdrawals', to='payments.currency')),
                ('user', models.ForeignKey(help_text='User who requested withdrawal', on_delete=django.db.models.deletion.CASCADE, related_name='withdrawal_requests_v2', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Withdrawal Request',
                'verbose_name_plural': 'Withdrawal Requests',
                'db_table': 'payments_withdrawal_requests',
                'ordering': ['-created_at'],
                'indexes': [models.Index(fields=['user', 'status'], name='payments_wi_user_id_cdacdc_idx'), models.Index(fields=['status', 'created_at'], name='payments_wi_status_a0769d_idx'), models.Index(fields=['transaction_hash'], name='payments_wi_transac_d276e6_idx'), models.Index(fields=['status_changed_at'], name='payments_wi_status__b1c412_idx')],
                'constraints': [models.CheckConstraint(condition=models.Q(('amount_usd__gte', 10.0)), name='payments_withdrawal_min_amount_check'), models.CheckConstraint(condition=models.Q(('final_amount_usd__gte', 0.0)), name='payments_withdrawal_final_amount_check')],
            },
        ),
    ]
