# Collapsar

<p align="center">
    <img src="https://banners.beyondco.de/Collapsar.png?theme=dark&packageManager=pip+install&packageName=collapsar&pattern=cage&style=style_1&description=Masonite+Dashboard+Package&md=0&showWatermark=1&fontSize=100px&images=emoji-happy">
</p>

<p align="center">
  <a href="https://collapsar.aguad.dev">
    <img alt="Collapsar" src="https://img.shields.io/static/v1?label=Masonite&message=package&labelColor=grey&color=blue&logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAOCAYAAAAfSC3RAAAAAXNSR0IArs4c6QAAAIRlWElmTU0AKgAAAAgABQESAAMAAAABAAEAAAEaAAUAAAABAAAASgEbAAUAAAABAAAAUgEoAAMAAAABAAIAAIdpAAQAAAABAAAAWgAAAAAAAABIAAAAAQAAAEgAAAABAAOgAQADAAAAAQABAACgAgAEAAAAAQAAAA6gAwAEAAAAAQAAAA4AAAAATspU+QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAVlpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IlhNUCBDb3JlIDUuNC4wIj4KICAgPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIKICAgICAgICAgICAgeG1sbnM6dGlmZj0iaHR0cDovL25zLmFkb2JlLmNvbS90aWZmLzEuMC8iPgogICAgICAgICA8dGlmZjpPcmllbnRhdGlvbj4xPC90aWZmOk9yaWVudGF0aW9uPgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgPC9yZGY6UkRGPgo8L3g6eG1wbWV0YT4KTMInWQAAAnxJREFUKBVNUl1IVEEUPjPObdd1VdxWM0rMIl3bzbVWLSofVm3th0AhMakHHyqRiNSHEAq5b2HSVvoQRUiEECQUQkkPbRslRGigG8auoon2oPSjpev+3PWeZq7eaC5nDt93vplz5txDQJYpNxX4st4JFiwj9aCqmswUFQNS/A2YskrZJPYefkECC2GhQwAqvLYybwXrwBvq8HSNOXRO92+aH7nW8vc/wS2Z9TqneYt2KHjlf9Iv+43wFJMExzO0YE5OKe60N+AOW6OmE+WJTBrg23jjzWxMBauOlfyycsV24F+cH+zAXYUOGl+DaiDxfl245/W9OnVrSY+O2eqPkyz4sVvHoKp9gOihf5KoAVv3hkQgbj/ihG9fI3RixKcUVx7lJVaEc0vnyf2FFll+ny80ZHZiGhIKowWJBCEAKr+FSuNDLt+lxybSF51lo74arqs113dOZqwsptxNs5bwi7Q3q8npSC2AWmvjTncZf1l61e5DEizNn5mtufpsqk5+CZTuq00sP1wkNPv8jeEikVVlJso+GEwRtNs3QeBt2YP2V2ZI3Tx0e+7T89zK5tNASOLEytJAryGtkLc2PcBM5byyUWYkMQpMioYcDcchC6xN220Iv36Ot8pV0454RHLEwmmD7UWfIdX0zq3GjMPG5NKBtv5qiPEPekK2U51j1451BZoc3i+1ohSQ/UzzG5uYFFn2mwVUnO4O3JblXA91T51l3pB3QweDl7sNXMyEjbguSjrPcQNmwDkNc8CbCvDd0+xCC7RFi9wFulD3mJeXqxQevB4prrqgc0TmQ85NG/K43e2UwnMVAJIEBNfWRYR3HfnvivrIzMyo4Hgy+hfscvLo53jItAAAAABJRU5ErkJggg==">
  </a>
  <img alt="GitHub Workflow Status (branch)" src="https://img.shields.io/github/actions/workflow/status/usecollapsar/collapsar/pythonapp.yml?branch=develop">
  <img src="https://codecov.io/gh/usecollapsar/collapsar/branch/develop/graph/badge.svg?token="/>
  <img alt="PyPI" src="https://img.shields.io/pypi/v/collapsar">
  <img src="https://img.shields.io/badge/python-3.6+-blue.svg" alt="Python Version">
  <img alt="GitHub release (latest by date including pre-releases)" src="https://img.shields.io/github/v/release/usecollapsar/collapsar?include_prereleases">
  <img alt="License" src="https://img.shields.io/github/license/usecollapsar/collapsar">
  <a href="https://github.com/psf/black"><img alt="Code style: black" src="https://img.shields.io/badge/code%20style-black-000000.svg"></a>
</p>

## Introduction

Collapsar is a package that will let you save time creating a dashboard for your app. You won't need to worry anymore about creating CRUD's.

## Features

- _Add multiple resources to your dashboard using Masonite Models_
- _Use fields: TextField, IdField, PasswordField, SelectField and more_
- _Add basic validations: max, min, required, email, etc._

## Documentation

See the [official documentation](https://collapsar.aguad.dev) to learn how to use Collapsar.

## Installation

```bash
pip install collapsar
```

## Configuration

Add CollapsarProvider to your project in `config/providers.py`:

```python
# config/providers.py
# ...
from collapsar import CollapsarProvider

# ...
PROVIDERS = [
    # ...
    # Third Party Providers
    CollapsarProvider,
    # ...
]
```

Create a new resource using

```python
python craft resource MyModel
```

And see your panel on https://localhost/collapsar

## Contributing

Please read the [Contributing Documentation](https://collapsar.aguad.dev/docs/contributing/) here.

## Maintainers

- [Eduardo Aguad](https://www.github.com/eaguad1337)

## License


Collapsar is open-sourced software licensed under the [MIT license](LICENSE).

