"""
This code was originally published by the following individuals for use with
Scilab:
    Copyright (C) 2012 - 2013 - Michael Baudin
    Copyright (C) 2012 - Maria Christopoulou
    Copyright (C) 2010 - 2011 - INRIA - Michael Baudin
    Copyright (C) 2009 - Yann Collette
    Copyright (C) 2009 - CEA - Jean-Marc Martinez

    website: forge.scilab.org/index.php/p/scidoe/sourcetree/master/macros

Much thanks goes to these individuals. It has been converted to Python by
Abraham Lee.
"""

import numpy as np


def repeat_center(n, repeat):
    """
    Create the center-point portion of a design matrix

    Parameters
    ----------
    n : int
        The number of factors in the original design
    repeat : int
        The number of center points to repeat

    Returns
    -------
    mat : 2d-array
        The center-point portion of a design matrix (elements all zero).

    Example
    -------
    ::

        >>> repeat_center(3, 2)
        array([[0., 0., 0.],
               [0., 0., 0.]])

    """
    return np.zeros((repeat, n))
