from ipywidgets import IntProgress, HTML, VBox
from IPython.display import display
import time


def log_progress(sequence, every=None, size=None, name='Items'):
    is_iterator = False
    if size is None:
        try:
            size = len(sequence)
        except TypeError:
            is_iterator = True
    if size is not None:
        if every is None:
            every = 1 if size <= 200 else size // 200
    else:
        assert every is not None, 'sequence is iterator, set every'

    if is_iterator:
        progress = IntProgress(min=0, max=1, value=1)
        progress.bar_style = 'info'
    else:
        progress = IntProgress(min=0, max=size, value=0)
    label = HTML()
    box = VBox(children=[label, progress])
    display(box)

    index = 0
    try:
        start = time.time()
        for index, record in enumerate(sequence, 1):
            if index == 1 or index % every == 0:
                if is_iterator:
                    label.value = '{name}: {index} / ?\ttook {time:.4f}s.'.format(
                        name=name,
                        index=index,
                        time=time.time()-start
                    )
                else:
                    progress.value = index
                    label.value = u'{name}: {index} / {size}\ttook {time:.4f}s.\tleft approx {left:.4f}s.'.format(
                        name=name,
                        index=index,
                        size=size,
                        time = time.time() - start,
                        left = (time.time() - start) / index * (size - index)
                    )
            yield record
    except:
        progress.bar_style = 'danger'
        raise
    else:
        progress.bar_style = 'success'
        progress.value = index
        label.value = '{name}: {index} / {index}\ttook {time:.4f}s.'.format(
            name=name,
            index=str(index or '?'),
            time=time.time() - start
        )
