from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="cerona-tok",  # Package name on PyPI can have hyphens
    version="0.1.0",
    author="ZaiperUnbound",
    author_email="altheahueteah@gmail.com",
    license="MIT",
    description="A esolang with a proper tokenizer/lexer",
    long_description=long_description,
    long_description_content_type="text/markdown",
    packages=find_packages(),
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
    ],
    python_requires=">=3.6",
    entry_points={
        "console_scripts": [
            # CLI command = module_with_underscores.file:function
            "cerona-tok=cerona_tok.main:main",
        ],
    },
    install_requires=[],
)
