"""gemlib scientific compute library for epidemics."""

import importlib.metadata

# JAX Configuration
import jax

jax.config.update("jax_enable_x64", True)

__version__ = importlib.metadata.version(__package__)


from gemlib import deterministic, distributions, math, mcmc, util  # noqa: E402

__all__ = [
    "deterministic",
    "distributions",
    "math",
    "mcmc",
    "util",
]
