# @Author: Bi Ying
# @Date:   2024-07-27 00:02:34
from typing import Final
from typing_extensions import TypedDict, NotRequired

from .enums import ContextLengthControlType

CONTEXT_LENGTH_CONTROL: Final[ContextLengthControlType] = ContextLengthControlType.Latest

ENDPOINT_CONCURRENT_REQUESTS: Final[int] = 20
ENDPOINT_RPM: Final[int] = 60
ENDPOINT_TPM: Final[int] = 300000

MODEL_CONTEXT_LENGTH: Final[int] = 32768


class ModelSettingDict(TypedDict):
    id: str
    function_call_available: bool
    response_format_available: bool
    native_multimodal: bool
    context_length: int
    max_output_tokens: NotRequired[int]


# Moonshot models
MOONSHOT_DEFAULT_MODEL: Final[str] = "kimi-latest"
MOONSHOT_MODELS: Final[dict[str, ModelSettingDict]] = {
    "moonshot-v1-8k": {
        "id": "moonshot-v1-8k",
        "context_length": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "moonshot-v1-32k": {
        "id": "moonshot-v1-32k",
        "context_length": 32768,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "moonshot-v1-128k": {
        "id": "moonshot-v1-128k",
        "context_length": 131072,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "moonshot-v1-8k-vision-preview": {
        "id": "moonshot-v1-8k-vision-preview",
        "context_length": 8192,
        "max_output_tokens": 4096,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "moonshot-v1-32k-vision-preview": {
        "id": "moonshot-v1-32k-vision-preview",
        "context_length": 32768,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "moonshot-v1-128k-vision-preview": {
        "id": "moonshot-v1-128k-vision-preview",
        "context_length": 131072,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "kimi-latest": {
        "id": "kimi-latest",
        "context_length": 131072,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "kimi-thinking-preview": {
        "id": "kimi-thinking-preview",
        "context_length": 131072,
        "function_call_available": False,
        "response_format_available": False,
        "native_multimodal": True,
    },
    "kimi-k2-0711-preview": {
        "id": "kimi-k2-0711-preview",
        "context_length": 131072,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "kimi-k2-0905-preview": {
        "id": "kimi-k2-0905-preview",
        "context_length": 256000,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "kimi-k2-turbo-preview": {
        "id": "kimi-k2-turbo-preview",
        "context_length": 131072,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
}

# Deepseek models
DEEPSEEK_DEFAULT_MODEL: Final[str] = "deepseek-chat"
DEEPSEEK_MODELS: Final[dict[str, ModelSettingDict]] = {
    "deepseek-chat": {
        "id": "deepseek-chat",
        "context_length": 64000,
        "max_output_tokens": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "deepseek-reasoner": {
        "id": "deepseek-reasoner",
        "context_length": 64000,
        "max_output_tokens": 8192,
        "function_call_available": True,
        "response_format_available": False,
        "native_multimodal": False,
    },
}

# Baichuan models
BAICHUAN_DEFAULT_MODEL: Final[str] = "Baichuan3-Turbo"
BAICHUAN_MODELS: Final[dict[str, ModelSettingDict]] = {
    "Baichuan4": {
        "id": "Baichuan4",
        "context_length": 32768,
        "max_output_tokens": 2048,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "Baichuan3-Turbo": {
        "id": "Baichuan3-Turbo",
        "context_length": 32768,
        "max_output_tokens": 2048,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "Baichuan3-Turbo-128k": {
        "id": "Baichuan3-Turbo-128k",
        "context_length": 128000,
        "max_output_tokens": 2048,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "Baichuan2-Turbo": {
        "id": "Baichuan2-Turbo",
        "context_length": 32768,
        "max_output_tokens": 2048,
        "function_call_available": True,
        "response_format_available": False,
        "native_multimodal": False,
    },
    "Baichuan2-53B": {
        "id": "Baichuan2-53B",
        "context_length": 32768,
        "max_output_tokens": 2048,
        "function_call_available": False,
        "response_format_available": False,
        "native_multimodal": False,
    },
}

# Groq models
GROQ_DEFAULT_MODEL: Final[str] = "llama3-70b-8192"
GROQ_MODELS: Final[dict[str, ModelSettingDict]] = {
    "mixtral-8x7b-32768": {
        "id": "mixtral-8x7b-32768",
        "context_length": 32768,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "llama3-70b-8192": {
        "id": "llama3-70b-8192",
        "context_length": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "llama3-8b-8192": {
        "id": "llama3-8b-8192",
        "context_length": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "gemma-7b-it": {
        "id": "gemma-7b-it",
        "context_length": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "gemma2-9b-it": {
        "id": "gemma2-9b-it",
        "context_length": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "llama3-groq-70b-8192-tool-use-preview": {
        "id": "llama3-groq-70b-8192-tool-use-preview",
        "context_length": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "max_output_tokens": 8000,
        "native_multimodal": False,
    },
    "llama3-groq-8b-8192-tool-use-preview": {
        "id": "llama3-groq-8b-8192-tool-use-preview",
        "context_length": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "max_output_tokens": 8000,
        "native_multimodal": False,
    },
    "llama-3.1-70b-versatile": {
        "id": "llama-3.1-70b-versatile",
        "context_length": 131072,
        "function_call_available": True,
        "response_format_available": True,
        "max_output_tokens": 8000,
        "native_multimodal": False,
    },
    "llama-3.1-8b-instant": {
        "id": "llama-3.1-8b-instant",
        "context_length": 131072,
        "function_call_available": True,
        "response_format_available": True,
        "max_output_tokens": 8000,
        "native_multimodal": False,
    },
}

# Qwen models
QWEN_DEFAULT_MODEL: Final[str] = "qwen2.5-72b-instruct"
QWEN_MODELS: Final[dict[str, ModelSettingDict]] = {
    "qwen2.5-7b-instruct": {
        "id": "qwen2.5-7b-instruct",
        "context_length": 131072,
        "max_output_tokens": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "qwen2.5-14b-instruct": {
        "id": "qwen2.5-14b-instruct",
        "context_length": 131072,
        "max_output_tokens": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "qwen2.5-32b-instruct": {
        "id": "qwen2.5-32b-instruct",
        "context_length": 131072,
        "max_output_tokens": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "qwen2.5-coder-32b-instruct": {
        "id": "qwen2.5-coder-32b-instruct",
        "context_length": 30000,
        "max_output_tokens": 4096,
        "function_call_available": False,
        "response_format_available": False,
        "native_multimodal": False,
    },
    "qwq-32b": {
        "id": "qwq-32b",
        "context_length": 131072,
        "max_output_tokens": 8192,
        "function_call_available": False,
        "response_format_available": False,
        "native_multimodal": False,
    },
    "qwen2.5-72b-instruct": {
        "id": "qwen2.5-72b-instruct",
        "context_length": 131072,
        "max_output_tokens": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "qwen2-vl-72b-instruct": {
        "id": "qwen2-vl-72b-instruct",
        "context_length": 131072,
        "max_output_tokens": 8192,
        "function_call_available": False,
        "response_format_available": False,
        "native_multimodal": True,
    },
    "qwen2.5-vl-72b-instruct": {
        "id": "qwen2.5-vl-72b-instruct",
        "context_length": 131072,
        "max_output_tokens": 8192,
        "function_call_available": False,
        "response_format_available": False,
        "native_multimodal": True,
    },
    "qwen2.5-vl-7b-instruct": {
        "id": "qwen2.5-vl-7b-instruct",
        "context_length": 131072,
        "max_output_tokens": 8192,
        "function_call_available": False,
        "response_format_available": False,
        "native_multimodal": True,
    },
    "qwen2.5-vl-3b-instruct": {
        "id": "qwen2.5-vl-3b-instruct",
        "context_length": 131072,
        "max_output_tokens": 8192,
        "function_call_available": False,
        "response_format_available": False,
        "native_multimodal": True,
    },
    "qwen-max": {
        "id": "qwen-max",
        "context_length": 8096,
        "max_output_tokens": 2048,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "qwen-max-longcontext": {
        "id": "qwen-max-longcontext",
        "context_length": 30000,
        "max_output_tokens": 2048,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "qwen-plus": {
        "id": "qwen-plus",
        "context_length": 131072,
        "max_output_tokens": 8096,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "qwen-turbo": {
        "id": "qwen-turbo",
        "context_length": 8096,
        "max_output_tokens": 1500,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "qvq-max": {
        "id": "qvq-max",
        "context_length": 122880,
        "max_output_tokens": 8192,
        "function_call_available": False,
        "response_format_available": False,
        "native_multimodal": True,
    },
    "qwen3-235b-a22b": {
        "id": "qwen3-235b-a22b",
        "context_length": 131072,
        "max_output_tokens": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "qwen3-32b": {
        "id": "qwen3-32b",
        "context_length": 131072,
        "max_output_tokens": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "qwen3-30b-a3b": {
        "id": "qwen3-30b-a3b",
        "context_length": 131072,
        "max_output_tokens": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "qwen3-14b": {
        "id": "qwen3-14b",
        "context_length": 131072,
        "max_output_tokens": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "qwen3-8b": {
        "id": "qwen3-8b",
        "context_length": 131072,
        "max_output_tokens": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "qwen3-4b": {
        "id": "qwen3-4b",
        "context_length": 131072,
        "max_output_tokens": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "qwen3-1.7b": {
        "id": "qwen3-1.7b",
        "context_length": 32768,
        "max_output_tokens": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "qwen3-0.6b": {
        "id": "qwen3-0.6b",
        "context_length": 32768,
        "max_output_tokens": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "qwen3-235b-a22b-instruct-2507": {
        "id": "qwen3-235b-a22b-instruct-2507",
        "context_length": 131072,
        "max_output_tokens": 32768,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "qwen3-235b-a22b-thinking-2507": {
        "id": "qwen3-235b-a22b-thinking-2507",
        "context_length": 131072,
        "max_output_tokens": 32768,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "qwen3-coder-480b-a35b-instruct": {
        "id": "qwen3-coder-480b-a35b-instruct",
        "context_length": 262144,
        "max_output_tokens": 65536,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "qwen3-next-80b-a3b-thinking": {
        "id": "qwen3-next-80b-a3b-thinking",
        "context_length": 159744,
        "max_output_tokens": 32768,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "qwen3-next-80b-a3b-instruct": {
        "id": "qwen3-next-80b-a3b-instruct",
        "context_length": 159744,
        "max_output_tokens": 32768,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "qwen3-max-preview": {
        "id": "qwen3-max-preview",
        "context_length": 262144,
        "max_output_tokens": 32768,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "qwen3-max": {
        "id": "qwen3-max",
        "context_length": 262144,
        "max_output_tokens": 32768,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "qwen3-vl-plus": {
        "id": "qwen3-vl-plus",
        "context_length": 262144,
        "max_output_tokens": 32768,
        "function_call_available": True,
        "response_format_available": False,
        "native_multimodal": True,
    },
    "qwen3-coder-plus": {
        "id": "qwen3-coder-plus",
        "context_length": 1000000,
        "max_output_tokens": 65536,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "qwen3-coder-flash": {
        "id": "qwen3-coder-flash",
        "context_length": 1000000,
        "max_output_tokens": 65536,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "qwen3-vl-235b-a22b-thinking": {
        "id": "qwen3-vl-235b-a22b-thinking",
        "context_length": 131072,
        "max_output_tokens": 32768,
        "function_call_available": True,
        "response_format_available": False,
        "native_multimodal": True,
    },
    "qwen3-vl-235b-a22b-instruct": {
        "id": "qwen3-vl-235b-a22b-instruct",
        "context_length": 131072,
        "max_output_tokens": 32768,
        "function_call_available": True,
        "response_format_available": False,
        "native_multimodal": True,
    },
    "qwen3-vl-30b-a3b-thinking": {
        "id": "qwen3-vl-30b-a3b-thinking",
        "context_length": 131072,
        "max_output_tokens": 32768,
        "function_call_available": True,
        "response_format_available": False,
        "native_multimodal": True,
    },
    "qwen3-vl-30b-a3b-instruct": {
        "id": "qwen3-vl-30b-a3b-instruct",
        "context_length": 131072,
        "max_output_tokens": 32768,
        "function_call_available": True,
        "response_format_available": False,
        "native_multimodal": True,
    },
    "qwen3-vl-8b-thinking": {
        "id": "qwen3-vl-8b-thinking",
        "context_length": 131072,
        "max_output_tokens": 32768,
        "function_call_available": True,
        "response_format_available": False,
        "native_multimodal": True,
    },
    "qwen3-vl-8b-instruct": {
        "id": "qwen3-vl-8b-instruct",
        "context_length": 131072,
        "max_output_tokens": 32768,
        "function_call_available": True,
        "response_format_available": False,
        "native_multimodal": True,
    },
    "qwen3-vl-flash": {
        "id": "qwen3-vl-flash",
        "context_length": 262144,
        "max_output_tokens": 32768,
        "function_call_available": True,
        "response_format_available": False,
        "native_multimodal": True,
    },
}

# Yi models
YI_DEFAULT_MODEL: Final[str] = "yi-lightning"
YI_MODELS: Final[dict[str, ModelSettingDict]] = {
    "yi-lightning": {
        "id": "yi-lightning",
        "context_length": 16000,
        "max_output_tokens": 4096,
        "function_call_available": False,
        "response_format_available": False,
        "native_multimodal": False,
    },
    "yi-vision-v2": {
        "id": "yi-vision-v2",
        "context_length": 16000,
        "max_output_tokens": 2000,
        "function_call_available": False,
        "response_format_available": False,
        "native_multimodal": True,
    },
}

# ZhiPuAI models
ZHIPUAI_DEFAULT_MODEL: Final[str] = "glm-4-air"
ZHIPUAI_MODELS: Final[dict[str, ModelSettingDict]] = {
    "glm-3-turbo": {
        "id": "glm-3-turbo",
        "context_length": 128000,
        "function_call_available": True,
        "response_format_available": False,
        "max_output_tokens": 4095,
        "native_multimodal": False,
    },
    "glm-4": {
        "id": "glm-4",
        "context_length": 128000,
        "function_call_available": True,
        "response_format_available": False,
        "max_output_tokens": 4095,
        "native_multimodal": False,
    },
    "glm-4-plus": {
        "id": "glm-4-plus",
        "context_length": 128000,
        "function_call_available": True,
        "response_format_available": False,
        "max_output_tokens": 4095,
        "native_multimodal": False,
    },
    "glm-4-0520": {
        "id": "glm-4-0520",
        "context_length": 128000,
        "function_call_available": True,
        "response_format_available": False,
        "max_output_tokens": 4095,
        "native_multimodal": False,
    },
    "glm-4-air": {
        "id": "glm-4-air",
        "context_length": 128000,
        "function_call_available": True,
        "response_format_available": False,
        "max_output_tokens": 4095,
        "native_multimodal": False,
    },
    "glm-4-airx": {
        "id": "glm-4-airx",
        "context_length": 128000,
        "function_call_available": True,
        "response_format_available": False,
        "max_output_tokens": 4095,
        "native_multimodal": False,
    },
    "glm-4-flash": {
        "id": "glm-4-flash",
        "context_length": 128000,
        "function_call_available": True,
        "response_format_available": False,
        "max_output_tokens": 4095,
        "native_multimodal": False,
    },
    "glm-4-long": {
        "id": "glm-4-long",
        "context_length": 1000000,
        "function_call_available": True,
        "response_format_available": False,
        "max_output_tokens": 4095,
        "native_multimodal": False,
    },
    "glm-4v": {
        "id": "glm-4v",
        "context_length": 2000,
        "function_call_available": False,
        "response_format_available": False,
        "max_output_tokens": 1024,
        "native_multimodal": True,
    },
    "glm-4v-plus": {
        "id": "glm-4v-plus",
        "context_length": 2000,
        "function_call_available": False,
        "response_format_available": False,
        "max_output_tokens": 1024,
        "native_multimodal": True,
    },
    "glm-4v-flash": {
        "id": "glm-4v-flash",
        "context_length": 2000,
        "function_call_available": False,
        "response_format_available": False,
        "max_output_tokens": 1024,
        "native_multimodal": True,
    },
    "glm-zero-preview": {
        "id": "glm-zero-preview",
        "context_length": 16000,
        "function_call_available": False,
        "response_format_available": False,
        "max_output_tokens": 12000,
        "native_multimodal": False,
    },
    "glm-4-alltools": {
        "id": "glm-4-alltools",
        "context_length": 128000,
        "function_call_available": False,
        "response_format_available": False,
        "max_output_tokens": 20480,
        "native_multimodal": False,
    },
    "glm-z1-air": {
        "id": "glm-z1-air",
        "context_length": 32000,
        "function_call_available": False,
        "response_format_available": False,
        "max_output_tokens": 32000,
        "native_multimodal": False,
    },
    "glm-z1-airx": {
        "id": "glm-z1-airx",
        "context_length": 32000,
        "function_call_available": False,
        "response_format_available": False,
        "max_output_tokens": 30000,
        "native_multimodal": False,
    },
    "glm-z1-flash": {
        "id": "glm-z1-flash",
        "context_length": 32000,
        "function_call_available": False,
        "response_format_available": False,
        "max_output_tokens": 32000,
        "native_multimodal": False,
    },
    "glm-4.1v-thinking-flashx": {
        "id": "glm-4.1v-thinking-flashx",
        "context_length": 64000,
        "function_call_available": False,
        "response_format_available": False,
        "max_output_tokens": 16384,
        "native_multimodal": True,
    },
    "glm-4.1v-thinking-flash": {
        "id": "glm-4.1v-thinking-flash",
        "context_length": 64000,
        "function_call_available": False,
        "response_format_available": False,
        "max_output_tokens": 16384,
        "native_multimodal": True,
    },
    "glm-4.5": {
        "id": "glm-4.5",
        "context_length": 128000,
        "function_call_available": True,
        "response_format_available": True,
        "max_output_tokens": 96000,
        "native_multimodal": False,
    },
    "glm-4.5-x": {
        "id": "glm-4.5-x",
        "context_length": 128000,
        "function_call_available": True,
        "response_format_available": True,
        "max_output_tokens": 96000,
        "native_multimodal": False,
    },
    "glm-4.5-air": {
        "id": "glm-4.5-air",
        "context_length": 128000,
        "function_call_available": True,
        "response_format_available": True,
        "max_output_tokens": 96000,
        "native_multimodal": False,
    },
    "glm-4.5-airx": {
        "id": "glm-4.5-airx",
        "context_length": 128000,
        "function_call_available": True,
        "response_format_available": True,
        "max_output_tokens": 96000,
        "native_multimodal": False,
    },
    "glm-4.5-flash": {
        "id": "glm-4.5-flash",
        "context_length": 128000,
        "function_call_available": True,
        "response_format_available": True,
        "max_output_tokens": 96000,
        "native_multimodal": False,
    },
    "glm-4.5v": {
        "id": "glm-4.5v",
        "context_length": 64000,
        "function_call_available": True,
        "response_format_available": True,
        "max_output_tokens": 16384,
        "native_multimodal": True,
    },
    "glm-4.6": {
        "id": "glm-4.6",
        "context_length": 200000,
        "function_call_available": True,
        "response_format_available": True,
        "max_output_tokens": 128000,
        "native_multimodal": False,
    },
}

# Mistral models
MISTRAL_DEFAULT_MODEL: Final[str] = "mistral-small"
MISTRAL_MODELS: Final[dict[str, ModelSettingDict]] = {
    "open-mistral-7b": {
        "id": "open-mistral-7b",
        "context_length": 32000,
        "function_call_available": False,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "open-mixtral-8x7b": {
        "id": "open-mixtral-8x7b",
        "context_length": 32000,
        "function_call_available": False,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "open-mixtral-8x22b": {
        "id": "open-mixtral-8x22b",
        "context_length": 64000,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "open-mistral-nemo": {
        "id": "open-mistral-nemo",
        "context_length": 128000,
        "function_call_available": False,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "codestral-latest": {
        "id": "codestral-latest",
        "context_length": 32000,
        "function_call_available": False,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "mistral-small-latest": {
        "id": "mistral-small-latest",
        "context_length": 30000,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "mistral-medium-latest": {
        "id": "mistral-medium-latest",
        "context_length": 30000,
        "function_call_available": False,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "mistral-large-latest": {
        "id": "mistral-large-latest",
        "context_length": 128000,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
}

# OpenAI models
OPENAI_DEFAULT_MODEL: Final[str] = "gpt-4o"
OPENAI_MODELS: Final[dict[str, ModelSettingDict]] = {
    "gpt-35-turbo": {
        "id": "gpt-35-turbo",
        "context_length": 16385,
        "function_call_available": True,
        "response_format_available": True,
        "max_output_tokens": 4096,
        "native_multimodal": False,
    },
    "gpt-4-turbo": {
        "id": "gpt-4-turbo",
        "context_length": 128000,
        "max_output_tokens": 4096,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "gpt-4": {
        "id": "gpt-4",
        "context_length": 8192,
        "max_output_tokens": 4096,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "gpt-4o": {
        "id": "gpt-4o",
        "context_length": 128000,
        "max_output_tokens": 4096,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gpt-4o-mini": {
        "id": "gpt-4o-mini",
        "context_length": 128000,
        "max_output_tokens": 16384,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gpt-4v": {
        "id": "gpt-4v",
        "context_length": 128000,
        "max_output_tokens": 4096,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "o1-mini": {
        "id": "o1-mini",
        "context_length": 128000,
        "max_output_tokens": 65536,
        "function_call_available": False,
        "response_format_available": False,
        "native_multimodal": False,
    },
    "o1-preview": {
        "id": "o1-preview",
        "context_length": 128000,
        "max_output_tokens": 32768,
        "function_call_available": False,
        "response_format_available": False,
        "native_multimodal": False,
    },
    "o3": {
        "id": "o3",
        "context_length": 200000,
        "max_output_tokens": 100000,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "o3-mini": {
        "id": "o3-mini",
        "context_length": 200000,
        "max_output_tokens": 100000,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "o4-mini": {
        "id": "o4-mini",
        "context_length": 200000,
        "max_output_tokens": 100000,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gpt-4.1": {
        "id": "gpt-4.1",
        "context_length": 1047576,
        "max_output_tokens": 32768,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gpt-4.1-mini": {
        "id": "gpt-4.1-mini",
        "context_length": 1047576,
        "max_output_tokens": 32768,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gpt-4.1-nano": {
        "id": "gpt-4.1-nano",
        "context_length": 1047576,
        "max_output_tokens": 32768,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gpt-5": {
        "id": "gpt-5",
        "context_length": 400000,
        "max_output_tokens": 128000,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gpt-5-mini": {
        "id": "gpt-5-mini",
        "context_length": 400000,
        "max_output_tokens": 128000,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gpt-5-nano": {
        "id": "gpt-5-nano",
        "context_length": 400000,
        "max_output_tokens": 128000,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gpt-5-chat-latest": {
        "id": "gpt-5-chat-latest",
        "context_length": 400000,
        "max_output_tokens": 128000,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gpt-5-codex": {
        "id": "gpt-5-codex",
        "context_length": 400000,
        "max_output_tokens": 128000,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gpt-5-pro": {
        "id": "gpt-5-pro",
        "context_length": 400000,
        "max_output_tokens": 272000,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
}

# Anthropic models
ANTHROPIC_DEFAULT_MODEL: Final[str] = "claude-3-7-sonnet-20250219"
ANTHROPIC_MODELS: Final[dict[str, ModelSettingDict]] = {
    "claude-3-opus-20240229": {
        "id": "claude-3-opus-20240229",
        "context_length": 200000,
        "max_output_tokens": 4096,
        "function_call_available": True,
        "response_format_available": False,
        "native_multimodal": True,
    },
    "claude-3-sonnet-20240229": {
        "id": "claude-3-sonnet-20240229",
        "context_length": 200000,
        "max_output_tokens": 4096,
        "function_call_available": True,
        "native_multimodal": True,
        "response_format_available": False,
    },
    "claude-3-haiku-20240307": {
        "id": "claude-3-haiku-20240307",
        "context_length": 200000,
        "max_output_tokens": 4096,
        "function_call_available": True,
        "response_format_available": False,
        "native_multimodal": True,
    },
    "claude-3-5-haiku-20241022": {
        "id": "claude-3-5-haiku-20241022",
        "context_length": 200000,
        "max_output_tokens": 8192,
        "function_call_available": True,
        "response_format_available": False,
        "native_multimodal": False,
    },
    "claude-3-5-sonnet-20240620": {
        "id": "claude-3-5-sonnet-20240620",
        "context_length": 200000,
        "max_output_tokens": 8192,
        "function_call_available": True,
        "response_format_available": False,
        "native_multimodal": True,
    },
    "claude-3-5-sonnet-20241022": {
        "id": "claude-3-5-sonnet-20241022",
        "context_length": 200000,
        "max_output_tokens": 8192,
        "function_call_available": True,
        "response_format_available": False,
        "native_multimodal": True,
    },
    "claude-3-7-sonnet-20250219": {
        "id": "claude-3-7-sonnet-20250219",
        "context_length": 200000,
        "max_output_tokens": 64000,
        "function_call_available": True,
        "response_format_available": False,
        "native_multimodal": True,
    },
    "claude-sonnet-4-20250514": {
        "id": "claude-sonnet-4-20250514",
        "context_length": 200000,
        "max_output_tokens": 64000,
        "function_call_available": True,
        "response_format_available": False,
        "native_multimodal": True,
    },
    "claude-opus-4-20250514": {
        "id": "claude-opus-4-20250514",
        "context_length": 200000,
        "max_output_tokens": 32000,
        "function_call_available": True,
        "response_format_available": False,
        "native_multimodal": True,
    },
    "claude-opus-4-1-20250805": {
        "id": "claude-opus-4-1-20250805",
        "context_length": 200000,
        "max_output_tokens": 32000,
        "function_call_available": True,
        "response_format_available": False,
        "native_multimodal": True,
    },
    "claude-sonnet-4-5-20250929": {
        "id": "claude-sonnet-4-5-20250929",
        "context_length": 200000,
        "max_output_tokens": 64000,
        "function_call_available": True,
        "response_format_available": False,
        "native_multimodal": True,
    },
    "claude-haiku-4-5-20251001": {
        "id": "claude-haiku-4-5-20251001",
        "context_length": 200000,
        "max_output_tokens": 64000,
        "function_call_available": True,
        "response_format_available": False,
        "native_multimodal": True,
    },
}

# Minimax models
MINIMAX_DEFAULT_MODEL: Final[str] = "MiniMax-Text-01"
MINIMAX_MODELS: Final[dict[str, ModelSettingDict]] = {
    "abab5-chat": {
        "id": "abab5-chat",
        "context_length": 6144,
        "max_output_tokens": 6144,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "abab5.5-chat": {
        "id": "abab5.5-chat",
        "context_length": 16384,
        "max_output_tokens": 16384,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "abab6-chat": {
        "id": "abab6-chat",
        "context_length": 32768,
        "max_output_tokens": 32768,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "abab6.5s-chat": {
        "id": "abab6.5s-chat",
        "context_length": 245760,
        "max_output_tokens": 245760,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "abab7-preview": {
        "id": "abab7-preview",
        "context_length": 245760,
        "max_output_tokens": 245760,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "MiniMax-Text-01": {
        "id": "MiniMax-Text-01",
        "context_length": 1000192,
        "max_output_tokens": 40000,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "MiniMax-M1": {
        "id": "MiniMax-M1",
        "context_length": 1000192,
        "max_output_tokens": 40000,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
}

# Gemini models
GEMINI_DEFAULT_MODEL: Final[str] = "gemini-2.0-flash"
GEMINI_MODELS: Final[dict[str, ModelSettingDict]] = {
    "gemini-1.5-pro": {
        "id": "gemini-1.5-pro",
        "context_length": 2097152,
        "max_output_tokens": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gemini-2.0-pro-exp-02-05": {
        "id": "gemini-2.0-pro-exp-02-05",
        "context_length": 2097152,
        "max_output_tokens": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gemini-1.5-flash": {
        "id": "gemini-1.5-flash",
        "context_length": 1048576,
        "max_output_tokens": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gemini-2.0-flash": {
        "id": "gemini-2.0-flash",
        "context_length": 1048576,
        "max_output_tokens": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gemini-2.0-flash-lite-preview-02-05": {
        "id": "gemini-2.0-flash-lite-preview-02-05",
        "context_length": 1048576,
        "max_output_tokens": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gemini-2.0-flash-exp": {
        "id": "gemini-2.0-flash-exp",
        "context_length": 1048576,
        "max_output_tokens": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gemini-2.0-flash-thinking-exp-1219": {
        "id": "gemini-2.0-flash-thinking-exp-1219",
        "context_length": 32767,
        "max_output_tokens": 8192,
        "function_call_available": False,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "gemini-2.0-flash-thinking-exp-01-21": {
        "id": "gemini-2.0-flash-thinking-exp-01-21",
        "context_length": 1048576,
        "max_output_tokens": 8192,
        "function_call_available": False,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "gemini-exp-1206": {
        "id": "gemini-exp-1206",
        "context_length": 2097152,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gemini-1.5-flash-8b": {
        "id": "gemini-1.5-flash-8b",
        "context_length": 1048576,
        "max_output_tokens": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gemini-2.5-pro-exp-03-25": {
        "id": "gemini-2.5-pro-exp-03-25",
        "context_length": 1048576,
        "max_output_tokens": 65536,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gemini-2.5-pro-preview-03-25": {
        "id": "gemini-2.5-pro-preview-03-25",
        "context_length": 1048576,
        "max_output_tokens": 65536,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gemini-2.5-flash-preview-04-17": {
        "id": "gemini-2.5-flash-preview-04-17",
        "context_length": 1048576,
        "max_output_tokens": 65536,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gemini-2.5-flash-preview-05-20": {
        "id": "gemini-2.5-flash-preview-05-20",
        "context_length": 1048576,
        "max_output_tokens": 65536,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gemini-2.5-pro-preview-05-06": {
        "id": "gemini-2.5-pro-preview-05-06",
        "context_length": 1048576,
        "max_output_tokens": 65536,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gemini-2.5-pro-preview-06-05": {
        "id": "gemini-2.5-pro-preview-06-05",
        "context_length": 1048576,
        "max_output_tokens": 65536,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gemini-2.5-pro": {
        "id": "gemini-2.5-pro",
        "context_length": 1048576,
        "max_output_tokens": 65536,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gemini-2.5-flash": {
        "id": "gemini-2.5-flash",
        "context_length": 1048576,
        "max_output_tokens": 65536,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "gemini-2.5-flash-lite": {
        "id": "gemini-2.5-flash-lite",
        "context_length": 1048576,
        "max_output_tokens": 65536,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
}

# 百度文心一言 ERNIE 模型
ERNIE_DEFAULT_MODEL: Final[str] = "ernie-lite"
ERNIE_MODELS: Final[dict[str, ModelSettingDict]] = {
    "ernie-lite": {
        "id": "ernie-lite",
        "context_length": 6144,
        "max_output_tokens": 2048,
        "function_call_available": False,
        "response_format_available": False,
        "native_multimodal": False,
    },
    "ernie-speed": {
        "id": "ernie-speed",
        "context_length": 126976,
        "max_output_tokens": 4096,
        "function_call_available": False,
        "response_format_available": False,
        "native_multimodal": False,
    },
    "ernie-speed-pro-128k": {
        "id": "ernie-speed-pro-128k",
        "context_length": 126976,
        "max_output_tokens": 4096,
        "function_call_available": False,
        "response_format_available": False,
        "native_multimodal": False,
    },
    "ernie-3.5-8k": {
        "id": "ernie-3.5-8k",
        "context_length": 5120,
        "max_output_tokens": 2048,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "ernie-3.5-128k": {
        "id": "ernie-3.5-128k",
        "context_length": 126976,
        "max_output_tokens": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "ernie-4.0-8k-latest": {
        "id": "ernie-4.0-8k-latest",
        "context_length": 5120,
        "max_output_tokens": 2048,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "ernie-4.0-8k": {
        "id": "ernie-4.0-8k",
        "context_length": 5120,
        "max_output_tokens": 2048,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "ernie-4.0-turbo-8k": {
        "id": "ernie-4.0-turbo-8k",
        "context_length": 5120,
        "max_output_tokens": 2048,
        "function_call_available": False,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "ernie-4.5-8k-preview": {
        "id": "ernie-4.5-8k-preview",
        "context_length": 5120,
        "max_output_tokens": 2048,
        "function_call_available": False,
        "response_format_available": True,
        "native_multimodal": False,
    },
}


STEPFUN_DEFAULT_MODEL: Final[str] = "step-1-8k"
STEPFUN_MODELS: Final[dict[str, ModelSettingDict]] = {
    "step-1-8k": {
        "id": "step-1-8k",
        "context_length": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "step-1-32k": {
        "id": "step-1-32k",
        "context_length": 32000,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "step-1-128k": {
        "id": "step-1-128k",
        "context_length": 128000,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "step-1-256k": {
        "id": "step-1-256k",
        "context_length": 256000,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "step-2-16k": {
        "id": "step-2-16k",
        "context_length": 16384,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "step-1-flash": {
        "id": "step-1-flash",
        "context_length": 8192,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "step-1v-8k": {
        "id": "step-1v-8k",
        "context_length": 8192,
        "function_call_available": False,
        "response_format_available": False,
        "native_multimodal": True,
    },
    "step-1v-32k": {
        "id": "step-1v-32k",
        "context_length": 32768,
        "function_call_available": False,
        "response_format_available": False,
        "native_multimodal": True,
    },
}


XAI_DEFAULT_MODEL: Final[str] = "grok-2-latest"
XAI_MODELS: Final[dict[str, ModelSettingDict]] = {
    "grok-beta": {
        "id": "grok-beta",
        "context_length": 131072,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "grok-2-latest": {
        "id": "grok-2-latest",
        "context_length": 131072,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "grok-2-vision-latest": {
        "id": "grok-2-vision-latest",
        "context_length": 32768,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": True,
    },
    "grok-3-beta": {
        "id": "grok-beta",
        "context_length": 131072,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "grok-3-fast-beta": {
        "id": "grok-beta",
        "context_length": 131072,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "grok-3-mini-beta": {
        "id": "grok-beta",
        "context_length": 131072,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "grok-3-mini-fast-beta": {
        "id": "grok-beta",
        "context_length": 131072,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
    "grok-4": {
        "id": "grok-4",
        "context_length": 256000,
        "function_call_available": True,
        "response_format_available": True,
        "native_multimodal": False,
    },
}
