# Domain Vision Statement

The model will represent the status and nature of studies involving biosamples 
in such a way that automated routing for computational analysis can be supported. 

Biosamples are acquired from an environment;
they are prepared for analysis using protocols;
they are subject to analysis by instruments that output raw data;
and they can be associated thematically with one or more studies.

A study, conducted by a research team to answer research questions, collects
(a) a set of biosamples, associated instrument-obtained ("raw") data,
and/or associated computation-obtained ("derived") data; and
(b) performs additional analysis activities in order to answer research questions.

The model represents classes of operational activities for (1) environmental sampling,
(2) biosample preparation for instrument analysis,
(3) instrument-analysis runs, and
(4) computational-analysis workflow executions.

The model represents metadata for biosamples, studies, and their associated operational activities
in such a way that researcher teams can leverage existing data in order to more easily answer research questions
with minimal duplication of effort, by either obtaining answers from the data of existing studies, or by designing
new studies that maximally leverage existing data.

## About

A <span class="term">Domain Vision Statement</span>[^1] is a short description (about one page)
of the <span class="term">core domain</span> and the value it will bring, the "value proposition."
Ignore those aspects that do not distinguish this domain model from others.
Show how the domain model serves and balances diverse interests.
Keep it narrow.
Write this statement early and revise it as you gain new insight.

It should be usable directly by the management and technical staff during all phases of development
to guide resource allocation, to guide modeling choices, and to educate team members.

## References

[^1]: [Domain Vision Statement](https://files.polyneme.xyz/domain-vision-statement-1696514386.pdf), pp415-6, in Evans, Eric. Domain-Driven Design: Tackling Complexity in the Heart of Software. Boston: Addison-Wesley, 2004.
