# coding: utf-8

"""
    authentik

    Making authentication simple.

    The version of the OpenAPI document: 2025.10.0-rc1
    Contact: hello@goauthentik.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt
from typing import Any, ClassVar, Dict, List
from authentik_client.models.capabilities_enum import CapabilitiesEnum
from authentik_client.models.error_reporting_config import ErrorReportingConfig
from typing import Optional, Set
from typing_extensions import Self

class Config(BaseModel):
    """
    Serialize authentik Config into DRF Object
    """ # noqa: E501
    error_reporting: ErrorReportingConfig
    capabilities: List[CapabilitiesEnum]
    cache_timeout: StrictInt
    cache_timeout_flows: StrictInt
    cache_timeout_policies: StrictInt
    cache_timeout_reputation: StrictInt
    __properties: ClassVar[List[str]] = ["error_reporting", "capabilities", "cache_timeout", "cache_timeout_flows", "cache_timeout_policies", "cache_timeout_reputation"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Config from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of error_reporting
        if self.error_reporting:
            _dict['error_reporting'] = self.error_reporting.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Config from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "error_reporting": ErrorReportingConfig.from_dict(obj["error_reporting"]) if obj.get("error_reporting") is not None else None,
            "capabilities": obj.get("capabilities"),
            "cache_timeout": obj.get("cache_timeout"),
            "cache_timeout_flows": obj.get("cache_timeout_flows"),
            "cache_timeout_policies": obj.get("cache_timeout_policies"),
            "cache_timeout_reputation": obj.get("cache_timeout_reputation")
        })
        return _obj


