# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AccountFeaturesArgs', 'AccountFeatures']

@pulumi.input_type
class AccountFeaturesArgs:
    def __init__(__self__, *,
                 advanced_ci: Optional[pulumi.Input[_builtins.bool]] = None,
                 ai_features: Optional[pulumi.Input[_builtins.bool]] = None,
                 partial_parsing: Optional[pulumi.Input[_builtins.bool]] = None,
                 repo_caching: Optional[pulumi.Input[_builtins.bool]] = None,
                 warehouse_cost_visibility: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a AccountFeatures resource.
        :param pulumi.Input[_builtins.bool] advanced_ci: Whether advanced CI is enabled.
        :param pulumi.Input[_builtins.bool] ai_features: Whether AI features are enabled.
        :param pulumi.Input[_builtins.bool] partial_parsing: Whether partial parsing is enabled.
        :param pulumi.Input[_builtins.bool] repo_caching: Whether repository caching is enabled.
        :param pulumi.Input[_builtins.bool] warehouse_cost_visibility: Whether warehouse cost visibility is enabled.
        """
        if advanced_ci is not None:
            pulumi.set(__self__, "advanced_ci", advanced_ci)
        if ai_features is not None:
            pulumi.set(__self__, "ai_features", ai_features)
        if partial_parsing is not None:
            pulumi.set(__self__, "partial_parsing", partial_parsing)
        if repo_caching is not None:
            pulumi.set(__self__, "repo_caching", repo_caching)
        if warehouse_cost_visibility is not None:
            pulumi.set(__self__, "warehouse_cost_visibility", warehouse_cost_visibility)

    @_builtins.property
    @pulumi.getter(name="advancedCi")
    def advanced_ci(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether advanced CI is enabled.
        """
        return pulumi.get(self, "advanced_ci")

    @advanced_ci.setter
    def advanced_ci(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "advanced_ci", value)

    @_builtins.property
    @pulumi.getter(name="aiFeatures")
    def ai_features(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether AI features are enabled.
        """
        return pulumi.get(self, "ai_features")

    @ai_features.setter
    def ai_features(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ai_features", value)

    @_builtins.property
    @pulumi.getter(name="partialParsing")
    def partial_parsing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether partial parsing is enabled.
        """
        return pulumi.get(self, "partial_parsing")

    @partial_parsing.setter
    def partial_parsing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "partial_parsing", value)

    @_builtins.property
    @pulumi.getter(name="repoCaching")
    def repo_caching(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether repository caching is enabled.
        """
        return pulumi.get(self, "repo_caching")

    @repo_caching.setter
    def repo_caching(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "repo_caching", value)

    @_builtins.property
    @pulumi.getter(name="warehouseCostVisibility")
    def warehouse_cost_visibility(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether warehouse cost visibility is enabled.
        """
        return pulumi.get(self, "warehouse_cost_visibility")

    @warehouse_cost_visibility.setter
    def warehouse_cost_visibility(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "warehouse_cost_visibility", value)


@pulumi.input_type
class _AccountFeaturesState:
    def __init__(__self__, *,
                 advanced_ci: Optional[pulumi.Input[_builtins.bool]] = None,
                 ai_features: Optional[pulumi.Input[_builtins.bool]] = None,
                 partial_parsing: Optional[pulumi.Input[_builtins.bool]] = None,
                 repo_caching: Optional[pulumi.Input[_builtins.bool]] = None,
                 warehouse_cost_visibility: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering AccountFeatures resources.
        :param pulumi.Input[_builtins.bool] advanced_ci: Whether advanced CI is enabled.
        :param pulumi.Input[_builtins.bool] ai_features: Whether AI features are enabled.
        :param pulumi.Input[_builtins.bool] partial_parsing: Whether partial parsing is enabled.
        :param pulumi.Input[_builtins.bool] repo_caching: Whether repository caching is enabled.
        :param pulumi.Input[_builtins.bool] warehouse_cost_visibility: Whether warehouse cost visibility is enabled.
        """
        if advanced_ci is not None:
            pulumi.set(__self__, "advanced_ci", advanced_ci)
        if ai_features is not None:
            pulumi.set(__self__, "ai_features", ai_features)
        if partial_parsing is not None:
            pulumi.set(__self__, "partial_parsing", partial_parsing)
        if repo_caching is not None:
            pulumi.set(__self__, "repo_caching", repo_caching)
        if warehouse_cost_visibility is not None:
            pulumi.set(__self__, "warehouse_cost_visibility", warehouse_cost_visibility)

    @_builtins.property
    @pulumi.getter(name="advancedCi")
    def advanced_ci(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether advanced CI is enabled.
        """
        return pulumi.get(self, "advanced_ci")

    @advanced_ci.setter
    def advanced_ci(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "advanced_ci", value)

    @_builtins.property
    @pulumi.getter(name="aiFeatures")
    def ai_features(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether AI features are enabled.
        """
        return pulumi.get(self, "ai_features")

    @ai_features.setter
    def ai_features(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ai_features", value)

    @_builtins.property
    @pulumi.getter(name="partialParsing")
    def partial_parsing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether partial parsing is enabled.
        """
        return pulumi.get(self, "partial_parsing")

    @partial_parsing.setter
    def partial_parsing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "partial_parsing", value)

    @_builtins.property
    @pulumi.getter(name="repoCaching")
    def repo_caching(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether repository caching is enabled.
        """
        return pulumi.get(self, "repo_caching")

    @repo_caching.setter
    def repo_caching(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "repo_caching", value)

    @_builtins.property
    @pulumi.getter(name="warehouseCostVisibility")
    def warehouse_cost_visibility(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether warehouse cost visibility is enabled.
        """
        return pulumi.get(self, "warehouse_cost_visibility")

    @warehouse_cost_visibility.setter
    def warehouse_cost_visibility(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "warehouse_cost_visibility", value)


@pulumi.type_token("dbtcloud:index/accountFeatures:AccountFeatures")
class AccountFeatures(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_ci: Optional[pulumi.Input[_builtins.bool]] = None,
                 ai_features: Optional[pulumi.Input[_builtins.bool]] = None,
                 partial_parsing: Optional[pulumi.Input[_builtins.bool]] = None,
                 repo_caching: Optional[pulumi.Input[_builtins.bool]] = None,
                 warehouse_cost_visibility: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages dbt Cloud global features at the account level, like Advanced CI. The same feature should not be configured in different resources to avoid conflicts.

        When destroying the resource or removing the value for an attribute, the features status will not be changed. Deactivating features will require applying them wih the value set to `false`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] advanced_ci: Whether advanced CI is enabled.
        :param pulumi.Input[_builtins.bool] ai_features: Whether AI features are enabled.
        :param pulumi.Input[_builtins.bool] partial_parsing: Whether partial parsing is enabled.
        :param pulumi.Input[_builtins.bool] repo_caching: Whether repository caching is enabled.
        :param pulumi.Input[_builtins.bool] warehouse_cost_visibility: Whether warehouse cost visibility is enabled.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AccountFeaturesArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages dbt Cloud global features at the account level, like Advanced CI. The same feature should not be configured in different resources to avoid conflicts.

        When destroying the resource or removing the value for an attribute, the features status will not be changed. Deactivating features will require applying them wih the value set to `false`.

        :param str resource_name: The name of the resource.
        :param AccountFeaturesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountFeaturesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_ci: Optional[pulumi.Input[_builtins.bool]] = None,
                 ai_features: Optional[pulumi.Input[_builtins.bool]] = None,
                 partial_parsing: Optional[pulumi.Input[_builtins.bool]] = None,
                 repo_caching: Optional[pulumi.Input[_builtins.bool]] = None,
                 warehouse_cost_visibility: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountFeaturesArgs.__new__(AccountFeaturesArgs)

            __props__.__dict__["advanced_ci"] = advanced_ci
            __props__.__dict__["ai_features"] = ai_features
            __props__.__dict__["partial_parsing"] = partial_parsing
            __props__.__dict__["repo_caching"] = repo_caching
            __props__.__dict__["warehouse_cost_visibility"] = warehouse_cost_visibility
        super(AccountFeatures, __self__).__init__(
            'dbtcloud:index/accountFeatures:AccountFeatures',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advanced_ci: Optional[pulumi.Input[_builtins.bool]] = None,
            ai_features: Optional[pulumi.Input[_builtins.bool]] = None,
            partial_parsing: Optional[pulumi.Input[_builtins.bool]] = None,
            repo_caching: Optional[pulumi.Input[_builtins.bool]] = None,
            warehouse_cost_visibility: Optional[pulumi.Input[_builtins.bool]] = None) -> 'AccountFeatures':
        """
        Get an existing AccountFeatures resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] advanced_ci: Whether advanced CI is enabled.
        :param pulumi.Input[_builtins.bool] ai_features: Whether AI features are enabled.
        :param pulumi.Input[_builtins.bool] partial_parsing: Whether partial parsing is enabled.
        :param pulumi.Input[_builtins.bool] repo_caching: Whether repository caching is enabled.
        :param pulumi.Input[_builtins.bool] warehouse_cost_visibility: Whether warehouse cost visibility is enabled.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountFeaturesState.__new__(_AccountFeaturesState)

        __props__.__dict__["advanced_ci"] = advanced_ci
        __props__.__dict__["ai_features"] = ai_features
        __props__.__dict__["partial_parsing"] = partial_parsing
        __props__.__dict__["repo_caching"] = repo_caching
        __props__.__dict__["warehouse_cost_visibility"] = warehouse_cost_visibility
        return AccountFeatures(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="advancedCi")
    def advanced_ci(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether advanced CI is enabled.
        """
        return pulumi.get(self, "advanced_ci")

    @_builtins.property
    @pulumi.getter(name="aiFeatures")
    def ai_features(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether AI features are enabled.
        """
        return pulumi.get(self, "ai_features")

    @_builtins.property
    @pulumi.getter(name="partialParsing")
    def partial_parsing(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether partial parsing is enabled.
        """
        return pulumi.get(self, "partial_parsing")

    @_builtins.property
    @pulumi.getter(name="repoCaching")
    def repo_caching(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether repository caching is enabled.
        """
        return pulumi.get(self, "repo_caching")

    @_builtins.property
    @pulumi.getter(name="warehouseCostVisibility")
    def warehouse_cost_visibility(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether warehouse cost visibility is enabled.
        """
        return pulumi.get(self, "warehouse_cost_visibility")

