# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetModelNotificationsResult',
    'AwaitableGetModelNotificationsResult',
    'get_model_notifications',
    'get_model_notifications_output',
]

@pulumi.output_type
class GetModelNotificationsResult:
    """
    A collection of values returned by getModelNotifications.
    """
    def __init__(__self__, enabled=None, environment_id=None, id=None, on_failure=None, on_skipped=None, on_success=None, on_warning=None):
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if environment_id and not isinstance(environment_id, str):
            raise TypeError("Expected argument 'environment_id' to be a str")
        pulumi.set(__self__, "environment_id", environment_id)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if on_failure and not isinstance(on_failure, bool):
            raise TypeError("Expected argument 'on_failure' to be a bool")
        pulumi.set(__self__, "on_failure", on_failure)
        if on_skipped and not isinstance(on_skipped, bool):
            raise TypeError("Expected argument 'on_skipped' to be a bool")
        pulumi.set(__self__, "on_skipped", on_skipped)
        if on_success and not isinstance(on_success, bool):
            raise TypeError("Expected argument 'on_success' to be a bool")
        pulumi.set(__self__, "on_success", on_success)
        if on_warning and not isinstance(on_warning, bool):
            raise TypeError("Expected argument 'on_warning' to be a bool")
        pulumi.set(__self__, "on_warning", on_warning)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether model notifications are enabled for this environment
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> _builtins.str:
        """
        The ID of the dbt Cloud environment
        """
        return pulumi.get(self, "environment_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        The internal ID of the model notifications configuration
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="onFailure")
    def on_failure(self) -> _builtins.bool:
        """
        Whether to send notifications for failed model runs
        """
        return pulumi.get(self, "on_failure")

    @_builtins.property
    @pulumi.getter(name="onSkipped")
    def on_skipped(self) -> _builtins.bool:
        """
        Whether to send notifications for skipped model runs
        """
        return pulumi.get(self, "on_skipped")

    @_builtins.property
    @pulumi.getter(name="onSuccess")
    def on_success(self) -> _builtins.bool:
        """
        Whether to send notifications for successful model runs
        """
        return pulumi.get(self, "on_success")

    @_builtins.property
    @pulumi.getter(name="onWarning")
    def on_warning(self) -> _builtins.bool:
        """
        Whether to send notifications for model runs with warnings
        """
        return pulumi.get(self, "on_warning")


class AwaitableGetModelNotificationsResult(GetModelNotificationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetModelNotificationsResult(
            enabled=self.enabled,
            environment_id=self.environment_id,
            id=self.id,
            on_failure=self.on_failure,
            on_skipped=self.on_skipped,
            on_success=self.on_success,
            on_warning=self.on_warning)


def get_model_notifications(environment_id: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetModelNotificationsResult:
    """
    Get model notifications configuration for a dbt Cloud environment

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dbtcloud as dbtcloud

    prod_model_notifications = dbtcloud.get_model_notifications(environment_id=prod_environment["environmentId"])
    qa_model_notifications = dbtcloud.get_model_notifications(environment_id="12345")
    ```


    :param _builtins.str environment_id: The ID of the dbt Cloud environment
    """
    __args__ = dict()
    __args__['environmentId'] = environment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dbtcloud:index/getModelNotifications:getModelNotifications', __args__, opts=opts, typ=GetModelNotificationsResult).value

    return AwaitableGetModelNotificationsResult(
        enabled=pulumi.get(__ret__, 'enabled'),
        environment_id=pulumi.get(__ret__, 'environment_id'),
        id=pulumi.get(__ret__, 'id'),
        on_failure=pulumi.get(__ret__, 'on_failure'),
        on_skipped=pulumi.get(__ret__, 'on_skipped'),
        on_success=pulumi.get(__ret__, 'on_success'),
        on_warning=pulumi.get(__ret__, 'on_warning'))
def get_model_notifications_output(environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetModelNotificationsResult]:
    """
    Get model notifications configuration for a dbt Cloud environment

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dbtcloud as dbtcloud

    prod_model_notifications = dbtcloud.get_model_notifications(environment_id=prod_environment["environmentId"])
    qa_model_notifications = dbtcloud.get_model_notifications(environment_id="12345")
    ```


    :param _builtins.str environment_id: The ID of the dbt Cloud environment
    """
    __args__ = dict()
    __args__['environmentId'] = environment_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dbtcloud:index/getModelNotifications:getModelNotifications', __args__, opts=opts, typ=GetModelNotificationsResult)
    return __ret__.apply(lambda __response__: GetModelNotificationsResult(
        enabled=pulumi.get(__response__, 'enabled'),
        environment_id=pulumi.get(__response__, 'environment_id'),
        id=pulumi.get(__response__, 'id'),
        on_failure=pulumi.get(__response__, 'on_failure'),
        on_skipped=pulumi.get(__response__, 'on_skipped'),
        on_success=pulumi.get(__response__, 'on_success'),
        on_warning=pulumi.get(__response__, 'on_warning')))
