# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IpRestrictionsRuleArgs', 'IpRestrictionsRule']

@pulumi.input_type
class IpRestrictionsRuleArgs:
    def __init__(__self__, *,
                 cidrs: pulumi.Input[Sequence[pulumi.Input['IpRestrictionsRuleCidrArgs']]],
                 rule_set_enabled: pulumi.Input[_builtins.bool],
                 type: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a IpRestrictionsRule resource.
        :param pulumi.Input[Sequence[pulumi.Input['IpRestrictionsRuleCidrArgs']]] cidrs: Set of CIDR ranges for this rule
        :param pulumi.Input[_builtins.bool] rule_set_enabled: Whether the IP restriction rule set is enabled or not. Important!: This value needs to be the same for all rules if multiple rules are defined. All rules must be active or inactive at the same time.
        :param pulumi.Input[_builtins.str] type: The type of the IP restriction rule (allow or deny)
        :param pulumi.Input[_builtins.str] description: A description of the IP restriction rule
        :param pulumi.Input[_builtins.str] name: The name of the IP restriction rule
        """
        pulumi.set(__self__, "cidrs", cidrs)
        pulumi.set(__self__, "rule_set_enabled", rule_set_enabled)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def cidrs(self) -> pulumi.Input[Sequence[pulumi.Input['IpRestrictionsRuleCidrArgs']]]:
        """
        Set of CIDR ranges for this rule
        """
        return pulumi.get(self, "cidrs")

    @cidrs.setter
    def cidrs(self, value: pulumi.Input[Sequence[pulumi.Input['IpRestrictionsRuleCidrArgs']]]):
        pulumi.set(self, "cidrs", value)

    @_builtins.property
    @pulumi.getter(name="ruleSetEnabled")
    def rule_set_enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether the IP restriction rule set is enabled or not. Important!: This value needs to be the same for all rules if multiple rules are defined. All rules must be active or inactive at the same time.
        """
        return pulumi.get(self, "rule_set_enabled")

    @rule_set_enabled.setter
    def rule_set_enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "rule_set_enabled", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the IP restriction rule (allow or deny)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the IP restriction rule
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IP restriction rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _IpRestrictionsRuleState:
    def __init__(__self__, *,
                 cidrs: Optional[pulumi.Input[Sequence[pulumi.Input['IpRestrictionsRuleCidrArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_set_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IpRestrictionsRule resources.
        :param pulumi.Input[Sequence[pulumi.Input['IpRestrictionsRuleCidrArgs']]] cidrs: Set of CIDR ranges for this rule
        :param pulumi.Input[_builtins.str] description: A description of the IP restriction rule
        :param pulumi.Input[_builtins.str] name: The name of the IP restriction rule
        :param pulumi.Input[_builtins.bool] rule_set_enabled: Whether the IP restriction rule set is enabled or not. Important!: This value needs to be the same for all rules if multiple rules are defined. All rules must be active or inactive at the same time.
        :param pulumi.Input[_builtins.str] type: The type of the IP restriction rule (allow or deny)
        """
        if cidrs is not None:
            pulumi.set(__self__, "cidrs", cidrs)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rule_set_enabled is not None:
            pulumi.set(__self__, "rule_set_enabled", rule_set_enabled)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpRestrictionsRuleCidrArgs']]]]:
        """
        Set of CIDR ranges for this rule
        """
        return pulumi.get(self, "cidrs")

    @cidrs.setter
    def cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpRestrictionsRuleCidrArgs']]]]):
        pulumi.set(self, "cidrs", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the IP restriction rule
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IP restriction rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ruleSetEnabled")
    def rule_set_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the IP restriction rule set is enabled or not. Important!: This value needs to be the same for all rules if multiple rules are defined. All rules must be active or inactive at the same time.
        """
        return pulumi.get(self, "rule_set_enabled")

    @rule_set_enabled.setter
    def rule_set_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "rule_set_enabled", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the IP restriction rule (allow or deny)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("dbtcloud:index/ipRestrictionsRule:IpRestrictionsRule")
class IpRestrictionsRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpRestrictionsRuleCidrArgs', 'IpRestrictionsRuleCidrArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_set_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages IP restriction rules in dbt Cloud. IP restriction rules allow you to control access to your dbt Cloud instance based on IP address ranges.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        test = dbtcloud.IpRestrictionsRule("test",
            name="My restriction rule",
            description="Important description",
            cidrs=[
                {
                    "cidr": "::ffff:106:708",
                },
                {
                    "cidr": "1.6.7.10/24",
                },
            ],
            type="deny",
            rule_set_enabled=False)
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_ip_restrictions_rule.my_rule

          id = "ip_restriction_rule_id"

        }

        import {

          to = dbtcloud_ip_restrictions_rule.my_rule

          id = "12345"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/ipRestrictionsRule:IpRestrictionsRule my_rule "ip_restriction_rule_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/ipRestrictionsRule:IpRestrictionsRule my_rule 12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IpRestrictionsRuleCidrArgs', 'IpRestrictionsRuleCidrArgsDict']]]] cidrs: Set of CIDR ranges for this rule
        :param pulumi.Input[_builtins.str] description: A description of the IP restriction rule
        :param pulumi.Input[_builtins.str] name: The name of the IP restriction rule
        :param pulumi.Input[_builtins.bool] rule_set_enabled: Whether the IP restriction rule set is enabled or not. Important!: This value needs to be the same for all rules if multiple rules are defined. All rules must be active or inactive at the same time.
        :param pulumi.Input[_builtins.str] type: The type of the IP restriction rule (allow or deny)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IpRestrictionsRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages IP restriction rules in dbt Cloud. IP restriction rules allow you to control access to your dbt Cloud instance based on IP address ranges.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        test = dbtcloud.IpRestrictionsRule("test",
            name="My restriction rule",
            description="Important description",
            cidrs=[
                {
                    "cidr": "::ffff:106:708",
                },
                {
                    "cidr": "1.6.7.10/24",
                },
            ],
            type="deny",
            rule_set_enabled=False)
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_ip_restrictions_rule.my_rule

          id = "ip_restriction_rule_id"

        }

        import {

          to = dbtcloud_ip_restrictions_rule.my_rule

          id = "12345"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/ipRestrictionsRule:IpRestrictionsRule my_rule "ip_restriction_rule_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/ipRestrictionsRule:IpRestrictionsRule my_rule 12345
        ```

        :param str resource_name: The name of the resource.
        :param IpRestrictionsRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpRestrictionsRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpRestrictionsRuleCidrArgs', 'IpRestrictionsRuleCidrArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_set_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpRestrictionsRuleArgs.__new__(IpRestrictionsRuleArgs)

            if cidrs is None and not opts.urn:
                raise TypeError("Missing required property 'cidrs'")
            __props__.__dict__["cidrs"] = cidrs
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if rule_set_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'rule_set_enabled'")
            __props__.__dict__["rule_set_enabled"] = rule_set_enabled
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(IpRestrictionsRule, __self__).__init__(
            'dbtcloud:index/ipRestrictionsRule:IpRestrictionsRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpRestrictionsRuleCidrArgs', 'IpRestrictionsRuleCidrArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            rule_set_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'IpRestrictionsRule':
        """
        Get an existing IpRestrictionsRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IpRestrictionsRuleCidrArgs', 'IpRestrictionsRuleCidrArgsDict']]]] cidrs: Set of CIDR ranges for this rule
        :param pulumi.Input[_builtins.str] description: A description of the IP restriction rule
        :param pulumi.Input[_builtins.str] name: The name of the IP restriction rule
        :param pulumi.Input[_builtins.bool] rule_set_enabled: Whether the IP restriction rule set is enabled or not. Important!: This value needs to be the same for all rules if multiple rules are defined. All rules must be active or inactive at the same time.
        :param pulumi.Input[_builtins.str] type: The type of the IP restriction rule (allow or deny)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IpRestrictionsRuleState.__new__(_IpRestrictionsRuleState)

        __props__.__dict__["cidrs"] = cidrs
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["rule_set_enabled"] = rule_set_enabled
        __props__.__dict__["type"] = type
        return IpRestrictionsRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def cidrs(self) -> pulumi.Output[Sequence['outputs.IpRestrictionsRuleCidr']]:
        """
        Set of CIDR ranges for this rule
        """
        return pulumi.get(self, "cidrs")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of the IP restriction rule
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the IP restriction rule
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ruleSetEnabled")
    def rule_set_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the IP restriction rule set is enabled or not. Important!: This value needs to be the same for all rules if multiple rules are defined. All rules must be active or inactive at the same time.
        """
        return pulumi.get(self, "rule_set_enabled")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the IP restriction rule (allow or deny)
        """
        return pulumi.get(self, "type")

