# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'BigquerySemanticLayerCredentialConfiguration',
    'BigquerySemanticLayerCredentialCredential',
    'DatabricksSemanticLayerCredentialConfiguration',
    'DatabricksSemanticLayerCredentialCredential',
    'GlobalConnectionApacheSpark',
    'GlobalConnectionAthena',
    'GlobalConnectionBigquery',
    'GlobalConnectionDatabricks',
    'GlobalConnectionFabric',
    'GlobalConnectionPostgres',
    'GlobalConnectionPostgresSshTunnel',
    'GlobalConnectionRedshift',
    'GlobalConnectionRedshiftSshTunnel',
    'GlobalConnectionSnowflake',
    'GlobalConnectionStarburst',
    'GlobalConnectionSynapse',
    'GlobalConnectionTeradata',
    'GroupGroupPermission',
    'GroupPartialPermissionsGroupPermission',
    'IpRestrictionsRuleCidr',
    'JobJobCompletionTriggerCondition',
    'JobTriggers',
    'PostgresSemanticLayerCredentialConfiguration',
    'PostgresSemanticLayerCredentialCredential',
    'RedshiftSemanticLayerCredentialConfiguration',
    'RedshiftSemanticLayerCredentialCredential',
    'ScimGroupPermissionsPermission',
    'ServiceTokenServiceTokenPermission',
    'SnowflakeSemanticLayerCredentialConfiguration',
    'SnowflakeSemanticLayerCredentialCredential',
    'GetEnvironmentsEnvironmentResult',
    'GetGlobalConnectionApacheSparkResult',
    'GetGlobalConnectionAthenaResult',
    'GetGlobalConnectionBigqueryResult',
    'GetGlobalConnectionDatabricksResult',
    'GetGlobalConnectionFabricResult',
    'GetGlobalConnectionPostgresResult',
    'GetGlobalConnectionPostgresSshTunnelResult',
    'GetGlobalConnectionRedshiftResult',
    'GetGlobalConnectionRedshiftSshTunnelResult',
    'GetGlobalConnectionSnowflakeResult',
    'GetGlobalConnectionStarburstResult',
    'GetGlobalConnectionSynapseResult',
    'GetGlobalConnectionTeradataResult',
    'GetGlobalConnectionsConnectionResult',
    'GetGroupGroupPermissionResult',
    'GetGroupUsersUserResult',
    'GetGroupsGroupResult',
    'GetJobEnvironmentResult',
    'GetJobExecutionResult',
    'GetJobJobCompletionTriggerConditionResult',
    'GetJobScheduleResult',
    'GetJobSettingsResult',
    'GetJobTriggersResult',
    'GetJobsJobResult',
    'GetJobsJobEnvironmentResult',
    'GetJobsJobExecutionResult',
    'GetJobsJobJobCompletionTriggerConditionResult',
    'GetJobsJobJobCompletionTriggerConditionConditionResult',
    'GetJobsJobScheduleResult',
    'GetJobsJobSettingsResult',
    'GetJobsJobTriggersResult',
    'GetPrivatelinkEndpointsEndpointResult',
    'GetProjectProjectConnectionResult',
    'GetProjectRepositoryResult',
    'GetProjectsProjectResult',
    'GetProjectsProjectProjectConnectionResult',
    'GetProjectsProjectRepositoryResult',
    'GetRunsFilterResult',
    'GetRunsRunResult',
    'GetServiceTokenServiceTokenPermissionResult',
    'GetUsersUserResult',
]

@pulumi.output_type
class BigquerySemanticLayerCredentialConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adapterVersion":
            suggest = "adapter_version"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BigquerySemanticLayerCredentialConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BigquerySemanticLayerCredentialConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BigquerySemanticLayerCredentialConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 adapter_version: _builtins.str,
                 name: _builtins.str,
                 project_id: _builtins.int):
        """
        :param _builtins.str adapter_version: The adapter version
        :param _builtins.str name: The name of the configuration
        :param _builtins.int project_id: The ID of the project
        """
        pulumi.set(__self__, "adapter_version", adapter_version)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter(name="adapterVersion")
    def adapter_version(self) -> _builtins.str:
        """
        The adapter version
        """
        return pulumi.get(self, "adapter_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the configuration
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.int:
        """
        The ID of the project
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class BigquerySemanticLayerCredentialCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numThreads":
            suggest = "num_threads"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "credentialId":
            suggest = "credential_id"
        elif key == "isActive":
            suggest = "is_active"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BigquerySemanticLayerCredentialCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BigquerySemanticLayerCredentialCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BigquerySemanticLayerCredentialCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset: _builtins.str,
                 num_threads: _builtins.int,
                 project_id: _builtins.int,
                 credential_id: Optional[_builtins.int] = None,
                 id: Optional[_builtins.str] = None,
                 is_active: Optional[_builtins.bool] = None):
        """
        :param _builtins.str dataset: Default dataset name
        :param _builtins.int num_threads: Number of threads to use
        :param _builtins.int project_id: Project ID to create the BigQuery credential in
        :param _builtins.int credential_id: The internal credential ID
        :param _builtins.str id: The ID of this resource. Contains the project ID and the credential ID.
        :param _builtins.bool is_active: Whether the BigQuery credential is active
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "num_threads", num_threads)
        pulumi.set(__self__, "project_id", project_id)
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> _builtins.str:
        """
        Default dataset name
        """
        return pulumi.get(self, "dataset")

    @_builtins.property
    @pulumi.getter(name="numThreads")
    def num_threads(self) -> _builtins.int:
        """
        Number of threads to use
        """
        return pulumi.get(self, "num_threads")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.int:
        """
        Project ID to create the BigQuery credential in
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[_builtins.int]:
        """
        The internal credential ID
        """
        return pulumi.get(self, "credential_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of this resource. Contains the project ID and the credential ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[_builtins.bool]:
        """
        Whether the BigQuery credential is active
        """
        return pulumi.get(self, "is_active")


@pulumi.output_type
class DatabricksSemanticLayerCredentialConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adapterVersion":
            suggest = "adapter_version"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabricksSemanticLayerCredentialConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabricksSemanticLayerCredentialConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabricksSemanticLayerCredentialConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 adapter_version: _builtins.str,
                 name: _builtins.str,
                 project_id: _builtins.int):
        """
        :param _builtins.str adapter_version: The adapter version
        :param _builtins.str name: The name of the configuration
        :param _builtins.int project_id: The ID of the project
        """
        pulumi.set(__self__, "adapter_version", adapter_version)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter(name="adapterVersion")
    def adapter_version(self) -> _builtins.str:
        """
        The adapter version
        """
        return pulumi.get(self, "adapter_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the configuration
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.int:
        """
        The ID of the project
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class DatabricksSemanticLayerCredentialCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"
        elif key == "adapterType":
            suggest = "adapter_type"
        elif key == "credentialId":
            suggest = "credential_id"
        elif key == "semanticLayerCredential":
            suggest = "semantic_layer_credential"
        elif key == "targetName":
            suggest = "target_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabricksSemanticLayerCredentialCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabricksSemanticLayerCredentialCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabricksSemanticLayerCredentialCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project_id: _builtins.int,
                 token: _builtins.str,
                 adapter_type: Optional[_builtins.str] = None,
                 catalog: Optional[_builtins.str] = None,
                 credential_id: Optional[_builtins.int] = None,
                 id: Optional[_builtins.str] = None,
                 schema: Optional[_builtins.str] = None,
                 semantic_layer_credential: Optional[_builtins.bool] = None,
                 target_name: Optional[_builtins.str] = None):
        """
        :param _builtins.int project_id: Project ID to create the Databricks credential in
        :param _builtins.str token: Token for Databricks user
        :param _builtins.str adapter_type: The type of the adapter (databricks or spark). Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        :param _builtins.str catalog: The catalog where to create models (only for the databricks adapter)
        :param _builtins.int credential_id: The system Databricks credential ID
        :param _builtins.str id: The ID of this resource. Contains the project ID and the credential ID.
        :param _builtins.str schema: The schema where to create models. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        :param _builtins.bool semantic_layer_credential: This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Databricks credential for the Semantic Layer.
        :param _builtins.str target_name: Target name
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "token", token)
        if adapter_type is not None:
            pulumi.set(__self__, "adapter_type", adapter_type)
        if catalog is not None:
            pulumi.set(__self__, "catalog", catalog)
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if semantic_layer_credential is not None:
            pulumi.set(__self__, "semantic_layer_credential", semantic_layer_credential)
        if target_name is not None:
            pulumi.set(__self__, "target_name", target_name)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.int:
        """
        Project ID to create the Databricks credential in
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        Token for Databricks user
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter(name="adapterType")
    def adapter_type(self) -> Optional[_builtins.str]:
        """
        The type of the adapter (databricks or spark). Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        """
        return pulumi.get(self, "adapter_type")

    @_builtins.property
    @pulumi.getter
    def catalog(self) -> Optional[_builtins.str]:
        """
        The catalog where to create models (only for the databricks adapter)
        """
        return pulumi.get(self, "catalog")

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[_builtins.int]:
        """
        The system Databricks credential ID
        """
        return pulumi.get(self, "credential_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of this resource. Contains the project ID and the credential ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[_builtins.str]:
        """
        The schema where to create models. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="semanticLayerCredential")
    def semantic_layer_credential(self) -> Optional[_builtins.bool]:
        """
        This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Databricks credential for the Semantic Layer.
        """
        return pulumi.get(self, "semantic_layer_credential")

    @_builtins.property
    @pulumi.getter(name="targetName")
    @_utilities.deprecated("""This field is deprecated at the environment level (it was never possible to set it in the UI) and will be removed in a future release. Please remove it and set the target name at the job level or leverage environment variables.""")
    def target_name(self) -> Optional[_builtins.str]:
        """
        Target name
        """
        return pulumi.get(self, "target_name")


@pulumi.output_type
class GlobalConnectionApacheSpark(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectRetries":
            suggest = "connect_retries"
        elif key == "connectTimeout":
            suggest = "connect_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalConnectionApacheSpark. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalConnectionApacheSpark.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalConnectionApacheSpark.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster: _builtins.str,
                 host: _builtins.str,
                 method: _builtins.str,
                 auth: Optional[_builtins.str] = None,
                 connect_retries: Optional[_builtins.int] = None,
                 connect_timeout: Optional[_builtins.int] = None,
                 organization: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 user: Optional[_builtins.str] = None):
        """
        :param _builtins.str cluster: Spark cluster for the connection
        :param _builtins.str host: Hostname of the connection
        :param _builtins.str method: Authentication method for the connection (http or thrift).
        :param _builtins.str auth: Auth
        :param _builtins.int connect_retries: Connection retries. Default=0
        :param _builtins.int connect_timeout: Connection time out in seconds. Default=10
        :param _builtins.str organization: Organization ID
        :param _builtins.int port: Port for the connection. Default=443
        :param _builtins.str user: User
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "method", method)
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if connect_retries is not None:
            pulumi.set(__self__, "connect_retries", connect_retries)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> _builtins.str:
        """
        Spark cluster for the connection
        """
        return pulumi.get(self, "cluster")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        Hostname of the connection
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        Authentication method for the connection (http or thrift).
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def auth(self) -> Optional[_builtins.str]:
        """
        Auth
        """
        return pulumi.get(self, "auth")

    @_builtins.property
    @pulumi.getter(name="connectRetries")
    def connect_retries(self) -> Optional[_builtins.int]:
        """
        Connection retries. Default=0
        """
        return pulumi.get(self, "connect_retries")

    @_builtins.property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[_builtins.int]:
        """
        Connection time out in seconds. Default=10
        """
        return pulumi.get(self, "connect_timeout")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[_builtins.str]:
        """
        Organization ID
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port for the connection. Default=443
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[_builtins.str]:
        """
        User
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class GlobalConnectionAthena(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "regionName":
            suggest = "region_name"
        elif key == "s3StagingDir":
            suggest = "s3_staging_dir"
        elif key == "numBoto3Retries":
            suggest = "num_boto3_retries"
        elif key == "numIcebergRetries":
            suggest = "num_iceberg_retries"
        elif key == "numRetries":
            suggest = "num_retries"
        elif key == "pollInterval":
            suggest = "poll_interval"
        elif key == "s3DataDir":
            suggest = "s3_data_dir"
        elif key == "s3DataNaming":
            suggest = "s3_data_naming"
        elif key == "s3TmpTableDir":
            suggest = "s3_tmp_table_dir"
        elif key == "sparkWorkGroup":
            suggest = "spark_work_group"
        elif key == "workGroup":
            suggest = "work_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalConnectionAthena. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalConnectionAthena.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalConnectionAthena.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database: _builtins.str,
                 region_name: _builtins.str,
                 s3_staging_dir: _builtins.str,
                 num_boto3_retries: Optional[_builtins.int] = None,
                 num_iceberg_retries: Optional[_builtins.int] = None,
                 num_retries: Optional[_builtins.int] = None,
                 poll_interval: Optional[_builtins.int] = None,
                 s3_data_dir: Optional[_builtins.str] = None,
                 s3_data_naming: Optional[_builtins.str] = None,
                 s3_tmp_table_dir: Optional[_builtins.str] = None,
                 spark_work_group: Optional[_builtins.str] = None,
                 work_group: Optional[_builtins.str] = None):
        """
        :param _builtins.str database: Specify the database (data catalog) to build models into (lowercase only).
        :param _builtins.str region_name: AWS region of your Athena instance.
        :param _builtins.str s3_staging_dir: S3 location to store Athena query results and metadata.
        :param _builtins.int num_boto3_retries: Number of times to retry boto3 requests (e.g. deleting S3 files for materialized tables).
        :param _builtins.int num_iceberg_retries: Number of times to retry iceberg commit queries to fix ICEBERG*COMMIT*ERROR.
        :param _builtins.int num_retries: Number of times to retry a failing query.
        :param _builtins.int poll_interval: Interval in seconds to use for polling the status of query results in Athena.
        :param _builtins.str s3_data_dir: Prefix for storing tables, if different from the connection's S3 staging directory.
        :param _builtins.str s3_data_naming: How to generate table paths in the S3 data directory.
        :param _builtins.str s3_tmp_table_dir: Prefix for storing temporary tables, if different from the connection's S3 data directory.
        :param _builtins.str spark_work_group: Identifier of Athena Spark workgroup for running Python models.
        :param _builtins.str work_group: Identifier of Athena workgroup.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "region_name", region_name)
        pulumi.set(__self__, "s3_staging_dir", s3_staging_dir)
        if num_boto3_retries is not None:
            pulumi.set(__self__, "num_boto3_retries", num_boto3_retries)
        if num_iceberg_retries is not None:
            pulumi.set(__self__, "num_iceberg_retries", num_iceberg_retries)
        if num_retries is not None:
            pulumi.set(__self__, "num_retries", num_retries)
        if poll_interval is not None:
            pulumi.set(__self__, "poll_interval", poll_interval)
        if s3_data_dir is not None:
            pulumi.set(__self__, "s3_data_dir", s3_data_dir)
        if s3_data_naming is not None:
            pulumi.set(__self__, "s3_data_naming", s3_data_naming)
        if s3_tmp_table_dir is not None:
            pulumi.set(__self__, "s3_tmp_table_dir", s3_tmp_table_dir)
        if spark_work_group is not None:
            pulumi.set(__self__, "spark_work_group", spark_work_group)
        if work_group is not None:
            pulumi.set(__self__, "work_group", work_group)

    @_builtins.property
    @pulumi.getter
    def database(self) -> _builtins.str:
        """
        Specify the database (data catalog) to build models into (lowercase only).
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter(name="regionName")
    def region_name(self) -> _builtins.str:
        """
        AWS region of your Athena instance.
        """
        return pulumi.get(self, "region_name")

    @_builtins.property
    @pulumi.getter(name="s3StagingDir")
    def s3_staging_dir(self) -> _builtins.str:
        """
        S3 location to store Athena query results and metadata.
        """
        return pulumi.get(self, "s3_staging_dir")

    @_builtins.property
    @pulumi.getter(name="numBoto3Retries")
    def num_boto3_retries(self) -> Optional[_builtins.int]:
        """
        Number of times to retry boto3 requests (e.g. deleting S3 files for materialized tables).
        """
        return pulumi.get(self, "num_boto3_retries")

    @_builtins.property
    @pulumi.getter(name="numIcebergRetries")
    def num_iceberg_retries(self) -> Optional[_builtins.int]:
        """
        Number of times to retry iceberg commit queries to fix ICEBERG*COMMIT*ERROR.
        """
        return pulumi.get(self, "num_iceberg_retries")

    @_builtins.property
    @pulumi.getter(name="numRetries")
    def num_retries(self) -> Optional[_builtins.int]:
        """
        Number of times to retry a failing query.
        """
        return pulumi.get(self, "num_retries")

    @_builtins.property
    @pulumi.getter(name="pollInterval")
    def poll_interval(self) -> Optional[_builtins.int]:
        """
        Interval in seconds to use for polling the status of query results in Athena.
        """
        return pulumi.get(self, "poll_interval")

    @_builtins.property
    @pulumi.getter(name="s3DataDir")
    def s3_data_dir(self) -> Optional[_builtins.str]:
        """
        Prefix for storing tables, if different from the connection's S3 staging directory.
        """
        return pulumi.get(self, "s3_data_dir")

    @_builtins.property
    @pulumi.getter(name="s3DataNaming")
    def s3_data_naming(self) -> Optional[_builtins.str]:
        """
        How to generate table paths in the S3 data directory.
        """
        return pulumi.get(self, "s3_data_naming")

    @_builtins.property
    @pulumi.getter(name="s3TmpTableDir")
    def s3_tmp_table_dir(self) -> Optional[_builtins.str]:
        """
        Prefix for storing temporary tables, if different from the connection's S3 data directory.
        """
        return pulumi.get(self, "s3_tmp_table_dir")

    @_builtins.property
    @pulumi.getter(name="sparkWorkGroup")
    def spark_work_group(self) -> Optional[_builtins.str]:
        """
        Identifier of Athena Spark workgroup for running Python models.
        """
        return pulumi.get(self, "spark_work_group")

    @_builtins.property
    @pulumi.getter(name="workGroup")
    def work_group(self) -> Optional[_builtins.str]:
        """
        Identifier of Athena workgroup.
        """
        return pulumi.get(self, "work_group")


@pulumi.output_type
class GlobalConnectionBigquery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authProviderX509CertUrl":
            suggest = "auth_provider_x509_cert_url"
        elif key == "authUri":
            suggest = "auth_uri"
        elif key == "clientEmail":
            suggest = "client_email"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientX509CertUrl":
            suggest = "client_x509_cert_url"
        elif key == "gcpProjectId":
            suggest = "gcp_project_id"
        elif key == "privateKey":
            suggest = "private_key"
        elif key == "privateKeyId":
            suggest = "private_key_id"
        elif key == "tokenUri":
            suggest = "token_uri"
        elif key == "applicationId":
            suggest = "application_id"
        elif key == "applicationSecret":
            suggest = "application_secret"
        elif key == "dataprocClusterName":
            suggest = "dataproc_cluster_name"
        elif key == "dataprocRegion":
            suggest = "dataproc_region"
        elif key == "executionProject":
            suggest = "execution_project"
        elif key == "gcsBucket":
            suggest = "gcs_bucket"
        elif key == "impersonateServiceAccount":
            suggest = "impersonate_service_account"
        elif key == "jobCreationTimeoutSeconds":
            suggest = "job_creation_timeout_seconds"
        elif key == "jobExecutionTimeoutSeconds":
            suggest = "job_execution_timeout_seconds"
        elif key == "jobRetryDeadlineSeconds":
            suggest = "job_retry_deadline_seconds"
        elif key == "maximumBytesBilled":
            suggest = "maximum_bytes_billed"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"
        elif key == "useLatestAdapter":
            suggest = "use_latest_adapter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalConnectionBigquery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalConnectionBigquery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalConnectionBigquery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_provider_x509_cert_url: _builtins.str,
                 auth_uri: _builtins.str,
                 client_email: _builtins.str,
                 client_id: _builtins.str,
                 client_x509_cert_url: _builtins.str,
                 gcp_project_id: _builtins.str,
                 private_key: _builtins.str,
                 private_key_id: _builtins.str,
                 token_uri: _builtins.str,
                 application_id: Optional[_builtins.str] = None,
                 application_secret: Optional[_builtins.str] = None,
                 dataproc_cluster_name: Optional[_builtins.str] = None,
                 dataproc_region: Optional[_builtins.str] = None,
                 execution_project: Optional[_builtins.str] = None,
                 gcs_bucket: Optional[_builtins.str] = None,
                 impersonate_service_account: Optional[_builtins.str] = None,
                 job_creation_timeout_seconds: Optional[_builtins.int] = None,
                 job_execution_timeout_seconds: Optional[_builtins.int] = None,
                 job_retry_deadline_seconds: Optional[_builtins.int] = None,
                 location: Optional[_builtins.str] = None,
                 maximum_bytes_billed: Optional[_builtins.int] = None,
                 priority: Optional[_builtins.str] = None,
                 retries: Optional[_builtins.int] = None,
                 scopes: Optional[Sequence[_builtins.str]] = None,
                 timeout_seconds: Optional[_builtins.int] = None,
                 use_latest_adapter: Optional[_builtins.bool] = None):
        """
        :param _builtins.str auth_provider_x509_cert_url: Auth Provider X509 Cert URL for the Service Account
        :param _builtins.str auth_uri: Auth URI for the Service Account
        :param _builtins.str client_email: Service Account email
        :param _builtins.str client_id: Client ID of the Service Account
        :param _builtins.str client_x509_cert_url: Client X509 Cert URL for the Service Account
        :param _builtins.str gcp_project_id: The GCP project ID to use for the connection
        :param _builtins.str private_key: Private Key for the Service Account
        :param _builtins.str private_key_id: Private Key ID for the Service Account
        :param _builtins.str token_uri: Token URI for the Service Account
        :param _builtins.str application_id: OAuth Client ID
        :param _builtins.str application_secret: OAuth Client Secret
        :param _builtins.str dataproc_cluster_name: Dataproc cluster name for PySpark workloads
        :param _builtins.str dataproc_region: Google Cloud region for PySpark workloads on Dataproc
        :param _builtins.str execution_project: Project to bill for query execution
        :param _builtins.str gcs_bucket: URI for a Google Cloud Storage bucket to host Python code executed via Datapro
        :param _builtins.str impersonate_service_account: Service Account to impersonate when running queries
        :param _builtins.int job_creation_timeout_seconds: Maximum timeout for the job creation step
        :param _builtins.int job_execution_timeout_seconds: Timeout in seconds for job execution, to be used for the bigquery_v1 adapter
        :param _builtins.int job_retry_deadline_seconds: Total number of seconds to wait while retrying the same query
        :param _builtins.str location: Location to create new Datasets in
        :param _builtins.int maximum_bytes_billed: Max number of bytes that can be billed for a given BigQuery query
        :param _builtins.str priority: The priority with which to execute BigQuery queries (batch or interactive)
        :param _builtins.int retries: Number of retries for queries
        :param Sequence[_builtins.str] scopes: OAuth scopes for the BigQuery connection
        :param _builtins.int timeout_seconds: Timeout in seconds for queries, to be used ONLY for the bigquery_v0 adapter
        :param _builtins.bool use_latest_adapter: Whether to use the latest bigquery_v1 adapter (use this for BQ WIF). If true, the `job_execution_timeout_seconds` field will be used. Warning! changing the adapter version (from legacy to latest or vice versa) is not supported.
        """
        pulumi.set(__self__, "auth_provider_x509_cert_url", auth_provider_x509_cert_url)
        pulumi.set(__self__, "auth_uri", auth_uri)
        pulumi.set(__self__, "client_email", client_email)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_x509_cert_url", client_x509_cert_url)
        pulumi.set(__self__, "gcp_project_id", gcp_project_id)
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "private_key_id", private_key_id)
        pulumi.set(__self__, "token_uri", token_uri)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if application_secret is not None:
            pulumi.set(__self__, "application_secret", application_secret)
        if dataproc_cluster_name is not None:
            pulumi.set(__self__, "dataproc_cluster_name", dataproc_cluster_name)
        if dataproc_region is not None:
            pulumi.set(__self__, "dataproc_region", dataproc_region)
        if execution_project is not None:
            pulumi.set(__self__, "execution_project", execution_project)
        if gcs_bucket is not None:
            pulumi.set(__self__, "gcs_bucket", gcs_bucket)
        if impersonate_service_account is not None:
            pulumi.set(__self__, "impersonate_service_account", impersonate_service_account)
        if job_creation_timeout_seconds is not None:
            pulumi.set(__self__, "job_creation_timeout_seconds", job_creation_timeout_seconds)
        if job_execution_timeout_seconds is not None:
            pulumi.set(__self__, "job_execution_timeout_seconds", job_execution_timeout_seconds)
        if job_retry_deadline_seconds is not None:
            pulumi.set(__self__, "job_retry_deadline_seconds", job_retry_deadline_seconds)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maximum_bytes_billed is not None:
            pulumi.set(__self__, "maximum_bytes_billed", maximum_bytes_billed)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        if use_latest_adapter is not None:
            pulumi.set(__self__, "use_latest_adapter", use_latest_adapter)

    @_builtins.property
    @pulumi.getter(name="authProviderX509CertUrl")
    def auth_provider_x509_cert_url(self) -> _builtins.str:
        """
        Auth Provider X509 Cert URL for the Service Account
        """
        return pulumi.get(self, "auth_provider_x509_cert_url")

    @_builtins.property
    @pulumi.getter(name="authUri")
    def auth_uri(self) -> _builtins.str:
        """
        Auth URI for the Service Account
        """
        return pulumi.get(self, "auth_uri")

    @_builtins.property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> _builtins.str:
        """
        Service Account email
        """
        return pulumi.get(self, "client_email")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        Client ID of the Service Account
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientX509CertUrl")
    def client_x509_cert_url(self) -> _builtins.str:
        """
        Client X509 Cert URL for the Service Account
        """
        return pulumi.get(self, "client_x509_cert_url")

    @_builtins.property
    @pulumi.getter(name="gcpProjectId")
    def gcp_project_id(self) -> _builtins.str:
        """
        The GCP project ID to use for the connection
        """
        return pulumi.get(self, "gcp_project_id")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> _builtins.str:
        """
        Private Key for the Service Account
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> _builtins.str:
        """
        Private Key ID for the Service Account
        """
        return pulumi.get(self, "private_key_id")

    @_builtins.property
    @pulumi.getter(name="tokenUri")
    def token_uri(self) -> _builtins.str:
        """
        Token URI for the Service Account
        """
        return pulumi.get(self, "token_uri")

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[_builtins.str]:
        """
        OAuth Client ID
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="applicationSecret")
    def application_secret(self) -> Optional[_builtins.str]:
        """
        OAuth Client Secret
        """
        return pulumi.get(self, "application_secret")

    @_builtins.property
    @pulumi.getter(name="dataprocClusterName")
    def dataproc_cluster_name(self) -> Optional[_builtins.str]:
        """
        Dataproc cluster name for PySpark workloads
        """
        return pulumi.get(self, "dataproc_cluster_name")

    @_builtins.property
    @pulumi.getter(name="dataprocRegion")
    def dataproc_region(self) -> Optional[_builtins.str]:
        """
        Google Cloud region for PySpark workloads on Dataproc
        """
        return pulumi.get(self, "dataproc_region")

    @_builtins.property
    @pulumi.getter(name="executionProject")
    def execution_project(self) -> Optional[_builtins.str]:
        """
        Project to bill for query execution
        """
        return pulumi.get(self, "execution_project")

    @_builtins.property
    @pulumi.getter(name="gcsBucket")
    def gcs_bucket(self) -> Optional[_builtins.str]:
        """
        URI for a Google Cloud Storage bucket to host Python code executed via Datapro
        """
        return pulumi.get(self, "gcs_bucket")

    @_builtins.property
    @pulumi.getter(name="impersonateServiceAccount")
    def impersonate_service_account(self) -> Optional[_builtins.str]:
        """
        Service Account to impersonate when running queries
        """
        return pulumi.get(self, "impersonate_service_account")

    @_builtins.property
    @pulumi.getter(name="jobCreationTimeoutSeconds")
    def job_creation_timeout_seconds(self) -> Optional[_builtins.int]:
        """
        Maximum timeout for the job creation step
        """
        return pulumi.get(self, "job_creation_timeout_seconds")

    @_builtins.property
    @pulumi.getter(name="jobExecutionTimeoutSeconds")
    def job_execution_timeout_seconds(self) -> Optional[_builtins.int]:
        """
        Timeout in seconds for job execution, to be used for the bigquery_v1 adapter
        """
        return pulumi.get(self, "job_execution_timeout_seconds")

    @_builtins.property
    @pulumi.getter(name="jobRetryDeadlineSeconds")
    def job_retry_deadline_seconds(self) -> Optional[_builtins.int]:
        """
        Total number of seconds to wait while retrying the same query
        """
        return pulumi.get(self, "job_retry_deadline_seconds")

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[_builtins.str]:
        """
        Location to create new Datasets in
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="maximumBytesBilled")
    def maximum_bytes_billed(self) -> Optional[_builtins.int]:
        """
        Max number of bytes that can be billed for a given BigQuery query
        """
        return pulumi.get(self, "maximum_bytes_billed")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.str]:
        """
        The priority with which to execute BigQuery queries (batch or interactive)
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def retries(self) -> Optional[_builtins.int]:
        """
        Number of retries for queries
        """
        return pulumi.get(self, "retries")

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[_builtins.str]]:
        """
        OAuth scopes for the BigQuery connection
        """
        return pulumi.get(self, "scopes")

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[_builtins.int]:
        """
        Timeout in seconds for queries, to be used ONLY for the bigquery_v0 adapter
        """
        return pulumi.get(self, "timeout_seconds")

    @_builtins.property
    @pulumi.getter(name="useLatestAdapter")
    def use_latest_adapter(self) -> Optional[_builtins.bool]:
        """
        Whether to use the latest bigquery_v1 adapter (use this for BQ WIF). If true, the `job_execution_timeout_seconds` field will be used. Warning! changing the adapter version (from legacy to latest or vice versa) is not supported.
        """
        return pulumi.get(self, "use_latest_adapter")


@pulumi.output_type
class GlobalConnectionDatabricks(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpPath":
            suggest = "http_path"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalConnectionDatabricks. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalConnectionDatabricks.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalConnectionDatabricks.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: _builtins.str,
                 http_path: _builtins.str,
                 catalog: Optional[_builtins.str] = None,
                 client_id: Optional[_builtins.str] = None,
                 client_secret: Optional[_builtins.str] = None):
        """
        :param _builtins.str host: The hostname of the Databricks cluster or SQL warehouse.
        :param _builtins.str http_path: The HTTP path of the Databricks cluster or SQL warehouse.
        :param _builtins.str catalog: Catalog name if Unity Catalog is enabled in your Databricks workspace.
        :param _builtins.str client_id: Required to enable Databricks OAuth authentication for IDE developers.
        :param _builtins.str client_secret: Required to enable Databricks OAuth authentication for IDE developers.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "http_path", http_path)
        if catalog is not None:
            pulumi.set(__self__, "catalog", catalog)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The hostname of the Databricks cluster or SQL warehouse.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="httpPath")
    def http_path(self) -> _builtins.str:
        """
        The HTTP path of the Databricks cluster or SQL warehouse.
        """
        return pulumi.get(self, "http_path")

    @_builtins.property
    @pulumi.getter
    def catalog(self) -> Optional[_builtins.str]:
        """
        Catalog name if Unity Catalog is enabled in your Databricks workspace.
        """
        return pulumi.get(self, "catalog")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[_builtins.str]:
        """
        Required to enable Databricks OAuth authentication for IDE developers.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[_builtins.str]:
        """
        Required to enable Databricks OAuth authentication for IDE developers.
        """
        return pulumi.get(self, "client_secret")


@pulumi.output_type
class GlobalConnectionFabric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loginTimeout":
            suggest = "login_timeout"
        elif key == "queryTimeout":
            suggest = "query_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalConnectionFabric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalConnectionFabric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalConnectionFabric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database: _builtins.str,
                 server: _builtins.str,
                 login_timeout: Optional[_builtins.int] = None,
                 port: Optional[_builtins.int] = None,
                 query_timeout: Optional[_builtins.int] = None,
                 retries: Optional[_builtins.int] = None):
        """
        :param _builtins.str database: The database to connect to for this connection.
        :param _builtins.str server: The server hostname.
        :param _builtins.int login_timeout: The number of seconds used to establish a connection before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        :param _builtins.int port: The port to connect to for this connection. Default=1433
        :param _builtins.int query_timeout: The number of seconds used to wait for a query before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        :param _builtins.int retries: The number of automatic times to retry a query before failing. Defaults to 1. Queries with syntax errors will not be retried. This setting can be used to overcome intermittent network issues.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "server", server)
        if login_timeout is not None:
            pulumi.set(__self__, "login_timeout", login_timeout)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if query_timeout is not None:
            pulumi.set(__self__, "query_timeout", query_timeout)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)

    @_builtins.property
    @pulumi.getter
    def database(self) -> _builtins.str:
        """
        The database to connect to for this connection.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.str:
        """
        The server hostname.
        """
        return pulumi.get(self, "server")

    @_builtins.property
    @pulumi.getter(name="loginTimeout")
    def login_timeout(self) -> Optional[_builtins.int]:
        """
        The number of seconds used to establish a connection before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        """
        return pulumi.get(self, "login_timeout")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port to connect to for this connection. Default=1433
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="queryTimeout")
    def query_timeout(self) -> Optional[_builtins.int]:
        """
        The number of seconds used to wait for a query before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        """
        return pulumi.get(self, "query_timeout")

    @_builtins.property
    @pulumi.getter
    def retries(self) -> Optional[_builtins.int]:
        """
        The number of automatic times to retry a query before failing. Defaults to 1. Queries with syntax errors will not be retried. This setting can be used to overcome intermittent network issues.
        """
        return pulumi.get(self, "retries")


@pulumi.output_type
class GlobalConnectionPostgres(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshTunnel":
            suggest = "ssh_tunnel"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalConnectionPostgres. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalConnectionPostgres.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalConnectionPostgres.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dbname: _builtins.str,
                 hostname: _builtins.str,
                 port: Optional[_builtins.int] = None,
                 ssh_tunnel: Optional['outputs.GlobalConnectionPostgresSshTunnel'] = None):
        """
        :param _builtins.str dbname: The database name for this connection.
        :param _builtins.str hostname: The hostname of the database.
        :param _builtins.int port: The port to connect to for this connection. Default=5432
        :param 'GlobalConnectionPostgresSshTunnelArgs' ssh_tunnel: PostgreSQL SSH Tunnel configuration
        """
        pulumi.set(__self__, "dbname", dbname)
        pulumi.set(__self__, "hostname", hostname)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if ssh_tunnel is not None:
            pulumi.set(__self__, "ssh_tunnel", ssh_tunnel)

    @_builtins.property
    @pulumi.getter
    def dbname(self) -> _builtins.str:
        """
        The database name for this connection.
        """
        return pulumi.get(self, "dbname")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The hostname of the database.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port to connect to for this connection. Default=5432
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="sshTunnel")
    def ssh_tunnel(self) -> Optional['outputs.GlobalConnectionPostgresSshTunnel']:
        """
        PostgreSQL SSH Tunnel configuration
        """
        return pulumi.get(self, "ssh_tunnel")


@pulumi.output_type
class GlobalConnectionPostgresSshTunnel(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKey":
            suggest = "public_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalConnectionPostgresSshTunnel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalConnectionPostgresSshTunnel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalConnectionPostgresSshTunnel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: _builtins.str,
                 port: _builtins.int,
                 username: _builtins.str,
                 id: Optional[_builtins.int] = None,
                 public_key: Optional[_builtins.str] = None):
        """
        :param _builtins.str hostname: The hostname for the SSH tunnel.
        :param _builtins.int port: The HTTP port for the SSH tunnel.
        :param _builtins.str username: The username to use for the SSH tunnel.
        :param _builtins.int id: The ID of the SSH tunnel connection.
        :param _builtins.str public_key: The SSH public key generated to allow connecting via SSH tunnel.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "username", username)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The hostname for the SSH tunnel.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The HTTP port for the SSH tunnel.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The username to use for the SSH tunnel.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.int]:
        """
        The ID of the SSH tunnel connection.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[_builtins.str]:
        """
        The SSH public key generated to allow connecting via SSH tunnel.
        """
        return pulumi.get(self, "public_key")


@pulumi.output_type
class GlobalConnectionRedshift(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshTunnel":
            suggest = "ssh_tunnel"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalConnectionRedshift. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalConnectionRedshift.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalConnectionRedshift.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dbname: _builtins.str,
                 hostname: _builtins.str,
                 port: Optional[_builtins.int] = None,
                 ssh_tunnel: Optional['outputs.GlobalConnectionRedshiftSshTunnel'] = None):
        """
        :param _builtins.str dbname: The database name for this connection.
        :param _builtins.str hostname: The hostname of the data warehouse.
        :param _builtins.int port: The port to connect to for this connection. Default=5432
        :param 'GlobalConnectionRedshiftSshTunnelArgs' ssh_tunnel: Redshift SSH Tunnel configuration
        """
        pulumi.set(__self__, "dbname", dbname)
        pulumi.set(__self__, "hostname", hostname)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if ssh_tunnel is not None:
            pulumi.set(__self__, "ssh_tunnel", ssh_tunnel)

    @_builtins.property
    @pulumi.getter
    def dbname(self) -> _builtins.str:
        """
        The database name for this connection.
        """
        return pulumi.get(self, "dbname")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The hostname of the data warehouse.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port to connect to for this connection. Default=5432
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="sshTunnel")
    def ssh_tunnel(self) -> Optional['outputs.GlobalConnectionRedshiftSshTunnel']:
        """
        Redshift SSH Tunnel configuration
        """
        return pulumi.get(self, "ssh_tunnel")


@pulumi.output_type
class GlobalConnectionRedshiftSshTunnel(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKey":
            suggest = "public_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalConnectionRedshiftSshTunnel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalConnectionRedshiftSshTunnel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalConnectionRedshiftSshTunnel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: _builtins.str,
                 port: _builtins.int,
                 username: _builtins.str,
                 id: Optional[_builtins.int] = None,
                 public_key: Optional[_builtins.str] = None):
        """
        :param _builtins.str hostname: The hostname for the SSH tunnel.
        :param _builtins.int port: The HTTP port for the SSH tunnel.
        :param _builtins.str username: The username to use for the SSH tunnel.
        :param _builtins.int id: The ID of the SSH tunnel connection.
        :param _builtins.str public_key: The SSH public key generated to allow connecting via SSH tunnel.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "username", username)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The hostname for the SSH tunnel.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The HTTP port for the SSH tunnel.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The username to use for the SSH tunnel.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.int]:
        """
        The ID of the SSH tunnel connection.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[_builtins.str]:
        """
        The SSH public key generated to allow connecting via SSH tunnel.
        """
        return pulumi.get(self, "public_key")


@pulumi.output_type
class GlobalConnectionSnowflake(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowSso":
            suggest = "allow_sso"
        elif key == "clientSessionKeepAlive":
            suggest = "client_session_keep_alive"
        elif key == "oauthClientId":
            suggest = "oauth_client_id"
        elif key == "oauthClientSecret":
            suggest = "oauth_client_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalConnectionSnowflake. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalConnectionSnowflake.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalConnectionSnowflake.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account: _builtins.str,
                 database: _builtins.str,
                 warehouse: _builtins.str,
                 allow_sso: Optional[_builtins.bool] = None,
                 client_session_keep_alive: Optional[_builtins.bool] = None,
                 oauth_client_id: Optional[_builtins.str] = None,
                 oauth_client_secret: Optional[_builtins.str] = None,
                 role: Optional[_builtins.str] = None):
        """
        :param _builtins.str account: The Snowflake account name
        :param _builtins.str database: The default database for the connection
        :param _builtins.str warehouse: The default Snowflake Warehouse to use for the connection
        :param _builtins.bool allow_sso: Whether to allow Snowflake OAuth for the connection. If true, the `oauth_client_id` and `oauth_client_secret` fields must be set
        :param _builtins.bool client_session_keep_alive: If true, the snowflake client will keep connections for longer than the default 4 hours. This is helpful when particularly long-running queries are executing (> 4 hours)
        :param _builtins.str oauth_client_id: OAuth Client ID. Required to allow OAuth between dbt Cloud and Snowflake
        :param _builtins.str oauth_client_secret: OAuth Client Secret. Required to allow OAuth between dbt Cloud and Snowflake
        :param _builtins.str role: The Snowflake role to use when running queries on the connection
        """
        pulumi.set(__self__, "account", account)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "warehouse", warehouse)
        if allow_sso is not None:
            pulumi.set(__self__, "allow_sso", allow_sso)
        if client_session_keep_alive is not None:
            pulumi.set(__self__, "client_session_keep_alive", client_session_keep_alive)
        if oauth_client_id is not None:
            pulumi.set(__self__, "oauth_client_id", oauth_client_id)
        if oauth_client_secret is not None:
            pulumi.set(__self__, "oauth_client_secret", oauth_client_secret)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @_builtins.property
    @pulumi.getter
    def account(self) -> _builtins.str:
        """
        The Snowflake account name
        """
        return pulumi.get(self, "account")

    @_builtins.property
    @pulumi.getter
    def database(self) -> _builtins.str:
        """
        The default database for the connection
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter
    def warehouse(self) -> _builtins.str:
        """
        The default Snowflake Warehouse to use for the connection
        """
        return pulumi.get(self, "warehouse")

    @_builtins.property
    @pulumi.getter(name="allowSso")
    def allow_sso(self) -> Optional[_builtins.bool]:
        """
        Whether to allow Snowflake OAuth for the connection. If true, the `oauth_client_id` and `oauth_client_secret` fields must be set
        """
        return pulumi.get(self, "allow_sso")

    @_builtins.property
    @pulumi.getter(name="clientSessionKeepAlive")
    def client_session_keep_alive(self) -> Optional[_builtins.bool]:
        """
        If true, the snowflake client will keep connections for longer than the default 4 hours. This is helpful when particularly long-running queries are executing (> 4 hours)
        """
        return pulumi.get(self, "client_session_keep_alive")

    @_builtins.property
    @pulumi.getter(name="oauthClientId")
    def oauth_client_id(self) -> Optional[_builtins.str]:
        """
        OAuth Client ID. Required to allow OAuth between dbt Cloud and Snowflake
        """
        return pulumi.get(self, "oauth_client_id")

    @_builtins.property
    @pulumi.getter(name="oauthClientSecret")
    def oauth_client_secret(self) -> Optional[_builtins.str]:
        """
        OAuth Client Secret. Required to allow OAuth between dbt Cloud and Snowflake
        """
        return pulumi.get(self, "oauth_client_secret")

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[_builtins.str]:
        """
        The Snowflake role to use when running queries on the connection
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class GlobalConnectionStarburst(dict):
    def __init__(__self__, *,
                 host: _builtins.str,
                 method: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.str host: The hostname of the account to connect to.
        :param _builtins.str method: The authentication method. Only LDAP for now.
        :param _builtins.int port: The port to connect to for this connection. Default=443
        """
        pulumi.set(__self__, "host", host)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The hostname of the account to connect to.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[_builtins.str]:
        """
        The authentication method. Only LDAP for now.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port to connect to for this connection. Default=443
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GlobalConnectionSynapse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loginTimeout":
            suggest = "login_timeout"
        elif key == "queryTimeout":
            suggest = "query_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalConnectionSynapse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalConnectionSynapse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalConnectionSynapse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database: _builtins.str,
                 host: _builtins.str,
                 login_timeout: Optional[_builtins.int] = None,
                 port: Optional[_builtins.int] = None,
                 query_timeout: Optional[_builtins.int] = None,
                 retries: Optional[_builtins.int] = None):
        """
        :param _builtins.str database: The database to connect to for this connection.
        :param _builtins.str host: The server hostname.
        :param _builtins.int login_timeout: The number of seconds used to establish a connection before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        :param _builtins.int port: The port to connect to for this connection. Default=1433
        :param _builtins.int query_timeout: The number of seconds used to wait for a query before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        :param _builtins.int retries: The number of automatic times to retry a query before failing. Defaults to 1. Queries with syntax errors will not be retried. This setting can be used to overcome intermittent network issues.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "host", host)
        if login_timeout is not None:
            pulumi.set(__self__, "login_timeout", login_timeout)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if query_timeout is not None:
            pulumi.set(__self__, "query_timeout", query_timeout)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)

    @_builtins.property
    @pulumi.getter
    def database(self) -> _builtins.str:
        """
        The database to connect to for this connection.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The server hostname.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="loginTimeout")
    def login_timeout(self) -> Optional[_builtins.int]:
        """
        The number of seconds used to establish a connection before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        """
        return pulumi.get(self, "login_timeout")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port to connect to for this connection. Default=1433
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="queryTimeout")
    def query_timeout(self) -> Optional[_builtins.int]:
        """
        The number of seconds used to wait for a query before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        """
        return pulumi.get(self, "query_timeout")

    @_builtins.property
    @pulumi.getter
    def retries(self) -> Optional[_builtins.int]:
        """
        The number of automatic times to retry a query before failing. Defaults to 1. Queries with syntax errors will not be retried. This setting can be used to overcome intermittent network issues.
        """
        return pulumi.get(self, "retries")


@pulumi.output_type
class GlobalConnectionTeradata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requestTimeout":
            suggest = "request_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalConnectionTeradata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalConnectionTeradata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalConnectionTeradata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: _builtins.str,
                 tmode: _builtins.str,
                 port: Optional[_builtins.str] = None,
                 request_timeout: Optional[_builtins.int] = None,
                 retries: Optional[_builtins.int] = None):
        """
        :param _builtins.str host: The hostname of the database.
        :param _builtins.str tmode: The transaction mode to use for the connection.
        :param _builtins.str port: The port to connect to for this connection. Default=1025
        :param _builtins.int request_timeout: The number of seconds used to establish a connection before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        :param _builtins.int retries: The number of automatic times to retry a query before failing. Defaults to 1. Queries with syntax errors will not be retried. This setting can be used to overcome intermittent network issues.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "tmode", tmode)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The hostname of the database.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def tmode(self) -> _builtins.str:
        """
        The transaction mode to use for the connection.
        """
        return pulumi.get(self, "tmode")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.str]:
        """
        The port to connect to for this connection. Default=1025
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[_builtins.int]:
        """
        The number of seconds used to establish a connection before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        """
        return pulumi.get(self, "request_timeout")

    @_builtins.property
    @pulumi.getter
    def retries(self) -> Optional[_builtins.int]:
        """
        The number of automatic times to retry a query before failing. Defaults to 1. Queries with syntax errors will not be retried. This setting can be used to overcome intermittent network issues.
        """
        return pulumi.get(self, "retries")


@pulumi.output_type
class GroupGroupPermission(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allProjects":
            suggest = "all_projects"
        elif key == "permissionSet":
            suggest = "permission_set"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "writableEnvironmentCategories":
            suggest = "writable_environment_categories"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupGroupPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupGroupPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupGroupPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_projects: _builtins.bool,
                 permission_set: _builtins.str,
                 project_id: Optional[_builtins.int] = None,
                 writable_environment_categories: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.bool all_projects: Whether access should be provided for all projects or not.
        :param _builtins.str permission_set: Set of permissions to apply. The permissions allowed are the same as the ones for the `Group` resource.
        :param _builtins.int project_id: Project ID to apply this permission to for this group.
        :param Sequence[_builtins.str] writable_environment_categories: What types of environments to apply Write permissions to.
               Even if Write access is restricted to some environment types, the permission set will have Read access to all environments.
               The values allowed are `all`, `development`, `staging`, `production` and `other`.
               Not setting a value is the same as selecting `all`.
               Not all permission sets support environment level write settings, only `analyst`, `database_admin`, `developer`, `git_admin` and `team_admin`.
        """
        pulumi.set(__self__, "all_projects", all_projects)
        pulumi.set(__self__, "permission_set", permission_set)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if writable_environment_categories is not None:
            pulumi.set(__self__, "writable_environment_categories", writable_environment_categories)

    @_builtins.property
    @pulumi.getter(name="allProjects")
    def all_projects(self) -> _builtins.bool:
        """
        Whether access should be provided for all projects or not.
        """
        return pulumi.get(self, "all_projects")

    @_builtins.property
    @pulumi.getter(name="permissionSet")
    def permission_set(self) -> _builtins.str:
        """
        Set of permissions to apply. The permissions allowed are the same as the ones for the `Group` resource.
        """
        return pulumi.get(self, "permission_set")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.int]:
        """
        Project ID to apply this permission to for this group.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="writableEnvironmentCategories")
    def writable_environment_categories(self) -> Optional[Sequence[_builtins.str]]:
        """
        What types of environments to apply Write permissions to.
        Even if Write access is restricted to some environment types, the permission set will have Read access to all environments.
        The values allowed are `all`, `development`, `staging`, `production` and `other`.
        Not setting a value is the same as selecting `all`.
        Not all permission sets support environment level write settings, only `analyst`, `database_admin`, `developer`, `git_admin` and `team_admin`.
        """
        return pulumi.get(self, "writable_environment_categories")


@pulumi.output_type
class GroupPartialPermissionsGroupPermission(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allProjects":
            suggest = "all_projects"
        elif key == "permissionSet":
            suggest = "permission_set"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "writableEnvironmentCategories":
            suggest = "writable_environment_categories"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupPartialPermissionsGroupPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupPartialPermissionsGroupPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupPartialPermissionsGroupPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_projects: _builtins.bool,
                 permission_set: _builtins.str,
                 project_id: Optional[_builtins.int] = None,
                 writable_environment_categories: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.bool all_projects: Whether access should be provided for all projects or not.
        :param _builtins.str permission_set: Set of permissions to apply. The permissions allowed are the same as the ones for the `Group` resource.
        :param _builtins.int project_id: Project ID to apply this permission to for this group.
        :param Sequence[_builtins.str] writable_environment_categories: What types of environments to apply Write permissions to.
               Even if Write access is restricted to some environment types, the permission set will have Read access to all environments.
               The values allowed are `all`, `development`, `staging`, `production` and `other`.
               Not setting a value is the same as selecting `all`.
               Not all permission sets support environment level write settings, only `analyst`, `database_admin`, `developer`, `git_admin` and `team_admin`.
        """
        pulumi.set(__self__, "all_projects", all_projects)
        pulumi.set(__self__, "permission_set", permission_set)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if writable_environment_categories is not None:
            pulumi.set(__self__, "writable_environment_categories", writable_environment_categories)

    @_builtins.property
    @pulumi.getter(name="allProjects")
    def all_projects(self) -> _builtins.bool:
        """
        Whether access should be provided for all projects or not.
        """
        return pulumi.get(self, "all_projects")

    @_builtins.property
    @pulumi.getter(name="permissionSet")
    def permission_set(self) -> _builtins.str:
        """
        Set of permissions to apply. The permissions allowed are the same as the ones for the `Group` resource.
        """
        return pulumi.get(self, "permission_set")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.int]:
        """
        Project ID to apply this permission to for this group.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="writableEnvironmentCategories")
    def writable_environment_categories(self) -> Optional[Sequence[_builtins.str]]:
        """
        What types of environments to apply Write permissions to.
        Even if Write access is restricted to some environment types, the permission set will have Read access to all environments.
        The values allowed are `all`, `development`, `staging`, `production` and `other`.
        Not setting a value is the same as selecting `all`.
        Not all permission sets support environment level write settings, only `analyst`, `database_admin`, `developer`, `git_admin` and `team_admin`.
        """
        return pulumi.get(self, "writable_environment_categories")


@pulumi.output_type
class IpRestrictionsRuleCidr(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cidrIpv6":
            suggest = "cidr_ipv6"
        elif key == "ipRestrictionRuleId":
            suggest = "ip_restriction_rule_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpRestrictionsRuleCidr. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpRestrictionsRuleCidr.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpRestrictionsRuleCidr.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr: Optional[_builtins.str] = None,
                 cidr_ipv6: Optional[_builtins.str] = None,
                 id: Optional[_builtins.int] = None,
                 ip_restriction_rule_id: Optional[_builtins.int] = None):
        """
        :param _builtins.str cidr: IP CIDR range (can be IPv4 or IPv6)
        :param _builtins.str cidr_ipv6: IPv6 CIDR range (read-only)
        :param _builtins.int id: ID of the CIDR range
        :param _builtins.int ip_restriction_rule_id: ID of the IP restriction rule
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if cidr_ipv6 is not None:
            pulumi.set(__self__, "cidr_ipv6", cidr_ipv6)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_restriction_rule_id is not None:
            pulumi.set(__self__, "ip_restriction_rule_id", ip_restriction_rule_id)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> Optional[_builtins.str]:
        """
        IP CIDR range (can be IPv4 or IPv6)
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter(name="cidrIpv6")
    def cidr_ipv6(self) -> Optional[_builtins.str]:
        """
        IPv6 CIDR range (read-only)
        """
        return pulumi.get(self, "cidr_ipv6")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.int]:
        """
        ID of the CIDR range
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipRestrictionRuleId")
    def ip_restriction_rule_id(self) -> Optional[_builtins.int]:
        """
        ID of the IP restriction rule
        """
        return pulumi.get(self, "ip_restriction_rule_id")


@pulumi.output_type
class JobJobCompletionTriggerCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobId":
            suggest = "job_id"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobJobCompletionTriggerCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobJobCompletionTriggerCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobJobCompletionTriggerCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_id: _builtins.int,
                 project_id: _builtins.int,
                 statuses: Sequence[_builtins.str]):
        """
        :param _builtins.int job_id: The ID of the job that would trigger this job after completion.
        :param _builtins.int project_id: The ID of the project where the trigger job is running in.
        :param Sequence[_builtins.str] statuses: List of statuses to trigger the job on. Possible values are `success`, `error` and `canceled`.
        """
        pulumi.set(__self__, "job_id", job_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "statuses", statuses)

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> _builtins.int:
        """
        The ID of the job that would trigger this job after completion.
        """
        return pulumi.get(self, "job_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.int:
        """
        The ID of the project where the trigger job is running in.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> Sequence[_builtins.str]:
        """
        List of statuses to trigger the job on. Possible values are `success`, `error` and `canceled`.
        """
        return pulumi.get(self, "statuses")


@pulumi.output_type
class JobTriggers(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gitProviderWebhook":
            suggest = "git_provider_webhook"
        elif key == "githubWebhook":
            suggest = "github_webhook"
        elif key == "onMerge":
            suggest = "on_merge"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTriggers. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTriggers.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTriggers.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 git_provider_webhook: Optional[_builtins.bool] = None,
                 github_webhook: Optional[_builtins.bool] = None,
                 on_merge: Optional[_builtins.bool] = None,
                 schedule: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool git_provider_webhook: Whether the job runs automatically on PR creation
        :param _builtins.bool github_webhook: Whether the job runs automatically on PR creation
        :param _builtins.bool on_merge: Whether the job runs automatically once a PR is merged
        :param _builtins.bool schedule: Whether the job runs on a schedule
        """
        if git_provider_webhook is not None:
            pulumi.set(__self__, "git_provider_webhook", git_provider_webhook)
        if github_webhook is not None:
            pulumi.set(__self__, "github_webhook", github_webhook)
        if on_merge is not None:
            pulumi.set(__self__, "on_merge", on_merge)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @_builtins.property
    @pulumi.getter(name="gitProviderWebhook")
    def git_provider_webhook(self) -> Optional[_builtins.bool]:
        """
        Whether the job runs automatically on PR creation
        """
        return pulumi.get(self, "git_provider_webhook")

    @_builtins.property
    @pulumi.getter(name="githubWebhook")
    def github_webhook(self) -> Optional[_builtins.bool]:
        """
        Whether the job runs automatically on PR creation
        """
        return pulumi.get(self, "github_webhook")

    @_builtins.property
    @pulumi.getter(name="onMerge")
    def on_merge(self) -> Optional[_builtins.bool]:
        """
        Whether the job runs automatically once a PR is merged
        """
        return pulumi.get(self, "on_merge")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[_builtins.bool]:
        """
        Whether the job runs on a schedule
        """
        return pulumi.get(self, "schedule")


@pulumi.output_type
class PostgresSemanticLayerCredentialConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adapterVersion":
            suggest = "adapter_version"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PostgresSemanticLayerCredentialConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PostgresSemanticLayerCredentialConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PostgresSemanticLayerCredentialConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 adapter_version: _builtins.str,
                 name: _builtins.str,
                 project_id: _builtins.int):
        """
        :param _builtins.str adapter_version: The adapter version
        :param _builtins.str name: The name of the configuration
        :param _builtins.int project_id: The ID of the project
        """
        pulumi.set(__self__, "adapter_version", adapter_version)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter(name="adapterVersion")
    def adapter_version(self) -> _builtins.str:
        """
        The adapter version
        """
        return pulumi.get(self, "adapter_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the configuration
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.int:
        """
        The ID of the project
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class PostgresSemanticLayerCredentialCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"
        elif key == "credentialId":
            suggest = "credential_id"
        elif key == "defaultSchema":
            suggest = "default_schema"
        elif key == "isActive":
            suggest = "is_active"
        elif key == "numThreads":
            suggest = "num_threads"
        elif key == "semanticLayerCredential":
            suggest = "semantic_layer_credential"
        elif key == "targetName":
            suggest = "target_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PostgresSemanticLayerCredentialCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PostgresSemanticLayerCredentialCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PostgresSemanticLayerCredentialCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project_id: _builtins.int,
                 username: _builtins.str,
                 credential_id: Optional[_builtins.int] = None,
                 default_schema: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 is_active: Optional[_builtins.bool] = None,
                 num_threads: Optional[_builtins.int] = None,
                 password: Optional[_builtins.str] = None,
                 semantic_layer_credential: Optional[_builtins.bool] = None,
                 target_name: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.int project_id: Project ID to create the Postgres/Redshift/AlloyDB credential in.
        :param _builtins.str username: Username for Postgres/Redshift/AlloyDB
        :param _builtins.int credential_id: The system Postgres/Redshift/AlloyDB credential ID.
        :param _builtins.str default_schema: Default schema name. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        :param _builtins.str id: The ID of this resource. Contains the project ID and the credential ID.
        :param _builtins.bool is_active: Whether the Postgres/Redshift/AlloyDB credential is active
        :param _builtins.int num_threads: Number of threads to use (required for Redshift)
        :param _builtins.str password: Password for Postgres/Redshift/AlloyDB
        :param _builtins.bool semantic_layer_credential: This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Postgres credential for the Semantic Layer.
        :param _builtins.str target_name: Default schema name
        :param _builtins.str type: Type of connection. One of (postgres/redshift). Use postgres for alloydb connections. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "username", username)
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if default_schema is not None:
            pulumi.set(__self__, "default_schema", default_schema)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if num_threads is not None:
            pulumi.set(__self__, "num_threads", num_threads)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if semantic_layer_credential is not None:
            pulumi.set(__self__, "semantic_layer_credential", semantic_layer_credential)
        if target_name is not None:
            pulumi.set(__self__, "target_name", target_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.int:
        """
        Project ID to create the Postgres/Redshift/AlloyDB credential in.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        Username for Postgres/Redshift/AlloyDB
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[_builtins.int]:
        """
        The system Postgres/Redshift/AlloyDB credential ID.
        """
        return pulumi.get(self, "credential_id")

    @_builtins.property
    @pulumi.getter(name="defaultSchema")
    def default_schema(self) -> Optional[_builtins.str]:
        """
        Default schema name. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        """
        return pulumi.get(self, "default_schema")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of this resource. Contains the project ID and the credential ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[_builtins.bool]:
        """
        Whether the Postgres/Redshift/AlloyDB credential is active
        """
        return pulumi.get(self, "is_active")

    @_builtins.property
    @pulumi.getter(name="numThreads")
    def num_threads(self) -> Optional[_builtins.int]:
        """
        Number of threads to use (required for Redshift)
        """
        return pulumi.get(self, "num_threads")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        Password for Postgres/Redshift/AlloyDB
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="semanticLayerCredential")
    def semantic_layer_credential(self) -> Optional[_builtins.bool]:
        """
        This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Postgres credential for the Semantic Layer.
        """
        return pulumi.get(self, "semantic_layer_credential")

    @_builtins.property
    @pulumi.getter(name="targetName")
    def target_name(self) -> Optional[_builtins.str]:
        """
        Default schema name
        """
        return pulumi.get(self, "target_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of connection. One of (postgres/redshift). Use postgres for alloydb connections. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RedshiftSemanticLayerCredentialConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adapterVersion":
            suggest = "adapter_version"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RedshiftSemanticLayerCredentialConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RedshiftSemanticLayerCredentialConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RedshiftSemanticLayerCredentialConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 adapter_version: _builtins.str,
                 name: _builtins.str,
                 project_id: _builtins.int):
        """
        :param _builtins.str adapter_version: The adapter version
        :param _builtins.str name: The name of the configuration
        :param _builtins.int project_id: The ID of the project
        """
        pulumi.set(__self__, "adapter_version", adapter_version)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter(name="adapterVersion")
    def adapter_version(self) -> _builtins.str:
        """
        The adapter version
        """
        return pulumi.get(self, "adapter_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the configuration
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.int:
        """
        The ID of the project
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class RedshiftSemanticLayerCredentialCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultSchema":
            suggest = "default_schema"
        elif key == "numThreads":
            suggest = "num_threads"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "credentialId":
            suggest = "credential_id"
        elif key == "isActive":
            suggest = "is_active"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RedshiftSemanticLayerCredentialCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RedshiftSemanticLayerCredentialCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RedshiftSemanticLayerCredentialCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_schema: _builtins.str,
                 num_threads: _builtins.int,
                 project_id: _builtins.int,
                 credential_id: Optional[_builtins.int] = None,
                 id: Optional[_builtins.str] = None,
                 is_active: Optional[_builtins.bool] = None,
                 password: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.str default_schema: Default schema name
        :param _builtins.int num_threads: Number of threads to use
        :param _builtins.int project_id: Project ID to create the Redshift credential in
        :param _builtins.int credential_id: The internal credential ID
        :param _builtins.str id: The ID of this resource. Contains the project ID and the credential ID.
        :param _builtins.bool is_active: Whether the Redshift credential is active
        :param _builtins.str password: The password for the Redshift account
        :param _builtins.str username: The username for the Redshift account.
        """
        pulumi.set(__self__, "default_schema", default_schema)
        pulumi.set(__self__, "num_threads", num_threads)
        pulumi.set(__self__, "project_id", project_id)
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="defaultSchema")
    def default_schema(self) -> _builtins.str:
        """
        Default schema name
        """
        return pulumi.get(self, "default_schema")

    @_builtins.property
    @pulumi.getter(name="numThreads")
    def num_threads(self) -> _builtins.int:
        """
        Number of threads to use
        """
        return pulumi.get(self, "num_threads")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.int:
        """
        Project ID to create the Redshift credential in
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[_builtins.int]:
        """
        The internal credential ID
        """
        return pulumi.get(self, "credential_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of this resource. Contains the project ID and the credential ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[_builtins.bool]:
        """
        Whether the Redshift credential is active
        """
        return pulumi.get(self, "is_active")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The password for the Redshift account
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The username for the Redshift account.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ScimGroupPermissionsPermission(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allProjects":
            suggest = "all_projects"
        elif key == "permissionSet":
            suggest = "permission_set"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "writableEnvironmentCategories":
            suggest = "writable_environment_categories"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScimGroupPermissionsPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScimGroupPermissionsPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScimGroupPermissionsPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_projects: _builtins.bool,
                 permission_set: _builtins.str,
                 project_id: Optional[_builtins.int] = None,
                 writable_environment_categories: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.bool all_projects: Whether access should be provided for all projects or not.
        :param _builtins.str permission_set: Set of permissions to apply. The permissions allowed are the same as the ones for the `Group` resource.
        :param _builtins.int project_id: Project ID to apply this permission to for this group.
        :param Sequence[_builtins.str] writable_environment_categories: What types of environments to apply Write permissions to.
               Even if Write access is restricted to some environment types, the permission set will have Read access to all environments.
               The values allowed are `all`, `development`, `staging`, `production` and `other`.
               Not setting a value is the same as selecting `all`.
               Not all permission sets support environment level write settings, only `analyst`, `database_admin`, `developer`, `git_admin` and `team_admin`.
        """
        pulumi.set(__self__, "all_projects", all_projects)
        pulumi.set(__self__, "permission_set", permission_set)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if writable_environment_categories is not None:
            pulumi.set(__self__, "writable_environment_categories", writable_environment_categories)

    @_builtins.property
    @pulumi.getter(name="allProjects")
    def all_projects(self) -> _builtins.bool:
        """
        Whether access should be provided for all projects or not.
        """
        return pulumi.get(self, "all_projects")

    @_builtins.property
    @pulumi.getter(name="permissionSet")
    def permission_set(self) -> _builtins.str:
        """
        Set of permissions to apply. The permissions allowed are the same as the ones for the `Group` resource.
        """
        return pulumi.get(self, "permission_set")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.int]:
        """
        Project ID to apply this permission to for this group.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="writableEnvironmentCategories")
    def writable_environment_categories(self) -> Optional[Sequence[_builtins.str]]:
        """
        What types of environments to apply Write permissions to.
        Even if Write access is restricted to some environment types, the permission set will have Read access to all environments.
        The values allowed are `all`, `development`, `staging`, `production` and `other`.
        Not setting a value is the same as selecting `all`.
        Not all permission sets support environment level write settings, only `analyst`, `database_admin`, `developer`, `git_admin` and `team_admin`.
        """
        return pulumi.get(self, "writable_environment_categories")


@pulumi.output_type
class ServiceTokenServiceTokenPermission(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allProjects":
            suggest = "all_projects"
        elif key == "permissionSet":
            suggest = "permission_set"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "writableEnvironmentCategories":
            suggest = "writable_environment_categories"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTokenServiceTokenPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTokenServiceTokenPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTokenServiceTokenPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_projects: _builtins.bool,
                 permission_set: _builtins.str,
                 project_id: Optional[_builtins.int] = None,
                 writable_environment_categories: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.bool all_projects: Whether or not to apply this permission to all projects for this service token
        :param _builtins.str permission_set: Set of permissions to apply
        :param _builtins.int project_id: Project ID to apply this permission to for this service token
        :param Sequence[_builtins.str] writable_environment_categories: What types of environments to apply Write permissions to.
               Even if Write access is restricted to some environment types, the permission set will have Read access to all environments.
               The values allowed are `all`, `development`, `staging`, `production` and `other`.
               Not setting a value is the same as selecting `all`.
               Not all permission sets support environment level write settings, only `analyst`, `database_admin`, `developer`, `git_admin` and `team_admin`.
        """
        pulumi.set(__self__, "all_projects", all_projects)
        pulumi.set(__self__, "permission_set", permission_set)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if writable_environment_categories is not None:
            pulumi.set(__self__, "writable_environment_categories", writable_environment_categories)

    @_builtins.property
    @pulumi.getter(name="allProjects")
    def all_projects(self) -> _builtins.bool:
        """
        Whether or not to apply this permission to all projects for this service token
        """
        return pulumi.get(self, "all_projects")

    @_builtins.property
    @pulumi.getter(name="permissionSet")
    def permission_set(self) -> _builtins.str:
        """
        Set of permissions to apply
        """
        return pulumi.get(self, "permission_set")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.int]:
        """
        Project ID to apply this permission to for this service token
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="writableEnvironmentCategories")
    def writable_environment_categories(self) -> Optional[Sequence[_builtins.str]]:
        """
        What types of environments to apply Write permissions to.
        Even if Write access is restricted to some environment types, the permission set will have Read access to all environments.
        The values allowed are `all`, `development`, `staging`, `production` and `other`.
        Not setting a value is the same as selecting `all`.
        Not all permission sets support environment level write settings, only `analyst`, `database_admin`, `developer`, `git_admin` and `team_admin`.
        """
        return pulumi.get(self, "writable_environment_categories")


@pulumi.output_type
class SnowflakeSemanticLayerCredentialConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adapterVersion":
            suggest = "adapter_version"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SnowflakeSemanticLayerCredentialConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SnowflakeSemanticLayerCredentialConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SnowflakeSemanticLayerCredentialConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 adapter_version: _builtins.str,
                 name: _builtins.str,
                 project_id: _builtins.int):
        """
        :param _builtins.str adapter_version: The adapter version
        :param _builtins.str name: The name of the configuration
        :param _builtins.int project_id: The ID of the project
        """
        pulumi.set(__self__, "adapter_version", adapter_version)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter(name="adapterVersion")
    def adapter_version(self) -> _builtins.str:
        """
        The adapter version
        """
        return pulumi.get(self, "adapter_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the configuration
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.int:
        """
        The ID of the project
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class SnowflakeSemanticLayerCredentialCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"
        elif key == "numThreads":
            suggest = "num_threads"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "credentialId":
            suggest = "credential_id"
        elif key == "isActive":
            suggest = "is_active"
        elif key == "privateKey":
            suggest = "private_key"
        elif key == "privateKeyPassphrase":
            suggest = "private_key_passphrase"
        elif key == "semanticLayerCredential":
            suggest = "semantic_layer_credential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SnowflakeSemanticLayerCredentialCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SnowflakeSemanticLayerCredentialCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SnowflakeSemanticLayerCredentialCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: _builtins.str,
                 num_threads: _builtins.int,
                 project_id: _builtins.int,
                 credential_id: Optional[_builtins.int] = None,
                 database: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 is_active: Optional[_builtins.bool] = None,
                 password: Optional[_builtins.str] = None,
                 private_key: Optional[_builtins.str] = None,
                 private_key_passphrase: Optional[_builtins.str] = None,
                 role: Optional[_builtins.str] = None,
                 schema: Optional[_builtins.str] = None,
                 semantic_layer_credential: Optional[_builtins.bool] = None,
                 user: Optional[_builtins.str] = None,
                 warehouse: Optional[_builtins.str] = None):
        """
        :param _builtins.str auth_type: The type of Snowflake credential ('password' or 'keypair')
        :param _builtins.int num_threads: Number of threads to use
        :param _builtins.int project_id: Project ID to create the Snowflake credential in
        :param _builtins.int credential_id: The internal credential ID
        :param _builtins.str database: The catalog to connect use
        :param _builtins.str id: The ID of this resource. Contains the project ID and the credential ID.
        :param _builtins.bool is_active: Whether the Snowflake credential is active
        :param _builtins.str password: The password for the Snowflake account
        :param _builtins.str private_key: The private key for the Snowflake account
        :param _builtins.str private_key_passphrase: The passphrase for the private key
        :param _builtins.str role: The role to assume
        :param _builtins.str schema: The schema where to create models. This is an optional field ONLY if the credential is used for Semantic Layer configuration, otherwise it is required.
        :param _builtins.bool semantic_layer_credential: This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Snowflake credential for the Semantic Layer.
        :param _builtins.str user: The username for the Snowflake account. This is an optional field ONLY if the credential is used for Semantic Layer configuration, otherwise it is required.
        :param _builtins.str warehouse: The warehouse to use
        """
        pulumi.set(__self__, "auth_type", auth_type)
        pulumi.set(__self__, "num_threads", num_threads)
        pulumi.set(__self__, "project_id", project_id)
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_passphrase is not None:
            pulumi.set(__self__, "private_key_passphrase", private_key_passphrase)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if semantic_layer_credential is not None:
            pulumi.set(__self__, "semantic_layer_credential", semantic_layer_credential)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if warehouse is not None:
            pulumi.set(__self__, "warehouse", warehouse)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> _builtins.str:
        """
        The type of Snowflake credential ('password' or 'keypair')
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter(name="numThreads")
    def num_threads(self) -> _builtins.int:
        """
        Number of threads to use
        """
        return pulumi.get(self, "num_threads")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.int:
        """
        Project ID to create the Snowflake credential in
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[_builtins.int]:
        """
        The internal credential ID
        """
        return pulumi.get(self, "credential_id")

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[_builtins.str]:
        """
        The catalog to connect use
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of this resource. Contains the project ID and the credential ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[_builtins.bool]:
        """
        Whether the Snowflake credential is active
        """
        return pulumi.get(self, "is_active")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The password for the Snowflake account
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[_builtins.str]:
        """
        The private key for the Snowflake account
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="privateKeyPassphrase")
    def private_key_passphrase(self) -> Optional[_builtins.str]:
        """
        The passphrase for the private key
        """
        return pulumi.get(self, "private_key_passphrase")

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[_builtins.str]:
        """
        The role to assume
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[_builtins.str]:
        """
        The schema where to create models. This is an optional field ONLY if the credential is used for Semantic Layer configuration, otherwise it is required.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="semanticLayerCredential")
    def semantic_layer_credential(self) -> Optional[_builtins.bool]:
        """
        This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Snowflake credential for the Semantic Layer.
        """
        return pulumi.get(self, "semantic_layer_credential")

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[_builtins.str]:
        """
        The username for the Snowflake account. This is an optional field ONLY if the credential is used for Semantic Layer configuration, otherwise it is required.
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter
    def warehouse(self) -> Optional[_builtins.str]:
        """
        The warehouse to use
        """
        return pulumi.get(self, "warehouse")


@pulumi.output_type
class GetEnvironmentsEnvironmentResult(dict):
    def __init__(__self__, *,
                 connection_id: _builtins.int,
                 credentials_id: _builtins.int,
                 custom_branch: _builtins.str,
                 dbt_version: _builtins.str,
                 deployment_type: _builtins.str,
                 enable_model_query_history: _builtins.bool,
                 environment_id: _builtins.int,
                 extended_attributes_id: _builtins.int,
                 name: _builtins.str,
                 project_id: _builtins.int,
                 type: _builtins.str,
                 use_custom_branch: _builtins.bool):
        """
        :param _builtins.int connection_id: A connection ID (used with Global Connections)
        :param _builtins.int credentials_id: Credential ID for this environment. A credential is not required for development environments, as dbt Cloud defaults to the user's credentials, but deployment environments will have this.
        :param _builtins.str custom_branch: The custom branch name to use
        :param _builtins.str dbt_version: Version number of dbt to use in this environment.
        :param _builtins.str deployment_type: The type of deployment environment (currently 'production', 'staging' or empty)
        :param _builtins.bool enable_model_query_history: Whether model query history is on
        :param _builtins.int environment_id: The ID of the environment
        :param _builtins.int extended_attributes_id: The ID of the extended attributes applied
        :param _builtins.str name: The name of the environment
        :param _builtins.int project_id: The project ID to which the environment belong
        :param _builtins.str type: The type of environment (must be either development or deployment)
        :param _builtins.bool use_custom_branch: Whether to use a custom git branch in this environment
        """
        pulumi.set(__self__, "connection_id", connection_id)
        pulumi.set(__self__, "credentials_id", credentials_id)
        pulumi.set(__self__, "custom_branch", custom_branch)
        pulumi.set(__self__, "dbt_version", dbt_version)
        pulumi.set(__self__, "deployment_type", deployment_type)
        pulumi.set(__self__, "enable_model_query_history", enable_model_query_history)
        pulumi.set(__self__, "environment_id", environment_id)
        pulumi.set(__self__, "extended_attributes_id", extended_attributes_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "use_custom_branch", use_custom_branch)

    @_builtins.property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> _builtins.int:
        """
        A connection ID (used with Global Connections)
        """
        return pulumi.get(self, "connection_id")

    @_builtins.property
    @pulumi.getter(name="credentialsId")
    def credentials_id(self) -> _builtins.int:
        """
        Credential ID for this environment. A credential is not required for development environments, as dbt Cloud defaults to the user's credentials, but deployment environments will have this.
        """
        return pulumi.get(self, "credentials_id")

    @_builtins.property
    @pulumi.getter(name="customBranch")
    def custom_branch(self) -> _builtins.str:
        """
        The custom branch name to use
        """
        return pulumi.get(self, "custom_branch")

    @_builtins.property
    @pulumi.getter(name="dbtVersion")
    def dbt_version(self) -> _builtins.str:
        """
        Version number of dbt to use in this environment.
        """
        return pulumi.get(self, "dbt_version")

    @_builtins.property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> _builtins.str:
        """
        The type of deployment environment (currently 'production', 'staging' or empty)
        """
        return pulumi.get(self, "deployment_type")

    @_builtins.property
    @pulumi.getter(name="enableModelQueryHistory")
    def enable_model_query_history(self) -> _builtins.bool:
        """
        Whether model query history is on
        """
        return pulumi.get(self, "enable_model_query_history")

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> _builtins.int:
        """
        The ID of the environment
        """
        return pulumi.get(self, "environment_id")

    @_builtins.property
    @pulumi.getter(name="extendedAttributesId")
    def extended_attributes_id(self) -> _builtins.int:
        """
        The ID of the extended attributes applied
        """
        return pulumi.get(self, "extended_attributes_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the environment
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.int:
        """
        The project ID to which the environment belong
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of environment (must be either development or deployment)
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="useCustomBranch")
    def use_custom_branch(self) -> _builtins.bool:
        """
        Whether to use a custom git branch in this environment
        """
        return pulumi.get(self, "use_custom_branch")


@pulumi.output_type
class GetGlobalConnectionApacheSparkResult(dict):
    def __init__(__self__, *,
                 auth: _builtins.str,
                 cluster: _builtins.str,
                 connect_retries: _builtins.int,
                 connect_timeout: _builtins.int,
                 host: _builtins.str,
                 method: _builtins.str,
                 organization: _builtins.str,
                 port: _builtins.int,
                 user: _builtins.str):
        """
        :param _builtins.str auth: Auth
        :param _builtins.str cluster: Spark cluster for the connection
        :param _builtins.int connect_retries: Connection retries. Default=0
        :param _builtins.int connect_timeout: Connection time out in seconds. Default=10
        :param _builtins.str host: Hostname of the connection
        :param _builtins.str method: Authentication method for the connection (http or thrift).
        :param _builtins.str organization: Organization ID
        :param _builtins.int port: Port for the connection. Default=443
        :param _builtins.str user: User
        """
        pulumi.set(__self__, "auth", auth)
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "connect_retries", connect_retries)
        pulumi.set(__self__, "connect_timeout", connect_timeout)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter
    def auth(self) -> _builtins.str:
        """
        Auth
        """
        return pulumi.get(self, "auth")

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> _builtins.str:
        """
        Spark cluster for the connection
        """
        return pulumi.get(self, "cluster")

    @_builtins.property
    @pulumi.getter(name="connectRetries")
    def connect_retries(self) -> _builtins.int:
        """
        Connection retries. Default=0
        """
        return pulumi.get(self, "connect_retries")

    @_builtins.property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> _builtins.int:
        """
        Connection time out in seconds. Default=10
        """
        return pulumi.get(self, "connect_timeout")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        Hostname of the connection
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        Authentication method for the connection (http or thrift).
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> _builtins.str:
        """
        Organization ID
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port for the connection. Default=443
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        User
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class GetGlobalConnectionAthenaResult(dict):
    def __init__(__self__, *,
                 database: _builtins.str,
                 num_boto3_retries: _builtins.int,
                 num_iceberg_retries: _builtins.int,
                 num_retries: _builtins.int,
                 poll_interval: _builtins.int,
                 region_name: _builtins.str,
                 s3_data_dir: _builtins.str,
                 s3_data_naming: _builtins.str,
                 s3_staging_dir: _builtins.str,
                 s3_tmp_table_dir: _builtins.str,
                 spark_work_group: _builtins.str,
                 work_group: _builtins.str):
        """
        :param _builtins.str database: Specify the database (data catalog) to build models into (lowercase only).
        :param _builtins.int num_boto3_retries: Number of times to retry boto3 requests (e.g. deleting S3 files for materialized tables).
        :param _builtins.int num_iceberg_retries: Number of times to retry iceberg commit queries to fix ICEBERG*COMMIT*ERROR.
        :param _builtins.int num_retries: Number of times to retry a failing query.
        :param _builtins.int poll_interval: Interval in seconds to use for polling the status of query results in Athena.
        :param _builtins.str region_name: AWS region of your Athena instance.
        :param _builtins.str s3_data_dir: Prefix for storing tables, if different from the connection's S3 staging directory.
        :param _builtins.str s3_data_naming: How to generate table paths in the S3 data directory.
        :param _builtins.str s3_staging_dir: S3 location to store Athena query results and metadata.
        :param _builtins.str s3_tmp_table_dir: Prefix for storing temporary tables, if different from the connection's S3 data directory.
        :param _builtins.str spark_work_group: Identifier of Athena Spark workgroup for running Python models.
        :param _builtins.str work_group: Identifier of Athena workgroup.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "num_boto3_retries", num_boto3_retries)
        pulumi.set(__self__, "num_iceberg_retries", num_iceberg_retries)
        pulumi.set(__self__, "num_retries", num_retries)
        pulumi.set(__self__, "poll_interval", poll_interval)
        pulumi.set(__self__, "region_name", region_name)
        pulumi.set(__self__, "s3_data_dir", s3_data_dir)
        pulumi.set(__self__, "s3_data_naming", s3_data_naming)
        pulumi.set(__self__, "s3_staging_dir", s3_staging_dir)
        pulumi.set(__self__, "s3_tmp_table_dir", s3_tmp_table_dir)
        pulumi.set(__self__, "spark_work_group", spark_work_group)
        pulumi.set(__self__, "work_group", work_group)

    @_builtins.property
    @pulumi.getter
    def database(self) -> _builtins.str:
        """
        Specify the database (data catalog) to build models into (lowercase only).
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter(name="numBoto3Retries")
    def num_boto3_retries(self) -> _builtins.int:
        """
        Number of times to retry boto3 requests (e.g. deleting S3 files for materialized tables).
        """
        return pulumi.get(self, "num_boto3_retries")

    @_builtins.property
    @pulumi.getter(name="numIcebergRetries")
    def num_iceberg_retries(self) -> _builtins.int:
        """
        Number of times to retry iceberg commit queries to fix ICEBERG*COMMIT*ERROR.
        """
        return pulumi.get(self, "num_iceberg_retries")

    @_builtins.property
    @pulumi.getter(name="numRetries")
    def num_retries(self) -> _builtins.int:
        """
        Number of times to retry a failing query.
        """
        return pulumi.get(self, "num_retries")

    @_builtins.property
    @pulumi.getter(name="pollInterval")
    def poll_interval(self) -> _builtins.int:
        """
        Interval in seconds to use for polling the status of query results in Athena.
        """
        return pulumi.get(self, "poll_interval")

    @_builtins.property
    @pulumi.getter(name="regionName")
    def region_name(self) -> _builtins.str:
        """
        AWS region of your Athena instance.
        """
        return pulumi.get(self, "region_name")

    @_builtins.property
    @pulumi.getter(name="s3DataDir")
    def s3_data_dir(self) -> _builtins.str:
        """
        Prefix for storing tables, if different from the connection's S3 staging directory.
        """
        return pulumi.get(self, "s3_data_dir")

    @_builtins.property
    @pulumi.getter(name="s3DataNaming")
    def s3_data_naming(self) -> _builtins.str:
        """
        How to generate table paths in the S3 data directory.
        """
        return pulumi.get(self, "s3_data_naming")

    @_builtins.property
    @pulumi.getter(name="s3StagingDir")
    def s3_staging_dir(self) -> _builtins.str:
        """
        S3 location to store Athena query results and metadata.
        """
        return pulumi.get(self, "s3_staging_dir")

    @_builtins.property
    @pulumi.getter(name="s3TmpTableDir")
    def s3_tmp_table_dir(self) -> _builtins.str:
        """
        Prefix for storing temporary tables, if different from the connection's S3 data directory.
        """
        return pulumi.get(self, "s3_tmp_table_dir")

    @_builtins.property
    @pulumi.getter(name="sparkWorkGroup")
    def spark_work_group(self) -> _builtins.str:
        """
        Identifier of Athena Spark workgroup for running Python models.
        """
        return pulumi.get(self, "spark_work_group")

    @_builtins.property
    @pulumi.getter(name="workGroup")
    def work_group(self) -> _builtins.str:
        """
        Identifier of Athena workgroup.
        """
        return pulumi.get(self, "work_group")


@pulumi.output_type
class GetGlobalConnectionBigqueryResult(dict):
    def __init__(__self__, *,
                 application_id: _builtins.str,
                 application_secret: _builtins.str,
                 auth_provider_x509_cert_url: _builtins.str,
                 auth_uri: _builtins.str,
                 client_email: _builtins.str,
                 client_id: _builtins.str,
                 client_x509_cert_url: _builtins.str,
                 dataproc_cluster_name: _builtins.str,
                 dataproc_region: _builtins.str,
                 execution_project: _builtins.str,
                 gcp_project_id: _builtins.str,
                 gcs_bucket: _builtins.str,
                 impersonate_service_account: _builtins.str,
                 job_creation_timeout_seconds: _builtins.int,
                 job_retry_deadline_seconds: _builtins.int,
                 location: _builtins.str,
                 maximum_bytes_billed: _builtins.int,
                 priority: _builtins.str,
                 private_key: _builtins.str,
                 private_key_id: _builtins.str,
                 retries: _builtins.int,
                 scopes: Sequence[_builtins.str],
                 timeout_seconds: _builtins.int,
                 token_uri: _builtins.str):
        """
        :param _builtins.str application_id: OAuth Client ID
        :param _builtins.str application_secret: OAuth Client Secret
        :param _builtins.str auth_provider_x509_cert_url: Auth Provider X509 Cert URL for the Service Account
        :param _builtins.str auth_uri: Auth URI for the Service Account
        :param _builtins.str client_email: Service Account email
        :param _builtins.str client_id: Client ID of the Service Account
        :param _builtins.str client_x509_cert_url: Client X509 Cert URL for the Service Account
        :param _builtins.str dataproc_cluster_name: Dataproc cluster name for PySpark workloads
        :param _builtins.str dataproc_region: Google Cloud region for PySpark workloads on Dataproc
        :param _builtins.str execution_project: Project to bill for query execution
        :param _builtins.str gcp_project_id: The GCP project ID to use for the connection
        :param _builtins.str gcs_bucket: URI for a Google Cloud Storage bucket to host Python code executed via Datapro
        :param _builtins.str impersonate_service_account: Service Account to impersonate when running queries
        :param _builtins.int job_creation_timeout_seconds: Maximum timeout for the job creation step
        :param _builtins.int job_retry_deadline_seconds: Total number of seconds to wait while retrying the same query
        :param _builtins.str location: Location to create new Datasets in
        :param _builtins.int maximum_bytes_billed: Max number of bytes that can be billed for a given BigQuery query
        :param _builtins.str priority: The priority with which to execute BigQuery queries (batch or interactive)
        :param _builtins.str private_key: Private Key for the Service Account
        :param _builtins.str private_key_id: Private Key ID for the Service Account
        :param _builtins.int retries: Number of retries for queries
        :param Sequence[_builtins.str] scopes: OAuth scopes for the BigQuery connection
        :param _builtins.int timeout_seconds: Timeout in seconds for queries
        :param _builtins.str token_uri: Token URI for the Service Account
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "application_secret", application_secret)
        pulumi.set(__self__, "auth_provider_x509_cert_url", auth_provider_x509_cert_url)
        pulumi.set(__self__, "auth_uri", auth_uri)
        pulumi.set(__self__, "client_email", client_email)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_x509_cert_url", client_x509_cert_url)
        pulumi.set(__self__, "dataproc_cluster_name", dataproc_cluster_name)
        pulumi.set(__self__, "dataproc_region", dataproc_region)
        pulumi.set(__self__, "execution_project", execution_project)
        pulumi.set(__self__, "gcp_project_id", gcp_project_id)
        pulumi.set(__self__, "gcs_bucket", gcs_bucket)
        pulumi.set(__self__, "impersonate_service_account", impersonate_service_account)
        pulumi.set(__self__, "job_creation_timeout_seconds", job_creation_timeout_seconds)
        pulumi.set(__self__, "job_retry_deadline_seconds", job_retry_deadline_seconds)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "maximum_bytes_billed", maximum_bytes_billed)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "private_key_id", private_key_id)
        pulumi.set(__self__, "retries", retries)
        pulumi.set(__self__, "scopes", scopes)
        pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        pulumi.set(__self__, "token_uri", token_uri)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> _builtins.str:
        """
        OAuth Client ID
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="applicationSecret")
    def application_secret(self) -> _builtins.str:
        """
        OAuth Client Secret
        """
        return pulumi.get(self, "application_secret")

    @_builtins.property
    @pulumi.getter(name="authProviderX509CertUrl")
    def auth_provider_x509_cert_url(self) -> _builtins.str:
        """
        Auth Provider X509 Cert URL for the Service Account
        """
        return pulumi.get(self, "auth_provider_x509_cert_url")

    @_builtins.property
    @pulumi.getter(name="authUri")
    def auth_uri(self) -> _builtins.str:
        """
        Auth URI for the Service Account
        """
        return pulumi.get(self, "auth_uri")

    @_builtins.property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> _builtins.str:
        """
        Service Account email
        """
        return pulumi.get(self, "client_email")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        Client ID of the Service Account
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientX509CertUrl")
    def client_x509_cert_url(self) -> _builtins.str:
        """
        Client X509 Cert URL for the Service Account
        """
        return pulumi.get(self, "client_x509_cert_url")

    @_builtins.property
    @pulumi.getter(name="dataprocClusterName")
    def dataproc_cluster_name(self) -> _builtins.str:
        """
        Dataproc cluster name for PySpark workloads
        """
        return pulumi.get(self, "dataproc_cluster_name")

    @_builtins.property
    @pulumi.getter(name="dataprocRegion")
    def dataproc_region(self) -> _builtins.str:
        """
        Google Cloud region for PySpark workloads on Dataproc
        """
        return pulumi.get(self, "dataproc_region")

    @_builtins.property
    @pulumi.getter(name="executionProject")
    def execution_project(self) -> _builtins.str:
        """
        Project to bill for query execution
        """
        return pulumi.get(self, "execution_project")

    @_builtins.property
    @pulumi.getter(name="gcpProjectId")
    def gcp_project_id(self) -> _builtins.str:
        """
        The GCP project ID to use for the connection
        """
        return pulumi.get(self, "gcp_project_id")

    @_builtins.property
    @pulumi.getter(name="gcsBucket")
    def gcs_bucket(self) -> _builtins.str:
        """
        URI for a Google Cloud Storage bucket to host Python code executed via Datapro
        """
        return pulumi.get(self, "gcs_bucket")

    @_builtins.property
    @pulumi.getter(name="impersonateServiceAccount")
    def impersonate_service_account(self) -> _builtins.str:
        """
        Service Account to impersonate when running queries
        """
        return pulumi.get(self, "impersonate_service_account")

    @_builtins.property
    @pulumi.getter(name="jobCreationTimeoutSeconds")
    def job_creation_timeout_seconds(self) -> _builtins.int:
        """
        Maximum timeout for the job creation step
        """
        return pulumi.get(self, "job_creation_timeout_seconds")

    @_builtins.property
    @pulumi.getter(name="jobRetryDeadlineSeconds")
    def job_retry_deadline_seconds(self) -> _builtins.int:
        """
        Total number of seconds to wait while retrying the same query
        """
        return pulumi.get(self, "job_retry_deadline_seconds")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        Location to create new Datasets in
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="maximumBytesBilled")
    def maximum_bytes_billed(self) -> _builtins.int:
        """
        Max number of bytes that can be billed for a given BigQuery query
        """
        return pulumi.get(self, "maximum_bytes_billed")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.str:
        """
        The priority with which to execute BigQuery queries (batch or interactive)
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> _builtins.str:
        """
        Private Key for the Service Account
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> _builtins.str:
        """
        Private Key ID for the Service Account
        """
        return pulumi.get(self, "private_key_id")

    @_builtins.property
    @pulumi.getter
    def retries(self) -> _builtins.int:
        """
        Number of retries for queries
        """
        return pulumi.get(self, "retries")

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Sequence[_builtins.str]:
        """
        OAuth scopes for the BigQuery connection
        """
        return pulumi.get(self, "scopes")

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> _builtins.int:
        """
        Timeout in seconds for queries
        """
        return pulumi.get(self, "timeout_seconds")

    @_builtins.property
    @pulumi.getter(name="tokenUri")
    def token_uri(self) -> _builtins.str:
        """
        Token URI for the Service Account
        """
        return pulumi.get(self, "token_uri")


@pulumi.output_type
class GetGlobalConnectionDatabricksResult(dict):
    def __init__(__self__, *,
                 catalog: _builtins.str,
                 client_id: _builtins.str,
                 client_secret: _builtins.str,
                 host: _builtins.str,
                 http_path: _builtins.str):
        """
        :param _builtins.str catalog: Catalog name if Unity Catalog is enabled in your Databricks workspace.
        :param _builtins.str client_id: Required to enable Databricks OAuth authentication for IDE developers.
        :param _builtins.str client_secret: Required to enable Databricks OAuth authentication for IDE developers.
        :param _builtins.str host: The hostname of the Databricks cluster or SQL warehouse.
        :param _builtins.str http_path: The HTTP path of the Databricks cluster or SQL warehouse.
        """
        pulumi.set(__self__, "catalog", catalog)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "http_path", http_path)

    @_builtins.property
    @pulumi.getter
    def catalog(self) -> _builtins.str:
        """
        Catalog name if Unity Catalog is enabled in your Databricks workspace.
        """
        return pulumi.get(self, "catalog")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        Required to enable Databricks OAuth authentication for IDE developers.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> _builtins.str:
        """
        Required to enable Databricks OAuth authentication for IDE developers.
        """
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The hostname of the Databricks cluster or SQL warehouse.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="httpPath")
    def http_path(self) -> _builtins.str:
        """
        The HTTP path of the Databricks cluster or SQL warehouse.
        """
        return pulumi.get(self, "http_path")


@pulumi.output_type
class GetGlobalConnectionFabricResult(dict):
    def __init__(__self__, *,
                 database: _builtins.str,
                 login_timeout: _builtins.int,
                 port: _builtins.int,
                 query_timeout: _builtins.int,
                 retries: _builtins.int,
                 server: _builtins.str):
        """
        :param _builtins.str database: The database to connect to for this connection.
        :param _builtins.int login_timeout: The number of seconds used to establish a connection before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        :param _builtins.int port: The port to connect to for this connection. Default=1433
        :param _builtins.int query_timeout: The number of seconds used to wait for a query before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        :param _builtins.int retries: The number of automatic times to retry a query before failing. Defaults to 1. Queries with syntax errors will not be retried. This setting can be used to overcome intermittent network issues.
        :param _builtins.str server: The server hostname.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "login_timeout", login_timeout)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "query_timeout", query_timeout)
        pulumi.set(__self__, "retries", retries)
        pulumi.set(__self__, "server", server)

    @_builtins.property
    @pulumi.getter
    def database(self) -> _builtins.str:
        """
        The database to connect to for this connection.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter(name="loginTimeout")
    def login_timeout(self) -> _builtins.int:
        """
        The number of seconds used to establish a connection before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        """
        return pulumi.get(self, "login_timeout")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port to connect to for this connection. Default=1433
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="queryTimeout")
    def query_timeout(self) -> _builtins.int:
        """
        The number of seconds used to wait for a query before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        """
        return pulumi.get(self, "query_timeout")

    @_builtins.property
    @pulumi.getter
    def retries(self) -> _builtins.int:
        """
        The number of automatic times to retry a query before failing. Defaults to 1. Queries with syntax errors will not be retried. This setting can be used to overcome intermittent network issues.
        """
        return pulumi.get(self, "retries")

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.str:
        """
        The server hostname.
        """
        return pulumi.get(self, "server")


@pulumi.output_type
class GetGlobalConnectionPostgresResult(dict):
    def __init__(__self__, *,
                 dbname: _builtins.str,
                 hostname: _builtins.str,
                 port: _builtins.int,
                 ssh_tunnel: 'outputs.GetGlobalConnectionPostgresSshTunnelResult'):
        """
        :param _builtins.str dbname: The database name for this connection.
        :param _builtins.str hostname: The hostname of the database.
        :param _builtins.int port: The port to connect to for this connection. Default=5432
        :param 'GetGlobalConnectionPostgresSshTunnelArgs' ssh_tunnel: PostgreSQL SSH Tunnel configuration
        """
        pulumi.set(__self__, "dbname", dbname)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "ssh_tunnel", ssh_tunnel)

    @_builtins.property
    @pulumi.getter
    def dbname(self) -> _builtins.str:
        """
        The database name for this connection.
        """
        return pulumi.get(self, "dbname")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The hostname of the database.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port to connect to for this connection. Default=5432
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="sshTunnel")
    def ssh_tunnel(self) -> 'outputs.GetGlobalConnectionPostgresSshTunnelResult':
        """
        PostgreSQL SSH Tunnel configuration
        """
        return pulumi.get(self, "ssh_tunnel")


@pulumi.output_type
class GetGlobalConnectionPostgresSshTunnelResult(dict):
    def __init__(__self__, *,
                 hostname: _builtins.str,
                 id: _builtins.int,
                 port: _builtins.int,
                 public_key: _builtins.str,
                 username: _builtins.str):
        """
        :param _builtins.str hostname: The hostname for the SSH tunnel.
        :param _builtins.int id: The ID of the SSH tunnel connection.
        :param _builtins.int port: The HTTP port for the SSH tunnel.
        :param _builtins.str public_key: The SSH public key generated to allow connecting via SSH tunnel.
        :param _builtins.str username: The username to use for the SSH tunnel.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "public_key", public_key)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The hostname for the SSH tunnel.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        The ID of the SSH tunnel connection.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The HTTP port for the SSH tunnel.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> _builtins.str:
        """
        The SSH public key generated to allow connecting via SSH tunnel.
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The username to use for the SSH tunnel.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetGlobalConnectionRedshiftResult(dict):
    def __init__(__self__, *,
                 dbname: _builtins.str,
                 hostname: _builtins.str,
                 port: _builtins.int,
                 ssh_tunnel: 'outputs.GetGlobalConnectionRedshiftSshTunnelResult'):
        """
        :param _builtins.str dbname: The database name for this connection.
        :param _builtins.str hostname: The hostname of the data warehouse.
        :param _builtins.int port: The port to connect to for this connection. Default=5432
        :param 'GetGlobalConnectionRedshiftSshTunnelArgs' ssh_tunnel: Redshift SSH Tunnel configuration
        """
        pulumi.set(__self__, "dbname", dbname)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "ssh_tunnel", ssh_tunnel)

    @_builtins.property
    @pulumi.getter
    def dbname(self) -> _builtins.str:
        """
        The database name for this connection.
        """
        return pulumi.get(self, "dbname")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The hostname of the data warehouse.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port to connect to for this connection. Default=5432
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="sshTunnel")
    def ssh_tunnel(self) -> 'outputs.GetGlobalConnectionRedshiftSshTunnelResult':
        """
        Redshift SSH Tunnel configuration
        """
        return pulumi.get(self, "ssh_tunnel")


@pulumi.output_type
class GetGlobalConnectionRedshiftSshTunnelResult(dict):
    def __init__(__self__, *,
                 hostname: _builtins.str,
                 id: _builtins.int,
                 port: _builtins.int,
                 public_key: _builtins.str,
                 username: _builtins.str):
        """
        :param _builtins.str hostname: The hostname for the SSH tunnel.
        :param _builtins.int id: The ID of the SSH tunnel connection.
        :param _builtins.int port: The HTTP port for the SSH tunnel.
        :param _builtins.str public_key: The SSH public key generated to allow connecting via SSH tunnel.
        :param _builtins.str username: The username to use for the SSH tunnel.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "public_key", public_key)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The hostname for the SSH tunnel.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        The ID of the SSH tunnel connection.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The HTTP port for the SSH tunnel.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> _builtins.str:
        """
        The SSH public key generated to allow connecting via SSH tunnel.
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The username to use for the SSH tunnel.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetGlobalConnectionSnowflakeResult(dict):
    def __init__(__self__, *,
                 account: _builtins.str,
                 allow_sso: _builtins.bool,
                 client_session_keep_alive: _builtins.bool,
                 database: _builtins.str,
                 oauth_client_id: _builtins.str,
                 oauth_client_secret: _builtins.str,
                 role: _builtins.str,
                 warehouse: _builtins.str):
        """
        :param _builtins.str account: The Snowflake account name
        :param _builtins.bool allow_sso: Whether to allow Snowflake OAuth for the connection. If true, the `oauth_client_id` and `oauth_client_secret` fields must be set
        :param _builtins.bool client_session_keep_alive: If true, the snowflake client will keep connections for longer than the default 4 hours. This is helpful when particularly long-running queries are executing (> 4 hours)
        :param _builtins.str database: The default database for the connection
        :param _builtins.str oauth_client_id: OAuth Client ID. Required to allow OAuth between dbt Cloud and Snowflake
        :param _builtins.str oauth_client_secret: OAuth Client Secret. Required to allow OAuth between dbt Cloud and Snowflake
        :param _builtins.str role: The Snowflake role to use when running queries on the connection
        :param _builtins.str warehouse: The default Snowflake Warehouse to use for the connection
        """
        pulumi.set(__self__, "account", account)
        pulumi.set(__self__, "allow_sso", allow_sso)
        pulumi.set(__self__, "client_session_keep_alive", client_session_keep_alive)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "oauth_client_id", oauth_client_id)
        pulumi.set(__self__, "oauth_client_secret", oauth_client_secret)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "warehouse", warehouse)

    @_builtins.property
    @pulumi.getter
    def account(self) -> _builtins.str:
        """
        The Snowflake account name
        """
        return pulumi.get(self, "account")

    @_builtins.property
    @pulumi.getter(name="allowSso")
    def allow_sso(self) -> _builtins.bool:
        """
        Whether to allow Snowflake OAuth for the connection. If true, the `oauth_client_id` and `oauth_client_secret` fields must be set
        """
        return pulumi.get(self, "allow_sso")

    @_builtins.property
    @pulumi.getter(name="clientSessionKeepAlive")
    def client_session_keep_alive(self) -> _builtins.bool:
        """
        If true, the snowflake client will keep connections for longer than the default 4 hours. This is helpful when particularly long-running queries are executing (> 4 hours)
        """
        return pulumi.get(self, "client_session_keep_alive")

    @_builtins.property
    @pulumi.getter
    def database(self) -> _builtins.str:
        """
        The default database for the connection
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter(name="oauthClientId")
    def oauth_client_id(self) -> _builtins.str:
        """
        OAuth Client ID. Required to allow OAuth between dbt Cloud and Snowflake
        """
        return pulumi.get(self, "oauth_client_id")

    @_builtins.property
    @pulumi.getter(name="oauthClientSecret")
    def oauth_client_secret(self) -> _builtins.str:
        """
        OAuth Client Secret. Required to allow OAuth between dbt Cloud and Snowflake
        """
        return pulumi.get(self, "oauth_client_secret")

    @_builtins.property
    @pulumi.getter
    def role(self) -> _builtins.str:
        """
        The Snowflake role to use when running queries on the connection
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def warehouse(self) -> _builtins.str:
        """
        The default Snowflake Warehouse to use for the connection
        """
        return pulumi.get(self, "warehouse")


@pulumi.output_type
class GetGlobalConnectionStarburstResult(dict):
    def __init__(__self__, *,
                 host: _builtins.str,
                 method: _builtins.str,
                 port: _builtins.int):
        """
        :param _builtins.str host: The hostname of the account to connect to.
        :param _builtins.str method: The authentication method. Only LDAP for now.
        :param _builtins.int port: The port to connect to for this connection. Default=443
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The hostname of the account to connect to.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        The authentication method. Only LDAP for now.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port to connect to for this connection. Default=443
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetGlobalConnectionSynapseResult(dict):
    def __init__(__self__, *,
                 database: _builtins.str,
                 host: _builtins.str,
                 login_timeout: _builtins.int,
                 port: _builtins.int,
                 query_timeout: _builtins.int,
                 retries: _builtins.int):
        """
        :param _builtins.str database: The database to connect to for this connection.
        :param _builtins.str host: The server hostname.
        :param _builtins.int login_timeout: The number of seconds used to establish a connection before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        :param _builtins.int port: The port to connect to for this connection. Default=1433
        :param _builtins.int query_timeout: The number of seconds used to wait for a query before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        :param _builtins.int retries: The number of automatic times to retry a query before failing. Defaults to 1. Queries with syntax errors will not be retried. This setting can be used to overcome intermittent network issues.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "login_timeout", login_timeout)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "query_timeout", query_timeout)
        pulumi.set(__self__, "retries", retries)

    @_builtins.property
    @pulumi.getter
    def database(self) -> _builtins.str:
        """
        The database to connect to for this connection.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The server hostname.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="loginTimeout")
    def login_timeout(self) -> _builtins.int:
        """
        The number of seconds used to establish a connection before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        """
        return pulumi.get(self, "login_timeout")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port to connect to for this connection. Default=1433
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="queryTimeout")
    def query_timeout(self) -> _builtins.int:
        """
        The number of seconds used to wait for a query before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        """
        return pulumi.get(self, "query_timeout")

    @_builtins.property
    @pulumi.getter
    def retries(self) -> _builtins.int:
        """
        The number of automatic times to retry a query before failing. Defaults to 1. Queries with syntax errors will not be retried. This setting can be used to overcome intermittent network issues.
        """
        return pulumi.get(self, "retries")


@pulumi.output_type
class GetGlobalConnectionTeradataResult(dict):
    def __init__(__self__, *,
                 host: _builtins.str,
                 port: _builtins.str,
                 request_timeout: _builtins.int,
                 retries: _builtins.int,
                 tmode: _builtins.str):
        """
        :param _builtins.str host: The hostname of the database.
        :param _builtins.str port: The port to connect to for this connection. Default=1025
        :param _builtins.int request_timeout: The number of seconds used to establish a connection before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        :param _builtins.int retries: The number of automatic times to retry a query before failing. Defaults to 1. Queries with syntax errors will not be retried. This setting can be used to overcome intermittent network issues.
        :param _builtins.str tmode: The transaction mode to use for the connection.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "request_timeout", request_timeout)
        pulumi.set(__self__, "retries", retries)
        pulumi.set(__self__, "tmode", tmode)

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The hostname of the database.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.str:
        """
        The port to connect to for this connection. Default=1025
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> _builtins.int:
        """
        The number of seconds used to establish a connection before failing. Defaults to 0, which means that the timeout is disabled or uses the default system settings.
        """
        return pulumi.get(self, "request_timeout")

    @_builtins.property
    @pulumi.getter
    def retries(self) -> _builtins.int:
        """
        The number of automatic times to retry a query before failing. Defaults to 1. Queries with syntax errors will not be retried. This setting can be used to overcome intermittent network issues.
        """
        return pulumi.get(self, "retries")

    @_builtins.property
    @pulumi.getter
    def tmode(self) -> _builtins.str:
        """
        The transaction mode to use for the connection.
        """
        return pulumi.get(self, "tmode")


@pulumi.output_type
class GetGlobalConnectionsConnectionResult(dict):
    def __init__(__self__, *,
                 adapter_version: _builtins.str,
                 created_at: _builtins.str,
                 environment_count: _builtins.int,
                 id: _builtins.int,
                 is_ssh_tunnel_enabled: _builtins.bool,
                 name: _builtins.str,
                 oauth_configuration_id: _builtins.int,
                 private_link_endpoint_id: _builtins.str,
                 updated_at: _builtins.str):
        """
        :param _builtins.str adapter_version: Type of adapter used for the connection
        :param _builtins.str created_at: When the connection was created
        :param _builtins.int environment_count: Number of environments using this connection
        :param _builtins.int id: Connection Identifier
        :param _builtins.str name: Connection name
        :param _builtins.str private_link_endpoint_id: Private Link Endpoint ID.
        :param _builtins.str updated_at: When the connection was updated
        """
        pulumi.set(__self__, "adapter_version", adapter_version)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "environment_count", environment_count)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_ssh_tunnel_enabled", is_ssh_tunnel_enabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "oauth_configuration_id", oauth_configuration_id)
        pulumi.set(__self__, "private_link_endpoint_id", private_link_endpoint_id)
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="adapterVersion")
    def adapter_version(self) -> _builtins.str:
        """
        Type of adapter used for the connection
        """
        return pulumi.get(self, "adapter_version")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        When the connection was created
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="environmentCount")
    def environment_count(self) -> _builtins.int:
        """
        Number of environments using this connection
        """
        return pulumi.get(self, "environment_count")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        Connection Identifier
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isSshTunnelEnabled")
    def is_ssh_tunnel_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "is_ssh_tunnel_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Connection name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="oauthConfigurationId")
    def oauth_configuration_id(self) -> _builtins.int:
        return pulumi.get(self, "oauth_configuration_id")

    @_builtins.property
    @pulumi.getter(name="privateLinkEndpointId")
    def private_link_endpoint_id(self) -> _builtins.str:
        """
        Private Link Endpoint ID.
        """
        return pulumi.get(self, "private_link_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        When the connection was updated
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetGroupGroupPermissionResult(dict):
    def __init__(__self__, *,
                 all_projects: _builtins.bool,
                 permission_set: _builtins.str,
                 project_id: _builtins.int,
                 writable_environment_categories: Sequence[_builtins.str]):
        """
        :param _builtins.bool all_projects: Whether access should be provided for all projects or not.
        :param _builtins.str permission_set: Set of permissions to apply. The permissions allowed are the same as the ones for the `Group` resource.
        :param _builtins.int project_id: Project ID to apply this permission to for this group.
        :param Sequence[_builtins.str] writable_environment_categories: What types of environments to apply Write permissions to.
        """
        pulumi.set(__self__, "all_projects", all_projects)
        pulumi.set(__self__, "permission_set", permission_set)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "writable_environment_categories", writable_environment_categories)

    @_builtins.property
    @pulumi.getter(name="allProjects")
    def all_projects(self) -> _builtins.bool:
        """
        Whether access should be provided for all projects or not.
        """
        return pulumi.get(self, "all_projects")

    @_builtins.property
    @pulumi.getter(name="permissionSet")
    def permission_set(self) -> _builtins.str:
        """
        Set of permissions to apply. The permissions allowed are the same as the ones for the `Group` resource.
        """
        return pulumi.get(self, "permission_set")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.int:
        """
        Project ID to apply this permission to for this group.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="writableEnvironmentCategories")
    def writable_environment_categories(self) -> Sequence[_builtins.str]:
        """
        What types of environments to apply Write permissions to.
        """
        return pulumi.get(self, "writable_environment_categories")


@pulumi.output_type
class GetGroupUsersUserResult(dict):
    def __init__(__self__, *,
                 email: _builtins.str,
                 id: _builtins.int):
        """
        :param _builtins.str email: Email of the user
        :param _builtins.int id: ID of the user
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        Email of the user
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        ID of the user
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetGroupsGroupResult(dict):
    def __init__(__self__, *,
                 assign_by_default: _builtins.bool,
                 id: _builtins.int,
                 name: _builtins.str,
                 scim_managed: _builtins.bool,
                 sso_mapping_groups: Sequence[_builtins.str],
                 state: _builtins.int):
        """
        :param _builtins.bool assign_by_default: Whether the group will be assigned by default to users
        :param _builtins.int id: The ID of the group
        :param _builtins.str name: Group name
        :param _builtins.bool scim_managed: Whether the group is managed by SCIM
        :param Sequence[_builtins.str] sso_mapping_groups: SSO mapping group names for this group
        :param _builtins.int state: The state of the group (1=active, 2=deleted)
        """
        pulumi.set(__self__, "assign_by_default", assign_by_default)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scim_managed", scim_managed)
        pulumi.set(__self__, "sso_mapping_groups", sso_mapping_groups)
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="assignByDefault")
    def assign_by_default(self) -> _builtins.bool:
        """
        Whether the group will be assigned by default to users
        """
        return pulumi.get(self, "assign_by_default")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        The ID of the group
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Group name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="scimManaged")
    def scim_managed(self) -> _builtins.bool:
        """
        Whether the group is managed by SCIM
        """
        return pulumi.get(self, "scim_managed")

    @_builtins.property
    @pulumi.getter(name="ssoMappingGroups")
    def sso_mapping_groups(self) -> Sequence[_builtins.str]:
        """
        SSO mapping group names for this group
        """
        return pulumi.get(self, "sso_mapping_groups")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.int:
        """
        The state of the group (1=active, 2=deleted)
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetJobEnvironmentResult(dict):
    def __init__(__self__, *,
                 deployment_type: _builtins.str,
                 id: _builtins.int,
                 name: _builtins.str,
                 project_id: _builtins.int,
                 type: _builtins.str):
        """
        :param _builtins.str deployment_type: Type of deployment environment: staging, production
        :param _builtins.int id: ID of the environment
        :param _builtins.str name: Name of the environment
        :param _builtins.str type: Environment type: development or deployment
        """
        pulumi.set(__self__, "deployment_type", deployment_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> _builtins.str:
        """
        Type of deployment environment: staging, production
        """
        return pulumi.get(self, "deployment_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        ID of the environment
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the environment
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.int:
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Environment type: development or deployment
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetJobExecutionResult(dict):
    def __init__(__self__, *,
                 timeout_seconds: _builtins.int):
        """
        :param _builtins.int timeout_seconds: The number of seconds before the job times out
        """
        pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> _builtins.int:
        """
        The number of seconds before the job times out
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class GetJobJobCompletionTriggerConditionResult(dict):
    def __init__(__self__, *,
                 job_id: _builtins.int,
                 project_id: _builtins.int,
                 statuses: Sequence[_builtins.str]):
        """
        :param _builtins.int job_id: The ID of the job that would trigger this job after completion.
        :param _builtins.int project_id: The ID of the project where the trigger job is running in.
        :param Sequence[_builtins.str] statuses: List of statuses to trigger the job on.
        """
        pulumi.set(__self__, "job_id", job_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "statuses", statuses)

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> _builtins.int:
        """
        The ID of the job that would trigger this job after completion.
        """
        return pulumi.get(self, "job_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.int:
        """
        The ID of the project where the trigger job is running in.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> Sequence[_builtins.str]:
        """
        List of statuses to trigger the job on.
        """
        return pulumi.get(self, "statuses")


@pulumi.output_type
class GetJobScheduleResult(dict):
    def __init__(__self__, *,
                 cron: _builtins.str):
        """
        :param _builtins.str cron: The cron schedule for the job. Only used if triggers.schedule is true
        """
        pulumi.set(__self__, "cron", cron)

    @_builtins.property
    @pulumi.getter
    def cron(self) -> _builtins.str:
        """
        The cron schedule for the job. Only used if triggers.schedule is true
        """
        return pulumi.get(self, "cron")


@pulumi.output_type
class GetJobSettingsResult(dict):
    def __init__(__self__, *,
                 target_name: _builtins.str,
                 threads: _builtins.int):
        """
        :param _builtins.str target_name: Value for `target.name` in the Jinja context
        :param _builtins.int threads: Number of threads to run dbt with
        """
        pulumi.set(__self__, "target_name", target_name)
        pulumi.set(__self__, "threads", threads)

    @_builtins.property
    @pulumi.getter(name="targetName")
    def target_name(self) -> _builtins.str:
        """
        Value for `target.name` in the Jinja context
        """
        return pulumi.get(self, "target_name")

    @_builtins.property
    @pulumi.getter
    def threads(self) -> _builtins.int:
        """
        Number of threads to run dbt with
        """
        return pulumi.get(self, "threads")


@pulumi.output_type
class GetJobTriggersResult(dict):
    def __init__(__self__, *,
                 git_provider_webhook: _builtins.bool,
                 github_webhook: _builtins.bool,
                 on_merge: _builtins.bool,
                 schedule: _builtins.bool):
        """
        :param _builtins.bool git_provider_webhook: Whether the job runs automatically on PR creation
        :param _builtins.bool github_webhook: Whether the job runs automatically on PR creation
        :param _builtins.bool on_merge: Whether the job runs automatically once a PR is merged
        :param _builtins.bool schedule: Whether the job runs on a schedule
        """
        pulumi.set(__self__, "git_provider_webhook", git_provider_webhook)
        pulumi.set(__self__, "github_webhook", github_webhook)
        pulumi.set(__self__, "on_merge", on_merge)
        pulumi.set(__self__, "schedule", schedule)

    @_builtins.property
    @pulumi.getter(name="gitProviderWebhook")
    def git_provider_webhook(self) -> _builtins.bool:
        """
        Whether the job runs automatically on PR creation
        """
        return pulumi.get(self, "git_provider_webhook")

    @_builtins.property
    @pulumi.getter(name="githubWebhook")
    def github_webhook(self) -> _builtins.bool:
        """
        Whether the job runs automatically on PR creation
        """
        return pulumi.get(self, "github_webhook")

    @_builtins.property
    @pulumi.getter(name="onMerge")
    def on_merge(self) -> _builtins.bool:
        """
        Whether the job runs automatically once a PR is merged
        """
        return pulumi.get(self, "on_merge")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> _builtins.bool:
        """
        Whether the job runs on a schedule
        """
        return pulumi.get(self, "schedule")


@pulumi.output_type
class GetJobsJobResult(dict):
    def __init__(__self__, *,
                 dbt_version: _builtins.str,
                 deferring_environment_id: _builtins.int,
                 deferring_job_definition_id: _builtins.int,
                 description: _builtins.str,
                 environment: 'outputs.GetJobsJobEnvironmentResult',
                 environment_id: _builtins.int,
                 execute_steps: Sequence[_builtins.str],
                 execution: 'outputs.GetJobsJobExecutionResult',
                 generate_docs: _builtins.bool,
                 id: _builtins.int,
                 job_completion_trigger_condition: 'outputs.GetJobsJobJobCompletionTriggerConditionResult',
                 job_id: _builtins.int,
                 job_type: _builtins.str,
                 name: _builtins.str,
                 project_id: _builtins.int,
                 run_compare_changes: _builtins.bool,
                 run_generate_sources: _builtins.bool,
                 schedule: 'outputs.GetJobsJobScheduleResult',
                 settings: 'outputs.GetJobsJobSettingsResult',
                 timeout_seconds: _builtins.int,
                 triggers: 'outputs.GetJobsJobTriggersResult',
                 triggers_on_draft_pr: _builtins.bool):
        """
        :param _builtins.str dbt_version: The version of dbt used for the job. If not set, the environment version will be used.
        :param _builtins.int deferring_environment_id: The ID of the environment this job defers to
        :param _builtins.int deferring_job_definition_id: [Deprectated - Deferral is now set at the environment level] The ID of the job definition this job defers to
        :param _builtins.str description: The description of the job
        :param 'GetJobsJobEnvironmentArgs' environment: Details of the environment the job is running in
        :param _builtins.int environment_id: The ID of environment
        :param Sequence[_builtins.str] execute_steps: The list of steps to run in the job
        :param _builtins.bool generate_docs: Whether the job generate docs
        :param _builtins.int id: The ID of the job
        :param 'GetJobsJobJobCompletionTriggerConditionArgs' job_completion_trigger_condition: Whether the job is triggered by the completion of another job
        :param _builtins.int job_id: The ID of the job
        :param _builtins.str job_type: The type of job (e.g. CI, scheduled)
        :param _builtins.str name: The name of the job
        :param _builtins.int project_id: The ID of the project
        :param _builtins.bool run_compare_changes: Whether the job should compare data changes introduced by the code change in the PR
        :param _builtins.bool run_generate_sources: Whether the job test source freshness
        :param _builtins.int timeout_seconds: [Deprectated - Moved to execution.timeout_seconds] Number of seconds before the job times out
        :param _builtins.bool triggers_on_draft_pr: Whether the CI job should be automatically triggered on draft PRs
        """
        pulumi.set(__self__, "dbt_version", dbt_version)
        pulumi.set(__self__, "deferring_environment_id", deferring_environment_id)
        pulumi.set(__self__, "deferring_job_definition_id", deferring_job_definition_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "environment_id", environment_id)
        pulumi.set(__self__, "execute_steps", execute_steps)
        pulumi.set(__self__, "execution", execution)
        pulumi.set(__self__, "generate_docs", generate_docs)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "job_completion_trigger_condition", job_completion_trigger_condition)
        pulumi.set(__self__, "job_id", job_id)
        pulumi.set(__self__, "job_type", job_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "run_compare_changes", run_compare_changes)
        pulumi.set(__self__, "run_generate_sources", run_generate_sources)
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "settings", settings)
        pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        pulumi.set(__self__, "triggers", triggers)
        pulumi.set(__self__, "triggers_on_draft_pr", triggers_on_draft_pr)

    @_builtins.property
    @pulumi.getter(name="dbtVersion")
    def dbt_version(self) -> _builtins.str:
        """
        The version of dbt used for the job. If not set, the environment version will be used.
        """
        return pulumi.get(self, "dbt_version")

    @_builtins.property
    @pulumi.getter(name="deferringEnvironmentId")
    def deferring_environment_id(self) -> _builtins.int:
        """
        The ID of the environment this job defers to
        """
        return pulumi.get(self, "deferring_environment_id")

    @_builtins.property
    @pulumi.getter(name="deferringJobDefinitionId")
    @_utilities.deprecated("""Deferral is now set at the environment level""")
    def deferring_job_definition_id(self) -> _builtins.int:
        """
        [Deprectated - Deferral is now set at the environment level] The ID of the job definition this job defers to
        """
        return pulumi.get(self, "deferring_job_definition_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the job
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> 'outputs.GetJobsJobEnvironmentResult':
        """
        Details of the environment the job is running in
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> _builtins.int:
        """
        The ID of environment
        """
        return pulumi.get(self, "environment_id")

    @_builtins.property
    @pulumi.getter(name="executeSteps")
    def execute_steps(self) -> Sequence[_builtins.str]:
        """
        The list of steps to run in the job
        """
        return pulumi.get(self, "execute_steps")

    @_builtins.property
    @pulumi.getter
    def execution(self) -> 'outputs.GetJobsJobExecutionResult':
        return pulumi.get(self, "execution")

    @_builtins.property
    @pulumi.getter(name="generateDocs")
    def generate_docs(self) -> _builtins.bool:
        """
        Whether the job generate docs
        """
        return pulumi.get(self, "generate_docs")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        The ID of the job
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="jobCompletionTriggerCondition")
    def job_completion_trigger_condition(self) -> 'outputs.GetJobsJobJobCompletionTriggerConditionResult':
        """
        Whether the job is triggered by the completion of another job
        """
        return pulumi.get(self, "job_completion_trigger_condition")

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> _builtins.int:
        """
        The ID of the job
        """
        return pulumi.get(self, "job_id")

    @_builtins.property
    @pulumi.getter(name="jobType")
    def job_type(self) -> _builtins.str:
        """
        The type of job (e.g. CI, scheduled)
        """
        return pulumi.get(self, "job_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the job
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.int:
        """
        The ID of the project
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="runCompareChanges")
    def run_compare_changes(self) -> _builtins.bool:
        """
        Whether the job should compare data changes introduced by the code change in the PR
        """
        return pulumi.get(self, "run_compare_changes")

    @_builtins.property
    @pulumi.getter(name="runGenerateSources")
    def run_generate_sources(self) -> _builtins.bool:
        """
        Whether the job test source freshness
        """
        return pulumi.get(self, "run_generate_sources")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> 'outputs.GetJobsJobScheduleResult':
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter
    def settings(self) -> 'outputs.GetJobsJobSettingsResult':
        return pulumi.get(self, "settings")

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    @_utilities.deprecated("""Moved to execution.timeout_seconds""")
    def timeout_seconds(self) -> _builtins.int:
        """
        [Deprectated - Moved to execution.timeout_seconds] Number of seconds before the job times out
        """
        return pulumi.get(self, "timeout_seconds")

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> 'outputs.GetJobsJobTriggersResult':
        return pulumi.get(self, "triggers")

    @_builtins.property
    @pulumi.getter(name="triggersOnDraftPr")
    def triggers_on_draft_pr(self) -> _builtins.bool:
        """
        Whether the CI job should be automatically triggered on draft PRs
        """
        return pulumi.get(self, "triggers_on_draft_pr")


@pulumi.output_type
class GetJobsJobEnvironmentResult(dict):
    def __init__(__self__, *,
                 deployment_type: _builtins.str,
                 id: _builtins.int,
                 name: _builtins.str,
                 project_id: _builtins.int,
                 type: _builtins.str):
        """
        :param _builtins.str deployment_type: Type of deployment environment: staging, production
        :param _builtins.int id: ID of the environment
        :param _builtins.str name: Name of the environment
        :param _builtins.str type: Environment type: development or deployment
        """
        pulumi.set(__self__, "deployment_type", deployment_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> _builtins.str:
        """
        Type of deployment environment: staging, production
        """
        return pulumi.get(self, "deployment_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        ID of the environment
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the environment
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.int:
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Environment type: development or deployment
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetJobsJobExecutionResult(dict):
    def __init__(__self__, *,
                 timeout_seconds: _builtins.int):
        """
        :param _builtins.int timeout_seconds: The number of seconds before the job times out
        """
        pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> _builtins.int:
        """
        The number of seconds before the job times out
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class GetJobsJobJobCompletionTriggerConditionResult(dict):
    def __init__(__self__, *,
                 condition: 'outputs.GetJobsJobJobCompletionTriggerConditionConditionResult'):
        pulumi.set(__self__, "condition", condition)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> 'outputs.GetJobsJobJobCompletionTriggerConditionConditionResult':
        return pulumi.get(self, "condition")


@pulumi.output_type
class GetJobsJobJobCompletionTriggerConditionConditionResult(dict):
    def __init__(__self__, *,
                 job_id: _builtins.int,
                 project_id: _builtins.int,
                 statuses: Sequence[_builtins.str]):
        pulumi.set(__self__, "job_id", job_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "statuses", statuses)

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> _builtins.int:
        return pulumi.get(self, "job_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.int:
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "statuses")


@pulumi.output_type
class GetJobsJobScheduleResult(dict):
    def __init__(__self__, *,
                 cron: _builtins.str):
        """
        :param _builtins.str cron: The cron schedule for the job. Only used if triggers.schedule is true
        """
        pulumi.set(__self__, "cron", cron)

    @_builtins.property
    @pulumi.getter
    def cron(self) -> _builtins.str:
        """
        The cron schedule for the job. Only used if triggers.schedule is true
        """
        return pulumi.get(self, "cron")


@pulumi.output_type
class GetJobsJobSettingsResult(dict):
    def __init__(__self__, *,
                 target_name: _builtins.str,
                 threads: _builtins.int):
        """
        :param _builtins.str target_name: Value for `target.name` in the Jinja context
        :param _builtins.int threads: Number of threads to run dbt with
        """
        pulumi.set(__self__, "target_name", target_name)
        pulumi.set(__self__, "threads", threads)

    @_builtins.property
    @pulumi.getter(name="targetName")
    def target_name(self) -> _builtins.str:
        """
        Value for `target.name` in the Jinja context
        """
        return pulumi.get(self, "target_name")

    @_builtins.property
    @pulumi.getter
    def threads(self) -> _builtins.int:
        """
        Number of threads to run dbt with
        """
        return pulumi.get(self, "threads")


@pulumi.output_type
class GetJobsJobTriggersResult(dict):
    def __init__(__self__, *,
                 git_provider_webhook: _builtins.bool,
                 github_webhook: _builtins.bool,
                 on_merge: _builtins.bool,
                 schedule: _builtins.bool):
        """
        :param _builtins.bool git_provider_webhook: Whether the job runs automatically on PR creation
        :param _builtins.bool github_webhook: Whether the job runs automatically on PR creation
        :param _builtins.bool on_merge: Whether the job runs automatically once a PR is merged
        :param _builtins.bool schedule: Whether the job runs on a schedule
        """
        pulumi.set(__self__, "git_provider_webhook", git_provider_webhook)
        pulumi.set(__self__, "github_webhook", github_webhook)
        pulumi.set(__self__, "on_merge", on_merge)
        pulumi.set(__self__, "schedule", schedule)

    @_builtins.property
    @pulumi.getter(name="gitProviderWebhook")
    def git_provider_webhook(self) -> _builtins.bool:
        """
        Whether the job runs automatically on PR creation
        """
        return pulumi.get(self, "git_provider_webhook")

    @_builtins.property
    @pulumi.getter(name="githubWebhook")
    def github_webhook(self) -> _builtins.bool:
        """
        Whether the job runs automatically on PR creation
        """
        return pulumi.get(self, "github_webhook")

    @_builtins.property
    @pulumi.getter(name="onMerge")
    def on_merge(self) -> _builtins.bool:
        """
        Whether the job runs automatically once a PR is merged
        """
        return pulumi.get(self, "on_merge")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> _builtins.bool:
        """
        Whether the job runs on a schedule
        """
        return pulumi.get(self, "schedule")


@pulumi.output_type
class GetPrivatelinkEndpointsEndpointResult(dict):
    def __init__(__self__, *,
                 cidr_range: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 private_link_endpoint_url: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str cidr_range: CIDR range of the PrivateLink Endpoint
        :param _builtins.str id: The internal ID of the PrivateLink Endpoint
        :param _builtins.str name: Given descriptive name for the PrivateLink Endpoint
        :param _builtins.str private_link_endpoint_url: URL of the PrivateLink Endpoint
        :param _builtins.str type: Type of the PrivateLink Endpoint
        """
        pulumi.set(__self__, "cidr_range", cidr_range)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_link_endpoint_url", private_link_endpoint_url)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="cidrRange")
    def cidr_range(self) -> _builtins.str:
        """
        CIDR range of the PrivateLink Endpoint
        """
        return pulumi.get(self, "cidr_range")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The internal ID of the PrivateLink Endpoint
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Given descriptive name for the PrivateLink Endpoint
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateLinkEndpointUrl")
    def private_link_endpoint_url(self) -> _builtins.str:
        """
        URL of the PrivateLink Endpoint
        """
        return pulumi.get(self, "private_link_endpoint_url")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the PrivateLink Endpoint
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetProjectProjectConnectionResult(dict):
    def __init__(__self__, *,
                 adapter_version: _builtins.str,
                 id: _builtins.int,
                 name: _builtins.str):
        """
        :param _builtins.str adapter_version: Version of the adapter for the connection. Will tell what connection type it is
        :param _builtins.int id: Connection ID
        :param _builtins.str name: Connection name
        """
        pulumi.set(__self__, "adapter_version", adapter_version)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="adapterVersion")
    def adapter_version(self) -> _builtins.str:
        """
        Version of the adapter for the connection. Will tell what connection type it is
        """
        return pulumi.get(self, "adapter_version")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        Connection ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Connection name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetProjectRepositoryResult(dict):
    def __init__(__self__, *,
                 id: _builtins.int,
                 pull_request_url_template: _builtins.str,
                 remote_url: _builtins.str):
        """
        :param _builtins.int id: Repository ID
        :param _builtins.str pull_request_url_template: URL template for PRs
        :param _builtins.str remote_url: URL of the git repo remote
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "pull_request_url_template", pull_request_url_template)
        pulumi.set(__self__, "remote_url", remote_url)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        Repository ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="pullRequestUrlTemplate")
    def pull_request_url_template(self) -> _builtins.str:
        """
        URL template for PRs
        """
        return pulumi.get(self, "pull_request_url_template")

    @_builtins.property
    @pulumi.getter(name="remoteUrl")
    def remote_url(self) -> _builtins.str:
        """
        URL of the git repo remote
        """
        return pulumi.get(self, "remote_url")


@pulumi.output_type
class GetProjectsProjectResult(dict):
    def __init__(__self__, *,
                 created_at: _builtins.str,
                 dbt_project_subdirectory: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.int,
                 name: _builtins.str,
                 project_connection: 'outputs.GetProjectsProjectProjectConnectionResult',
                 repository: 'outputs.GetProjectsProjectRepositoryResult',
                 semantic_layer_config_id: _builtins.int,
                 type: _builtins.int,
                 updated_at: _builtins.str):
        """
        :param _builtins.str created_at: When the project was created
        :param _builtins.str dbt_project_subdirectory: Subdirectory for the dbt project inside the git repo
        :param _builtins.str description: Project description
        :param _builtins.int id: Project ID
        :param _builtins.str name: Project name
        :param 'GetProjectsProjectProjectConnectionArgs' project_connection: Details for the connection linked to the project
        :param 'GetProjectsProjectRepositoryArgs' repository: Details for the repository linked to the project
        :param _builtins.int semantic_layer_config_id: Semantic layer config ID
        :param _builtins.int type: The type of dbt project (default or hybrid)
        :param _builtins.str updated_at: When the project was last updated
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "dbt_project_subdirectory", dbt_project_subdirectory)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_connection", project_connection)
        pulumi.set(__self__, "repository", repository)
        pulumi.set(__self__, "semantic_layer_config_id", semantic_layer_config_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        When the project was created
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="dbtProjectSubdirectory")
    def dbt_project_subdirectory(self) -> _builtins.str:
        """
        Subdirectory for the dbt project inside the git repo
        """
        return pulumi.get(self, "dbt_project_subdirectory")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Project description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        Project ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Project name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectConnection")
    def project_connection(self) -> 'outputs.GetProjectsProjectProjectConnectionResult':
        """
        Details for the connection linked to the project
        """
        return pulumi.get(self, "project_connection")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> 'outputs.GetProjectsProjectRepositoryResult':
        """
        Details for the repository linked to the project
        """
        return pulumi.get(self, "repository")

    @_builtins.property
    @pulumi.getter(name="semanticLayerConfigId")
    def semantic_layer_config_id(self) -> _builtins.int:
        """
        Semantic layer config ID
        """
        return pulumi.get(self, "semantic_layer_config_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.int:
        """
        The type of dbt project (default or hybrid)
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        When the project was last updated
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetProjectsProjectProjectConnectionResult(dict):
    def __init__(__self__, *,
                 adapter_version: _builtins.str,
                 id: _builtins.int,
                 name: _builtins.str):
        """
        :param _builtins.str adapter_version: Version of the adapter for the connection. Will tell what connection type it is
        :param _builtins.int id: Connection ID
        :param _builtins.str name: Connection name
        """
        pulumi.set(__self__, "adapter_version", adapter_version)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="adapterVersion")
    def adapter_version(self) -> _builtins.str:
        """
        Version of the adapter for the connection. Will tell what connection type it is
        """
        return pulumi.get(self, "adapter_version")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        Connection ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Connection name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetProjectsProjectRepositoryResult(dict):
    def __init__(__self__, *,
                 id: _builtins.int,
                 pull_request_url_template: _builtins.str,
                 remote_url: _builtins.str):
        """
        :param _builtins.int id: Repository ID
        :param _builtins.str pull_request_url_template: URL template for PRs
        :param _builtins.str remote_url: URL of the git repo remote
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "pull_request_url_template", pull_request_url_template)
        pulumi.set(__self__, "remote_url", remote_url)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        Repository ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="pullRequestUrlTemplate")
    def pull_request_url_template(self) -> _builtins.str:
        """
        URL template for PRs
        """
        return pulumi.get(self, "pull_request_url_template")

    @_builtins.property
    @pulumi.getter(name="remoteUrl")
    def remote_url(self) -> _builtins.str:
        """
        URL of the git repo remote
        """
        return pulumi.get(self, "remote_url")


@pulumi.output_type
class GetRunsFilterResult(dict):
    def __init__(__self__, *,
                 environment_id: Optional[_builtins.int] = None,
                 job_definition_id: Optional[_builtins.int] = None,
                 limit: Optional[_builtins.int] = None,
                 project_id: Optional[_builtins.int] = None,
                 pull_request_id: Optional[_builtins.int] = None,
                 status: Optional[_builtins.int] = None,
                 status_in: Optional[_builtins.str] = None,
                 trigger_id: Optional[_builtins.int] = None):
        """
        :param _builtins.int environment_id: The ID of the environment
        :param _builtins.int job_definition_id: The ID of the job definition
        :param _builtins.int limit: The limit of the runs
        :param _builtins.int project_id: The ID of the project
        :param _builtins.int pull_request_id: The ID of the pull request
        :param _builtins.int status: The status of the run
        :param _builtins.str status_in: The status of the run
        :param _builtins.int trigger_id: The ID of the trigger
        """
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if job_definition_id is not None:
            pulumi.set(__self__, "job_definition_id", job_definition_id)
        if limit is not None:
            pulumi.set(__self__, "limit", limit)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if pull_request_id is not None:
            pulumi.set(__self__, "pull_request_id", pull_request_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_in is not None:
            pulumi.set(__self__, "status_in", status_in)
        if trigger_id is not None:
            pulumi.set(__self__, "trigger_id", trigger_id)

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[_builtins.int]:
        """
        The ID of the environment
        """
        return pulumi.get(self, "environment_id")

    @_builtins.property
    @pulumi.getter(name="jobDefinitionId")
    def job_definition_id(self) -> Optional[_builtins.int]:
        """
        The ID of the job definition
        """
        return pulumi.get(self, "job_definition_id")

    @_builtins.property
    @pulumi.getter
    def limit(self) -> Optional[_builtins.int]:
        """
        The limit of the runs
        """
        return pulumi.get(self, "limit")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.int]:
        """
        The ID of the project
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="pullRequestId")
    def pull_request_id(self) -> Optional[_builtins.int]:
        """
        The ID of the pull request
        """
        return pulumi.get(self, "pull_request_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.int]:
        """
        The status of the run
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusIn")
    def status_in(self) -> Optional[_builtins.str]:
        """
        The status of the run
        """
        return pulumi.get(self, "status_in")

    @_builtins.property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> Optional[_builtins.int]:
        """
        The ID of the trigger
        """
        return pulumi.get(self, "trigger_id")


@pulumi.output_type
class GetRunsRunResult(dict):
    def __init__(__self__, *,
                 account_id: _builtins.int,
                 cause: _builtins.str,
                 git_branch: _builtins.str,
                 git_sha: _builtins.str,
                 github_pull_request_id: _builtins.str,
                 id: _builtins.int,
                 job_id: _builtins.int,
                 schema_override: _builtins.str):
        """
        :param _builtins.int account_id: The ID of the account
        :param _builtins.str cause: The cause of the run
        :param _builtins.str git_branch: The branch of the commit
        :param _builtins.str git_sha: The SHA of the commit
        :param _builtins.str github_pull_request_id: The ID of the pull request
        :param _builtins.int id: The ID of the run
        :param _builtins.int job_id: The ID of the job
        :param _builtins.str schema_override: The schema override
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "cause", cause)
        pulumi.set(__self__, "git_branch", git_branch)
        pulumi.set(__self__, "git_sha", git_sha)
        pulumi.set(__self__, "github_pull_request_id", github_pull_request_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "job_id", job_id)
        pulumi.set(__self__, "schema_override", schema_override)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.int:
        """
        The ID of the account
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def cause(self) -> _builtins.str:
        """
        The cause of the run
        """
        return pulumi.get(self, "cause")

    @_builtins.property
    @pulumi.getter(name="gitBranch")
    def git_branch(self) -> _builtins.str:
        """
        The branch of the commit
        """
        return pulumi.get(self, "git_branch")

    @_builtins.property
    @pulumi.getter(name="gitSha")
    def git_sha(self) -> _builtins.str:
        """
        The SHA of the commit
        """
        return pulumi.get(self, "git_sha")

    @_builtins.property
    @pulumi.getter(name="githubPullRequestId")
    def github_pull_request_id(self) -> _builtins.str:
        """
        The ID of the pull request
        """
        return pulumi.get(self, "github_pull_request_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        The ID of the run
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> _builtins.int:
        """
        The ID of the job
        """
        return pulumi.get(self, "job_id")

    @_builtins.property
    @pulumi.getter(name="schemaOverride")
    def schema_override(self) -> _builtins.str:
        """
        The schema override
        """
        return pulumi.get(self, "schema_override")


@pulumi.output_type
class GetServiceTokenServiceTokenPermissionResult(dict):
    def __init__(__self__, *,
                 all_projects: _builtins.bool,
                 permission_set: _builtins.str,
                 project_id: _builtins.int,
                 writable_environment_categories: Sequence[_builtins.str]):
        """
        :param _builtins.bool all_projects: Whether or not to apply this permission to all projects for this service token
        :param _builtins.str permission_set: Set of permissions to apply
        :param _builtins.int project_id: Project ID to apply this permission to for this service token
        :param Sequence[_builtins.str] writable_environment_categories: What types of environments to apply Write permissions to.
               Even if Write access is restricted to some environment types, the permission set will have Read access to all environments.
               The values allowed are `all`, `development`, `staging`, `production` and `other`.
               Not setting a value is the same as selecting `all`.
               Not all permission sets support environment level write settings, only `analyst`, `database_admin`, `developer`, `git_admin` and `team_admin`.
        """
        pulumi.set(__self__, "all_projects", all_projects)
        pulumi.set(__self__, "permission_set", permission_set)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "writable_environment_categories", writable_environment_categories)

    @_builtins.property
    @pulumi.getter(name="allProjects")
    def all_projects(self) -> _builtins.bool:
        """
        Whether or not to apply this permission to all projects for this service token
        """
        return pulumi.get(self, "all_projects")

    @_builtins.property
    @pulumi.getter(name="permissionSet")
    def permission_set(self) -> _builtins.str:
        """
        Set of permissions to apply
        """
        return pulumi.get(self, "permission_set")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.int:
        """
        Project ID to apply this permission to for this service token
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="writableEnvironmentCategories")
    def writable_environment_categories(self) -> Sequence[_builtins.str]:
        """
        What types of environments to apply Write permissions to.
        Even if Write access is restricted to some environment types, the permission set will have Read access to all environments.
        The values allowed are `all`, `development`, `staging`, `production` and `other`.
        Not setting a value is the same as selecting `all`.
        Not all permission sets support environment level write settings, only `analyst`, `database_admin`, `developer`, `git_admin` and `team_admin`.
        """
        return pulumi.get(self, "writable_environment_categories")


@pulumi.output_type
class GetUsersUserResult(dict):
    def __init__(__self__, *,
                 email: _builtins.str,
                 id: _builtins.int):
        """
        :param _builtins.str email: Email for the user
        :param _builtins.int id: ID of the user
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        Email for the user
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        ID of the user
        """
        return pulumi.get(self, "id")


