# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PartialNotificationArgs', 'PartialNotification']

@pulumi.input_type
class PartialNotificationArgs:
    def __init__(__self__, *,
                 user_id: pulumi.Input[_builtins.int],
                 external_email: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_type: Optional[pulumi.Input[_builtins.int]] = None,
                 on_cancels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 on_failures: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 on_successes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 on_warnings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 slack_channel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slack_channel_name: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a PartialNotification resource.
        :param pulumi.Input[_builtins.int] user_id: Internal dbt Cloud User ID. Must be the user_id for an existing user even if the notification is an external one [global]
        :param pulumi.Input[_builtins.str] external_email: The external email to receive the notification [global, used as identifier]
        :param pulumi.Input[_builtins.int] notification_type: Type of notification (1 = dbt Cloud user email (default): does not require an external_email ; 2 = Slack channel: requires `slack_channel_id` and `slack_channel_name` ; 4 = external email: requires setting an `external_email`) [global, used as identifier]
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] on_cancels: List of job IDs to trigger the webhook on cancel. Those will be added/removed when config is added/removed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] on_failures: List of job IDs to trigger the webhook on failure Those will be added/removed when config is added/removed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] on_successes: List of job IDs to trigger the webhook on success Those will be added/removed when config is added/removed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] on_warnings: List of job IDs to trigger the webhook on warning Those will be added/removed when config is added/removed.
        :param pulumi.Input[_builtins.str] slack_channel_id: The ID of the Slack channel to receive the notification. It can be found at the bottom of the Slack channel settings [global, used as identifier]
        :param pulumi.Input[_builtins.str] slack_channel_name: The name of the slack channel [global, used as identifier]
        :param pulumi.Input[_builtins.int] state: State of the notification (1 = active (default), 2 = inactive) [global]
        """
        pulumi.set(__self__, "user_id", user_id)
        if external_email is not None:
            pulumi.set(__self__, "external_email", external_email)
        if notification_type is not None:
            pulumi.set(__self__, "notification_type", notification_type)
        if on_cancels is not None:
            pulumi.set(__self__, "on_cancels", on_cancels)
        if on_failures is not None:
            pulumi.set(__self__, "on_failures", on_failures)
        if on_successes is not None:
            pulumi.set(__self__, "on_successes", on_successes)
        if on_warnings is not None:
            pulumi.set(__self__, "on_warnings", on_warnings)
        if slack_channel_id is not None:
            pulumi.set(__self__, "slack_channel_id", slack_channel_id)
        if slack_channel_name is not None:
            pulumi.set(__self__, "slack_channel_name", slack_channel_name)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[_builtins.int]:
        """
        Internal dbt Cloud User ID. Must be the user_id for an existing user even if the notification is an external one [global]
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "user_id", value)

    @_builtins.property
    @pulumi.getter(name="externalEmail")
    def external_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The external email to receive the notification [global, used as identifier]
        """
        return pulumi.get(self, "external_email")

    @external_email.setter
    def external_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_email", value)

    @_builtins.property
    @pulumi.getter(name="notificationType")
    def notification_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Type of notification (1 = dbt Cloud user email (default): does not require an external_email ; 2 = Slack channel: requires `slack_channel_id` and `slack_channel_name` ; 4 = external email: requires setting an `external_email`) [global, used as identifier]
        """
        return pulumi.get(self, "notification_type")

    @notification_type.setter
    def notification_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "notification_type", value)

    @_builtins.property
    @pulumi.getter(name="onCancels")
    def on_cancels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        List of job IDs to trigger the webhook on cancel. Those will be added/removed when config is added/removed.
        """
        return pulumi.get(self, "on_cancels")

    @on_cancels.setter
    def on_cancels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "on_cancels", value)

    @_builtins.property
    @pulumi.getter(name="onFailures")
    def on_failures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        List of job IDs to trigger the webhook on failure Those will be added/removed when config is added/removed.
        """
        return pulumi.get(self, "on_failures")

    @on_failures.setter
    def on_failures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "on_failures", value)

    @_builtins.property
    @pulumi.getter(name="onSuccesses")
    def on_successes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        List of job IDs to trigger the webhook on success Those will be added/removed when config is added/removed.
        """
        return pulumi.get(self, "on_successes")

    @on_successes.setter
    def on_successes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "on_successes", value)

    @_builtins.property
    @pulumi.getter(name="onWarnings")
    def on_warnings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        List of job IDs to trigger the webhook on warning Those will be added/removed when config is added/removed.
        """
        return pulumi.get(self, "on_warnings")

    @on_warnings.setter
    def on_warnings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "on_warnings", value)

    @_builtins.property
    @pulumi.getter(name="slackChannelId")
    def slack_channel_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Slack channel to receive the notification. It can be found at the bottom of the Slack channel settings [global, used as identifier]
        """
        return pulumi.get(self, "slack_channel_id")

    @slack_channel_id.setter
    def slack_channel_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slack_channel_id", value)

    @_builtins.property
    @pulumi.getter(name="slackChannelName")
    def slack_channel_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the slack channel [global, used as identifier]
        """
        return pulumi.get(self, "slack_channel_name")

    @slack_channel_name.setter
    def slack_channel_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slack_channel_name", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        State of the notification (1 = active (default), 2 = inactive) [global]
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _PartialNotificationState:
    def __init__(__self__, *,
                 external_email: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_type: Optional[pulumi.Input[_builtins.int]] = None,
                 on_cancels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 on_failures: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 on_successes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 on_warnings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 slack_channel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slack_channel_name: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.int]] = None,
                 user_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering PartialNotification resources.
        :param pulumi.Input[_builtins.str] external_email: The external email to receive the notification [global, used as identifier]
        :param pulumi.Input[_builtins.int] notification_type: Type of notification (1 = dbt Cloud user email (default): does not require an external_email ; 2 = Slack channel: requires `slack_channel_id` and `slack_channel_name` ; 4 = external email: requires setting an `external_email`) [global, used as identifier]
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] on_cancels: List of job IDs to trigger the webhook on cancel. Those will be added/removed when config is added/removed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] on_failures: List of job IDs to trigger the webhook on failure Those will be added/removed when config is added/removed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] on_successes: List of job IDs to trigger the webhook on success Those will be added/removed when config is added/removed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] on_warnings: List of job IDs to trigger the webhook on warning Those will be added/removed when config is added/removed.
        :param pulumi.Input[_builtins.str] slack_channel_id: The ID of the Slack channel to receive the notification. It can be found at the bottom of the Slack channel settings [global, used as identifier]
        :param pulumi.Input[_builtins.str] slack_channel_name: The name of the slack channel [global, used as identifier]
        :param pulumi.Input[_builtins.int] state: State of the notification (1 = active (default), 2 = inactive) [global]
        :param pulumi.Input[_builtins.int] user_id: Internal dbt Cloud User ID. Must be the user_id for an existing user even if the notification is an external one [global]
        """
        if external_email is not None:
            pulumi.set(__self__, "external_email", external_email)
        if notification_type is not None:
            pulumi.set(__self__, "notification_type", notification_type)
        if on_cancels is not None:
            pulumi.set(__self__, "on_cancels", on_cancels)
        if on_failures is not None:
            pulumi.set(__self__, "on_failures", on_failures)
        if on_successes is not None:
            pulumi.set(__self__, "on_successes", on_successes)
        if on_warnings is not None:
            pulumi.set(__self__, "on_warnings", on_warnings)
        if slack_channel_id is not None:
            pulumi.set(__self__, "slack_channel_id", slack_channel_id)
        if slack_channel_name is not None:
            pulumi.set(__self__, "slack_channel_name", slack_channel_name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="externalEmail")
    def external_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The external email to receive the notification [global, used as identifier]
        """
        return pulumi.get(self, "external_email")

    @external_email.setter
    def external_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_email", value)

    @_builtins.property
    @pulumi.getter(name="notificationType")
    def notification_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Type of notification (1 = dbt Cloud user email (default): does not require an external_email ; 2 = Slack channel: requires `slack_channel_id` and `slack_channel_name` ; 4 = external email: requires setting an `external_email`) [global, used as identifier]
        """
        return pulumi.get(self, "notification_type")

    @notification_type.setter
    def notification_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "notification_type", value)

    @_builtins.property
    @pulumi.getter(name="onCancels")
    def on_cancels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        List of job IDs to trigger the webhook on cancel. Those will be added/removed when config is added/removed.
        """
        return pulumi.get(self, "on_cancels")

    @on_cancels.setter
    def on_cancels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "on_cancels", value)

    @_builtins.property
    @pulumi.getter(name="onFailures")
    def on_failures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        List of job IDs to trigger the webhook on failure Those will be added/removed when config is added/removed.
        """
        return pulumi.get(self, "on_failures")

    @on_failures.setter
    def on_failures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "on_failures", value)

    @_builtins.property
    @pulumi.getter(name="onSuccesses")
    def on_successes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        List of job IDs to trigger the webhook on success Those will be added/removed when config is added/removed.
        """
        return pulumi.get(self, "on_successes")

    @on_successes.setter
    def on_successes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "on_successes", value)

    @_builtins.property
    @pulumi.getter(name="onWarnings")
    def on_warnings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        List of job IDs to trigger the webhook on warning Those will be added/removed when config is added/removed.
        """
        return pulumi.get(self, "on_warnings")

    @on_warnings.setter
    def on_warnings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "on_warnings", value)

    @_builtins.property
    @pulumi.getter(name="slackChannelId")
    def slack_channel_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Slack channel to receive the notification. It can be found at the bottom of the Slack channel settings [global, used as identifier]
        """
        return pulumi.get(self, "slack_channel_id")

    @slack_channel_id.setter
    def slack_channel_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slack_channel_id", value)

    @_builtins.property
    @pulumi.getter(name="slackChannelName")
    def slack_channel_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the slack channel [global, used as identifier]
        """
        return pulumi.get(self, "slack_channel_name")

    @slack_channel_name.setter
    def slack_channel_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slack_channel_name", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        State of the notification (1 = active (default), 2 = inactive) [global]
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Internal dbt Cloud User ID. Must be the user_id for an existing user even if the notification is an external one [global]
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "user_id", value)


@pulumi.type_token("dbtcloud:index/partialNotification:PartialNotification")
class PartialNotification(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 external_email: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_type: Optional[pulumi.Input[_builtins.int]] = None,
                 on_cancels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 on_failures: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 on_successes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 on_warnings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 slack_channel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slack_channel_name: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.int]] = None,
                 user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        # the config is the same as for `dbtcloud_notification`
        prod_job_internal_notification = dbtcloud.PartialNotification("prod_job_internal_notification",
            user_id=100,
            on_successes=[prod_job["id"]],
            on_failures=[12345],
            notification_type=1)
        # we can also send "external" email notifications to emails to related to dbt Cloud users
        prod_job_external_notification = dbtcloud.PartialNotification("prod_job_external_notification",
            user_id=100,
            on_failures=[
                23456,
                56788,
            ],
            on_cancels=[prod_job["id"]],
            notification_type=4,
            external_email="my_email@mail.com")
        # and finally, we can set up Slack notifications
        prod_job_slack_notifications = dbtcloud.PartialNotification("prod_job_slack_notifications",
            user_id=100,
            on_failures=[
                23456,
                56788,
            ],
            on_cancels=[prod_job["id"]],
            notification_type=2,
            slack_channel_id="C12345ABCDE",
            slack_channel_name="#my-awesome-channel")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] external_email: The external email to receive the notification [global, used as identifier]
        :param pulumi.Input[_builtins.int] notification_type: Type of notification (1 = dbt Cloud user email (default): does not require an external_email ; 2 = Slack channel: requires `slack_channel_id` and `slack_channel_name` ; 4 = external email: requires setting an `external_email`) [global, used as identifier]
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] on_cancels: List of job IDs to trigger the webhook on cancel. Those will be added/removed when config is added/removed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] on_failures: List of job IDs to trigger the webhook on failure Those will be added/removed when config is added/removed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] on_successes: List of job IDs to trigger the webhook on success Those will be added/removed when config is added/removed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] on_warnings: List of job IDs to trigger the webhook on warning Those will be added/removed when config is added/removed.
        :param pulumi.Input[_builtins.str] slack_channel_id: The ID of the Slack channel to receive the notification. It can be found at the bottom of the Slack channel settings [global, used as identifier]
        :param pulumi.Input[_builtins.str] slack_channel_name: The name of the slack channel [global, used as identifier]
        :param pulumi.Input[_builtins.int] state: State of the notification (1 = active (default), 2 = inactive) [global]
        :param pulumi.Input[_builtins.int] user_id: Internal dbt Cloud User ID. Must be the user_id for an existing user even if the notification is an external one [global]
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PartialNotificationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        # the config is the same as for `dbtcloud_notification`
        prod_job_internal_notification = dbtcloud.PartialNotification("prod_job_internal_notification",
            user_id=100,
            on_successes=[prod_job["id"]],
            on_failures=[12345],
            notification_type=1)
        # we can also send "external" email notifications to emails to related to dbt Cloud users
        prod_job_external_notification = dbtcloud.PartialNotification("prod_job_external_notification",
            user_id=100,
            on_failures=[
                23456,
                56788,
            ],
            on_cancels=[prod_job["id"]],
            notification_type=4,
            external_email="my_email@mail.com")
        # and finally, we can set up Slack notifications
        prod_job_slack_notifications = dbtcloud.PartialNotification("prod_job_slack_notifications",
            user_id=100,
            on_failures=[
                23456,
                56788,
            ],
            on_cancels=[prod_job["id"]],
            notification_type=2,
            slack_channel_id="C12345ABCDE",
            slack_channel_name="#my-awesome-channel")
        ```

        :param str resource_name: The name of the resource.
        :param PartialNotificationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PartialNotificationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 external_email: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_type: Optional[pulumi.Input[_builtins.int]] = None,
                 on_cancels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 on_failures: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 on_successes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 on_warnings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 slack_channel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slack_channel_name: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.int]] = None,
                 user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PartialNotificationArgs.__new__(PartialNotificationArgs)

            __props__.__dict__["external_email"] = external_email
            __props__.__dict__["notification_type"] = notification_type
            __props__.__dict__["on_cancels"] = on_cancels
            __props__.__dict__["on_failures"] = on_failures
            __props__.__dict__["on_successes"] = on_successes
            __props__.__dict__["on_warnings"] = on_warnings
            __props__.__dict__["slack_channel_id"] = slack_channel_id
            __props__.__dict__["slack_channel_name"] = slack_channel_name
            __props__.__dict__["state"] = state
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
        super(PartialNotification, __self__).__init__(
            'dbtcloud:index/partialNotification:PartialNotification',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            external_email: Optional[pulumi.Input[_builtins.str]] = None,
            notification_type: Optional[pulumi.Input[_builtins.int]] = None,
            on_cancels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
            on_failures: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
            on_successes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
            on_warnings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
            slack_channel_id: Optional[pulumi.Input[_builtins.str]] = None,
            slack_channel_name: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.int]] = None,
            user_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'PartialNotification':
        """
        Get an existing PartialNotification resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] external_email: The external email to receive the notification [global, used as identifier]
        :param pulumi.Input[_builtins.int] notification_type: Type of notification (1 = dbt Cloud user email (default): does not require an external_email ; 2 = Slack channel: requires `slack_channel_id` and `slack_channel_name` ; 4 = external email: requires setting an `external_email`) [global, used as identifier]
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] on_cancels: List of job IDs to trigger the webhook on cancel. Those will be added/removed when config is added/removed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] on_failures: List of job IDs to trigger the webhook on failure Those will be added/removed when config is added/removed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] on_successes: List of job IDs to trigger the webhook on success Those will be added/removed when config is added/removed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] on_warnings: List of job IDs to trigger the webhook on warning Those will be added/removed when config is added/removed.
        :param pulumi.Input[_builtins.str] slack_channel_id: The ID of the Slack channel to receive the notification. It can be found at the bottom of the Slack channel settings [global, used as identifier]
        :param pulumi.Input[_builtins.str] slack_channel_name: The name of the slack channel [global, used as identifier]
        :param pulumi.Input[_builtins.int] state: State of the notification (1 = active (default), 2 = inactive) [global]
        :param pulumi.Input[_builtins.int] user_id: Internal dbt Cloud User ID. Must be the user_id for an existing user even if the notification is an external one [global]
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PartialNotificationState.__new__(_PartialNotificationState)

        __props__.__dict__["external_email"] = external_email
        __props__.__dict__["notification_type"] = notification_type
        __props__.__dict__["on_cancels"] = on_cancels
        __props__.__dict__["on_failures"] = on_failures
        __props__.__dict__["on_successes"] = on_successes
        __props__.__dict__["on_warnings"] = on_warnings
        __props__.__dict__["slack_channel_id"] = slack_channel_id
        __props__.__dict__["slack_channel_name"] = slack_channel_name
        __props__.__dict__["state"] = state
        __props__.__dict__["user_id"] = user_id
        return PartialNotification(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="externalEmail")
    def external_email(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The external email to receive the notification [global, used as identifier]
        """
        return pulumi.get(self, "external_email")

    @_builtins.property
    @pulumi.getter(name="notificationType")
    def notification_type(self) -> pulumi.Output[_builtins.int]:
        """
        Type of notification (1 = dbt Cloud user email (default): does not require an external_email ; 2 = Slack channel: requires `slack_channel_id` and `slack_channel_name` ; 4 = external email: requires setting an `external_email`) [global, used as identifier]
        """
        return pulumi.get(self, "notification_type")

    @_builtins.property
    @pulumi.getter(name="onCancels")
    def on_cancels(self) -> pulumi.Output[Sequence[_builtins.int]]:
        """
        List of job IDs to trigger the webhook on cancel. Those will be added/removed when config is added/removed.
        """
        return pulumi.get(self, "on_cancels")

    @_builtins.property
    @pulumi.getter(name="onFailures")
    def on_failures(self) -> pulumi.Output[Sequence[_builtins.int]]:
        """
        List of job IDs to trigger the webhook on failure Those will be added/removed when config is added/removed.
        """
        return pulumi.get(self, "on_failures")

    @_builtins.property
    @pulumi.getter(name="onSuccesses")
    def on_successes(self) -> pulumi.Output[Sequence[_builtins.int]]:
        """
        List of job IDs to trigger the webhook on success Those will be added/removed when config is added/removed.
        """
        return pulumi.get(self, "on_successes")

    @_builtins.property
    @pulumi.getter(name="onWarnings")
    def on_warnings(self) -> pulumi.Output[Sequence[_builtins.int]]:
        """
        List of job IDs to trigger the webhook on warning Those will be added/removed when config is added/removed.
        """
        return pulumi.get(self, "on_warnings")

    @_builtins.property
    @pulumi.getter(name="slackChannelId")
    def slack_channel_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Slack channel to receive the notification. It can be found at the bottom of the Slack channel settings [global, used as identifier]
        """
        return pulumi.get(self, "slack_channel_id")

    @_builtins.property
    @pulumi.getter(name="slackChannelName")
    def slack_channel_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the slack channel [global, used as identifier]
        """
        return pulumi.get(self, "slack_channel_name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.int]:
        """
        State of the notification (1 = active (default), 2 = inactive) [global]
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[_builtins.int]:
        """
        Internal dbt Cloud User ID. Must be the user_id for an existing user even if the notification is an external one [global]
        """
        return pulumi.get(self, "user_id")

