# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 dbt_project_subdirectory: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Project resource.
        :param pulumi.Input[_builtins.str] dbt_project_subdirectory: DBT project subdirectory
        :param pulumi.Input[_builtins.str] description: Description for the project. Will show in dbt Explorer.
        :param pulumi.Input[_builtins.str] name: Project name
        :param pulumi.Input[_builtins.int] type: The type of dbt project (0=default or 1=hybrid)
        """
        if dbt_project_subdirectory is not None:
            pulumi.set(__self__, "dbt_project_subdirectory", dbt_project_subdirectory)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="dbtProjectSubdirectory")
    def dbt_project_subdirectory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DBT project subdirectory
        """
        return pulumi.get(self, "dbt_project_subdirectory")

    @dbt_project_subdirectory.setter
    def dbt_project_subdirectory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbt_project_subdirectory", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for the project. Will show in dbt Explorer.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The type of dbt project (0=default or 1=hybrid)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _ProjectState:
    def __init__(__self__, *,
                 dbt_project_subdirectory: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Project resources.
        :param pulumi.Input[_builtins.str] dbt_project_subdirectory: DBT project subdirectory
        :param pulumi.Input[_builtins.str] description: Description for the project. Will show in dbt Explorer.
        :param pulumi.Input[_builtins.str] name: Project name
        :param pulumi.Input[_builtins.int] type: The type of dbt project (0=default or 1=hybrid)
        """
        if dbt_project_subdirectory is not None:
            pulumi.set(__self__, "dbt_project_subdirectory", dbt_project_subdirectory)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="dbtProjectSubdirectory")
    def dbt_project_subdirectory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DBT project subdirectory
        """
        return pulumi.get(self, "dbt_project_subdirectory")

    @dbt_project_subdirectory.setter
    def dbt_project_subdirectory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbt_project_subdirectory", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for the project. Will show in dbt Explorer.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The type of dbt project (0=default or 1=hybrid)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("dbtcloud:index/project:Project")
class Project(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dbt_project_subdirectory: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages a dbt Cloud project.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        dbt_project = dbtcloud.Project("dbt_project", name="Analytics")
        dbt_project_with_description = dbtcloud.Project("dbt_project_with_description",
            name="Analytics with description",
            description="My awesome analytics project")
        dbt_project_with_subdir = dbtcloud.Project("dbt_project_with_subdir",
            name="Analytics in Subdir",
            dbt_project_subdirectory="path")
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_project.my_project

          id = "project_id"

        }

        import {

          to = dbtcloud_project.my_project

          id = "12345"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/project:Project my_project "project_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/project:Project my_project 12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dbt_project_subdirectory: DBT project subdirectory
        :param pulumi.Input[_builtins.str] description: Description for the project. Will show in dbt Explorer.
        :param pulumi.Input[_builtins.str] name: Project name
        :param pulumi.Input[_builtins.int] type: The type of dbt project (0=default or 1=hybrid)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProjectArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a dbt Cloud project.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        dbt_project = dbtcloud.Project("dbt_project", name="Analytics")
        dbt_project_with_description = dbtcloud.Project("dbt_project_with_description",
            name="Analytics with description",
            description="My awesome analytics project")
        dbt_project_with_subdir = dbtcloud.Project("dbt_project_with_subdir",
            name="Analytics in Subdir",
            dbt_project_subdirectory="path")
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_project.my_project

          id = "project_id"

        }

        import {

          to = dbtcloud_project.my_project

          id = "12345"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/project:Project my_project "project_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/project:Project my_project 12345
        ```

        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dbt_project_subdirectory: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            __props__.__dict__["dbt_project_subdirectory"] = dbt_project_subdirectory
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["type"] = type
        super(Project, __self__).__init__(
            'dbtcloud:index/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dbt_project_subdirectory: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.int]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dbt_project_subdirectory: DBT project subdirectory
        :param pulumi.Input[_builtins.str] description: Description for the project. Will show in dbt Explorer.
        :param pulumi.Input[_builtins.str] name: Project name
        :param pulumi.Input[_builtins.int] type: The type of dbt project (0=default or 1=hybrid)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectState.__new__(_ProjectState)

        __props__.__dict__["dbt_project_subdirectory"] = dbt_project_subdirectory
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["type"] = type
        return Project(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dbtProjectSubdirectory")
    def dbt_project_subdirectory(self) -> pulumi.Output[_builtins.str]:
        """
        DBT project subdirectory
        """
        return pulumi.get(self, "dbt_project_subdirectory")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description for the project. Will show in dbt Explorer.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Project name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.int]:
        """
        The type of dbt project (0=default or 1=hybrid)
        """
        return pulumi.get(self, "type")

