# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RedshiftSemanticLayerCredentialArgs', 'RedshiftSemanticLayerCredential']

@pulumi.input_type
class RedshiftSemanticLayerCredentialArgs:
    def __init__(__self__, *,
                 configuration: pulumi.Input['RedshiftSemanticLayerCredentialConfigurationArgs'],
                 credential: pulumi.Input['RedshiftSemanticLayerCredentialCredentialArgs']):
        """
        The set of arguments for constructing a RedshiftSemanticLayerCredential resource.
        :param pulumi.Input['RedshiftSemanticLayerCredentialConfigurationArgs'] configuration: Semantic Layer credential configuration details.
        :param pulumi.Input['RedshiftSemanticLayerCredentialCredentialArgs'] credential: Redshift credential details, but used in the context of the Semantic Layer.
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "credential", credential)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> pulumi.Input['RedshiftSemanticLayerCredentialConfigurationArgs']:
        """
        Semantic Layer credential configuration details.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: pulumi.Input['RedshiftSemanticLayerCredentialConfigurationArgs']):
        pulumi.set(self, "configuration", value)

    @_builtins.property
    @pulumi.getter
    def credential(self) -> pulumi.Input['RedshiftSemanticLayerCredentialCredentialArgs']:
        """
        Redshift credential details, but used in the context of the Semantic Layer.
        """
        return pulumi.get(self, "credential")

    @credential.setter
    def credential(self, value: pulumi.Input['RedshiftSemanticLayerCredentialCredentialArgs']):
        pulumi.set(self, "credential", value)


@pulumi.input_type
class _RedshiftSemanticLayerCredentialState:
    def __init__(__self__, *,
                 configuration: Optional[pulumi.Input['RedshiftSemanticLayerCredentialConfigurationArgs']] = None,
                 credential: Optional[pulumi.Input['RedshiftSemanticLayerCredentialCredentialArgs']] = None):
        """
        Input properties used for looking up and filtering RedshiftSemanticLayerCredential resources.
        :param pulumi.Input['RedshiftSemanticLayerCredentialConfigurationArgs'] configuration: Semantic Layer credential configuration details.
        :param pulumi.Input['RedshiftSemanticLayerCredentialCredentialArgs'] credential: Redshift credential details, but used in the context of the Semantic Layer.
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if credential is not None:
            pulumi.set(__self__, "credential", credential)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['RedshiftSemanticLayerCredentialConfigurationArgs']]:
        """
        Semantic Layer credential configuration details.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['RedshiftSemanticLayerCredentialConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @_builtins.property
    @pulumi.getter
    def credential(self) -> Optional[pulumi.Input['RedshiftSemanticLayerCredentialCredentialArgs']]:
        """
        Redshift credential details, but used in the context of the Semantic Layer.
        """
        return pulumi.get(self, "credential")

    @credential.setter
    def credential(self, value: Optional[pulumi.Input['RedshiftSemanticLayerCredentialCredentialArgs']]):
        pulumi.set(self, "credential", value)


@pulumi.type_token("dbtcloud:index/redshiftSemanticLayerCredential:RedshiftSemanticLayerCredential")
class RedshiftSemanticLayerCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union['RedshiftSemanticLayerCredentialConfigurationArgs', 'RedshiftSemanticLayerCredentialConfigurationArgsDict']]] = None,
                 credential: Optional[pulumi.Input[Union['RedshiftSemanticLayerCredentialCredentialArgs', 'RedshiftSemanticLayerCredentialCredentialArgsDict']]] = None,
                 __props__=None):
        """
        Redshift credential resource. This resource is composed of a Redshift credential and a Semantic Layer configuration. It is used to create a Redshift credential for the Semantic Layer.

        ## Example Usage

        ## Import

        using import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_redshift_semantic_layer_credential.example

          id = "credential_id"

        }

        import {

          to = dbtcloud_redshift_semantic_layer_credential.example

          id = "12345"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/redshiftSemanticLayerCredential:RedshiftSemanticLayerCredential example "credential_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/redshiftSemanticLayerCredential:RedshiftSemanticLayerCredential example 12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RedshiftSemanticLayerCredentialConfigurationArgs', 'RedshiftSemanticLayerCredentialConfigurationArgsDict']] configuration: Semantic Layer credential configuration details.
        :param pulumi.Input[Union['RedshiftSemanticLayerCredentialCredentialArgs', 'RedshiftSemanticLayerCredentialCredentialArgsDict']] credential: Redshift credential details, but used in the context of the Semantic Layer.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RedshiftSemanticLayerCredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Redshift credential resource. This resource is composed of a Redshift credential and a Semantic Layer configuration. It is used to create a Redshift credential for the Semantic Layer.

        ## Example Usage

        ## Import

        using import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_redshift_semantic_layer_credential.example

          id = "credential_id"

        }

        import {

          to = dbtcloud_redshift_semantic_layer_credential.example

          id = "12345"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/redshiftSemanticLayerCredential:RedshiftSemanticLayerCredential example "credential_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/redshiftSemanticLayerCredential:RedshiftSemanticLayerCredential example 12345
        ```

        :param str resource_name: The name of the resource.
        :param RedshiftSemanticLayerCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RedshiftSemanticLayerCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union['RedshiftSemanticLayerCredentialConfigurationArgs', 'RedshiftSemanticLayerCredentialConfigurationArgsDict']]] = None,
                 credential: Optional[pulumi.Input[Union['RedshiftSemanticLayerCredentialCredentialArgs', 'RedshiftSemanticLayerCredentialCredentialArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RedshiftSemanticLayerCredentialArgs.__new__(RedshiftSemanticLayerCredentialArgs)

            if configuration is None and not opts.urn:
                raise TypeError("Missing required property 'configuration'")
            __props__.__dict__["configuration"] = configuration
            if credential is None and not opts.urn:
                raise TypeError("Missing required property 'credential'")
            __props__.__dict__["credential"] = credential
        super(RedshiftSemanticLayerCredential, __self__).__init__(
            'dbtcloud:index/redshiftSemanticLayerCredential:RedshiftSemanticLayerCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configuration: Optional[pulumi.Input[Union['RedshiftSemanticLayerCredentialConfigurationArgs', 'RedshiftSemanticLayerCredentialConfigurationArgsDict']]] = None,
            credential: Optional[pulumi.Input[Union['RedshiftSemanticLayerCredentialCredentialArgs', 'RedshiftSemanticLayerCredentialCredentialArgsDict']]] = None) -> 'RedshiftSemanticLayerCredential':
        """
        Get an existing RedshiftSemanticLayerCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RedshiftSemanticLayerCredentialConfigurationArgs', 'RedshiftSemanticLayerCredentialConfigurationArgsDict']] configuration: Semantic Layer credential configuration details.
        :param pulumi.Input[Union['RedshiftSemanticLayerCredentialCredentialArgs', 'RedshiftSemanticLayerCredentialCredentialArgsDict']] credential: Redshift credential details, but used in the context of the Semantic Layer.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RedshiftSemanticLayerCredentialState.__new__(_RedshiftSemanticLayerCredentialState)

        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["credential"] = credential
        return RedshiftSemanticLayerCredential(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> pulumi.Output['outputs.RedshiftSemanticLayerCredentialConfiguration']:
        """
        Semantic Layer credential configuration details.
        """
        return pulumi.get(self, "configuration")

    @_builtins.property
    @pulumi.getter
    def credential(self) -> pulumi.Output['outputs.RedshiftSemanticLayerCredentialCredential']:
        """
        Redshift credential details, but used in the context of the Semantic Layer.
        """
        return pulumi.get(self, "credential")

