# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SynapseCredentialArgs', 'SynapseCredential']

@pulumi.input_type
class SynapseCredentialArgs:
    def __init__(__self__, *,
                 adapter_type: pulumi.Input[_builtins.str],
                 authentication: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.int],
                 schema: pulumi.Input[_builtins.str],
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_authorization: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SynapseCredential resource.
        :param pulumi.Input[_builtins.str] adapter_type: The type of the adapter (synapse)
        :param pulumi.Input[_builtins.str] authentication: Authentication type (SQL, ActiveDirectoryPassword, ServicePrincipal)
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the Synapse credential in
        :param pulumi.Input[_builtins.str] schema: The schema where to create the dbt models
        :param pulumi.Input[_builtins.str] client_id: The client ID of the Azure Active Directory service principal. This is only used when connecting to Azure SQL with an AAD service principal.
        :param pulumi.Input[_builtins.str] client_secret: The client secret of the Azure Active Directory service principal. This is only used when connecting to Azure SQL with an AAD service principal.
        :param pulumi.Input[_builtins.str] password: The password for the account to connect to. Only used when connection with AD user/pass
        :param pulumi.Input[_builtins.str] schema_authorization: Optionally set this to the principal who should own the schemas created by dbt
        :param pulumi.Input[_builtins.str] tenant_id: The tenant ID of the Azure Active Directory instance. This is only used when connecting to Azure SQL with a service principal.
        :param pulumi.Input[_builtins.str] user: The username of the Synapse account to connect to. Only used when connection with AD user/pass
        """
        pulumi.set(__self__, "adapter_type", adapter_type)
        pulumi.set(__self__, "authentication", authentication)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "schema", schema)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if schema_authorization is not None:
            pulumi.set(__self__, "schema_authorization", schema_authorization)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter(name="adapterType")
    def adapter_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the adapter (synapse)
        """
        return pulumi.get(self, "adapter_type")

    @adapter_type.setter
    def adapter_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "adapter_type", value)

    @_builtins.property
    @pulumi.getter
    def authentication(self) -> pulumi.Input[_builtins.str]:
        """
        Authentication type (SQL, ActiveDirectoryPassword, ServicePrincipal)
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "authentication", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.int]:
        """
        Project ID to create the Synapse credential in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Input[_builtins.str]:
        """
        The schema where to create the dbt models
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client ID of the Azure Active Directory service principal. This is only used when connecting to Azure SQL with an AAD service principal.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client secret of the Azure Active Directory service principal. This is only used when connecting to Azure SQL with an AAD service principal.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for the account to connect to. Only used when connection with AD user/pass
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="schemaAuthorization")
    def schema_authorization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optionally set this to the principal who should own the schemas created by dbt
        """
        return pulumi.get(self, "schema_authorization")

    @schema_authorization.setter
    def schema_authorization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_authorization", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tenant ID of the Azure Active Directory instance. This is only used when connecting to Azure SQL with a service principal.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of the Synapse account to connect to. Only used when connection with AD user/pass
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class _SynapseCredentialState:
    def __init__(__self__, *,
                 adapter_type: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 credential_id: Optional[pulumi.Input[_builtins.int]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_authorization: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SynapseCredential resources.
        :param pulumi.Input[_builtins.str] adapter_type: The type of the adapter (synapse)
        :param pulumi.Input[_builtins.str] authentication: Authentication type (SQL, ActiveDirectoryPassword, ServicePrincipal)
        :param pulumi.Input[_builtins.str] client_id: The client ID of the Azure Active Directory service principal. This is only used when connecting to Azure SQL with an AAD service principal.
        :param pulumi.Input[_builtins.str] client_secret: The client secret of the Azure Active Directory service principal. This is only used when connecting to Azure SQL with an AAD service principal.
        :param pulumi.Input[_builtins.int] credential_id: The internal credential ID
        :param pulumi.Input[_builtins.str] password: The password for the account to connect to. Only used when connection with AD user/pass
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the Synapse credential in
        :param pulumi.Input[_builtins.str] schema: The schema where to create the dbt models
        :param pulumi.Input[_builtins.str] schema_authorization: Optionally set this to the principal who should own the schemas created by dbt
        :param pulumi.Input[_builtins.str] tenant_id: The tenant ID of the Azure Active Directory instance. This is only used when connecting to Azure SQL with a service principal.
        :param pulumi.Input[_builtins.str] user: The username of the Synapse account to connect to. Only used when connection with AD user/pass
        """
        if adapter_type is not None:
            pulumi.set(__self__, "adapter_type", adapter_type)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if schema_authorization is not None:
            pulumi.set(__self__, "schema_authorization", schema_authorization)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter(name="adapterType")
    def adapter_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the adapter (synapse)
        """
        return pulumi.get(self, "adapter_type")

    @adapter_type.setter
    def adapter_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "adapter_type", value)

    @_builtins.property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authentication type (SQL, ActiveDirectoryPassword, ServicePrincipal)
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client ID of the Azure Active Directory service principal. This is only used when connecting to Azure SQL with an AAD service principal.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client secret of the Azure Active Directory service principal. This is only used when connecting to Azure SQL with an AAD service principal.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The internal credential ID
        """
        return pulumi.get(self, "credential_id")

    @credential_id.setter
    def credential_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "credential_id", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for the account to connect to. Only used when connection with AD user/pass
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Project ID to create the Synapse credential in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schema where to create the dbt models
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="schemaAuthorization")
    def schema_authorization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optionally set this to the principal who should own the schemas created by dbt
        """
        return pulumi.get(self, "schema_authorization")

    @schema_authorization.setter
    def schema_authorization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_authorization", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tenant ID of the Azure Active Directory instance. This is only used when connecting to Azure SQL with a service principal.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of the Synapse account to connect to. Only used when connection with AD user/pass
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user", value)


@pulumi.type_token("dbtcloud:index/synapseCredential:SynapseCredential")
class SynapseCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 adapter_type: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_authorization: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Synapse credential resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        # when using sql authentication
        my_synapse_cred_sql = dbtcloud.SynapseCredential("my_synapse_cred_sql",
            project_id=dbt_project["id"],
            authentication="sql",
            schema="my_schema",
            user="my_user",
            password="my_password",
            schema_authorization="abcd")
        # when using AD authentication
        my_synapse_cred_ad = dbtcloud.SynapseCredential("my_synapse_cred_ad",
            project_id=dbt_project["id"],
            authentication="ActiveDirectoryPassword",
            schema="my_schema",
            user="my_user",
            password="my_password",
            schema_authorization="abcd")
        # when using service principal authentication
        my_synapse_cred_serv_princ = dbtcloud.SynapseCredential("my_synapse_cred_serv_princ",
            project_id=dbt_project["id"],
            authentication="ServicePrincipal",
            schema="my_schema",
            client_id="my_client_id",
            tenant_id="my_tenant_id",
            client_secret="my_secret",
            schema_authorization="abcd")
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_synapse_credential.my_synapse_credential

          id = "project_id:credential_id"

        }

        import {

          to = dbtcloud_synapse_credential.my_synapse_credential

          id = "12345:6789"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/synapseCredential:SynapseCredential my_synapse_credential "project_id:credential_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/synapseCredential:SynapseCredential my_synapse_credential 12345:6789
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] adapter_type: The type of the adapter (synapse)
        :param pulumi.Input[_builtins.str] authentication: Authentication type (SQL, ActiveDirectoryPassword, ServicePrincipal)
        :param pulumi.Input[_builtins.str] client_id: The client ID of the Azure Active Directory service principal. This is only used when connecting to Azure SQL with an AAD service principal.
        :param pulumi.Input[_builtins.str] client_secret: The client secret of the Azure Active Directory service principal. This is only used when connecting to Azure SQL with an AAD service principal.
        :param pulumi.Input[_builtins.str] password: The password for the account to connect to. Only used when connection with AD user/pass
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the Synapse credential in
        :param pulumi.Input[_builtins.str] schema: The schema where to create the dbt models
        :param pulumi.Input[_builtins.str] schema_authorization: Optionally set this to the principal who should own the schemas created by dbt
        :param pulumi.Input[_builtins.str] tenant_id: The tenant ID of the Azure Active Directory instance. This is only used when connecting to Azure SQL with a service principal.
        :param pulumi.Input[_builtins.str] user: The username of the Synapse account to connect to. Only used when connection with AD user/pass
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SynapseCredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Synapse credential resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        # when using sql authentication
        my_synapse_cred_sql = dbtcloud.SynapseCredential("my_synapse_cred_sql",
            project_id=dbt_project["id"],
            authentication="sql",
            schema="my_schema",
            user="my_user",
            password="my_password",
            schema_authorization="abcd")
        # when using AD authentication
        my_synapse_cred_ad = dbtcloud.SynapseCredential("my_synapse_cred_ad",
            project_id=dbt_project["id"],
            authentication="ActiveDirectoryPassword",
            schema="my_schema",
            user="my_user",
            password="my_password",
            schema_authorization="abcd")
        # when using service principal authentication
        my_synapse_cred_serv_princ = dbtcloud.SynapseCredential("my_synapse_cred_serv_princ",
            project_id=dbt_project["id"],
            authentication="ServicePrincipal",
            schema="my_schema",
            client_id="my_client_id",
            tenant_id="my_tenant_id",
            client_secret="my_secret",
            schema_authorization="abcd")
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_synapse_credential.my_synapse_credential

          id = "project_id:credential_id"

        }

        import {

          to = dbtcloud_synapse_credential.my_synapse_credential

          id = "12345:6789"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/synapseCredential:SynapseCredential my_synapse_credential "project_id:credential_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/synapseCredential:SynapseCredential my_synapse_credential 12345:6789
        ```

        :param str resource_name: The name of the resource.
        :param SynapseCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SynapseCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 adapter_type: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_authorization: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SynapseCredentialArgs.__new__(SynapseCredentialArgs)

            if adapter_type is None and not opts.urn:
                raise TypeError("Missing required property 'adapter_type'")
            __props__.__dict__["adapter_type"] = adapter_type
            if authentication is None and not opts.urn:
                raise TypeError("Missing required property 'authentication'")
            __props__.__dict__["authentication"] = authentication
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["client_secret"] = None if client_secret is None else pulumi.Output.secret(client_secret)
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            __props__.__dict__["schema_authorization"] = schema_authorization
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["user"] = user
            __props__.__dict__["credential_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientSecret", "password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SynapseCredential, __self__).__init__(
            'dbtcloud:index/synapseCredential:SynapseCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            adapter_type: Optional[pulumi.Input[_builtins.str]] = None,
            authentication: Optional[pulumi.Input[_builtins.str]] = None,
            client_id: Optional[pulumi.Input[_builtins.str]] = None,
            client_secret: Optional[pulumi.Input[_builtins.str]] = None,
            credential_id: Optional[pulumi.Input[_builtins.int]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.int]] = None,
            schema: Optional[pulumi.Input[_builtins.str]] = None,
            schema_authorization: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            user: Optional[pulumi.Input[_builtins.str]] = None) -> 'SynapseCredential':
        """
        Get an existing SynapseCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] adapter_type: The type of the adapter (synapse)
        :param pulumi.Input[_builtins.str] authentication: Authentication type (SQL, ActiveDirectoryPassword, ServicePrincipal)
        :param pulumi.Input[_builtins.str] client_id: The client ID of the Azure Active Directory service principal. This is only used when connecting to Azure SQL with an AAD service principal.
        :param pulumi.Input[_builtins.str] client_secret: The client secret of the Azure Active Directory service principal. This is only used when connecting to Azure SQL with an AAD service principal.
        :param pulumi.Input[_builtins.int] credential_id: The internal credential ID
        :param pulumi.Input[_builtins.str] password: The password for the account to connect to. Only used when connection with AD user/pass
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the Synapse credential in
        :param pulumi.Input[_builtins.str] schema: The schema where to create the dbt models
        :param pulumi.Input[_builtins.str] schema_authorization: Optionally set this to the principal who should own the schemas created by dbt
        :param pulumi.Input[_builtins.str] tenant_id: The tenant ID of the Azure Active Directory instance. This is only used when connecting to Azure SQL with a service principal.
        :param pulumi.Input[_builtins.str] user: The username of the Synapse account to connect to. Only used when connection with AD user/pass
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SynapseCredentialState.__new__(_SynapseCredentialState)

        __props__.__dict__["adapter_type"] = adapter_type
        __props__.__dict__["authentication"] = authentication
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["credential_id"] = credential_id
        __props__.__dict__["password"] = password
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["schema"] = schema
        __props__.__dict__["schema_authorization"] = schema_authorization
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["user"] = user
        return SynapseCredential(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="adapterType")
    def adapter_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the adapter (synapse)
        """
        return pulumi.get(self, "adapter_type")

    @_builtins.property
    @pulumi.getter
    def authentication(self) -> pulumi.Output[_builtins.str]:
        """
        Authentication type (SQL, ActiveDirectoryPassword, ServicePrincipal)
        """
        return pulumi.get(self, "authentication")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[_builtins.str]:
        """
        The client ID of the Azure Active Directory service principal. This is only used when connecting to Azure SQL with an AAD service principal.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[_builtins.str]:
        """
        The client secret of the Azure Active Directory service principal. This is only used when connecting to Azure SQL with an AAD service principal.
        """
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> pulumi.Output[_builtins.int]:
        """
        The internal credential ID
        """
        return pulumi.get(self, "credential_id")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        The password for the account to connect to. Only used when connection with AD user/pass
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.int]:
        """
        Project ID to create the Synapse credential in
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Output[_builtins.str]:
        """
        The schema where to create the dbt models
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="schemaAuthorization")
    def schema_authorization(self) -> pulumi.Output[_builtins.str]:
        """
        Optionally set this to the principal who should own the schemas created by dbt
        """
        return pulumi.get(self, "schema_authorization")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        The tenant ID of the Azure Active Directory instance. This is only used when connecting to Azure SQL with a service principal.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Output[_builtins.str]:
        """
        The username of the Synapse account to connect to. Only used when connection with AD user/pass
        """
        return pulumi.get(self, "user")

