"""activity pub and account tables

Revision ID: bab34046008c
Revises: 35d59ad5716c
Create Date: 2025-08-29 11:55:05.146080

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "bab34046008c"
down_revision: Union[str, Sequence[str], None] = "2f838b29357f"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "account",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=256), nullable=False),
        sa.Column("password_hash", sa.String(length=256), nullable=False),
        sa.Column("meta_information", sa.JSON(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "actor",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("actor_id", sa.String(length=256), nullable=False),
        sa.Column("inbox_uri", sa.String(length=256), nullable=False),
        sa.Column("outbox_uri", sa.String(length=256), nullable=False),
        sa.Column("following_uri", sa.String(length=256), nullable=False),
        sa.Column("followers_uri", sa.String(length=256), nullable=False),
        sa.Column("preferred_username", sa.String(length=256), nullable=True),
        sa.Column("public_key_name", sa.String(length=256), nullable=False),
        sa.Column("public_key", sa.Text(), nullable=False),
        sa.Column("automatically_accept_followers", sa.Boolean(), nullable=False),
        sa.Column("profile", sa.JSON(), nullable=False),
        sa.Column("status", sa.String(length=7), nullable=False),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("actor_id"),
        sa.UniqueConstraint("followers_uri"),
        sa.UniqueConstraint("following_uri"),
        sa.UniqueConstraint("inbox_uri"),
        sa.UniqueConstraint("outbox_uri"),
    )
    op.create_table(
        "credential",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("actor_id", sa.String(length=256), nullable=False),
        sa.Column("identifier", sa.String(length=256), nullable=False),
        sa.Column("secret", sa.Text(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("identifier"),
    )
    op.create_table(
        "inboxlocation",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("actor", sa.String(length=256), nullable=False),
        sa.Column("inbox", sa.String(length=256), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("actor"),
    )
    op.create_table(
        "actorforaccount",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("account_id", sa.Integer(), nullable=False),
        sa.Column("actor", sa.String(length=256), nullable=False),
        sa.Column("name", sa.String(length=256), nullable=False),
        sa.Column("status", sa.String(length=10), nullable=False),
        sa.ForeignKeyConstraint(
            ["account_id"],
            ["account.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "authenticationtoken",
        sa.Column("token", sa.String(length=65), nullable=False),
        sa.Column("account_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["account_id"],
            ["account.id"],
        ),
        sa.PrimaryKeyConstraint("token"),
    )
    op.create_table(
        "blocking",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("actor_id", sa.Integer(), nullable=False),
        sa.Column("blocking", sa.String(length=256), nullable=False),
        sa.Column("request", sa.String(length=256), nullable=False),
        sa.Column("active", sa.Boolean(), nullable=False),
        sa.ForeignKeyConstraint(
            ["actor_id"],
            ["actor.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "follower",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("actor_id", sa.Integer(), nullable=False),
        sa.Column("follower", sa.String(length=256), nullable=False),
        sa.Column("request", sa.String(length=256), nullable=False),
        sa.Column("accepted", sa.Boolean(), nullable=False),
        sa.ForeignKeyConstraint(
            ["actor_id"],
            ["actor.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "following",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("actor_id", sa.Integer(), nullable=False),
        sa.Column("following", sa.String(length=256), nullable=False),
        sa.Column("request", sa.String(length=256), nullable=False),
        sa.Column("accepted", sa.Boolean(), nullable=False),
        sa.ForeignKeyConstraint(
            ["actor_id"],
            ["actor.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "permission",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("account_id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=256), nullable=False),
        sa.ForeignKeyConstraint(
            ["account_id"],
            ["account.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "publicidentifier",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("actor_id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=256), nullable=False),
        sa.Column("identifier", sa.String(length=256), nullable=False),
        sa.Column("preference", sa.Integer(), nullable=False),
        sa.Column("status", sa.String(length=10), nullable=False),
        sa.ForeignKeyConstraint(
            ["actor_id"],
            ["actor.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("identifier"),
    )
    op.create_table(
        "storedactivity",
        sa.Column("id", sa.String(length=256), nullable=False),
        sa.Column("actor_id", sa.Integer(), nullable=False),
        sa.Column("data", sa.JSON(), nullable=False),
        sa.Column("published", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(
            ["actor_id"],
            ["actor.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "actorgroup",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=256), nullable=False),
        sa.Column("actor_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["actor_id"],
            ["actorforaccount.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("actorgroup")
    op.drop_table("storedactivity")
    op.drop_table("publicidentifier")
    op.drop_table("permission")
    op.drop_table("following")
    op.drop_table("follower")
    op.drop_table("blocking")
    op.drop_table("authenticationtoken")
    op.drop_table("actorforaccount")
    op.drop_table("inboxlocation")
    op.drop_table("credential")
    op.drop_table("actor")
    op.drop_table("account")
    # ### end Alembic commands ###
