# cattle_grid account api sdk

The aim here is to create a client sdk for the cattle
grid account api. This package is autogenerated
using [@hey-api/openapi-ts](https://heyapi.dev/openapi-ts/get-started).

For background on cattle_grid, see [here](https://bovine.codeberg.page/cattle_grid/).

- [cattle_grid](https://bovine.codeberg.page/cattle_grid/)
- [npm](https://www.npmjs.com/package/@cattle-grid/account-api)
- [repository @ codeberg.org](https://codeberg.org/bovine/cattle_grid)
- [API documentation](https://bovine.codeberg.page/cattle_grid/assets/redoc.html?url=openapi_account.json)

This API does not support event sources directly. For how to use
them see [Event Sources](#event-sources)

## Usage

Import the relevant methods and configure the client with
the `baseUrl`.

```js
import { signin, accountInfo } from "@cattle-grid/account-api";
import { client } from "@cattle-grid/account-api/client";

client.setConfig({
  baseUrl: "http://localhost:3001/fe",
});
```

### Signin

One can sign in into an account with the account name and the
corresponding password. For further requests, you will need the
bearer token.

```js
let result = await signin({ body: { name: "js", password: "js" } });

const bearerToken = result.data.token;
```

### Setting the bearer token

This is done via:

```js
client.interceptors.request.use(async (request) => { 
  request.headers.set("Authorization", "Bearer " + bearerToken);
  return request;
});
```

### Getting account info

This can be done via

```js
const result = await accountInfo();
```

The response data is in `result.data` the status code
can be retrieved from `result.response.status`.

Furthermore methods can be discovered via `sdk.gen`.

## Event Sources

As we use Bearer authentication, you cannot use a vanilla event
source as provided by the browser. Instead, you have to use
a polyfill such as [extended-eventsource](https://www.npmjs.com/package/extended-eventsource).

Once you have this, usage is like this

```js
import { EventSource } from "extended-eventsource";

const eventSource = new EventSource(`/fe/account/stream/${eventType}`, {
  headers: {
    Authorization: `Bearer ${token}`,
  },
});


eventSource.addEventListener("message", (event) => {
  const parsed = JSON.parse(event.data);
  console.log(parsed);
});
```

Here `eventType` is one of `incoming`, `outgoing`, or `error`.
