# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .graph_data_type import GraphDataType
from .role_type import RoleType


class Episode(UniversalBaseModel):
    content: str
    created_at: str
    processed: typing.Optional[bool] = None
    role: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional role, will only be present if the episode was created using memory.add API
    """

    role_type: typing.Optional[RoleType] = pydantic.Field(default=None)
    """
    Optional role_type, will only be present if the episode was created using memory.add API
    """

    score: typing.Optional[float] = None
    session_id: typing.Optional[str] = None
    source: typing.Optional[GraphDataType] = None
    source_description: typing.Optional[str] = None
    uuid_: typing_extensions.Annotated[str, FieldMetadata(alias="uuid")]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
