# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.fact_rating_instruction import FactRatingInstruction
from ..types.success_response import SuccessResponse
from ..types.thread import Thread
from ..types.user import User
from ..types.user_list_response import UserListResponse
from ..types.user_node_response import UserNodeResponse
from .raw_client import AsyncRawUserClient, RawUserClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class UserClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawUserClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawUserClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawUserClient
        """
        return self._raw_client

    def add(
        self,
        *,
        user_id: str,
        email: typing.Optional[str] = OMIT,
        fact_rating_instruction: typing.Optional[FactRatingInstruction] = OMIT,
        first_name: typing.Optional[str] = OMIT,
        last_name: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> User:
        """
        Adds a user.

        Parameters
        ----------
        user_id : str
            The unique identifier of the user.

        email : typing.Optional[str]
            The email address of the user.

        fact_rating_instruction : typing.Optional[FactRatingInstruction]
            Optional instruction to use for fact rating.

        first_name : typing.Optional[str]
            The first name of the user.

        last_name : typing.Optional[str]
            The last name of the user.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The metadata associated with the user.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        User
            The user that was added.

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.user.add(
            user_id="user_id",
        )
        """
        _response = self._raw_client.add(
            user_id=user_id,
            email=email,
            fact_rating_instruction=fact_rating_instruction,
            first_name=first_name,
            last_name=last_name,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    def list_ordered(
        self,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UserListResponse:
        """
        Returns all users.

        Parameters
        ----------
        page_number : typing.Optional[int]
            Page number for pagination, starting from 1

        page_size : typing.Optional[int]
            Number of users to retrieve per page

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserListResponse
            Successfully retrieved list of users

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.user.list_ordered()
        """
        _response = self._raw_client.list_ordered(
            page_number=page_number, page_size=page_size, request_options=request_options
        )
        return _response.data

    def get(self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> User:
        """
        Returns a user.

        Parameters
        ----------
        user_id : str
            The user_id of the user to get.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        User
            The user that was retrieved.

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.user.get(
            user_id="userId",
        )
        """
        _response = self._raw_client.get(user_id, request_options=request_options)
        return _response.data

    def delete(self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> SuccessResponse:
        """
        Deletes a user.

        Parameters
        ----------
        user_id : str
            User ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.user.delete(
            user_id="userId",
        )
        """
        _response = self._raw_client.delete(user_id, request_options=request_options)
        return _response.data

    def update(
        self,
        user_id: str,
        *,
        email: typing.Optional[str] = OMIT,
        fact_rating_instruction: typing.Optional[FactRatingInstruction] = OMIT,
        first_name: typing.Optional[str] = OMIT,
        last_name: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> User:
        """
        Updates a user.

        Parameters
        ----------
        user_id : str
            User ID

        email : typing.Optional[str]
            The email address of the user.

        fact_rating_instruction : typing.Optional[FactRatingInstruction]
            Optional instruction to use for fact rating.

        first_name : typing.Optional[str]
            The first name of the user.

        last_name : typing.Optional[str]
            The last name of the user.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The metadata to update

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        User
            The user that was updated.

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.user.update(
            user_id="userId",
        )
        """
        _response = self._raw_client.update(
            user_id,
            email=email,
            fact_rating_instruction=fact_rating_instruction,
            first_name=first_name,
            last_name=last_name,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    def get_node(self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> UserNodeResponse:
        """
        Returns a user's node.

        Parameters
        ----------
        user_id : str
            The user_id of the user to get the node for.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserNodeResponse
            Response object containing the User node.

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.user.get_node(
            user_id="userId",
        )
        """
        _response = self._raw_client.get_node(user_id, request_options=request_options)
        return _response.data

    def get_threads(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[Thread]:
        """
        Returns all threads for a user.

        Parameters
        ----------
        user_id : str
            User ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Thread]
            OK

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.user.get_threads(
            user_id="userId",
        )
        """
        _response = self._raw_client.get_threads(user_id, request_options=request_options)
        return _response.data


class AsyncUserClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawUserClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawUserClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawUserClient
        """
        return self._raw_client

    async def add(
        self,
        *,
        user_id: str,
        email: typing.Optional[str] = OMIT,
        fact_rating_instruction: typing.Optional[FactRatingInstruction] = OMIT,
        first_name: typing.Optional[str] = OMIT,
        last_name: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> User:
        """
        Adds a user.

        Parameters
        ----------
        user_id : str
            The unique identifier of the user.

        email : typing.Optional[str]
            The email address of the user.

        fact_rating_instruction : typing.Optional[FactRatingInstruction]
            Optional instruction to use for fact rating.

        first_name : typing.Optional[str]
            The first name of the user.

        last_name : typing.Optional[str]
            The last name of the user.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The metadata associated with the user.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        User
            The user that was added.

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.add(
                user_id="user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.add(
            user_id=user_id,
            email=email,
            fact_rating_instruction=fact_rating_instruction,
            first_name=first_name,
            last_name=last_name,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    async def list_ordered(
        self,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UserListResponse:
        """
        Returns all users.

        Parameters
        ----------
        page_number : typing.Optional[int]
            Page number for pagination, starting from 1

        page_size : typing.Optional[int]
            Number of users to retrieve per page

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserListResponse
            Successfully retrieved list of users

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.list_ordered()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_ordered(
            page_number=page_number, page_size=page_size, request_options=request_options
        )
        return _response.data

    async def get(self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> User:
        """
        Returns a user.

        Parameters
        ----------
        user_id : str
            The user_id of the user to get.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        User
            The user that was retrieved.

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.get(
                user_id="userId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(user_id, request_options=request_options)
        return _response.data

    async def delete(self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> SuccessResponse:
        """
        Deletes a user.

        Parameters
        ----------
        user_id : str
            User ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.delete(
                user_id="userId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(user_id, request_options=request_options)
        return _response.data

    async def update(
        self,
        user_id: str,
        *,
        email: typing.Optional[str] = OMIT,
        fact_rating_instruction: typing.Optional[FactRatingInstruction] = OMIT,
        first_name: typing.Optional[str] = OMIT,
        last_name: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> User:
        """
        Updates a user.

        Parameters
        ----------
        user_id : str
            User ID

        email : typing.Optional[str]
            The email address of the user.

        fact_rating_instruction : typing.Optional[FactRatingInstruction]
            Optional instruction to use for fact rating.

        first_name : typing.Optional[str]
            The first name of the user.

        last_name : typing.Optional[str]
            The last name of the user.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The metadata to update

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        User
            The user that was updated.

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.update(
                user_id="userId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            user_id,
            email=email,
            fact_rating_instruction=fact_rating_instruction,
            first_name=first_name,
            last_name=last_name,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    async def get_node(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> UserNodeResponse:
        """
        Returns a user's node.

        Parameters
        ----------
        user_id : str
            The user_id of the user to get the node for.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserNodeResponse
            Response object containing the User node.

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.get_node(
                user_id="userId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_node(user_id, request_options=request_options)
        return _response.data

    async def get_threads(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[Thread]:
        """
        Returns all threads for a user.

        Parameters
        ----------
        user_id : str
            User ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Thread]
            OK

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.get_threads(
                user_id="userId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_threads(user_id, request_options=request_options)
        return _response.data
