# OpenFisca-France

[![Newsletter](https://img.shields.io/badge/newsletter-subscribe!-informational.svg?style=flat)](mailto:contact%40openfisca.org?subject=Subscribe%20to%20your%20newsletter%20%7C%20S'inscrire%20%C3%A0%20votre%20newsletter&body=%5BEnglish%20version%20below%5D%0A%0ABonjour%2C%0A%0AVotre%C2%A0pr%C3%A9sence%C2%A0ici%C2%A0nous%C2%A0ravit%C2%A0!%20%F0%9F%98%83%0A%0AEnvoyez-nous%20cet%20email%20pour%20que%20l'on%20puisse%20vous%20inscrire%20%C3%A0%20la%20newsletter.%20%0A%0AAh%C2%A0!%20Et%20si%20vous%20pouviez%20remplir%20ce%20petit%20questionnaire%2C%20%C3%A7a%20serait%20encore%20mieux%C2%A0!%0Ahttps%3A%2F%2Fgoo.gl%2Fforms%2F45M0VR1TYKD1RGzX2%0A%0AAmiti%C3%A9%2C%0AL%E2%80%99%C3%A9quipe%20OpenFisca%0A%0A%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%20ENGLISH%20VERSION%20%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%0A%0AHi%2C%20%0A%0AWe're%20glad%20to%20see%20you%20here!%20%F0%9F%98%83%0A%0APlease%20send%20us%20this%20email%2C%20so%20we%20can%20subscribe%20you%20to%20the%20newsletter.%0A%0AAlso%2C%20if%20you%20can%20fill%20out%20this%20short%20survey%2C%20even%20better!%0Ahttps%3A%2F%2Fgoo.gl%2Fforms%2FsOg8K1abhhm441LG2%0A%0ACheers%2C%0AThe%20OpenFisca%20Team)
[![Twitter](https://img.shields.io/badge/twitter-follow%20us!-9cf.svg?style=flat)](https://twitter.com/intent/follow?screen_name=openfisca)
[![Slack](https://img.shields.io/badge/slack-join%20us!-blueviolet.svg?style=flat)](mailto:contact%40openfisca.org?subject=Join%20you%20on%20Slack%20%7C%20Nous%20rejoindre%20sur%20Slack&body=%5BEnglish%20version%20below%5D%0A%0ABonjour%2C%0A%0AVotre%C2%A0pr%C3%A9sence%C2%A0ici%C2%A0nous%C2%A0ravit%C2%A0!%20%F0%9F%98%83%0A%0ARacontez-nous%20un%20peu%20de%20vous%2C%20et%20du%20pourquoi%20de%20votre%20int%C3%A9r%C3%AAt%20de%20rejoindre%20la%20communaut%C3%A9%20OpenFisca%20sur%20Slack.%0A%0AAh%C2%A0!%20Et%20si%20vous%20pouviez%20remplir%20ce%20petit%20questionnaire%2C%20%C3%A7a%20serait%20encore%20mieux%C2%A0!%0Ahttps%3A%2F%2Fgoo.gl%2Fforms%2F45M0VR1TYKD1RGzX2%0A%0AN%E2%80%99oubliez%20pas%20de%20nous%20envoyer%20cet%20email%C2%A0!%20Sinon%2C%20on%20ne%20pourra%20pas%20vous%20contacter%20ni%20vous%20inviter%20sur%20Slack.%0A%0AAmiti%C3%A9%2C%0AL%E2%80%99%C3%A9quipe%20OpenFisca%0A%0A%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%20ENGLISH%20VERSION%20%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%0A%0AHi%2C%20%0A%0AWe're%20glad%20to%20see%20you%20here!%20%F0%9F%98%83%0A%0APlease%20tell%20us%20a%20bit%20about%20you%20and%20why%20you%20want%20to%20join%20the%20OpenFisca%20community%20on%20Slack.%0A%0AAlso%2C%20if%20you%20can%20fill%20out%20this%20short%20survey%2C%20even%20better!%0Ahttps%3A%2F%2Fgoo.gl%2Fforms%2FsOg8K1abhhm441LG2.%0A%0ADon't%20forget%20to%20send%20us%20this%20email!%20Otherwise%20we%20won't%20be%20able%20to%20contact%20you%20back%2C%20nor%20invite%20you%20on%20Slack.%0A%0ACheers%2C%0AThe%20OpenFisca%20Team)
[![Python](https://img.shields.io/pypi/pyversions/openfisca-france.svg)](https://pypi.python.org/pypi/openfisca-france)
[![PyPi](https://img.shields.io/pypi/v/openfisca-france.svg?style=flat)](https://pypi.python.org/pypi/openfisca-france)
[![Gitpod](https://camo.githubusercontent.com/1eb1ddfea6092593649f0117f7262ffa8fbd3017/68747470733a2f2f676974706f642e696f2f627574746f6e2f6f70656e2d696e2d676974706f642e737667)](https://gitpod-referer.now.sh/api/gitpod-referer-redirect)

## [EN] Introduction

OpenFisca is a versatile microsimulation free software. This repository contains the OpenFisca model of the French tax and benefit system. Therefore, the working language here is French. You can however check the [general OpenFisca documentation](https://openfisca.org/doc/) in English!
> We host a public instance of of the [OpenFisca-France Web API](https://api.fr.openfisca.org/latest/). Learn more about its endpoint in the [Swagger documentation](https://legislation.fr.openfisca.org/swagger).
> If you need to run large amount of calculations, or add extensions, you should [host your own instance](#servez-openfisca-france-avec-lapi-web-openfisca).

## [FR] Introduction

[OpenFisca](https://www.openfisca.fr/) est un logiciel libre de micro-simulation. Ce dépôt contient la modélisation du système social et fiscal français. Pour plus d'information sur les fonctionnalités et la manière d'utiliser OpenFisca, vous pouvez consulter la [documentation générale](https://openfisca.org/doc/).
> Nous mettons à disposition une instance publique de [l'API Web OpenFisca-France](https://api.fr.openfisca.org/latest/). Découvrez ses capacité sur sa [documentation Swagger](https://legislation.fr.openfisca.org/swagger).
> Si vous avez besoin de réaliser un grand nombre de calculs ou d'ajouter des extensions, vous pouvez [servir votre propre instance](#servez-openfisca-france-avec-lapi-web-openfisca).

## API Web publique : interrogez OpenFisca-France sans installation

OpenFisca met à disposition une [API Web publique](https://openfisca.org/doc/openfisca-web-api/endpoints.html) qui ne demande aucune installation.
Utilisez l'API publique si vous souhaitez :
- accéder à un paramètre (Ex : [le montant du Smic horaire brut](https://api.fr.openfisca.org/latest/parameter/marche_travail.salaire_minimum.smic.smic_b_horaire)) ;
- consulter une formule de calcul (Ex : [le calcul de l'allocation de base des allocations familiales](https://api.fr.openfisca.org/latest/variable/af_base)) ;
- faire des calculs sur une situation (Ex : le calcul du coût du travail).

L'ensembles des endpoints sont décrits dans la [documentation Swagger](https://legislation.fr.openfisca.org/swagger).

[L'explorateur de législation](https://legislation.fr.openfisca.org/swagger) contient la liste des paramètres et variables disponibles.

## Installation

Ce paquet requiert [Python 3.9](https://www.python.org/downloads/release/python-390/) et [pip](https://pip.pypa.io/en/stable/installing/) ou [conda](https://www.anaconda.com/products/individual) ou [UV](https://docs.astral.sh/uv/).

Plateformes supportées :
- distributions GNU/Linux (en particulier Debian and Ubuntu) ;
- Mac OS X ;
- Windows : Nous recommandons d'utiliser [UV](https://docs.astral.sh/uv/) car [conda](https://www.anaconda.com/products/individual) ne va surement plus être supporté par la communauté OpenFisca, si vous souhaitez tout de même l'utiliser, voir la procédure ci-dessous [Installez un environnement virtuel avec conda](./README.md#installez-un-environnement-virtuel-avec-conda)  ; OpenFisca fonctionne également dans le [sous-système Windows pour Linux (WSL)](https://docs.microsoft.com/fr-fr/windows/wsl/install). Dans ce dernier cas, il suffit de suivre la procédure pour Linux car vous êtes alors dans un environnement Linux.

Pour les autres OS : si vous pouvez exécuter Python et Numpy, l'installation d'OpenFisca devrait fonctionner.

### A. Installation minimale, sans les sources

Suivez cette installation si vous souhaitez :
- procéder à des calculs sur une large population ;
- créer des simulations fiscales ;
- écrire une extension au-dessus de la législation française (exemple : les extensions de [Paris](https://github.com/sgmap/openfisca-paris) et [Rennes](https://github.com/sgmap/openfisca-rennesmetropole) ;
- servir OpenFisca-France avec l'API Web OpenFisca.

Pour pouvoir modifier OpenFisca-France, consultez l'[Installation avancée](#b-installation-avancée-git-clone).

#### Installer OpenFisca-France avec pip install

Placer vous dans le répertoire où vous souhaitez faire vos développements, puis :

```sh
uv init
```

Ensuite, installez OpenFisca-France :

```sh
uv add openfisca-france
uv add openfisca-core[web-api]
```
> _Note: La deuxième commande est optionnelle. Elle vous permet d'installer l'API Web d'OpenFisca._

Félicitations :tada: OpenFisca-France est prêt à être utilisé !

Vous pouvez vous assurer que votre installation s'est bien passée en exécutant :

```sh
uv run openfisca -h
```

#### Prochaines étapes

- Apprenez à utiliser OpenFisca avec nos [tutoriels](https://openfisca.org/doc/) (en anglais).
- Hébergez et servez votre instance d'OpenFisca-France avec l'[API Web OpenFisca](#servez-openfisca-france-avec-lapi-web-openfisca).

En fonction de vos projets, vous pourriez bénéficier de l'installation des paquets suivants dans votre _virtualenv_ :
- pour installer une extension ou écrire une législation au-dessus d'OpenFisca-France, consultez la [documentation sur les extensions](https://openfisca.org/doc/contribute/extensions.html) (en anglais) ;
- pour représenter graphiquement vos résultats, essayez la bibliothèque [matplotlib](http://matplotlib.org/) ;
- pour gérer vos données, découvrez la bibliothèque [pandas](http://pandas.pydata.org/).

### B. Installation avancée (Git Clone)

Suivez cette installation si vous souhaitez :
- enrichir ou modifier la législation d'OpenFisca-France ;
- contribuer au code source d'OpenFisca-France.

#### Cloner OpenFisca-France avec Git

Premièrement, assurez-vous que [Git](https://www.git-scm.com/) est bien installé sur votre machine.

Dans votre _virtualenv_, assurez-vous que vous êtes dans le répertoire où vous souhaitez cloner OpenFisca-France.

Clonez OpenFisca-France sur votre machine :

```sh
git clone https://github.com/openfisca/openfisca-france.git
cd openfisca-france
```

Vous pouvez vous assurer que votre installation s'est bien passée en exécutant :

```sh
uv run pytest tests/test_basics.py # Ces test peuvent prendre jusqu'à 60 secondes.
```
:tada: OpenFisca-France est prêt à être utilisé !

### Installez un environnement virtuel avec conda

Nous ne conseillons plus cette procédure, même pour les personnes utilisant Windows, il est préférable d'utiliser `uv`. En effet, nous pensons arrêter de supporter `conda` dans OpenFisca. Si vous en avez besoin, n'hésitez pas à ouvrir une issue sur le dépôt GitHub d'OpenFisca-France et nous expliquer votre cas d'utilisation.

Ceci vous permet d'obtenir en une seule installation :
- Python
- Le gestionnaire de paquets [Anaconda.org](https://docs.anaconda.com/anacondaorg/user-guide/)
- Le gestionnaire d'environnement Python virtuel : [conda](https://docs.conda.io/projects/conda/en/latest/user-guide/tasks/manage-environments.html)

Voici les étapes à suivre :

- Installer la version communautaire/gratuite en suivant la procédure décrite sur [le site Anaconda](https://www.anaconda.com/products/individual). A noter que Anaconda occupe beaucoup d'espace disque (>2 Go), vous pouvez installer à la place [Miniconda](https://docs.conda.io/projects/conda/en/latest/user-guide/install/windows.html) qui occupe beaucoup moins d'espace disque. Cependant vous n'aurez pas l'interface graphique [Anaconda Navigator](https://docs.anaconda.com/anaconda/navigator/index.html) qui vous permet de gérer vos environnements. Si vous êtes habituée à gérer les choses en ligne de commande, préfèrez Miniconda.
- Depuis le menu démarrer, exécuter `Anaconda Powershell Prompt`. Ou utiliser votre shell préféré avec Miniconda, il vous faudra peut-être utiliser la commande `conda init`, mais conda vous le dira.
- Exécuter les commandes suivantes dans le shell:
  - Ajouter `conda-forge` comme channel par défaut : `conda config --add channels conda-forge && conda config --set channel_priority strict `
  - Créer un environnement virtuel dédié : `conda create --name openfisca python=3.9`
  - Activer l'environnement : `conda activate openfisca`
  - Installer OpenFisca : `conda install openfisca-france`

:tada: OpenFisca-France est prêt à être utilisé !

Ensuite, pour quitter l'environnement OpenFisca : `conda deactivate`

Pour y revenir : `conda activate openfisca`

A noter que OpenFisca-France est présent sur [conda-forge](https://anaconda.org/conda-forge/openfisca-france) et sur un _channel_ dédié [openfisca](https://anaconda.org/openfisca/openfisca-france). C'est conda-forge qui est mis en avant dans cette documentation, car accessible par défaut dans les installations Anaconda.

A noter que l'installation d'Openfisca-France peut lever une erreur sur certaines machines Windows à cause de la longueur des chemins de certains fichiers de paramètres et des restrictions de longueur de chemin sous Windows. Une option possible pour résoudre ce problème est de lever cette limite (voir cette documentation pour [Windows >=10](https://learn.microsoft.com/en-us/windows/win32/fileio/maximum-file-path-limitation?tabs=registry#enable-long-paths-in-windows-10-version-1607-and-later))

#### Prochaines étapes

- Pour enrichir ou faire évoluer la législation d'OpenFisca-France, lisez _[Coding the Legislation](https://openfisca.org/doc/coding-the-legislation/index.html)_ (en anglais).
- Pour contribuer au code, lisez le _[Contribution Guidebook](https://openfisca.org/doc/contribute/index.html)_ (en anglais).

## Testing

Pour faire tourner les tests d'OpenFisca-France, exécutez la commande suivante :

```sh
uv run make test
```

Pour utiliser une version spécifique de Python :

```sh
uv run  --python 3.12.3 make test
```

## Style

Ce dépôt adhère à un style de code précis, et on vous invite à le suivre pour que vos contributions soient intégrées au plus vite.

L'analyse de style est déjà exécutée avec `uv run make test`. Pour le faire tourner de façon indépendante :

```sh
uv run make check-style
```

Pour corriger les erreurs de style de façon automatique:

```sh
uv run make format-style
```

Pour corriger les erreurs de style de façon automatique à chaque fois que vous faites un _commit_ :

```sh
touch .git/hooks/pre-commit
chmod +x .git/hooks/pre-commit

tee -a .git/hooks/pre-commit << END
#!/bin/sh
#
# Automatically format your code before committing.
exec make format-style
END
```

## Servez OpenFisca-France avec l'API Web OpenFisca

Il est possible de servir l'API Web d'OpenFisca-France sur votre propre serveur :

```sh
uv run openfisca serve
```

Pour en savoir plus sur la commande `uv run openfisca serve` et ses options, consultez la [documentation de référence](https://openfisca.org/doc/openfisca-python-api/openfisca_serve.html).

Testez votre installation en requêtant la commande suivante :

```sh
curl "http://localhost:5000/parameter/marche_travail.salaire_minimum.smic.smic_b_horaire"
```
Vous devriez avoir le resultat suivant :
```JSON
{
  "description": "Smic horaire brut",
  "id": "marche_travail.salaire_minimum.smic.smic_b_horaire",
  "values": {
    "2001-08-01": 6.67,
    "2002-07-01": 6.83,
    "2003-07-01": 7.19,
    "2004-07-01": 7.61,
    "2005-07-01": 8.03,
    "2006-07-01": 8.27,
    "2007-07-01": 8.44,
    "2008-05-01": 8.63,
    "2008-07-01": 8.71,
    "2009-07-01": 8.82,
    "2010-01-01": 8.86,
    "2011-01-01": 9.0,
    "2011-12-01": 9.19,
    "2012-01-01": 9.22,
    "2012-07-01": 9.4,
    "2013-01-01": 9.43,
    "2014-01-01": 9.53,
    "2015-01-01": 9.61,
    "2016-01-01": 9.67,
    "2017-01-01": 9.76
  }
}
```

:tada: Vous servez OpenFisca-France via l'API Web OpenFisca !

Pour en savoir plus, explorez [la documentation de l'API Web](https://legislation.fr.openfisca.org/swagger).

Vous pouvez activer le suivi des visites sur votre instance via Piwik avec _[le Tracker API OpenFisca](https://github.com/openfisca/tracker)_ (en anglais).

## Stratégie de versionnement

Le code d'OpenFisca-France est déployé de manière continue et automatique. Ainsi, à chaque fois que le code de la législation évolue sur la branche principale `master`, une nouvelle version est publiée.

De nouvelles versions sont donc publiées très régulièrement. Cependant, la différence entre deux versions consécutives étant réduite, les efforts d'adaptation pour passer de l'une à l'autre sont en général très limités.

Par ailleurs, OpenFisca-France respecte les règles du [versionnement sémantique](http://semver.org/). Tous les changements qui ne font pas l'objet d'une augmentation du numéro majeur de version sont donc garantis rétro-compatibles.

> Par exemple, si mon application utilise la version `13.1.1`, je sais qu'elle fonctionnera également avec la version `13.2.0`. En revanche, il est possible qu'une adaptation soit nécessaire sur mon client pour pouvoir utiliser la version `14.0.0`.

Enfin, les impacts et périmètres des évolutions sont tous documentés sur le [CHANGELOG](CHANGELOG.md) du package. Ce document permet aux contributeurs de suivre les évolutions et d'établir leur propre stratégie de mise à jour.

## Contributeurs

Voir la [liste des contributeurs](https://github.com/openfisca/openfisca-france/graphs/contributors).
