# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict


class BucketInfo(TeaModel):
    def __init__(
        self,
        bucket_acl: str = None,
        bucket_name: str = None,
        comment: str = None,
        create_time: str = None,
        data_redundancy_type: str = None,
        dispatcher_type: str = None,
        endpoint: str = None,
        ens_region_id: str = None,
        modify_time: str = None,
        resource_type: str = None,
        storage_class: str = None,
    ):
        self.bucket_acl = bucket_acl
        # This parameter is required.
        self.bucket_name = bucket_name
        self.comment = comment
        self.create_time = create_time
        self.data_redundancy_type = data_redundancy_type
        self.dispatcher_type = dispatcher_type
        self.endpoint = endpoint
        self.ens_region_id = ens_region_id
        self.modify_time = modify_time
        self.resource_type = resource_type
        self.storage_class = storage_class

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket_acl is not None:
            result['BucketAcl'] = self.bucket_acl
        if self.bucket_name is not None:
            result['BucketName'] = self.bucket_name
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.data_redundancy_type is not None:
            result['DataRedundancyType'] = self.data_redundancy_type
        if self.dispatcher_type is not None:
            result['DispatcherType'] = self.dispatcher_type
        if self.endpoint is not None:
            result['Endpoint'] = self.endpoint
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.storage_class is not None:
            result['StorageClass'] = self.storage_class
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BucketAcl') is not None:
            self.bucket_acl = m.get('BucketAcl')
        if m.get('BucketName') is not None:
            self.bucket_name = m.get('BucketName')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DataRedundancyType') is not None:
            self.data_redundancy_type = m.get('DataRedundancyType')
        if m.get('DispatcherType') is not None:
            self.dispatcher_type = m.get('DispatcherType')
        if m.get('Endpoint') is not None:
            self.endpoint = m.get('Endpoint')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('StorageClass') is not None:
            self.storage_class = m.get('StorageClass')
        return self


class DataDisk(TeaModel):
    def __init__(
        self,
        size: int = None,
    ):
        self.size = size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class HealthCheck(TeaModel):
    def __init__(
        self,
        health_check: str = None,
        health_check_connect_port: int = None,
        health_check_connect_timeout: int = None,
        health_check_domain: str = None,
        health_check_http_code: str = None,
        health_check_interval: int = None,
        health_check_method: str = None,
        health_check_timeout: int = None,
        health_check_type: str = None,
        health_check_uri: str = None,
        healthy_threshold: int = None,
        unhealthy_threshold: int = None,
    ):
        self.health_check = health_check
        self.health_check_connect_port = health_check_connect_port
        self.health_check_connect_timeout = health_check_connect_timeout
        self.health_check_domain = health_check_domain
        self.health_check_http_code = health_check_http_code
        self.health_check_interval = health_check_interval
        self.health_check_method = health_check_method
        self.health_check_timeout = health_check_timeout
        self.health_check_type = health_check_type
        self.health_check_uri = health_check_uri
        self.healthy_threshold = healthy_threshold
        self.unhealthy_threshold = unhealthy_threshold

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.health_check is not None:
            result['HealthCheck'] = self.health_check
        if self.health_check_connect_port is not None:
            result['HealthCheckConnectPort'] = self.health_check_connect_port
        if self.health_check_connect_timeout is not None:
            result['HealthCheckConnectTimeout'] = self.health_check_connect_timeout
        if self.health_check_domain is not None:
            result['HealthCheckDomain'] = self.health_check_domain
        if self.health_check_http_code is not None:
            result['HealthCheckHttpCode'] = self.health_check_http_code
        if self.health_check_interval is not None:
            result['HealthCheckInterval'] = self.health_check_interval
        if self.health_check_method is not None:
            result['HealthCheckMethod'] = self.health_check_method
        if self.health_check_timeout is not None:
            result['HealthCheckTimeout'] = self.health_check_timeout
        if self.health_check_type is not None:
            result['HealthCheckType'] = self.health_check_type
        if self.health_check_uri is not None:
            result['HealthCheckURI'] = self.health_check_uri
        if self.healthy_threshold is not None:
            result['HealthyThreshold'] = self.healthy_threshold
        if self.unhealthy_threshold is not None:
            result['UnhealthyThreshold'] = self.unhealthy_threshold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HealthCheck') is not None:
            self.health_check = m.get('HealthCheck')
        if m.get('HealthCheckConnectPort') is not None:
            self.health_check_connect_port = m.get('HealthCheckConnectPort')
        if m.get('HealthCheckConnectTimeout') is not None:
            self.health_check_connect_timeout = m.get('HealthCheckConnectTimeout')
        if m.get('HealthCheckDomain') is not None:
            self.health_check_domain = m.get('HealthCheckDomain')
        if m.get('HealthCheckHttpCode') is not None:
            self.health_check_http_code = m.get('HealthCheckHttpCode')
        if m.get('HealthCheckInterval') is not None:
            self.health_check_interval = m.get('HealthCheckInterval')
        if m.get('HealthCheckMethod') is not None:
            self.health_check_method = m.get('HealthCheckMethod')
        if m.get('HealthCheckTimeout') is not None:
            self.health_check_timeout = m.get('HealthCheckTimeout')
        if m.get('HealthCheckType') is not None:
            self.health_check_type = m.get('HealthCheckType')
        if m.get('HealthCheckURI') is not None:
            self.health_check_uri = m.get('HealthCheckURI')
        if m.get('HealthyThreshold') is not None:
            self.healthy_threshold = m.get('HealthyThreshold')
        if m.get('UnhealthyThreshold') is not None:
            self.unhealthy_threshold = m.get('UnhealthyThreshold')
        return self


class HttpConfig(TeaModel):
    def __init__(
        self,
        cookie: str = None,
        cookie_timeout: int = None,
        idle_timeout: int = None,
        request_timeout: int = None,
        scheduler: str = None,
        server_certificate_id: str = None,
        sticky_session: str = None,
        sticky_session_type: str = None,
        xforwarded_for: str = None,
    ):
        self.cookie = cookie
        self.cookie_timeout = cookie_timeout
        self.idle_timeout = idle_timeout
        self.request_timeout = request_timeout
        self.scheduler = scheduler
        self.server_certificate_id = server_certificate_id
        self.sticky_session = sticky_session
        self.sticky_session_type = sticky_session_type
        self.xforwarded_for = xforwarded_for

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cookie is not None:
            result['Cookie'] = self.cookie
        if self.cookie_timeout is not None:
            result['CookieTimeout'] = self.cookie_timeout
        if self.idle_timeout is not None:
            result['IdleTimeout'] = self.idle_timeout
        if self.request_timeout is not None:
            result['RequestTimeout'] = self.request_timeout
        if self.scheduler is not None:
            result['Scheduler'] = self.scheduler
        if self.server_certificate_id is not None:
            result['ServerCertificateId'] = self.server_certificate_id
        if self.sticky_session is not None:
            result['StickySession'] = self.sticky_session
        if self.sticky_session_type is not None:
            result['StickySessionType'] = self.sticky_session_type
        if self.xforwarded_for is not None:
            result['XForwardedFor'] = self.xforwarded_for
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cookie') is not None:
            self.cookie = m.get('Cookie')
        if m.get('CookieTimeout') is not None:
            self.cookie_timeout = m.get('CookieTimeout')
        if m.get('IdleTimeout') is not None:
            self.idle_timeout = m.get('IdleTimeout')
        if m.get('RequestTimeout') is not None:
            self.request_timeout = m.get('RequestTimeout')
        if m.get('Scheduler') is not None:
            self.scheduler = m.get('Scheduler')
        if m.get('ServerCertificateId') is not None:
            self.server_certificate_id = m.get('ServerCertificateId')
        if m.get('StickySession') is not None:
            self.sticky_session = m.get('StickySession')
        if m.get('StickySessionType') is not None:
            self.sticky_session_type = m.get('StickySessionType')
        if m.get('XForwardedFor') is not None:
            self.xforwarded_for = m.get('XForwardedFor')
        return self


class InstanceActiveOpsGroup(TeaModel):
    def __init__(
        self,
        instance_ids: List[str] = None,
    ):
        self.instance_ids = instance_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        return self


class InstanceActiveOpsTask(TeaModel):
    def __init__(
        self,
        instance_active_ops_task_id: str = None,
        instance_active_ops_task_status: str = None,
    ):
        self.instance_active_ops_task_id = instance_active_ops_task_id
        self.instance_active_ops_task_status = instance_active_ops_task_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_active_ops_task_id is not None:
            result['InstanceActiveOpsTaskId'] = self.instance_active_ops_task_id
        if self.instance_active_ops_task_status is not None:
            result['InstanceActiveOpsTaskStatus'] = self.instance_active_ops_task_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceActiveOpsTaskId') is not None:
            self.instance_active_ops_task_id = m.get('InstanceActiveOpsTaskId')
        if m.get('InstanceActiveOpsTaskStatus') is not None:
            self.instance_active_ops_task_status = m.get('InstanceActiveOpsTaskStatus')
        return self


class InstanceOperateResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        instance_id: str = None,
        message: str = None,
    ):
        self.code = code
        self.instance_id = instance_id
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class SecurityGroupRule(TeaModel):
    def __init__(
        self,
        description: str = None,
        dest_cidr_ip: str = None,
        direction: str = None,
        ip_protocol: str = None,
        policy: str = None,
        port_range: str = None,
        source_cidr_ip: str = None,
        source_port_range: str = None,
        priority: int = None,
    ):
        self.description = description
        self.dest_cidr_ip = dest_cidr_ip
        self.direction = direction
        self.ip_protocol = ip_protocol
        self.policy = policy
        self.port_range = port_range
        self.source_cidr_ip = source_cidr_ip
        self.source_port_range = source_port_range
        self.priority = priority

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_cidr_ip is not None:
            result['DestCidrIp'] = self.dest_cidr_ip
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.source_cidr_ip is not None:
            result['SourceCidrIp'] = self.source_cidr_ip
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        if self.priority is not None:
            result['priority'] = self.priority
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestCidrIp') is not None:
            self.dest_cidr_ip = m.get('DestCidrIp')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PortRange') is not None:
            self.port_range = m.get('PortRange')
        if m.get('SourceCidrIp') is not None:
            self.source_cidr_ip = m.get('SourceCidrIp')
        if m.get('SourcePortRange') is not None:
            self.source_port_range = m.get('SourcePortRange')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        return self


class TagsInParamsTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # This parameter is required.
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class TagsInParams(TeaModel):
    def __init__(
        self,
        tag: List[TagsInParamsTag] = None,
    ):
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = TagsInParamsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class TcpConfig(TeaModel):
    def __init__(
        self,
        established_timeout: int = None,
        persistence_timeout: int = None,
        scheduler: str = None,
    ):
        self.established_timeout = established_timeout
        self.persistence_timeout = persistence_timeout
        self.scheduler = scheduler

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.established_timeout is not None:
            result['EstablishedTimeout'] = self.established_timeout
        if self.persistence_timeout is not None:
            result['PersistenceTimeout'] = self.persistence_timeout
        if self.scheduler is not None:
            result['Scheduler'] = self.scheduler
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EstablishedTimeout') is not None:
            self.established_timeout = m.get('EstablishedTimeout')
        if m.get('PersistenceTimeout') is not None:
            self.persistence_timeout = m.get('PersistenceTimeout')
        if m.get('Scheduler') is not None:
            self.scheduler = m.get('Scheduler')
        return self


class UdpCheck(TeaModel):
    def __init__(
        self,
        health_check_connect_port: int = None,
        health_check_connect_timeout: int = None,
        health_check_interval: int = None,
        healthy_threshold: int = None,
        unhealthy_threshold: int = None,
    ):
        self.health_check_connect_port = health_check_connect_port
        self.health_check_connect_timeout = health_check_connect_timeout
        self.health_check_interval = health_check_interval
        self.healthy_threshold = healthy_threshold
        self.unhealthy_threshold = unhealthy_threshold

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.health_check_connect_port is not None:
            result['HealthCheckConnectPort'] = self.health_check_connect_port
        if self.health_check_connect_timeout is not None:
            result['HealthCheckConnectTimeout'] = self.health_check_connect_timeout
        if self.health_check_interval is not None:
            result['HealthCheckInterval'] = self.health_check_interval
        if self.healthy_threshold is not None:
            result['HealthyThreshold'] = self.healthy_threshold
        if self.unhealthy_threshold is not None:
            result['UnhealthyThreshold'] = self.unhealthy_threshold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HealthCheckConnectPort') is not None:
            self.health_check_connect_port = m.get('HealthCheckConnectPort')
        if m.get('HealthCheckConnectTimeout') is not None:
            self.health_check_connect_timeout = m.get('HealthCheckConnectTimeout')
        if m.get('HealthCheckInterval') is not None:
            self.health_check_interval = m.get('HealthCheckInterval')
        if m.get('HealthyThreshold') is not None:
            self.healthy_threshold = m.get('HealthyThreshold')
        if m.get('UnhealthyThreshold') is not None:
            self.unhealthy_threshold = m.get('UnhealthyThreshold')
        return self


class UdpConfig(TeaModel):
    def __init__(
        self,
        hash_key: str = None,
        scheduler: str = None,
    ):
        self.hash_key = hash_key
        self.scheduler = scheduler

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hash_key is not None:
            result['HashKey'] = self.hash_key
        if self.scheduler is not None:
            result['Scheduler'] = self.scheduler
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HashKey') is not None:
            self.hash_key = m.get('HashKey')
        if m.get('Scheduler') is not None:
            self.scheduler = m.get('Scheduler')
        return self


class AccosicateNetworkAclRequestResource(TeaModel):
    def __init__(
        self,
        resource_id: str = None,
        resource_type: str = None,
    ):
        # The ID of the associated resource.
        # 
        # This parameter is required.
        self.resource_id = resource_id
        # The type of the associated resource. Set the value to **Network**.
        # 
        # Valid values of **N**: 0 to 29. You can associate a network ACL with at most 30 resources.
        # 
        # This parameter is required.
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class AccosicateNetworkAclRequest(TeaModel):
    def __init__(
        self,
        network_acl_id: str = None,
        resource: List[AccosicateNetworkAclRequestResource] = None,
    ):
        # The ID of the network ACL.
        # 
        # This parameter is required.
        self.network_acl_id = network_acl_id
        # The type of resource with which you want to associate the network ACL.
        # 
        # This parameter is required.
        self.resource = resource

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_acl_id is not None:
            result['NetworkAclId'] = self.network_acl_id
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkAclId') is not None:
            self.network_acl_id = m.get('NetworkAclId')
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = AccosicateNetworkAclRequestResource()
                self.resource.append(temp_model.from_map(k))
        return self


class AccosicateNetworkAclResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AccosicateNetworkAclResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AccosicateNetworkAclResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AccosicateNetworkAclResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddBackendServersRequestBackendServers(TeaModel):
    def __init__(
        self,
        ip: str = None,
        port: int = None,
        server_id: str = None,
        type: str = None,
        weight: int = None,
    ):
        # The IP address of the backend server.
        self.ip = ip
        # The backend port that is used by the ELB instance.
        self.port = port
        # The ID of the ENS instance.
        # 
        # This parameter is required.
        self.server_id = server_id
        # The type of the backend server. Valid values:
        # 
        # *   **ens**: ENS instance
        # *   **eni**: elastic network interface (ENI)
        self.type = type
        # The weight of the backend server. Default value: 100. Valid values: **0** to **100**.
        # 
        # >  The value 0 indicates that requests are not forwarded to the backend server.
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.port is not None:
            result['Port'] = self.port
        if self.server_id is not None:
            result['ServerId'] = self.server_id
        if self.type is not None:
            result['Type'] = self.type
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ServerId') is not None:
            self.server_id = m.get('ServerId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class AddBackendServersRequest(TeaModel):
    def __init__(
        self,
        backend_servers: List[AddBackendServersRequestBackendServers] = None,
        load_balancer_id: str = None,
    ):
        # The list of backend servers that you want to add to the Edge Load Balancer (ELB) instance. You can add up to 20 backend servers at a time.
        # 
        # >  Only Edge Node Service (ENS) instances that are in the running state can be added to the ELB instance as backend servers.
        # 
        # This parameter is required.
        self.backend_servers = backend_servers
        # The frontend port that is used by the Edge Load Balance (ELB) instance. Valid values: **1** to **65535**.
        # 
        # This parameter is required.
        self.load_balancer_id = load_balancer_id

    def validate(self):
        if self.backend_servers:
            for k in self.backend_servers:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BackendServers'] = []
        if self.backend_servers is not None:
            for k in self.backend_servers:
                result['BackendServers'].append(k.to_map() if k else None)
        if self.load_balancer_id is not None:
            result['LoadBalancerId'] = self.load_balancer_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.backend_servers = []
        if m.get('BackendServers') is not None:
            for k in m.get('BackendServers'):
                temp_model = AddBackendServersRequestBackendServers()
                self.backend_servers.append(temp_model.from_map(k))
        if m.get('LoadBalancerId') is not None:
            self.load_balancer_id = m.get('LoadBalancerId')
        return self


class AddBackendServersShrinkRequest(TeaModel):
    def __init__(
        self,
        backend_servers_shrink: str = None,
        load_balancer_id: str = None,
    ):
        # The list of backend servers that you want to add to the Edge Load Balancer (ELB) instance. You can add up to 20 backend servers at a time.
        # 
        # >  Only Edge Node Service (ENS) instances that are in the running state can be added to the ELB instance as backend servers.
        # 
        # This parameter is required.
        self.backend_servers_shrink = backend_servers_shrink
        # The frontend port that is used by the Edge Load Balance (ELB) instance. Valid values: **1** to **65535**.
        # 
        # This parameter is required.
        self.load_balancer_id = load_balancer_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backend_servers_shrink is not None:
            result['BackendServers'] = self.backend_servers_shrink
        if self.load_balancer_id is not None:
            result['LoadBalancerId'] = self.load_balancer_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackendServers') is not None:
            self.backend_servers_shrink = m.get('BackendServers')
        if m.get('LoadBalancerId') is not None:
            self.load_balancer_id = m.get('LoadBalancerId')
        return self


class AddBackendServersResponseBodyBackendServersBackendServer(TeaModel):
    def __init__(
        self,
        ip: str = None,
        port: int = None,
        server_id: str = None,
        type: str = None,
        weight: int = None,
    ):
        # The IP address of the backend server.
        self.ip = ip
        # The backend port that is used by the ELB instance.
        self.port = port
        # The ID of the instance that is used as the backend server.
        self.server_id = server_id
        # The type of the backend server. Valid values:
        # 
        # *   **ens**: ENS instance.
        # *   **eni**: ENI.
        self.type = type
        # The weight of the backend server. Default value: 100. Valid values: **0** to **100**.
        # 
        # >  The value 0 indicates that requests are not forwarded to the backend server.
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.port is not None:
            result['Port'] = self.port
        if self.server_id is not None:
            result['ServerId'] = self.server_id
        if self.type is not None:
            result['Type'] = self.type
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ServerId') is not None:
            self.server_id = m.get('ServerId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class AddBackendServersResponseBodyBackendServers(TeaModel):
    def __init__(
        self,
        backend_server: List[AddBackendServersResponseBodyBackendServersBackendServer] = None,
    ):
        self.backend_server = backend_server

    def validate(self):
        if self.backend_server:
            for k in self.backend_server:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BackendServer'] = []
        if self.backend_server is not None:
            for k in self.backend_server:
                result['BackendServer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.backend_server = []
        if m.get('BackendServer') is not None:
            for k in m.get('BackendServer'):
                temp_model = AddBackendServersResponseBodyBackendServersBackendServer()
                self.backend_server.append(temp_model.from_map(k))
        return self


class AddBackendServersResponseBody(TeaModel):
    def __init__(
        self,
        backend_servers: AddBackendServersResponseBodyBackendServers = None,
        request_id: str = None,
    ):
        # The list of backend servers that you want to add. You can add at most 20 backend servers.
        # 
        # >  Only ENS instances that are in the running state can be attached to the ELB instance as backend servers.
        self.backend_servers = backend_servers
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.backend_servers:
            self.backend_servers.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backend_servers is not None:
            result['BackendServers'] = self.backend_servers.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackendServers') is not None:
            temp_model = AddBackendServersResponseBodyBackendServers()
            self.backend_servers = temp_model.from_map(m['BackendServers'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddBackendServersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddBackendServersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddBackendServersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddNetworkInterfaceToInstanceRequest(TeaModel):
    def __init__(
        self,
        auto_start: bool = None,
        instance_id: str = None,
        networks: str = None,
    ):
        # Specifies whether to automatically restart the instance.
        self.auto_start = auto_start
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The network. The value is a JSON string. Only IPv6 is supported. Sample code of an IPv6 network: [{ "ipType": "public", "ipAddressType": "ipv6" }]
        # 
        # This parameter is required.
        self.networks = networks

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_start is not None:
            result['AutoStart'] = self.auto_start
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.networks is not None:
            result['Networks'] = self.networks
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoStart') is not None:
            self.auto_start = m.get('AutoStart')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Networks') is not None:
            self.networks = m.get('Networks')
        return self


class AddNetworkInterfaceToInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddNetworkInterfaceToInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddNetworkInterfaceToInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddNetworkInterfaceToInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddSnatIpForSnatEntryRequest(TeaModel):
    def __init__(
        self,
        snat_entry_id: str = None,
        snat_ip: str = None,
    ):
        # The ID of the SNAT entry.
        # 
        # This parameter is required.
        self.snat_entry_id = snat_entry_id
        # The EIP specified in the SNAT entry.
        # 
        # This parameter is required.
        self.snat_ip = snat_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.snat_entry_id is not None:
            result['SnatEntryId'] = self.snat_entry_id
        if self.snat_ip is not None:
            result['SnatIp'] = self.snat_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SnatEntryId') is not None:
            self.snat_entry_id = m.get('SnatEntryId')
        if m.get('SnatIp') is not None:
            self.snat_ip = m.get('SnatIp')
        return self


class AddSnatIpForSnatEntryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddSnatIpForSnatEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddSnatIpForSnatEntryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddSnatIpForSnatEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssignPrivateIpAddressesRequest(TeaModel):
    def __init__(
        self,
        network_interface_id: str = None,
        v_switch_id: str = None,
    ):
        # The ID of the ENI.
        # 
        # This parameter is required.
        self.network_interface_id = network_interface_id
        # The ID of the vSwitch.
        self.v_switch_id = v_switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class AssignPrivateIpAddressesResponseBodyAssignedPrivateIpAddressesSet(TeaModel):
    def __init__(
        self,
        network_interface_id: str = None,
        private_ip_set: List[str] = None,
    ):
        # The ID of the ENI.
        self.network_interface_id = network_interface_id
        # The assigned private IP addresses.
        self.private_ip_set = private_ip_set

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.private_ip_set is not None:
            result['PrivateIpSet'] = self.private_ip_set
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('PrivateIpSet') is not None:
            self.private_ip_set = m.get('PrivateIpSet')
        return self


class AssignPrivateIpAddressesResponseBody(TeaModel):
    def __init__(
        self,
        assigned_private_ip_addresses_set: AssignPrivateIpAddressesResponseBodyAssignedPrivateIpAddressesSet = None,
        request_id: str = None,
    ):
        # Details about the ENI and the secondary private IP addresses that are assigned to the ENI.
        self.assigned_private_ip_addresses_set = assigned_private_ip_addresses_set
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.assigned_private_ip_addresses_set:
            self.assigned_private_ip_addresses_set.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assigned_private_ip_addresses_set is not None:
            result['AssignedPrivateIpAddressesSet'] = self.assigned_private_ip_addresses_set.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssignedPrivateIpAddressesSet') is not None:
            temp_model = AssignPrivateIpAddressesResponseBodyAssignedPrivateIpAddressesSet()
            self.assigned_private_ip_addresses_set = temp_model.from_map(m['AssignedPrivateIpAddressesSet'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AssignPrivateIpAddressesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AssignPrivateIpAddressesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AssignPrivateIpAddressesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssociateEnsEipAddressRequest(TeaModel):
    def __init__(
        self,
        allocation_id: str = None,
        instance_id: str = None,
        instance_type: str = None,
        standby: bool = None,
    ):
        # The ID of the EIP that you want to associate.
        # 
        # This parameter is required.
        self.allocation_id = allocation_id
        # The ID of the cloud service with which the EIP is associated.
        # 
        # >  You can specify the ID of an Edge Load Balancer (ELB) instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The type of instance with which you want to associate the EIP. Valid values:
        # 
        # *   **Nat**: NAT gateway.
        # *   **SlbInstance**: Edge Load Balancer (ELB) instance.
        # *   **NetworkInterface**: secondary elastic network interface (ENI).
        # *   **NatSlbInstance**: If you want to associate multiple EIPs with an ELB instance, you need to set the parameter to this value.
        # *   **EnsInstance** (default): ENS instance.
        self.instance_type = instance_type
        # Specifies whether the EIP is a secondary EIP. Valid values:
        # 
        # *   true
        # *   false
        self.standby = standby

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allocation_id is not None:
            result['AllocationId'] = self.allocation_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.standby is not None:
            result['Standby'] = self.standby
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllocationId') is not None:
            self.allocation_id = m.get('AllocationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('Standby') is not None:
            self.standby = m.get('Standby')
        return self


class AssociateEnsEipAddressResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AssociateEnsEipAddressResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AssociateEnsEipAddressResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AssociateEnsEipAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssociateHaVipRequest(TeaModel):
    def __init__(
        self,
        ha_vip_id: str = None,
        instance_id: str = None,
        instance_type: str = None,
    ):
        # The ID of the HAVIP.
        # 
        # This parameter is required.
        self.ha_vip_id = ha_vip_id
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The type of the instance to be associated with the HAVIP. Valid values:
        # 
        # *   EnsInstance (default): ENS instance
        # *   NetworkInterface: elastic network interface (ENI)
        self.instance_type = instance_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ha_vip_id is not None:
            result['HaVipId'] = self.ha_vip_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HaVipId') is not None:
            self.ha_vip_id = m.get('HaVipId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        return self


class AssociateHaVipResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AssociateHaVipResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AssociateHaVipResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AssociateHaVipResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachDiskRequest(TeaModel):
    def __init__(
        self,
        delete_with_instance: str = None,
        disk_id: str = None,
        instance_id: str = None,
    ):
        # Specifies whether the disk to be attached is released with the instance. Valid values:
        # 
        # *   true: The disk will be released when the ECS instance is released.
        # *   false: The disk will be retained when the ECS instance is released.
        # *   If you leave this parameter empty, the default value is used.
        self.delete_with_instance = delete_with_instance
        # The ID of the disk to be attached. The cloud disk and the instance must belong to the same node.
        # 
        # This parameter is required.
        self.disk_id = disk_id
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_with_instance is not None:
            result['DeleteWithInstance'] = self.delete_with_instance
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeleteWithInstance') is not None:
            self.delete_with_instance = m.get('DeleteWithInstance')
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class AttachDiskResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        request_id: str = None,
    ):
        # The returned service code. 0 indicates that the request was successful.
        self.code = code
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AttachDiskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AttachDiskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachDiskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachEnsInstancesRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        scripts: str = None,
    ):
        # The ID of the instance. You can specify only one instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The command that you want to execute on the instance. The command must be encoded in Base64 or UTF-8.
        # 
        # This parameter is required.
        self.scripts = scripts

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.scripts is not None:
            result['Scripts'] = self.scripts
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Scripts') is not None:
            self.scripts = m.get('Scripts')
        return self


class AttachEnsInstancesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AttachEnsInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AttachEnsInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachEnsInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachInstanceSDGRequestLoadOpt(TeaModel):
    def __init__(
        self,
        block_rw_split: bool = None,
        block_rw_split_size: int = None,
        cache: bool = None,
        cache_size: int = None,
    ):
        self.block_rw_split = block_rw_split
        self.block_rw_split_size = block_rw_split_size
        self.cache = cache
        self.cache_size = cache_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_rw_split is not None:
            result['BlockRwSplit'] = self.block_rw_split
        if self.block_rw_split_size is not None:
            result['BlockRwSplitSize'] = self.block_rw_split_size
        if self.cache is not None:
            result['Cache'] = self.cache
        if self.cache_size is not None:
            result['CacheSize'] = self.cache_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BlockRwSplit') is not None:
            self.block_rw_split = m.get('BlockRwSplit')
        if m.get('BlockRwSplitSize') is not None:
            self.block_rw_split_size = m.get('BlockRwSplitSize')
        if m.get('Cache') is not None:
            self.cache = m.get('Cache')
        if m.get('CacheSize') is not None:
            self.cache_size = m.get('CacheSize')
        return self


class AttachInstanceSDGRequest(TeaModel):
    def __init__(
        self,
        disk_access_protocol: str = None,
        disk_type: str = None,
        instance_ids: List[str] = None,
        load_opt: AttachInstanceSDGRequestLoadOpt = None,
        sdgid: str = None,
    ):
        self.disk_access_protocol = disk_access_protocol
        self.disk_type = disk_type
        # The IDs of the instances.
        # 
        # This parameter is required.
        self.instance_ids = instance_ids
        self.load_opt = load_opt
        # The ID of the SDG.
        # 
        # This parameter is required.
        self.sdgid = sdgid

    def validate(self):
        if self.load_opt:
            self.load_opt.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_access_protocol is not None:
            result['DiskAccessProtocol'] = self.disk_access_protocol
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.load_opt is not None:
            result['LoadOpt'] = self.load_opt.to_map()
        if self.sdgid is not None:
            result['SDGId'] = self.sdgid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiskAccessProtocol') is not None:
            self.disk_access_protocol = m.get('DiskAccessProtocol')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('LoadOpt') is not None:
            temp_model = AttachInstanceSDGRequestLoadOpt()
            self.load_opt = temp_model.from_map(m['LoadOpt'])
        if m.get('SDGId') is not None:
            self.sdgid = m.get('SDGId')
        return self


class AttachInstanceSDGShrinkRequest(TeaModel):
    def __init__(
        self,
        disk_access_protocol: str = None,
        disk_type: str = None,
        instance_ids_shrink: str = None,
        load_opt_shrink: str = None,
        sdgid: str = None,
    ):
        self.disk_access_protocol = disk_access_protocol
        self.disk_type = disk_type
        # The IDs of the instances.
        # 
        # This parameter is required.
        self.instance_ids_shrink = instance_ids_shrink
        self.load_opt_shrink = load_opt_shrink
        # The ID of the SDG.
        # 
        # This parameter is required.
        self.sdgid = sdgid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_access_protocol is not None:
            result['DiskAccessProtocol'] = self.disk_access_protocol
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.instance_ids_shrink is not None:
            result['InstanceIds'] = self.instance_ids_shrink
        if self.load_opt_shrink is not None:
            result['LoadOpt'] = self.load_opt_shrink
        if self.sdgid is not None:
            result['SDGId'] = self.sdgid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiskAccessProtocol') is not None:
            self.disk_access_protocol = m.get('DiskAccessProtocol')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('InstanceIds') is not None:
            self.instance_ids_shrink = m.get('InstanceIds')
        if m.get('LoadOpt') is not None:
            self.load_opt_shrink = m.get('LoadOpt')
        if m.get('SDGId') is not None:
            self.sdgid = m.get('SDGId')
        return self


class AttachInstanceSDGResponseBodyDataResultFailedItems(TeaModel):
    def __init__(
        self,
        err_message: str = None,
        instance_id: str = None,
    ):
        # The error message.
        self.err_message = err_message
        # The ID of the instance.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.err_message is not None:
            result['ErrMessage'] = self.err_message
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrMessage') is not None:
            self.err_message = m.get('ErrMessage')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class AttachInstanceSDGResponseBodyDataResult(TeaModel):
    def __init__(
        self,
        failed_count: int = None,
        failed_items: List[AttachInstanceSDGResponseBodyDataResultFailedItems] = None,
        success_count: int = None,
    ):
        # The number of failed tasks.
        self.failed_count = failed_count
        # Details about failed tasks.
        self.failed_items = failed_items
        # The number of successful tasks.
        self.success_count = success_count

    def validate(self):
        if self.failed_items:
            for k in self.failed_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed_count is not None:
            result['FailedCount'] = self.failed_count
        result['FailedItems'] = []
        if self.failed_items is not None:
            for k in self.failed_items:
                result['FailedItems'].append(k.to_map() if k else None)
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailedCount') is not None:
            self.failed_count = m.get('FailedCount')
        self.failed_items = []
        if m.get('FailedItems') is not None:
            for k in m.get('FailedItems'):
                temp_model = AttachInstanceSDGResponseBodyDataResultFailedItems()
                self.failed_items.append(temp_model.from_map(k))
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        return self


class AttachInstanceSDGResponseBodyData(TeaModel):
    def __init__(
        self,
        message: str = None,
        result: AttachInstanceSDGResponseBodyDataResult = None,
        success: bool = None,
    ):
        # The response message. Success is returned for a successful request.
        self.message = message
        # The execution result of the synchronization request.
        self.result = result
        # Indicates whether all tasks are successful. Valid values:
        # 
        # *   **true**: All tasks are successful.
        # *   **false**: Failed tasks exist.
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.result is not None:
            result['Result'] = self.result.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Result') is not None:
            temp_model = AttachInstanceSDGResponseBodyDataResult()
            self.result = temp_model.from_map(m['Result'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AttachInstanceSDGResponseBody(TeaModel):
    def __init__(
        self,
        data: AttachInstanceSDGResponseBodyData = None,
        request_id: str = None,
    ):
        # The returned data object.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = AttachInstanceSDGResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AttachInstanceSDGResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AttachInstanceSDGResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachInstanceSDGResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachNetworkInterfaceRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        network_interface_id: str = None,
    ):
        # The ID of the instance
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The ID of the ENI.
        # 
        # This parameter is required.
        self.network_interface_id = network_interface_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        return self


class AttachNetworkInterfaceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AttachNetworkInterfaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AttachNetworkInterfaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachNetworkInterfaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AuthorizeSecurityGroupRequest(TeaModel):
    def __init__(
        self,
        ip_protocol: str = None,
        policy: str = None,
        port_range: str = None,
        priority: int = None,
        security_group_id: str = None,
        source_cidr_ip: str = None,
        source_port_range: str = None,
    ):
        # The transport layer protocol. The values of this parameter are case-sensitive. Valid values:
        # 
        # *   tcp
        # *   udp
        # *   icmp
        # *   gre
        # *   all: All protocols are supported.
        # 
        # This parameter is required.
        self.ip_protocol = ip_protocol
        # The action of security group rule N that determines whether to allow inbound access. Valid values:
        # 
        # *   accept: allows access.
        # *   drop: denies access and returns no responses.
        # 
        # Default value: accept.
        self.policy = policy
        # The range of destination ports that correspond to the transport layer protocol for security group rule N. Valid values:
        # 
        # *   When the IpProtocol parameter is set to tcp or udp, the port number range is **1** to **65535**. The start port number and the end port number are separated by a forward slash (/). Correct example: **1/200**. Incorrect example: **200/1**.
        # *   When the IpProtocol parameter is set to icmp, the port number range is **-1/-1**, which indicates all ports.
        # *   When the IpProtocol parameter is set to gre, the port number range is **-1/-1**, which indicates all ports.
        # *   When the IpProtocol parameter is set to all, the port number range is **-1/-1**, which indicates all ports.
        # 
        # This parameter is required.
        self.port_range = port_range
        # The priority of security group rule N. Valid values: **1** to **100**.
        # 
        # Default value: **1**.
        self.priority = priority
        # The ID of the security group.
        # 
        # This parameter is required.
        self.security_group_id = security_group_id
        # The source IPv4 CIDR block. CIDR blocks and IPv4 addresses are supported.
        # 
        # This parameter is empty by default.
        # 
        # This parameter is required.
        self.source_cidr_ip = source_cidr_ip
        # The range of port numbers that correspond to the transport layer protocol for the source security group. Valid values:
        # 
        # *   When the IpProtocol parameter is set to tcp or udp, the port number range is **1 to 65535**. The start port number and the end port number are separated by a forward slash (/). Correct example: **1/200**. Incorrect example: **200/1**.
        # *   When the IpProtocol parameter is set to icmp, the port number range is **-1/-1**, which indicates all ports.
        # *   When the IpProtocol parameter is set to gre, the port number range is **-1/-1**, which indicates all ports.
        # *   When the IpProtocol parameter is set to all, the port number range is **-1/-1**, which indicates all ports.
        self.source_port_range = source_port_range

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.source_cidr_ip is not None:
            result['SourceCidrIp'] = self.source_cidr_ip
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PortRange') is not None:
            self.port_range = m.get('PortRange')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('SourceCidrIp') is not None:
            self.source_cidr_ip = m.get('SourceCidrIp')
        if m.get('SourcePortRange') is not None:
            self.source_port_range = m.get('SourcePortRange')
        return self


class AuthorizeSecurityGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AuthorizeSecurityGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AuthorizeSecurityGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AuthorizeSecurityGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AuthorizeSecurityGroupEgressRequest(TeaModel):
    def __init__(
        self,
        dest_cidr_ip: str = None,
        ip_protocol: str = None,
        policy: str = None,
        port_range: str = None,
        priority: int = None,
        security_group_id: str = None,
        source_port_range: str = None,
    ):
        # The destination IP addresses. CIDR blocks and IPv4 addresses are supported.
        # 
        # This parameter is empty by default.
        # 
        # This parameter is required.
        self.dest_cidr_ip = dest_cidr_ip
        # The transport layer protocol. The value of this parameter is case-sensitive. Valid values:
        # 
        # *   tcp
        # *   udp
        # *   icmp
        # *   gre
        # *   all: All protocols are supported.
        # 
        # This parameter is required.
        self.ip_protocol = ip_protocol
        # The action of the security group rule. Valid values:
        # 
        # *   accept: allows access. This is the default value.
        # *   drop: denies access and does not return responses.
        self.policy = policy
        # The range of destination ports that correspond to the transport layer protocol for security group rule N. Valid values:
        # 
        # *   When the IpProtocol parameter is set to tcp or udp, the port number range is **1** to **65535**. The start port number and the end port number are separated by a forward slash (/). Correct example: **1/200**. Incorrect example: **200/1**.
        # *   When the IpProtocol parameter is set to icmp, the port number range is **-1/-1**, which indicates all ports.
        # *   When the IpProtocol parameter is set to gre, the port number range is **-1/-1**, which indicates all ports.
        # *   When the IpProtocol parameter is set to all, the port number range is **-1/-1**, which indicates all ports.
        # 
        # This parameter is required.
        self.port_range = port_range
        # The priority of security group rule N. Valid values: **1 to 100**. Default value: **1**.
        self.priority = priority
        # The ID of the security group.
        # 
        # This parameter is required.
        self.security_group_id = security_group_id
        # The range of port numbers that correspond to the transport layer protocol for the source security group. Valid values:
        # 
        # *   When the IpProtocol parameter is set to tcp or udp, the port number range is **1** to **65535**. The start port number and the end port number are separated by a forward slash (/). Correct example: **1/200**. Incorrect example: **200/1**.
        # *   When the IpProtocol parameter is set to icmp, the port number range is **-1/-1**, which indicates all ports.
        # *   When the IpProtocol parameter is set to gre, the port number range is **-1/-1**, which indicates all ports.
        # *   When the IpProtocol parameter is set to all, the port number range is **-1/-1**, which indicates all ports.
        self.source_port_range = source_port_range

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dest_cidr_ip is not None:
            result['DestCidrIp'] = self.dest_cidr_ip
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DestCidrIp') is not None:
            self.dest_cidr_ip = m.get('DestCidrIp')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PortRange') is not None:
            self.port_range = m.get('PortRange')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('SourcePortRange') is not None:
            self.source_port_range = m.get('SourcePortRange')
        return self


class AuthorizeSecurityGroupEgressResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AuthorizeSecurityGroupEgressResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AuthorizeSecurityGroupEgressResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AuthorizeSecurityGroupEgressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchEventMigrateInstanceRequestEventInfos(TeaModel):
    def __init__(
        self,
        data_policy: str = None,
        event_id: str = None,
        ops_type: str = None,
        password: str = None,
        plan_time: int = None,
        resource_id: str = None,
    ):
        # The data migration policy. Valid values:
        # 
        # *   abandon: does not migrate data. This is the default value.
        # *   force_transfer: forcibly migrates data.
        # *   try_transfer: Migrate data as much as possible.
        self.data_policy = data_policy
        # Event ID e-\\*.
        # 
        # This parameter is required.
        self.event_id = event_id
        # The type of the O\\&M task. Valid values:
        # 
        # *   immediate
        # *   scheduled
        # 
        # This parameter is required.
        self.ops_type = ops_type
        # The password of the instance. This parameter is optional. If you do not specify this parameter, a random password is used.
        # 
        # The password must be 8 to 30 characters in length. The password must contain uppercase letters, lowercase letters, digits, and special characters.
        # 
        # Note that you cannot enter a password for scheduled execution.
        self.password = password
        # The execution time of the reservation. The timestamp is measured in milliseconds. If the OpsType parameter is set to scheduled, this parameter is required.
        self.plan_time = plan_time
        # Resource ID i-\\*.
        # 
        # This parameter is required.
        self.resource_id = resource_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_policy is not None:
            result['DataPolicy'] = self.data_policy
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.ops_type is not None:
            result['OpsType'] = self.ops_type
        if self.password is not None:
            result['Password'] = self.password
        if self.plan_time is not None:
            result['PlanTime'] = self.plan_time
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataPolicy') is not None:
            self.data_policy = m.get('DataPolicy')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('OpsType') is not None:
            self.ops_type = m.get('OpsType')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('PlanTime') is not None:
            self.plan_time = m.get('PlanTime')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class BatchEventMigrateInstanceRequest(TeaModel):
    def __init__(
        self,
        event_infos: List[BatchEventMigrateInstanceRequestEventInfos] = None,
    ):
        # The details of events.
        self.event_infos = event_infos

    def validate(self):
        if self.event_infos:
            for k in self.event_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EventInfos'] = []
        if self.event_infos is not None:
            for k in self.event_infos:
                result['EventInfos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.event_infos = []
        if m.get('EventInfos') is not None:
            for k in m.get('EventInfos'):
                temp_model = BatchEventMigrateInstanceRequestEventInfos()
                self.event_infos.append(temp_model.from_map(k))
        return self


class BatchEventMigrateInstanceShrinkRequest(TeaModel):
    def __init__(
        self,
        event_infos_shrink: str = None,
    ):
        # The details of events.
        self.event_infos_shrink = event_infos_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_infos_shrink is not None:
            result['EventInfos'] = self.event_infos_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventInfos') is not None:
            self.event_infos_shrink = m.get('EventInfos')
        return self


class BatchEventMigrateInstanceResponseBodyResults(TeaModel):
    def __init__(
        self,
        code: int = None,
        event_id: str = None,
        message: str = None,
        resource_id: str = None,
    ):
        # The error code.
        self.code = code
        # The ID of the event.
        self.event_id = event_id
        # When Code!=200, it indicates the specific error message.
        self.message = message
        # The resource IDs.
        self.resource_id = resource_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.message is not None:
            result['Message'] = self.message
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class BatchEventMigrateInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        results: List[BatchEventMigrateInstanceResponseBodyResults] = None,
    ):
        # Request ID.
        self.request_id = request_id
        # The results.
        self.results = results

    def validate(self):
        if self.results:
            for k in self.results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Results'] = []
        if self.results is not None:
            for k in self.results:
                result['Results'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.results = []
        if m.get('Results') is not None:
            for k in m.get('Results'):
                temp_model = BatchEventMigrateInstanceResponseBodyResults()
                self.results.append(temp_model.from_map(k))
        return self


class BatchEventMigrateInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchEventMigrateInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchEventMigrateInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchEventRebootInstanceRequestEventInfos(TeaModel):
    def __init__(
        self,
        event_id: str = None,
        ops_type: str = None,
        plan_time: int = None,
        resource_id: str = None,
    ):
        # The ID of the system event.
        self.event_id = event_id
        # The type of the O\\&M task.
        # 
        # *   immediate
        # *   scheduled
        self.ops_type = ops_type
        # The execution time of the reservation. The timestamp is measured in milliseconds. If the OpsType parameter is set to scheduled, this parameter is required.
        self.plan_time = plan_time
        # A client ID.
        self.resource_id = resource_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.ops_type is not None:
            result['OpsType'] = self.ops_type
        if self.plan_time is not None:
            result['PlanTime'] = self.plan_time
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('OpsType') is not None:
            self.ops_type = m.get('OpsType')
        if m.get('PlanTime') is not None:
            self.plan_time = m.get('PlanTime')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class BatchEventRebootInstanceRequest(TeaModel):
    def __init__(
        self,
        event_infos: List[BatchEventRebootInstanceRequestEventInfos] = None,
    ):
        # The details of events.
        self.event_infos = event_infos

    def validate(self):
        if self.event_infos:
            for k in self.event_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EventInfos'] = []
        if self.event_infos is not None:
            for k in self.event_infos:
                result['EventInfos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.event_infos = []
        if m.get('EventInfos') is not None:
            for k in m.get('EventInfos'):
                temp_model = BatchEventRebootInstanceRequestEventInfos()
                self.event_infos.append(temp_model.from_map(k))
        return self


class BatchEventRebootInstanceShrinkRequest(TeaModel):
    def __init__(
        self,
        event_infos_shrink: str = None,
    ):
        # The details of events.
        self.event_infos_shrink = event_infos_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_infos_shrink is not None:
            result['EventInfos'] = self.event_infos_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventInfos') is not None:
            self.event_infos_shrink = m.get('EventInfos')
        return self


class BatchEventRebootInstanceResponseBodyResults(TeaModel):
    def __init__(
        self,
        code: int = None,
        event_id: str = None,
        message: str = None,
        resource_id: str = None,
    ):
        # The status code.
        self.code = code
        # The ID of the system event.
        self.event_id = event_id
        # The message of the operation. If the value of the Code parameter is 200, the value of this parameter is successful.
        self.message = message
        # The resource IDs.
        self.resource_id = resource_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.message is not None:
            result['Message'] = self.message
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class BatchEventRebootInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        results: List[BatchEventRebootInstanceResponseBodyResults] = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The result.
        self.results = results

    def validate(self):
        if self.results:
            for k in self.results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Results'] = []
        if self.results is not None:
            for k in self.results:
                result['Results'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.results = []
        if m.get('Results') is not None:
            for k in m.get('Results'):
                temp_model = BatchEventRebootInstanceResponseBodyResults()
                self.results.append(temp_model.from_map(k))
        return self


class BatchEventRebootInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchEventRebootInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchEventRebootInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchEventRedeployInstanceRequestEventInfos(TeaModel):
    def __init__(
        self,
        event_id: str = None,
        ops_type: str = None,
        plan_time: int = None,
        resource_id: str = None,
    ):
        # System event ID.
        self.event_id = event_id
        # Operation type, value range:
        # 
        # - immediate: Execute immediately.
        # - scheduled: Scheduled execution.
        self.ops_type = ops_type
        # Scheduled execution time, in timestamp, unit is milliseconds. This field is required when OpsType=scheduled.
        self.plan_time = plan_time
        # Resource ID.
        self.resource_id = resource_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.ops_type is not None:
            result['OpsType'] = self.ops_type
        if self.plan_time is not None:
            result['PlanTime'] = self.plan_time
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('OpsType') is not None:
            self.ops_type = m.get('OpsType')
        if m.get('PlanTime') is not None:
            self.plan_time = m.get('PlanTime')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class BatchEventRedeployInstanceRequest(TeaModel):
    def __init__(
        self,
        event_infos: List[BatchEventRedeployInstanceRequestEventInfos] = None,
    ):
        # List of events.
        self.event_infos = event_infos

    def validate(self):
        if self.event_infos:
            for k in self.event_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EventInfos'] = []
        if self.event_infos is not None:
            for k in self.event_infos:
                result['EventInfos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.event_infos = []
        if m.get('EventInfos') is not None:
            for k in m.get('EventInfos'):
                temp_model = BatchEventRedeployInstanceRequestEventInfos()
                self.event_infos.append(temp_model.from_map(k))
        return self


class BatchEventRedeployInstanceShrinkRequest(TeaModel):
    def __init__(
        self,
        event_infos_shrink: str = None,
    ):
        # List of events.
        self.event_infos_shrink = event_infos_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_infos_shrink is not None:
            result['EventInfos'] = self.event_infos_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventInfos') is not None:
            self.event_infos_shrink = m.get('EventInfos')
        return self


class BatchEventRedeployInstanceResponseBodyResults(TeaModel):
    def __init__(
        self,
        code: int = None,
        event_id: str = None,
        message: str = None,
        resource_id: str = None,
    ):
        # Status code.
        self.code = code
        # System event ID.
        self.event_id = event_id
        # Operational message, when code=200, the message is \\"successful\\".
        self.message = message
        # Resource ID.
        self.resource_id = resource_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.message is not None:
            result['Message'] = self.message
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class BatchEventRedeployInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        results: List[BatchEventRedeployInstanceResponseBodyResults] = None,
    ):
        # Request ID.
        self.request_id = request_id
        # List of results.
        self.results = results

    def validate(self):
        if self.results:
            for k in self.results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Results'] = []
        if self.results is not None:
            for k in self.results:
                result['Results'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.results = []
        if m.get('Results') is not None:
            for k in m.get('Results'):
                temp_model = BatchEventRedeployInstanceResponseBodyResults()
                self.results.append(temp_model.from_map(k))
        return self


class BatchEventRedeployInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchEventRedeployInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchEventRedeployInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CleanDistDataRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        data_name: str = None,
        data_version: str = None,
        ens_region_id: str = None,
    ):
        self.app_id = app_id
        self.data_name = data_name
        self.data_version = data_version
        self.ens_region_id = ens_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.data_name is not None:
            result['DataName'] = self.data_name
        if self.data_version is not None:
            result['DataVersion'] = self.data_version
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('DataName') is not None:
            self.data_name = m.get('DataName')
        if m.get('DataVersion') is not None:
            self.data_version = m.get('DataVersion')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        return self


class CleanDistDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CleanDistDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CleanDistDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CleanDistDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopySDGRequest(TeaModel):
    def __init__(
        self,
        destination_region_ids: List[str] = None,
        sdgid: str = None,
    ):
        # The destination nodes.
        # 
        # This parameter is required.
        self.destination_region_ids = destination_region_ids
        # The ID of the SDG that you want to copy.
        # 
        # This parameter is required.
        self.sdgid = sdgid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_region_ids is not None:
            result['DestinationRegionIds'] = self.destination_region_ids
        if self.sdgid is not None:
            result['SDGId'] = self.sdgid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DestinationRegionIds') is not None:
            self.destination_region_ids = m.get('DestinationRegionIds')
        if m.get('SDGId') is not None:
            self.sdgid = m.get('SDGId')
        return self


class CopySDGShrinkRequest(TeaModel):
    def __init__(
        self,
        destination_region_ids_shrink: str = None,
        sdgid: str = None,
    ):
        # The destination nodes.
        # 
        # This parameter is required.
        self.destination_region_ids_shrink = destination_region_ids_shrink
        # The ID of the SDG that you want to copy.
        # 
        # This parameter is required.
        self.sdgid = sdgid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_region_ids_shrink is not None:
            result['DestinationRegionIds'] = self.destination_region_ids_shrink
        if self.sdgid is not None:
            result['SDGId'] = self.sdgid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DestinationRegionIds') is not None:
            self.destination_region_ids_shrink = m.get('DestinationRegionIds')
        if m.get('SDGId') is not None:
            self.sdgid = m.get('SDGId')
        return self


class CopySDGResponseBodyDataResultFailedItems(TeaModel):
    def __init__(
        self,
        destination_region_id: str = None,
        error_message: str = None,
    ):
        # The ID of the destination node.
        self.destination_region_id = destination_region_id
        # The error message.
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_region_id is not None:
            result['DestinationRegionId'] = self.destination_region_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DestinationRegionId') is not None:
            self.destination_region_id = m.get('DestinationRegionId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CopySDGResponseBodyDataResult(TeaModel):
    def __init__(
        self,
        failed_count: int = None,
        failed_items: List[CopySDGResponseBodyDataResultFailedItems] = None,
        success_count: int = None,
    ):
        # The number of failed nodes.
        self.failed_count = failed_count
        # Details of failed nodes.
        self.failed_items = failed_items
        # The number of successful nodes.
        self.success_count = success_count

    def validate(self):
        if self.failed_items:
            for k in self.failed_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed_count is not None:
            result['FailedCount'] = self.failed_count
        result['FailedItems'] = []
        if self.failed_items is not None:
            for k in self.failed_items:
                result['FailedItems'].append(k.to_map() if k else None)
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailedCount') is not None:
            self.failed_count = m.get('FailedCount')
        self.failed_items = []
        if m.get('FailedItems') is not None:
            for k in m.get('FailedItems'):
                temp_model = CopySDGResponseBodyDataResultFailedItems()
                self.failed_items.append(temp_model.from_map(k))
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        return self


class CopySDGResponseBodyData(TeaModel):
    def __init__(
        self,
        message: str = None,
        result: CopySDGResponseBodyDataResult = None,
        success: bool = None,
    ):
        # The response message. Success is returned for a successful request.
        self.message = message
        # The execution result of the synchronization request.
        self.result = result
        # Indicates whether all tasks are successful. Valid values:
        # 
        # *   **true**: All tasks are successful.
        # *   **false**: Failed tasks exist.
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.result is not None:
            result['Result'] = self.result.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Result') is not None:
            temp_model = CopySDGResponseBodyDataResult()
            self.result = temp_model.from_map(m['Result'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CopySDGResponseBody(TeaModel):
    def __init__(
        self,
        data: CopySDGResponseBodyData = None,
        request_id: str = None,
    ):
        # The returned data object.
        self.data = data
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CopySDGResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CopySDGResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CopySDGResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CopySDGResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopySnapshotRequest(TeaModel):
    def __init__(
        self,
        destination_region_ids: List[str] = None,
        destination_snapshot_description: str = None,
        destination_snapshot_name: str = None,
        instance_billing_cycle: str = None,
        snapshot_id: str = None,
    ):
        # The IDs of destination nodes.
        # 
        # This parameter is required.
        self.destination_region_ids = destination_region_ids
        # The description of the snapshot. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
        self.destination_snapshot_description = destination_snapshot_description
        # The name of the snapshot. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        self.destination_snapshot_name = destination_snapshot_name
        self.instance_billing_cycle = instance_billing_cycle
        # The ID of the source snapshot.
        # 
        # This parameter is required.
        self.snapshot_id = snapshot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_region_ids is not None:
            result['DestinationRegionIds'] = self.destination_region_ids
        if self.destination_snapshot_description is not None:
            result['DestinationSnapshotDescription'] = self.destination_snapshot_description
        if self.destination_snapshot_name is not None:
            result['DestinationSnapshotName'] = self.destination_snapshot_name
        if self.instance_billing_cycle is not None:
            result['InstanceBillingCycle'] = self.instance_billing_cycle
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DestinationRegionIds') is not None:
            self.destination_region_ids = m.get('DestinationRegionIds')
        if m.get('DestinationSnapshotDescription') is not None:
            self.destination_snapshot_description = m.get('DestinationSnapshotDescription')
        if m.get('DestinationSnapshotName') is not None:
            self.destination_snapshot_name = m.get('DestinationSnapshotName')
        if m.get('InstanceBillingCycle') is not None:
            self.instance_billing_cycle = m.get('InstanceBillingCycle')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        return self


class CopySnapshotShrinkRequest(TeaModel):
    def __init__(
        self,
        destination_region_ids_shrink: str = None,
        destination_snapshot_description: str = None,
        destination_snapshot_name: str = None,
        instance_billing_cycle: str = None,
        snapshot_id: str = None,
    ):
        # The IDs of destination nodes.
        # 
        # This parameter is required.
        self.destination_region_ids_shrink = destination_region_ids_shrink
        # The description of the snapshot. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
        self.destination_snapshot_description = destination_snapshot_description
        # The name of the snapshot. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        self.destination_snapshot_name = destination_snapshot_name
        self.instance_billing_cycle = instance_billing_cycle
        # The ID of the source snapshot.
        # 
        # This parameter is required.
        self.snapshot_id = snapshot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_region_ids_shrink is not None:
            result['DestinationRegionIds'] = self.destination_region_ids_shrink
        if self.destination_snapshot_description is not None:
            result['DestinationSnapshotDescription'] = self.destination_snapshot_description
        if self.destination_snapshot_name is not None:
            result['DestinationSnapshotName'] = self.destination_snapshot_name
        if self.instance_billing_cycle is not None:
            result['InstanceBillingCycle'] = self.instance_billing_cycle
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DestinationRegionIds') is not None:
            self.destination_region_ids_shrink = m.get('DestinationRegionIds')
        if m.get('DestinationSnapshotDescription') is not None:
            self.destination_snapshot_description = m.get('DestinationSnapshotDescription')
        if m.get('DestinationSnapshotName') is not None:
            self.destination_snapshot_name = m.get('DestinationSnapshotName')
        if m.get('InstanceBillingCycle') is not None:
            self.instance_billing_cycle = m.get('InstanceBillingCycle')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        return self


class CopySnapshotResponseBodyAllocationId(TeaModel):
    def __init__(
        self,
        ens_region_id: str = None,
        instance_id: List[str] = None,
    ):
        # The ID of the node.
        self.ens_region_id = ens_region_id
        # The IDs of the instances.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CopySnapshotResponseBodyUnAllocationId(TeaModel):
    def __init__(
        self,
        ens_region_id: str = None,
    ):
        # The ID of the node.
        self.ens_region_id = ens_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        return self


class CopySnapshotResponseBody(TeaModel):
    def __init__(
        self,
        allocation_id: List[CopySnapshotResponseBodyAllocationId] = None,
        biz_status_code: str = None,
        request_id: str = None,
        un_allocation_id: List[CopySnapshotResponseBodyUnAllocationId] = None,
    ):
        # The list of created snapshots.
        self.allocation_id = allocation_id
        # The success status code.
        # 
        # *   **PartSuccess**: partially succeeded.
        # *   **AllSuccess**: all succeeded.
        self.biz_status_code = biz_status_code
        # The request ID.
        self.request_id = request_id
        # The list of nodes that are not created.
        self.un_allocation_id = un_allocation_id

    def validate(self):
        if self.allocation_id:
            for k in self.allocation_id:
                if k:
                    k.validate()
        if self.un_allocation_id:
            for k in self.un_allocation_id:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AllocationId'] = []
        if self.allocation_id is not None:
            for k in self.allocation_id:
                result['AllocationId'].append(k.to_map() if k else None)
        if self.biz_status_code is not None:
            result['BizStatusCode'] = self.biz_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['UnAllocationId'] = []
        if self.un_allocation_id is not None:
            for k in self.un_allocation_id:
                result['UnAllocationId'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.allocation_id = []
        if m.get('AllocationId') is not None:
            for k in m.get('AllocationId'):
                temp_model = CopySnapshotResponseBodyAllocationId()
                self.allocation_id.append(temp_model.from_map(k))
        if m.get('BizStatusCode') is not None:
            self.biz_status_code = m.get('BizStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.un_allocation_id = []
        if m.get('UnAllocationId') is not None:
            for k in m.get('UnAllocationId'):
                temp_model = CopySnapshotResponseBodyUnAllocationId()
                self.un_allocation_id.append(temp_model.from_map(k))
        return self


class CopySnapshotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CopySnapshotResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CopySnapshotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateARMServerInstancesRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateARMServerInstancesRequest(TeaModel):
    def __init__(
        self,
        amount: int = None,
        auto_renew: bool = None,
        auto_use_coupon: bool = None,
        cidr: str = None,
        ens_region_id: str = None,
        environment_var: str = None,
        frequency: int = None,
        image_id: str = None,
        instance_billing_cycle: str = None,
        instance_type: str = None,
        key_pair_name: str = None,
        name_space: str = None,
        pay_type: str = None,
        period: int = None,
        period_unit: str = None,
        resolution: str = None,
        server_name: str = None,
        server_type: str = None,
        tag: List[CreateARMServerInstancesRequestTag] = None,
    ):
        # The number of instances to create. Valid values: **1** to **100**.
        # 
        # This parameter is required.
        self.amount = amount
        # Specifies whether to enable auto-renewal for the subscription. Valid values:
        # 
        # *   true
        # *   false (default)
        self.auto_renew = auto_renew
        # Specifies whether to use coupons. Valid values:
        # 
        # *   true
        # *   false (default)
        self.auto_use_coupon = auto_use_coupon
        self.cidr = cidr
        # The ID of the Edge Node Service (ENS) node.
        # 
        # This parameter is required.
        self.ens_region_id = ens_region_id
        # Set one or more environment variables during EAIS instance initialization.
        self.environment_var = environment_var
        # The refresh rate. Unit: Hz. Valid values: 30 and 60.
        self.frequency = frequency
        # The ID of the image.
        # 
        # This parameter is required.
        self.image_id = image_id
        self.instance_billing_cycle = instance_billing_cycle
        # The specification of the Android in Container (AIC) instance. Examples:
        # 
        # *   aic.cf52r.c1.np
        # *   aic.cf52r.c2.np
        # *   aic.cf53r.c2.np
        # *   aic.cf52r.c4.np
        # *   aic.cf53r.c3.np
        # *   aic.cf52r.c3.np
        # *   aic.cf53r.c1.np
        # *   aic.cf53r.c5.np
        # *   aic.cf53r.c6
        # *   aic.cf53r.c4.np
        # *   aic.cf53r.c6.np
        # *   aic.cf53r.c7.np
        # *   aic.cf52m1r.c5.np
        # *   aic.cf53r.c8.np
        # *   aic.cf53r.c7
        # *   aic.cf52m1r.c2.np
        # *   aic.cf52m1r.c1.np
        # *   aic.cf52m1r.c3.np
        # *   aic.cf52m1r.c4.np
        # *   aic.cf52m1r.c6
        # *   ens.a6c2
        # 
        # This parameter is required.
        self.instance_type = instance_type
        # The name of the key pair.
        self.key_pair_name = key_pair_name
        # The namespace.
        self.name_space = name_space
        # The billing method. Set the value to **PrePaid**. PrePaid specifies the subscription billing method.
        # 
        # >  Only PrePaid is supported.
        # 
        # This parameter is required.
        self.pay_type = pay_type
        # The subscription duration of the instance.
        # 
        # *   If you leave PeriodUnit empty, the instance is purchased on a monthly basis. Valid values: Day and Month.
        # *   If you set PeriodUnit to Day, you can set Period only to 3.
        # *   If you set PeriodUnit to Month, you can set Period to a value within the range of [1,9], or set the value to 12.
        self.period = period
        # The unit of the subscription duration.
        # 
        # *   If you leave PeriodUnit empty, the instance is purchased on a monthly basis. Valid values: Day and Month.
        # *   If you set PeriodUnit to Day, you can set Period only to 3.
        # *   If you set PeriodUnit to Month, you can set Period to a value within the range of [1,9], or set the value to 12.
        self.period_unit = period_unit
        # The resolution. Examples:
        # 
        # *   1920\\*864
        # *   1080\\*1920
        # *   1920\\*1080
        # *   720\\*1280
        # *   2400\\*1080
        # *   1080\\*2400
        # *   1280\\*720
        # *   864\\*1920
        # 
        # This parameter is required.
        self.resolution = resolution
        # The name of the service.
        self.server_name = server_name
        # The specification of the ARM server. Examples:
        # 
        # *   cas.cf53r
        # *   cas.cf52r
        # *   cas.cf52m1r
        # *   cas.tg52g2
        # *   ens.afq-c2m3i.medium
        # 
        # This parameter is required.
        self.server_type = server_type
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.auto_use_coupon is not None:
            result['AutoUseCoupon'] = self.auto_use_coupon
        if self.cidr is not None:
            result['Cidr'] = self.cidr
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.environment_var is not None:
            result['EnvironmentVar'] = self.environment_var
        if self.frequency is not None:
            result['Frequency'] = self.frequency
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.instance_billing_cycle is not None:
            result['InstanceBillingCycle'] = self.instance_billing_cycle
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.name_space is not None:
            result['NameSpace'] = self.name_space
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.resolution is not None:
            result['Resolution'] = self.resolution
        if self.server_name is not None:
            result['ServerName'] = self.server_name
        if self.server_type is not None:
            result['ServerType'] = self.server_type
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('AutoUseCoupon') is not None:
            self.auto_use_coupon = m.get('AutoUseCoupon')
        if m.get('Cidr') is not None:
            self.cidr = m.get('Cidr')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('EnvironmentVar') is not None:
            self.environment_var = m.get('EnvironmentVar')
        if m.get('Frequency') is not None:
            self.frequency = m.get('Frequency')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('InstanceBillingCycle') is not None:
            self.instance_billing_cycle = m.get('InstanceBillingCycle')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('NameSpace') is not None:
            self.name_space = m.get('NameSpace')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('Resolution') is not None:
            self.resolution = m.get('Resolution')
        if m.get('ServerName') is not None:
            self.server_name = m.get('ServerName')
        if m.get('ServerType') is not None:
            self.server_type = m.get('ServerType')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateARMServerInstancesRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateARMServerInstancesResponseBody(TeaModel):
    def __init__(
        self,
        instance_ids: List[str] = None,
        order_id: str = None,
        request_id: str = None,
    ):
        # The IDs of instances.
        self.instance_ids = instance_ids
        # The ID of the order.
        self.order_id = order_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateARMServerInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateARMServerInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateARMServerInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateApplicationRequest(TeaModel):
    def __init__(
        self,
        template: str = None,
        timeout: int = None,
    ):
        # The edge application template. The value must be a JSON string that contains the following information:
        # 
        # *   Basic information such as the name of the application
        # *   Information such as resource specifications and network security configurations
        # *   Service specifications
        # *   Required resources
        # 
        # This parameter is required.
        self.template = template
        # The timeout period for asynchronous processing. Unit: seconds. Default value: 1800.
        self.timeout = timeout

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template is not None:
            result['Template'] = self.template
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Template') is not None:
            self.template = m.get('Template')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        return self


class CreateApplicationResponseBody(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        request_id: str = None,
    ):
        # The ID of the application. This is the unique identifier of the edge application.
        self.app_id = app_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateApplicationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateClassicNetworkRequest(TeaModel):
    def __init__(
        self,
        cidr_block: str = None,
        description: str = None,
        ens_region_id: str = None,
        network_name: str = None,
    ):
        # The CIDR block of the network. You can use one of the following CIDR blocks or their subnets as the CIDR block of the network:
        # 
        # *   10.0.0.0/8 (default)
        # *   172.16.0.0/12
        # *   192.168.0.0/16
        # 
        # This parameter is required.
        self.cidr_block = cidr_block
        # The description of the network. The name must be 2 to 256 characters in length. It must start with a letter but cannot start with http:// or https://.
        self.description = description
        # The ID of the edge node.
        # 
        # This parameter is required.
        self.ens_region_id = ens_region_id
        # The name of the network. The name must meet the following requirements:
        # 
        # *   The name must be 2 to 128 characters in length.
        # *   The name must start with a letter but cannot start with http:// or https://.
        # *   The name can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        self.network_name = network_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.description is not None:
            result['Description'] = self.description
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.network_name is not None:
            result['NetworkName'] = self.network_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('NetworkName') is not None:
            self.network_name = m.get('NetworkName')
        return self


class CreateClassicNetworkResponseBody(TeaModel):
    def __init__(
        self,
        network_id: str = None,
        request_id: str = None,
    ):
        # The ID of the network.
        self.network_id = network_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_id is not None:
            result['NetworkId'] = self.network_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkId') is not None:
            self.network_id = m.get('NetworkId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateClassicNetworkResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateClassicNetworkResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateClassicNetworkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateClusterRequest(TeaModel):
    def __init__(
        self,
        cluster_version: str = None,
        name: str = None,
    ):
        # The version of the cluster.
        self.cluster_version = cluster_version
        # The name of the cluster.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_version is not None:
            result['ClusterVersion'] = self.cluster_version
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterVersion') is not None:
            self.cluster_version = m.get('ClusterVersion')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateClusterResponseBody(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        request_id: str = None,
    ):
        # The ID of the instance.
        self.cluster_id = cluster_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateClusterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateClusterResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDiskRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The key of the tag. Valid values of N: **1** to **20**.
        # 
        # *   The key cannot start with `aliyun`, `acs:`, `http://`, or `https://`.
        # *   The key must be up to 64 characters in length.
        # *   The tag key cannot be an empty string.
        self.key = key
        # The value of a tag that is attached to the topics you want to query. This parameter is not required. If you configure this parameter, you must also configure the **Key** parameter.**** If you include the Key and Value parameters in a request, this operation queries only the topics that use the specified tags. If you do not include these parameters in a request, this operation queries all topics that you can access.
        # 
        # *   Valid values: 1 to 20.
        # *   The value of this parameter can be an empty string.
        # *   The tag value can be up to 128 characters in length. It cannot start with aliyun or acs: and cannot contain http:// or https://.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateDiskRequest(TeaModel):
    def __init__(
        self,
        category: str = None,
        disk_name: str = None,
        encrypted: bool = None,
        ens_region_id: str = None,
        instance_billing_cycle: str = None,
        instance_charge_type: str = None,
        kmskey_id: str = None,
        size: str = None,
        snapshot_id: str = None,
        tag: List[CreateDiskRequestTag] = None,
    ):
        # The category of the disk. Valid values:
        # 
        # *   cloud_efficiency: ultra disk.
        # *   cloud_ssd: all-flash disk.
        # 
        # This parameter is required.
        self.category = category
        # The name of the disk.
        self.disk_name = disk_name
        # Specifies whether to encrypt the new system disk. Valid values:
        # 
        # *   **true**\
        # *   **false** (default): no
        self.encrypted = encrypted
        # The ID of the edge node.
        # 
        # This parameter is required.
        self.ens_region_id = ens_region_id
        self.instance_billing_cycle = instance_billing_cycle
        # The billing method of the instance. Set the value to **PostPaid**.
        # 
        # This parameter is required.
        self.instance_charge_type = instance_charge_type
        # The ID of the Key Management Service (KMS) key that is used by the cloud disk.
        # 
        # >  If you set the **Encrypted** parameter to **true**, the default service key is used when the **KMSKeyId** parameter is empty.
        self.kmskey_id = kmskey_id
        # The size of the disk. Unit: GiB.
        self.size = size
        # The ID of the snapshot that you want to use to create the disk.
        # 
        # The following limits apply to the **SnapshotId** and **Size** parameters:
        # 
        # *   If the size of the snapshot specified by **SnapshotId** is greater than the specified **Size** value, the size of the created disk is equal to the specified snapshot size.
        # *   If the size of the snapshot specified by **SnapshotId** is smaller than the specified **Size** value, the size of the created disk is equal to the specified **Size** value.
        self.snapshot_id = snapshot_id
        # The tags of the instance. You can specify at most 20 tags in each call.
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.instance_billing_cycle is not None:
            result['InstanceBillingCycle'] = self.instance_billing_cycle
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.kmskey_id is not None:
            result['KMSKeyId'] = self.kmskey_id
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('Encrypted') is not None:
            self.encrypted = m.get('Encrypted')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('InstanceBillingCycle') is not None:
            self.instance_billing_cycle = m.get('InstanceBillingCycle')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('KMSKeyId') is not None:
            self.kmskey_id = m.get('KMSKeyId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateDiskRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateDiskResponseBody(TeaModel):
    def __init__(
        self,
        instance_ids: List[str] = None,
        order_id: str = None,
        request_id: str = None,
    ):
        # The IDs of the instances.
        self.instance_ids = instance_ids
        # The ID of the order. Multiple IDs are separated by commas (,).
        # 
        # >  This parameter is not returned for the pay-as-you-go billing method.
        self.order_id = order_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDiskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDiskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDiskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEipInstanceRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The key of tag N of the instance. Valid values of N: **1** to **20**.
        # 
        # *   The key cannot start with `aliyun`, `acs:`, `http://`, or `https://`.
        # *   The key must be up to 64 characters in length.
        # *   The tag key cannot be an empty string.
        self.key = key
        # The value of tag N that is added to the resource. Valid values of N: 1 to 20. The tag value can be an empty string. The tag value can be up to 128 characters in length. It cannot start with acs: or contain http:// or https://.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateEipInstanceRequest(TeaModel):
    def __init__(
        self,
        bandwidth: int = None,
        client_token: str = None,
        description: str = None,
        ens_region_id: str = None,
        instance_charge_type: str = None,
        internet_charge_type: str = None,
        isp: str = None,
        name: str = None,
        tag: List[CreateEipInstanceRequestTag] = None,
    ):
        # The maximum bandwidth of the EIP. Default value: 5. Valid values: 5 to 10000. Unit: Mbit/s.
        self.bandwidth = bandwidth
        # The client token that is used to ensure the idempotence of the request. This prevents repeated operations caused by multiple retries.
        # 
        # *   You can use the client to generate the token, but you must make sure that the token is unique among different requests. The token can only contain ASCII characters and cannot exceed 64 characters in length.
        # *   If you use a ClientToken that has been used and other request parameters remain unchanged in a repeated request, the client will receive the same result as the first request. This does not affect the status of your server.
        # *   You can initiate a retry when the operation times out or the error code is PROCESSING. The idempotence is valid. If HTTP status code 200 is returned, the client receives the same result as the last request. However, your server status is not affected. If HTTP status code 4xx is returned and error code is not PROCESSING, the idempotence is invalid.
        # *   A client token is valid for 10 minutes.
        self.client_token = client_token
        # The description of the EIP.
        self.description = description
        # The ID of the Edge Node Service (ENS) node.
        # 
        # This parameter is required.
        self.ens_region_id = ens_region_id
        # The billing method of the EIP. Set the value to **PostPaid**.
        # 
        # This parameter is required.
        self.instance_charge_type = instance_charge_type
        # The metering method of the EIP. Set the value to **95BandwidthByMonth**.
        # 
        # This parameter is required.
        self.internet_charge_type = internet_charge_type
        # The Internet service provider. Valid values:
        # 
        # *   **cmcc**: China Mobile.
        # *   **unicom**: China Unicom.
        # *   **telecom**: China Telecom.
        self.isp = isp
        # The name of the EIP.
        self.name = name
        # The tags.
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.name is not None:
            result['Name'] = self.name
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateEipInstanceRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateEipInstanceResponseBody(TeaModel):
    def __init__(
        self,
        allocation_id: str = None,
        request_id: str = None,
    ):
        # The ID of the EIP.
        self.allocation_id = allocation_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allocation_id is not None:
            result['AllocationId'] = self.allocation_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllocationId') is not None:
            self.allocation_id = m.get('AllocationId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateEipInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateEipInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEipInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEnsRouteEntryRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        destination_cidr_block: str = None,
        next_hop_id: str = None,
        next_hop_type: str = None,
        route_entry_name: str = None,
        route_table_id: str = None,
        source_cidr_block: str = None,
    ):
        # The description of the custom route entry.
        self.description = description
        # The destination CIDR block of the custom route entry. Make sure that the following requirements are met:
        # 
        # *   The destination CIDR block cannot point or belong to 100.64.0.0/10.
        # *   The destination CIDR blocks of the custom route entries in the same route table cannot overlap.
        # *   0.0.0.0/0 indicates the default CIDR block.
        # 
        # This parameter is required.
        self.destination_cidr_block = destination_cidr_block
        # The ID of the next hop of the custom route entry.
        # 
        # This parameter is required.
        self.next_hop_id = next_hop_id
        # The next hop type of the custom route. Valid values:
        # 
        # *   Instance: an ENS instance.
        # *   HaVip: a high-availability virtual IP address (HAVIP).
        # *   NetworkPeer: VPC peering connection.
        self.next_hop_type = next_hop_type
        # The name of the custom route entry that you want to add. The name must be 1 to 128 characters in length. It cannot start with http:// or https://.
        self.route_entry_name = route_entry_name
        # The ID of the route table to which you want to add a custom route entry.
        # 
        # This parameter is required.
        self.route_table_id = route_table_id
        # The source CIDR block is available when you configure a route entry in the gateway route table, but is not unavailable when you configure a route entry in the vSwitch route table.
        self.source_cidr_block = source_cidr_block

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        if self.next_hop_id is not None:
            result['NextHopId'] = self.next_hop_id
        if self.next_hop_type is not None:
            result['NextHopType'] = self.next_hop_type
        if self.route_entry_name is not None:
            result['RouteEntryName'] = self.route_entry_name
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        if self.source_cidr_block is not None:
            result['SourceCidrBlock'] = self.source_cidr_block
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        if m.get('NextHopId') is not None:
            self.next_hop_id = m.get('NextHopId')
        if m.get('NextHopType') is not None:
            self.next_hop_type = m.get('NextHopType')
        if m.get('RouteEntryName') is not None:
            self.route_entry_name = m.get('RouteEntryName')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        if m.get('SourceCidrBlock') is not None:
            self.source_cidr_block = m.get('SourceCidrBlock')
        return self


class CreateEnsRouteEntryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        route_entry_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The ID of the route.
        self.route_entry_id = route_entry_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.route_entry_id is not None:
            result['RouteEntryId'] = self.route_entry_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RouteEntryId') is not None:
            self.route_entry_id = m.get('RouteEntryId')
        return self


class CreateEnsRouteEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateEnsRouteEntryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEnsRouteEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEnsSaleControlRequestSaleControlsConditionControls(TeaModel):
    def __init__(
        self,
        condition_control_module_code: str = None,
        condition_control_module_value: str = None,
    ):
        self.condition_control_module_code = condition_control_module_code
        self.condition_control_module_value = condition_control_module_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.condition_control_module_code is not None:
            result['ConditionControlModuleCode'] = self.condition_control_module_code
        if self.condition_control_module_value is not None:
            result['ConditionControlModuleValue'] = self.condition_control_module_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConditionControlModuleCode') is not None:
            self.condition_control_module_code = m.get('ConditionControlModuleCode')
        if m.get('ConditionControlModuleValue') is not None:
            self.condition_control_module_value = m.get('ConditionControlModuleValue')
        return self


class CreateEnsSaleControlRequestSaleControlsModuleValue(TeaModel):
    def __init__(
        self,
        module_max_value: str = None,
        module_min_value: str = None,
        module_value: List[str] = None,
    ):
        self.module_max_value = module_max_value
        self.module_min_value = module_min_value
        self.module_value = module_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.module_max_value is not None:
            result['ModuleMaxValue'] = self.module_max_value
        if self.module_min_value is not None:
            result['ModuleMinValue'] = self.module_min_value
        if self.module_value is not None:
            result['ModuleValue'] = self.module_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ModuleMaxValue') is not None:
            self.module_max_value = m.get('ModuleMaxValue')
        if m.get('ModuleMinValue') is not None:
            self.module_min_value = m.get('ModuleMinValue')
        if m.get('ModuleValue') is not None:
            self.module_value = m.get('ModuleValue')
        return self


class CreateEnsSaleControlRequestSaleControls(TeaModel):
    def __init__(
        self,
        condition_controls: List[CreateEnsSaleControlRequestSaleControlsConditionControls] = None,
        description: str = None,
        module_code: str = None,
        module_value: CreateEnsSaleControlRequestSaleControlsModuleValue = None,
        operator: str = None,
        order_type: str = None,
    ):
        self.condition_controls = condition_controls
        self.description = description
        # This parameter is required.
        self.module_code = module_code
        # This parameter is required.
        self.module_value = module_value
        # This parameter is required.
        self.operator = operator
        # This parameter is required.
        self.order_type = order_type

    def validate(self):
        if self.condition_controls:
            for k in self.condition_controls:
                if k:
                    k.validate()
        if self.module_value:
            self.module_value.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConditionControls'] = []
        if self.condition_controls is not None:
            for k in self.condition_controls:
                result['ConditionControls'].append(k.to_map() if k else None)
        if self.description is not None:
            result['Description'] = self.description
        if self.module_code is not None:
            result['ModuleCode'] = self.module_code
        if self.module_value is not None:
            result['ModuleValue'] = self.module_value.to_map()
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.condition_controls = []
        if m.get('ConditionControls') is not None:
            for k in m.get('ConditionControls'):
                temp_model = CreateEnsSaleControlRequestSaleControlsConditionControls()
                self.condition_controls.append(temp_model.from_map(k))
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ModuleCode') is not None:
            self.module_code = m.get('ModuleCode')
        if m.get('ModuleValue') is not None:
            temp_model = CreateEnsSaleControlRequestSaleControlsModuleValue()
            self.module_value = temp_model.from_map(m['ModuleValue'])
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        return self


class CreateEnsSaleControlRequest(TeaModel):
    def __init__(
        self,
        ali_uid_account: str = None,
        commodity_code: str = None,
        custom_account: str = None,
        sale_controls: List[CreateEnsSaleControlRequestSaleControls] = None,
    ):
        self.ali_uid_account = ali_uid_account
        # This parameter is required.
        self.commodity_code = commodity_code
        self.custom_account = custom_account
        # This parameter is required.
        self.sale_controls = sale_controls

    def validate(self):
        if self.sale_controls:
            for k in self.sale_controls:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid_account is not None:
            result['AliUidAccount'] = self.ali_uid_account
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.custom_account is not None:
            result['CustomAccount'] = self.custom_account
        result['SaleControls'] = []
        if self.sale_controls is not None:
            for k in self.sale_controls:
                result['SaleControls'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliUidAccount') is not None:
            self.ali_uid_account = m.get('AliUidAccount')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('CustomAccount') is not None:
            self.custom_account = m.get('CustomAccount')
        self.sale_controls = []
        if m.get('SaleControls') is not None:
            for k in m.get('SaleControls'):
                temp_model = CreateEnsSaleControlRequestSaleControls()
                self.sale_controls.append(temp_model.from_map(k))
        return self


class CreateEnsSaleControlShrinkRequest(TeaModel):
    def __init__(
        self,
        ali_uid_account: str = None,
        commodity_code: str = None,
        custom_account: str = None,
        sale_controls_shrink: str = None,
    ):
        self.ali_uid_account = ali_uid_account
        # This parameter is required.
        self.commodity_code = commodity_code
        self.custom_account = custom_account
        # This parameter is required.
        self.sale_controls_shrink = sale_controls_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid_account is not None:
            result['AliUidAccount'] = self.ali_uid_account
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.custom_account is not None:
            result['CustomAccount'] = self.custom_account
        if self.sale_controls_shrink is not None:
            result['SaleControls'] = self.sale_controls_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliUidAccount') is not None:
            self.ali_uid_account = m.get('AliUidAccount')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('CustomAccount') is not None:
            self.custom_account = m.get('CustomAccount')
        if m.get('SaleControls') is not None:
            self.sale_controls_shrink = m.get('SaleControls')
        return self


class CreateEnsSaleControlResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateEnsSaleControlResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateEnsSaleControlResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEnsSaleControlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEnsServiceRequest(TeaModel):
    def __init__(
        self,
        ens_service_id: str = None,
        order_type: str = None,
    ):
        # The ID of the resource that you want to obtain. You can specify only one ID in a request.
        # 
        # This parameter is required.
        self.ens_service_id = ens_service_id
        # The operation to perform after you preview the created edge service. Valid values:
        # 
        # *   **Buy**: create
        # *   **Upgrade**: change
        # 
        # This parameter is required.
        self.order_type = order_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ens_service_id is not None:
            result['EnsServiceId'] = self.ens_service_id
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnsServiceId') is not None:
            self.ens_service_id = m.get('EnsServiceId')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        return self


class CreateEnsServiceResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        request_id: str = None,
    ):
        # The service code. 0 is returned for a successful request. An error code is returned for a failed request.
        self.code = code
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateEnsServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateEnsServiceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEnsServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEpnInstanceRequest(TeaModel):
    def __init__(
        self,
        epninstance_name: str = None,
        epninstance_type: str = None,
        internet_charge_type: str = None,
        internet_max_bandwidth_out: int = None,
        networking_model: str = None,
    ):
        # The name of the EPN instance.
        self.epninstance_name = epninstance_name
        # The type of the EPN instance. Set the value to **EdgeToEdge**.
        # 
        # This parameter is required.
        self.epninstance_type = epninstance_type
        # The billing method for network usage. Valid values:
        # 
        # *   **BandwidthByDay**: Pay by daily peak bandwidth.
        # *   **95BandwidthByMonth**: Pay by monthly 95th percentile bandwidth.
        # *   **PayByBandwidth4thMonth**: Pay by monthly fourth peak bandwidth.
        # *   **PayByBandwidth**: Pay by fixed bandwidth.
        # 
        # You can specify only one metering method for network usage and cannot overwrite the existing metering method.
        # 
        # This parameter is required.
        self.internet_charge_type = internet_charge_type
        # The maximum outbound public bandwidth. Unit: Mbit/s. Valid values: 1 to 100.
        # 
        # This parameter is required.
        self.internet_max_bandwidth_out = internet_max_bandwidth_out
        # The networking mode. Valid values:
        # 
        # *   **SpeedUp**: intelligent acceleration network (Internet)
        # *   **Connection**: internal network
        # *   **SpeedUpAndConnection**: intelligent acceleration network and internal network
        # 
        # This parameter is required.
        self.networking_model = networking_model

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.epninstance_name is not None:
            result['EPNInstanceName'] = self.epninstance_name
        if self.epninstance_type is not None:
            result['EPNInstanceType'] = self.epninstance_type
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.internet_max_bandwidth_out is not None:
            result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        if self.networking_model is not None:
            result['NetworkingModel'] = self.networking_model
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EPNInstanceName') is not None:
            self.epninstance_name = m.get('EPNInstanceName')
        if m.get('EPNInstanceType') is not None:
            self.epninstance_type = m.get('EPNInstanceType')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('InternetMaxBandwidthOut') is not None:
            self.internet_max_bandwidth_out = m.get('InternetMaxBandwidthOut')
        if m.get('NetworkingModel') is not None:
            self.networking_model = m.get('NetworkingModel')
        return self


class CreateEpnInstanceResponseBody(TeaModel):
    def __init__(
        self,
        epninstance_id: str = None,
        request_id: str = None,
    ):
        # The ID of the EPN instance.
        self.epninstance_id = epninstance_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.epninstance_id is not None:
            result['EPNInstanceId'] = self.epninstance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EPNInstanceId') is not None:
            self.epninstance_id = m.get('EPNInstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateEpnInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateEpnInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEpnInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFileSystemRequestOrderDetails(TeaModel):
    def __init__(
        self,
        charge_type: str = None,
        ens_region_id: str = None,
        file_system_name: str = None,
        mount_target_domain: str = None,
        network_id: str = None,
        order_type: str = None,
        protocol_type: str = None,
        storge_type: str = None,
    ):
        # The billing method of the NAS file system. Valid values:
        # 
        # *   PrePaid: subscription. This billing method is not supported.
        # *   PostPaid: pay-as-you-go.
        # 
        # This parameter is required.
        self.charge_type = charge_type
        # The ID of the edge node.
        # 
        # This parameter is required.
        self.ens_region_id = ens_region_id
        # The name of the file system. The name must be 1 to 80 characters in length and can contain letters, digits, hyphens (-), and underscores (_).
        # 
        # This parameter is required.
        self.file_system_name = file_system_name
        # The name of the mount target. The name must be 1 to 80 characters in length and can contain letters, digits, hyphens (-), and underscores (_).
        # 
        # This parameter is required.
        self.mount_target_domain = mount_target_domain
        # The ID of the VPC.
        # 
        # This parameter is required.
        self.network_id = network_id
        # The type of the order. Set the value to BUY.
        # 
        # This parameter is required.
        self.order_type = order_type
        # The storage protocol. Set the value to nfs.
        # 
        # This parameter is required.
        self.protocol_type = protocol_type
        # The storage type. Valid values:
        # 
        # *   Capacity.
        # *   Performance.
        # 
        # This parameter is required.
        self.storge_type = storge_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.file_system_name is not None:
            result['FileSystemName'] = self.file_system_name
        if self.mount_target_domain is not None:
            result['MountTargetDomain'] = self.mount_target_domain
        if self.network_id is not None:
            result['NetworkId'] = self.network_id
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.storge_type is not None:
            result['StorgeType'] = self.storge_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('FileSystemName') is not None:
            self.file_system_name = m.get('FileSystemName')
        if m.get('MountTargetDomain') is not None:
            self.mount_target_domain = m.get('MountTargetDomain')
        if m.get('NetworkId') is not None:
            self.network_id = m.get('NetworkId')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('StorgeType') is not None:
            self.storge_type = m.get('StorgeType')
        return self


class CreateFileSystemRequest(TeaModel):
    def __init__(
        self,
        order_details: List[CreateFileSystemRequestOrderDetails] = None,
    ):
        # The information about the orders.
        # 
        # This parameter is required.
        self.order_details = order_details

    def validate(self):
        if self.order_details:
            for k in self.order_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OrderDetails'] = []
        if self.order_details is not None:
            for k in self.order_details:
                result['OrderDetails'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.order_details = []
        if m.get('OrderDetails') is not None:
            for k in m.get('OrderDetails'):
                temp_model = CreateFileSystemRequestOrderDetails()
                self.order_details.append(temp_model.from_map(k))
        return self


class CreateFileSystemShrinkRequest(TeaModel):
    def __init__(
        self,
        order_details_shrink: str = None,
    ):
        # The information about the orders.
        # 
        # This parameter is required.
        self.order_details_shrink = order_details_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_details_shrink is not None:
            result['OrderDetails'] = self.order_details_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrderDetails') is not None:
            self.order_details_shrink = m.get('OrderDetails')
        return self


class CreateFileSystemResponseBodyAllocationIds(TeaModel):
    def __init__(
        self,
        ens_region_id: str = None,
        instance_id: str = None,
    ):
        self.ens_region_id = ens_region_id
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateFileSystemResponseBody(TeaModel):
    def __init__(
        self,
        allocation_id: List[str] = None,
        allocation_ids: List[CreateFileSystemResponseBodyAllocationIds] = None,
        biz_status_code: str = None,
        request_id: str = None,
        un_allocation_id: List[str] = None,
    ):
        # The information about the file system that was created.
        self.allocation_id = allocation_id
        self.allocation_ids = allocation_ids
        # The status code for successful operations. Valid values:
        # 
        # *   PartSuccess: The operation is partially successful.
        # *   AllSuccess: The operation is successful.
        self.biz_status_code = biz_status_code
        # The ID of the request.
        self.request_id = request_id
        # The information about the file system that failed to be created.
        self.un_allocation_id = un_allocation_id

    def validate(self):
        if self.allocation_ids:
            for k in self.allocation_ids:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allocation_id is not None:
            result['AllocationId'] = self.allocation_id
        result['AllocationIds'] = []
        if self.allocation_ids is not None:
            for k in self.allocation_ids:
                result['AllocationIds'].append(k.to_map() if k else None)
        if self.biz_status_code is not None:
            result['BizStatusCode'] = self.biz_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.un_allocation_id is not None:
            result['UnAllocationId'] = self.un_allocation_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllocationId') is not None:
            self.allocation_id = m.get('AllocationId')
        self.allocation_ids = []
        if m.get('AllocationIds') is not None:
            for k in m.get('AllocationIds'):
                temp_model = CreateFileSystemResponseBodyAllocationIds()
                self.allocation_ids.append(temp_model.from_map(k))
        if m.get('BizStatusCode') is not None:
            self.biz_status_code = m.get('BizStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UnAllocationId') is not None:
            self.un_allocation_id = m.get('UnAllocationId')
        return self


class CreateFileSystemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateFileSystemResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateFileSystemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateForwardEntryRequest(TeaModel):
    def __init__(
        self,
        external_ip: str = None,
        external_port: str = None,
        forward_entry_name: str = None,
        health_check_port: int = None,
        internal_ip: str = None,
        internal_port: str = None,
        ip_protocol: str = None,
        nat_gateway_id: str = None,
        standby_external_ip: str = None,
    ):
        # The elastic IP address (EIP) that is used to access the Internet.
        # 
        # This parameter is required.
        self.external_ip = external_ip
        # The external port or port range that is used for port forwarding.
        # 
        # *   Valid values: 1 to 65535.
        # *   To specify a port range, separate the first port and the last port with a forward slash (/), such as 10/20.
        # *   If you set ExternalPort to a port range, you must also set InternalPort to a port range. The number of ports in the port ranges must be the same. For example, if you set ExternalPort to 10/20, you can set InternalPort to 80/90.
        # 
        # This parameter is required.
        self.external_port = external_port
        # The name of the DNAT entry. The name must be 2 to 128 characters in length. The name cannot start with `http://` or `https://`.
        self.forward_entry_name = forward_entry_name
        # The probe port. The port must be within the internal port range. By default, this parameter is left empty.
        self.health_check_port = health_check_port
        # The private IP address of the instance that uses the DNAT entry for Internet communication.
        # 
        # This parameter is required.
        self.internal_ip = internal_ip
        # The internal port or port range that is used for port forwarding.
        # 
        # *   Valid values: 1 to 65535.
        # *   To specify a port range, separate the first port and the last port with a forward slash (/), such as 10/20.
        # 
        # This parameter is required.
        self.internal_port = internal_port
        # The protocol. Valid values:
        # 
        # *   **TCP**: forwards TCP packets.
        # *   **UDP**: forwards UDP packets.
        # *   **Any** (default): forwards all packets.
        self.ip_protocol = ip_protocol
        # The ID of the Network Address Translation (NAT) gateway.
        # 
        # This parameter is required.
        self.nat_gateway_id = nat_gateway_id
        # The secondary EIP that is used to access the Internet. You need to select a secondary EIP that is bound to NAT. After the DNAT entry is created, the secondary EIP takes effect.
        self.standby_external_ip = standby_external_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_ip is not None:
            result['ExternalIp'] = self.external_ip
        if self.external_port is not None:
            result['ExternalPort'] = self.external_port
        if self.forward_entry_name is not None:
            result['ForwardEntryName'] = self.forward_entry_name
        if self.health_check_port is not None:
            result['HealthCheckPort'] = self.health_check_port
        if self.internal_ip is not None:
            result['InternalIp'] = self.internal_ip
        if self.internal_port is not None:
            result['InternalPort'] = self.internal_port
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.standby_external_ip is not None:
            result['StandbyExternalIp'] = self.standby_external_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalIp') is not None:
            self.external_ip = m.get('ExternalIp')
        if m.get('ExternalPort') is not None:
            self.external_port = m.get('ExternalPort')
        if m.get('ForwardEntryName') is not None:
            self.forward_entry_name = m.get('ForwardEntryName')
        if m.get('HealthCheckPort') is not None:
            self.health_check_port = m.get('HealthCheckPort')
        if m.get('InternalIp') is not None:
            self.internal_ip = m.get('InternalIp')
        if m.get('InternalPort') is not None:
            self.internal_port = m.get('InternalPort')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('StandbyExternalIp') is not None:
            self.standby_external_ip = m.get('StandbyExternalIp')
        return self


class CreateForwardEntryResponseBody(TeaModel):
    def __init__(
        self,
        forward_entry_id: str = None,
        request_id: str = None,
    ):
        # The ID of the DNAT entry.
        self.forward_entry_id = forward_entry_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.forward_entry_id is not None:
            result['ForwardEntryId'] = self.forward_entry_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ForwardEntryId') is not None:
            self.forward_entry_id = m.get('ForwardEntryId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateForwardEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateForwardEntryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateForwardEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHaVipRequest(TeaModel):
    def __init__(
        self,
        amount: int = None,
        description: str = None,
        ip_address: str = None,
        name: str = None,
        v_switch_id: str = None,
    ):
        # The number of HAVIPs that you want to create. Valid values: 1 to 10. The value can be only 1 if you specify an IP address.
        # 
        # Default value: 1.
        self.amount = amount
        # The description of the HAVIP.
        self.description = description
        # The IP address of the HAVIP.
        self.ip_address = ip_address
        # The name of the HAVIP.
        self.name = name
        # The vSwitch ID of the HAVIP.
        self.v_switch_id = v_switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.description is not None:
            result['Description'] = self.description
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.name is not None:
            result['Name'] = self.name
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class CreateHaVipResponseBody(TeaModel):
    def __init__(
        self,
        ha_vip_ids: List[str] = None,
        request_id: str = None,
    ):
        # The IDs of the HAVIPs.
        self.ha_vip_ids = ha_vip_ids
        # Request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ha_vip_ids is not None:
            result['HaVipIds'] = self.ha_vip_ids
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HaVipIds') is not None:
            self.ha_vip_ids = m.get('HaVipIds')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateHaVipResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateHaVipResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHaVipResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateImageRequest(TeaModel):
    def __init__(
        self,
        delete_after_image_upload: str = None,
        image_name: str = None,
        instance_id: str = None,
        snapshot_id: str = None,
        target_ossregion_id: str = None,
        with_data_disks: bool = None,
    ):
        # Specifies whether to automatically release the instance after the image is packaged and uploaded. Only image builders are supported. Default value: false. Valid values:
        # 
        # *   true: The image is released when the instance is released.
        # *   false: The image is retained when the instance is released.
        # *   If you leave this property empty, false is used by default.
        self.delete_after_image_upload = delete_after_image_upload
        # The name of the image. The name must be 2 to 128 characters in length. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-). It must start with a letter but cannot start with `http://` or `https://`. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        # 
        # This parameter is required.
        self.image_name = image_name
        # The ID of the instance.
        self.instance_id = instance_id
        # The ID of the snapshot.
        self.snapshot_id = snapshot_id
        # The region of the destination OSS bucket where the image is to be stored.
        self.target_ossregion_id = target_ossregion_id
        # Specifies whether to include data disk snapshots in the custom image.
        self.with_data_disks = with_data_disks

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_after_image_upload is not None:
            result['DeleteAfterImageUpload'] = self.delete_after_image_upload
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.target_ossregion_id is not None:
            result['TargetOSSRegionId'] = self.target_ossregion_id
        if self.with_data_disks is not None:
            result['WithDataDisks'] = self.with_data_disks
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeleteAfterImageUpload') is not None:
            self.delete_after_image_upload = m.get('DeleteAfterImageUpload')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('TargetOSSRegionId') is not None:
            self.target_ossregion_id = m.get('TargetOSSRegionId')
        if m.get('WithDataDisks') is not None:
            self.with_data_disks = m.get('WithDataDisks')
        return self


class CreateImageResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        image_id: str = None,
        request_id: str = None,
    ):
        # The returned service code. 0 indicates that the request was successful.
        self.code = code
        # The ID of the image.
        self.image_id = image_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateImageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateImageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateInstanceRequestDataDisk(TeaModel):
    def __init__(
        self,
        size: str = None,
    ):
        # The capacity of the first data disk. Unit: GiB. The capacity is at least 20 GiB and is a multiple of 10 GiB.
        self.size = size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class CreateInstanceRequestSystemDisk(TeaModel):
    def __init__(
        self,
        size: str = None,
    ):
        # The size of the system disk. Unit: GiB. Valid values: **20** and **40**. The value cannot be smaller than the size of the image and must be a multiple of 10 GiB.
        self.size = size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class CreateInstanceRequest(TeaModel):
    def __init__(
        self,
        data_disk: List[CreateInstanceRequestDataDisk] = None,
        system_disk: CreateInstanceRequestSystemDisk = None,
        auto_renew: str = None,
        auto_renew_period: str = None,
        ens_region_id: str = None,
        host_name: str = None,
        image_id: str = None,
        instance_name: str = None,
        instance_type: str = None,
        internet_charge_type: str = None,
        ip_type: str = None,
        key_pair_name: str = None,
        owner_id: int = None,
        password: str = None,
        password_inherit: bool = None,
        payment_type: str = None,
        period: str = None,
        private_ip_address: str = None,
        public_ip_identification: bool = None,
        quantity: str = None,
        unique_suffix: bool = None,
        user_data: str = None,
        v_switch_id: str = None,
    ):
        self.data_disk = data_disk
        self.system_disk = system_disk
        # Specifies whether to enable the auto-renewal feature. Valid values: **True** and **False**. Default value: False.
        self.auto_renew = auto_renew
        # The auto-renewal period for the instance. This parameter is required when the **AutoRenew** parameter is set to **True**. Valid values: **1** to **12**. Unit: months.
        self.auto_renew_period = auto_renew_period
        # The region ID.
        # 
        # This parameter is required.
        self.ens_region_id = ens_region_id
        # The hostname of the Elastic Compute Service (ECS) instance. General naming rules: The hostname cannot start or end with a period (.) or hyphen (-). It cannot contain consecutive periods (.) or hyphens (-).
        # 
        # Naming rules for specific instances:
        # 
        # *   For Windows instances, the hostname must be **2** to **15** characters in length and cannot contain periods (.) or contain only digits. The hostname cannot contain periods (.) or contain only digits.
        # *   For instances that run one of other operating systems such as Linux, the hostname must be **2** to **64** characters in length. You can use periods (.) to separate the hostname into multiple segments. Each segment can contain letters, digits, and hyphens (-).
        self.host_name = host_name
        # The ID of the image file that you select when creating the instance.
        self.image_id = image_id
        # The name of the instance. The name must conform to the following naming conventions:
        # 
        # *   The name must be **2** to **128** characters in length.
        # *   It must start with a letter but cannot start with http:// or https://.
        # *   The name can contain letters, digits, colons (:), underscores (_), periods (.), and hyphens (-).
        # 
        # If you do not specify this parameter, the instance ID is used as the instance name by default.
        self.instance_name = instance_name
        # The type of the instance.
        # 
        # For more information, see [](~~66124~~).
        # 
        # This parameter is required.
        self.instance_type = instance_type
        # This parameter is required if you create the instance for the first time. The existing billing method is used by default if you have created an instance. Valid values:
        # 
        # *   **BandwidthByDay**: Pay by daily peak bandwidth.
        # *   **95BandwidthByMonth**: Pay by monthly 95th percentile bandwidth.
        self.internet_charge_type = internet_charge_type
        # The type of the IP address. Valid values:
        # 
        # *   **ipv4** (default)
        # *   **ipv6**\
        # *   **ipv4Andipv6**\
        self.ip_type = ip_type
        # The name of the key pair. You can specify only one name.
        self.key_pair_name = key_pair_name
        self.owner_id = owner_id
        # The password of the instance.
        # 
        # The password must be 8 to 30 characters in length and contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include: ``()`~!@#$%^&*-_+=|{}[]:;\\"<>,.?/``
        self.password = password
        # Specifies whether to use the preset password of the image. Valid values:
        # 
        # - **true**: The password preset in the image is used, and the **Password** parameter must be null. For secure access, make sure that the selected image has a password configured.
        # 
        # - **false**: does not use the password preset in the image.
        self.password_inherit = password_inherit
        # The billing method of the instance. Set the value to Subscription.
        self.payment_type = payment_type
        # The subscription period of the instance. Valid values: **1** to **9** and **12**. Unit: months.
        # 
        # This parameter is required.
        self.period = period
        # The internal IP address. If this parameter is specified, you must specify the vSwitch ID. The vSwitch must be created first. Otherwise, an error is returned.
        self.private_ip_address = private_ip_address
        # Specifies whether a public IP address can be assigned to the specified instance. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.public_ip_identification = public_ip_identification
        # The number of instances.
        # 
        # This parameter is required.
        self.quantity = quantity
        # Specifies whether to automatically append sequential suffixes to the hostnames specified by the **HostName** parameter and instance names specified by the **InstanceName** parameter. The sequential suffixes range from **001** to **999**.
        # 
        # Examples: **LocalHost001** and **LocalHost002**, and **MyInstance001** and **MyInstance002**.
        # 
        # Default value: **false**.
        self.unique_suffix = unique_suffix
        # Custom data. The data starts with `#!`. The data can be at most 256 characters in length and 16 KB in size. Only custom scripts are supported and cannot be rendered by InstanceMetaData.
        # 
        # You can specify custom data. The data is encoded in Base64. The system does not encrypt your custom data when API requests are initiated. We recommend that you do not pass in confidential information such as passwords and private keys in plaintext. If you want to provide sensitive data such as passwords and private keys, encrypt the data and then encode it in Base64. The data is decrypted on the instance in the way it is encrypted.
        # 
        # For more information, see [User data formats](https://cloudinit.readthedocs.io/en/latest/topics/format.html).
        self.user_data = user_data
        # The ID of the vSwitch.
        self.v_switch_id = v_switch_id

    def validate(self):
        if self.data_disk:
            for k in self.data_disk:
                if k:
                    k.validate()
        if self.system_disk:
            self.system_disk.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataDisk'] = []
        if self.data_disk is not None:
            for k in self.data_disk:
                result['DataDisk'].append(k.to_map() if k else None)
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.auto_renew_period is not None:
            result['AutoRenewPeriod'] = self.auto_renew_period
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.ip_type is not None:
            result['IpType'] = self.ip_type
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.password is not None:
            result['Password'] = self.password
        if self.password_inherit is not None:
            result['PasswordInherit'] = self.password_inherit
        if self.payment_type is not None:
            result['PaymentType'] = self.payment_type
        if self.period is not None:
            result['Period'] = self.period
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.public_ip_identification is not None:
            result['PublicIpIdentification'] = self.public_ip_identification
        if self.quantity is not None:
            result['Quantity'] = self.quantity
        if self.unique_suffix is not None:
            result['UniqueSuffix'] = self.unique_suffix
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_disk = []
        if m.get('DataDisk') is not None:
            for k in m.get('DataDisk'):
                temp_model = CreateInstanceRequestDataDisk()
                self.data_disk.append(temp_model.from_map(k))
        if m.get('SystemDisk') is not None:
            temp_model = CreateInstanceRequestSystemDisk()
            self.system_disk = temp_model.from_map(m['SystemDisk'])
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('AutoRenewPeriod') is not None:
            self.auto_renew_period = m.get('AutoRenewPeriod')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('IpType') is not None:
            self.ip_type = m.get('IpType')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('PasswordInherit') is not None:
            self.password_inherit = m.get('PasswordInherit')
        if m.get('PaymentType') is not None:
            self.payment_type = m.get('PaymentType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('PublicIpIdentification') is not None:
            self.public_ip_identification = m.get('PublicIpIdentification')
        if m.get('Quantity') is not None:
            self.quantity = m.get('Quantity')
        if m.get('UniqueSuffix') is not None:
            self.unique_suffix = m.get('UniqueSuffix')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class CreateInstanceResponseBodyInstanceIds(TeaModel):
    def __init__(
        self,
        instance_id: List[str] = None,
    ):
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateInstanceResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        instance_ids: CreateInstanceResponseBodyInstanceIds = None,
        request_id: str = None,
    ):
        # The return code. A value of 0 indicates that the request is successful.
        # 
        # >  If you call this operation by using SDKs, the return value is of the integer type. If you call this operation by using common methods or HTTP requests, the return value is of the string type.
        self.code = code
        # The IDs of instances.
        self.instance_ids = instance_ids
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.instance_ids:
            self.instance_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('InstanceIds') is not None:
            temp_model = CreateInstanceResponseBodyInstanceIds()
            self.instance_ids = temp_model.from_map(m['InstanceIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateInstanceActiveOpsTaskRequest(TeaModel):
    def __init__(
        self,
        instance_ids: List[str] = None,
    ):
        self.instance_ids = instance_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        return self


class CreateInstanceActiveOpsTaskShrinkRequest(TeaModel):
    def __init__(
        self,
        instance_ids_shrink: str = None,
    ):
        self.instance_ids_shrink = instance_ids_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_ids_shrink is not None:
            result['InstanceIds'] = self.instance_ids_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceIds') is not None:
            self.instance_ids_shrink = m.get('InstanceIds')
        return self


class CreateInstanceActiveOpsTaskResponseBody(TeaModel):
    def __init__(
        self,
        instance_active_ops_task: InstanceActiveOpsTask = None,
        request_id: str = None,
    ):
        self.instance_active_ops_task = instance_active_ops_task
        self.request_id = request_id

    def validate(self):
        if self.instance_active_ops_task:
            self.instance_active_ops_task.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_active_ops_task is not None:
            result['InstanceActiveOpsTask'] = self.instance_active_ops_task.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceActiveOpsTask') is not None:
            temp_model = InstanceActiveOpsTask()
            self.instance_active_ops_task = temp_model.from_map(m['InstanceActiveOpsTask'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateInstanceActiveOpsTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateInstanceActiveOpsTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateInstanceActiveOpsTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateKeyPairRequest(TeaModel):
    def __init__(
        self,
        key_pair_name: str = None,
    ):
        # The name of the key pair. The name must conform to the following naming conventions:
        # 
        # *   The name must be 2 to 128 characters in length, and can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        # *   It must start with a letter but cannot start with `http://` or `https://`.
        # 
        # This parameter is required.
        self.key_pair_name = key_pair_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        return self


class CreateKeyPairResponseBody(TeaModel):
    def __init__(
        self,
        key_pair_finger_print: str = None,
        key_pair_id: str = None,
        key_pair_name: str = None,
        private_key_body: str = None,
        request_id: str = None,
    ):
        # The fingerprint of the key pair. The message-digest algorithm 5 (MD5) is used based on the public key fingerprint format defined in RFC 4716. For more information, see [RFC 4716](https://tools.ietf.org/html/rfc4716).
        self.key_pair_finger_print = key_pair_finger_print
        # The ID of the SSH key pair.
        self.key_pair_id = key_pair_id
        # The name of the key pair.
        self.key_pair_name = key_pair_name
        # The private key of the key pair. The private key is encoded with PEM in the PKCS#8 format.
        self.private_key_body = private_key_body
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key_pair_finger_print is not None:
            result['KeyPairFingerPrint'] = self.key_pair_finger_print
        if self.key_pair_id is not None:
            result['KeyPairId'] = self.key_pair_id
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.private_key_body is not None:
            result['PrivateKeyBody'] = self.private_key_body
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('KeyPairFingerPrint') is not None:
            self.key_pair_finger_print = m.get('KeyPairFingerPrint')
        if m.get('KeyPairId') is not None:
            self.key_pair_id = m.get('KeyPairId')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('PrivateKeyBody') is not None:
            self.private_key_body = m.get('PrivateKeyBody')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateKeyPairResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateKeyPairResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateKeyPairResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLoadBalancerRequest(TeaModel):
    def __init__(
        self,
        billing_cycle: str = None,
        client_token: str = None,
        ens_region_id: str = None,
        load_balancer_name: str = None,
        load_balancer_spec: str = None,
        load_balancer_type: str = None,
        network_id: str = None,
        pay_type: str = None,
        v_switch_id: str = None,
    ):
        self.billing_cycle = billing_cycle
        # The client token that is used to ensure the idempotence of the request. This prevents repeated operations caused by multiple retries.
        # 
        # *   You can use the client to generate the token, but you must make sure that the token is unique among different requests. The token can only contain ASCII characters and cannot exceed 64 characters in length.
        # *   If you retry an API request with the same client token and request parameters after it has completed successfully, the result of the original request is returned. The server status does not change.
        # *   You can initiate a retry when the operation times out or the error code is PROCESSING. The idempotence is valid. If HTTP status code 200 is returned, the client receives the same result as the last request. However, your server status is not affected. If HTTP status code 4xx is returned and error code is not PROCESSING, the idempotence is invalid.
        # *   A client token is valid for 10 minutes.
        self.client_token = client_token
        # The ID of the Edge Node Service (ENS) node.
        # 
        # This parameter is required.
        self.ens_region_id = ens_region_id
        # The name of the ELB instance. The name must be 1 to 80 characters in length. If you leave this parameter empty, the system randomly allocates a name as the value of this parameter.
        # 
        # >  The value cannot start with `http://` or `https://`.
        self.load_balancer_name = load_balancer_name
        # The specification of the ELB instance.
        # 
        # This parameter is required.
        self.load_balancer_spec = load_balancer_spec
        self.load_balancer_type = load_balancer_type
        # The network ID of the created ELB instance.
        # 
        # This parameter is required.
        self.network_id = network_id
        # The billing method of the cluster. Valid value: PostPaid. PostPaid specifies the pay-as-you-go billing method.
        # 
        # This parameter is required.
        self.pay_type = pay_type
        # The ID of the vSwitch to which the internal-facing ELB instance belongs.
        # 
        # This parameter is required.
        self.v_switch_id = v_switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.billing_cycle is not None:
            result['BillingCycle'] = self.billing_cycle
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.load_balancer_name is not None:
            result['LoadBalancerName'] = self.load_balancer_name
        if self.load_balancer_spec is not None:
            result['LoadBalancerSpec'] = self.load_balancer_spec
        if self.load_balancer_type is not None:
            result['LoadBalancerType'] = self.load_balancer_type
        if self.network_id is not None:
            result['NetworkId'] = self.network_id
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BillingCycle') is not None:
            self.billing_cycle = m.get('BillingCycle')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('LoadBalancerName') is not None:
            self.load_balancer_name = m.get('LoadBalancerName')
        if m.get('LoadBalancerSpec') is not None:
            self.load_balancer_spec = m.get('LoadBalancerSpec')
        if m.get('LoadBalancerType') is not None:
            self.load_balancer_type = m.get('LoadBalancerType')
        if m.get('NetworkId') is not None:
            self.network_id = m.get('NetworkId')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class CreateLoadBalancerResponseBody(TeaModel):
    def __init__(
        self,
        load_balancer_id: str = None,
        load_balancer_name: str = None,
        network_id: str = None,
        request_id: str = None,
        v_switch_id: str = None,
    ):
        # The ID of the ELB instance.
        self.load_balancer_id = load_balancer_id
        # The name of the ELB instance.
        self.load_balancer_name = load_balancer_name
        # The ID of the network.
        self.network_id = network_id
        # The ID of the request.
        self.request_id = request_id
        # The ID of the vSwitch to which the ELB instance belongs.
        self.v_switch_id = v_switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.load_balancer_id is not None:
            result['LoadBalancerId'] = self.load_balancer_id
        if self.load_balancer_name is not None:
            result['LoadBalancerName'] = self.load_balancer_name
        if self.network_id is not None:
            result['NetworkId'] = self.network_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LoadBalancerId') is not None:
            self.load_balancer_id = m.get('LoadBalancerId')
        if m.get('LoadBalancerName') is not None:
            self.load_balancer_name = m.get('LoadBalancerName')
        if m.get('NetworkId') is not None:
            self.network_id = m.get('NetworkId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class CreateLoadBalancerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateLoadBalancerResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLoadBalancerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLoadBalancerHTTPListenerRequest(TeaModel):
    def __init__(
        self,
        backend_server_port: int = None,
        description: str = None,
        forward_port: int = None,
        health_check: str = None,
        health_check_connect_port: int = None,
        health_check_domain: str = None,
        health_check_http_code: str = None,
        health_check_interval: int = None,
        health_check_method: str = None,
        health_check_timeout: int = None,
        health_check_uri: str = None,
        healthy_threshold: int = None,
        idle_timeout: int = None,
        listener_forward: str = None,
        listener_port: int = None,
        load_balancer_id: str = None,
        request_timeout: int = None,
        scheduler: str = None,
        unhealthy_threshold: int = None,
        xforwarded_for: str = None,
    ):
        # The port used by the backend server of the ELB instance. Valid values: **1** to **65535**.
        self.backend_server_port = backend_server_port
        # The name of the listener. The value must be **1** to **80** characters in length.
        # 
        # >  The value cannot start with `http://` or `https://`.
        self.description = description
        # The listener port that is used to redirect HTTP requests to HTTPS.
        self.forward_port = forward_port
        # Specifies whether to enable the health check feature. Valid values:
        # 
        # *   **on**\
        # *   **off** (default)
        # 
        # This parameter is required.
        self.health_check = health_check
        # The backend port that is used for health checks. Valid values: **1** to **65535**.
        # 
        # >  This parameter takes effect only if you set HealthCheck to on.
        self.health_check_connect_port = health_check_connect_port
        # The domain name that you want to use for health checks.
        # 
        # >  This parameter takes effect only if you set HealthCheck to on.
        self.health_check_domain = health_check_domain
        # The HTTP status code for a successful health check. Valid values:
        # 
        # *   **http_2xx** (default)
        # *   **http_3xx**\
        # *   **http_4xx**\
        # *   **http_5xx**\
        # 
        # >  This parameter takes effect only if you set HealthCheck to on.
        self.health_check_http_code = health_check_http_code
        # The interval at which health checks are performed. Valid values: **1** to **50**. Default value: **2**. Unit: seconds.
        # 
        # >  This parameter takes effect only if you set HealthCheck to on.
        self.health_check_interval = health_check_interval
        # The HTTP request method for health checks. Valid values:
        # 
        # *   **head** (default)
        # *   **get**\
        # 
        # >  This parameter takes effect only if the HealthCheck parameter is set to on.
        self.health_check_method = health_check_method
        # The timeout period of a health check response. If a backend server does not respond within the specified timeout period, the server fails the health check.
        # 
        # *   Default value: 5.
        # *   Valid values: **1** to **300**.
        # *   Unit: seconds.
        # 
        # > 
        # 
        # *   This parameter takes effect only if the HealthCheck parameter is set to on.
        # 
        # *   If the value of HealthCheckTimeout is smaller than the value of HealthCheckInterval, the timeout period specified by HealthCheckTimeout becomes invalid, and the value of HealthCheckInterval is used as the timeout period.
        self.health_check_timeout = health_check_timeout
        # The URI used for health checks. The URI must be **1** to **80** characters in length.
        # 
        # > 
        # 
        # *   A URL must start with a forward slash (`/`) but cannot contain only forward slashes (`/`).
        # 
        # *   This parameter takes effect only if the HealthCheck parameter is set to on.
        self.health_check_uri = health_check_uri
        # The number of consecutive successful health checks that must occur before an unhealthy and inaccessible backend server is declared healthy and accessible. Valid values: **2** to **10**. Default value: **3**.
        # 
        # >  This parameter takes effect only if you set HealthCheck to on.
        self.healthy_threshold = healthy_threshold
        # The timeout period for idle connections. Default value: 15. Valid values: **1** to **60**. Unit: seconds.
        # 
        # >  If no request is received within the specified timeout period, ELB closes the connection. When a request is received, ELB creates a new connection.
        self.idle_timeout = idle_timeout
        # Specifies whether to enable redirection from HTTP to HTTPS. Valid values:
        # 
        # *   **on**\
        # *   **off** (default)
        self.listener_forward = listener_forward
        # The listener port that is used by Edge Load Balancer (ELB) to receive requests and forward the requests to backend servers. Valid values: **1** to **65535**.
        # 
        # >  We recommend that you use port 80 for HTTP.
        # 
        # This parameter is required.
        self.listener_port = listener_port
        # The ID of the Edge Load Balancer (ELB) instance.
        # 
        # This parameter is required.
        self.load_balancer_id = load_balancer_id
        # The timeout period of a request. Default value: 60. Valid values: **1** to **180**. Unit: seconds.
        # 
        # >  If no response is received from the backend server within the specified timeout period, ALB returns an HTTP 504 error code to the client.
        self.request_timeout = request_timeout
        # The scheduling algorithm. Valid values:
        # 
        # *   **wrr** (default): Backend servers with higher weights receive more requests than backend servers with lower weights.
        # *   **wlc**: Requests are distributed based on the weights and number of connections to backend servers. If two backend servers have the same weight, the backend server that has fewer connections receives more requests.
        # *   **rr**: Requests are distributed to backend servers in sequence.
        # *   **sch**: consistent hashing based on source IP addresses. Requests from the same source IP address are distributed to the same backend server.
        # *   **qch**: consistent hashing based on QUIC connection IDs (CIDs). Requests that contain the same QUIC CID are distributed to the same backend server.
        # *   **iqch**: consistent hashing based on three specific bytes of iQUIC CIDs. Requests with the same second, third, and fourth bytes are distributed to the same backend server.
        self.scheduler = scheduler
        # The number of consecutive failed health checks that must occur before a healthy and accessible backend server is declared unhealthy and inaccessible. Valid values: **2** to **10**. Default value: **3**.
        # 
        # >  This parameter takes effect only if you set HealthCheck to on.
        self.unhealthy_threshold = unhealthy_threshold
        # Specifies whether to use the X-Forwarded-For header to obtain the real IP address of the client. Valid values:
        # 
        # *   **on**\
        # *   **off** (default)
        self.xforwarded_for = xforwarded_for

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backend_server_port is not None:
            result['BackendServerPort'] = self.backend_server_port
        if self.description is not None:
            result['Description'] = self.description
        if self.forward_port is not None:
            result['ForwardPort'] = self.forward_port
        if self.health_check is not None:
            result['HealthCheck'] = self.health_check
        if self.health_check_connect_port is not None:
            result['HealthCheckConnectPort'] = self.health_check_connect_port
        if self.health_check_domain is not None:
            result['HealthCheckDomain'] = self.health_check_domain
        if self.health_check_http_code is not None:
            result['HealthCheckHttpCode'] = self.health_check_http_code
        if self.health_check_interval is not None:
            result['HealthCheckInterval'] = self.health_check_interval
        if self.health_check_method is not None:
            result['HealthCheckMethod'] = self.health_check_method
        if self.health_check_timeout is not None:
            result['HealthCheckTimeout'] = self.health_check_timeout
        if self.health_check_uri is not None:
            result['HealthCheckURI'] = self.health_check_uri
        if self.healthy_threshold is not None:
            result['HealthyThreshold'] = self.healthy_threshold
        if self.idle_timeout is not None:
            result['IdleTimeout'] = self.idle_timeout
        if self.listener_forward is not None:
            result['ListenerForward'] = self.listener_forward
        if self.listener_port is not None:
            result['ListenerPort'] = self.listener_port
        if self.load_balancer_id is not None:
            result['LoadBalancerId'] = self.load_balancer_id
        if self.request_timeout is not None:
            result['RequestTimeout'] = self.request_timeout
        if self.scheduler is not None:
            result['Scheduler'] = self.scheduler
        if self.unhealthy_threshold is not None:
            result['UnhealthyThreshold'] = self.unhealthy_threshold
        if self.xforwarded_for is not None:
            result['XForwardedFor'] = self.xforwarded_for
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackendServerPort') is not None:
            self.backend_server_port = m.get('BackendServerPort')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ForwardPort') is not None:
            self.forward_port = m.get('ForwardPort')
        if m.get('HealthCheck') is not None:
            self.health_check = m.get('HealthCheck')
        if m.get('HealthCheckConnectPort') is not None:
            self.health_check_connect_port = m.get('HealthCheckConnectPort')
        if m.get('HealthCheckDomain') is not None:
            self.health_check_domain = m.get('HealthCheckDomain')
        if m.get('HealthCheckHttpCode') is not None:
            self.health_check_http_code = m.get('HealthCheckHttpCode')
        if m.get('HealthCheckInterval') is not None:
            self.health_check_interval = m.get('HealthCheckInterval')
        if m.get('HealthCheckMethod') is not None:
            self.health_check_method = m.get('HealthCheckMethod')
        if m.get('HealthCheckTimeout') is not None:
            self.health_check_timeout = m.get('HealthCheckTimeout')
        if m.get('HealthCheckURI') is not None:
            self.health_check_uri = m.get('HealthCheckURI')
        if m.get('HealthyThreshold') is not None:
            self.healthy_threshold = m.get('HealthyThreshold')
        if m.get('IdleTimeout') is not None:
            self.idle_timeout = m.get('IdleTimeout')
        if m.get('ListenerForward') is not None:
            self.listener_forward = m.get('ListenerForward')
        if m.get('ListenerPort') is not None:
            self.listener_port = m.get('ListenerPort')
        if m.get('LoadBalancerId') is not None:
            self.load_balancer_id = m.get('LoadBalancerId')
        if m.get('RequestTimeout') is not None:
            self.request_timeout = m.get('RequestTimeout')
        if m.get('Scheduler') is not None:
            self.scheduler = m.get('Scheduler')
        if m.get('UnhealthyThreshold') is not None:
            self.unhealthy_threshold = m.get('UnhealthyThreshold')
        if m.get('XForwardedFor') is not None:
            self.xforwarded_for = m.get('XForwardedFor')
        return self


class CreateLoadBalancerHTTPListenerResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLoadBalancerHTTPListenerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateLoadBalancerHTTPListenerResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLoadBalancerHTTPListenerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLoadBalancerHTTPSListenerRequest(TeaModel):
    def __init__(
        self,
        backend_server_port: int = None,
        cookie: str = None,
        cookie_timeout: int = None,
        description: str = None,
        forward_port: int = None,
        health_check: str = None,
        health_check_connect_port: int = None,
        health_check_domain: str = None,
        health_check_http_code: str = None,
        health_check_interval: int = None,
        health_check_method: str = None,
        health_check_timeout: int = None,
        health_check_uri: str = None,
        healthy_threshold: int = None,
        idle_timeout: int = None,
        listener_forward: str = None,
        listener_port: int = None,
        load_balancer_id: str = None,
        request_timeout: int = None,
        scheduler: str = None,
        server_certificate_id: str = None,
        sticky_session_type: str = None,
        unhealthy_threshold: int = None,
    ):
        # The backend port that is used by the ELB instance. Valid values: **1** to **65535**.
        self.backend_server_port = backend_server_port
        # The cookie that is configured on the server. The cookie must be **1** to **200** characters in length and contain only ASCII characters and digits.
        # 
        # >  This parameter is required if you set StickySession to on and StickySessionType to server.
        self.cookie = cookie
        # The timeout period of a cookie. Valid values: **1** to **86400**. Unit: seconds.
        # 
        # >  This parameter is required if you set StickySession to on and StickySessionType to insert.
        self.cookie_timeout = cookie_timeout
        # The description of the listener. The description must be **1** to **80** characters in length.
        # 
        # >  The value cannot start with `http://` or `https://`.
        self.description = description
        # The listener port that is used to redirect HTTP requests to HTTPS.
        self.forward_port = forward_port
        # Indicates whether the health check feature is enabled. Valid values:
        # 
        # *   **on**\
        # *   **off**\
        # 
        # This parameter is required.
        self.health_check = health_check
        # The port that is used for health checks. Valid values: **1** to **65535**. If you leave this parameter empty, the port specified by BackendServerPort is used for health checks.
        # 
        # >  This parameter takes effect only if you set HealthCheck to on.
        self.health_check_connect_port = health_check_connect_port
        # The domain name that you want to use for health checks.
        # 
        # >  This parameter takes effect only if you set HealthCheck to on.
        self.health_check_domain = health_check_domain
        # The HTTP status code for a successful health check. Valid values:
        # 
        # *   **http_2xx** (default)
        # *   **http_3xx**\
        # *   **http_4xx**\
        # *   **http_5xx**\
        # 
        # >  This parameter takes effect only if you set HealthCheck to on.
        self.health_check_http_code = health_check_http_code
        # The interval at which health checks are performed. Valid values: **1** to **50**. Default value: **2**. Unit: seconds.
        # 
        # >  This parameter takes effect only if you set HealthCheck to on.
        self.health_check_interval = health_check_interval
        # The HTTP request method for health checks. Valid values:
        # 
        # *   **head** (default): requests the head of the page.
        # *   **get**: requests the specified part of the page and returns the entity body.
        # 
        # >  This parameter takes effect only if the HealthCheck parameter is set to on.
        self.health_check_method = health_check_method
        # The timeout period of a health check response. If a backend server does not respond within the specified timeout period, the server fails to pass the health check.
        # 
        # *   Default value: 5.
        # *   Valid values: **1** to **300**.
        # *   Unit: seconds.
        # 
        # > 
        # 
        # *   This parameter takes effect only if the HealthCheck parameter is set to on.
        # 
        # *   If the value of HealthCheckTimeout is smaller than the value of HealthCheckInterval, the timeout period specified by HealthCheckTimeout becomes invalid, and the value of HealthCheckInterval is used as the timeout period.
        self.health_check_timeout = health_check_timeout
        # The URI used for health checks. The URI must be **1** to **80** characters in length.
        # 
        # >  A URL must start with a forward slash (`/`) but cannot contain only forward slashes (`/`).
        self.health_check_uri = health_check_uri
        # The number of consecutive successful health checks that must occur before an unhealthy and inaccessible backend server is declared healthy and accessible. Valid values: **2** to **10**. Default value: **3**.
        # 
        # >  This parameter takes effect only if you set HealthCheck to on.
        self.healthy_threshold = healthy_threshold
        # The timeout period for idle connections. Default value: 15. Valid values: **1** to **60**. Unit: seconds.
        # 
        # >  If no request is received within the specified timeout period, ELB closes the connection. When another request is received, ELB establishes a new connection.
        self.idle_timeout = idle_timeout
        # Specifies whether to enable redirection from HTTP to HTTPS. Valid values:
        # 
        # *   **on**\
        # *   **off** (default)
        self.listener_forward = listener_forward
        # The listening port that is used by Edge Load Balancer (ELB) to receive requests and forward the requests to backend servers. Valid values: **1** to **65535**.
        # 
        # >  We recommend that you use port 443 for HTTPS.
        # 
        # This parameter is required.
        self.listener_port = listener_port
        # The ID of the Edge Load Balancer (ELB) instance.
        # 
        # This parameter is required.
        self.load_balancer_id = load_balancer_id
        # The timeout period of requests. Default value: 60. Valid values: **1** to **180**. Unit: seconds.
        # 
        # >  If no response is received from the backend server within the specified timeout period, ELB returns an HTTP 504 error code to the client.
        self.request_timeout = request_timeout
        # The scheduling algorithm. Valid values:
        # 
        # *   **wrr** (default): Backend servers with higher weights receive more requests than backend servers with lower weights.
        # *   **wlc**: Requests are distributed based on the weight and load of each backend server. The load refers to the number of connections on a backend server. If two backend servers have the same weight, the backend server that has fewer connections receives more requests.
        # *   **rr**: Requests are distributed to backend servers in sequence.
        # *   **sch**: consistent hashing based on source IP addresses. Requests from the same source IP address are distributed to the same backend server.
        # *   **qch**: consistent hashing based on QUIC connection IDs (CIDs). Requests that contain the same QUIC CID are distributed to the same backend server.
        # *   **iqch**: consistent hashing based on three specific bytes of iQUIC CIDs. Requests with the same second, third, and fourth bytes are distributed to the same backend server.
        self.scheduler = scheduler
        # The ID of the server certificate.
        # 
        # This parameter is required.
        self.server_certificate_id = server_certificate_id
        # The method that is used to handle cookies. Valid values:
        # 
        # *   **insert**: inserts a cookie. ELB inserts a session cookie (SERVERID) into the first HTTP or HTTPS response that is sent to a client. Subsequent requests to ELB carry this cookie, and ELB determines the destination servers of the requests based on the cookies.
        # *   **server**: rewrites the original cookie. SLB rewrites the custom cookies in requests from a client. Subsequent requests from the client that carry the new cookie are forwarded to the same backend server as the first request.
        # 
        # >  This parameter is required when the StickySession parameter is set to on.
        self.sticky_session_type = sticky_session_type
        # The number of consecutive failed health checks that must occur before a healthy and accessible backend server is declared unhealthy and inaccessible. Valid values: **2** to **10**. Default value: **3**.
        # 
        # >  This parameter takes effect only if you set HealthCheck to on.
        self.unhealthy_threshold = unhealthy_threshold

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backend_server_port is not None:
            result['BackendServerPort'] = self.backend_server_port
        if self.cookie is not None:
            result['Cookie'] = self.cookie
        if self.cookie_timeout is not None:
            result['CookieTimeout'] = self.cookie_timeout
        if self.description is not None:
            result['Description'] = self.description
        if self.forward_port is not None:
            result['ForwardPort'] = self.forward_port
        if self.health_check is not None:
            result['HealthCheck'] = self.health_check
        if self.health_check_connect_port is not None:
            result['HealthCheckConnectPort'] = self.health_check_connect_port
        if self.health_check_domain is not None:
            result['HealthCheckDomain'] = self.health_check_domain
        if self.health_check_http_code is not None:
            result['HealthCheckHttpCode'] = self.health_check_http_code
        if self.health_check_interval is not None:
            result['HealthCheckInterval'] = self.health_check_interval
        if self.health_check_method is not None:
            result['HealthCheckMethod'] = self.health_check_method
        if self.health_check_timeout is not None:
            result['HealthCheckTimeout'] = self.health_check_timeout
        if self.health_check_uri is not None:
            result['HealthCheckURI'] = self.health_check_uri
        if self.healthy_threshold is not None:
            result['HealthyThreshold'] = self.healthy_threshold
        if self.idle_timeout is not None:
            result['IdleTimeout'] = self.idle_timeout
        if self.listener_forward is not None:
            result['ListenerForward'] = self.listener_forward
        if self.listener_port is not None:
            result['ListenerPort'] = self.listener_port
        if self.load_balancer_id is not None:
            result['LoadBalancerId'] = self.load_balancer_id
        if self.request_timeout is not None:
            result['RequestTimeout'] = self.request_timeout
        if self.scheduler is not None:
            result['Scheduler'] = self.scheduler
        if self.server_certificate_id is not None:
            result['ServerCertificateId'] = self.server_certificate_id
        if self.sticky_session_type is not None:
            result['StickySessionType'] = self.sticky_session_type
        if self.unhealthy_threshold is not None:
            result['UnhealthyThreshold'] = self.unhealthy_threshold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackendServerPort') is not None:
            self.backend_server_port = m.get('BackendServerPort')
        if m.get('Cookie') is not None:
            self.cookie = m.get('Cookie')
        if m.get('CookieTimeout') is not None:
            self.cookie_timeout = m.get('CookieTimeout')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ForwardPort') is not None:
            self.forward_port = m.get('ForwardPort')
        if m.get('HealthCheck') is not None:
            self.health_check = m.get('HealthCheck')
        if m.get('HealthCheckConnectPort') is not None:
            self.health_check_connect_port = m.get('HealthCheckConnectPort')
        if m.get('HealthCheckDomain') is not None:
            self.health_check_domain = m.get('HealthCheckDomain')
        if m.get('HealthCheckHttpCode') is not None:
            self.health_check_http_code = m.get('HealthCheckHttpCode')
        if m.get('HealthCheckInterval') is not None:
            self.health_check_interval = m.get('HealthCheckInterval')
        if m.get('HealthCheckMethod') is not None:
            self.health_check_method = m.get('HealthCheckMethod')
        if m.get('HealthCheckTimeout') is not None:
            self.health_check_timeout = m.get('HealthCheckTimeout')
        if m.get('HealthCheckURI') is not None:
            self.health_check_uri = m.get('HealthCheckURI')
        if m.get('HealthyThreshold') is not None:
            self.healthy_threshold = m.get('HealthyThreshold')
        if m.get('IdleTimeout') is not None:
            self.idle_timeout = m.get('IdleTimeout')
        if m.get('ListenerForward') is not None:
            self.listener_forward = m.get('ListenerForward')
        if m.get('ListenerPort') is not None:
            self.listener_port = m.get('ListenerPort')
        if m.get('LoadBalancerId') is not None:
            self.load_balancer_id = m.get('LoadBalancerId')
        if m.get('RequestTimeout') is not None:
            self.request_timeout = m.get('RequestTimeout')
        if m.get('Scheduler') is not None:
            self.scheduler = m.get('Scheduler')
        if m.get('ServerCertificateId') is not None:
            self.server_certificate_id = m.get('ServerCertificateId')
        if m.get('StickySessionType') is not None:
            self.sticky_session_type = m.get('StickySessionType')
        if m.get('UnhealthyThreshold') is not None:
            self.unhealthy_threshold = m.get('UnhealthyThreshold')
        return self


class CreateLoadBalancerHTTPSListenerResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLoadBalancerHTTPSListenerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateLoadBalancerHTTPSListenerResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLoadBalancerHTTPSListenerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLoadBalancerTCPListenerRequest(TeaModel):
    def __init__(
        self,
        backend_server_port: int = None,
        description: str = None,
        eip_transmit: str = None,
        established_timeout: int = None,
        health_check_connect_port: int = None,
        health_check_connect_timeout: int = None,
        health_check_domain: str = None,
        health_check_http_code: str = None,
        health_check_interval: int = None,
        health_check_type: str = None,
        health_check_uri: str = None,
        healthy_threshold: int = None,
        listener_port: int = None,
        load_balancer_id: str = None,
        persistence_timeout: int = None,
        scheduler: str = None,
        unhealthy_threshold: int = None,
    ):
        # The port used by the backend ELB server of the ELB instance. Valid values: **1** to **65535**.
        self.backend_server_port = backend_server_port
        # The name of the listener. The value must be **1** to **80** characters in length.
        # 
        # >  The value cannot start with `http://` or `https://`.
        self.description = description
        # Specifies whether to enable elastic IP address (EIP) pass-through. Valid values:
        # 
        # *   **on**\
        # *   **off** (default)
        self.eip_transmit = eip_transmit
        # The timeout period of a connection. Valid values: **10** to **900**. Default value: **900**. Unit: seconds.
        self.established_timeout = established_timeout
        # The port that is used for health checks. Valid values: **1** to **65535**. If you leave this parameter empty, the port specified for BackendServerPort is used for health checks.
        self.health_check_connect_port = health_check_connect_port
        # The timeout period of a health check response. If a backend server does not respond within the specified timeout period, the server fails the health check.
        # 
        # *   Default value: 5.
        # *   Valid values: **1** to **300**.
        # *   Unit: seconds.
        # 
        # >  If the value of the HealthCheckConnectTimeout parameter is smaller than that of the HealthCheckInterval parameter, the timeout period specified by the HealthCheckConnectTimeout parameter is ignored and the period of time specified by the HealthCheckInterval parameter is used as the timeout period.
        self.health_check_connect_timeout = health_check_connect_timeout
        # The domain name that you want to use for health checks.
        self.health_check_domain = health_check_domain
        # The HTTP status codes for a successful health check. Valid values:
        # 
        # *   **http_2xx** (default)
        # *   **http_3xx**.
        # *   **http_4xx**\
        # *   **http_5xx**\
        self.health_check_http_code = health_check_http_code
        # The interval at which health checks are performed. Valid values: **1** to **50**. Default value: **2**. Unit: seconds.
        self.health_check_interval = health_check_interval
        # The type of health checks. Valid values:
        # 
        # *   **tcp** (default)
        # *   **http**\
        self.health_check_type = health_check_type
        # The Uniform Resource Identifier (URI) that you want to use for health checks. The URI must be **1** to **80** characters in length.
        # 
        # >  The URL must start with `/` and contain characters other than `/`.
        self.health_check_uri = health_check_uri
        # The number of consecutive successful health checks that must occur before an unhealthy and inaccessible backend server is declared healthy and accessible. Valid values: **2** to **10**. Default value: **3**.
        self.healthy_threshold = healthy_threshold
        # The listener port that is used by Edge Load Balancer (ELB) to receive requests and forward the requests to backend servers. Valid values: **1** to **65535**.
        # 
        # This parameter is required.
        self.listener_port = listener_port
        # The ID of the Edge Load Balancer (ELB) instance.
        # 
        # This parameter is required.
        self.load_balancer_id = load_balancer_id
        # The timeout period of session persistence.
        # 
        # *   Default value: 0. If the default value is used, the system disables session persistence.
        # *   Valid values: **0** to **3600**.
        # *   Unit: seconds.
        self.persistence_timeout = persistence_timeout
        # The scheduling algorithm. Valid values:
        # 
        # *   **wrr** (default): Backend servers with higher weights receive more requests than backend servers with lower weights.
        # *   **wlc**: Requests are distributed based on the weights and number of connections to backend servers. If two backend servers have the same weight, the backend server that has fewer connections receives more requests.
        # *   **rr**: Requests are distributed to backend servers in sequence.
        # *   **sch**: consistent hashing based on source IP addresses. Requests from the same source IP address are distributed to the same backend server.
        # *   **qch**: consistent hashing based on QUIC connection IDs (CIDs). Requests that contain the same QUIC CID are distributed to the same backend server.
        # *   **iqch**: consistent hashing based on three specific bytes of iQUIC CIDs. Requests with the same second, third, and fourth bytes are distributed to the same backend server.
        self.scheduler = scheduler
        # The number of consecutive failed health checks that must occur before a healthy and accessible backend server is declared unhealthy and inaccessible. Valid values: **2** to **10**. Default value: **3**.
        self.unhealthy_threshold = unhealthy_threshold

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backend_server_port is not None:
            result['BackendServerPort'] = self.backend_server_port
        if self.description is not None:
            result['Description'] = self.description
        if self.eip_transmit is not None:
            result['EipTransmit'] = self.eip_transmit
        if self.established_timeout is not None:
            result['EstablishedTimeout'] = self.established_timeout
        if self.health_check_connect_port is not None:
            result['HealthCheckConnectPort'] = self.health_check_connect_port
        if self.health_check_connect_timeout is not None:
            result['HealthCheckConnectTimeout'] = self.health_check_connect_timeout
        if self.health_check_domain is not None:
            result['HealthCheckDomain'] = self.health_check_domain
        if self.health_check_http_code is not None:
            result['HealthCheckHttpCode'] = self.health_check_http_code
        if self.health_check_interval is not None:
            result['HealthCheckInterval'] = self.health_check_interval
        if self.health_check_type is not None:
            result['HealthCheckType'] = self.health_check_type
        if self.health_check_uri is not None:
            result['HealthCheckURI'] = self.health_check_uri
        if self.healthy_threshold is not None:
            result['HealthyThreshold'] = self.healthy_threshold
        if self.listener_port is not None:
            result['ListenerPort'] = self.listener_port
        if self.load_balancer_id is not None:
            result['LoadBalancerId'] = self.load_balancer_id
        if self.persistence_timeout is not None:
            result['PersistenceTimeout'] = self.persistence_timeout
        if self.scheduler is not None:
            result['Scheduler'] = self.scheduler
        if self.unhealthy_threshold is not None:
            result['UnhealthyThreshold'] = self.unhealthy_threshold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackendServerPort') is not None:
            self.backend_server_port = m.get('BackendServerPort')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EipTransmit') is not None:
            self.eip_transmit = m.get('EipTransmit')
        if m.get('EstablishedTimeout') is not None:
            self.established_timeout = m.get('EstablishedTimeout')
        if m.get('HealthCheckConnectPort') is not None:
            self.health_check_connect_port = m.get('HealthCheckConnectPort')
        if m.get('HealthCheckConnectTimeout') is not None:
            self.health_check_connect_timeout = m.get('HealthCheckConnectTimeout')
        if m.get('HealthCheckDomain') is not None:
            self.health_check_domain = m.get('HealthCheckDomain')
        if m.get('HealthCheckHttpCode') is not None:
            self.health_check_http_code = m.get('HealthCheckHttpCode')
        if m.get('HealthCheckInterval') is not None:
            self.health_check_interval = m.get('HealthCheckInterval')
        if m.get('HealthCheckType') is not None:
            self.health_check_type = m.get('HealthCheckType')
        if m.get('HealthCheckURI') is not None:
            self.health_check_uri = m.get('HealthCheckURI')
        if m.get('HealthyThreshold') is not None:
            self.healthy_threshold = m.get('HealthyThreshold')
        if m.get('ListenerPort') is not None:
            self.listener_port = m.get('ListenerPort')
        if m.get('LoadBalancerId') is not None:
            self.load_balancer_id = m.get('LoadBalancerId')
        if m.get('PersistenceTimeout') is not None:
            self.persistence_timeout = m.get('PersistenceTimeout')
        if m.get('Scheduler') is not None:
            self.scheduler = m.get('Scheduler')
        if m.get('UnhealthyThreshold') is not None:
            self.unhealthy_threshold = m.get('UnhealthyThreshold')
        return self


class CreateLoadBalancerTCPListenerResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLoadBalancerTCPListenerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateLoadBalancerTCPListenerResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLoadBalancerTCPListenerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLoadBalancerUDPListenerRequest(TeaModel):
    def __init__(
        self,
        backend_server_port: int = None,
        description: str = None,
        eip_transmit: str = None,
        established_timeout: int = None,
        health_check_connect_port: int = None,
        health_check_connect_timeout: int = None,
        health_check_exp: str = None,
        health_check_interval: int = None,
        health_check_req: str = None,
        healthy_threshold: int = None,
        listener_port: int = None,
        load_balancer_id: str = None,
        scheduler: str = None,
        unhealthy_threshold: int = None,
    ):
        # The port used by the backend ELB server of the ELB instance. Valid values: **1** to **65535**.
        self.backend_server_port = backend_server_port
        # The name of the listener. The value must be **1** to **80** characters in length.
        # 
        # >  The value cannot start with `http://` or `https://`.
        self.description = description
        # Specifies whether to enable Elastic IP address (EIP) pass-through. Valid values:
        # 
        # *   **on**\
        # *   **off** (default)
        self.eip_transmit = eip_transmit
        # The timeout period of a connection. Valid values: **10** to **900**. Default value: **900**. Unit: seconds.
        self.established_timeout = established_timeout
        # The port that is used for health checks. Valid values: **1** to **65535**. If you leave this parameter empty, the port specified by BackendServerPort is used for health checks.
        self.health_check_connect_port = health_check_connect_port
        # The timeout period for a health check response. If a backend server does not respond within the specified timeout period, the server fails the health check.
        # 
        # *   Default value: 5.
        # *   Valid values: **1** to **300**.
        # *   Unit: seconds.
        # 
        # >  If the value of the HealthCheckConnectTimeout parameter is smaller than that of the HealthCheckInterval parameter, the timeout period specified by the HealthCheckConnectTimeout parameter becomes invalid and the value of the HealthCheckInterval parameter is used as the timeout period.
        self.health_check_connect_timeout = health_check_connect_timeout
        # The response string for UDP listener health checks. The string can be up to 64 characters in length and can contain only letters and digits.
        self.health_check_exp = health_check_exp
        # The interval at which health checks are performed. Valid values: **1** to **50**. Default value: **2**. Unit: seconds.
        self.health_check_interval = health_check_interval
        # The request string for UDP listener health checks. The string can be up to 64 characters in length and can contain only letters and digits.
        self.health_check_req = health_check_req
        # The number of consecutive successful health checks that must occur before an unhealthy and inaccessible backend server is declared healthy and accessible. Valid values: **2** to **10**. Default value: **3**.
        self.healthy_threshold = healthy_threshold
        # The listener port that is used by Edge Load Balancer (ELB) to receive requests and forward the requests to backend servers. Valid values: **1** to **65535**.
        # 
        # >  You cannot specify ports 250, 4789, or 4790 for UDP listeners. They are system reserved ports.
        # 
        # This parameter is required.
        self.listener_port = listener_port
        # The ID of the Edge Load Balancer (ELB) instance.
        # 
        # This parameter is required.
        self.load_balancer_id = load_balancer_id
        # The scheduling algorithm. Valid values:
        # 
        # *   **wrr**: Backend servers with higher weights receive more requests than backend servers with lower weights. This is the default value.
        # *   **wlc**: Requests are distributed based on the weight and load of each backend server. The load refers to the number of connections on a backend server. If two backend servers have the same weight, the backend server that has fewer connections receives more requests.
        # *   **rr**: Requests are distributed to backend servers in sequence.
        # *   **sch**: Consistent hashing that is based on source IP addresses. Requests from the same source IP address are distributed to the same backend server.
        # *   **qch**: Consistent hashing based on Quick UDP Internet Connection (QUIC) IDs. Requests that contain the same QUIC ID are scheduled to the same backend server.
        # *   **iqch**: Consistent hashing based on three specific bytes of iQUIC CID. Requests with the same second, third, and forth bytes are scheduled to the same backend server.
        self.scheduler = scheduler
        # The number of consecutive failed health checks that must occur before a healthy and accessible backend server is declared unhealthy and inaccessible. Valid values: **2** to **10**. Default value: **3**.
        self.unhealthy_threshold = unhealthy_threshold

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backend_server_port is not None:
            result['BackendServerPort'] = self.backend_server_port
        if self.description is not None:
            result['Description'] = self.description
        if self.eip_transmit is not None:
            result['EipTransmit'] = self.eip_transmit
        if self.established_timeout is not None:
            result['EstablishedTimeout'] = self.established_timeout
        if self.health_check_connect_port is not None:
            result['HealthCheckConnectPort'] = self.health_check_connect_port
        if self.health_check_connect_timeout is not None:
            result['HealthCheckConnectTimeout'] = self.health_check_connect_timeout
        if self.health_check_exp is not None:
            result['HealthCheckExp'] = self.health_check_exp
        if self.health_check_interval is not None:
            result['HealthCheckInterval'] = self.health_check_interval
        if self.health_check_req is not None:
            result['HealthCheckReq'] = self.health_check_req
        if self.healthy_threshold is not None:
            result['HealthyThreshold'] = self.healthy_threshold
        if self.listener_port is not None:
            result['ListenerPort'] = self.listener_port
        if self.load_balancer_id is not None:
            result['LoadBalancerId'] = self.load_balancer_id
        if self.scheduler is not None:
            result['Scheduler'] = self.scheduler
        if self.unhealthy_threshold is not None:
            result['UnhealthyThreshold'] = self.unhealthy_threshold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackendServerPort') is not None:
            self.backend_server_port = m.get('BackendServerPort')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EipTransmit') is not None:
            self.eip_transmit = m.get('EipTransmit')
        if m.get('EstablishedTimeout') is not None:
            self.established_timeout = m.get('EstablishedTimeout')
        if m.get('HealthCheckConnectPort') is not None:
            self.health_check_connect_port = m.get('HealthCheckConnectPort')
        if m.get('HealthCheckConnectTimeout') is not None:
            self.health_check_connect_timeout = m.get('HealthCheckConnectTimeout')
        if m.get('HealthCheckExp') is not None:
            self.health_check_exp = m.get('HealthCheckExp')
        if m.get('HealthCheckInterval') is not None:
            self.health_check_interval = m.get('HealthCheckInterval')
        if m.get('HealthCheckReq') is not None:
            self.health_check_req = m.get('HealthCheckReq')
        if m.get('HealthyThreshold') is not None:
            self.healthy_threshold = m.get('HealthyThreshold')
        if m.get('ListenerPort') is not None:
            self.listener_port = m.get('ListenerPort')
        if m.get('LoadBalancerId') is not None:
            self.load_balancer_id = m.get('LoadBalancerId')
        if m.get('Scheduler') is not None:
            self.scheduler = m.get('Scheduler')
        if m.get('UnhealthyThreshold') is not None:
            self.unhealthy_threshold = m.get('UnhealthyThreshold')
        return self


class CreateLoadBalancerUDPListenerResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLoadBalancerUDPListenerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateLoadBalancerUDPListenerResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLoadBalancerUDPListenerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMountTargetRequest(TeaModel):
    def __init__(
        self,
        ens_region_id: str = None,
        file_system_id: str = None,
        mount_target_name: str = None,
        net_work_id: str = None,
    ):
        # The ID of the region.
        # 
        # This parameter is required.
        self.ens_region_id = ens_region_id
        # The ID of the file system.
        # 
        # This parameter is required.
        self.file_system_id = file_system_id
        # The name of the mount target.
        # 
        # This parameter is required.
        self.mount_target_name = mount_target_name
        # The ID of the network.
        # 
        # This parameter is required.
        self.net_work_id = net_work_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.file_system_id is not None:
            result['FileSystemId'] = self.file_system_id
        if self.mount_target_name is not None:
            result['MountTargetName'] = self.mount_target_name
        if self.net_work_id is not None:
            result['NetWorkId'] = self.net_work_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('FileSystemId') is not None:
            self.file_system_id = m.get('FileSystemId')
        if m.get('MountTargetName') is not None:
            self.mount_target_name = m.get('MountTargetName')
        if m.get('NetWorkId') is not None:
            self.net_work_id = m.get('NetWorkId')
        return self


class CreateMountTargetResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        status: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The state of the mount target. Valid values:
        # 
        # *   active
        # *   inactive
        # *   pending
        # *   deleting
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateMountTargetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMountTargetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMountTargetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNatGatewayRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The key of tag N of the instance. Valid values of N: **1** to **20**.
        # 
        # *   The key cannot start with `aliyun`, `acs:`, `http://`, or `https://`.
        # *   The key must be up to 64 characters in length.
        # *   The tag key cannot be an empty string.
        self.key = key
        # The value of tag N that is added to the resource. Valid values of N: 1 to 20. The tag value can be an empty string. The tag value can be up to 128 characters in length. It cannot start with acs: or contain http:// or https://.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateNatGatewayRequest(TeaModel):
    def __init__(
        self,
        ens_region_id: str = None,
        instance_billing_cycle: str = None,
        instance_type: str = None,
        name: str = None,
        network_id: str = None,
        tag: List[CreateNatGatewayRequestTag] = None,
        v_switch_id: str = None,
    ):
        # The ID of the Edge Node Service (ENS) node.
        # 
        # This parameter is required.
        self.ens_region_id = ens_region_id
        self.instance_billing_cycle = instance_billing_cycle
        # The instance type of the NAT gateway. Set the value to **enat.default**.
        self.instance_type = instance_type
        # The name of the NAT gateway. The name must be 1 to 128 characters in length. The name cannot start with `http://` or `https://`.
        self.name = name
        # The ID of the network.
        # 
        # This parameter is required.
        self.network_id = network_id
        # The tags.
        self.tag = tag
        # The ID of the new vSwitch.
        self.v_switch_id = v_switch_id

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.instance_billing_cycle is not None:
            result['InstanceBillingCycle'] = self.instance_billing_cycle
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.name is not None:
            result['Name'] = self.name
        if self.network_id is not None:
            result['NetworkId'] = self.network_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('InstanceBillingCycle') is not None:
            self.instance_billing_cycle = m.get('InstanceBillingCycle')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NetworkId') is not None:
            self.network_id = m.get('NetworkId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateNatGatewayRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class CreateNatGatewayResponseBody(TeaModel):
    def __init__(
        self,
        nat_gateway_id: str = None,
        request_id: str = None,
    ):
        # The ID of the NAT gateway.
        self.nat_gateway_id = nat_gateway_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateNatGatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateNatGatewayResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateNatGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNetworkRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The key of the tag that are to add to the instance. Valid values of N: **1** to **20**.
        # 
        # *   The key cannot start with `aliyun`, `acs:`, `http://`, or `https://`.
        # *   The key must be up to 64 characters in length.
        # *   The tag key cannot be an empty string.
        self.key = key
        # The value of tag N that is added to the resource. You can specify up to 20 tag values. The tag value can be an empty string. The tag value can be up to 128 characters in length. It cannot start with acs: or contain http:// or https://.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateNetworkRequest(TeaModel):
    def __init__(
        self,
        cidr_block: str = None,
        description: str = None,
        ens_region_id: str = None,
        network_name: str = None,
        tag: List[CreateNetworkRequestTag] = None,
    ):
        # The CIDR block of the network. You can use one of the following CIDR blocks or their subnets as the CIDR block of the network:
        # 
        # *   10.0.0.0/8 (default)
        # *   172.16.0.0/12
        # *   192.168.0.0/16
        # 
        # This parameter is required.
        self.cidr_block = cidr_block
        # The description of the network.
        # 
        # The description must be 2 to 256 characters in length. It must start with a letter but cannot start with http:// or https://.
        self.description = description
        # The ID of the edge node.
        # 
        # This parameter is required.
        self.ens_region_id = ens_region_id
        # The name of the network. The name must meet the following requirements:
        # 
        # *   The name must be 2 to 128 characters in length.
        # *   The name must start with a letter but cannot start with http:// or https://.
        # *   The name can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        self.network_name = network_name
        # The resource tags.
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.description is not None:
            result['Description'] = self.description
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.network_name is not None:
            result['NetworkName'] = self.network_name
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('NetworkName') is not None:
            self.network_name = m.get('NetworkName')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateNetworkRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateNetworkResponseBody(TeaModel):
    def __init__(
        self,
        network_id: str = None,
        request_id: str = None,
    ):
        # The ID of the network.
        self.network_id = network_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_id is not None:
            result['NetworkId'] = self.network_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkId') is not None:
            self.network_id = m.get('NetworkId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateNetworkResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateNetworkResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateNetworkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNetworkAclRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        network_acl_name: str = None,
    ):
        # The description of the network ACL.
        # 
        # The description must be 1 to 256 characters in length and cannot start with http:// or https://.
        self.description = description
        # Enter a name for the network ACL.
        # 
        # The name must be 1 to 128 characters in length and cannot start with http:// or https://.
        self.network_acl_name = network_acl_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.network_acl_name is not None:
            result['NetworkAclName'] = self.network_acl_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('NetworkAclName') is not None:
            self.network_acl_name = m.get('NetworkAclName')
        return self


class CreateNetworkAclResponseBody(TeaModel):
    def __init__(
        self,
        network_acl_id: str = None,
        request_id: str = None,
    ):
        # The ID of the network ACL.
        self.network_acl_id = network_acl_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_acl_id is not None:
            result['NetworkAclId'] = self.network_acl_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkAclId') is not None:
            self.network_acl_id = m.get('NetworkAclId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateNetworkAclResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateNetworkAclResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateNetworkAclResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNetworkAclEntryRequest(TeaModel):
    def __init__(
        self,
        cidr_block: str = None,
        description: str = None,
        destination_cidr_block: str = None,
        direction: str = None,
        network_acl_entry_name: str = None,
        network_acl_id: str = None,
        policy: str = None,
        port_range: str = None,
        priority: int = None,
        protocol: str = None,
    ):
        # The source CIDR block.
        # 
        # This parameter is required.
        self.cidr_block = cidr_block
        # The description of the network ACL.
        # 
        # The description must be 1 to 256 characters in length and cannot start with http:// or https://.
        self.description = description
        self.destination_cidr_block = destination_cidr_block
        # The direction in which the rule is applied. Valid values:
        # 
        # *   **ingress**\
        # *   **egress**\
        # 
        # This parameter is required.
        self.direction = direction
        # The name of the rule.
        # 
        # The name must be 1 to 128 characters in length and cannot start with http:// or https://.
        self.network_acl_entry_name = network_acl_entry_name
        # The ID of the network ACL.
        # 
        # This parameter is required.
        self.network_acl_id = network_acl_id
        # The action that is performed on network traffic that matches the rule. Valid values:
        # 
        # *   **accept**: allows network traffic.
        # *   **drop**: blocks network traffic.
        # 
        # This parameter is required.
        self.policy = policy
        # The port range.
        # 
        # *   If you set **Protocol** to **all** or **icmp**, set this parameter to -1/-1, which specifies all ports.
        # *   If you set **Protocol** to **tcp** or **udp**, the port can be **1 to 65535**. You can set this parameter to **1/200** or **80/80**, which specifies ports 1 to 200 or port 80.
        # 
        # This parameter is required.
        self.port_range = port_range
        # The priority of the rule. Valid values: **1 to 100**. Default value: **1**.
        # 
        # This parameter is required.
        self.priority = priority
        # The type of the protocol. Valid values:
        # 
        # *   **icmp**: ICMP
        # *   **tcp**: TCP
        # *   **udp**: UDP
        # *   **all**: all protocols
        # 
        # This parameter is required.
        self.protocol = protocol

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.description is not None:
            result['Description'] = self.description
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.network_acl_entry_name is not None:
            result['NetworkAclEntryName'] = self.network_acl_entry_name
        if self.network_acl_id is not None:
            result['NetworkAclId'] = self.network_acl_id
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('NetworkAclEntryName') is not None:
            self.network_acl_entry_name = m.get('NetworkAclEntryName')
        if m.get('NetworkAclId') is not None:
            self.network_acl_id = m.get('NetworkAclId')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PortRange') is not None:
            self.port_range = m.get('PortRange')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        return self


class CreateNetworkAclEntryResponseBody(TeaModel):
    def __init__(
        self,
        network_acl_entry_id: str = None,
        request_id: str = None,
    ):
        # The ID of the network ACL.
        self.network_acl_entry_id = network_acl_entry_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_acl_entry_id is not None:
            result['NetworkAclEntryId'] = self.network_acl_entry_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkAclEntryId') is not None:
            self.network_acl_entry_id = m.get('NetworkAclEntryId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateNetworkAclEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateNetworkAclEntryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateNetworkAclEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNetworkInterfaceRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        security_group_ids: List[str] = None,
        v_switch_id: str = None,
    ):
        # Description of the ENI.
        self.description = description
        # ENI name.
        self.name = name
        # Security group ID.
        # 
        # This parameter is required.
        self.security_group_ids = security_group_ids
        # vSwitch ID.
        self.v_switch_id = v_switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SecurityGroupIds') is not None:
            self.security_group_ids = m.get('SecurityGroupIds')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class CreateNetworkInterfaceShrinkRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        security_group_ids_shrink: str = None,
        v_switch_id: str = None,
    ):
        # Description of the ENI.
        self.description = description
        # ENI name.
        self.name = name
        # Security group ID.
        # 
        # This parameter is required.
        self.security_group_ids_shrink = security_group_ids_shrink
        # vSwitch ID.
        self.v_switch_id = v_switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.security_group_ids_shrink is not None:
            result['SecurityGroupIds'] = self.security_group_ids_shrink
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SecurityGroupIds') is not None:
            self.security_group_ids_shrink = m.get('SecurityGroupIds')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class CreateNetworkInterfaceResponseBody(TeaModel):
    def __init__(
        self,
        network_interface_ids: List[str] = None,
        request_id: str = None,
    ):
        # A list of ENI IDs.
        self.network_interface_ids = network_interface_ids
        # Request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_interface_ids is not None:
            result['NetworkInterfaceIds'] = self.network_interface_ids
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkInterfaceIds') is not None:
            self.network_interface_ids = m.get('NetworkInterfaceIds')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateNetworkInterfaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateNetworkInterfaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateNetworkInterfaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSDGRequest(TeaModel):
    def __init__(
        self,
        billing_cycle: str = None,
        description: str = None,
        disk_type: str = None,
        from_sdgid: str = None,
        instance_id: str = None,
        performance_level: int = None,
        size: str = None,
    ):
        self.billing_cycle = billing_cycle
        # The description of the SDG.
        # 
        # >  We recommend that you specify this parameter in details for subsequent queries.
        self.description = description
        self.disk_type = disk_type
        # The ID of the SDG from which you want to create an SDG.
        # 
        # > 
        # 
        # *   The first time you create an SDG, the **FromSDGId** parameter is empty.
        # 
        # *   If the value of the **FromSDGId** parameter is invalid or does not correspond to an original disk, an error is reported.
        # 
        # *   If the value of the **FromSDGId** parameter is not empty, you have created an SDG, and the operation is performed on the existing SDG.
        self.from_sdgid = from_sdgid
        # The ID of the AIC instance. You can call the [DescribeARMServerInstances](~~DescribeARMServerInstances~~) operation to query the ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        self.performance_level = performance_level
        # The maximum capacity of the SDG. Unit: GB.
        # 
        # > 
        # 
        # *   To save costs, we recommend that you specify this parameter based on your business requirements.
        # 
        # *   The first time that you create an SDG, the **Size** parameter is required.
        # 
        # *   When the amount of data increases, you can pass a new **Size** parameter for resizing. If the value of the new **Size** parameter is greater than the value of the old **Size** parameter, the disk size of the SDG is increased to the size that is specified by the new **Size** parameter. If the value of the new **Size** parameter is empty or smaller than that of the old **Size** parameter, no operation is performed.
        self.size = size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.billing_cycle is not None:
            result['BillingCycle'] = self.billing_cycle
        if self.description is not None:
            result['Description'] = self.description
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.from_sdgid is not None:
            result['FromSDGId'] = self.from_sdgid
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BillingCycle') is not None:
            self.billing_cycle = m.get('BillingCycle')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('FromSDGId') is not None:
            self.from_sdgid = m.get('FromSDGId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class CreateSDGResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        sdgid: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The ID of the generated SDG.
        self.sdgid = sdgid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sdgid is not None:
            result['SDGId'] = self.sdgid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SDGId') is not None:
            self.sdgid = m.get('SDGId')
        return self


class CreateSDGResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSDGResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSDGResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSecurityGroupRequestPermissions(TeaModel):
    def __init__(
        self,
        description: str = None,
        dest_cidr_ip: str = None,
        direction: str = None,
        ip_protocol: str = None,
        ipv_6dest_cidr_ip: str = None,
        ipv_6source_cidr_ip: str = None,
        policy: str = None,
        port_range: str = None,
        priority: int = None,
        source_cidr_ip: str = None,
        source_port_range: str = None,
    ):
        # The description. It must be 2 to 256 characters in length and cannot start with http:// or https://.
        self.description = description
        # The destination IPv4 CIDR block. IPv4 CIDR blocks and IPv4 addresses are supported.
        self.dest_cidr_ip = dest_cidr_ip
        # The direction in which the security group rule is applied.
        # 
        # *   egress
        # *   ingress
        # 
        # This parameter is required.
        self.direction = direction
        # The protocol type. Valid values:
        # 
        # *   TCP
        # *   UDP
        # *   ICMP
        # *   ALL: All protocols are supported.
        # 
        # This parameter is required.
        self.ip_protocol = ip_protocol
        self.ipv_6dest_cidr_ip = ipv_6dest_cidr_ip
        self.ipv_6source_cidr_ip = ipv_6source_cidr_ip
        # The action of the security group rule. Valid values:
        # 
        # *   Accept
        # *   Drop
        # 
        # This parameter is required.
        self.policy = policy
        # The range of destination port numbers for the protocols specified in the security group rule. Valid values:
        # 
        # *   If you set IpProtocol to TCP or UDP, the port number range is 1 to 65535. Specify a port range in the format of \\<Start port number>/\\<End port number>. Example: 1/200.
        # *   If you set IpProtocol to ICMP, the port number range is -1/-1.
        # *   If you set IpProtocol to ALL, the port number range is -1/-1.
        # 
        # This parameter is required.
        self.port_range = port_range
        # The priority of the security group rule. A smaller value specifies a higher priority. Valid values: 1 to 100.
        # 
        # This parameter is required.
        self.priority = priority
        # The source IPv4 CIDR block. IPv4 CIDR blocks and IPv4 addresses are supported.
        self.source_cidr_ip = source_cidr_ip
        # The range of source port numbers for the protocols specified in the security group rule. Valid values:
        # 
        # *   If you set IpProtocol to TCP or UDP, the port number range is 1 to 65535. Specify a port range in the format of \\<Start port number>/\\<End port number>. Example: 1/200.
        # *   If you set IpProtocol to ICMP, the port number range is -1/-1.
        # *   If you set IpProtocol to ALL, the port number range is -1/-1, which indicates all port numbers.
        self.source_port_range = source_port_range

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_cidr_ip is not None:
            result['DestCidrIp'] = self.dest_cidr_ip
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.ipv_6dest_cidr_ip is not None:
            result['Ipv6DestCidrIp'] = self.ipv_6dest_cidr_ip
        if self.ipv_6source_cidr_ip is not None:
            result['Ipv6SourceCidrIp'] = self.ipv_6source_cidr_ip
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.source_cidr_ip is not None:
            result['SourceCidrIp'] = self.source_cidr_ip
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestCidrIp') is not None:
            self.dest_cidr_ip = m.get('DestCidrIp')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('Ipv6DestCidrIp') is not None:
            self.ipv_6dest_cidr_ip = m.get('Ipv6DestCidrIp')
        if m.get('Ipv6SourceCidrIp') is not None:
            self.ipv_6source_cidr_ip = m.get('Ipv6SourceCidrIp')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PortRange') is not None:
            self.port_range = m.get('PortRange')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('SourceCidrIp') is not None:
            self.source_cidr_ip = m.get('SourceCidrIp')
        if m.get('SourcePortRange') is not None:
            self.source_port_range = m.get('SourcePortRange')
        return self


class CreateSecurityGroupRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        permissions: List[CreateSecurityGroupRequestPermissions] = None,
        security_group_name: str = None,
    ):
        # The description. The description must be 2 to 256 characters in length. It must start with a letter but cannot start with http:// or https://.
        self.description = description
        # An array of security group rules. You can specify up to 200 IDs of security group rules.
        self.permissions = permissions
        # The name of the security group. The name must be 2 to 128 characters in length and can contain letters, digits, colons (:), underscores (_), and hyphens (-). It must start with a letter but cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). By default, this parameter is empty.
        self.security_group_name = security_group_name

    def validate(self):
        if self.permissions:
            for k in self.permissions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        result['Permissions'] = []
        if self.permissions is not None:
            for k in self.permissions:
                result['Permissions'].append(k.to_map() if k else None)
        if self.security_group_name is not None:
            result['SecurityGroupName'] = self.security_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        self.permissions = []
        if m.get('Permissions') is not None:
            for k in m.get('Permissions'):
                temp_model = CreateSecurityGroupRequestPermissions()
                self.permissions.append(temp_model.from_map(k))
        if m.get('SecurityGroupName') is not None:
            self.security_group_name = m.get('SecurityGroupName')
        return self


class CreateSecurityGroupShrinkRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        permissions_shrink: str = None,
        security_group_name: str = None,
    ):
        # The description. The description must be 2 to 256 characters in length. It must start with a letter but cannot start with http:// or https://.
        self.description = description
        # An array of security group rules. You can specify up to 200 IDs of security group rules.
        self.permissions_shrink = permissions_shrink
        # The name of the security group. The name must be 2 to 128 characters in length and can contain letters, digits, colons (:), underscores (_), and hyphens (-). It must start with a letter but cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). By default, this parameter is empty.
        self.security_group_name = security_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.permissions_shrink is not None:
            result['Permissions'] = self.permissions_shrink
        if self.security_group_name is not None:
            result['SecurityGroupName'] = self.security_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Permissions') is not None:
            self.permissions_shrink = m.get('Permissions')
        if m.get('SecurityGroupName') is not None:
            self.security_group_name = m.get('SecurityGroupName')
        return self


class CreateSecurityGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        security_group_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The ID of the security group.
        self.security_group_id = security_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        return self


class CreateSecurityGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSecurityGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSecurityGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSnapshotRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        disk_id: str = None,
        ens_region_id: str = None,
        instance_billing_cycle: str = None,
        snapshot_name: str = None,
    ):
        # The description of the snapshot. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
        # 
        # By default, this parameter is left empty.
        self.description = description
        # The ID of the cloud disk.
        # 
        # This parameter is required.
        self.disk_id = disk_id
        # The ID of the edge node.
        # 
        # This parameter is required.
        self.ens_region_id = ens_region_id
        self.instance_billing_cycle = instance_billing_cycle
        # The name of the snapshot. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        self.snapshot_name = snapshot_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.instance_billing_cycle is not None:
            result['InstanceBillingCycle'] = self.instance_billing_cycle
        if self.snapshot_name is not None:
            result['SnapshotName'] = self.snapshot_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('InstanceBillingCycle') is not None:
            self.instance_billing_cycle = m.get('InstanceBillingCycle')
        if m.get('SnapshotName') is not None:
            self.snapshot_name = m.get('SnapshotName')
        return self


class CreateSnapshotResponseBody(TeaModel):
    def __init__(
        self,
        order_id: str = None,
        request_id: str = None,
        snap_shot_id: List[str] = None,
    ):
        # The ID of the order.
        self.order_id = order_id
        # The request ID.
        self.request_id = request_id
        # The IDs of the snapshots.
        self.snap_shot_id = snap_shot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.snap_shot_id is not None:
            result['SnapShotId'] = self.snap_shot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SnapShotId') is not None:
            self.snap_shot_id = m.get('SnapShotId')
        return self


class CreateSnapshotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSnapshotResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSnapshotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSnatEntryRequest(TeaModel):
    def __init__(
        self,
        eip_affinity: bool = None,
        idle_timeout: int = None,
        isp_affinity: bool = None,
        nat_gateway_id: str = None,
        snat_entry_name: str = None,
        snat_ip: str = None,
        source_cidr: str = None,
        source_network_id: str = None,
        source_vswitch_id: str = None,
        standby_snat_ip: str = None,
    ):
        # Specifies whether to enable IP affinity. If you do not specify this parameter, IP affinity is enabled by default. Valid values:
        # 
        # *   **false**\
        # *   **true**\
        # 
        # >  After you enable IP affinity, if multiple EIPs are associated with an SNAT entry, one client uses the same EIP to for communication. If IP affinity is disabled, the client uses a random EIP for communication.
        self.eip_affinity = eip_affinity
        # The timeout period for idle connections. Valid values: **1** to **86400**. Unit: seconds.
        self.idle_timeout = idle_timeout
        # Whether to enable operator affinity. Value taking:
        # 
        # - false:Do not open.
        # - true:Open.
        self.isp_affinity = isp_affinity
        # The ID of the Network Address Translation (NAT) gateway.
        # 
        # This parameter is required.
        self.nat_gateway_id = nat_gateway_id
        # The name of the SNAT entry. The name must be 1 to 128 characters in length. The name cannot start with `http://` or `https://`.
        self.snat_entry_name = snat_entry_name
        # The elastic IP address (EIP) in the SNAT entry. Separate multiple EIPs with commas (,).
        # 
        # This parameter is required.
        self.snat_ip = snat_ip
        # The CIDR block. You can specify the CIDR block of a network, a vSwitch, or an instance. You can also specify a custom CIDR block. All instances within the CIDR block can access the Internet or external networks by using SNAT.
        # 
        # >  If you specify **SourceVSwitchId** and **SourceCIDR**, **SourceVSwitchId** does not take effect. The value that you specified for **SourceCIDR** takes precedence.
        self.source_cidr = source_cidr
        # The ID of the network. This parameter specifies that all ENS instances in the network can use the SNAT entry to access the Internet.
        # 
        # >  If you specify **SourceNetworkId** and **SourceVSwitchId** or **SourceCIDR**, **SourceNetworkId** does not take effect. The value that you specified for **SourceCIDR** takes precedence. Priority: **SourceCIDR** > **SourceVSwitchId** > **SourceNetworkId**.
        self.source_network_id = source_network_id
        # The ID of the vSwitch that you need to access over the Internet. This parameter specifies that Edge Node Service (ENS) instances in the vSwitch can use the SNAT entry to access the Internet.
        # 
        # >  If you specify **SourceVSwitchId** and **SourceCIDR**, **SourceVSwitchId** does not take effect. The value that you specified for **SourceCIDR** takes precedence.
        self.source_vswitch_id = source_vswitch_id
        # The secondary EIP in the SNAT entry. Separate multiple secondary EIPs with commas (,).
        self.standby_snat_ip = standby_snat_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.eip_affinity is not None:
            result['EipAffinity'] = self.eip_affinity
        if self.idle_timeout is not None:
            result['IdleTimeout'] = self.idle_timeout
        if self.isp_affinity is not None:
            result['IspAffinity'] = self.isp_affinity
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.snat_entry_name is not None:
            result['SnatEntryName'] = self.snat_entry_name
        if self.snat_ip is not None:
            result['SnatIp'] = self.snat_ip
        if self.source_cidr is not None:
            result['SourceCIDR'] = self.source_cidr
        if self.source_network_id is not None:
            result['SourceNetworkId'] = self.source_network_id
        if self.source_vswitch_id is not None:
            result['SourceVSwitchId'] = self.source_vswitch_id
        if self.standby_snat_ip is not None:
            result['StandbySnatIp'] = self.standby_snat_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EipAffinity') is not None:
            self.eip_affinity = m.get('EipAffinity')
        if m.get('IdleTimeout') is not None:
            self.idle_timeout = m.get('IdleTimeout')
        if m.get('IspAffinity') is not None:
            self.isp_affinity = m.get('IspAffinity')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('SnatEntryName') is not None:
            self.snat_entry_name = m.get('SnatEntryName')
        if m.get('SnatIp') is not None:
            self.snat_ip = m.get('SnatIp')
        if m.get('SourceCIDR') is not None:
            self.source_cidr = m.get('SourceCIDR')
        if m.get('SourceNetworkId') is not None:
            self.source_network_id = m.get('SourceNetworkId')
        if m.get('SourceVSwitchId') is not None:
            self.source_vswitch_id = m.get('SourceVSwitchId')
        if m.get('StandbySnatIp') is not None:
            self.standby_snat_ip = m.get('StandbySnatIp')
        return self


class CreateSnatEntryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        snat_entry_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The ID of the SNAT entry.
        self.snat_entry_id = snat_entry_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.snat_entry_id is not None:
            result['SnatEntryId'] = self.snat_entry_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SnatEntryId') is not None:
            self.snat_entry_id = m.get('SnatEntryId')
        return self


class CreateSnatEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSnatEntryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSnatEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateStorageGatewayRequestOrderDetails(TeaModel):
    def __init__(
        self,
        description: str = None,
        ens_region_id: str = None,
        gateway_name: str = None,
        gateway_type: str = None,
        vpc_id: str = None,
    ):
        # The description of the gateway. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
        self.description = description
        # The ID of the node.
        # 
        # This parameter is required.
        self.ens_region_id = ens_region_id
        # The name of the gateway. The name must be 2 to 128 characters in length. The name must start with a letter and cannot start with `http://` or `https://`. The name can contain letters, digits, colons (.), underscores (_), and hyphens (-).
        self.gateway_name = gateway_name
        # The type of the gateway. Set this parameter to **1**. **1** indicates iSCSI.
        # 
        # This parameter is required.
        self.gateway_type = gateway_type
        # The ID of the VPC.
        # 
        # This parameter is required.
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.gateway_name is not None:
            result['GatewayName'] = self.gateway_name
        if self.gateway_type is not None:
            result['GatewayType'] = self.gateway_type
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('GatewayName') is not None:
            self.gateway_name = m.get('GatewayName')
        if m.get('GatewayType') is not None:
            self.gateway_type = m.get('GatewayType')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class CreateStorageGatewayRequest(TeaModel):
    def __init__(
        self,
        order_details: List[CreateStorageGatewayRequestOrderDetails] = None,
    ):
        # The array of orders.
        # 
        # This parameter is required.
        self.order_details = order_details

    def validate(self):
        if self.order_details:
            for k in self.order_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OrderDetails'] = []
        if self.order_details is not None:
            for k in self.order_details:
                result['OrderDetails'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.order_details = []
        if m.get('OrderDetails') is not None:
            for k in m.get('OrderDetails'):
                temp_model = CreateStorageGatewayRequestOrderDetails()
                self.order_details.append(temp_model.from_map(k))
        return self


class CreateStorageGatewayShrinkRequest(TeaModel):
    def __init__(
        self,
        order_details_shrink: str = None,
    ):
        # The array of orders.
        # 
        # This parameter is required.
        self.order_details_shrink = order_details_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_details_shrink is not None:
            result['OrderDetails'] = self.order_details_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrderDetails') is not None:
            self.order_details_shrink = m.get('OrderDetails')
        return self


class CreateStorageGatewayResponseBodyAllocationId(TeaModel):
    def __init__(
        self,
        ens_region_id: str = None,
        instance_id: str = None,
    ):
        # The ID of the node.
        self.ens_region_id = ens_region_id
        # The ID of the instance.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateStorageGatewayResponseBodyUnAllocationId(TeaModel):
    def __init__(
        self,
        ens_region_id: str = None,
        instance_id: str = None,
    ):
        # The ID of the node.
        self.ens_region_id = ens_region_id
        # The ID of the instance.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateStorageGatewayResponseBody(TeaModel):
    def __init__(
        self,
        allocation_id: List[CreateStorageGatewayResponseBodyAllocationId] = None,
        biz_status_code: str = None,
        request_id: str = None,
        un_allocation_id: List[CreateStorageGatewayResponseBodyUnAllocationId] = None,
    ):
        # The list of created nodes.
        self.allocation_id = allocation_id
        # The success status code.
        # 
        # *   **PartSuccess**: partially succeeded.
        # *   **AllSuccess**: all succeeded.
        self.biz_status_code = biz_status_code
        # The request ID.
        self.request_id = request_id
        # The list of nodes that are not created.
        self.un_allocation_id = un_allocation_id

    def validate(self):
        if self.allocation_id:
            for k in self.allocation_id:
                if k:
                    k.validate()
        if self.un_allocation_id:
            for k in self.un_allocation_id:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AllocationId'] = []
        if self.allocation_id is not None:
            for k in self.allocation_id:
                result['AllocationId'].append(k.to_map() if k else None)
        if self.biz_status_code is not None:
            result['BizStatusCode'] = self.biz_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['UnAllocationId'] = []
        if self.un_allocation_id is not None:
            for k in self.un_allocation_id:
                result['UnAllocationId'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.allocation_id = []
        if m.get('AllocationId') is not None:
            for k in m.get('AllocationId'):
                temp_model = CreateStorageGatewayResponseBodyAllocationId()
                self.allocation_id.append(temp_model.from_map(k))
        if m.get('BizStatusCode') is not None:
            self.biz_status_code = m.get('BizStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.un_allocation_id = []
        if m.get('UnAllocationId') is not None:
            for k in m.get('UnAllocationId'):
                temp_model = CreateStorageGatewayResponseBodyUnAllocationId()
                self.un_allocation_id.append(temp_model.from_map(k))
        return self


class CreateStorageGatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateStorageGatewayResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateStorageGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateStorageVolumeRequest(TeaModel):
    def __init__(
        self,
        auth_password: str = None,
        auth_protocol: str = None,
        auth_user: str = None,
        description: str = None,
        ens_region_id: str = None,
        gateway_id: str = None,
        is_auth: str = None,
        is_enable: str = None,
        storage_id: str = None,
        volume_name: str = None,
    ):
        # The password of the CHAP protocol.
        self.auth_password = auth_password
        # The authentication protocol. Set the value to **CHAP**.
        self.auth_protocol = auth_protocol
        # The username of the CHAP protocol.
        self.auth_user = auth_user
        # The description of the volume. The description must be 2 to 128 characters in length. The description cannot start with `http://` or `https://`.
        self.description = description
        # The ID of the node.
        # 
        # This parameter is required.
        self.ens_region_id = ens_region_id
        # The ID of the gateway.
        # 
        # This parameter is required.
        self.gateway_id = gateway_id
        # Specifies whether to enable authentication. Valid values:
        # 
        # *   **1**: Authentication is enabled.
        # *   **0** (default): Authentication is disabled.
        self.is_auth = is_auth
        # Indicates whether the volume is enabled. Valid values:
        # 
        # *   **1** (default): The volume is enabled.
        # *   **0**: The volume is disabled.
        self.is_enable = is_enable
        # The ID of the storage medium.
        # 
        # This parameter is required.
        self.storage_id = storage_id
        # The name of the volume. The name must be 2 to 128 characters in length. The name cannot start with `http://` or `https://`. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        self.volume_name = volume_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_password is not None:
            result['AuthPassword'] = self.auth_password
        if self.auth_protocol is not None:
            result['AuthProtocol'] = self.auth_protocol
        if self.auth_user is not None:
            result['AuthUser'] = self.auth_user
        if self.description is not None:
            result['Description'] = self.description
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.is_auth is not None:
            result['IsAuth'] = self.is_auth
        if self.is_enable is not None:
            result['IsEnable'] = self.is_enable
        if self.storage_id is not None:
            result['StorageId'] = self.storage_id
        if self.volume_name is not None:
            result['VolumeName'] = self.volume_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthPassword') is not None:
            self.auth_password = m.get('AuthPassword')
        if m.get('AuthProtocol') is not None:
            self.auth_protocol = m.get('AuthProtocol')
        if m.get('AuthUser') is not None:
            self.auth_user = m.get('AuthUser')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('IsAuth') is not None:
            self.is_auth = m.get('IsAuth')
        if m.get('IsEnable') is not None:
            self.is_enable = m.get('IsEnable')
        if m.get('StorageId') is not None:
            self.storage_id = m.get('StorageId')
        if m.get('VolumeName') is not None:
            self.volume_name = m.get('VolumeName')
        return self


class CreateStorageVolumeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        volume_id: List[str] = None,
    ):
        # The request ID.
        self.request_id = request_id
        # An array of volume IDs.
        self.volume_id = volume_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.volume_id is not None:
            result['VolumeId'] = self.volume_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VolumeId') is not None:
            self.volume_id = m.get('VolumeId')
        return self


class CreateStorageVolumeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateStorageVolumeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateStorageVolumeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVSwitchRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The key of the tag that are to add to the instance. Valid values of N: **1** to **20**.
        # 
        # *   The key cannot start with `aliyun`, `acs:`, `http://`, or `https://`.
        # *   The key must be up to 64 characters in length.
        # *   The tag key cannot be an empty string.
        self.key = key
        # The value of tag N that is added to the resource. Valid values of N: 1 to 20. The tag value can be an empty string. The tag value can be up to 128 characters in length. It cannot start with acs: or contain http:// or https://.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateVSwitchRequest(TeaModel):
    def __init__(
        self,
        cidr_block: str = None,
        description: str = None,
        ens_region_id: str = None,
        network_id: str = None,
        tag: List[CreateVSwitchRequestTag] = None,
        v_switch_name: str = None,
    ):
        # The CIDR block of the vSwitch. Take note of the following limits:
        # 
        # *   The subnet mask must be 16 to 29 bits in length.
        # *   The CIDR block of the vSwitch must fall within the CIDR block of the VPC to which the vSwitch belongs.
        # *   The CIDR block of the vSwitch cannot be the same as the destination CIDR block in a route entry of the VPC. However, it can be a subset of the destination CIDR block.
        # 
        # This parameter is required.
        self.cidr_block = cidr_block
        # The description of the vSwitch.
        # 
        # The description must be 2 to 256 characters in length. It must start with a letter but cannot start with http:// or https://.
        self.description = description
        # The ID of the edge node.
        # 
        # This parameter is required.
        self.ens_region_id = ens_region_id
        # The ID of the network to which the vSwitch that you want to create belongs.
        self.network_id = network_id
        # The tags.
        self.tag = tag
        # The name of the vSwitch. The name must meet the following requirements:
        # 
        # *   The name must be 2 to 128 characters in length.
        # *   The name must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        # 
        # Default value: null.
        self.v_switch_name = v_switch_name

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.description is not None:
            result['Description'] = self.description
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.network_id is not None:
            result['NetworkId'] = self.network_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.v_switch_name is not None:
            result['VSwitchName'] = self.v_switch_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('NetworkId') is not None:
            self.network_id = m.get('NetworkId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateVSwitchRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('VSwitchName') is not None:
            self.v_switch_name = m.get('VSwitchName')
        return self


class CreateVSwitchResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        v_switch_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The ID of the vSwitch.
        self.v_switch_id = v_switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class CreateVSwitchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateVSwitchResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateVSwitchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAICPublicKeyRequest(TeaModel):
    def __init__(
        self,
        key_name: str = None,
    ):
        # This parameter is required.
        self.key_name = key_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key_name is not None:
            result['KeyName'] = self.key_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('KeyName') is not None:
            self.key_name = m.get('KeyName')
        return self


class DeleteAICPublicKeyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAICPublicKeyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAICPublicKeyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAICPublicKeyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteApplicationRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        timeout: int = None,
    ):
        # The ID of the application. To obtain the application ID, call the ListApplication operation.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The timeout period for the asynchronous release. Unit: seconds. Default value: 300.
        self.timeout = timeout

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        return self


class DeleteApplicationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteApplicationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBucketRequest(TeaModel):
    def __init__(
        self,
        bucket_name: str = None,
    ):
        # The name of the bucket that you want to delete. You can delete only one bucket at a time.
        # 
        # This parameter is required.
        self.bucket_name = bucket_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket_name is not None:
            result['BucketName'] = self.bucket_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BucketName') is not None:
            self.bucket_name = m.get('BucketName')
        return self


class DeleteBucketResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBucketResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteBucketResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteBucketResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBucketLifecycleRequest(TeaModel):
    def __init__(
        self,
        bucket_name: str = None,
        rule_id: str = None,
    ):
        # The name of the bucket.
        # 
        # This parameter is required.
        self.bucket_name = bucket_name
        # The ID of the rule. If this parameter is not specified, all rules are removed.
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket_name is not None:
            result['BucketName'] = self.bucket_name
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BucketName') is not None:
            self.bucket_name = m.get('BucketName')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DeleteBucketLifecycleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBucketLifecycleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteBucketLifecycleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteBucketLifecycleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDiskRequest(TeaModel):
    def __init__(
        self,
        disk_id: str = None,
    ):
        # The ID of the disk.
        # 
        # This parameter is required.
        self.disk_id = disk_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        return self


class DeleteDiskResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        request_id: str = None,
    ):
        # The returned service code. 0 indicates that the request was successful.
        self.code = code
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDiskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDiskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDiskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEipRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteEipResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEipResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEipResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEipResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEnsRouteEntryRequest(TeaModel):
    def __init__(
        self,
        route_entry_id: str = None,
    ):
        # The ID of the route that you want to delete.
        # 
        # This parameter is required.
        self.route_entry_id = route_entry_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.route_entry_id is not None:
            result['RouteEntryId'] = self.route_entry_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RouteEntryId') is not None:
            self.route_entry_id = m.get('RouteEntryId')
        return self


class DeleteEnsRouteEntryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEnsRouteEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEnsRouteEntryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEnsRouteEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEnsSaleConditionControlRequestSaleControlsConditionControls(TeaModel):
    def __init__(
        self,
        condition_control_module_code: str = None,
        condition_control_module_value: str = None,
    ):
        # This parameter is required.
        self.condition_control_module_code = condition_control_module_code
        # This parameter is required.
        self.condition_control_module_value = condition_control_module_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.condition_control_module_code is not None:
            result['ConditionControlModuleCode'] = self.condition_control_module_code
        if self.condition_control_module_value is not None:
            result['ConditionControlModuleValue'] = self.condition_control_module_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConditionControlModuleCode') is not None:
            self.condition_control_module_code = m.get('ConditionControlModuleCode')
        if m.get('ConditionControlModuleValue') is not None:
            self.condition_control_module_value = m.get('ConditionControlModuleValue')
        return self


class DeleteEnsSaleConditionControlRequestSaleControls(TeaModel):
    def __init__(
        self,
        condition_controls: List[DeleteEnsSaleConditionControlRequestSaleControlsConditionControls] = None,
        module_code: str = None,
        order_type: str = None,
    ):
        # This parameter is required.
        self.condition_controls = condition_controls
        # This parameter is required.
        self.module_code = module_code
        # This parameter is required.
        self.order_type = order_type

    def validate(self):
        if self.condition_controls:
            for k in self.condition_controls:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConditionControls'] = []
        if self.condition_controls is not None:
            for k in self.condition_controls:
                result['ConditionControls'].append(k.to_map() if k else None)
        if self.module_code is not None:
            result['ModuleCode'] = self.module_code
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.condition_controls = []
        if m.get('ConditionControls') is not None:
            for k in m.get('ConditionControls'):
                temp_model = DeleteEnsSaleConditionControlRequestSaleControlsConditionControls()
                self.condition_controls.append(temp_model.from_map(k))
        if m.get('ModuleCode') is not None:
            self.module_code = m.get('ModuleCode')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        return self


class DeleteEnsSaleConditionControlRequest(TeaModel):
    def __init__(
        self,
        ali_uid_account: str = None,
        commodity_code: str = None,
        custom_account: str = None,
        sale_controls: List[DeleteEnsSaleConditionControlRequestSaleControls] = None,
    ):
        self.ali_uid_account = ali_uid_account
        # This parameter is required.
        self.commodity_code = commodity_code
        self.custom_account = custom_account
        # This parameter is required.
        self.sale_controls = sale_controls

    def validate(self):
        if self.sale_controls:
            for k in self.sale_controls:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid_account is not None:
            result['AliUidAccount'] = self.ali_uid_account
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.custom_account is not None:
            result['CustomAccount'] = self.custom_account
        result['SaleControls'] = []
        if self.sale_controls is not None:
            for k in self.sale_controls:
                result['SaleControls'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliUidAccount') is not None:
            self.ali_uid_account = m.get('AliUidAccount')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('CustomAccount') is not None:
            self.custom_account = m.get('CustomAccount')
        self.sale_controls = []
        if m.get('SaleControls') is not None:
            for k in m.get('SaleControls'):
                temp_model = DeleteEnsSaleConditionControlRequestSaleControls()
                self.sale_controls.append(temp_model.from_map(k))
        return self


class DeleteEnsSaleConditionControlShrinkRequest(TeaModel):
    def __init__(
        self,
        ali_uid_account: str = None,
        commodity_code: str = None,
        custom_account: str = None,
        sale_controls_shrink: str = None,
    ):
        self.ali_uid_account = ali_uid_account
        # This parameter is required.
        self.commodity_code = commodity_code
        self.custom_account = custom_account
        # This parameter is required.
        self.sale_controls_shrink = sale_controls_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid_account is not None:
            result['AliUidAccount'] = self.ali_uid_account
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.custom_account is not None:
            result['CustomAccount'] = self.custom_account
        if self.sale_controls_shrink is not None:
            result['SaleControls'] = self.sale_controls_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliUidAccount') is not None:
            self.ali_uid_account = m.get('AliUidAccount')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('CustomAccount') is not None:
            self.custom_account = m.get('CustomAccount')
        if m.get('SaleControls') is not None:
            self.sale_controls_shrink = m.get('SaleControls')
        return self


class DeleteEnsSaleConditionControlResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEnsSaleConditionControlResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEnsSaleConditionControlResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEnsSaleConditionControlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEnsSaleControlRequestSaleControls(TeaModel):
    def __init__(
        self,
        module_code: str = None,
        order_type: str = None,
    ):
        # This parameter is required.
        self.module_code = module_code
        # This parameter is required.
        self.order_type = order_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.module_code is not None:
            result['ModuleCode'] = self.module_code
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ModuleCode') is not None:
            self.module_code = m.get('ModuleCode')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        return self


class DeleteEnsSaleControlRequest(TeaModel):
    def __init__(
        self,
        ali_uid_account: str = None,
        commodity_code: str = None,
        custom_account: str = None,
        sale_controls: List[DeleteEnsSaleControlRequestSaleControls] = None,
    ):
        self.ali_uid_account = ali_uid_account
        # This parameter is required.
        self.commodity_code = commodity_code
        self.custom_account = custom_account
        # This parameter is required.
        self.sale_controls = sale_controls

    def validate(self):
        if self.sale_controls:
            for k in self.sale_controls:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid_account is not None:
            result['AliUidAccount'] = self.ali_uid_account
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.custom_account is not None:
            result['CustomAccount'] = self.custom_account
        result['SaleControls'] = []
        if self.sale_controls is not None:
            for k in self.sale_controls:
                result['SaleControls'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliUidAccount') is not None:
            self.ali_uid_account = m.get('AliUidAccount')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('CustomAccount') is not None:
            self.custom_account = m.get('CustomAccount')
        self.sale_controls = []
        if m.get('SaleControls') is not None:
            for k in m.get('SaleControls'):
                temp_model = DeleteEnsSaleControlRequestSaleControls()
                self.sale_controls.append(temp_model.from_map(k))
        return self


class DeleteEnsSaleControlShrinkRequest(TeaModel):
    def __init__(
        self,
        ali_uid_account: str = None,
        commodity_code: str = None,
        custom_account: str = None,
        sale_controls_shrink: str = None,
    ):
        self.ali_uid_account = ali_uid_account
        # This parameter is required.
        self.commodity_code = commodity_code
        self.custom_account = custom_account
        # This parameter is required.
        self.sale_controls_shrink = sale_controls_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid_account is not None:
            result['AliUidAccount'] = self.ali_uid_account
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.custom_account is not None:
            result['CustomAccount'] = self.custom_account
        if self.sale_controls_shrink is not None:
            result['SaleControls'] = self.sale_controls_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliUidAccount') is not None:
            self.ali_uid_account = m.get('AliUidAccount')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('CustomAccount') is not None:
            self.custom_account = m.get('CustomAccount')
        if m.get('SaleControls') is not None:
            self.sale_controls_shrink = m.get('SaleControls')
        return self


class DeleteEnsSaleControlResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEnsSaleControlResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEnsSaleControlResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEnsSaleControlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEpnInstanceRequest(TeaModel):
    def __init__(
        self,
        epninstance_id: str = None,
    ):
        # The ID of the EPN instance.
        # 
        # This parameter is required.
        self.epninstance_id = epninstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.epninstance_id is not None:
            result['EPNInstanceId'] = self.epninstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EPNInstanceId') is not None:
            self.epninstance_id = m.get('EPNInstanceId')
        return self


class DeleteEpnInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEpnInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEpnInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEpnInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFileSystemRequest(TeaModel):
    def __init__(
        self,
        ens_region_id: str = None,
        file_system_id: str = None,
    ):
        # The ID of the edge node.
        # 
        # This parameter is required.
        self.ens_region_id = ens_region_id
        # The ID of the file system that you want to delete.
        # 
        # This parameter is required.
        self.file_system_id = file_system_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.file_system_id is not None:
            result['FileSystemId'] = self.file_system_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('FileSystemId') is not None:
            self.file_system_id = m.get('FileSystemId')
        return self


class DeleteFileSystemResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteFileSystemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteFileSystemResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteFileSystemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteForwardEntryRequest(TeaModel):
    def __init__(
        self,
        forward_entry_id: str = None,
    ):
        # The ID of the DNAT entry that you want to delete.
        # 
        # This parameter is required.
        self.forward_entry_id = forward_entry_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.forward_entry_id is not None:
            result['ForwardEntryId'] = self.forward_entry_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ForwardEntryId') is not None:
            self.forward_entry_id = m.get('ForwardEntryId')
        return self


class DeleteForwardEntryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteForwardEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteForwardEntryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteForwardEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHaVipsRequest(TeaModel):
    def __init__(
        self,
        ha_vip_ids: List[str] = None,
    ):
        # The IDs of high-availability virtual IP addresses (HAVIPs).
        # 
        # This parameter is required.
        self.ha_vip_ids = ha_vip_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ha_vip_ids is not None:
            result['HaVipIds'] = self.ha_vip_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HaVipIds') is not None:
            self.ha_vip_ids = m.get('HaVipIds')
        return self


class DeleteHaVipsShrinkRequest(TeaModel):
    def __init__(
        self,
        ha_vip_ids_shrink: str = None,
    ):
        # The IDs of high-availability virtual IP addresses (HAVIPs).
        # 
        # This parameter is required.
        self.ha_vip_ids_shrink = ha_vip_ids_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ha_vip_ids_shrink is not None:
            result['HaVipIds'] = self.ha_vip_ids_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HaVipIds') is not None:
            self.ha_vip_ids_shrink = m.get('HaVipIds')
        return self


class DeleteHaVipsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteHaVipsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteHaVipsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHaVipsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteImageRequest(TeaModel):
    def __init__(
        self,
        image_id: str = None,
    ):
        # The ID of the image. You can specify only one image ID.
        # 
        # You can delete only custom images that you created.
        # 
        # This parameter is required.
        self.image_id = image_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        return self


class DeleteImageResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        request_id: str = None,
    ):
        # The returned service code. A value of 0 indicates that the operation was successful.
        self.code = code
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteImageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteImageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteKeyPairsRequest(TeaModel):
    def __init__(
        self,
        key_pair_id: str = None,
        key_pair_name: str = None,
    ):
        # The ID of the SSH key pair.
        self.key_pair_id = key_pair_id
        # The name of the key pair. The name must conform to the following naming conventions:
        # 
        # *   The name must be 2 to 128 characters in length.
        # *   The name must start with a letter and cannot start with `http://` or `https://`.
        # *   The name can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        # 
        # Before you delete a key pair, you can call the DescribeKeyPairs operation to query existing key pairs.
        self.key_pair_name = key_pair_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key_pair_id is not None:
            result['KeyPairId'] = self.key_pair_id
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('KeyPairId') is not None:
            self.key_pair_id = m.get('KeyPairId')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        return self


class DeleteKeyPairsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteKeyPairsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteKeyPairsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteKeyPairsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLoadBalancerListenerRequest(TeaModel):
    def __init__(
        self,
        listener_port: int = None,
        listener_protocol: str = None,
        load_balancer_id: str = None,
    ):
        # The frontend port that is used by the Edge Load Balance (ELB) instance. Valid values: **1** to **65535**.
        # 
        # This parameter is required.
        self.listener_port = listener_port
        # The frontend protocol that is used by the ELB instance.
        # 
        # >  This parameter is required if the same port is used by listeners that use different protocols.
        self.listener_protocol = listener_protocol
        # The ID of the ELB instance.
        # 
        # This parameter is required.
        self.load_balancer_id = load_balancer_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.listener_port is not None:
            result['ListenerPort'] = self.listener_port
        if self.listener_protocol is not None:
            result['ListenerProtocol'] = self.listener_protocol
        if self.load_balancer_id is not None:
            result['LoadBalancerId'] = self.load_balancer_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ListenerPort') is not None:
            self.listener_port = m.get('ListenerPort')
        if m.get('ListenerProtocol') is not None:
            self.listener_protocol = m.get('ListenerProtocol')
        if m.get('LoadBalancerId') is not None:
            self.load_balancer_id = m.get('LoadBalancerId')
        return self


class DeleteLoadBalancerListenerResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLoadBalancerListenerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLoadBalancerListenerResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLoadBalancerListenerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMountTargetRequest(TeaModel):
    def __init__(
        self,
        ens_region_id: str = None,
        file_system_id: str = None,
        mount_target_name: str = None,
    ):
        # The ID of the edge node.
        # 
        # This parameter is required.
        self.ens_region_id = ens_region_id
        # The ID of the file system.
        # 
        # This parameter is required.
        self.file_system_id = file_system_id
        # The name of the mount target.
        # 
        # This parameter is required.
        self.mount_target_name = mount_target_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.file_system_id is not None:
            result['FileSystemId'] = self.file_system_id
        if self.mount_target_name is not None:
            result['MountTargetName'] = self.mount_target_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('FileSystemId') is not None:
            self.file_system_id = m.get('FileSystemId')
        if m.get('MountTargetName') is not None:
            self.mount_target_name = m.get('MountTargetName')
        return self


class DeleteMountTargetResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMountTargetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMountTargetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMountTargetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNatGatewayRequest(TeaModel):
    def __init__(
        self,
        force_delete: bool = None,
        nat_gateway_id: str = None,
    ):
        # Specifies whether to forcefully delete the NAT instance.
        self.force_delete = force_delete
        # The ID of the NAT gateway that you want to delete.
        # 
        # This parameter is required.
        self.nat_gateway_id = nat_gateway_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.force_delete is not None:
            result['ForceDelete'] = self.force_delete
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ForceDelete') is not None:
            self.force_delete = m.get('ForceDelete')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        return self


class DeleteNatGatewayResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteNatGatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteNatGatewayResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNatGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNetworkRequest(TeaModel):
    def __init__(
        self,
        network_id: str = None,
    ):
        # The ID of the network.
        # 
        # This parameter is required.
        self.network_id = network_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_id is not None:
            result['NetworkId'] = self.network_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkId') is not None:
            self.network_id = m.get('NetworkId')
        return self


class DeleteNetworkResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteNetworkResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteNetworkResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNetworkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNetworkAclRequest(TeaModel):
    def __init__(
        self,
        network_acl_id: str = None,
    ):
        # The ID of the network ACL.
        # 
        # This parameter is required.
        self.network_acl_id = network_acl_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_acl_id is not None:
            result['NetworkAclId'] = self.network_acl_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkAclId') is not None:
            self.network_acl_id = m.get('NetworkAclId')
        return self


class DeleteNetworkAclResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteNetworkAclResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteNetworkAclResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNetworkAclResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNetworkAclEntryRequest(TeaModel):
    def __init__(
        self,
        network_acl_entry_id: str = None,
    ):
        # The ID of the network ACL for which you want to delete a rule.
        self.network_acl_entry_id = network_acl_entry_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_acl_entry_id is not None:
            result['NetworkAclEntryId'] = self.network_acl_entry_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkAclEntryId') is not None:
            self.network_acl_entry_id = m.get('NetworkAclEntryId')
        return self


class DeleteNetworkAclEntryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteNetworkAclEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteNetworkAclEntryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNetworkAclEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNetworkInterfacesRequest(TeaModel):
    def __init__(
        self,
        network_interface_ids: List[str] = None,
    ):
        # The IDs of the elastic network interfaces (ENIs).
        # 
        # This parameter is required.
        self.network_interface_ids = network_interface_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_interface_ids is not None:
            result['NetworkInterfaceIds'] = self.network_interface_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkInterfaceIds') is not None:
            self.network_interface_ids = m.get('NetworkInterfaceIds')
        return self


class DeleteNetworkInterfacesShrinkRequest(TeaModel):
    def __init__(
        self,
        network_interface_ids_shrink: str = None,
    ):
        # The IDs of the elastic network interfaces (ENIs).
        # 
        # This parameter is required.
        self.network_interface_ids_shrink = network_interface_ids_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_interface_ids_shrink is not None:
            result['NetworkInterfaceIds'] = self.network_interface_ids_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkInterfaceIds') is not None:
            self.network_interface_ids_shrink = m.get('NetworkInterfaceIds')
        return self


class DeleteNetworkInterfacesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteNetworkInterfacesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteNetworkInterfacesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNetworkInterfacesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteObjectRequest(TeaModel):
    def __init__(
        self,
        bucket_name: str = None,
        object_key: str = None,
    ):
        # The name of the bucket.
        # 
        # This parameter is required.
        self.bucket_name = bucket_name
        # The name of the file.
        # 
        # This parameter is required.
        self.object_key = object_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket_name is not None:
            result['BucketName'] = self.bucket_name
        if self.object_key is not None:
            result['ObjectKey'] = self.object_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BucketName') is not None:
            self.bucket_name = m.get('BucketName')
        if m.get('ObjectKey') is not None:
            self.object_key = m.get('ObjectKey')
        return self


class DeleteObjectResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteObjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteObjectResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteObjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSDGRequest(TeaModel):
    def __init__(
        self,
        sdgid: List[str] = None,
    ):
        # The IDs of the SDGs that you want to delete.
        # 
        # This parameter is required.
        self.sdgid = sdgid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sdgid is not None:
            result['SDGId'] = self.sdgid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SDGId') is not None:
            self.sdgid = m.get('SDGId')
        return self


class DeleteSDGShrinkRequest(TeaModel):
    def __init__(
        self,
        sdgid_shrink: str = None,
    ):
        # The IDs of the SDGs that you want to delete.
        # 
        # This parameter is required.
        self.sdgid_shrink = sdgid_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sdgid_shrink is not None:
            result['SDGId'] = self.sdgid_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SDGId') is not None:
            self.sdgid_shrink = m.get('SDGId')
        return self


class DeleteSDGResponseBodyDataResultFailedItemsItem(TeaModel):
    def __init__(
        self,
        sdg_id: str = None,
    ):
        # The ID of the shared data group (SDG).
        self.sdg_id = sdg_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sdg_id is not None:
            result['SdgId'] = self.sdg_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SdgId') is not None:
            self.sdg_id = m.get('SdgId')
        return self


class DeleteSDGResponseBodyDataResultFailedItems(TeaModel):
    def __init__(
        self,
        err_message: str = None,
        item: DeleteSDGResponseBodyDataResultFailedItemsItem = None,
    ):
        # The error message.
        self.err_message = err_message
        # Description
        self.item = item

    def validate(self):
        if self.item:
            self.item.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.err_message is not None:
            result['ErrMessage'] = self.err_message
        if self.item is not None:
            result['Item'] = self.item.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrMessage') is not None:
            self.err_message = m.get('ErrMessage')
        if m.get('Item') is not None:
            temp_model = DeleteSDGResponseBodyDataResultFailedItemsItem()
            self.item = temp_model.from_map(m['Item'])
        return self


class DeleteSDGResponseBodyDataResult(TeaModel):
    def __init__(
        self,
        failed_count: int = None,
        failed_items: List[DeleteSDGResponseBodyDataResultFailedItems] = None,
        success_count: int = None,
    ):
        # The number of failed tasks.
        self.failed_count = failed_count
        # Details about the failed tasks.
        self.failed_items = failed_items
        # The number of successful tasks.
        self.success_count = success_count

    def validate(self):
        if self.failed_items:
            for k in self.failed_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed_count is not None:
            result['FailedCount'] = self.failed_count
        result['FailedItems'] = []
        if self.failed_items is not None:
            for k in self.failed_items:
                result['FailedItems'].append(k.to_map() if k else None)
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailedCount') is not None:
            self.failed_count = m.get('FailedCount')
        self.failed_items = []
        if m.get('FailedItems') is not None:
            for k in m.get('FailedItems'):
                temp_model = DeleteSDGResponseBodyDataResultFailedItems()
                self.failed_items.append(temp_model.from_map(k))
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        return self


class DeleteSDGResponseBodyData(TeaModel):
    def __init__(
        self,
        message: str = None,
        result: DeleteSDGResponseBodyDataResult = None,
        success: bool = None,
    ):
        # The response message. Success is returned for a successful request.
        self.message = message
        # The execution result of the synchronization request.
        self.result = result
        # Indicates whether all tasks are successful. Valid values:
        # 
        # *   true: All tasks are successful.
        # *   false: Failed tasks exist.
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.result is not None:
            result['Result'] = self.result.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Result') is not None:
            temp_model = DeleteSDGResponseBodyDataResult()
            self.result = temp_model.from_map(m['Result'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSDGResponseBody(TeaModel):
    def __init__(
        self,
        data: DeleteSDGResponseBodyData = None,
        request_id: str = None,
    ):
        # The returned data object.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DeleteSDGResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSDGResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSDGResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSDGResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSecurityGroupRequest(TeaModel):
    def __init__(
        self,
        security_group_id: str = None,
    ):
        # The security group ID of the instance.
        # 
        # This parameter is required.
        self.security_group_id = security_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        return self


class DeleteSecurityGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSecurityGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSecurityGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSecurityGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSnapshotRequest(TeaModel):
    def __init__(
        self,
        snapshot_id: str = None,
    ):
        # The ID of the snapshot.
        # 
        # This parameter is required.
        self.snapshot_id = snapshot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        return self


class DeleteSnapshotResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSnapshotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSnapshotResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSnapshotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSnatEntryRequest(TeaModel):
    def __init__(
        self,
        snat_entry_id: str = None,
    ):
        # The ID of the SNAT entry that you want to delete.
        # 
        # This parameter is required.
        self.snat_entry_id = snat_entry_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.snat_entry_id is not None:
            result['SnatEntryId'] = self.snat_entry_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SnatEntryId') is not None:
            self.snat_entry_id = m.get('SnatEntryId')
        return self


class DeleteSnatEntryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSnatEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSnatEntryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSnatEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSnatIpForSnatEntryRequest(TeaModel):
    def __init__(
        self,
        snat_entry_id: str = None,
        snat_ip: str = None,
    ):
        # The ID of the SNAT entry.
        # 
        # This parameter is required.
        self.snat_entry_id = snat_entry_id
        # The EIP that you want to delete from the SNAT entry.
        # 
        # This parameter is required.
        self.snat_ip = snat_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.snat_entry_id is not None:
            result['SnatEntryId'] = self.snat_entry_id
        if self.snat_ip is not None:
            result['SnatIp'] = self.snat_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SnatEntryId') is not None:
            self.snat_entry_id = m.get('SnatEntryId')
        if m.get('SnatIp') is not None:
            self.snat_ip = m.get('SnatIp')
        return self


class DeleteSnatIpForSnatEntryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSnatIpForSnatEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSnatIpForSnatEntryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSnatIpForSnatEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteStorageGatewayRequest(TeaModel):
    def __init__(
        self,
        gateway_id: str = None,
    ):
        # The ID of the gateway.
        # 
        # This parameter is required.
        self.gateway_id = gateway_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        return self


class DeleteStorageGatewayResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteStorageGatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteStorageGatewayResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteStorageGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteStorageVolumeRequest(TeaModel):
    def __init__(
        self,
        volume_id: str = None,
    ):
        # The ID of the volume.
        # 
        # This parameter is required.
        self.volume_id = volume_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.volume_id is not None:
            result['VolumeId'] = self.volume_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VolumeId') is not None:
            self.volume_id = m.get('VolumeId')
        return self


class DeleteStorageVolumeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteStorageVolumeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteStorageVolumeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteStorageVolumeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVSwitchRequest(TeaModel):
    def __init__(
        self,
        v_switch_id: str = None,
    ):
        # The ID of the vSwitch.
        # 
        # This parameter is required.
        self.v_switch_id = v_switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class DeleteVSwitchResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVSwitchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteVSwitchResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVSwitchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeployInstanceSDGRequest(TeaModel):
    def __init__(
        self,
        deployment_type: str = None,
        disk_access_protocol: str = None,
        disk_type: str = None,
        instance_ids: List[str] = None,
        sdgid: str = None,
    ):
        # The deployment type of the SDG. shared: shared read/write splitting deployment. The content of the SDG is read-only, and data updates are written to the local storage of the instance.
        self.deployment_type = deployment_type
        self.disk_access_protocol = disk_access_protocol
        self.disk_type = disk_type
        # The IDs of the instances. The value is a JSON array that consists of up to 100 IDs.
        # 
        # This parameter is required.
        self.instance_ids = instance_ids
        # The ID of the SDG.
        # 
        # This parameter is required.
        self.sdgid = sdgid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deployment_type is not None:
            result['DeploymentType'] = self.deployment_type
        if self.disk_access_protocol is not None:
            result['DiskAccessProtocol'] = self.disk_access_protocol
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.sdgid is not None:
            result['SDGId'] = self.sdgid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeploymentType') is not None:
            self.deployment_type = m.get('DeploymentType')
        if m.get('DiskAccessProtocol') is not None:
            self.disk_access_protocol = m.get('DiskAccessProtocol')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('SDGId') is not None:
            self.sdgid = m.get('SDGId')
        return self


class DeployInstanceSDGShrinkRequest(TeaModel):
    def __init__(
        self,
        deployment_type: str = None,
        disk_access_protocol: str = None,
        disk_type: str = None,
        instance_ids_shrink: str = None,
        sdgid: str = None,
    ):
        # The deployment type of the SDG. shared: shared read/write splitting deployment. The content of the SDG is read-only, and data updates are written to the local storage of the instance.
        self.deployment_type = deployment_type
        self.disk_access_protocol = disk_access_protocol
        self.disk_type = disk_type
        # The IDs of the instances. The value is a JSON array that consists of up to 100 IDs.
        # 
        # This parameter is required.
        self.instance_ids_shrink = instance_ids_shrink
        # The ID of the SDG.
        # 
        # This parameter is required.
        self.sdgid = sdgid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deployment_type is not None:
            result['DeploymentType'] = self.deployment_type
        if self.disk_access_protocol is not None:
            result['DiskAccessProtocol'] = self.disk_access_protocol
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.instance_ids_shrink is not None:
            result['InstanceIds'] = self.instance_ids_shrink
        if self.sdgid is not None:
            result['SDGId'] = self.sdgid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeploymentType') is not None:
            self.deployment_type = m.get('DeploymentType')
        if m.get('DiskAccessProtocol') is not None:
            self.disk_access_protocol = m.get('DiskAccessProtocol')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('InstanceIds') is not None:
            self.instance_ids_shrink = m.get('InstanceIds')
        if m.get('SDGId') is not None:
            self.sdgid = m.get('SDGId')
        return self


class DeployInstanceSDGResponseBodyDataResultFailedItems(TeaModel):
    def __init__(
        self,
        err_message: str = None,
        instance_id: str = None,
    ):
        # The error message that is returned.
        self.err_message = err_message
        # The ID of the instance.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.err_message is not None:
            result['ErrMessage'] = self.err_message
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrMessage') is not None:
            self.err_message = m.get('ErrMessage')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeployInstanceSDGResponseBodyDataResult(TeaModel):
    def __init__(
        self,
        failed_count: int = None,
        failed_items: List[DeployInstanceSDGResponseBodyDataResultFailedItems] = None,
        success_count: int = None,
    ):
        # The number of failed tasks.
        self.failed_count = failed_count
        # Details about the failed tasks.
        self.failed_items = failed_items
        # The number of successful tasks.
        self.success_count = success_count

    def validate(self):
        if self.failed_items:
            for k in self.failed_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed_count is not None:
            result['FailedCount'] = self.failed_count
        result['FailedItems'] = []
        if self.failed_items is not None:
            for k in self.failed_items:
                result['FailedItems'].append(k.to_map() if k else None)
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailedCount') is not None:
            self.failed_count = m.get('FailedCount')
        self.failed_items = []
        if m.get('FailedItems') is not None:
            for k in m.get('FailedItems'):
                temp_model = DeployInstanceSDGResponseBodyDataResultFailedItems()
                self.failed_items.append(temp_model.from_map(k))
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        return self


class DeployInstanceSDGResponseBodyData(TeaModel):
    def __init__(
        self,
        message: str = None,
        result: DeployInstanceSDGResponseBodyDataResult = None,
        success: bool = None,
    ):
        # The response message. Success is returned for a successful request.
        self.message = message
        # The execution result of the synchronization request.
        self.result = result
        # Indicates whether all tasks are successful. Valid values:
        # 
        # *   true: All tasks are successful.
        # *   false: Failed tasks exist.
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.result is not None:
            result['Result'] = self.result.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Result') is not None:
            temp_model = DeployInstanceSDGResponseBodyDataResult()
            self.result = temp_model.from_map(m['Result'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeployInstanceSDGResponseBody(TeaModel):
    def __init__(
        self,
        data: DeployInstanceSDGResponseBodyData = None,
        request_id: str = None,
    ):
        # The returned data object.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DeployInstanceSDGResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeployInstanceSDGResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeployInstanceSDGResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeployInstanceSDGResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeploySDGRequest(TeaModel):
    def __init__(
        self,
        deployment_type: str = None,
        instance_ids: List[str] = None,
        sdgid: str = None,
    ):
        # The SDG deployment type. Valid values:
        # 
        # *   common (default): read/write deployment. Data updates are written to disks.
        # *   overlay: read/write splitting deployment. Content in SDGs is read-only. Data updates are written to the local storage of the instance.
        self.deployment_type = deployment_type
        # The IDs of instances on which you want to deploy SDGs. You can deploy SDGs on a maximum of 100 instances at a time.
        # 
        # This parameter is required.
        self.instance_ids = instance_ids
        # The SDG ID. This parameter is used to create a disk, which is attached to an instance.
        # 
        # This parameter is required.
        self.sdgid = sdgid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deployment_type is not None:
            result['DeploymentType'] = self.deployment_type
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.sdgid is not None:
            result['SDGId'] = self.sdgid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeploymentType') is not None:
            self.deployment_type = m.get('DeploymentType')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('SDGId') is not None:
            self.sdgid = m.get('SDGId')
        return self


class DeploySDGShrinkRequest(TeaModel):
    def __init__(
        self,
        deployment_type: str = None,
        instance_ids_shrink: str = None,
        sdgid: str = None,
    ):
        # The SDG deployment type. Valid values:
        # 
        # *   common (default): read/write deployment. Data updates are written to disks.
        # *   overlay: read/write splitting deployment. Content in SDGs is read-only. Data updates are written to the local storage of the instance.
        self.deployment_type = deployment_type
        # The IDs of instances on which you want to deploy SDGs. You can deploy SDGs on a maximum of 100 instances at a time.
        # 
        # This parameter is required.
        self.instance_ids_shrink = instance_ids_shrink
        # The SDG ID. This parameter is used to create a disk, which is attached to an instance.
        # 
        # This parameter is required.
        self.sdgid = sdgid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deployment_type is not None:
            result['DeploymentType'] = self.deployment_type
        if self.instance_ids_shrink is not None:
            result['InstanceIds'] = self.instance_ids_shrink
        if self.sdgid is not None:
            result['SDGId'] = self.sdgid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeploymentType') is not None:
            self.deployment_type = m.get('DeploymentType')
        if m.get('InstanceIds') is not None:
            self.instance_ids_shrink = m.get('InstanceIds')
        if m.get('SDGId') is not None:
            self.sdgid = m.get('SDGId')
        return self


class DeploySDGResponseBodyDataResultFailedItems(TeaModel):
    def __init__(
        self,
        err_message: str = None,
        instance_id: str = None,
    ):
        # The error message.
        self.err_message = err_message
        # The ID of the instance.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.err_message is not None:
            result['ErrMessage'] = self.err_message
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrMessage') is not None:
            self.err_message = m.get('ErrMessage')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeploySDGResponseBodyDataResult(TeaModel):
    def __init__(
        self,
        failed_count: int = None,
        failed_items: List[DeploySDGResponseBodyDataResultFailedItems] = None,
        success_count: int = None,
    ):
        # The number of failed tasks.
        self.failed_count = failed_count
        # Details of failed tasks.
        self.failed_items = failed_items
        # The number of successful tasks.
        self.success_count = success_count

    def validate(self):
        if self.failed_items:
            for k in self.failed_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed_count is not None:
            result['FailedCount'] = self.failed_count
        result['FailedItems'] = []
        if self.failed_items is not None:
            for k in self.failed_items:
                result['FailedItems'].append(k.to_map() if k else None)
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailedCount') is not None:
            self.failed_count = m.get('FailedCount')
        self.failed_items = []
        if m.get('FailedItems') is not None:
            for k in m.get('FailedItems'):
                temp_model = DeploySDGResponseBodyDataResultFailedItems()
                self.failed_items.append(temp_model.from_map(k))
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        return self


class DeploySDGResponseBodyData(TeaModel):
    def __init__(
        self,
        message: str = None,
        result: DeploySDGResponseBodyDataResult = None,
        success: bool = None,
    ):
        # The response message. Success is returned for a successful request.
        self.message = message
        # The task result.
        self.result = result
        # Indicates whether all tasks are successful. Valid values:
        # 
        # *   true: All tasks are successful.
        # *   false: Failed tasks exist.
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.result is not None:
            result['Result'] = self.result.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Result') is not None:
            temp_model = DeploySDGResponseBodyDataResult()
            self.result = temp_model.from_map(m['Result'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeploySDGResponseBody(TeaModel):
    def __init__(
        self,
        data: DeploySDGResponseBodyData = None,
        request_id: str = None,
    ):
        # The returned data object.
        self.data = data
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DeploySDGResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeploySDGResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeploySDGResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeploySDGResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAICImagesRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        image_id: str = None,
        image_type: str = None,
        image_url: str = None,
        max_date: str = None,
        min_date: str = None,
        page_number: str = None,
        page_size: str = None,
        status: str = None,
    ):
        # The description of the image.
        self.description = description
        # The image ID of the AIC instance.
        self.image_id = image_id
        # The type of the image. Valid values:
        # 
        # *   **public**: public image
        # *   **private**: custom image
        self.image_type = image_type
        # The URL of the AIC image repository.
        self.image_url = image_url
        # The end of the time range to query. Specify the time in the 2006-01-02 format. By default, the time range to query is not restricted.
        self.max_date = max_date
        # The beginning of the time range to query. Specify the time in the 2006-01-02 format. By default, the time range to query is not restricted.
        self.min_date = min_date
        # The page number. Pages start from page **1**. Default value: **1**.
        self.page_number = page_number
        # The number of entries per page. The maximum value is **100**. Default value: **10**.
        self.page_size = page_size
        # The status of the image. Valid values:
        # 
        # *   **verifying**\
        # *   **disable**\
        # *   **available**\
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_type is not None:
            result['ImageType'] = self.image_type
        if self.image_url is not None:
            result['ImageUrl'] = self.image_url
        if self.max_date is not None:
            result['MaxDate'] = self.max_date
        if self.min_date is not None:
            result['MinDate'] = self.min_date
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageType') is not None:
            self.image_type = m.get('ImageType')
        if m.get('ImageUrl') is not None:
            self.image_url = m.get('ImageUrl')
        if m.get('MaxDate') is not None:
            self.max_date = m.get('MaxDate')
        if m.get('MinDate') is not None:
            self.min_date = m.get('MinDate')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeAICImagesResponseBodyImages(TeaModel):
    def __init__(
        self,
        android_version: str = None,
        creation_time: str = None,
        description: str = None,
        image_id: str = None,
        image_url: str = None,
        status: str = None,
        user: str = None,
    ):
        self.android_version = android_version
        # The time when the image was created.
        self.creation_time = creation_time
        # The description of the image.
        self.description = description
        # The image ID of the AIC instance.
        self.image_id = image_id
        # The URL of the AIC image repository.
        self.image_url = image_url
        # The status of the image. **Available** is returned for this parameter. Available indicates that the image is available.
        self.status = status
        # The username of the image repository.
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.android_version is not None:
            result['AndroidVersion'] = self.android_version
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_url is not None:
            result['ImageUrl'] = self.image_url
        if self.status is not None:
            result['Status'] = self.status
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AndroidVersion') is not None:
            self.android_version = m.get('AndroidVersion')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageUrl') is not None:
            self.image_url = m.get('ImageUrl')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DescribeAICImagesResponseBody(TeaModel):
    def __init__(
        self,
        images: List[DescribeAICImagesResponseBodyImages] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The information about the images.
        self.images = images
        # The page number. Default value: **1**.
        self.page_number = page_number
        # The number of entries per page.
        # 
        # Default value: 10.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.images:
            for k in self.images:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Images'] = []
        if self.images is not None:
            for k in self.images:
                result['Images'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.images = []
        if m.get('Images') is not None:
            for k in m.get('Images'):
                temp_model = DescribeAICImagesResponseBodyImages()
                self.images.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAICImagesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAICImagesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAICImagesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeARMServerInstancesRequestTags(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeARMServerInstancesRequest(TeaModel):
    def __init__(
        self,
        aicspecs: List[str] = None,
        describe_aicinstances: bool = None,
        ens_region_ids: List[str] = None,
        max_date: str = None,
        min_date: str = None,
        name: str = None,
        namespace: str = None,
        order_by_params: str = None,
        page_number: int = None,
        page_size: int = None,
        server_ids: List[str] = None,
        server_specs: List[str] = None,
        states: List[str] = None,
        tags: List[DescribeARMServerInstancesRequestTags] = None,
    ):
        # The container specifications.
        self.aicspecs = aicspecs
        # Spcifies whether the result contains the container information. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.describe_aicinstances = describe_aicinstances
        # The IDs of the Edge Node Service (ENS) nodes.
        self.ens_region_ids = ens_region_ids
        # The end of the time range to query. Specify the time in the 2006-01-02 format. By default, the time range to query is not restricted.
        self.max_date = max_date
        # The beginning of the time range to query. Specify the time in the 2006-01-02 format. By default, the time range to query is not restricted.
        self.min_date = min_date
        # The name of the server.
        self.name = name
        # The namespace.
        self.namespace = namespace
        # The sorting order of the results to return. Valid values: ServerIdSort, ServerNameSort, ExpireTimeSort, CreationTimeSort, and EnsRegionIdSort.
        # 
        # asc: ascending order. desc: descending order.
        self.order_by_params = order_by_params
        # The page number. Pages start from page **1**.
        # 
        # Default value: **1**.
        self.page_number = page_number
        # The number of entries to return on each page. Maximum value: **100**.
        # 
        # Default value: **10**.
        self.page_size = page_size
        # The IDs of the ARM servers.
        self.server_ids = server_ids
        # The server specifications.
        self.server_specs = server_specs
        # The operation statuses.
        self.states = states
        self.tags = tags

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aicspecs is not None:
            result['AICSpecs'] = self.aicspecs
        if self.describe_aicinstances is not None:
            result['DescribeAICInstances'] = self.describe_aicinstances
        if self.ens_region_ids is not None:
            result['EnsRegionIds'] = self.ens_region_ids
        if self.max_date is not None:
            result['MaxDate'] = self.max_date
        if self.min_date is not None:
            result['MinDate'] = self.min_date
        if self.name is not None:
            result['Name'] = self.name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.order_by_params is not None:
            result['OrderByParams'] = self.order_by_params
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.server_ids is not None:
            result['ServerIds'] = self.server_ids
        if self.server_specs is not None:
            result['ServerSpecs'] = self.server_specs
        if self.states is not None:
            result['States'] = self.states
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AICSpecs') is not None:
            self.aicspecs = m.get('AICSpecs')
        if m.get('DescribeAICInstances') is not None:
            self.describe_aicinstances = m.get('DescribeAICInstances')
        if m.get('EnsRegionIds') is not None:
            self.ens_region_ids = m.get('EnsRegionIds')
        if m.get('MaxDate') is not None:
            self.max_date = m.get('MaxDate')
        if m.get('MinDate') is not None:
            self.min_date = m.get('MinDate')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('OrderByParams') is not None:
            self.order_by_params = m.get('OrderByParams')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ServerIds') is not None:
            self.server_ids = m.get('ServerIds')
        if m.get('ServerSpecs') is not None:
            self.server_specs = m.get('ServerSpecs')
        if m.get('States') is not None:
            self.states = m.get('States')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = DescribeARMServerInstancesRequestTags()
                self.tags.append(temp_model.from_map(k))
        return self


class DescribeARMServerInstancesShrinkRequest(TeaModel):
    def __init__(
        self,
        aicspecs_shrink: str = None,
        describe_aicinstances: bool = None,
        ens_region_ids_shrink: str = None,
        max_date: str = None,
        min_date: str = None,
        name: str = None,
        namespace: str = None,
        order_by_params: str = None,
        page_number: int = None,
        page_size: int = None,
        server_ids_shrink: str = None,
        server_specs_shrink: str = None,
        states_shrink: str = None,
        tags_shrink: str = None,
    ):
        # The container specifications.
        self.aicspecs_shrink = aicspecs_shrink
        # Spcifies whether the result contains the container information. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.describe_aicinstances = describe_aicinstances
        # The IDs of the Edge Node Service (ENS) nodes.
        self.ens_region_ids_shrink = ens_region_ids_shrink
        # The end of the time range to query. Specify the time in the 2006-01-02 format. By default, the time range to query is not restricted.
        self.max_date = max_date
        # The beginning of the time range to query. Specify the time in the 2006-01-02 format. By default, the time range to query is not restricted.
        self.min_date = min_date
        # The name of the server.
        self.name = name
        # The namespace.
        self.namespace = namespace
        # The sorting order of the results to return. Valid values: ServerIdSort, ServerNameSort, ExpireTimeSort, CreationTimeSort, and EnsRegionIdSort.
        # 
        # asc: ascending order. desc: descending order.
        self.order_by_params = order_by_params
        # The page number. Pages start from page **1**.
        # 
        # Default value: **1**.
        self.page_number = page_number
        # The number of entries to return on each page. Maximum value: **100**.
        # 
        # Default value: **10**.
        self.page_size = page_size
        # The IDs of the ARM servers.
        self.server_ids_shrink = server_ids_shrink
        # The server specifications.
        self.server_specs_shrink = server_specs_shrink
        # The operation statuses.
        self.states_shrink = states_shrink
        self.tags_shrink = tags_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aicspecs_shrink is not None:
            result['AICSpecs'] = self.aicspecs_shrink
        if self.describe_aicinstances is not None:
            result['DescribeAICInstances'] = self.describe_aicinstances
        if self.ens_region_ids_shrink is not None:
            result['EnsRegionIds'] = self.ens_region_ids_shrink
        if self.max_date is not None:
            result['MaxDate'] = self.max_date
        if self.min_date is not None:
            result['MinDate'] = self.min_date
        if self.name is not None:
            result['Name'] = self.name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.order_by_params is not None:
            result['OrderByParams'] = self.order_by_params
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.server_ids_shrink is not None:
            result['ServerIds'] = self.server_ids_shrink
        if self.server_specs_shrink is not None:
            result['ServerSpecs'] = self.server_specs_shrink
        if self.states_shrink is not None:
            result['States'] = self.states_shrink
        if self.tags_shrink is not None:
            result['Tags'] = self.tags_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AICSpecs') is not None:
            self.aicspecs_shrink = m.get('AICSpecs')
        if m.get('DescribeAICInstances') is not None:
            self.describe_aicinstances = m.get('DescribeAICInstances')
        if m.get('EnsRegionIds') is not None:
            self.ens_region_ids_shrink = m.get('EnsRegionIds')
        if m.get('MaxDate') is not None:
            self.max_date = m.get('MaxDate')
        if m.get('MinDate') is not None:
            self.min_date = m.get('MinDate')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('OrderByParams') is not None:
            self.order_by_params = m.get('OrderByParams')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ServerIds') is not None:
            self.server_ids_shrink = m.get('ServerIds')
        if m.get('ServerSpecs') is not None:
            self.server_specs_shrink = m.get('ServerSpecs')
        if m.get('States') is not None:
            self.states_shrink = m.get('States')
        if m.get('Tags') is not None:
            self.tags_shrink = m.get('Tags')
        return self


class DescribeARMServerInstancesResponseBodyServersAICInstancesNetworkAttributes(TeaModel):
    def __init__(
        self,
        ip_address: str = None,
        network_id: str = None,
        v_switch_id: str = None,
    ):
        # The IP address of the AIC instance.
        self.ip_address = ip_address
        # The network ID of the AIC instance.
        self.network_id = network_id
        # The vSwitch ID of the AIC instance.
        self.v_switch_id = v_switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.network_id is not None:
            result['NetworkId'] = self.network_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('NetworkId') is not None:
            self.network_id = m.get('NetworkId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class DescribeARMServerInstancesResponseBodyServersAICInstancesSdgDeployInfo(TeaModel):
    def __init__(
        self,
        sdgid: str = None,
        status: str = None,
    ):
        # The ID of the SDG.
        self.sdgid = sdgid
        # The deployment status of the SDG. Valid values:
        # 
        # *   **sdg_deploying**\
        # *   **failed**\
        # *   **success**\
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sdgid is not None:
            result['SDGId'] = self.sdgid
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SDGId') is not None:
            self.sdgid = m.get('SDGId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeARMServerInstancesResponseBodyServersAICInstances(TeaModel):
    def __init__(
        self,
        frequency: int = None,
        image_id: str = None,
        instance_id: str = None,
        latest_action: str = None,
        name: str = None,
        network_attributes: DescribeARMServerInstancesResponseBodyServersAICInstancesNetworkAttributes = None,
        resolution: str = None,
        sdg_deploy_info: DescribeARMServerInstancesResponseBodyServersAICInstancesSdgDeployInfo = None,
        spec: str = None,
        state: str = None,
        status: str = None,
    ):
        # The refresh rate of the AIC instance. Unit: Hz.
        self.frequency = frequency
        # The ID of the AIC image.
        self.image_id = image_id
        # The ID of the AIC instance.
        self.instance_id = instance_id
        # The operation that was most recently performed.
        self.latest_action = latest_action
        # The name of the container.
        self.name = name
        # The network attributes of the AIC instance.
        self.network_attributes = network_attributes
        # The resolution of the AIC instance.
        self.resolution = resolution
        # The information about the shared data group (SDG) that is deployed on the AIC instance.
        self.sdg_deploy_info = sdg_deploy_info
        # The specification of the AIC instance.
        self.spec = spec
        # The operation status of the AIC instance. Valid values:
        # 
        # *   **success**\
        # *   **failed**\
        # *   **creating**\
        # *   **releasing**\
        # *   **rebooting**\
        # *   **reseting**\
        self.state = state
        # The running status of the AIC instance. Valid values:
        # 
        # *   **running**\
        # *   **pending**\
        # *   **terminating**\
        self.status = status

    def validate(self):
        if self.network_attributes:
            self.network_attributes.validate()
        if self.sdg_deploy_info:
            self.sdg_deploy_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.frequency is not None:
            result['Frequency'] = self.frequency
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.latest_action is not None:
            result['LatestAction'] = self.latest_action
        if self.name is not None:
            result['Name'] = self.name
        if self.network_attributes is not None:
            result['NetworkAttributes'] = self.network_attributes.to_map()
        if self.resolution is not None:
            result['Resolution'] = self.resolution
        if self.sdg_deploy_info is not None:
            result['SdgDeployInfo'] = self.sdg_deploy_info.to_map()
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.state is not None:
            result['State'] = self.state
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Frequency') is not None:
            self.frequency = m.get('Frequency')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LatestAction') is not None:
            self.latest_action = m.get('LatestAction')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NetworkAttributes') is not None:
            temp_model = DescribeARMServerInstancesResponseBodyServersAICInstancesNetworkAttributes()
            self.network_attributes = temp_model.from_map(m['NetworkAttributes'])
        if m.get('Resolution') is not None:
            self.resolution = m.get('Resolution')
        if m.get('SdgDeployInfo') is not None:
            temp_model = DescribeARMServerInstancesResponseBodyServersAICInstancesSdgDeployInfo()
            self.sdg_deploy_info = temp_model.from_map(m['SdgDeployInfo'])
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeARMServerInstancesResponseBodyServersTags(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeARMServerInstancesResponseBodyServers(TeaModel):
    def __init__(
        self,
        aicinstances: List[DescribeARMServerInstancesResponseBodyServersAICInstances] = None,
        creation_time: str = None,
        ens_region_id: str = None,
        expired_time: str = None,
        latest_action: str = None,
        name: str = None,
        namespace: str = None,
        pay_type: str = None,
        server_id: str = None,
        spec_name: str = None,
        state: str = None,
        status: str = None,
        tags: List[DescribeARMServerInstancesResponseBodyServersTags] = None,
    ):
        # The information about the AIC instances.
        self.aicinstances = aicinstances
        # The time when the instance was created.
        self.creation_time = creation_time
        # The ID of the ENS node.
        self.ens_region_id = ens_region_id
        # The time when the instance expires.
        self.expired_time = expired_time
        # The operation that was most recently performed.
        self.latest_action = latest_action
        # The name of the server.
        self.name = name
        # The namespace of the cluster to which the server belongs.
        self.namespace = namespace
        # The billing method.
        self.pay_type = pay_type
        # The ID of the server.
        self.server_id = server_id
        # The server specification.
        self.spec_name = spec_name
        # The operation status of the server. Valid values:
        # 
        # *   **success**\
        # *   **failed**\
        # *   **creating**\
        # *   **releasing**\
        # *   **rebooting**\
        # *   **upgrading**\
        self.state = state
        # The running status of the server. Valid values:
        # 
        # *   **running**\
        # *   **stopping**\
        # *   **down**\
        # *   **starting**\
        self.status = status
        self.tags = tags

    def validate(self):
        if self.aicinstances:
            for k in self.aicinstances:
                if k:
                    k.validate()
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AICInstances'] = []
        if self.aicinstances is not None:
            for k in self.aicinstances:
                result['AICInstances'].append(k.to_map() if k else None)
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.latest_action is not None:
            result['LatestAction'] = self.latest_action
        if self.name is not None:
            result['Name'] = self.name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.server_id is not None:
            result['ServerId'] = self.server_id
        if self.spec_name is not None:
            result['SpecName'] = self.spec_name
        if self.state is not None:
            result['State'] = self.state
        if self.status is not None:
            result['Status'] = self.status
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.aicinstances = []
        if m.get('AICInstances') is not None:
            for k in m.get('AICInstances'):
                temp_model = DescribeARMServerInstancesResponseBodyServersAICInstances()
                self.aicinstances.append(temp_model.from_map(k))
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('LatestAction') is not None:
            self.latest_action = m.get('LatestAction')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('ServerId') is not None:
            self.server_id = m.get('ServerId')
        if m.get('SpecName') is not None:
            self.spec_name = m.get('SpecName')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = DescribeARMServerInstancesResponseBodyServersTags()
                self.tags.append(temp_model.from_map(k))
        return self


class DescribeARMServerInstancesResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        servers: List[DescribeARMServerInstancesResponseBodyServers] = None,
        total_count: int = None,
    ):
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The information about the servers and the AIC instances.
        self.servers = servers
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.servers:
            for k in self.servers:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Servers'] = []
        if self.servers is not None:
            for k in self.servers:
                result['Servers'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.servers = []
        if m.get('Servers') is not None:
            for k in m.get('Servers'):
                temp_model = DescribeARMServerInstancesResponseBodyServers()
                self.servers.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeARMServerInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeARMServerInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeARMServerInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeApplicationRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        app_versions: str = None,
        level: str = None,
        out_detail_stat_params: str = None,
        resource_selector: str = None,
    ):
        # The ID of the application. You can call the ListApplications operation to obtain the application ID.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The version number of the application. Separate multiple version numbers with commas (,). If you want to query data of all versions of applications, specify All for this parameter. By default, only data of applications in the stable versions are queried.
        self.app_versions = app_versions
        # The region level by which edge resources of the application are collected. The value is of the enumeration type. Valid values:
        # 
        # *   National: Chinese mainland
        # *   Big: area
        # *   Middle: province
        # *   Small: city
        # *   RegionId: edge node
        # 
        # Default value: National.
        self.level = level
        # Specifies whether to return other information about the application, such as statistics on resource instances and pods. The value must be a JSON string. By default, all information is returned.
        self.out_detail_stat_params = out_detail_stat_params
        # The resource filtering condition.
        self.resource_selector = resource_selector

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_versions is not None:
            result['AppVersions'] = self.app_versions
        if self.level is not None:
            result['Level'] = self.level
        if self.out_detail_stat_params is not None:
            result['OutDetailStatParams'] = self.out_detail_stat_params
        if self.resource_selector is not None:
            result['ResourceSelector'] = self.resource_selector
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppVersions') is not None:
            self.app_versions = m.get('AppVersions')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('OutDetailStatParams') is not None:
            self.out_detail_stat_params = m.get('OutDetailStatParams')
        if m.get('ResourceSelector') is not None:
            self.resource_selector = m.get('ResourceSelector')
        return self


class DescribeApplicationResponseBody(TeaModel):
    def __init__(
        self,
        application: str = None,
        request_id: str = None,
    ):
        # The returned application information.
        self.application = application
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application is not None:
            result['Application'] = self.application
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Application') is not None:
            self.application = m.get('Application')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeApplicationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAvailableResourceResponseBodyImagesImage(TeaModel):
    def __init__(
        self,
        image_id: str = None,
        image_name: str = None,
    ):
        # The ID of the image.
        self.image_id = image_id
        # The name of the image.
        self.image_name = image_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        return self


class DescribeAvailableResourceResponseBodyImages(TeaModel):
    def __init__(
        self,
        image: List[DescribeAvailableResourceResponseBodyImagesImage] = None,
    ):
        self.image = image

    def validate(self):
        if self.image:
            for k in self.image:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Image'] = []
        if self.image is not None:
            for k in self.image:
                result['Image'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.image = []
        if m.get('Image') is not None:
            for k in m.get('Image'):
                temp_model = DescribeAvailableResourceResponseBodyImagesImage()
                self.image.append(temp_model.from_map(k))
        return self


class DescribeAvailableResourceResponseBodySupportResourcesSupportResource(TeaModel):
    def __init__(
        self,
        data_disk_size: str = None,
        ens_region_id: str = None,
        instance_spec: str = None,
        support_resources_count: str = None,
        system_disk_size: str = None,
    ):
        # The size of the data disk. Unit: GB.
        self.data_disk_size = data_disk_size
        # The ID of the edge node.
        self.ens_region_id = ens_region_id
        # The specifications of the resource plan.
        self.instance_spec = instance_spec
        # The number of resources that you can purchase.
        self.support_resources_count = support_resources_count
        # The size of the system disk. Unit: GiB.
        self.system_disk_size = system_disk_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_disk_size is not None:
            result['DataDiskSize'] = self.data_disk_size
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.instance_spec is not None:
            result['InstanceSpec'] = self.instance_spec
        if self.support_resources_count is not None:
            result['SupportResourcesCount'] = self.support_resources_count
        if self.system_disk_size is not None:
            result['SystemDiskSize'] = self.system_disk_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataDiskSize') is not None:
            self.data_disk_size = m.get('DataDiskSize')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('InstanceSpec') is not None:
            self.instance_spec = m.get('InstanceSpec')
        if m.get('SupportResourcesCount') is not None:
            self.support_resources_count = m.get('SupportResourcesCount')
        if m.get('SystemDiskSize') is not None:
            self.system_disk_size = m.get('SystemDiskSize')
        return self


class DescribeAvailableResourceResponseBodySupportResources(TeaModel):
    def __init__(
        self,
        support_resource: List[DescribeAvailableResourceResponseBodySupportResourcesSupportResource] = None,
    ):
        self.support_resource = support_resource

    def validate(self):
        if self.support_resource:
            for k in self.support_resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SupportResource'] = []
        if self.support_resource is not None:
            for k in self.support_resource:
                result['SupportResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.support_resource = []
        if m.get('SupportResource') is not None:
            for k in m.get('SupportResource'):
                temp_model = DescribeAvailableResourceResponseBodySupportResourcesSupportResource()
                self.support_resource.append(temp_model.from_map(k))
        return self


class DescribeAvailableResourceResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        images: DescribeAvailableResourceResponseBodyImages = None,
        request_id: str = None,
        support_resources: DescribeAvailableResourceResponseBodySupportResources = None,
    ):
        # The returned service code. 0 indicates that the request was successful.
        self.code = code
        # The details of the images.
        self.images = images
        # The ID of the request. This is a common parameter. Each request has a unique ID. You can use this ID to troubleshoot issues.
        self.request_id = request_id
        # The specifications of resources that you can purchase.
        self.support_resources = support_resources

    def validate(self):
        if self.images:
            self.images.validate()
        if self.support_resources:
            self.support_resources.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.images is not None:
            result['Images'] = self.images.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.support_resources is not None:
            result['SupportResources'] = self.support_resources.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Images') is not None:
            temp_model = DescribeAvailableResourceResponseBodyImages()
            self.images = temp_model.from_map(m['Images'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SupportResources') is not None:
            temp_model = DescribeAvailableResourceResponseBodySupportResources()
            self.support_resources = temp_model.from_map(m['SupportResources'])
        return self


class DescribeAvailableResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAvailableResourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAvailableResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAvailableResourceInfoResponseBodyImagesImage(TeaModel):
    def __init__(
        self,
        image_id: str = None,
        image_name: str = None,
        image_size: int = None,
    ):
        # The ID of the image.
        self.image_id = image_id
        # The name of the image.
        self.image_name = image_name
        # The size of the image. Unit: GB.
        self.image_size = image_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.image_size is not None:
            result['ImageSize'] = self.image_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('ImageSize') is not None:
            self.image_size = m.get('ImageSize')
        return self


class DescribeAvailableResourceInfoResponseBodyImages(TeaModel):
    def __init__(
        self,
        image: List[DescribeAvailableResourceInfoResponseBodyImagesImage] = None,
    ):
        self.image = image

    def validate(self):
        if self.image:
            for k in self.image:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Image'] = []
        if self.image is not None:
            for k in self.image:
                result['Image'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.image = []
        if m.get('Image') is not None:
            for k in m.get('Image'):
                temp_model = DescribeAvailableResourceInfoResponseBodyImagesImage()
                self.image.append(temp_model.from_map(k))
        return self


class DescribeAvailableResourceInfoResponseBodySupportResourcesSupportResourceBandwidthTypes(TeaModel):
    def __init__(
        self,
        bandwidth_type: List[str] = None,
    ):
        self.bandwidth_type = bandwidth_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth_type is not None:
            result['BandwidthType'] = self.bandwidth_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BandwidthType') is not None:
            self.bandwidth_type = m.get('BandwidthType')
        return self


class DescribeAvailableResourceInfoResponseBodySupportResourcesSupportResourceEnsRegionIds(TeaModel):
    def __init__(
        self,
        ens_region_id: List[str] = None,
    ):
        self.ens_region_id = ens_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        return self


class DescribeAvailableResourceInfoResponseBodySupportResourcesSupportResourceEnsRegionIdsExtendsEnsRegionId(TeaModel):
    def __init__(
        self,
        area: str = None,
        en_name: str = None,
        ens_region_id: str = None,
        isp: str = None,
        name: str = None,
        province: str = None,
    ):
        # The region.
        self.area = area
        # The name. This parameter is empty by default.
        self.en_name = en_name
        # The ID of the edge node.
        self.ens_region_id = ens_region_id
        # The information about the Internet service provider (ISP).
        self.isp = isp
        # The name of the edge node.
        self.name = name
        # The province.
        self.province = province

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.area is not None:
            result['Area'] = self.area
        if self.en_name is not None:
            result['EnName'] = self.en_name
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.name is not None:
            result['Name'] = self.name
        if self.province is not None:
            result['Province'] = self.province
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Area') is not None:
            self.area = m.get('Area')
        if m.get('EnName') is not None:
            self.en_name = m.get('EnName')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        return self


class DescribeAvailableResourceInfoResponseBodySupportResourcesSupportResourceEnsRegionIdsExtends(TeaModel):
    def __init__(
        self,
        ens_region_id: List[DescribeAvailableResourceInfoResponseBodySupportResourcesSupportResourceEnsRegionIdsExtendsEnsRegionId] = None,
    ):
        self.ens_region_id = ens_region_id

    def validate(self):
        if self.ens_region_id:
            for k in self.ens_region_id:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EnsRegionId'] = []
        if self.ens_region_id is not None:
            for k in self.ens_region_id:
                result['EnsRegionId'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ens_region_id = []
        if m.get('EnsRegionId') is not None:
            for k in m.get('EnsRegionId'):
                temp_model = DescribeAvailableResourceInfoResponseBodySupportResourcesSupportResourceEnsRegionIdsExtendsEnsRegionId()
                self.ens_region_id.append(temp_model.from_map(k))
        return self


class DescribeAvailableResourceInfoResponseBodySupportResourcesSupportResourceInstanceSpeces(TeaModel):
    def __init__(
        self,
        instance_spec: List[str] = None,
    ):
        self.instance_spec = instance_spec

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_spec is not None:
            result['InstanceSpec'] = self.instance_spec
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceSpec') is not None:
            self.instance_spec = m.get('InstanceSpec')
        return self


class DescribeAvailableResourceInfoResponseBodySupportResourcesSupportResourceIsp(TeaModel):
    def __init__(
        self,
        isp: List[str] = None,
    ):
        self.isp = isp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.isp is not None:
            result['Isp'] = self.isp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        return self


class DescribeAvailableResourceInfoResponseBodySupportResourcesSupportResource(TeaModel):
    def __init__(
        self,
        bandwidth_types: DescribeAvailableResourceInfoResponseBodySupportResourcesSupportResourceBandwidthTypes = None,
        data_disk_max_size: int = None,
        data_disk_min_size: int = None,
        ens_region_ids: DescribeAvailableResourceInfoResponseBodySupportResourcesSupportResourceEnsRegionIds = None,
        ens_region_ids_extends: DescribeAvailableResourceInfoResponseBodySupportResourcesSupportResourceEnsRegionIdsExtends = None,
        instance_speces: DescribeAvailableResourceInfoResponseBodySupportResourcesSupportResourceInstanceSpeces = None,
        isp: DescribeAvailableResourceInfoResponseBodySupportResourcesSupportResourceIsp = None,
        system_disk_max_size: int = None,
        system_disk_min_size: int = None,
    ):
        # Bandwidth billing method.
        self.bandwidth_types = bandwidth_types
        # The maximum capacity of a data disk. Unit: GB.
        self.data_disk_max_size = data_disk_max_size
        # The minimum data disk size. Unit: GiB.
        self.data_disk_min_size = data_disk_min_size
        # node ID
        self.ens_region_ids = ens_region_ids
        # The supplementary information about the edge nodes.
        self.ens_region_ids_extends = ens_region_ids_extends
        self.instance_speces = instance_speces
        # Operator
        self.isp = isp
        # The maximum size of the system disk. Unit: GiB.
        self.system_disk_max_size = system_disk_max_size
        # The minimum capacity of a system disk. Unit: GB.
        self.system_disk_min_size = system_disk_min_size

    def validate(self):
        if self.bandwidth_types:
            self.bandwidth_types.validate()
        if self.ens_region_ids:
            self.ens_region_ids.validate()
        if self.ens_region_ids_extends:
            self.ens_region_ids_extends.validate()
        if self.instance_speces:
            self.instance_speces.validate()
        if self.isp:
            self.isp.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth_types is not None:
            result['BandwidthTypes'] = self.bandwidth_types.to_map()
        if self.data_disk_max_size is not None:
            result['DataDiskMaxSize'] = self.data_disk_max_size
        if self.data_disk_min_size is not None:
            result['DataDiskMinSize'] = self.data_disk_min_size
        if self.ens_region_ids is not None:
            result['EnsRegionIds'] = self.ens_region_ids.to_map()
        if self.ens_region_ids_extends is not None:
            result['EnsRegionIdsExtends'] = self.ens_region_ids_extends.to_map()
        if self.instance_speces is not None:
            result['InstanceSpeces'] = self.instance_speces.to_map()
        if self.isp is not None:
            result['Isp'] = self.isp.to_map()
        if self.system_disk_max_size is not None:
            result['SystemDiskMaxSize'] = self.system_disk_max_size
        if self.system_disk_min_size is not None:
            result['SystemDiskMinSize'] = self.system_disk_min_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BandwidthTypes') is not None:
            temp_model = DescribeAvailableResourceInfoResponseBodySupportResourcesSupportResourceBandwidthTypes()
            self.bandwidth_types = temp_model.from_map(m['BandwidthTypes'])
        if m.get('DataDiskMaxSize') is not None:
            self.data_disk_max_size = m.get('DataDiskMaxSize')
        if m.get('DataDiskMinSize') is not None:
            self.data_disk_min_size = m.get('DataDiskMinSize')
        if m.get('EnsRegionIds') is not None:
            temp_model = DescribeAvailableResourceInfoResponseBodySupportResourcesSupportResourceEnsRegionIds()
            self.ens_region_ids = temp_model.from_map(m['EnsRegionIds'])
        if m.get('EnsRegionIdsExtends') is not None:
            temp_model = DescribeAvailableResourceInfoResponseBodySupportResourcesSupportResourceEnsRegionIdsExtends()
            self.ens_region_ids_extends = temp_model.from_map(m['EnsRegionIdsExtends'])
        if m.get('InstanceSpeces') is not None:
            temp_model = DescribeAvailableResourceInfoResponseBodySupportResourcesSupportResourceInstanceSpeces()
            self.instance_speces = temp_model.from_map(m['InstanceSpeces'])
        if m.get('Isp') is not None:
            temp_model = DescribeAvailableResourceInfoResponseBodySupportResourcesSupportResourceIsp()
            self.isp = temp_model.from_map(m['Isp'])
        if m.get('SystemDiskMaxSize') is not None:
            self.system_disk_max_size = m.get('SystemDiskMaxSize')
        if m.get('SystemDiskMinSize') is not None:
            self.system_disk_min_size = m.get('SystemDiskMinSize')
        return self


class DescribeAvailableResourceInfoResponseBodySupportResources(TeaModel):
    def __init__(
        self,
        support_resource: List[DescribeAvailableResourceInfoResponseBodySupportResourcesSupportResource] = None,
    ):
        self.support_resource = support_resource

    def validate(self):
        if self.support_resource:
            for k in self.support_resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SupportResource'] = []
        if self.support_resource is not None:
            for k in self.support_resource:
                result['SupportResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.support_resource = []
        if m.get('SupportResource') is not None:
            for k in m.get('SupportResource'):
                temp_model = DescribeAvailableResourceInfoResponseBodySupportResourcesSupportResource()
                self.support_resource.append(temp_model.from_map(k))
        return self


class DescribeAvailableResourceInfoResponseBody(TeaModel):
    def __init__(
        self,
        images: DescribeAvailableResourceInfoResponseBodyImages = None,
        request_id: str = None,
        support_resources: DescribeAvailableResourceInfoResponseBodySupportResources = None,
    ):
        # The information about the image.
        self.images = images
        # The request ID.
        self.request_id = request_id
        # The specifications of resources that you can purchase.
        self.support_resources = support_resources

    def validate(self):
        if self.images:
            self.images.validate()
        if self.support_resources:
            self.support_resources.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.images is not None:
            result['Images'] = self.images.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.support_resources is not None:
            result['SupportResources'] = self.support_resources.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Images') is not None:
            temp_model = DescribeAvailableResourceInfoResponseBodyImages()
            self.images = temp_model.from_map(m['Images'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SupportResources') is not None:
            temp_model = DescribeAvailableResourceInfoResponseBodySupportResources()
            self.support_resources = temp_model.from_map(m['SupportResources'])
        return self


class DescribeAvailableResourceInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAvailableResourceInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAvailableResourceInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBandWithdChargeTypeResponseBody(TeaModel):
    def __init__(
        self,
        band_with_type_info: str = None,
        charge_contract_type: str = None,
        charge_cycle_info: str = None,
        code: int = None,
        request_id: str = None,
    ):
        # The information about the metering method.
        self.band_with_type_info = band_with_type_info
        # The metering type.
        # 
        # *   ChargeByUnified: unified metering.
        # *   ChargeByGrade: differential metering.
        self.charge_contract_type = charge_contract_type
        # The metering cycle. Currently, this parameter is empty in the response.
        self.charge_cycle_info = charge_cycle_info
        # The returned service code. A value of 0 indicates that the operation was successful.
        self.code = code
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.band_with_type_info is not None:
            result['BandWithTypeInfo'] = self.band_with_type_info
        if self.charge_contract_type is not None:
            result['ChargeContractType'] = self.charge_contract_type
        if self.charge_cycle_info is not None:
            result['ChargeCycleInfo'] = self.charge_cycle_info
        if self.code is not None:
            result['Code'] = self.code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BandWithTypeInfo') is not None:
            self.band_with_type_info = m.get('BandWithTypeInfo')
        if m.get('ChargeContractType') is not None:
            self.charge_contract_type = m.get('ChargeContractType')
        if m.get('ChargeCycleInfo') is not None:
            self.charge_cycle_info = m.get('ChargeCycleInfo')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBandWithdChargeTypeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeBandWithdChargeTypeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBandWithdChargeTypeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBandwitdhByInternetChargeTypeRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        ens_region_id: str = None,
        isp: str = None,
        start_time: str = None,
    ):
        # The end of the time range to query.
        # 
        # *   Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # *   If the value of the seconds place is not 00, the start time is automatically set to the next minute.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The region ID of the instance.
        self.ens_region_id = ens_region_id
        # The Internet service provider (ISP). Valid values:
        # 
        # *   cmcc: China Mobile
        # *   telecom: China Telecom
        # *   unicom: China Unicom
        # *   multiCarrier: multi-line ISP
        self.isp = isp
        # The beginning of the time range to query.
        # 
        # *   Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # *   If the value of the seconds place is not 00, the start time is automatically set to the next minute.
        # 
        # This parameter is required.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeBandwitdhByInternetChargeTypeResponseBody(TeaModel):
    def __init__(
        self,
        bandwidth_value: int = None,
        internet_charge_type: str = None,
        request_id: str = None,
        time_stamp: str = None,
    ):
        # The bandwidth. Unit: bit/s.
        self.bandwidth_value = bandwidth_value
        # The metering method. Valid values:
        # 
        # *   BandwidthByDay: Pay by daily peak bandwidth
        # *   95BandwidthByMonth: Pay by monthly 95th percentile bandwidth
        # *   PayByBandwidth4thMonth: Pay by monthly fourth peak bandwidth
        # *   PayByBandwidth: Pay by fixed bandwidth
        # 
        # You can specify only one metering method for network usage and cannot overwrite the existing metering method.
        self.internet_charge_type = internet_charge_type
        # The ID of the request. This parameter is a common parameter. Each request has a unique ID. You can use the ID to troubleshoot issues.
        self.request_id = request_id
        # The timestamp. The time follows the ISO 8601 standard. The time is displayed in UTC. Example: 2016-10-20T04:00:00Z.
        self.time_stamp = time_stamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth_value is not None:
            result['BandwidthValue'] = self.bandwidth_value
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BandwidthValue') is not None:
            self.bandwidth_value = m.get('BandwidthValue')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeBandwitdhByInternetChargeTypeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeBandwitdhByInternetChargeTypeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBandwitdhByInternetChargeTypeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudDiskAvailableResourceInfoResponseBodySupportResourcesSupportResourceAbility(TeaModel):
    def __init__(
        self,
        ability: List[str] = None,
    ):
        self.ability = ability

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ability is not None:
            result['Ability'] = self.ability
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ability') is not None:
            self.ability = m.get('Ability')
        return self


class DescribeCloudDiskAvailableResourceInfoResponseBodySupportResourcesSupportResource(TeaModel):
    def __init__(
        self,
        ability: DescribeCloudDiskAvailableResourceInfoResponseBodySupportResourcesSupportResourceAbility = None,
        can_buy_count: int = None,
        category: str = None,
        default_disk_size: int = None,
        disk_max_size: int = None,
        disk_min_size: int = None,
        ens_region_id: str = None,
        ens_region_name: str = None,
    ):
        # Node product capability.
        self.ability = ability
        # The number of disks that you can purchase.
        self.can_buy_count = can_buy_count
        # The type of the disk.
        # 
        # *   cloud_efficiency:ultra disk.
        # *   cloud_ssd:all-flash disk.
        # *   local_hdd:local HDD.
        # *   local_ssd:local SSD.
        self.category = category
        # The default size of the disk. Unit: GiB.
        self.default_disk_size = default_disk_size
        # The maximum size of the disk. Unit: GiB.
        self.disk_max_size = disk_max_size
        # The minimum size of the disk size. Unit: GiB.
        self.disk_min_size = disk_min_size
        # The ID of the edge node.
        self.ens_region_id = ens_region_id
        # The name of the task node.
        self.ens_region_name = ens_region_name

    def validate(self):
        if self.ability:
            self.ability.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ability is not None:
            result['Ability'] = self.ability.to_map()
        if self.can_buy_count is not None:
            result['CanBuyCount'] = self.can_buy_count
        if self.category is not None:
            result['Category'] = self.category
        if self.default_disk_size is not None:
            result['DefaultDiskSize'] = self.default_disk_size
        if self.disk_max_size is not None:
            result['DiskMaxSize'] = self.disk_max_size
        if self.disk_min_size is not None:
            result['DiskMinSize'] = self.disk_min_size
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.ens_region_name is not None:
            result['EnsRegionName'] = self.ens_region_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ability') is not None:
            temp_model = DescribeCloudDiskAvailableResourceInfoResponseBodySupportResourcesSupportResourceAbility()
            self.ability = temp_model.from_map(m['Ability'])
        if m.get('CanBuyCount') is not None:
            self.can_buy_count = m.get('CanBuyCount')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DefaultDiskSize') is not None:
            self.default_disk_size = m.get('DefaultDiskSize')
        if m.get('DiskMaxSize') is not None:
            self.disk_max_size = m.get('DiskMaxSize')
        if m.get('DiskMinSize') is not None:
            self.disk_min_size = m.get('DiskMinSize')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('EnsRegionName') is not None:
            self.ens_region_name = m.get('EnsRegionName')
        return self


class DescribeCloudDiskAvailableResourceInfoResponseBodySupportResources(TeaModel):
    def __init__(
        self,
        support_resource: List[DescribeCloudDiskAvailableResourceInfoResponseBodySupportResourcesSupportResource] = None,
    ):
        self.support_resource = support_resource

    def validate(self):
        if self.support_resource:
            for k in self.support_resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SupportResource'] = []
        if self.support_resource is not None:
            for k in self.support_resource:
                result['SupportResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.support_resource = []
        if m.get('SupportResource') is not None:
            for k in m.get('SupportResource'):
                temp_model = DescribeCloudDiskAvailableResourceInfoResponseBodySupportResourcesSupportResource()
                self.support_resource.append(temp_model.from_map(k))
        return self


class DescribeCloudDiskAvailableResourceInfoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        support_resources: DescribeCloudDiskAvailableResourceInfoResponseBodySupportResources = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The specifications of resources that you can purchase.
        self.support_resources = support_resources

    def validate(self):
        if self.support_resources:
            self.support_resources.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.support_resources is not None:
            result['SupportResources'] = self.support_resources.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SupportResources') is not None:
            temp_model = DescribeCloudDiskAvailableResourceInfoResponseBodySupportResources()
            self.support_resources = temp_model.from_map(m['SupportResources'])
        return self


class DescribeCloudDiskAvailableResourceInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCloudDiskAvailableResourceInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCloudDiskAvailableResourceInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudDiskTypesRequest(TeaModel):
    def __init__(
        self,
        ens_region_id: str = None,
        ens_region_ids: List[str] = None,
    ):
        # The ID of the edge node.
        self.ens_region_id = ens_region_id
        # The edge nodes.
        self.ens_region_ids = ens_region_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.ens_region_ids is not None:
            result['EnsRegionIds'] = self.ens_region_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('EnsRegionIds') is not None:
            self.ens_region_ids = m.get('EnsRegionIds')
        return self


class DescribeCloudDiskTypesShrinkRequest(TeaModel):
    def __init__(
        self,
        ens_region_id: str = None,
        ens_region_ids_shrink: str = None,
    ):
        # The ID of the edge node.
        self.ens_region_id = ens_region_id
        # The edge nodes.
        self.ens_region_ids_shrink = ens_region_ids_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.ens_region_ids_shrink is not None:
            result['EnsRegionIds'] = self.ens_region_ids_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('EnsRegionIds') is not None:
            self.ens_region_ids_shrink = m.get('EnsRegionIds')
        return self


class DescribeCloudDiskTypesResponseBodySupportResourcesSupportResource(TeaModel):
    def __init__(
        self,
        category: str = None,
        ens_region_id: str = None,
    ):
        # The category of the disk.
        # 
        # *   cloud_efficiency: ultra disk.
        # *   cloud_ssd: all-flash disk.
        # *   local_hdd: local HDD.
        # *   local_ssd: local SSD.
        self.category = category
        # The ID of the edge node.
        self.ens_region_id = ens_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        return self


class DescribeCloudDiskTypesResponseBodySupportResources(TeaModel):
    def __init__(
        self,
        support_resource: List[DescribeCloudDiskTypesResponseBodySupportResourcesSupportResource] = None,
    ):
        self.support_resource = support_resource

    def validate(self):
        if self.support_resource:
            for k in self.support_resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SupportResource'] = []
        if self.support_resource is not None:
            for k in self.support_resource:
                result['SupportResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.support_resource = []
        if m.get('SupportResource') is not None:
            for k in m.get('SupportResource'):
                temp_model = DescribeCloudDiskTypesResponseBodySupportResourcesSupportResource()
                self.support_resource.append(temp_model.from_map(k))
        return self


class DescribeCloudDiskTypesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        support_resources: DescribeCloudDiskTypesResponseBodySupportResources = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The specifications of resources that you can purchase.
        self.support_resources = support_resources

    def validate(self):
        if self.support_resources:
            self.support_resources.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.support_resources is not None:
            result['SupportResources'] = self.support_resources.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SupportResources') is not None:
            temp_model = DescribeCloudDiskTypesResponseBodySupportResources()
            self.support_resources = temp_model.from_map(m['SupportResources'])
        return self


class DescribeCloudDiskTypesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCloudDiskTypesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCloudDiskTypesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
    ):
        # The cluster ID.
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeClusterResponseBodyClusters(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        current_version: str = None,
        name: str = None,
        next_version: str = None,
        status: str = None,
    ):
        # The cluster ID.
        self.cluster_id = cluster_id
        # The version of the cluster.
        self.current_version = current_version
        # The cluster name.
        self.name = name
        # The next version of the cluster.
        self.next_version = next_version
        # The health status of the instance.
        # 
        # Valid values:
        # 
        # *   healthy
        # *   unhealthy
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.current_version is not None:
            result['CurrentVersion'] = self.current_version
        if self.name is not None:
            result['Name'] = self.name
        if self.next_version is not None:
            result['NextVersion'] = self.next_version
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('CurrentVersion') is not None:
            self.current_version = m.get('CurrentVersion')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NextVersion') is not None:
            self.next_version = m.get('NextVersion')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeClusterResponseBody(TeaModel):
    def __init__(
        self,
        clusters: List[DescribeClusterResponseBodyClusters] = None,
        request_id: str = None,
    ):
        # An array that consists of the information about clusters.
        self.clusters = clusters
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.clusters:
            for k in self.clusters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Clusters'] = []
        if self.clusters is not None:
            for k in self.clusters:
                result['Clusters'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.clusters = []
        if m.get('Clusters') is not None:
            for k in m.get('Clusters'):
                temp_model = DescribeClusterResponseBodyClusters()
                self.clusters.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeClusterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeClusterResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterKubeConfigRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
    ):
        # The cluster ID.
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeClusterKubeConfigResponseBody(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        kubeconfig: str = None,
        request_id: str = None,
    ):
        # The cluster ID.
        self.cluster_id = cluster_id
        # The cluster certificate.
        self.kubeconfig = kubeconfig
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.kubeconfig is not None:
            result['Kubeconfig'] = self.kubeconfig
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Kubeconfig') is not None:
            self.kubeconfig = m.get('Kubeconfig')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeClusterKubeConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeClusterKubeConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeClusterKubeConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCreatePrePaidInstanceResultRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        # The ID of the instance. You can call the CreateIntance operation to create an instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeCreatePrePaidInstanceResultResponseBodyInstanceCreateResult(TeaModel):
    def __init__(
        self,
        instance_create_status: str = None,
        instance_id: str = None,
    ):
        # The status of the instance creation.
        # 
        # *   Accepted
        # *   Creating
        # *   Failed
        # *   Successed
        self.instance_create_status = instance_create_status
        # The ID of the instance.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_create_status is not None:
            result['InstanceCreateStatus'] = self.instance_create_status
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceCreateStatus') is not None:
            self.instance_create_status = m.get('InstanceCreateStatus')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeCreatePrePaidInstanceResultResponseBody(TeaModel):
    def __init__(
        self,
        instance_create_result: DescribeCreatePrePaidInstanceResultResponseBodyInstanceCreateResult = None,
        request_id: str = None,
    ):
        # Returned results of creating an instance.
        self.instance_create_result = instance_create_result
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.instance_create_result:
            self.instance_create_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_create_result is not None:
            result['InstanceCreateResult'] = self.instance_create_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceCreateResult') is not None:
            temp_model = DescribeCreatePrePaidInstanceResultResponseBodyInstanceCreateResult()
            self.instance_create_result = temp_model.from_map(m['InstanceCreateResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCreatePrePaidInstanceResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCreatePrePaidInstanceResultResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCreatePrePaidInstanceResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDataDistResultRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        data_names: str = None,
        data_versions: str = None,
        ens_region_ids: List[str] = None,
        instance_ids: str = None,
        max_date: str = None,
        min_date: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The ID of the application.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The name of the data file. Separate multiple names with commas (,). By default, all data files are queried.
        self.data_names = data_names
        # The version number of the data file. Separate multiple numbers with commas (,). By default, all versions of data files are queried.
        self.data_versions = data_versions
        # The IDs of the ENS nodes.
        self.ens_region_ids = ens_region_ids
        # The IDs of ENS instances. Separate multiple IDs with commas (,). By default, all instances are queried.
        self.instance_ids = instance_ids
        # The end of the time range to query. Specify the time in the 2006-01-02 format. By default, the time range to query is not restricted.
        self.max_date = max_date
        # The beginning of the time range to query. Specify the time in the 2006-01-02 format. By default, the time range to query is not restricted.
        self.min_date = min_date
        # The page number. Pages start from page 1. This parameter is optional if you want to return the push status of all data files.
        self.page_number = page_number
        # The number of entries per page. This parameter is optional if you want to return the distribution status of all data files.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.data_names is not None:
            result['DataNames'] = self.data_names
        if self.data_versions is not None:
            result['DataVersions'] = self.data_versions
        if self.ens_region_ids is not None:
            result['EnsRegionIds'] = self.ens_region_ids
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.max_date is not None:
            result['MaxDate'] = self.max_date
        if self.min_date is not None:
            result['MinDate'] = self.min_date
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('DataNames') is not None:
            self.data_names = m.get('DataNames')
        if m.get('DataVersions') is not None:
            self.data_versions = m.get('DataVersions')
        if m.get('EnsRegionIds') is not None:
            self.ens_region_ids = m.get('EnsRegionIds')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('MaxDate') is not None:
            self.max_date = m.get('MaxDate')
        if m.get('MinDate') is not None:
            self.min_date = m.get('MinDate')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeDataDistResultShrinkRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        data_names: str = None,
        data_versions: str = None,
        ens_region_ids_shrink: str = None,
        instance_ids: str = None,
        max_date: str = None,
        min_date: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The ID of the application.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The name of the data file. Separate multiple names with commas (,). By default, all data files are queried.
        self.data_names = data_names
        # The version number of the data file. Separate multiple numbers with commas (,). By default, all versions of data files are queried.
        self.data_versions = data_versions
        # The IDs of the ENS nodes.
        self.ens_region_ids_shrink = ens_region_ids_shrink
        # The IDs of ENS instances. Separate multiple IDs with commas (,). By default, all instances are queried.
        self.instance_ids = instance_ids
        # The end of the time range to query. Specify the time in the 2006-01-02 format. By default, the time range to query is not restricted.
        self.max_date = max_date
        # The beginning of the time range to query. Specify the time in the 2006-01-02 format. By default, the time range to query is not restricted.
        self.min_date = min_date
        # The page number. Pages start from page 1. This parameter is optional if you want to return the push status of all data files.
        self.page_number = page_number
        # The number of entries per page. This parameter is optional if you want to return the distribution status of all data files.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.data_names is not None:
            result['DataNames'] = self.data_names
        if self.data_versions is not None:
            result['DataVersions'] = self.data_versions
        if self.ens_region_ids_shrink is not None:
            result['EnsRegionIds'] = self.ens_region_ids_shrink
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.max_date is not None:
            result['MaxDate'] = self.max_date
        if self.min_date is not None:
            result['MinDate'] = self.min_date
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('DataNames') is not None:
            self.data_names = m.get('DataNames')
        if m.get('DataVersions') is not None:
            self.data_versions = m.get('DataVersions')
        if m.get('EnsRegionIds') is not None:
            self.ens_region_ids_shrink = m.get('EnsRegionIds')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('MaxDate') is not None:
            self.max_date = m.get('MaxDate')
        if m.get('MinDate') is not None:
            self.min_date = m.get('MinDate')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeDataDistResultResponseBodyDistResultsDistResultStatusStatsStatusStatInstancesInstance(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        start_time: str = None,
        status_descrip: str = None,
        update_time: str = None,
    ):
        # The ID of the instance
        self.instance_id = instance_id
        # The start time of the distribution. The time is displayed in UTC.
        self.start_time = start_time
        # The description of the distribution status.
        self.status_descrip = status_descrip
        # The time when the distribution status was last updated. The time is displayed in UTC.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status_descrip is not None:
            result['StatusDescrip'] = self.status_descrip
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StatusDescrip') is not None:
            self.status_descrip = m.get('StatusDescrip')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeDataDistResultResponseBodyDistResultsDistResultStatusStatsStatusStatInstances(TeaModel):
    def __init__(
        self,
        instance: List[DescribeDataDistResultResponseBodyDistResultsDistResultStatusStatsStatusStatInstancesInstance] = None,
    ):
        self.instance = instance

    def validate(self):
        if self.instance:
            for k in self.instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Instance'] = []
        if self.instance is not None:
            for k in self.instance:
                result['Instance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instance = []
        if m.get('Instance') is not None:
            for k in m.get('Instance'):
                temp_model = DescribeDataDistResultResponseBodyDistResultsDistResultStatusStatsStatusStatInstancesInstance()
                self.instance.append(temp_model.from_map(k))
        return self


class DescribeDataDistResultResponseBodyDistResultsDistResultStatusStatsStatusStat(TeaModel):
    def __init__(
        self,
        instance_count: str = None,
        instances: DescribeDataDistResultResponseBodyDistResultsDistResultStatusStatsStatusStatInstances = None,
        status: str = None,
    ):
        # The number of associated edge instances.
        self.instance_count = instance_count
        # The distribution status of the edge instance.
        self.instances = instances
        # The distribution status. The value is of the enumeration type. Valid values:
        # 
        # *   SUCCESS: The distribution is successful.
        # *   FAILED: The distribution failed.
        # *   DISTING: The data is being distributed.
        # *   POD_RESTARTING: The idle pod is being restarted.
        # *   DELETED: The data is cleared or removed.
        self.status = status

    def validate(self):
        if self.instances:
            self.instances.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.instances is not None:
            result['Instances'] = self.instances.to_map()
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('Instances') is not None:
            temp_model = DescribeDataDistResultResponseBodyDistResultsDistResultStatusStatsStatusStatInstances()
            self.instances = temp_model.from_map(m['Instances'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDataDistResultResponseBodyDistResultsDistResultStatusStats(TeaModel):
    def __init__(
        self,
        status_stat: List[DescribeDataDistResultResponseBodyDistResultsDistResultStatusStatsStatusStat] = None,
    ):
        self.status_stat = status_stat

    def validate(self):
        if self.status_stat:
            for k in self.status_stat:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['StatusStat'] = []
        if self.status_stat is not None:
            for k in self.status_stat:
                result['StatusStat'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.status_stat = []
        if m.get('StatusStat') is not None:
            for k in m.get('StatusStat'):
                temp_model = DescribeDataDistResultResponseBodyDistResultsDistResultStatusStatsStatusStat()
                self.status_stat.append(temp_model.from_map(k))
        return self


class DescribeDataDistResultResponseBodyDistResultsDistResult(TeaModel):
    def __init__(
        self,
        name: str = None,
        status_stats: DescribeDataDistResultResponseBodyDistResultsDistResultStatusStats = None,
        version: str = None,
    ):
        # The name of the data file.
        self.name = name
        # The distribution status statistics.
        self.status_stats = status_stats
        # The version number of the data file.
        self.version = version

    def validate(self):
        if self.status_stats:
            self.status_stats.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.status_stats is not None:
            result['StatusStats'] = self.status_stats.to_map()
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('StatusStats') is not None:
            temp_model = DescribeDataDistResultResponseBodyDistResultsDistResultStatusStats()
            self.status_stats = temp_model.from_map(m['StatusStats'])
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class DescribeDataDistResultResponseBodyDistResults(TeaModel):
    def __init__(
        self,
        dist_result: List[DescribeDataDistResultResponseBodyDistResultsDistResult] = None,
    ):
        self.dist_result = dist_result

    def validate(self):
        if self.dist_result:
            for k in self.dist_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DistResult'] = []
        if self.dist_result is not None:
            for k in self.dist_result:
                result['DistResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dist_result = []
        if m.get('DistResult') is not None:
            for k in m.get('DistResult'):
                temp_model = DescribeDataDistResultResponseBodyDistResultsDistResult()
                self.dist_result.append(temp_model.from_map(k))
        return self


class DescribeDataDistResultResponseBody(TeaModel):
    def __init__(
        self,
        dist_results: DescribeDataDistResultResponseBodyDistResults = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The distribution status of data files on edge instances.
        self.dist_results = dist_results
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.dist_results:
            self.dist_results.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dist_results is not None:
            result['DistResults'] = self.dist_results.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistResults') is not None:
            temp_model = DescribeDataDistResultResponseBodyDistResults()
            self.dist_results = temp_model.from_map(m['DistResults'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDataDistResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDataDistResultResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDataDistResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDataDownloadURLRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        data_name: str = None,
        data_version: str = None,
        expire_timeout: int = None,
        server_filter_strategy: str = None,
    ):
        # The ID of the application.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The name of the data file.
        # 
        # This parameter is required.
        self.data_name = data_name
        # The version number of the data file.
        # 
        # This parameter is required.
        self.data_version = data_version
        # This parameter is reserved.
        self.expire_timeout = expire_timeout
        # The condition that you want to use to filter file servers. You can specify multiple canary release policies. By default, all resources are queried.
        self.server_filter_strategy = server_filter_strategy

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.data_name is not None:
            result['DataName'] = self.data_name
        if self.data_version is not None:
            result['DataVersion'] = self.data_version
        if self.expire_timeout is not None:
            result['ExpireTimeout'] = self.expire_timeout
        if self.server_filter_strategy is not None:
            result['ServerFilterStrategy'] = self.server_filter_strategy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('DataName') is not None:
            self.data_name = m.get('DataName')
        if m.get('DataVersion') is not None:
            self.data_version = m.get('DataVersion')
        if m.get('ExpireTimeout') is not None:
            self.expire_timeout = m.get('ExpireTimeout')
        if m.get('ServerFilterStrategy') is not None:
            self.server_filter_strategy = m.get('ServerFilterStrategy')
        return self


class DescribeDataDownloadURLResponseBodyDataServerList(TeaModel):
    def __init__(
        self,
        host: str = None,
        region_id: str = None,
    ):
        # The host address of the file server.
        self.host = host
        # The ID of the Edge Node Service (ENS) node.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host is not None:
            result['Host'] = self.host
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeDataDownloadURLResponseBodyData(TeaModel):
    def __init__(
        self,
        expire_time: str = None,
        server_list: List[DescribeDataDownloadURLResponseBodyDataServerList] = None,
        url: str = None,
    ):
        # The time when the data file expires. The time is displayed in UTC.
        self.expire_time = expire_time
        # The file servers.
        self.server_list = server_list
        # The download URL of the data file.
        self.url = url

    def validate(self):
        if self.server_list:
            for k in self.server_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        result['ServerList'] = []
        if self.server_list is not None:
            for k in self.server_list:
                result['ServerList'].append(k.to_map() if k else None)
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        self.server_list = []
        if m.get('ServerList') is not None:
            for k in m.get('ServerList'):
                temp_model = DescribeDataDownloadURLResponseBodyDataServerList()
                self.server_list.append(temp_model.from_map(k))
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class DescribeDataDownloadURLResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: DescribeDataDownloadURLResponseBodyData = None,
        message: str = None,
        request_id: str = None,
    ):
        # The HTTP status code.
        self.code = code
        # The download URLs of data files.
        self.data = data
        # The response message. Success is returned for a successful request.
        self.message = message
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeDataDownloadURLResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDataDownloadURLResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDataDownloadURLResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDataDownloadURLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDataPushResultRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        data_names: str = None,
        data_versions: str = None,
        max_date: str = None,
        min_date: str = None,
        page_number: int = None,
        page_size: int = None,
        region_ids: str = None,
    ):
        # The ID of the application.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The name of the data file. Separate multiple names with commas (,). By default, all data files are queried.
        self.data_names = data_names
        # The version number of the data file. Separate multiple numbers with commas (,). By default, all versions of data files are queried.
        self.data_versions = data_versions
        # The end of the time range to query. Specify the time in the 2006-01-02 format. By default, the time range to query is not restricted.
        self.max_date = max_date
        # The beginning of the time range to query. Specify the time in the 2006-01-02 format. By default, the time range to query is not restricted.
        self.min_date = min_date
        self.page_number = page_number
        # The number of entries per page. This parameter is optional if you want to return the push status of all data files.
        self.page_size = page_size
        # The IDs of ENS nodes. Separate multiple IDs with commas (,). By default, all ENS nodes are queried.
        self.region_ids = region_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.data_names is not None:
            result['DataNames'] = self.data_names
        if self.data_versions is not None:
            result['DataVersions'] = self.data_versions
        if self.max_date is not None:
            result['MaxDate'] = self.max_date
        if self.min_date is not None:
            result['MinDate'] = self.min_date
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_ids is not None:
            result['RegionIds'] = self.region_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('DataNames') is not None:
            self.data_names = m.get('DataNames')
        if m.get('DataVersions') is not None:
            self.data_versions = m.get('DataVersions')
        if m.get('MaxDate') is not None:
            self.max_date = m.get('MaxDate')
        if m.get('MinDate') is not None:
            self.min_date = m.get('MinDate')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionIds') is not None:
            self.region_ids = m.get('RegionIds')
        return self


class DescribeDataPushResultResponseBodyPushResultsPushResultStatusStatSStatusStatRegionIdsRegionId(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        start_time: str = None,
        status_descrip: str = None,
        update_time: str = None,
    ):
        # The ID of the ENS node.
        self.region_id = region_id
        # The start time of the push operation. The time is displayed in UTC.
        self.start_time = start_time
        # The description of the status.
        self.status_descrip = status_descrip
        # The time when the status was last updated. The time is displayed in UTC.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status_descrip is not None:
            result['StatusDescrip'] = self.status_descrip
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StatusDescrip') is not None:
            self.status_descrip = m.get('StatusDescrip')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeDataPushResultResponseBodyPushResultsPushResultStatusStatSStatusStatRegionIds(TeaModel):
    def __init__(
        self,
        region_id: List[DescribeDataPushResultResponseBodyPushResultsPushResultStatusStatSStatusStatRegionIdsRegionId] = None,
    ):
        self.region_id = region_id

    def validate(self):
        if self.region_id:
            for k in self.region_id:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RegionId'] = []
        if self.region_id is not None:
            for k in self.region_id:
                result['RegionId'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.region_id = []
        if m.get('RegionId') is not None:
            for k in m.get('RegionId'):
                temp_model = DescribeDataPushResultResponseBodyPushResultsPushResultStatusStatSStatusStatRegionIdsRegionId()
                self.region_id.append(temp_model.from_map(k))
        return self


class DescribeDataPushResultResponseBodyPushResultsPushResultStatusStatSStatusStat(TeaModel):
    def __init__(
        self,
        region_id_count: int = None,
        region_ids: DescribeDataPushResultResponseBodyPushResultsPushResultStatusStatSStatusStatRegionIds = None,
        status: str = None,
    ):
        # The total number of ENS nodes.
        self.region_id_count = region_id_count
        # The push status of data files on the ENS node.
        self.region_ids = region_ids
        # The push status. The value is of the enumeration type. Valid values: SUCCESS FAILED PUSHING
        self.status = status

    def validate(self):
        if self.region_ids:
            self.region_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id_count is not None:
            result['RegionIdCount'] = self.region_id_count
        if self.region_ids is not None:
            result['RegionIds'] = self.region_ids.to_map()
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionIdCount') is not None:
            self.region_id_count = m.get('RegionIdCount')
        if m.get('RegionIds') is not None:
            temp_model = DescribeDataPushResultResponseBodyPushResultsPushResultStatusStatSStatusStatRegionIds()
            self.region_ids = temp_model.from_map(m['RegionIds'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDataPushResultResponseBodyPushResultsPushResultStatusStatS(TeaModel):
    def __init__(
        self,
        status_stat: List[DescribeDataPushResultResponseBodyPushResultsPushResultStatusStatSStatusStat] = None,
    ):
        self.status_stat = status_stat

    def validate(self):
        if self.status_stat:
            for k in self.status_stat:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['StatusStat'] = []
        if self.status_stat is not None:
            for k in self.status_stat:
                result['StatusStat'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.status_stat = []
        if m.get('StatusStat') is not None:
            for k in m.get('StatusStat'):
                temp_model = DescribeDataPushResultResponseBodyPushResultsPushResultStatusStatSStatusStat()
                self.status_stat.append(temp_model.from_map(k))
        return self


class DescribeDataPushResultResponseBodyPushResultsPushResult(TeaModel):
    def __init__(
        self,
        name: str = None,
        status_stat_s: DescribeDataPushResultResponseBodyPushResultsPushResultStatusStatS = None,
        version: str = None,
    ):
        # The name of the data file.
        self.name = name
        # The push status of data files.
        self.status_stat_s = status_stat_s
        # The version number of the data file.
        self.version = version

    def validate(self):
        if self.status_stat_s:
            self.status_stat_s.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.status_stat_s is not None:
            result['StatusStatS'] = self.status_stat_s.to_map()
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('StatusStatS') is not None:
            temp_model = DescribeDataPushResultResponseBodyPushResultsPushResultStatusStatS()
            self.status_stat_s = temp_model.from_map(m['StatusStatS'])
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class DescribeDataPushResultResponseBodyPushResults(TeaModel):
    def __init__(
        self,
        push_result: List[DescribeDataPushResultResponseBodyPushResultsPushResult] = None,
    ):
        self.push_result = push_result

    def validate(self):
        if self.push_result:
            for k in self.push_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PushResult'] = []
        if self.push_result is not None:
            for k in self.push_result:
                result['PushResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.push_result = []
        if m.get('PushResult') is not None:
            for k in m.get('PushResult'):
                temp_model = DescribeDataPushResultResponseBodyPushResultsPushResult()
                self.push_result.append(temp_model.from_map(k))
        return self


class DescribeDataPushResultResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        push_results: DescribeDataPushResultResponseBodyPushResults = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The push results of data files.
        self.push_results = push_results
        # The ID of the request.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.push_results:
            self.push_results.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.push_results is not None:
            result['PushResults'] = self.push_results.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PushResults') is not None:
            temp_model = DescribeDataPushResultResponseBodyPushResults()
            self.push_results = temp_model.from_map(m['PushResults'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDataPushResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDataPushResultResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDataPushResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDeviceServiceRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        ens_region_id: str = None,
        instance_id: str = None,
        order_id: str = None,
        region_id: str = None,
        service_id: str = None,
    ):
        # The ID of the application.
        self.app_id = app_id
        # This parameter does not take effect.
        self.ens_region_id = ens_region_id
        # The ID of the instance.
        self.instance_id = instance_id
        # The ID of the order.
        self.order_id = order_id
        # The ID of the Edge Node Service (ENS) node.
        self.region_id = region_id
        # Service ID
        self.service_id = service_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.service_id is not None:
            result['ServiceId'] = self.service_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ServiceId') is not None:
            self.service_id = m.get('ServiceId')
        return self


class DescribeDeviceServiceResponseBodyAppMetaData(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        app_name: str = None,
        app_stable_version: str = None,
        app_type: str = None,
        cluster_name: str = None,
        create_time: str = None,
        description: str = None,
    ):
        # The ID of the application.
        self.app_id = app_id
        # The name of the application.
        self.app_name = app_name
        # The stable version number of the application.
        self.app_stable_version = app_stable_version
        # The type of the application. The value is of the enumeration type. Valid values:
        # 
        # *   Common
        # *   Scheduler
        self.app_type = app_type
        # The name of the application cluster.
        self.cluster_name = cluster_name
        # The time when the application was created.
        self.create_time = create_time
        # The description of the application.
        self.description = description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.app_stable_version is not None:
            result['AppStableVersion'] = self.app_stable_version
        if self.app_type is not None:
            result['AppType'] = self.app_type
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('AppStableVersion') is not None:
            self.app_stable_version = m.get('AppStableVersion')
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class DescribeDeviceServiceResponseBodyAppStatus(TeaModel):
    def __init__(
        self,
        phase: str = None,
        status_descrip: str = None,
        update_time: str = None,
    ):
        # The status of the application. The value is of the enumeration type. Valid values:
        # 
        # Three intermediate states:
        # 
        # *   CREATING
        # *   UPDATING
        # *   DELETING
        # 
        # Four final states:
        # 
        # *   CREATE_FAILED
        # *   UPDATE_FAILED
        # *   DELETE_FAILED
        # *   RUNNING
        self.phase = phase
        # The description of the application status.
        self.status_descrip = status_descrip
        # The time when the status was last updated.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.phase is not None:
            result['Phase'] = self.phase
        if self.status_descrip is not None:
            result['StatusDescrip'] = self.status_descrip
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Phase') is not None:
            self.phase = m.get('Phase')
        if m.get('StatusDescrip') is not None:
            self.status_descrip = m.get('StatusDescrip')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeDeviceServiceResponseBodyResourceDetailInfos(TeaModel):
    def __init__(
        self,
        device_name: str = None,
        id: str = None,
        ip: str = None,
        isp: str = None,
        image_id: str = None,
        mac: str = None,
        region_id: str = None,
        server: str = None,
        status: str = None,
        type: str = None,
    ):
        # The name of the device.
        self.device_name = device_name
        # The ID of the cloud device.
        self.id = id
        # The IP address.
        self.ip = ip
        # The Internet service provider (ISP).
        self.isp = isp
        # The ID of the image.
        self.image_id = image_id
        # The media access control (MAC) address of the device.
        self.mac = mac
        # The ID of the ENS node.
        self.region_id = region_id
        # The server name of the ENS node.
        self.server = server
        # The status of the device.
        self.status = status
        # The type of the device.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.id is not None:
            result['ID'] = self.id
        if self.ip is not None:
            result['IP'] = self.ip
        if self.isp is not None:
            result['ISP'] = self.isp
        if self.image_id is not None:
            result['ImageID'] = self.image_id
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.region_id is not None:
            result['RegionID'] = self.region_id
        if self.server is not None:
            result['Server'] = self.server
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ID') is not None:
            self.id = m.get('ID')
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        if m.get('ISP') is not None:
            self.isp = m.get('ISP')
        if m.get('ImageID') is not None:
            self.image_id = m.get('ImageID')
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('RegionID') is not None:
            self.region_id = m.get('RegionID')
        if m.get('Server') is not None:
            self.server = m.get('Server')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeDeviceServiceResponseBodyResourceInfosDeviceInfosNetwork(TeaModel):
    def __init__(
        self,
        container_ports: str = None,
        external_ip: str = None,
        host_ports: str = None,
        protocol: str = None,
    ):
        # The port of the container.
        self.container_ports = container_ports
        # The public IP address.
        self.external_ip = external_ip
        # The port range.
        self.host_ports = host_ports
        # The protocol of the gateway. The value is of the enumeration type. Valid values:
        # 
        # *   TCP
        # *   UDP
        self.protocol = protocol

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.container_ports is not None:
            result['ContainerPorts'] = self.container_ports
        if self.external_ip is not None:
            result['ExternalIp'] = self.external_ip
        if self.host_ports is not None:
            result['HostPorts'] = self.host_ports
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContainerPorts') is not None:
            self.container_ports = m.get('ContainerPorts')
        if m.get('ExternalIp') is not None:
            self.external_ip = m.get('ExternalIp')
        if m.get('HostPorts') is not None:
            self.host_ports = m.get('HostPorts')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        return self


class DescribeDeviceServiceResponseBodyResourceInfosDeviceInfos(TeaModel):
    def __init__(
        self,
        name: str = None,
        network: List[DescribeDeviceServiceResponseBodyResourceInfosDeviceInfosNetwork] = None,
        status: str = None,
    ):
        # The name of the device.
        self.name = name
        # The network information.
        self.network = network
        # The status.
        self.status = status

    def validate(self):
        if self.network:
            for k in self.network:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        result['Network'] = []
        if self.network is not None:
            for k in self.network:
                result['Network'].append(k.to_map() if k else None)
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.network = []
        if m.get('Network') is not None:
            for k in m.get('Network'):
                temp_model = DescribeDeviceServiceResponseBodyResourceInfosDeviceInfosNetwork()
                self.network.append(temp_model.from_map(k))
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDeviceServiceResponseBodyResourceInfosInternalIps(TeaModel):
    def __init__(
        self,
        ip: str = None,
    ):
        # The internal IP address.
        self.ip = ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip is not None:
            result['Ip'] = self.ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        return self


class DescribeDeviceServiceResponseBodyResourceInfosPublicIps(TeaModel):
    def __init__(
        self,
        ip: str = None,
    ):
        # The public IP address.
        self.ip = ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip is not None:
            result['Ip'] = self.ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        return self


class DescribeDeviceServiceResponseBodyResourceInfos(TeaModel):
    def __init__(
        self,
        app_version: str = None,
        area_code: str = None,
        area_name: str = None,
        create_time: str = None,
        device_infos: List[DescribeDeviceServiceResponseBodyResourceInfosDeviceInfos] = None,
        instance_id: str = None,
        instance_status: str = None,
        internal_ips: List[DescribeDeviceServiceResponseBodyResourceInfosInternalIps] = None,
        public_ips: List[DescribeDeviceServiceResponseBodyResourceInfosPublicIps] = None,
        region_code: str = None,
        region_id: str = None,
        region_name: str = None,
    ):
        # The version of the application.
        self.app_version = app_version
        # The area code.
        self.area_code = area_code
        # The region name.
        self.area_name = area_name
        # The time when the application was created.
        self.create_time = create_time
        # The information about the devices.
        self.device_infos = device_infos
        # The ID of the instance.
        self.instance_id = instance_id
        # The status of the instance.
        self.instance_status = instance_status
        # The internal IP addresses.
        self.internal_ips = internal_ips
        # The public IP addresses.
        self.public_ips = public_ips
        # The ID of the region.
        self.region_code = region_code
        # The ID of the ENS node.
        self.region_id = region_id
        # The name of the region.
        self.region_name = region_name

    def validate(self):
        if self.device_infos:
            for k in self.device_infos:
                if k:
                    k.validate()
        if self.internal_ips:
            for k in self.internal_ips:
                if k:
                    k.validate()
        if self.public_ips:
            for k in self.public_ips:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_version is not None:
            result['AppVersion'] = self.app_version
        if self.area_code is not None:
            result['AreaCode'] = self.area_code
        if self.area_name is not None:
            result['AreaName'] = self.area_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        result['DeviceInfos'] = []
        if self.device_infos is not None:
            for k in self.device_infos:
                result['DeviceInfos'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_status is not None:
            result['InstanceStatus'] = self.instance_status
        result['InternalIps'] = []
        if self.internal_ips is not None:
            for k in self.internal_ips:
                result['InternalIps'].append(k.to_map() if k else None)
        result['PublicIps'] = []
        if self.public_ips is not None:
            for k in self.public_ips:
                result['PublicIps'].append(k.to_map() if k else None)
        if self.region_code is not None:
            result['RegionCode'] = self.region_code
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.region_name is not None:
            result['RegionName'] = self.region_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppVersion') is not None:
            self.app_version = m.get('AppVersion')
        if m.get('AreaCode') is not None:
            self.area_code = m.get('AreaCode')
        if m.get('AreaName') is not None:
            self.area_name = m.get('AreaName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        self.device_infos = []
        if m.get('DeviceInfos') is not None:
            for k in m.get('DeviceInfos'):
                temp_model = DescribeDeviceServiceResponseBodyResourceInfosDeviceInfos()
                self.device_infos.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceStatus') is not None:
            self.instance_status = m.get('InstanceStatus')
        self.internal_ips = []
        if m.get('InternalIps') is not None:
            for k in m.get('InternalIps'):
                temp_model = DescribeDeviceServiceResponseBodyResourceInfosInternalIps()
                self.internal_ips.append(temp_model.from_map(k))
        self.public_ips = []
        if m.get('PublicIps') is not None:
            for k in m.get('PublicIps'):
                temp_model = DescribeDeviceServiceResponseBodyResourceInfosPublicIps()
                self.public_ips.append(temp_model.from_map(k))
        if m.get('RegionCode') is not None:
            self.region_code = m.get('RegionCode')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RegionName') is not None:
            self.region_name = m.get('RegionName')
        return self


class DescribeDeviceServiceResponseBody(TeaModel):
    def __init__(
        self,
        app_meta_data: DescribeDeviceServiceResponseBodyAppMetaData = None,
        app_status: DescribeDeviceServiceResponseBodyAppStatus = None,
        request_id: str = None,
        resource_detail_infos: List[DescribeDeviceServiceResponseBodyResourceDetailInfos] = None,
        resource_infos: List[DescribeDeviceServiceResponseBodyResourceInfos] = None,
    ):
        # The basic properties of the application.
        self.app_meta_data = app_meta_data
        # The status information of the application.
        self.app_status = app_status
        # The ID of the request.
        self.request_id = request_id
        # The information about the devices.
        self.resource_detail_infos = resource_detail_infos
        # The information about the instances.
        self.resource_infos = resource_infos

    def validate(self):
        if self.app_meta_data:
            self.app_meta_data.validate()
        if self.app_status:
            self.app_status.validate()
        if self.resource_detail_infos:
            for k in self.resource_detail_infos:
                if k:
                    k.validate()
        if self.resource_infos:
            for k in self.resource_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_meta_data is not None:
            result['AppMetaData'] = self.app_meta_data.to_map()
        if self.app_status is not None:
            result['AppStatus'] = self.app_status.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['ResourceDetailInfos'] = []
        if self.resource_detail_infos is not None:
            for k in self.resource_detail_infos:
                result['ResourceDetailInfos'].append(k.to_map() if k else None)
        result['ResourceInfos'] = []
        if self.resource_infos is not None:
            for k in self.resource_infos:
                result['ResourceInfos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppMetaData') is not None:
            temp_model = DescribeDeviceServiceResponseBodyAppMetaData()
            self.app_meta_data = temp_model.from_map(m['AppMetaData'])
        if m.get('AppStatus') is not None:
            temp_model = DescribeDeviceServiceResponseBodyAppStatus()
            self.app_status = temp_model.from_map(m['AppStatus'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.resource_detail_infos = []
        if m.get('ResourceDetailInfos') is not None:
            for k in m.get('ResourceDetailInfos'):
                temp_model = DescribeDeviceServiceResponseBodyResourceDetailInfos()
                self.resource_detail_infos.append(temp_model.from_map(k))
        self.resource_infos = []
        if m.get('ResourceInfos') is not None:
            for k in m.get('ResourceInfos'):
                temp_model = DescribeDeviceServiceResponseBodyResourceInfos()
                self.resource_infos.append(temp_model.from_map(k))
        return self


class DescribeDeviceServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDeviceServiceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDeviceServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDiskIopsListRequest(TeaModel):
    def __init__(
        self,
        disk_id: str = None,
        end_time: str = None,
        start_time: str = None,
    ):
        # The ID of the disk. Format: d-\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*.
        # 
        # This parameter is required.
        self.disk_id = disk_id
        # The beginning of the time range to query. Specify the time in the format of yyyy-MM-dd HH:mm:ss. The time range specified by the StartTime and EndTime parameters cannot exceed one day for a query.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The beginning of the time range to query. Specify the time in the format of yyyy-MM-dd HH:mm:ss.
        # 
        # This parameter is required.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDiskIopsListResponseBodyDiskIopsList(TeaModel):
    def __init__(
        self,
        biz_time: str = None,
        disk_id: str = None,
        read_bytes: int = None,
        read_latency: int = None,
        read_ops: int = None,
        region_id: str = None,
        write_bytes: int = None,
        write_latency: int = None,
        write_ops: int = None,
    ):
        # The business time . The time is displayed in the yyyy-MM-dd HH:mm:ss.
        self.biz_time = biz_time
        # The ID of the disk.
        self.disk_id = disk_id
        # The read throughput. Unit: bytes.
        self.read_bytes = read_bytes
        # The read latency. Unit: ms.
        self.read_latency = read_latency
        # The read IOPS.
        self.read_ops = read_ops
        # The ID of the node.
        self.region_id = region_id
        # The write throughput. Unit: bytes.
        self.write_bytes = write_bytes
        # The write latency. Unit: microseconds.
        self.write_latency = write_latency
        # The write IOPS.
        self.write_ops = write_ops

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_time is not None:
            result['BizTime'] = self.biz_time
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.read_bytes is not None:
            result['ReadBytes'] = self.read_bytes
        if self.read_latency is not None:
            result['ReadLatency'] = self.read_latency
        if self.read_ops is not None:
            result['ReadOps'] = self.read_ops
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.write_bytes is not None:
            result['WriteBytes'] = self.write_bytes
        if self.write_latency is not None:
            result['WriteLatency'] = self.write_latency
        if self.write_ops is not None:
            result['WriteOps'] = self.write_ops
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizTime') is not None:
            self.biz_time = m.get('BizTime')
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('ReadBytes') is not None:
            self.read_bytes = m.get('ReadBytes')
        if m.get('ReadLatency') is not None:
            self.read_latency = m.get('ReadLatency')
        if m.get('ReadOps') is not None:
            self.read_ops = m.get('ReadOps')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('WriteBytes') is not None:
            self.write_bytes = m.get('WriteBytes')
        if m.get('WriteLatency') is not None:
            self.write_latency = m.get('WriteLatency')
        if m.get('WriteOps') is not None:
            self.write_ops = m.get('WriteOps')
        return self


class DescribeDiskIopsListResponseBody(TeaModel):
    def __init__(
        self,
        disk_iops_list: List[DescribeDiskIopsListResponseBodyDiskIopsList] = None,
        request_id: str = None,
    ):
        # The IOPS monitoring data of the cloud disk.
        self.disk_iops_list = disk_iops_list
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.disk_iops_list:
            for k in self.disk_iops_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DiskIopsList'] = []
        if self.disk_iops_list is not None:
            for k in self.disk_iops_list:
                result['DiskIopsList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.disk_iops_list = []
        if m.get('DiskIopsList') is not None:
            for k in m.get('DiskIopsList'):
                temp_model = DescribeDiskIopsListResponseBodyDiskIopsList()
                self.disk_iops_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDiskIopsListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDiskIopsListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDiskIopsListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDisksRequest(TeaModel):
    def __init__(
        self,
        category: str = None,
        disk_charge_type: str = None,
        disk_id: str = None,
        disk_ids: str = None,
        disk_name: str = None,
        disk_type: str = None,
        ens_region_id: str = None,
        ens_region_ids: str = None,
        instance_id: str = None,
        order_by_params: str = None,
        page_number: str = None,
        page_size: str = None,
        snapshot_id: str = None,
        status: str = None,
        type: str = None,
    ):
        # The category of the disk.
        # 
        # *   cloud_efficiency: ultra disk.
        # *   cloud_ssd: all-flash disk.
        # *   local_hdd: local HDD.
        # *   local_ssd: local SSD.
        self.category = category
        # The billing method.
        # 
        # *   prePay: subscription.
        # *   postpay: pay-as-you-go.
        self.disk_charge_type = disk_charge_type
        # The ID of the disk.
        self.disk_id = disk_id
        # The ID of the disk.
        self.disk_ids = disk_ids
        # The name of the disk.
        self.disk_name = disk_name
        # The purchase method of the disk. Valid values:
        # 
        # *   ServiceDisk: The disk is purchased when ENS is activated.
        # *   ResoureDisk: The disk is purchased when the instance is created.
        # *   PostPayDisk: The disk is separately purchased.
        self.disk_type = disk_type
        # The ID of the edge node.
        self.ens_region_id = ens_region_id
        # The node information.
        self.ens_region_ids = ens_region_ids
        # The ID of the instance to which the disk is attached.
        self.instance_id = instance_id
        # The order in which you want to sort the returned data. Example: {"EnsRegionId":"desc"}. By default, the nodes are sorted by IDs in descending order.
        self.order_by_params = order_by_params
        # The number of the page to return. Pages start from page **1**.
        # 
        # Default value: **1**.
        self.page_number = page_number
        # The number of entries to return on each page. Maximum value: **50**.
        # 
        # Default value: **10**.
        self.page_size = page_size
        # The ID of the snapshot.
        self.snapshot_id = snapshot_id
        # The status of the disk. Valid values:
        # 
        # *   In-use: The disk is in use.
        # *   Available: The disk can be attached.
        # *   Attaching: The disk is being attached.
        # *   Detaching: The disk is being detached.
        # *   Creating: The disk is being created.
        # *   ReIniting: The disk is being reset.
        # *   Deleting: The disk is being released.
        # *   Deleted: The disk is released.
        # *   Expiring: The disk is about to expire.
        self.status = status
        # The type of the disk. Valid values:
        # 
        # *   system: system disk.
        # *   data: data disk.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.disk_charge_type is not None:
            result['DiskChargeType'] = self.disk_charge_type
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.disk_ids is not None:
            result['DiskIds'] = self.disk_ids
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.ens_region_ids is not None:
            result['EnsRegionIds'] = self.ens_region_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.order_by_params is not None:
            result['OrderByParams'] = self.order_by_params
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DiskChargeType') is not None:
            self.disk_charge_type = m.get('DiskChargeType')
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('DiskIds') is not None:
            self.disk_ids = m.get('DiskIds')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('EnsRegionIds') is not None:
            self.ens_region_ids = m.get('EnsRegionIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrderByParams') is not None:
            self.order_by_params = m.get('OrderByParams')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeDisksResponseBodyDisksDisksTagsTags(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDisksResponseBodyDisksDisksTags(TeaModel):
    def __init__(
        self,
        tags: List[DescribeDisksResponseBodyDisksDisksTagsTags] = None,
    ):
        self.tags = tags

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = DescribeDisksResponseBodyDisksDisksTagsTags()
                self.tags.append(temp_model.from_map(k))
        return self


class DescribeDisksResponseBodyDisksDisks(TeaModel):
    def __init__(
        self,
        category: str = None,
        creation_time: str = None,
        delete_with_instance: bool = None,
        description: str = None,
        disk_charge_type: str = None,
        disk_id: str = None,
        disk_name: str = None,
        encrypted: bool = None,
        encrypted_key_id: str = None,
        ens_region_id: str = None,
        instance_id: str = None,
        instance_name: str = None,
        portable: bool = None,
        serial_id: str = None,
        size: int = None,
        snapshot_id: str = None,
        status: str = None,
        tags: DescribeDisksResponseBodyDisksDisksTags = None,
        type: str = None,
    ):
        # The category of the disk.
        # 
        # *   cloud_efficiency: ultra disk.
        # *   cloud_ssd: all-flash disk.
        # *   local_hdd: local HDD.
        # *   local_ssd: local SSD.
        self.category = category
        # The time when the disk was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.creation_time = creation_time
        # Indicates whether the disk is released when the instance to which the disk is attached is released. Valid values:
        # 
        # *   true: The disk is released when the associated instance is released.
        # *   false: The disk is retained when the associated instance is released.
        self.delete_with_instance = delete_with_instance
        # The namespace description.
        self.description = description
        # The billing method of the cloud disk or local disk. Valid values:
        # 
        # *   **prepaid**: subscription.
        # *   **postpaid**: pay-as-you-go.
        self.disk_charge_type = disk_charge_type
        # The ID of the disk.
        self.disk_id = disk_id
        # The name of the disk.
        self.disk_name = disk_name
        # Indicates whether the cloud disk is encrypted. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.encrypted = encrypted
        # The ID of the Key Management Service (KMS) key that is used for the cloud disk.
        self.encrypted_key_id = encrypted_key_id
        # The ID of the edge node.
        self.ens_region_id = ens_region_id
        # The ID of the instance.
        self.instance_id = instance_id
        # The name of the instance.
        self.instance_name = instance_name
        # Indicates whether the cloud disk or local disk is removable. Valid values:
        # 
        # *   true: The disk is removable. A removable disk can independently exist and can be attached to or detached from an instance within the same zone.
        # *   false: The disk is not removable. A disk that is not removable cannot independently exist or be attached to or detached from an instance within the same zone.
        # 
        # If disks are of the following categories or types, the **Portable** value is **false** and the disks have the same lifecycle as their attached instances:
        # 
        # *   Local HDDs
        # *   Local SSDs
        # *   Data disks that use the subscription billing method
        self.portable = portable
        # The serial number.
        self.serial_id = serial_id
        # The size of the disk. Unit: MiB.
        self.size = size
        # The ID of the snapshot.
        self.snapshot_id = snapshot_id
        # The status of the disk. Valid values:
        # 
        # *   In-use: The disk is in use.
        # *   Available: The disk can be attached.
        # *   Attaching: The disk is being attached.
        # *   Detaching: The disk is being detached.
        # *   Creating: The disk is being created.
        # *   ReIniting: The disk is being reset.
        self.status = status
        self.tags = tags
        # The type of the cloud disk or local disk. Valid values:
        # 
        # *   1: system disk.
        # *   2: data disk.
        self.type = type

    def validate(self):
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.delete_with_instance is not None:
            result['DeleteWithInstance'] = self.delete_with_instance
        if self.description is not None:
            result['Description'] = self.description
        if self.disk_charge_type is not None:
            result['DiskChargeType'] = self.disk_charge_type
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        if self.encrypted_key_id is not None:
            result['EncryptedKeyId'] = self.encrypted_key_id
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.portable is not None:
            result['Portable'] = self.portable
        if self.serial_id is not None:
            result['SerialId'] = self.serial_id
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.status is not None:
            result['Status'] = self.status
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DeleteWithInstance') is not None:
            self.delete_with_instance = m.get('DeleteWithInstance')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DiskChargeType') is not None:
            self.disk_charge_type = m.get('DiskChargeType')
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('Encrypted') is not None:
            self.encrypted = m.get('Encrypted')
        if m.get('EncryptedKeyId') is not None:
            self.encrypted_key_id = m.get('EncryptedKeyId')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Portable') is not None:
            self.portable = m.get('Portable')
        if m.get('SerialId') is not None:
            self.serial_id = m.get('SerialId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tags') is not None:
            temp_model = DescribeDisksResponseBodyDisksDisksTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeDisksResponseBodyDisks(TeaModel):
    def __init__(
        self,
        disks: List[DescribeDisksResponseBodyDisksDisks] = None,
    ):
        self.disks = disks

    def validate(self):
        if self.disks:
            for k in self.disks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Disks'] = []
        if self.disks is not None:
            for k in self.disks:
                result['Disks'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.disks = []
        if m.get('Disks') is not None:
            for k in m.get('Disks'):
                temp_model = DescribeDisksResponseBodyDisksDisks()
                self.disks.append(temp_model.from_map(k))
        return self


class DescribeDisksResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        disks: DescribeDisksResponseBodyDisks = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The returned service code. 0 indicates that the request was successful.
        self.code = code
        # The information about the disks.
        self.disks = disks
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page. Maximum value: **50**. Default value: **10**.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # The total number of returned pages.
        self.total_count = total_count

    def validate(self):
        if self.disks:
            self.disks.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.disks is not None:
            result['Disks'] = self.disks.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Disks') is not None:
            temp_model = DescribeDisksResponseBodyDisks()
            self.disks = temp_model.from_map(m['Disks'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDisksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDisksResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDisksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeElbAvailableResourceInfoResponseBodyElbAvailableResourceInfo(TeaModel):
    def __init__(
        self,
        ability: List[str] = None,
        area: str = None,
        can_buy_count: str = None,
        en_name: str = None,
        ens_region_id: str = None,
        load_balancer_spec: List[str] = None,
        name: str = None,
        province: str = None,
    ):
        self.ability = ability
        # The ID of the region.
        self.area = area
        # The number of resources that you can purchase.
        self.can_buy_count = can_buy_count
        # The name of the node.
        self.en_name = en_name
        # The ID of the Edge Node Service (ENS) node.
        self.ens_region_id = ens_region_id
        # The specifications of the ELB instances.
        self.load_balancer_spec = load_balancer_spec
        # The Chinese name of the node.
        self.name = name
        # The province where the node is deployed.
        self.province = province

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ability is not None:
            result['Ability'] = self.ability
        if self.area is not None:
            result['Area'] = self.area
        if self.can_buy_count is not None:
            result['CanBuyCount'] = self.can_buy_count
        if self.en_name is not None:
            result['EnName'] = self.en_name
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.load_balancer_spec is not None:
            result['LoadBalancerSpec'] = self.load_balancer_spec
        if self.name is not None:
            result['Name'] = self.name
        if self.province is not None:
            result['Province'] = self.province
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ability') is not None:
            self.ability = m.get('Ability')
        if m.get('Area') is not None:
            self.area = m.get('Area')
        if m.get('CanBuyCount') is not None:
            self.can_buy_count = m.get('CanBuyCount')
        if m.get('EnName') is not None:
            self.en_name = m.get('EnName')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('LoadBalancerSpec') is not None:
            self.load_balancer_spec = m.get('LoadBalancerSpec')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        return self


class DescribeElbAvailableResourceInfoResponseBody(TeaModel):
    def __init__(
        self,
        elb_available_resource_info: List[DescribeElbAvailableResourceInfoResponseBodyElbAvailableResourceInfo] = None,
        request_id: str = None,
    ):
        # The information about resources.
        self.elb_available_resource_info = elb_available_resource_info
        # The ID of the request. This parameter is a common parameter. Each request has a unique ID. You can use the ID to troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.elb_available_resource_info:
            for k in self.elb_available_resource_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ElbAvailableResourceInfo'] = []
        if self.elb_available_resource_info is not None:
            for k in self.elb_available_resource_info:
                result['ElbAvailableResourceInfo'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.elb_available_resource_info = []
        if m.get('ElbAvailableResourceInfo') is not None:
            for k in m.get('ElbAvailableResourceInfo'):
                temp_model = DescribeElbAvailableResourceInfoResponseBodyElbAvailableResourceInfo()
                self.elb_available_resource_info.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeElbAvailableResourceInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeElbAvailableResourceInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeElbAvailableResourceInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEnsCommodityCodeRequest(TeaModel):
    def __init__(
        self,
        commodity_code: str = None,
    ):
        self.commodity_code = commodity_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        return self


class DescribeEnsCommodityCodeResponseBodyCommodityCodeInfo(TeaModel):
    def __init__(
        self,
        commodity_code: str = None,
        commodity_name: str = None,
    ):
        self.commodity_code = commodity_code
        self.commodity_name = commodity_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.commodity_name is not None:
            result['CommodityName'] = self.commodity_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('CommodityName') is not None:
            self.commodity_name = m.get('CommodityName')
        return self


class DescribeEnsCommodityCodeResponseBody(TeaModel):
    def __init__(
        self,
        commodity_code_info: List[DescribeEnsCommodityCodeResponseBodyCommodityCodeInfo] = None,
        request_id: str = None,
    ):
        self.commodity_code_info = commodity_code_info
        self.request_id = request_id

    def validate(self):
        if self.commodity_code_info:
            for k in self.commodity_code_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CommodityCodeInfo'] = []
        if self.commodity_code_info is not None:
            for k in self.commodity_code_info:
                result['CommodityCodeInfo'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.commodity_code_info = []
        if m.get('CommodityCodeInfo') is not None:
            for k in m.get('CommodityCodeInfo'):
                temp_model = DescribeEnsCommodityCodeResponseBodyCommodityCodeInfo()
                self.commodity_code_info.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeEnsCommodityCodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEnsCommodityCodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEnsCommodityCodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEnsCommodityModuleCodeRequest(TeaModel):
    def __init__(
        self,
        commodity_code: str = None,
        module_code: str = None,
    ):
        self.commodity_code = commodity_code
        self.module_code = module_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.module_code is not None:
            result['ModuleCode'] = self.module_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('ModuleCode') is not None:
            self.module_code = m.get('ModuleCode')
        return self


class DescribeEnsCommodityModuleCodeResponseBodyCommodityCodesInfoModuleCodesInfo(TeaModel):
    def __init__(
        self,
        module_code: str = None,
        module_name: str = None,
    ):
        self.module_code = module_code
        self.module_name = module_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.module_code is not None:
            result['ModuleCode'] = self.module_code
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ModuleCode') is not None:
            self.module_code = m.get('ModuleCode')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        return self


class DescribeEnsCommodityModuleCodeResponseBodyCommodityCodesInfo(TeaModel):
    def __init__(
        self,
        commodity_code: str = None,
        module_codes_info: List[DescribeEnsCommodityModuleCodeResponseBodyCommodityCodesInfoModuleCodesInfo] = None,
    ):
        self.commodity_code = commodity_code
        self.module_codes_info = module_codes_info

    def validate(self):
        if self.module_codes_info:
            for k in self.module_codes_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        result['ModuleCodesInfo'] = []
        if self.module_codes_info is not None:
            for k in self.module_codes_info:
                result['ModuleCodesInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        self.module_codes_info = []
        if m.get('ModuleCodesInfo') is not None:
            for k in m.get('ModuleCodesInfo'):
                temp_model = DescribeEnsCommodityModuleCodeResponseBodyCommodityCodesInfoModuleCodesInfo()
                self.module_codes_info.append(temp_model.from_map(k))
        return self


class DescribeEnsCommodityModuleCodeResponseBody(TeaModel):
    def __init__(
        self,
        commodity_codes_info: List[DescribeEnsCommodityModuleCodeResponseBodyCommodityCodesInfo] = None,
        request_id: str = None,
    ):
        self.commodity_codes_info = commodity_codes_info
        self.request_id = request_id

    def validate(self):
        if self.commodity_codes_info:
            for k in self.commodity_codes_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CommodityCodesInfo'] = []
        if self.commodity_codes_info is not None:
            for k in self.commodity_codes_info:
                result['CommodityCodesInfo'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.commodity_codes_info = []
        if m.get('CommodityCodesInfo') is not None:
            for k in m.get('CommodityCodesInfo'):
                temp_model = DescribeEnsCommodityModuleCodeResponseBodyCommodityCodesInfo()
                self.commodity_codes_info.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeEnsCommodityModuleCodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEnsCommodityModuleCodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEnsCommodityModuleCodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEnsEipAddressesRequest(TeaModel):
    def __init__(
        self,
        allocation_id: str = None,
        associated_instance_id: str = None,
        associated_instance_type: str = None,
        eip_address: str = None,
        eip_name: str = None,
        ens_region_id: str = None,
        ens_region_ids: List[str] = None,
        icmp_reply_enabled: bool = None,
        page_number: int = None,
        page_size: int = None,
        standby: str = None,
    ):
        # The ID of the EIP that you want to query. You can specify up to 50 EIP IDs. Separate multiple IDs with commas (,).
        self.allocation_id = allocation_id
        # The ID of the instance with which you want to associate the EIP.
        self.associated_instance_id = associated_instance_id
        # The type of the instance that is associated with the EIP. Valid values:
        # 
        # *   **EnsInstance**: ENS instance in a VPC
        # *   **SlbInstance**: SLB instance
        self.associated_instance_type = associated_instance_type
        # The EIP that you want to query. You can specify up to 50 EIPs. Separate multiple EIPs with commas (,).
        self.eip_address = eip_address
        # The name of the EIP.
        self.eip_name = eip_name
        # The ID of the Edge Node Service (ENS) node.
        self.ens_region_id = ens_region_id
        # The IDs of edge nodes. You can specify 1 to 100 IDs.
        self.ens_region_ids = ens_region_ids
        self.icmp_reply_enabled = icmp_reply_enabled
        # The page number. Default value: 1.
        self.page_number = page_number
        # The number of entries per page. Maximum value: 100. Default value: 10.
        self.page_size = page_size
        # Specifies whether the EIP is a secondary EIP. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.standby = standby

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allocation_id is not None:
            result['AllocationId'] = self.allocation_id
        if self.associated_instance_id is not None:
            result['AssociatedInstanceId'] = self.associated_instance_id
        if self.associated_instance_type is not None:
            result['AssociatedInstanceType'] = self.associated_instance_type
        if self.eip_address is not None:
            result['EipAddress'] = self.eip_address
        if self.eip_name is not None:
            result['EipName'] = self.eip_name
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.ens_region_ids is not None:
            result['EnsRegionIds'] = self.ens_region_ids
        if self.icmp_reply_enabled is not None:
            result['IcmpReplyEnabled'] = self.icmp_reply_enabled
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.standby is not None:
            result['Standby'] = self.standby
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllocationId') is not None:
            self.allocation_id = m.get('AllocationId')
        if m.get('AssociatedInstanceId') is not None:
            self.associated_instance_id = m.get('AssociatedInstanceId')
        if m.get('AssociatedInstanceType') is not None:
            self.associated_instance_type = m.get('AssociatedInstanceType')
        if m.get('EipAddress') is not None:
            self.eip_address = m.get('EipAddress')
        if m.get('EipName') is not None:
            self.eip_name = m.get('EipName')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('EnsRegionIds') is not None:
            self.ens_region_ids = m.get('EnsRegionIds')
        if m.get('IcmpReplyEnabled') is not None:
            self.icmp_reply_enabled = m.get('IcmpReplyEnabled')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Standby') is not None:
            self.standby = m.get('Standby')
        return self


class DescribeEnsEipAddressesResponseBodyEipAddressesEipAddressTagsTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        tag_key: str = None,
        tag_value: str = None,
        value: str = None,
    ):
        self.key = key
        self.tag_key = tag_key
        self.tag_value = tag_value
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeEnsEipAddressesResponseBodyEipAddressesEipAddressTags(TeaModel):
    def __init__(
        self,
        tag: List[DescribeEnsEipAddressesResponseBodyEipAddressesEipAddressTagsTag] = None,
    ):
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeEnsEipAddressesResponseBodyEipAddressesEipAddressTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeEnsEipAddressesResponseBodyEipAddressesEipAddress(TeaModel):
    def __init__(
        self,
        allocation_id: str = None,
        allocation_time: str = None,
        bandwidth: int = None,
        charge_type: str = None,
        description: str = None,
        ens_region_id: str = None,
        icmp_reply_enabled: bool = None,
        instance_id: str = None,
        instance_type: str = None,
        internet_charge_type: str = None,
        ip_address: str = None,
        ip_status: str = None,
        isp: str = None,
        name: str = None,
        standby: bool = None,
        status: str = None,
        tags: DescribeEnsEipAddressesResponseBodyEipAddressesEipAddressTags = None,
    ):
        self.allocation_id = allocation_id
        self.allocation_time = allocation_time
        self.bandwidth = bandwidth
        self.charge_type = charge_type
        self.description = description
        self.ens_region_id = ens_region_id
        self.icmp_reply_enabled = icmp_reply_enabled
        self.instance_id = instance_id
        self.instance_type = instance_type
        self.internet_charge_type = internet_charge_type
        self.ip_address = ip_address
        self.ip_status = ip_status
        self.isp = isp
        self.name = name
        self.standby = standby
        self.status = status
        self.tags = tags

    def validate(self):
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allocation_id is not None:
            result['AllocationId'] = self.allocation_id
        if self.allocation_time is not None:
            result['AllocationTime'] = self.allocation_time
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.description is not None:
            result['Description'] = self.description
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.icmp_reply_enabled is not None:
            result['IcmpReplyEnabled'] = self.icmp_reply_enabled
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.ip_status is not None:
            result['IpStatus'] = self.ip_status
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.name is not None:
            result['Name'] = self.name
        if self.standby is not None:
            result['Standby'] = self.standby
        if self.status is not None:
            result['Status'] = self.status
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllocationId') is not None:
            self.allocation_id = m.get('AllocationId')
        if m.get('AllocationTime') is not None:
            self.allocation_time = m.get('AllocationTime')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('IcmpReplyEnabled') is not None:
            self.icmp_reply_enabled = m.get('IcmpReplyEnabled')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('IpStatus') is not None:
            self.ip_status = m.get('IpStatus')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Standby') is not None:
            self.standby = m.get('Standby')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tags') is not None:
            temp_model = DescribeEnsEipAddressesResponseBodyEipAddressesEipAddressTags()
            self.tags = temp_model.from_map(m['Tags'])
        return self


class DescribeEnsEipAddressesResponseBodyEipAddresses(TeaModel):
    def __init__(
        self,
        eip_address: List[DescribeEnsEipAddressesResponseBodyEipAddressesEipAddress] = None,
    ):
        self.eip_address = eip_address

    def validate(self):
        if self.eip_address:
            for k in self.eip_address:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EipAddress'] = []
        if self.eip_address is not None:
            for k in self.eip_address:
                result['EipAddress'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.eip_address = []
        if m.get('EipAddress') is not None:
            for k in m.get('EipAddress'):
                temp_model = DescribeEnsEipAddressesResponseBodyEipAddressesEipAddress()
                self.eip_address.append(temp_model.from_map(k))
        return self


class DescribeEnsEipAddressesResponseBody(TeaModel):
    def __init__(
        self,
        eip_addresses: DescribeEnsEipAddressesResponseBodyEipAddresses = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # Details of the EIPs.
        self.eip_addresses = eip_addresses
        # The page number. Valid values: an integer that is greater than 0. Default value: 1.
        self.page_number = page_number
        # The number of entries per page. Default value: 10. Valid values: **10** to **100**.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.eip_addresses:
            self.eip_addresses.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.eip_addresses is not None:
            result['EipAddresses'] = self.eip_addresses.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EipAddresses') is not None:
            temp_model = DescribeEnsEipAddressesResponseBodyEipAddresses()
            self.eip_addresses = temp_model.from_map(m['EipAddresses'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeEnsEipAddressesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEnsEipAddressesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEnsEipAddressesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEnsNetDistrictRequest(TeaModel):
    def __init__(
        self,
        net_district_code: str = None,
        net_district_code_node: bool = None,
        net_level_code: str = None,
    ):
        # The code of the region.
        # 
        # If you do not specify this parameter, only nodes in the regions of the level that is specified by the NetLevelCode parameter are queried.
        # 
        # If you specify this parameter, only nodes in the regions of the level that is specified by this parameter are queried.
        self.net_district_code = net_district_code
        self.net_district_code_node = net_district_code_node
        # The level of the region.
        # 
        # *   **Big**: area
        # *   **Middle**: province
        # *   **Small**: city
        # 
        # This parameter is required.
        self.net_level_code = net_level_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.net_district_code is not None:
            result['NetDistrictCode'] = self.net_district_code
        if self.net_district_code_node is not None:
            result['NetDistrictCodeNode'] = self.net_district_code_node
        if self.net_level_code is not None:
            result['NetLevelCode'] = self.net_level_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetDistrictCode') is not None:
            self.net_district_code = m.get('NetDistrictCode')
        if m.get('NetDistrictCodeNode') is not None:
            self.net_district_code_node = m.get('NetDistrictCodeNode')
        if m.get('NetLevelCode') is not None:
            self.net_level_code = m.get('NetLevelCode')
        return self


class DescribeEnsNetDistrictResponseBodyEnsNetDistrictsEnsNetDistrict(TeaModel):
    def __init__(
        self,
        ens_region_id_count: str = None,
        net_district_code: str = None,
        net_district_en_name: str = None,
        net_district_father_code: str = None,
        net_district_level: str = None,
        net_district_name: str = None,
    ):
        # The number of nodes in the region.
        self.ens_region_id_count = ens_region_id_count
        # The code of the region.
        self.net_district_code = net_district_code
        # The name of the region.
        self.net_district_en_name = net_district_en_name
        # The parent code of the region.
        self.net_district_father_code = net_district_father_code
        # The level of the region.
        # 
        # *   **Big**: area
        # *   **Middle**: province
        # *   **Small**: city
        self.net_district_level = net_district_level
        # The name of the region.
        self.net_district_name = net_district_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ens_region_id_count is not None:
            result['EnsRegionIdCount'] = self.ens_region_id_count
        if self.net_district_code is not None:
            result['NetDistrictCode'] = self.net_district_code
        if self.net_district_en_name is not None:
            result['NetDistrictEnName'] = self.net_district_en_name
        if self.net_district_father_code is not None:
            result['NetDistrictFatherCode'] = self.net_district_father_code
        if self.net_district_level is not None:
            result['NetDistrictLevel'] = self.net_district_level
        if self.net_district_name is not None:
            result['NetDistrictName'] = self.net_district_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnsRegionIdCount') is not None:
            self.ens_region_id_count = m.get('EnsRegionIdCount')
        if m.get('NetDistrictCode') is not None:
            self.net_district_code = m.get('NetDistrictCode')
        if m.get('NetDistrictEnName') is not None:
            self.net_district_en_name = m.get('NetDistrictEnName')
        if m.get('NetDistrictFatherCode') is not None:
            self.net_district_father_code = m.get('NetDistrictFatherCode')
        if m.get('NetDistrictLevel') is not None:
            self.net_district_level = m.get('NetDistrictLevel')
        if m.get('NetDistrictName') is not None:
            self.net_district_name = m.get('NetDistrictName')
        return self


class DescribeEnsNetDistrictResponseBodyEnsNetDistricts(TeaModel):
    def __init__(
        self,
        ens_net_district: List[DescribeEnsNetDistrictResponseBodyEnsNetDistrictsEnsNetDistrict] = None,
    ):
        self.ens_net_district = ens_net_district

    def validate(self):
        if self.ens_net_district:
            for k in self.ens_net_district:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EnsNetDistrict'] = []
        if self.ens_net_district is not None:
            for k in self.ens_net_district:
                result['EnsNetDistrict'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ens_net_district = []
        if m.get('EnsNetDistrict') is not None:
            for k in m.get('EnsNetDistrict'):
                temp_model = DescribeEnsNetDistrictResponseBodyEnsNetDistrictsEnsNetDistrict()
                self.ens_net_district.append(temp_model.from_map(k))
        return self


class DescribeEnsNetDistrictResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        ens_net_districts: DescribeEnsNetDistrictResponseBodyEnsNetDistricts = None,
        request_id: str = None,
    ):
        # The returned service code. A value of 0 indicates that the operation was successful.
        self.code = code
        # The information about the regions.
        self.ens_net_districts = ens_net_districts
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.ens_net_districts:
            self.ens_net_districts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.ens_net_districts is not None:
            result['EnsNetDistricts'] = self.ens_net_districts.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('EnsNetDistricts') is not None:
            temp_model = DescribeEnsNetDistrictResponseBodyEnsNetDistricts()
            self.ens_net_districts = temp_model.from_map(m['EnsNetDistricts'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeEnsNetDistrictResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEnsNetDistrictResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEnsNetDistrictResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEnsNetLevelResponseBodyEnsNetLevelsEnsNetLevel(TeaModel):
    def __init__(
        self,
        ens_net_level_code: str = None,
    ):
        # The network level. Valid values:
        # 
        # *   Big: greater area.
        # *   Middle: province.
        # *   Small: city.
        self.ens_net_level_code = ens_net_level_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ens_net_level_code is not None:
            result['EnsNetLevelCode'] = self.ens_net_level_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnsNetLevelCode') is not None:
            self.ens_net_level_code = m.get('EnsNetLevelCode')
        return self


class DescribeEnsNetLevelResponseBodyEnsNetLevels(TeaModel):
    def __init__(
        self,
        ens_net_level: List[DescribeEnsNetLevelResponseBodyEnsNetLevelsEnsNetLevel] = None,
    ):
        self.ens_net_level = ens_net_level

    def validate(self):
        if self.ens_net_level:
            for k in self.ens_net_level:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EnsNetLevel'] = []
        if self.ens_net_level is not None:
            for k in self.ens_net_level:
                result['EnsNetLevel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ens_net_level = []
        if m.get('EnsNetLevel') is not None:
            for k in m.get('EnsNetLevel'):
                temp_model = DescribeEnsNetLevelResponseBodyEnsNetLevelsEnsNetLevel()
                self.ens_net_level.append(temp_model.from_map(k))
        return self


class DescribeEnsNetLevelResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        ens_net_levels: DescribeEnsNetLevelResponseBodyEnsNetLevels = None,
        request_id: str = None,
    ):
        # The returned service code. A value of 0 indicates that the operation was successful.
        self.code = code
        # The network levels.
        self.ens_net_levels = ens_net_levels
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.ens_net_levels:
            self.ens_net_levels.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.ens_net_levels is not None:
            result['EnsNetLevels'] = self.ens_net_levels.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('EnsNetLevels') is not None:
            temp_model = DescribeEnsNetLevelResponseBodyEnsNetLevels()
            self.ens_net_levels = temp_model.from_map(m['EnsNetLevels'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeEnsNetLevelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEnsNetLevelResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEnsNetLevelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEnsNetSaleDistrictRequest(TeaModel):
    def __init__(
        self,
        net_district_code: str = None,
        net_level_code: str = None,
    ):
        # The region code.
        # 
        # *   If you do not specify this parameter, only nodes under the area level that is specified by NetLevelCode are queried.
        # *   If you specify this parameter, only child nodes in the area that is specified by NetDistrictCode are queried.
        self.net_district_code = net_district_code
        # The network level. Valid values:
        # 
        # *   **Big**: area
        # *   **Middle**: province
        # *   **Small**: city
        # 
        # This parameter is required.
        self.net_level_code = net_level_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.net_district_code is not None:
            result['NetDistrictCode'] = self.net_district_code
        if self.net_level_code is not None:
            result['NetLevelCode'] = self.net_level_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetDistrictCode') is not None:
            self.net_district_code = m.get('NetDistrictCode')
        if m.get('NetLevelCode') is not None:
            self.net_level_code = m.get('NetLevelCode')
        return self


class DescribeEnsNetSaleDistrictResponseBodyEnsNetDistrictsEnsNetDistrict(TeaModel):
    def __init__(
        self,
        ens_region_id_count: str = None,
        instance_count: str = None,
        net_district_code: str = None,
        net_district_en_name: str = None,
        net_district_father_code: str = None,
        net_district_level: str = None,
        net_district_name: str = None,
    ):
        # The information about the ISP.
        self.ens_region_id_count = ens_region_id_count
        # The information about the instance.
        self.instance_count = instance_count
        # The region code.
        self.net_district_code = net_district_code
        # The name of the region.
        self.net_district_en_name = net_district_en_name
        # The parent code of the region.
        self.net_district_father_code = net_district_father_code
        # The region level. Valid values:
        # 
        # *   **Big**: area
        # *   **Middle**: province
        # *   **Small**: city
        self.net_district_level = net_district_level
        # The Chinese name of the region.
        self.net_district_name = net_district_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ens_region_id_count is not None:
            result['EnsRegionIdCount'] = self.ens_region_id_count
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.net_district_code is not None:
            result['NetDistrictCode'] = self.net_district_code
        if self.net_district_en_name is not None:
            result['NetDistrictEnName'] = self.net_district_en_name
        if self.net_district_father_code is not None:
            result['NetDistrictFatherCode'] = self.net_district_father_code
        if self.net_district_level is not None:
            result['NetDistrictLevel'] = self.net_district_level
        if self.net_district_name is not None:
            result['NetDistrictName'] = self.net_district_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnsRegionIdCount') is not None:
            self.ens_region_id_count = m.get('EnsRegionIdCount')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('NetDistrictCode') is not None:
            self.net_district_code = m.get('NetDistrictCode')
        if m.get('NetDistrictEnName') is not None:
            self.net_district_en_name = m.get('NetDistrictEnName')
        if m.get('NetDistrictFatherCode') is not None:
            self.net_district_father_code = m.get('NetDistrictFatherCode')
        if m.get('NetDistrictLevel') is not None:
            self.net_district_level = m.get('NetDistrictLevel')
        if m.get('NetDistrictName') is not None:
            self.net_district_name = m.get('NetDistrictName')
        return self


class DescribeEnsNetSaleDistrictResponseBodyEnsNetDistricts(TeaModel):
    def __init__(
        self,
        ens_net_district: List[DescribeEnsNetSaleDistrictResponseBodyEnsNetDistrictsEnsNetDistrict] = None,
    ):
        self.ens_net_district = ens_net_district

    def validate(self):
        if self.ens_net_district:
            for k in self.ens_net_district:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EnsNetDistrict'] = []
        if self.ens_net_district is not None:
            for k in self.ens_net_district:
                result['EnsNetDistrict'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ens_net_district = []
        if m.get('EnsNetDistrict') is not None:
            for k in m.get('EnsNetDistrict'):
                temp_model = DescribeEnsNetSaleDistrictResponseBodyEnsNetDistrictsEnsNetDistrict()
                self.ens_net_district.append(temp_model.from_map(k))
        return self


class DescribeEnsNetSaleDistrictResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        ens_net_districts: DescribeEnsNetSaleDistrictResponseBodyEnsNetDistricts = None,
        request_id: str = None,
    ):
        # The returned service code. A value of 0 indicates that the operation was successful.
        self.code = code
        # The information about the ISPs in the area.
        self.ens_net_districts = ens_net_districts
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.ens_net_districts:
            self.ens_net_districts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.ens_net_districts is not None:
            result['EnsNetDistricts'] = self.ens_net_districts.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('EnsNetDistricts') is not None:
            temp_model = DescribeEnsNetSaleDistrictResponseBodyEnsNetDistricts()
            self.ens_net_districts = temp_model.from_map(m['EnsNetDistricts'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeEnsNetSaleDistrictResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEnsNetSaleDistrictResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEnsNetSaleDistrictResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEnsRegionIdIpv6InfoRequest(TeaModel):
    def __init__(
        self,
        ens_region_id: str = None,
    ):
        # The ID of the node. You can specify only one node ID in a call.
        # 
        # This parameter is required.
        self.ens_region_id = ens_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        return self


class DescribeEnsRegionIdIpv6InfoResponseBodySupportIpv6Info(TeaModel):
    def __init__(
        self,
        ens_region_id: str = None,
        support_ipv_6: bool = None,
    ):
        # The ID of the node.
        self.ens_region_id = ens_region_id
        # Specifies whether IPv6 is supported. Valid values:
        # 
        # *   true
        # *   false
        self.support_ipv_6 = support_ipv_6

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.support_ipv_6 is not None:
            result['SupportIpv6'] = self.support_ipv_6
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('SupportIpv6') is not None:
            self.support_ipv_6 = m.get('SupportIpv6')
        return self


class DescribeEnsRegionIdIpv6InfoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        support_ipv_6info: DescribeEnsRegionIdIpv6InfoResponseBodySupportIpv6Info = None,
    ):
        # The request ID.
        self.request_id = request_id
        # IPv6 support information.
        self.support_ipv_6info = support_ipv_6info

    def validate(self):
        if self.support_ipv_6info:
            self.support_ipv_6info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.support_ipv_6info is not None:
            result['SupportIpv6Info'] = self.support_ipv_6info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SupportIpv6Info') is not None:
            temp_model = DescribeEnsRegionIdIpv6InfoResponseBodySupportIpv6Info()
            self.support_ipv_6info = temp_model.from_map(m['SupportIpv6Info'])
        return self


class DescribeEnsRegionIdIpv6InfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEnsRegionIdIpv6InfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEnsRegionIdIpv6InfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEnsRegionIdResourceRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        isp: str = None,
        order_by_params: str = None,
        page_number: int = None,
        page_size: str = None,
        start_time: str = None,
    ):
        # The end time of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The Internet service provider (ISP). Valid values:
        # 
        # *   cmcc: China Mobile
        # *   telecom: China Telecom
        # *   unicom: China Unicom
        # *   multiCarrier: multi-line ISP
        self.isp = isp
        # The order in which the resources to return are sorted. Valid values:
        # 
        # *   InstanceCount: desc
        # *   Area: asc
        # *   InternetBandwidth: asc
        self.order_by_params = order_by_params
        # The page number. Pages start from page **1**. Default value: **1**.
        self.page_number = page_number
        # The number of entries per page. Maximum value: **100**. Default value: **10**.
        self.page_size = page_size
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # This parameter is required.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.order_by_params is not None:
            result['OrderByParams'] = self.order_by_params
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('OrderByParams') is not None:
            self.order_by_params = m.get('OrderByParams')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeEnsRegionIdResourceResponseBodyEnsRegionIdResourcesEnsRegionIdResource(TeaModel):
    def __init__(
        self,
        area: str = None,
        area_code: str = None,
        biz_date: str = None,
        ens_region_id: str = None,
        ens_region_id_name: str = None,
        instance_count: int = None,
        internet_bandwidth: int = None,
        isp: str = None,
        vcpu: int = None,
    ):
        # The region. Set the value to West.
        self.area = area
        # The code of the region.
        self.area_code = area_code
        # The date when the transaction was processed.
        self.biz_date = biz_date
        # The ID of the node.
        self.ens_region_id = ens_region_id
        # The name of the node.
        self.ens_region_id_name = ens_region_id_name
        # The number of instances.
        self.instance_count = instance_count
        # The public bandwidth of the instance. Unit: Bits/s.
        self.internet_bandwidth = internet_bandwidth
        # The ISP. Valid values:
        # 
        # *   cmcc: China Mobile
        # *   unicom: China Unicom
        # *   telecom: China Telecom
        # *   multiCarrier: multi-line ISP
        self.isp = isp
        # The number of vCPUs.
        self.vcpu = vcpu

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.area is not None:
            result['Area'] = self.area
        if self.area_code is not None:
            result['AreaCode'] = self.area_code
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.ens_region_id_name is not None:
            result['EnsRegionIdName'] = self.ens_region_id_name
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.internet_bandwidth is not None:
            result['InternetBandwidth'] = self.internet_bandwidth
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.vcpu is not None:
            result['VCpu'] = self.vcpu
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Area') is not None:
            self.area = m.get('Area')
        if m.get('AreaCode') is not None:
            self.area_code = m.get('AreaCode')
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('EnsRegionIdName') is not None:
            self.ens_region_id_name = m.get('EnsRegionIdName')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('InternetBandwidth') is not None:
            self.internet_bandwidth = m.get('InternetBandwidth')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('VCpu') is not None:
            self.vcpu = m.get('VCpu')
        return self


class DescribeEnsRegionIdResourceResponseBodyEnsRegionIdResources(TeaModel):
    def __init__(
        self,
        ens_region_id_resource: List[DescribeEnsRegionIdResourceResponseBodyEnsRegionIdResourcesEnsRegionIdResource] = None,
    ):
        self.ens_region_id_resource = ens_region_id_resource

    def validate(self):
        if self.ens_region_id_resource:
            for k in self.ens_region_id_resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EnsRegionIdResource'] = []
        if self.ens_region_id_resource is not None:
            for k in self.ens_region_id_resource:
                result['EnsRegionIdResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ens_region_id_resource = []
        if m.get('EnsRegionIdResource') is not None:
            for k in m.get('EnsRegionIdResource'):
                temp_model = DescribeEnsRegionIdResourceResponseBodyEnsRegionIdResourcesEnsRegionIdResource()
                self.ens_region_id_resource.append(temp_model.from_map(k))
        return self


class DescribeEnsRegionIdResourceResponseBody(TeaModel):
    def __init__(
        self,
        ens_region_id_resources: DescribeEnsRegionIdResourceResponseBodyEnsRegionIdResources = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The returned data. For more information, see EnsRegionIdResources in sample JSON responses.
        self.ens_region_id_resources = ens_region_id_resources
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # The total number of queried nodes.
        self.total_count = total_count

    def validate(self):
        if self.ens_region_id_resources:
            self.ens_region_id_resources.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ens_region_id_resources is not None:
            result['EnsRegionIdResources'] = self.ens_region_id_resources.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnsRegionIdResources') is not None:
            temp_model = DescribeEnsRegionIdResourceResponseBodyEnsRegionIdResources()
            self.ens_region_id_resources = temp_model.from_map(m['EnsRegionIdResources'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeEnsRegionIdResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEnsRegionIdResourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEnsRegionIdResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEnsRegionsRequest(TeaModel):
    def __init__(
        self,
        ens_region_id: str = None,
    ):
        # The ID of the node.
        # 
        # By default, all available node IDs are returned.
        self.ens_region_id = ens_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        return self


class DescribeEnsRegionsResponseBodyEnsRegionsEnsRegions(TeaModel):
    def __init__(
        self,
        area: str = None,
        en_name: str = None,
        ens_region_id: str = None,
        name: str = None,
        province: str = None,
    ):
        # The code of the region.
        self.area = area
        # The name of the node.
        self.en_name = en_name
        # The ID of the node.
        self.ens_region_id = ens_region_id
        # The name of the node.
        self.name = name
        # The province where the node is deployed.
        self.province = province

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.area is not None:
            result['Area'] = self.area
        if self.en_name is not None:
            result['EnName'] = self.en_name
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.name is not None:
            result['Name'] = self.name
        if self.province is not None:
            result['Province'] = self.province
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Area') is not None:
            self.area = m.get('Area')
        if m.get('EnName') is not None:
            self.en_name = m.get('EnName')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        return self


class DescribeEnsRegionsResponseBodyEnsRegions(TeaModel):
    def __init__(
        self,
        ens_regions: List[DescribeEnsRegionsResponseBodyEnsRegionsEnsRegions] = None,
    ):
        self.ens_regions = ens_regions

    def validate(self):
        if self.ens_regions:
            for k in self.ens_regions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EnsRegions'] = []
        if self.ens_regions is not None:
            for k in self.ens_regions:
                result['EnsRegions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ens_regions = []
        if m.get('EnsRegions') is not None:
            for k in m.get('EnsRegions'):
                temp_model = DescribeEnsRegionsResponseBodyEnsRegionsEnsRegions()
                self.ens_regions.append(temp_model.from_map(k))
        return self


class DescribeEnsRegionsResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        ens_regions: DescribeEnsRegionsResponseBodyEnsRegions = None,
        request_id: str = None,
    ):
        # The service code. 0 is returned for a successful request. An error code is returned for a failed request.
        self.code = code
        # The information about the regions.
        self.ens_regions = ens_regions
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.ens_regions:
            self.ens_regions.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.ens_regions is not None:
            result['EnsRegions'] = self.ens_regions.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('EnsRegions') is not None:
            temp_model = DescribeEnsRegionsResponseBodyEnsRegions()
            self.ens_regions = temp_model.from_map(m['EnsRegions'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeEnsRegionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEnsRegionsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEnsRegionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEnsResourceUsageRequest(TeaModel):
    def __init__(
        self,
        expired_end_time: str = None,
        expired_start_time: str = None,
    ):
        # The end of the time range to query. Format: yyyy-MM-dd or yyyy-MM-dd HH:mm:ss.
        self.expired_end_time = expired_end_time
        # The beginning of the time range to query. Format: yyyy-MM-dd or yyyy-MM-dd HH:mm:ss.
        self.expired_start_time = expired_start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expired_end_time is not None:
            result['ExpiredEndTime'] = self.expired_end_time
        if self.expired_start_time is not None:
            result['ExpiredStartTime'] = self.expired_start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExpiredEndTime') is not None:
            self.expired_end_time = m.get('ExpiredEndTime')
        if m.get('ExpiredStartTime') is not None:
            self.expired_start_time = m.get('ExpiredStartTime')
        return self


class DescribeEnsResourceUsageResponseBodyEnsResourceUsage(TeaModel):
    def __init__(
        self,
        compute_resource_count: int = None,
        cpu_sum: int = None,
        disk_count: int = None,
        down_count: int = None,
        expired_count: int = None,
        expiring_count: int = None,
        gpu_sum: int = None,
        instance_count: int = None,
        running_count: int = None,
        service_type: str = None,
        storage_sum: int = None,
    ):
        # The number of edge services. This parameter is available only when you set the ServiceType parameter to 2.
        self.compute_resource_count = compute_resource_count
        # The CPU usage. Unit: cores.
        self.cpu_sum = cpu_sum
        # The number of data disks.
        self.disk_count = disk_count
        # The number of stopped VMs.
        self.down_count = down_count
        # The number of expired VM instances.
        self.expired_count = expired_count
        # The number of VM instances that are about to expire.
        self.expiring_count = expiring_count
        # The number of GPUs.
        self.gpu_sum = gpu_sum
        # The number of instances.
        self.instance_count = instance_count
        # The number of running instances.
        self.running_count = running_count
        # The type of the service. Valid values:
        # 
        # *   1: subscription instance.
        # *   2: edge service instance.
        # *   3: pay-as-you-go instance.
        self.service_type = service_type
        # The total disk size.
        self.storage_sum = storage_sum

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compute_resource_count is not None:
            result['ComputeResourceCount'] = self.compute_resource_count
        if self.cpu_sum is not None:
            result['CpuSum'] = self.cpu_sum
        if self.disk_count is not None:
            result['DiskCount'] = self.disk_count
        if self.down_count is not None:
            result['DownCount'] = self.down_count
        if self.expired_count is not None:
            result['ExpiredCount'] = self.expired_count
        if self.expiring_count is not None:
            result['ExpiringCount'] = self.expiring_count
        if self.gpu_sum is not None:
            result['GpuSum'] = self.gpu_sum
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.running_count is not None:
            result['RunningCount'] = self.running_count
        if self.service_type is not None:
            result['ServiceType'] = self.service_type
        if self.storage_sum is not None:
            result['StorageSum'] = self.storage_sum
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComputeResourceCount') is not None:
            self.compute_resource_count = m.get('ComputeResourceCount')
        if m.get('CpuSum') is not None:
            self.cpu_sum = m.get('CpuSum')
        if m.get('DiskCount') is not None:
            self.disk_count = m.get('DiskCount')
        if m.get('DownCount') is not None:
            self.down_count = m.get('DownCount')
        if m.get('ExpiredCount') is not None:
            self.expired_count = m.get('ExpiredCount')
        if m.get('ExpiringCount') is not None:
            self.expiring_count = m.get('ExpiringCount')
        if m.get('GpuSum') is not None:
            self.gpu_sum = m.get('GpuSum')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('RunningCount') is not None:
            self.running_count = m.get('RunningCount')
        if m.get('ServiceType') is not None:
            self.service_type = m.get('ServiceType')
        if m.get('StorageSum') is not None:
            self.storage_sum = m.get('StorageSum')
        return self


class DescribeEnsResourceUsageResponseBody(TeaModel):
    def __init__(
        self,
        ens_resource_usage: List[DescribeEnsResourceUsageResponseBodyEnsResourceUsage] = None,
        request_id: str = None,
    ):
        # The resource usage data.
        self.ens_resource_usage = ens_resource_usage
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.ens_resource_usage:
            for k in self.ens_resource_usage:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EnsResourceUsage'] = []
        if self.ens_resource_usage is not None:
            for k in self.ens_resource_usage:
                result['EnsResourceUsage'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ens_resource_usage = []
        if m.get('EnsResourceUsage') is not None:
            for k in m.get('EnsResourceUsage'):
                temp_model = DescribeEnsResourceUsageResponseBodyEnsResourceUsage()
                self.ens_resource_usage.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeEnsResourceUsageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEnsResourceUsageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEnsResourceUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEnsRouteEntryListRequest(TeaModel):
    def __init__(
        self,
        destination_cidr_block: str = None,
        next_hop_id: str = None,
        next_hop_type: str = None,
        page_number: int = None,
        page_size: int = None,
        route_entry_id: str = None,
        route_entry_name: str = None,
        route_entry_type: str = None,
        route_table_id: str = None,
    ):
        # The destination Classless Inter-Domain Routing (CIDR) block of the route entry.
        self.destination_cidr_block = destination_cidr_block
        # The ID of the next hop.
        self.next_hop_id = next_hop_id
        # The type of next hop of the custom route entry. Valid values:
        # 
        # *   Instance (default): an ENS instance.
        # *   HaVip: a high-availability virtual IP address (HAVIP).
        # *   NetworkPeer: VPC peering connection.
        self.next_hop_type = next_hop_type
        # The page number of the returned page. Valid values: integers that are greater than 0. Default value: 1.
        self.page_number = page_number
        # The number of entries per page. Default value: 10. Valid values: 10 to 100.
        self.page_size = page_size
        # The ID of the route that you want to query.
        self.route_entry_id = route_entry_id
        # The name of the route.
        self.route_entry_name = route_entry_name
        # The route type. Valid values:
        # 
        # *   Custom: custom route
        # *   System: system route
        self.route_entry_type = route_entry_type
        # The ID of the route table that you want to query.
        self.route_table_id = route_table_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        if self.next_hop_id is not None:
            result['NextHopId'] = self.next_hop_id
        if self.next_hop_type is not None:
            result['NextHopType'] = self.next_hop_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.route_entry_id is not None:
            result['RouteEntryId'] = self.route_entry_id
        if self.route_entry_name is not None:
            result['RouteEntryName'] = self.route_entry_name
        if self.route_entry_type is not None:
            result['RouteEntryType'] = self.route_entry_type
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        if m.get('NextHopId') is not None:
            self.next_hop_id = m.get('NextHopId')
        if m.get('NextHopType') is not None:
            self.next_hop_type = m.get('NextHopType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RouteEntryId') is not None:
            self.route_entry_id = m.get('RouteEntryId')
        if m.get('RouteEntryName') is not None:
            self.route_entry_name = m.get('RouteEntryName')
        if m.get('RouteEntryType') is not None:
            self.route_entry_type = m.get('RouteEntryType')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        return self


class DescribeEnsRouteEntryListResponseBodyRouteEntrysNextHops(TeaModel):
    def __init__(
        self,
        next_hop_id: str = None,
        next_hop_name: str = None,
        next_hop_type: str = None,
    ):
        # The ID of the next hop.
        self.next_hop_id = next_hop_id
        # The instance ID of the next hop.
        self.next_hop_name = next_hop_name
        # The type of the next hop. Valid values:
        self.next_hop_type = next_hop_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_hop_id is not None:
            result['NextHopId'] = self.next_hop_id
        if self.next_hop_name is not None:
            result['NextHopName'] = self.next_hop_name
        if self.next_hop_type is not None:
            result['NextHopType'] = self.next_hop_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextHopId') is not None:
            self.next_hop_id = m.get('NextHopId')
        if m.get('NextHopName') is not None:
            self.next_hop_name = m.get('NextHopName')
        if m.get('NextHopType') is not None:
            self.next_hop_type = m.get('NextHopType')
        return self


class DescribeEnsRouteEntryListResponseBodyRouteEntrys(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        description: str = None,
        destination_cidr_block: str = None,
        next_hops: List[DescribeEnsRouteEntryListResponseBodyRouteEntrysNextHops] = None,
        route_entry_id: str = None,
        route_entry_name: str = None,
        route_table_id: str = None,
        source_cidr_block: str = None,
        status: str = None,
        type: str = None,
    ):
        # The time when the IP address was created. The time is displayed in UTC.
        self.creation_time = creation_time
        # Enter a description for the route.
        self.description = description
        # The destination CIDR block of the route.
        self.destination_cidr_block = destination_cidr_block
        # The information about the next hop.
        self.next_hops = next_hops
        # The ID of the route.
        self.route_entry_id = route_entry_id
        # The name of the route.
        self.route_entry_name = route_entry_name
        # The ID of the route table.
        self.route_table_id = route_table_id
        # The source CIDR block. This field is used when you configure a route entry in the gateway route table. This field is not supported in the vSwitch route table.
        self.source_cidr_block = source_cidr_block
        # The status of the route entry. Valid values:
        self.status = status
        # The type of the route entry.
        self.type = type

    def validate(self):
        if self.next_hops:
            for k in self.next_hops:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        result['NextHops'] = []
        if self.next_hops is not None:
            for k in self.next_hops:
                result['NextHops'].append(k.to_map() if k else None)
        if self.route_entry_id is not None:
            result['RouteEntryId'] = self.route_entry_id
        if self.route_entry_name is not None:
            result['RouteEntryName'] = self.route_entry_name
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        if self.source_cidr_block is not None:
            result['SourceCidrBlock'] = self.source_cidr_block
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        self.next_hops = []
        if m.get('NextHops') is not None:
            for k in m.get('NextHops'):
                temp_model = DescribeEnsRouteEntryListResponseBodyRouteEntrysNextHops()
                self.next_hops.append(temp_model.from_map(k))
        if m.get('RouteEntryId') is not None:
            self.route_entry_id = m.get('RouteEntryId')
        if m.get('RouteEntryName') is not None:
            self.route_entry_name = m.get('RouteEntryName')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        if m.get('SourceCidrBlock') is not None:
            self.source_cidr_block = m.get('SourceCidrBlock')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeEnsRouteEntryListResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        route_entrys: List[DescribeEnsRouteEntryListResponseBodyRouteEntrys] = None,
        total_count: int = None,
    ):
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # The information about the routes.
        self.route_entrys = route_entrys
        # The number of returned entries.
        self.total_count = total_count

    def validate(self):
        if self.route_entrys:
            for k in self.route_entrys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['RouteEntrys'] = []
        if self.route_entrys is not None:
            for k in self.route_entrys:
                result['RouteEntrys'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.route_entrys = []
        if m.get('RouteEntrys') is not None:
            for k in m.get('RouteEntrys'):
                temp_model = DescribeEnsRouteEntryListResponseBodyRouteEntrys()
                self.route_entrys.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeEnsRouteEntryListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEnsRouteEntryListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEnsRouteEntryListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEnsRouteTablesRequest(TeaModel):
    def __init__(
        self,
        associate_type: str = None,
        ens_region_id: str = None,
        ens_region_ids: List[str] = None,
        network_id: str = None,
        page_number: int = None,
        page_size: int = None,
        route_table_id: str = None,
        route_table_name: str = None,
        type: str = None,
    ):
        # The type of the resource with which the route table is associated. Valid values:
        # 
        # *   **VSwitch**\
        # *   **Gateway**\
        self.associate_type = associate_type
        # The ID of the ENS node.
        self.ens_region_id = ens_region_id
        # The IDs of edge nodes. You can specify 1 to 100 IDs.
        self.ens_region_ids = ens_region_ids
        # The ID of the network.
        self.network_id = network_id
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The ID of the route table.
        self.route_table_id = route_table_id
        # The name of the route table.
        self.route_table_name = route_table_name
        # The SNAT type.
        # 
        # *   FullCone: full cone NAT.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.associate_type is not None:
            result['AssociateType'] = self.associate_type
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.ens_region_ids is not None:
            result['EnsRegionIds'] = self.ens_region_ids
        if self.network_id is not None:
            result['NetworkId'] = self.network_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        if self.route_table_name is not None:
            result['RouteTableName'] = self.route_table_name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssociateType') is not None:
            self.associate_type = m.get('AssociateType')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('EnsRegionIds') is not None:
            self.ens_region_ids = m.get('EnsRegionIds')
        if m.get('NetworkId') is not None:
            self.network_id = m.get('NetworkId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        if m.get('RouteTableName') is not None:
            self.route_table_name = m.get('RouteTableName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeEnsRouteTablesResponseBodyRouteTables(TeaModel):
    def __init__(
        self,
        associate_type: str = None,
        creation_time: str = None,
        description: str = None,
        ens_region_id: str = None,
        is_default_gateway_route_table: bool = None,
        network_id: str = None,
        route_table_id: str = None,
        route_table_name: str = None,
        status: str = None,
        type: str = None,
        v_switch_ids: List[str] = None,
    ):
        # The type of the resource with which the route table is associated. Valid values:
        # 
        # *   **VSwitch**\
        # *   **Gateway**\
        self.associate_type = associate_type
        # The time when the route table was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.creation_time = creation_time
        # The description.
        self.description = description
        # The ID of the edge node.
        self.ens_region_id = ens_region_id
        # Specifies whether it is the default gateway route table.
        self.is_default_gateway_route_table = is_default_gateway_route_table
        # The ID of the network.
        self.network_id = network_id
        # The ID of the route table.
        self.route_table_id = route_table_id
        # The name of the route table that you want to query.
        # 
        # The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-).
        self.route_table_name = route_table_name
        # The status. Valid values:
        # 
        # *   Available: The route table is available.
        self.status = status
        # The type of the route table. Examples:
        # 
        # *   Custom: custom route table.
        # *   System: system route table.
        self.type = type
        # The vSwitches that are associated with the route table.
        self.v_switch_ids = v_switch_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.associate_type is not None:
            result['AssociateType'] = self.associate_type
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.is_default_gateway_route_table is not None:
            result['IsDefaultGatewayRouteTable'] = self.is_default_gateway_route_table
        if self.network_id is not None:
            result['NetworkId'] = self.network_id
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        if self.route_table_name is not None:
            result['RouteTableName'] = self.route_table_name
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.v_switch_ids is not None:
            result['VSwitchIds'] = self.v_switch_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssociateType') is not None:
            self.associate_type = m.get('AssociateType')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('IsDefaultGatewayRouteTable') is not None:
            self.is_default_gateway_route_table = m.get('IsDefaultGatewayRouteTable')
        if m.get('NetworkId') is not None:
            self.network_id = m.get('NetworkId')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        if m.get('RouteTableName') is not None:
            self.route_table_name = m.get('RouteTableName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('VSwitchIds') is not None:
            self.v_switch_ids = m.get('VSwitchIds')
        return self


class DescribeEnsRouteTablesResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        route_tables: List[DescribeEnsRouteTablesResponseBodyRouteTables] = None,
        total_count: int = None,
    ):
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The information about the route tables.
        self.route_tables = route_tables
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.route_tables:
            for k in self.route_tables:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['RouteTables'] = []
        if self.route_tables is not None:
            for k in self.route_tables:
                result['RouteTables'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.route_tables = []
        if m.get('RouteTables') is not None:
            for k in m.get('RouteTables'):
                temp_model = DescribeEnsRouteTablesResponseBodyRouteTables()
                self.route_tables.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeEnsRouteTablesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEnsRouteTablesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEnsRouteTablesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEnsSaleControlRequest(TeaModel):
    def __init__(
        self,
        ali_uid_account: str = None,
        commodity_code: str = None,
        custom_account: str = None,
        module_code: str = None,
        order_type: str = None,
    ):
        self.ali_uid_account = ali_uid_account
        # This parameter is required.
        self.commodity_code = commodity_code
        self.custom_account = custom_account
        self.module_code = module_code
        self.order_type = order_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid_account is not None:
            result['AliUidAccount'] = self.ali_uid_account
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.custom_account is not None:
            result['CustomAccount'] = self.custom_account
        if self.module_code is not None:
            result['ModuleCode'] = self.module_code
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliUidAccount') is not None:
            self.ali_uid_account = m.get('AliUidAccount')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('CustomAccount') is not None:
            self.custom_account = m.get('CustomAccount')
        if m.get('ModuleCode') is not None:
            self.module_code = m.get('ModuleCode')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        return self


class DescribeEnsSaleControlResponseBodySaleControlSaleControlItemsSaleControlItemBasicSaleControlModuleValue(TeaModel):
    def __init__(
        self,
        module_max_value: str = None,
        module_min_value: str = None,
        module_value: List[str] = None,
    ):
        self.module_max_value = module_max_value
        self.module_min_value = module_min_value
        self.module_value = module_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.module_max_value is not None:
            result['ModuleMaxValue'] = self.module_max_value
        if self.module_min_value is not None:
            result['ModuleMinValue'] = self.module_min_value
        if self.module_value is not None:
            result['ModuleValue'] = self.module_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ModuleMaxValue') is not None:
            self.module_max_value = m.get('ModuleMaxValue')
        if m.get('ModuleMinValue') is not None:
            self.module_min_value = m.get('ModuleMinValue')
        if m.get('ModuleValue') is not None:
            self.module_value = m.get('ModuleValue')
        return self


class DescribeEnsSaleControlResponseBodySaleControlSaleControlItemsSaleControlItemBasicSaleControl(TeaModel):
    def __init__(
        self,
        description: str = None,
        module_value: DescribeEnsSaleControlResponseBodySaleControlSaleControlItemsSaleControlItemBasicSaleControlModuleValue = None,
        operator: str = None,
    ):
        self.description = description
        self.module_value = module_value
        self.operator = operator

    def validate(self):
        if self.module_value:
            self.module_value.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.module_value is not None:
            result['ModuleValue'] = self.module_value.to_map()
        if self.operator is not None:
            result['Operator'] = self.operator
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ModuleValue') is not None:
            temp_model = DescribeEnsSaleControlResponseBodySaleControlSaleControlItemsSaleControlItemBasicSaleControlModuleValue()
            self.module_value = temp_model.from_map(m['ModuleValue'])
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        return self


class DescribeEnsSaleControlResponseBodySaleControlSaleControlItemsSaleControlItemConditionSaleControlConditionControl(TeaModel):
    def __init__(
        self,
        condition_control_module_code: str = None,
        condition_control_module_value: str = None,
    ):
        self.condition_control_module_code = condition_control_module_code
        self.condition_control_module_value = condition_control_module_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.condition_control_module_code is not None:
            result['ConditionControlModuleCode'] = self.condition_control_module_code
        if self.condition_control_module_value is not None:
            result['ConditionControlModuleValue'] = self.condition_control_module_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConditionControlModuleCode') is not None:
            self.condition_control_module_code = m.get('ConditionControlModuleCode')
        if m.get('ConditionControlModuleValue') is not None:
            self.condition_control_module_value = m.get('ConditionControlModuleValue')
        return self


class DescribeEnsSaleControlResponseBodySaleControlSaleControlItemsSaleControlItemConditionSaleControlModuleValue(TeaModel):
    def __init__(
        self,
        module_max_value: str = None,
        module_min_value: str = None,
        module_value: List[str] = None,
    ):
        self.module_max_value = module_max_value
        self.module_min_value = module_min_value
        self.module_value = module_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.module_max_value is not None:
            result['ModuleMaxValue'] = self.module_max_value
        if self.module_min_value is not None:
            result['ModuleMinValue'] = self.module_min_value
        if self.module_value is not None:
            result['ModuleValue'] = self.module_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ModuleMaxValue') is not None:
            self.module_max_value = m.get('ModuleMaxValue')
        if m.get('ModuleMinValue') is not None:
            self.module_min_value = m.get('ModuleMinValue')
        if m.get('ModuleValue') is not None:
            self.module_value = m.get('ModuleValue')
        return self


class DescribeEnsSaleControlResponseBodySaleControlSaleControlItemsSaleControlItemConditionSaleControl(TeaModel):
    def __init__(
        self,
        condition_control: DescribeEnsSaleControlResponseBodySaleControlSaleControlItemsSaleControlItemConditionSaleControlConditionControl = None,
        description: str = None,
        module_value: DescribeEnsSaleControlResponseBodySaleControlSaleControlItemsSaleControlItemConditionSaleControlModuleValue = None,
        operator: str = None,
    ):
        self.condition_control = condition_control
        self.description = description
        self.module_value = module_value
        self.operator = operator

    def validate(self):
        if self.condition_control:
            self.condition_control.validate()
        if self.module_value:
            self.module_value.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.condition_control is not None:
            result['ConditionControl'] = self.condition_control.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.module_value is not None:
            result['ModuleValue'] = self.module_value.to_map()
        if self.operator is not None:
            result['Operator'] = self.operator
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConditionControl') is not None:
            temp_model = DescribeEnsSaleControlResponseBodySaleControlSaleControlItemsSaleControlItemConditionSaleControlConditionControl()
            self.condition_control = temp_model.from_map(m['ConditionControl'])
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ModuleValue') is not None:
            temp_model = DescribeEnsSaleControlResponseBodySaleControlSaleControlItemsSaleControlItemConditionSaleControlModuleValue()
            self.module_value = temp_model.from_map(m['ModuleValue'])
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        return self


class DescribeEnsSaleControlResponseBodySaleControlSaleControlItemsSaleControlItem(TeaModel):
    def __init__(
        self,
        basic_sale_control: DescribeEnsSaleControlResponseBodySaleControlSaleControlItemsSaleControlItemBasicSaleControl = None,
        condition_sale_control: List[DescribeEnsSaleControlResponseBodySaleControlSaleControlItemsSaleControlItemConditionSaleControl] = None,
    ):
        self.basic_sale_control = basic_sale_control
        self.condition_sale_control = condition_sale_control

    def validate(self):
        if self.basic_sale_control:
            self.basic_sale_control.validate()
        if self.condition_sale_control:
            for k in self.condition_sale_control:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.basic_sale_control is not None:
            result['BasicSaleControl'] = self.basic_sale_control.to_map()
        result['ConditionSaleControl'] = []
        if self.condition_sale_control is not None:
            for k in self.condition_sale_control:
                result['ConditionSaleControl'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BasicSaleControl') is not None:
            temp_model = DescribeEnsSaleControlResponseBodySaleControlSaleControlItemsSaleControlItemBasicSaleControl()
            self.basic_sale_control = temp_model.from_map(m['BasicSaleControl'])
        self.condition_sale_control = []
        if m.get('ConditionSaleControl') is not None:
            for k in m.get('ConditionSaleControl'):
                temp_model = DescribeEnsSaleControlResponseBodySaleControlSaleControlItemsSaleControlItemConditionSaleControl()
                self.condition_sale_control.append(temp_model.from_map(k))
        return self


class DescribeEnsSaleControlResponseBodySaleControlSaleControlItems(TeaModel):
    def __init__(
        self,
        module_code: str = None,
        sale_control_item: DescribeEnsSaleControlResponseBodySaleControlSaleControlItemsSaleControlItem = None,
    ):
        self.module_code = module_code
        self.sale_control_item = sale_control_item

    def validate(self):
        if self.sale_control_item:
            self.sale_control_item.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.module_code is not None:
            result['ModuleCode'] = self.module_code
        if self.sale_control_item is not None:
            result['SaleControlItem'] = self.sale_control_item.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ModuleCode') is not None:
            self.module_code = m.get('ModuleCode')
        if m.get('SaleControlItem') is not None:
            temp_model = DescribeEnsSaleControlResponseBodySaleControlSaleControlItemsSaleControlItem()
            self.sale_control_item = temp_model.from_map(m['SaleControlItem'])
        return self


class DescribeEnsSaleControlResponseBodySaleControl(TeaModel):
    def __init__(
        self,
        commodity_code: str = None,
        order_type: str = None,
        sale_control_items: List[DescribeEnsSaleControlResponseBodySaleControlSaleControlItems] = None,
    ):
        self.commodity_code = commodity_code
        self.order_type = order_type
        self.sale_control_items = sale_control_items

    def validate(self):
        if self.sale_control_items:
            for k in self.sale_control_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        result['SaleControlItems'] = []
        if self.sale_control_items is not None:
            for k in self.sale_control_items:
                result['SaleControlItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        self.sale_control_items = []
        if m.get('SaleControlItems') is not None:
            for k in m.get('SaleControlItems'):
                temp_model = DescribeEnsSaleControlResponseBodySaleControlSaleControlItems()
                self.sale_control_items.append(temp_model.from_map(k))
        return self


class DescribeEnsSaleControlResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        sale_control: List[DescribeEnsSaleControlResponseBodySaleControl] = None,
    ):
        self.request_id = request_id
        self.sale_control = sale_control

    def validate(self):
        if self.sale_control:
            for k in self.sale_control:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SaleControl'] = []
        if self.sale_control is not None:
            for k in self.sale_control:
                result['SaleControl'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.sale_control = []
        if m.get('SaleControl') is not None:
            for k in m.get('SaleControl'):
                temp_model = DescribeEnsSaleControlResponseBodySaleControl()
                self.sale_control.append(temp_model.from_map(k))
        return self


class DescribeEnsSaleControlResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEnsSaleControlResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEnsSaleControlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEnsSaleControlAvailableResourceRequest(TeaModel):
    def __init__(
        self,
        commodity_code: str = None,
        custom_account: str = None,
        order_type: str = None,
    ):
        # This parameter is required.
        self.commodity_code = commodity_code
        self.custom_account = custom_account
        self.order_type = order_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.custom_account is not None:
            result['CustomAccount'] = self.custom_account
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('CustomAccount') is not None:
            self.custom_account = m.get('CustomAccount')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        return self


class DescribeEnsSaleControlAvailableResourceResponseBodySaleControlAvailableResourceAvailableDiskType(TeaModel):
    def __init__(
        self,
        disk_name: str = None,
        disk_type: str = None,
    ):
        self.disk_name = disk_name
        self.disk_type = disk_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        return self


class DescribeEnsSaleControlAvailableResourceResponseBodySaleControlAvailableResourceAvailableRegion(TeaModel):
    def __init__(
        self,
        area: str = None,
        city: str = None,
        country: str = None,
        ens_region_id: str = None,
        ens_region_name: str = None,
        isp: str = None,
        province: str = None,
    ):
        self.area = area
        self.city = city
        self.country = country
        self.ens_region_id = ens_region_id
        self.ens_region_name = ens_region_name
        self.isp = isp
        self.province = province

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.area is not None:
            result['Area'] = self.area
        if self.city is not None:
            result['City'] = self.city
        if self.country is not None:
            result['Country'] = self.country
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.ens_region_name is not None:
            result['EnsRegionName'] = self.ens_region_name
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.province is not None:
            result['Province'] = self.province
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Area') is not None:
            self.area = m.get('Area')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('Country') is not None:
            self.country = m.get('Country')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('EnsRegionName') is not None:
            self.ens_region_name = m.get('EnsRegionName')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        return self


class DescribeEnsSaleControlAvailableResourceResponseBodySaleControlAvailableResourceAvailableSpec(TeaModel):
    def __init__(
        self,
        cores: str = None,
        memory: str = None,
        spec_name: str = None,
        spec_value: str = None,
    ):
        self.cores = cores
        self.memory = memory
        self.spec_name = spec_name
        self.spec_value = spec_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cores is not None:
            result['Cores'] = self.cores
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.spec_name is not None:
            result['SpecName'] = self.spec_name
        if self.spec_value is not None:
            result['SpecValue'] = self.spec_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cores') is not None:
            self.cores = m.get('Cores')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('SpecName') is not None:
            self.spec_name = m.get('SpecName')
        if m.get('SpecValue') is not None:
            self.spec_value = m.get('SpecValue')
        return self


class DescribeEnsSaleControlAvailableResourceResponseBodySaleControlAvailableResourceAvailableStorageTypeAvailableDefaultStorageType(TeaModel):
    def __init__(
        self,
        storage_name: str = None,
        storage_type: str = None,
    ):
        self.storage_name = storage_name
        self.storage_type = storage_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.storage_name is not None:
            result['StorageName'] = self.storage_name
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StorageName') is not None:
            self.storage_name = m.get('StorageName')
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        return self


class DescribeEnsSaleControlAvailableResourceResponseBodySaleControlAvailableResourceAvailableStorageTypeAvailableSpecialStorageType(TeaModel):
    def __init__(
        self,
        storage_type: str = None,
        storage_name: str = None,
        ens_region_id: str = None,
    ):
        self.storage_type = storage_type
        self.storage_name = storage_name
        self.ens_region_id = ens_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        if self.storage_name is not None:
            result['StorageName'] = self.storage_name
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        if m.get('StorageName') is not None:
            self.storage_name = m.get('StorageName')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        return self


class DescribeEnsSaleControlAvailableResourceResponseBodySaleControlAvailableResourceAvailableStorageType(TeaModel):
    def __init__(
        self,
        available_default_storage_type: List[DescribeEnsSaleControlAvailableResourceResponseBodySaleControlAvailableResourceAvailableStorageTypeAvailableDefaultStorageType] = None,
        available_special_storage_type: List[List[DescribeEnsSaleControlAvailableResourceResponseBodySaleControlAvailableResourceAvailableStorageTypeAvailableSpecialStorageType]] = None,
    ):
        self.available_default_storage_type = available_default_storage_type
        self.available_special_storage_type = available_special_storage_type

    def validate(self):
        if self.available_default_storage_type:
            for k in self.available_default_storage_type:
                if k:
                    k.validate()
        if self.available_special_storage_type:
            for k in self.available_special_storage_type:
                for k1 in k:
                    if k1:
                        k1.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AvailableDefaultStorageType'] = []
        if self.available_default_storage_type is not None:
            for k in self.available_default_storage_type:
                result['AvailableDefaultStorageType'].append(k.to_map() if k else None)
        result['AvailableSpecialStorageType'] = []
        if self.available_special_storage_type is not None:
            for k in self.available_special_storage_type:
                l1 = []
                for k1 in k:
                    l1.append(k1.to_map() if k1 else None)
                result['AvailableSpecialStorageType'].append(l1)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.available_default_storage_type = []
        if m.get('AvailableDefaultStorageType') is not None:
            for k in m.get('AvailableDefaultStorageType'):
                temp_model = DescribeEnsSaleControlAvailableResourceResponseBodySaleControlAvailableResourceAvailableStorageTypeAvailableDefaultStorageType()
                self.available_default_storage_type.append(temp_model.from_map(k))
        self.available_special_storage_type = []
        if m.get('AvailableSpecialStorageType') is not None:
            for k in m.get('AvailableSpecialStorageType'):
                l1 = []
                for k1 in k:
                    temp_model = DescribeEnsSaleControlAvailableResourceResponseBodySaleControlAvailableResourceAvailableStorageTypeAvailableSpecialStorageType()
                    l1.append(temp_model.from_map(k1))
                self.available_special_storage_type.append(l1)
        return self


class DescribeEnsSaleControlAvailableResourceResponseBodySaleControlAvailableResource(TeaModel):
    def __init__(
        self,
        available_disk_type: List[DescribeEnsSaleControlAvailableResourceResponseBodySaleControlAvailableResourceAvailableDiskType] = None,
        available_region: List[DescribeEnsSaleControlAvailableResourceResponseBodySaleControlAvailableResourceAvailableRegion] = None,
        available_spec: List[DescribeEnsSaleControlAvailableResourceResponseBodySaleControlAvailableResourceAvailableSpec] = None,
        available_storage_type: DescribeEnsSaleControlAvailableResourceResponseBodySaleControlAvailableResourceAvailableStorageType = None,
        commodity_code: str = None,
        order_type: str = None,
    ):
        self.available_disk_type = available_disk_type
        self.available_region = available_region
        self.available_spec = available_spec
        self.available_storage_type = available_storage_type
        self.commodity_code = commodity_code
        self.order_type = order_type

    def validate(self):
        if self.available_disk_type:
            for k in self.available_disk_type:
                if k:
                    k.validate()
        if self.available_region:
            for k in self.available_region:
                if k:
                    k.validate()
        if self.available_spec:
            for k in self.available_spec:
                if k:
                    k.validate()
        if self.available_storage_type:
            self.available_storage_type.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AvailableDiskType'] = []
        if self.available_disk_type is not None:
            for k in self.available_disk_type:
                result['AvailableDiskType'].append(k.to_map() if k else None)
        result['AvailableRegion'] = []
        if self.available_region is not None:
            for k in self.available_region:
                result['AvailableRegion'].append(k.to_map() if k else None)
        result['AvailableSpec'] = []
        if self.available_spec is not None:
            for k in self.available_spec:
                result['AvailableSpec'].append(k.to_map() if k else None)
        if self.available_storage_type is not None:
            result['AvailableStorageType'] = self.available_storage_type.to_map()
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.available_disk_type = []
        if m.get('AvailableDiskType') is not None:
            for k in m.get('AvailableDiskType'):
                temp_model = DescribeEnsSaleControlAvailableResourceResponseBodySaleControlAvailableResourceAvailableDiskType()
                self.available_disk_type.append(temp_model.from_map(k))
        self.available_region = []
        if m.get('AvailableRegion') is not None:
            for k in m.get('AvailableRegion'):
                temp_model = DescribeEnsSaleControlAvailableResourceResponseBodySaleControlAvailableResourceAvailableRegion()
                self.available_region.append(temp_model.from_map(k))
        self.available_spec = []
        if m.get('AvailableSpec') is not None:
            for k in m.get('AvailableSpec'):
                temp_model = DescribeEnsSaleControlAvailableResourceResponseBodySaleControlAvailableResourceAvailableSpec()
                self.available_spec.append(temp_model.from_map(k))
        if m.get('AvailableStorageType') is not None:
            temp_model = DescribeEnsSaleControlAvailableResourceResponseBodySaleControlAvailableResourceAvailableStorageType()
            self.available_storage_type = temp_model.from_map(m['AvailableStorageType'])
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        return self


class DescribeEnsSaleControlAvailableResourceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        sale_control_available_resource: List[DescribeEnsSaleControlAvailableResourceResponseBodySaleControlAvailableResource] = None,
    ):
        self.request_id = request_id
        self.sale_control_available_resource = sale_control_available_resource

    def validate(self):
        if self.sale_control_available_resource:
            for k in self.sale_control_available_resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SaleControlAvailableResource'] = []
        if self.sale_control_available_resource is not None:
            for k in self.sale_control_available_resource:
                result['SaleControlAvailableResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.sale_control_available_resource = []
        if m.get('SaleControlAvailableResource') is not None:
            for k in m.get('SaleControlAvailableResource'):
                temp_model = DescribeEnsSaleControlAvailableResourceResponseBodySaleControlAvailableResource()
                self.sale_control_available_resource.append(temp_model.from_map(k))
        return self


class DescribeEnsSaleControlAvailableResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEnsSaleControlAvailableResourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEnsSaleControlAvailableResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEnsSaleControlStockRequest(TeaModel):
    def __init__(
        self,
        ali_uid_account: str = None,
        commodity_code: str = None,
        custom_account: str = None,
        module_code: str = None,
        order_type: str = None,
    ):
        self.ali_uid_account = ali_uid_account
        # This parameter is required.
        self.commodity_code = commodity_code
        self.custom_account = custom_account
        self.module_code = module_code
        self.order_type = order_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid_account is not None:
            result['AliUidAccount'] = self.ali_uid_account
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.custom_account is not None:
            result['CustomAccount'] = self.custom_account
        if self.module_code is not None:
            result['ModuleCode'] = self.module_code
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliUidAccount') is not None:
            self.ali_uid_account = m.get('AliUidAccount')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('CustomAccount') is not None:
            self.custom_account = m.get('CustomAccount')
        if m.get('ModuleCode') is not None:
            self.module_code = m.get('ModuleCode')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        return self


class DescribeEnsSaleControlStockResponseBodySaleControlSaleControlItemsSaleControlItemBasicSaleControlModuleValue(TeaModel):
    def __init__(
        self,
        module_max_value: str = None,
        module_min_value: str = None,
    ):
        self.module_max_value = module_max_value
        self.module_min_value = module_min_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.module_max_value is not None:
            result['ModuleMaxValue'] = self.module_max_value
        if self.module_min_value is not None:
            result['ModuleMinValue'] = self.module_min_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ModuleMaxValue') is not None:
            self.module_max_value = m.get('ModuleMaxValue')
        if m.get('ModuleMinValue') is not None:
            self.module_min_value = m.get('ModuleMinValue')
        return self


class DescribeEnsSaleControlStockResponseBodySaleControlSaleControlItemsSaleControlItemBasicSaleControl(TeaModel):
    def __init__(
        self,
        module_value: DescribeEnsSaleControlStockResponseBodySaleControlSaleControlItemsSaleControlItemBasicSaleControlModuleValue = None,
        stock_value: str = None,
    ):
        self.module_value = module_value
        self.stock_value = stock_value

    def validate(self):
        if self.module_value:
            self.module_value.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.module_value is not None:
            result['ModuleValue'] = self.module_value.to_map()
        if self.stock_value is not None:
            result['StockValue'] = self.stock_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ModuleValue') is not None:
            temp_model = DescribeEnsSaleControlStockResponseBodySaleControlSaleControlItemsSaleControlItemBasicSaleControlModuleValue()
            self.module_value = temp_model.from_map(m['ModuleValue'])
        if m.get('StockValue') is not None:
            self.stock_value = m.get('StockValue')
        return self


class DescribeEnsSaleControlStockResponseBodySaleControlSaleControlItemsSaleControlItemConditionSaleControlConditionControl(TeaModel):
    def __init__(
        self,
        condition_control_module_code: str = None,
        condition_control_module_value: str = None,
    ):
        self.condition_control_module_code = condition_control_module_code
        self.condition_control_module_value = condition_control_module_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.condition_control_module_code is not None:
            result['ConditionControlModuleCode'] = self.condition_control_module_code
        if self.condition_control_module_value is not None:
            result['ConditionControlModuleValue'] = self.condition_control_module_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConditionControlModuleCode') is not None:
            self.condition_control_module_code = m.get('ConditionControlModuleCode')
        if m.get('ConditionControlModuleValue') is not None:
            self.condition_control_module_value = m.get('ConditionControlModuleValue')
        return self


class DescribeEnsSaleControlStockResponseBodySaleControlSaleControlItemsSaleControlItemConditionSaleControlModuleValue(TeaModel):
    def __init__(
        self,
        module_max_value: str = None,
        module_min_value: str = None,
    ):
        self.module_max_value = module_max_value
        self.module_min_value = module_min_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.module_max_value is not None:
            result['ModuleMaxValue'] = self.module_max_value
        if self.module_min_value is not None:
            result['ModuleMinValue'] = self.module_min_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ModuleMaxValue') is not None:
            self.module_max_value = m.get('ModuleMaxValue')
        if m.get('ModuleMinValue') is not None:
            self.module_min_value = m.get('ModuleMinValue')
        return self


class DescribeEnsSaleControlStockResponseBodySaleControlSaleControlItemsSaleControlItemConditionSaleControl(TeaModel):
    def __init__(
        self,
        condition_control: DescribeEnsSaleControlStockResponseBodySaleControlSaleControlItemsSaleControlItemConditionSaleControlConditionControl = None,
        module_value: DescribeEnsSaleControlStockResponseBodySaleControlSaleControlItemsSaleControlItemConditionSaleControlModuleValue = None,
        stock_value: str = None,
    ):
        self.condition_control = condition_control
        self.module_value = module_value
        self.stock_value = stock_value

    def validate(self):
        if self.condition_control:
            self.condition_control.validate()
        if self.module_value:
            self.module_value.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.condition_control is not None:
            result['ConditionControl'] = self.condition_control.to_map()
        if self.module_value is not None:
            result['ModuleValue'] = self.module_value.to_map()
        if self.stock_value is not None:
            result['StockValue'] = self.stock_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConditionControl') is not None:
            temp_model = DescribeEnsSaleControlStockResponseBodySaleControlSaleControlItemsSaleControlItemConditionSaleControlConditionControl()
            self.condition_control = temp_model.from_map(m['ConditionControl'])
        if m.get('ModuleValue') is not None:
            temp_model = DescribeEnsSaleControlStockResponseBodySaleControlSaleControlItemsSaleControlItemConditionSaleControlModuleValue()
            self.module_value = temp_model.from_map(m['ModuleValue'])
        if m.get('StockValue') is not None:
            self.stock_value = m.get('StockValue')
        return self


class DescribeEnsSaleControlStockResponseBodySaleControlSaleControlItemsSaleControlItem(TeaModel):
    def __init__(
        self,
        basic_sale_control: DescribeEnsSaleControlStockResponseBodySaleControlSaleControlItemsSaleControlItemBasicSaleControl = None,
        condition_sale_control: List[DescribeEnsSaleControlStockResponseBodySaleControlSaleControlItemsSaleControlItemConditionSaleControl] = None,
    ):
        self.basic_sale_control = basic_sale_control
        self.condition_sale_control = condition_sale_control

    def validate(self):
        if self.basic_sale_control:
            self.basic_sale_control.validate()
        if self.condition_sale_control:
            for k in self.condition_sale_control:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.basic_sale_control is not None:
            result['BasicSaleControl'] = self.basic_sale_control.to_map()
        result['ConditionSaleControl'] = []
        if self.condition_sale_control is not None:
            for k in self.condition_sale_control:
                result['ConditionSaleControl'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BasicSaleControl') is not None:
            temp_model = DescribeEnsSaleControlStockResponseBodySaleControlSaleControlItemsSaleControlItemBasicSaleControl()
            self.basic_sale_control = temp_model.from_map(m['BasicSaleControl'])
        self.condition_sale_control = []
        if m.get('ConditionSaleControl') is not None:
            for k in m.get('ConditionSaleControl'):
                temp_model = DescribeEnsSaleControlStockResponseBodySaleControlSaleControlItemsSaleControlItemConditionSaleControl()
                self.condition_sale_control.append(temp_model.from_map(k))
        return self


class DescribeEnsSaleControlStockResponseBodySaleControlSaleControlItems(TeaModel):
    def __init__(
        self,
        module_code: str = None,
        sale_control_item: DescribeEnsSaleControlStockResponseBodySaleControlSaleControlItemsSaleControlItem = None,
    ):
        self.module_code = module_code
        self.sale_control_item = sale_control_item

    def validate(self):
        if self.sale_control_item:
            self.sale_control_item.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.module_code is not None:
            result['ModuleCode'] = self.module_code
        if self.sale_control_item is not None:
            result['SaleControlItem'] = self.sale_control_item.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ModuleCode') is not None:
            self.module_code = m.get('ModuleCode')
        if m.get('SaleControlItem') is not None:
            temp_model = DescribeEnsSaleControlStockResponseBodySaleControlSaleControlItemsSaleControlItem()
            self.sale_control_item = temp_model.from_map(m['SaleControlItem'])
        return self


class DescribeEnsSaleControlStockResponseBodySaleControl(TeaModel):
    def __init__(
        self,
        commodity_code: str = None,
        order_type: str = None,
        sale_control_items: List[DescribeEnsSaleControlStockResponseBodySaleControlSaleControlItems] = None,
    ):
        self.commodity_code = commodity_code
        self.order_type = order_type
        self.sale_control_items = sale_control_items

    def validate(self):
        if self.sale_control_items:
            for k in self.sale_control_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        result['SaleControlItems'] = []
        if self.sale_control_items is not None:
            for k in self.sale_control_items:
                result['SaleControlItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        self.sale_control_items = []
        if m.get('SaleControlItems') is not None:
            for k in m.get('SaleControlItems'):
                temp_model = DescribeEnsSaleControlStockResponseBodySaleControlSaleControlItems()
                self.sale_control_items.append(temp_model.from_map(k))
        return self


class DescribeEnsSaleControlStockResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        sale_control: List[DescribeEnsSaleControlStockResponseBodySaleControl] = None,
    ):
        self.request_id = request_id
        self.sale_control = sale_control

    def validate(self):
        if self.sale_control:
            for k in self.sale_control:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SaleControl'] = []
        if self.sale_control is not None:
            for k in self.sale_control:
                result['SaleControl'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.sale_control = []
        if m.get('SaleControl') is not None:
            for k in m.get('SaleControl'):
                temp_model = DescribeEnsSaleControlStockResponseBodySaleControl()
                self.sale_control.append(temp_model.from_map(k))
        return self


class DescribeEnsSaleControlStockResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEnsSaleControlStockResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEnsSaleControlStockResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEpnBandWidthDataRequest(TeaModel):
    def __init__(
        self,
        epninstance_id: str = None,
        end_time: str = None,
        ens_region_id: str = None,
        instance_id: str = None,
        isp: str = None,
        networking_model: str = None,
        period: str = None,
        start_time: str = None,
    ):
        # The ID of the EPN instance.
        self.epninstance_id = epninstance_id
        # The end of the time range to query.
        # 
        # *   Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # *   If the value of the seconds place is not 00, the start time is automatically set to the next minute.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The ID of the Edge Node Service (ENS) node.
        self.ens_region_id = ens_region_id
        # The ID of the instance.
        self.instance_id = instance_id
        # The Internet service provider (ISP). Valid values:
        # 
        # *   cmcc: China Mobile
        # *   telecom: China Telecom
        # *   unicom: China Unicom
        # *   multiCarrier: multi-line ISP
        self.isp = isp
        # The networking mode. Valid values:
        # 
        # *   **SpeedUp**: intelligent acceleration network (Internet)
        # *   **Connection**: internal network
        # *   **SpeedUpAndConnection**: intelligent acceleration network and internal network
        self.networking_model = networking_model
        # The precision of the monitoring data that you want to obtain. Valid values: 300, 1200, 3600, and 14400. Default value: 300. Unit: seconds.
        # 
        # This parameter is required.
        self.period = period
        # The beginning of the time range to query.
        # 
        # *   Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # *   If the value of the seconds place is not 00, the start time is automatically set to the next minute.
        # 
        # This parameter is required.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.epninstance_id is not None:
            result['EPNInstanceId'] = self.epninstance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.networking_model is not None:
            result['NetworkingModel'] = self.networking_model
        if self.period is not None:
            result['Period'] = self.period
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EPNInstanceId') is not None:
            self.epninstance_id = m.get('EPNInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('NetworkingModel') is not None:
            self.networking_model = m.get('NetworkingModel')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeEpnBandWidthDataResponseBodyMonitorDataBandWidthMonitorData(TeaModel):
    def __init__(
        self,
        down_band_width: int = None,
        internet_rx: int = None,
        internet_tx: int = None,
        time_stamp: str = None,
        up_band_width: int = None,
    ):
        # The outbound bandwidth. Unit: bit/s.
        self.down_band_width = down_band_width
        # The Internet traffic to the instance. Unit: bytes.
        self.internet_rx = internet_rx
        # The Internet traffic from the instance. Unit: bytes.
        self.internet_tx = internet_tx
        # The timestamp when the monitoring data was queried. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.time_stamp = time_stamp
        # The inbound bandwidth. Unit: bit/s.
        self.up_band_width = up_band_width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.down_band_width is not None:
            result['DownBandWidth'] = self.down_band_width
        if self.internet_rx is not None:
            result['InternetRX'] = self.internet_rx
        if self.internet_tx is not None:
            result['InternetTX'] = self.internet_tx
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.up_band_width is not None:
            result['UpBandWidth'] = self.up_band_width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DownBandWidth') is not None:
            self.down_band_width = m.get('DownBandWidth')
        if m.get('InternetRX') is not None:
            self.internet_rx = m.get('InternetRX')
        if m.get('InternetTX') is not None:
            self.internet_tx = m.get('InternetTX')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('UpBandWidth') is not None:
            self.up_band_width = m.get('UpBandWidth')
        return self


class DescribeEpnBandWidthDataResponseBodyMonitorData(TeaModel):
    def __init__(
        self,
        band_width_monitor_data: List[DescribeEpnBandWidthDataResponseBodyMonitorDataBandWidthMonitorData] = None,
        max_down_band_width: int = None,
        max_up_band_width: int = None,
    ):
        # The bandwidth data.
        self.band_width_monitor_data = band_width_monitor_data
        # The maximum outbound bandwidth within the queried time range. Unit: bit/s.
        self.max_down_band_width = max_down_band_width
        # The maximum inbound bandwidth within the queried time range. Unit: bit/s.
        self.max_up_band_width = max_up_band_width

    def validate(self):
        if self.band_width_monitor_data:
            for k in self.band_width_monitor_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BandWidthMonitorData'] = []
        if self.band_width_monitor_data is not None:
            for k in self.band_width_monitor_data:
                result['BandWidthMonitorData'].append(k.to_map() if k else None)
        if self.max_down_band_width is not None:
            result['MaxDownBandWidth'] = self.max_down_band_width
        if self.max_up_band_width is not None:
            result['MaxUpBandWidth'] = self.max_up_band_width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.band_width_monitor_data = []
        if m.get('BandWidthMonitorData') is not None:
            for k in m.get('BandWidthMonitorData'):
                temp_model = DescribeEpnBandWidthDataResponseBodyMonitorDataBandWidthMonitorData()
                self.band_width_monitor_data.append(temp_model.from_map(k))
        if m.get('MaxDownBandWidth') is not None:
            self.max_down_band_width = m.get('MaxDownBandWidth')
        if m.get('MaxUpBandWidth') is not None:
            self.max_up_band_width = m.get('MaxUpBandWidth')
        return self


class DescribeEpnBandWidthDataResponseBody(TeaModel):
    def __init__(
        self,
        monitor_data: DescribeEpnBandWidthDataResponseBodyMonitorData = None,
        request_id: str = None,
    ):
        # The monitoring data of the instance.
        self.monitor_data = monitor_data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.monitor_data:
            self.monitor_data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.monitor_data is not None:
            result['MonitorData'] = self.monitor_data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MonitorData') is not None:
            temp_model = DescribeEpnBandWidthDataResponseBodyMonitorData()
            self.monitor_data = temp_model.from_map(m['MonitorData'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeEpnBandWidthDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEpnBandWidthDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEpnBandWidthDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEpnBandwitdhByInternetChargeTypeRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        ens_region_id: str = None,
        isp: str = None,
        networking_model: str = None,
        start_time: str = None,
    ):
        # The end of the time range to query.
        # 
        # *   Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # *   If the value of the seconds place is not 00, the start time is automatically set to the next minute.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The ID of the Edge Node Service (ENS) node.
        self.ens_region_id = ens_region_id
        # The Internet service provider (ISP). Valid values:
        # 
        # *   cmcc: China Mobile
        # *   telecom: China Telecom
        # *   unicom: China Unicom
        # *   multiCarrier: multi-line ISP
        self.isp = isp
        # The networking mode. Valid values:
        # 
        # *   **SpeedUp**: intelligent acceleration network (Internet)
        # *   **Connection**: internal network
        # *   **SpeedUpAndConnection**: intelligent acceleration network and internal network
        self.networking_model = networking_model
        # The beginning of the time range to query.
        # 
        # *   Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # *   If the value of the seconds place is not 00, the start time is automatically set to the next minute.
        # 
        # This parameter is required.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.networking_model is not None:
            result['NetworkingModel'] = self.networking_model
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('NetworkingModel') is not None:
            self.networking_model = m.get('NetworkingModel')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeEpnBandwitdhByInternetChargeTypeResponseBody(TeaModel):
    def __init__(
        self,
        bandwidth_value: int = None,
        internet_charge_type: str = None,
        request_id: str = None,
        time_stamp: str = None,
    ):
        # The bandwidth. Unit: bit/s.
        self.bandwidth_value = bandwidth_value
        # The metering method. Valid values:
        # 
        # *   BandwidthByDay: Pay by daily peak bandwidth
        # *   95BandwidthByMonth: Pay by monthly 95th percentile bandwidth
        # *   PayByBandwidth4thMonth: Pay by monthly fourth peak bandwidth
        # *   PayByBandwidth: Pay by fixed bandwidth
        # 
        # You can specify only one metering method for network usage and cannot overwrite the existing metering method.
        self.internet_charge_type = internet_charge_type
        # The request ID.
        self.request_id = request_id
        # The timestamp when the monitoring data was queried. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.time_stamp = time_stamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth_value is not None:
            result['BandwidthValue'] = self.bandwidth_value
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BandwidthValue') is not None:
            self.bandwidth_value = m.get('BandwidthValue')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeEpnBandwitdhByInternetChargeTypeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEpnBandwitdhByInternetChargeTypeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEpnBandwitdhByInternetChargeTypeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEpnInstanceAttributeRequest(TeaModel):
    def __init__(
        self,
        epninstance_id: str = None,
    ):
        # The ID of the EPN instance.
        # 
        # This parameter is required.
        self.epninstance_id = epninstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.epninstance_id is not None:
            result['EPNInstanceId'] = self.epninstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EPNInstanceId') is not None:
            self.epninstance_id = m.get('EPNInstanceId')
        return self


class DescribeEpnInstanceAttributeResponseBodyConfVersions(TeaModel):
    def __init__(
        self,
        conf_version: str = None,
        ens_region_id: str = None,
    ):
        # The version number.
        self.conf_version = conf_version
        # The ID of the node.
        self.ens_region_id = ens_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conf_version is not None:
            result['ConfVersion'] = self.conf_version
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfVersion') is not None:
            self.conf_version = m.get('ConfVersion')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        return self


class DescribeEpnInstanceAttributeResponseBodyInstances(TeaModel):
    def __init__(
        self,
        ens_region_id: str = None,
        instance_id: str = None,
        instance_name: str = None,
        isp: str = None,
        private_ip_address: str = None,
        public_ip_address: str = None,
        status: str = None,
    ):
        # The ID of the node.
        self.ens_region_id = ens_region_id
        # The ID of the instance.
        self.instance_id = instance_id
        # The name of the instance.
        self.instance_name = instance_name
        # The ISP. Valid values:
        # 
        # *   cmcc: China Mobile
        # *   unicom: China Unicom
        # *   telecom: China Telecom
        self.isp = isp
        # The private IP address.
        self.private_ip_address = private_ip_address
        # The public IP address.
        self.public_ip_address = public_ip_address
        # The status of the instance. Valid values:
        # 
        # *   Running
        # *   Stopped
        # *   Expired
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.public_ip_address is not None:
            result['PublicIpAddress'] = self.public_ip_address
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('PublicIpAddress') is not None:
            self.public_ip_address = m.get('PublicIpAddress')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeEpnInstanceAttributeResponseBodyVSwitches(TeaModel):
    def __init__(
        self,
        cidr_block: str = None,
        ens_region_id: str = None,
        v_switch_id: str = None,
        v_switch_name: str = None,
    ):
        # The CIDR block.
        self.cidr_block = cidr_block
        # The ID of the node.
        self.ens_region_id = ens_region_id
        # The ID of the vSwitch.
        self.v_switch_id = v_switch_id
        # The name of the vSwitch.
        self.v_switch_name = v_switch_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.v_switch_name is not None:
            result['VSwitchName'] = self.v_switch_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VSwitchName') is not None:
            self.v_switch_name = m.get('VSwitchName')
        return self


class DescribeEpnInstanceAttributeResponseBody(TeaModel):
    def __init__(
        self,
        conf_versions: List[DescribeEpnInstanceAttributeResponseBodyConfVersions] = None,
        epninstance_id: str = None,
        epninstance_name: str = None,
        instances: List[DescribeEpnInstanceAttributeResponseBodyInstances] = None,
        networking_model: str = None,
        request_id: str = None,
        v_switches: List[DescribeEpnInstanceAttributeResponseBodyVSwitches] = None,
    ):
        # The information about the EPN configurations.
        self.conf_versions = conf_versions
        # The ID of the EPN instance.
        self.epninstance_id = epninstance_id
        # The name of the EPN instance.
        self.epninstance_name = epninstance_name
        # The information about the instance.
        self.instances = instances
        # The networking mode. Valid values:
        # 
        # *   SpeedUp: intelligent acceleration network (Internet)
        # *   Connection: internal network
        # *   SpeedUpAndConnection: intelligent acceleration network and internal network
        self.networking_model = networking_model
        # The request ID.
        self.request_id = request_id
        # Details of the vSwitch.
        self.v_switches = v_switches

    def validate(self):
        if self.conf_versions:
            for k in self.conf_versions:
                if k:
                    k.validate()
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()
        if self.v_switches:
            for k in self.v_switches:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfVersions'] = []
        if self.conf_versions is not None:
            for k in self.conf_versions:
                result['ConfVersions'].append(k.to_map() if k else None)
        if self.epninstance_id is not None:
            result['EPNInstanceId'] = self.epninstance_id
        if self.epninstance_name is not None:
            result['EPNInstanceName'] = self.epninstance_name
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        if self.networking_model is not None:
            result['NetworkingModel'] = self.networking_model
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['VSwitches'] = []
        if self.v_switches is not None:
            for k in self.v_switches:
                result['VSwitches'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.conf_versions = []
        if m.get('ConfVersions') is not None:
            for k in m.get('ConfVersions'):
                temp_model = DescribeEpnInstanceAttributeResponseBodyConfVersions()
                self.conf_versions.append(temp_model.from_map(k))
        if m.get('EPNInstanceId') is not None:
            self.epninstance_id = m.get('EPNInstanceId')
        if m.get('EPNInstanceName') is not None:
            self.epninstance_name = m.get('EPNInstanceName')
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = DescribeEpnInstanceAttributeResponseBodyInstances()
                self.instances.append(temp_model.from_map(k))
        if m.get('NetworkingModel') is not None:
            self.networking_model = m.get('NetworkingModel')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.v_switches = []
        if m.get('VSwitches') is not None:
            for k in m.get('VSwitches'):
                temp_model = DescribeEpnInstanceAttributeResponseBodyVSwitches()
                self.v_switches.append(temp_model.from_map(k))
        return self


class DescribeEpnInstanceAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEpnInstanceAttributeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEpnInstanceAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEpnInstancesRequest(TeaModel):
    def __init__(
        self,
        epninstance_id: str = None,
        epninstance_name: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The version number.
        self.epninstance_id = epninstance_id
        # The name of the EPN instance.
        self.epninstance_name = epninstance_name
        # The page number. Default value: **1**.
        self.page_number = page_number
        # The number of entries per page. Valid values: **1 to 50**. Default value: **10**.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.epninstance_id is not None:
            result['EPNInstanceId'] = self.epninstance_id
        if self.epninstance_name is not None:
            result['EPNInstanceName'] = self.epninstance_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EPNInstanceId') is not None:
            self.epninstance_id = m.get('EPNInstanceId')
        if m.get('EPNInstanceName') is not None:
            self.epninstance_name = m.get('EPNInstanceName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeEpnInstancesResponseBodyEPNInstancesEPNInstance(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        epninstance_id: str = None,
        epninstance_name: str = None,
        epninstance_type: str = None,
        end_time: str = None,
        internet_max_bandwidth_out: int = None,
        modify_time: str = None,
        networking_model: str = None,
        start_time: str = None,
        status: str = None,
    ):
        # The time when the instance was created. The time is displayed in UTC.
        self.creation_time = creation_time
        # The ID of the EPN instance.
        self.epninstance_id = epninstance_id
        # The name of the EPN instance.
        self.epninstance_name = epninstance_name
        # Set the value to EdgeToEdge.
        self.epninstance_type = epninstance_type
        # The end of the time range during which the data was queried. The time is displayed in UTC.
        self.end_time = end_time
        # The inbound bandwidth. Unit: Mbit/s.
        self.internet_max_bandwidth_out = internet_max_bandwidth_out
        # The time when the instance was last modified. The time is displayed in UTC.
        self.modify_time = modify_time
        # The networking mode. Valid values:
        # 
        # *   SpeedUp: intelligent acceleration network (Internet)
        # *   Connection: internal network
        # *   SpeedUpAndConnection: intelligent acceleration network and internal network
        self.networking_model = networking_model
        # The beginning of the time range during which the data was queried. The time is displayed in UTC.
        self.start_time = start_time
        # The status of the instance. Valid values:
        # 
        # *   Running
        # *   Excuting
        # *   Stopped
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.epninstance_id is not None:
            result['EPNInstanceId'] = self.epninstance_id
        if self.epninstance_name is not None:
            result['EPNInstanceName'] = self.epninstance_name
        if self.epninstance_type is not None:
            result['EPNInstanceType'] = self.epninstance_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.internet_max_bandwidth_out is not None:
            result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.networking_model is not None:
            result['NetworkingModel'] = self.networking_model
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('EPNInstanceId') is not None:
            self.epninstance_id = m.get('EPNInstanceId')
        if m.get('EPNInstanceName') is not None:
            self.epninstance_name = m.get('EPNInstanceName')
        if m.get('EPNInstanceType') is not None:
            self.epninstance_type = m.get('EPNInstanceType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InternetMaxBandwidthOut') is not None:
            self.internet_max_bandwidth_out = m.get('InternetMaxBandwidthOut')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('NetworkingModel') is not None:
            self.networking_model = m.get('NetworkingModel')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeEpnInstancesResponseBodyEPNInstances(TeaModel):
    def __init__(
        self,
        epninstance: List[DescribeEpnInstancesResponseBodyEPNInstancesEPNInstance] = None,
    ):
        self.epninstance = epninstance

    def validate(self):
        if self.epninstance:
            for k in self.epninstance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EPNInstance'] = []
        if self.epninstance is not None:
            for k in self.epninstance:
                result['EPNInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.epninstance = []
        if m.get('EPNInstance') is not None:
            for k in m.get('EPNInstance'):
                temp_model = DescribeEpnInstancesResponseBodyEPNInstancesEPNInstance()
                self.epninstance.append(temp_model.from_map(k))
        return self


class DescribeEpnInstancesResponseBody(TeaModel):
    def __init__(
        self,
        epninstances: DescribeEpnInstancesResponseBodyEPNInstances = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # Details of EPN instances.
        self.epninstances = epninstances
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # The total number of pages returned.
        self.total_count = total_count

    def validate(self):
        if self.epninstances:
            self.epninstances.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.epninstances is not None:
            result['EPNInstances'] = self.epninstances.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EPNInstances') is not None:
            temp_model = DescribeEpnInstancesResponseBodyEPNInstances()
            self.epninstances = temp_model.from_map(m['EPNInstances'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeEpnInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEpnInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEpnInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEpnMeasurementDataRequest(TeaModel):
    def __init__(
        self,
        end_date: str = None,
        start_date: str = None,
    ):
        # The end of the time range to query. Specify the time in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # This parameter is required.
        self.end_date = end_date
        # The beginning of the time range to query. Specify the time in the yyyy-mm-ddthh:mm:ssz format. The time must be in UTC.
        # 
        # This parameter is required.
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class DescribeEpnMeasurementDataResponseBodyMeasurementDatasMeasurementDataBandWidthFeeDatasBandWidthFeeData(TeaModel):
    def __init__(
        self,
        cost_code: str = None,
        cost_name: str = None,
        cost_type: str = None,
        cost_val: int = None,
        isp_line: str = None,
    ):
        # The code of the billable item.
        self.cost_code = cost_code
        # The name of the billable item.
        self.cost_name = cost_name
        # Metering method
        # 
        # *   SpeedUp: bandwidth of intelligent acceleration
        # *   IntranetConnection: internal bandwidth
        self.cost_type = cost_type
        # The value of the billable item.
        self.cost_val = cost_val
        # This parameter is unavailable.
        self.isp_line = isp_line

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cost_code is not None:
            result['CostCode'] = self.cost_code
        if self.cost_name is not None:
            result['CostName'] = self.cost_name
        if self.cost_type is not None:
            result['CostType'] = self.cost_type
        if self.cost_val is not None:
            result['CostVal'] = self.cost_val
        if self.isp_line is not None:
            result['IspLine'] = self.isp_line
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CostCode') is not None:
            self.cost_code = m.get('CostCode')
        if m.get('CostName') is not None:
            self.cost_name = m.get('CostName')
        if m.get('CostType') is not None:
            self.cost_type = m.get('CostType')
        if m.get('CostVal') is not None:
            self.cost_val = m.get('CostVal')
        if m.get('IspLine') is not None:
            self.isp_line = m.get('IspLine')
        return self


class DescribeEpnMeasurementDataResponseBodyMeasurementDatasMeasurementDataBandWidthFeeDatas(TeaModel):
    def __init__(
        self,
        band_width_fee_data: List[DescribeEpnMeasurementDataResponseBodyMeasurementDatasMeasurementDataBandWidthFeeDatasBandWidthFeeData] = None,
    ):
        self.band_width_fee_data = band_width_fee_data

    def validate(self):
        if self.band_width_fee_data:
            for k in self.band_width_fee_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BandWidthFeeData'] = []
        if self.band_width_fee_data is not None:
            for k in self.band_width_fee_data:
                result['BandWidthFeeData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.band_width_fee_data = []
        if m.get('BandWidthFeeData') is not None:
            for k in m.get('BandWidthFeeData'):
                temp_model = DescribeEpnMeasurementDataResponseBodyMeasurementDatasMeasurementDataBandWidthFeeDatasBandWidthFeeData()
                self.band_width_fee_data.append(temp_model.from_map(k))
        return self


class DescribeEpnMeasurementDataResponseBodyMeasurementDatasMeasurementData(TeaModel):
    def __init__(
        self,
        band_width_fee_datas: DescribeEpnMeasurementDataResponseBodyMeasurementDatasMeasurementDataBandWidthFeeDatas = None,
        charge_model: str = None,
        cost_cycle: str = None,
        cost_end_time: str = None,
        cost_start_time: str = None,
    ):
        # The bandwidth data returned.
        self.band_width_fee_datas = band_width_fee_datas
        # The metering method. Valid values:
        # 
        # *   ChargeByUnified: unified metering.
        # *   ChargeByGrade: differential metering.
        self.charge_model = charge_model
        # The metering cycle.
        self.cost_cycle = cost_cycle
        # The end time of the metering cycle.
        self.cost_end_time = cost_end_time
        # The start time of the metering cycle.
        self.cost_start_time = cost_start_time

    def validate(self):
        if self.band_width_fee_datas:
            self.band_width_fee_datas.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.band_width_fee_datas is not None:
            result['BandWidthFeeDatas'] = self.band_width_fee_datas.to_map()
        if self.charge_model is not None:
            result['ChargeModel'] = self.charge_model
        if self.cost_cycle is not None:
            result['CostCycle'] = self.cost_cycle
        if self.cost_end_time is not None:
            result['CostEndTime'] = self.cost_end_time
        if self.cost_start_time is not None:
            result['CostStartTime'] = self.cost_start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BandWidthFeeDatas') is not None:
            temp_model = DescribeEpnMeasurementDataResponseBodyMeasurementDatasMeasurementDataBandWidthFeeDatas()
            self.band_width_fee_datas = temp_model.from_map(m['BandWidthFeeDatas'])
        if m.get('ChargeModel') is not None:
            self.charge_model = m.get('ChargeModel')
        if m.get('CostCycle') is not None:
            self.cost_cycle = m.get('CostCycle')
        if m.get('CostEndTime') is not None:
            self.cost_end_time = m.get('CostEndTime')
        if m.get('CostStartTime') is not None:
            self.cost_start_time = m.get('CostStartTime')
        return self


class DescribeEpnMeasurementDataResponseBodyMeasurementDatas(TeaModel):
    def __init__(
        self,
        measurement_data: List[DescribeEpnMeasurementDataResponseBodyMeasurementDatasMeasurementData] = None,
    ):
        self.measurement_data = measurement_data

    def validate(self):
        if self.measurement_data:
            for k in self.measurement_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MeasurementData'] = []
        if self.measurement_data is not None:
            for k in self.measurement_data:
                result['MeasurementData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.measurement_data = []
        if m.get('MeasurementData') is not None:
            for k in m.get('MeasurementData'):
                temp_model = DescribeEpnMeasurementDataResponseBodyMeasurementDatasMeasurementData()
                self.measurement_data.append(temp_model.from_map(k))
        return self


class DescribeEpnMeasurementDataResponseBody(TeaModel):
    def __init__(
        self,
        measurement_datas: DescribeEpnMeasurementDataResponseBodyMeasurementDatas = None,
        request_id: str = None,
    ):
        # The metering data returned.
        self.measurement_datas = measurement_datas
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.measurement_datas:
            self.measurement_datas.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.measurement_datas is not None:
            result['MeasurementDatas'] = self.measurement_datas.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MeasurementDatas') is not None:
            temp_model = DescribeEpnMeasurementDataResponseBodyMeasurementDatas()
            self.measurement_datas = temp_model.from_map(m['MeasurementDatas'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeEpnMeasurementDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEpnMeasurementDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEpnMeasurementDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExportImageInfoRequest(TeaModel):
    def __init__(
        self,
        image_id: str = None,
        image_name: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The ID of the image.
        self.image_id = image_id
        # The name of the image.
        self.image_name = image_name
        # The page number. Pages start from page **1**. Default value: **1**.
        self.page_number = page_number
        # The number of entries per page. Maximum value: **50**. Default value: **10**.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeExportImageInfoResponseBodyImagesImage(TeaModel):
    def __init__(
        self,
        architecture: str = None,
        creation_time: str = None,
        exported_image_url: str = None,
        image_export_status: str = None,
        image_id: str = None,
        image_name: str = None,
        image_owner_alias: str = None,
        platform: str = None,
    ):
        # The architecture of the image. Example: **x86_64**.
        self.architecture = architecture
        # The time when the image was created.
        self.creation_time = creation_time
        # The URL of the exported image.
        self.exported_image_url = exported_image_url
        # The export status of the image. Valid values:
        # 
        # *   Exporting
        # *   Exported
        # *   ExportError
        # *   Unexported
        self.image_export_status = image_export_status
        # The ID of the image.
        self.image_id = image_id
        # The name of the image.
        self.image_name = image_name
        # The source of the image. Valid values:
        # 
        # *   system: public image
        # *   self: custom image
        self.image_owner_alias = image_owner_alias
        # The OS.
        self.platform = platform

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.architecture is not None:
            result['Architecture'] = self.architecture
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.exported_image_url is not None:
            result['ExportedImageURL'] = self.exported_image_url
        if self.image_export_status is not None:
            result['ImageExportStatus'] = self.image_export_status
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.image_owner_alias is not None:
            result['ImageOwnerAlias'] = self.image_owner_alias
        if self.platform is not None:
            result['Platform'] = self.platform
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Architecture') is not None:
            self.architecture = m.get('Architecture')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('ExportedImageURL') is not None:
            self.exported_image_url = m.get('ExportedImageURL')
        if m.get('ImageExportStatus') is not None:
            self.image_export_status = m.get('ImageExportStatus')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('ImageOwnerAlias') is not None:
            self.image_owner_alias = m.get('ImageOwnerAlias')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        return self


class DescribeExportImageInfoResponseBodyImages(TeaModel):
    def __init__(
        self,
        image: List[DescribeExportImageInfoResponseBodyImagesImage] = None,
    ):
        self.image = image

    def validate(self):
        if self.image:
            for k in self.image:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Image'] = []
        if self.image is not None:
            for k in self.image:
                result['Image'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.image = []
        if m.get('Image') is not None:
            for k in m.get('Image'):
                temp_model = DescribeExportImageInfoResponseBodyImagesImage()
                self.image.append(temp_model.from_map(k))
        return self


class DescribeExportImageInfoResponseBody(TeaModel):
    def __init__(
        self,
        images: DescribeExportImageInfoResponseBodyImages = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The returned result. For more information, see the Images parameter described in the JSON-formatted sample success response.
        self.images = images
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.images:
            self.images.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.images is not None:
            result['Images'] = self.images.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Images') is not None:
            temp_model = DescribeExportImageInfoResponseBodyImages()
            self.images = temp_model.from_map(m['Images'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeExportImageInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeExportImageInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeExportImageInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExportImageStatusRequest(TeaModel):
    def __init__(
        self,
        image_id: str = None,
    ):
        # The ID of the image.
        # 
        # This parameter is required.
        self.image_id = image_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        return self


class DescribeExportImageStatusResponseBody(TeaModel):
    def __init__(
        self,
        image_export_status: str = None,
        request_id: str = None,
    ):
        # The export status of the image. Valid values:
        # 
        # *   Exporting
        # *   Exported
        # *   ExportError
        # *   Unexported
        self.image_export_status = image_export_status
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_export_status is not None:
            result['ImageExportStatus'] = self.image_export_status
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageExportStatus') is not None:
            self.image_export_status = m.get('ImageExportStatus')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeExportImageStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeExportImageStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeExportImageStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFileSystemsRequest(TeaModel):
    def __init__(
        self,
        ens_region_id: str = None,
        file_system_id: str = None,
        file_system_name: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The ID of the region.
        self.ens_region_id = ens_region_id
        # The ID of the file system.
        self.file_system_id = file_system_id
        # The name of the file system.
        self.file_system_name = file_system_name
        # The page number. Pages start from page **1**. Default value: **1**.
        self.page_number = page_number
        # The number of entries per page. Maximum value: **100**. Default value: **10**.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.file_system_id is not None:
            result['FileSystemId'] = self.file_system_id
        if self.file_system_name is not None:
            result['FileSystemName'] = self.file_system_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('FileSystemId') is not None:
            self.file_system_id = m.get('FileSystemId')
        if m.get('FileSystemName') is not None:
            self.file_system_name = m.get('FileSystemName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeFileSystemsResponseBodyFileSystemsMountTargets(TeaModel):
    def __init__(
        self,
        mount_target_domain: str = None,
        mount_target_name: str = None,
        net_work_id: str = None,
        status: str = None,
    ):
        # The path of the mount target.
        self.mount_target_domain = mount_target_domain
        # The name of the mount target.
        self.mount_target_name = mount_target_name
        # The ID of the network.
        self.net_work_id = net_work_id
        # The status of the mount target. Valid values:
        # 
        # *   active: The mount target is available.
        # *   inactive: The mount target is unavailable.
        # *   pending: The task is running.
        # *   deleting: The mount target is being deleted.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mount_target_domain is not None:
            result['MountTargetDomain'] = self.mount_target_domain
        if self.mount_target_name is not None:
            result['MountTargetName'] = self.mount_target_name
        if self.net_work_id is not None:
            result['NetWorkId'] = self.net_work_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MountTargetDomain') is not None:
            self.mount_target_domain = m.get('MountTargetDomain')
        if m.get('MountTargetName') is not None:
            self.mount_target_name = m.get('MountTargetName')
        if m.get('NetWorkId') is not None:
            self.net_work_id = m.get('NetWorkId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeFileSystemsResponseBodyFileSystems(TeaModel):
    def __init__(
        self,
        capacity: int = None,
        creation_time: str = None,
        description: str = None,
        ens_region_id: str = None,
        file_system_id: str = None,
        file_system_name: str = None,
        metered_size: int = None,
        mount_targets: List[DescribeFileSystemsResponseBodyFileSystemsMountTargets] = None,
        pay_type: str = None,
        protocol_type: str = None,
        status: str = None,
        storage_type: str = None,
    ):
        # The capacity of the file system. Unit: MiB.
        self.capacity = capacity
        # The time when the file system was created.
        self.creation_time = creation_time
        self.description = description
        # The ID of the region.
        self.ens_region_id = ens_region_id
        # The ID of the file system.
        self.file_system_id = file_system_id
        # The name of the file system.
        self.file_system_name = file_system_name
        # The storage usage of the file system. The value of this parameter is the maximum storage usage of the file system over the last hour. Unit: bytes.
        self.metered_size = metered_size
        # The information about mount targets.
        self.mount_targets = mount_targets
        # The billing method. PostPaid is returned. PostPaid indicates the pay-as-you-go billing method.
        self.pay_type = pay_type
        # The protocol type of the file system. Valid values:
        # 
        # *   NFS: Network File System (NFS)
        # *   SMB: Server Message Block (SMB)
        self.protocol_type = protocol_type
        # The status of the file system. Valid values:
        # 
        # *   pending: The file system is being created or modified.
        # *   running: The file system is available. Before you create a mount target for the file system, make sure that the file system is in the running state.
        # *   stopped: The file system is unavailable.
        # *   extending: The file system is being scaled out.
        # *   stopping: The file system is being disabled.
        # *   deleting: The file system is being deleted.
        self.status = status
        # The storage type. Valid values:
        # 
        # *   capacity: Capacity NAS file systems
        # *   performance: Performance NAS file systems
        self.storage_type = storage_type

    def validate(self):
        if self.mount_targets:
            for k in self.mount_targets:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.capacity is not None:
            result['Capacity'] = self.capacity
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.file_system_id is not None:
            result['FileSystemId'] = self.file_system_id
        if self.file_system_name is not None:
            result['FileSystemName'] = self.file_system_name
        if self.metered_size is not None:
            result['MeteredSize'] = self.metered_size
        result['MountTargets'] = []
        if self.mount_targets is not None:
            for k in self.mount_targets:
                result['MountTargets'].append(k.to_map() if k else None)
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.status is not None:
            result['Status'] = self.status
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Capacity') is not None:
            self.capacity = m.get('Capacity')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('FileSystemId') is not None:
            self.file_system_id = m.get('FileSystemId')
        if m.get('FileSystemName') is not None:
            self.file_system_name = m.get('FileSystemName')
        if m.get('MeteredSize') is not None:
            self.metered_size = m.get('MeteredSize')
        self.mount_targets = []
        if m.get('MountTargets') is not None:
            for k in m.get('MountTargets'):
                temp_model = DescribeFileSystemsResponseBodyFileSystemsMountTargets()
                self.mount_targets.append(temp_model.from_map(k))
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        return self


class DescribeFileSystemsResponseBody(TeaModel):
    def __init__(
        self,
        file_systems: List[DescribeFileSystemsResponseBodyFileSystems] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The information about the file systems.
        self.file_systems = file_systems
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.file_systems:
            for k in self.file_systems:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FileSystems'] = []
        if self.file_systems is not None:
            for k in self.file_systems:
                result['FileSystems'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.file_systems = []
        if m.get('FileSystems') is not None:
            for k in m.get('FileSystems'):
                temp_model = DescribeFileSystemsResponseBodyFileSystems()
                self.file_systems.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeFileSystemsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeFileSystemsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeFileSystemsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeForwardTableEntriesRequest(TeaModel):
    def __init__(
        self,
        external_ip: str = None,
        forward_entry_id: str = None,
        forward_entry_name: str = None,
        internal_ip: str = None,
        ip_protocol: str = None,
        nat_gateway_id: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The EIP in the DNAT entry. The public IP address is used to access the Internet.
        self.external_ip = external_ip
        # The ID of the DNAT entry.
        self.forward_entry_id = forward_entry_id
        # The name of the DNAT entry.
        self.forward_entry_name = forward_entry_name
        # The private IP address of the instance that uses the DNAT entry for Internet communication.
        self.internal_ip = internal_ip
        # The protocol. Valid values:
        # 
        # *   **TCP**: forwards TCP packets.
        # *   **UDP**: forwards UDP packets.
        # *   **Any**: forwards all packets.
        self.ip_protocol = ip_protocol
        # The ID of the NAT gateway.
        # 
        # This parameter is required.
        self.nat_gateway_id = nat_gateway_id
        # The page number. Pages start from page **1**.
        # 
        # Default value: **1**.
        self.page_number = page_number
        # The number of entries per page. Maximum value: **100**.
        # 
        # Default value: **10**.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_ip is not None:
            result['ExternalIp'] = self.external_ip
        if self.forward_entry_id is not None:
            result['ForwardEntryId'] = self.forward_entry_id
        if self.forward_entry_name is not None:
            result['ForwardEntryName'] = self.forward_entry_name
        if self.internal_ip is not None:
            result['InternalIp'] = self.internal_ip
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalIp') is not None:
            self.external_ip = m.get('ExternalIp')
        if m.get('ForwardEntryId') is not None:
            self.forward_entry_id = m.get('ForwardEntryId')
        if m.get('ForwardEntryName') is not None:
            self.forward_entry_name = m.get('ForwardEntryName')
        if m.get('InternalIp') is not None:
            self.internal_ip = m.get('InternalIp')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeForwardTableEntriesResponseBodyForwardTableEntries(TeaModel):
    def __init__(
        self,
        external_ip: str = None,
        external_port: str = None,
        forward_entry_id: str = None,
        forward_entry_name: str = None,
        health_check_port: str = None,
        internal_ip: str = None,
        internal_port: str = None,
        ip_protocol: str = None,
        nat_gateway_id: str = None,
        standby_external_ip: str = None,
        standby_status: str = None,
        status: str = None,
    ):
        # The EIP in the DNAT entry. The public IP address is used to access the Internet.
        self.external_ip = external_ip
        # The external port or port range that is used in port forwarding.
        self.external_port = external_port
        # The ID of the DNAT entry.
        self.forward_entry_id = forward_entry_id
        # The name of the DNAT entry.
        self.forward_entry_name = forward_entry_name
        # The probe port of DNAT.
        self.health_check_port = health_check_port
        # The private IP address of the instance that uses the DNAT entry for Internet communication.
        self.internal_ip = internal_ip
        # The internal port or port range that is used for port forwarding.
        self.internal_port = internal_port
        # The protocol. Valid values:
        # 
        # *   **TCP**: forwards TCP packets.
        # *   **UDP**: forwards UDP packets.
        # *   **Any**: forwards all packets.
        self.ip_protocol = ip_protocol
        # The ID of the NAT gateway.
        self.nat_gateway_id = nat_gateway_id
        # The secondary EIP that is used to access the Internet.
        self.standby_external_ip = standby_external_ip
        # The status of the secondary EIP. Valid values:
        # 
        # *   Running
        # *   Stopping
        # *   Stopped
        # *   Starting
        self.standby_status = standby_status
        # The status of the DNAT entry. Valid values:
        # 
        # *   Pending: The DNAT entry is being created or modified.
        # *   Available: The DNAT entry is available.
        # *   Deleting: The DNAT entry is being deleted.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_ip is not None:
            result['ExternalIp'] = self.external_ip
        if self.external_port is not None:
            result['ExternalPort'] = self.external_port
        if self.forward_entry_id is not None:
            result['ForwardEntryId'] = self.forward_entry_id
        if self.forward_entry_name is not None:
            result['ForwardEntryName'] = self.forward_entry_name
        if self.health_check_port is not None:
            result['HealthCheckPort'] = self.health_check_port
        if self.internal_ip is not None:
            result['InternalIp'] = self.internal_ip
        if self.internal_port is not None:
            result['InternalPort'] = self.internal_port
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.standby_external_ip is not None:
            result['StandbyExternalIp'] = self.standby_external_ip
        if self.standby_status is not None:
            result['StandbyStatus'] = self.standby_status
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalIp') is not None:
            self.external_ip = m.get('ExternalIp')
        if m.get('ExternalPort') is not None:
            self.external_port = m.get('ExternalPort')
        if m.get('ForwardEntryId') is not None:
            self.forward_entry_id = m.get('ForwardEntryId')
        if m.get('ForwardEntryName') is not None:
            self.forward_entry_name = m.get('ForwardEntryName')
        if m.get('HealthCheckPort') is not None:
            self.health_check_port = m.get('HealthCheckPort')
        if m.get('InternalIp') is not None:
            self.internal_ip = m.get('InternalIp')
        if m.get('InternalPort') is not None:
            self.internal_port = m.get('InternalPort')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('StandbyExternalIp') is not None:
            self.standby_external_ip = m.get('StandbyExternalIp')
        if m.get('StandbyStatus') is not None:
            self.standby_status = m.get('StandbyStatus')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeForwardTableEntriesResponseBody(TeaModel):
    def __init__(
        self,
        forward_table_entries: List[DescribeForwardTableEntriesResponseBodyForwardTableEntries] = None,
        page_number: str = None,
        page_size: str = None,
        request_id: str = None,
        total_count: str = None,
    ):
        # Details of DNAT entries.
        self.forward_table_entries = forward_table_entries
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.forward_table_entries:
            for k in self.forward_table_entries:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ForwardTableEntries'] = []
        if self.forward_table_entries is not None:
            for k in self.forward_table_entries:
                result['ForwardTableEntries'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.forward_table_entries = []
        if m.get('ForwardTableEntries') is not None:
            for k in m.get('ForwardTableEntries'):
                temp_model = DescribeForwardTableEntriesResponseBodyForwardTableEntries()
                self.forward_table_entries.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeForwardTableEntriesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeForwardTableEntriesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeForwardTableEntriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHaVipsRequest(TeaModel):
    def __init__(
        self,
        ens_region_id: str = None,
        ens_region_ids: List[str] = None,
        ha_vip_address: str = None,
        ha_vip_id: str = None,
        name: str = None,
        network_id: str = None,
        page_number: str = None,
        page_size: str = None,
        status: str = None,
        v_switch_id: str = None,
    ):
        # The ID of the region.
        self.ens_region_id = ens_region_id
        # The IDs of edge nodes. You can specify 1 to 100 IDs.
        self.ens_region_ids = ens_region_ids
        # The IP address of the HAVIP.
        self.ha_vip_address = ha_vip_address
        # The ID of the HAVIP.
        self.ha_vip_id = ha_vip_id
        # The name of the HAVIP.
        self.name = name
        # The ID of the network.
        self.network_id = network_id
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The status of the HAVIP. Valid values:
        # 
        # *   Creating
        # *   Available
        # *   InUse
        # *   Deleting
        self.status = status
        # The ID of the vSwitch.
        self.v_switch_id = v_switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.ens_region_ids is not None:
            result['EnsRegionIds'] = self.ens_region_ids
        if self.ha_vip_address is not None:
            result['HaVipAddress'] = self.ha_vip_address
        if self.ha_vip_id is not None:
            result['HaVipId'] = self.ha_vip_id
        if self.name is not None:
            result['Name'] = self.name
        if self.network_id is not None:
            result['NetworkId'] = self.network_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('EnsRegionIds') is not None:
            self.ens_region_ids = m.get('EnsRegionIds')
        if m.get('HaVipAddress') is not None:
            self.ha_vip_address = m.get('HaVipAddress')
        if m.get('HaVipId') is not None:
            self.ha_vip_id = m.get('HaVipId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NetworkId') is not None:
            self.network_id = m.get('NetworkId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class DescribeHaVipsResponseBodyHaVipsAssociatedEipAddresses(TeaModel):
    def __init__(
        self,
        eip: str = None,
        eip_id: str = None,
    ):
        # The EIP.
        self.eip = eip
        # The ID of the EIP.
        self.eip_id = eip_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.eip is not None:
            result['Eip'] = self.eip
        if self.eip_id is not None:
            result['EipId'] = self.eip_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Eip') is not None:
            self.eip = m.get('Eip')
        if m.get('EipId') is not None:
            self.eip_id = m.get('EipId')
        return self


class DescribeHaVipsResponseBodyHaVipsAssociatedInstances(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        instance_id: str = None,
        instance_type: str = None,
        ip_address: str = None,
        status: str = None,
    ):
        # The time when the instance was created.
        self.creation_time = creation_time
        # The ID of the instance.
        self.instance_id = instance_id
        # The type of the instance that is associated with the HAVIP. Valid values:
        # 
        # *   EnsInstance: ENS instance
        # *   NetworkInterface: elastic network interface (ENI)
        self.instance_type = instance_type
        # The private IP address of the instance that is associated with the HAVIP. Valid values:
        self.ip_address = ip_address
        # The association status of the HAVIP. Valid values:
        # 
        # *   Associating
        # *   InUse
        # *   Unassociating
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeHaVipsResponseBodyHaVips(TeaModel):
    def __init__(
        self,
        associated_eip_addresses: List[DescribeHaVipsResponseBodyHaVipsAssociatedEipAddresses] = None,
        associated_instances: List[DescribeHaVipsResponseBodyHaVipsAssociatedInstances] = None,
        creation_time: str = None,
        description: str = None,
        ens_region_id: str = None,
        ha_vip_id: str = None,
        ip_address: str = None,
        name: str = None,
        network_id: str = None,
        status: str = None,
        v_switch_id: str = None,
    ):
        # The elastic IP addresses (EIPs) that are associated with the HAVIP.
        self.associated_eip_addresses = associated_eip_addresses
        # The information about instances that are associated with the HAVIP.
        self.associated_instances = associated_instances
        # The time when the HAVIP was created.
        self.creation_time = creation_time
        # The description of the HAVIP.
        self.description = description
        # The ID of the region.
        self.ens_region_id = ens_region_id
        # The ID of the HAVIP.
        self.ha_vip_id = ha_vip_id
        # The IP address of the HAVIP.
        self.ip_address = ip_address
        # The name of the HAVIP.
        self.name = name
        # The ID of the network.
        self.network_id = network_id
        # The status of the HAVIP. Valid values:
        # 
        # *   Creating
        # *   Available
        # *   InUse
        # *   Deleting
        self.status = status
        # The ID of the vSwitch.
        self.v_switch_id = v_switch_id

    def validate(self):
        if self.associated_eip_addresses:
            for k in self.associated_eip_addresses:
                if k:
                    k.validate()
        if self.associated_instances:
            for k in self.associated_instances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AssociatedEipAddresses'] = []
        if self.associated_eip_addresses is not None:
            for k in self.associated_eip_addresses:
                result['AssociatedEipAddresses'].append(k.to_map() if k else None)
        result['AssociatedInstances'] = []
        if self.associated_instances is not None:
            for k in self.associated_instances:
                result['AssociatedInstances'].append(k.to_map() if k else None)
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.ens_region_id is not None:
            result['EnsRegionId'] = self.ens_region_id
        if self.ha_vip_id is not None:
            result['HaVipId'] = self.ha_vip_id
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.name is not None:
            result['Name'] = self.name
        if self.network_id is not None:
            result['NetworkId'] = self.network_id
        if self.status is not None:
            result['Status'] = self.status
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.associated_eip_addresses = []
        if m.get('AssociatedEipAddresses') is not None:
            for k in m.get('AssociatedEipAddresses'):
                temp_model = DescribeHaVipsResponseBodyHaVipsAssociatedEipAddresses()
                self.associated_eip_addresses.append(temp_model.from_map(k))
        self.associated_instances = []
        if m.get('AssociatedInstances') is not None:
            for k in m.get('AssociatedInstances'):
                temp_model = DescribeHaVipsResponseBodyHaVipsAssociatedInstances()
                self.associated_instances.append(temp_model.from_map(k))
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnsRegionId') is not None:
            self.ens_region_id = m.get('EnsRegionId')
        if m.get('HaVipId') is not None:
            self.ha_vip_id = m.get('HaVipId')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NetworkId') is not None:
            self.network_id = m.get('NetworkId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class DescribeHaVipsResponseBody(TeaModel):
    def __init__(
        self,
        ha_vips: List[DescribeHaVipsResponseBodyHaVips] = None,
        page_number: str = None,
        page_size: str = None,
        request_id: str = None,
        total_count: str = None,
    ):
        # Details of the HAVIPs.
        self.ha_vips = ha_vips
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.ha_vips:
            for k in self.ha_vips:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HaVips'] = []
        if self.ha_vips is not None:
            for k in self.ha_vips:
                result['HaVips'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ha_vips = []
        if m.get('HaVips') is not None:
            for k in m.get('HaVips'):
                temp_model = DescribeHaVipsResponseBodyHaVips()
                self.ha_vips.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeHaVipsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeHaVipsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHaVipsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHistoryEventsRequest(TeaModel):
    def __init__(
        self,
        event_levels: List[str] = None,
        event_status: List[str] = None,
        event_types: List[str] = None,
        page_number: int = None,
        page_size: int = None,
        resource_ids: List[str] = None,
    ):
        # The levels of the event-triggered alerts.
        self.event_levels = event_levels
        # Event status list.
        self.event_status = event_status
        # The list of event types.
        # 
        # This parameter is required.
        self.event_types = event_types
        # The page number. Pages start from page 1. Default value: 1.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The IDs of resources.
        self.resource_ids = resource_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_levels is not None:
            result['EventLevels'] = self.event_levels
        if self.event_status is not None:
            result['EventStatus'] = self.event_status
        if self.event_types is not None:
            result['EventTypes'] = self.event_types
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_ids is not None:
            result['ResourceIds'] = self.resource_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventLevels') is not None:
            self.event_levels = m.get('EventLevels')
        if m.get('EventStatus') is not None:
            self.event_status = m.get('EventStatus')
        if m.get('EventTypes') is not None:
            self.event_types = m.get('EventTypes')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceIds') is not None:
            self.resource_ids = m.get('ResourceIds')
        return self


class DescribeHistoryEventsShrinkRequest(TeaModel):
    def __init__(
        self,
        event_levels_shrink: str = None,
        event_status_shrink: str = None,
        event_types_shrink: str = None,
        page_number: int = None,
        page_size: int = None,
        resource_ids_shrink: str = None,
    ):
        # The levels of the event-triggered alerts.
        self.event_levels_shrink = event_levels_shrink
        # Event status list.
        self.event_status_shrink = event_status_shrink
        # The list of event types.
        # 
        # This parameter is required.
        self.event_types_shrink = event_types_shrink
        # The page number. Pages start from page 1. Default value: 1.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The IDs of resources.
        self.resource_ids_shrink = resource_ids_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_levels_shrink is not None:
            result['EventLevels'] = self.event_levels_shrink
        if self.event_status_shrink is not None:
            result['EventStatus'] = self.event_status_shrink
        if self.event_types_shrink is not None:
            result['EventTypes'] = self.event_types_shrink
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_ids_shrink is not None:
            result['ResourceIds'] = self.resource_ids_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventLevels') is not None:
            self.event_levels_shrink = m.get('EventLevels')
        if m.get('EventStatus') is not None:
            self.event_status_shrink = m.get('EventStatus')
        if m.get('EventTypes') is not None:
            self.event_types_shrink = m.get('EventTypes')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceIds') is not None:
            self.resource_ids_shrink = m.get('ResourceIds')
        return self


class DescribeHistoryEventsResponseBodyEvents(TeaModel):
    def __init__(
        self,
        event_id: str = None,
        event_level: str = None,
        event_status: str = None,
        event_type: str = None,
        extended_attribute: str = None,
        not_before: int = None,
        publish_time: int = None,
        reason: str = None,
        resource_id: str = None,
    ):
        # The ID of the event.
        self.event_id = event_id
        # The level of the specific event. Valid values:
        # 
        # *   CRITICAL
        # *   WARN
        # *   INFO
        self.event_level = event_level
        # The status of the event. Valid values:
        # 
        # *   Inquiring
        # *   Scheduled
        # *   Executing
        # *   Executed
        # *   Failed
        # *   Canceled
        # *   Avoided
        self.event_status = event_status
        # The type of the event. Description:
        # 
        # *   Instance:SystemFailure.Redeploy: The instance is redeployed due to system issues.
        # *   Instance:SystemFailure.Reboot: The instance is restarted due to a system error.
        # *   Instance:RegionNetworkDown: The node network is interrupted.
        # *   Disk:Stalled: The disk performance is impaired.
        # *   EnsRegion:NetworkMigration: The instance is migrated due to a system error.
        # *   IP:SafeRisk: IP alerts.
        # *   IP:SafeBan: IP blocking.
        # *   Instance:SystemUpgrade.Migrate: The instance needs to be migrated due to underlying upgrades.
        # *   Instance:SystemMaintenance.Redeploy: The instance is redeployed due to system maintenance.
        self.event_type = event_type
        # The extended attributes.
        self.extended_attribute = extended_attribute
        # The scheduled execution time of the event in milliseconds.
        self.not_before = not_before
        # The release time in milliseconds.
        self.publish_time = publish_time
        # The event cause.
        self.reason = reason
        # The ID of the associated resources.
        self.resource_id = resource_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.event_level is not None:
            result['EventLevel'] = self.event_level
        if self.event_status is not None:
            result['EventStatus'] = self.event_status
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.extended_attribute is not None:
            result['ExtendedAttribute'] = self.extended_attribute
        if self.not_before is not None:
            result['NotBefore'] = self.not_before
        if self.publish_time is not None:
            result['PublishTime'] = self.publish_time
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('EventLevel') is not None:
            self.event_level = m.get('EventLevel')
        if m.get('EventStatus') is not None:
            self.event_status = m.get('EventStatus')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('ExtendedAttribute') is not None:
            self.extended_attribute = m.get('ExtendedAttribute')
        if m.get('NotBefore') is not None:
            self.not_before = m.get('NotBefore')
        if m.get('PublishTime') is not None:
            self.publish_time = m.get('PublishTime')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class DescribeHistoryEventsResponseBody(TeaModel):
    def __init__(
        self,
        events: List[DescribeHistoryEventsResponseBodyEvents] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The queried events.
        self.events = events
        # The page number. Pages start from page 1. Default value: 1.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # Request ID.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.events:
            for k in self.events:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Events'] = []
        if self.events is not None:
            for k in self.events:
                result['Events'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.events = []
        if m.get('Events') is not None:
            for k in m.get('Events'):
                temp_model = DescribeHistoryEventsResponseBodyEvents()
                self.events.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeHistoryEventsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeHistoryEventsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHistoryEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageInfosRequest(TeaModel):
    def __init__(
        self,
        os_type: str = None,
    ):
        # The operating system (OS). You can specify only one OS in a request. If you do not specify a value for this parameter, images for all supported OSs are queried. Valid values:
        # 
        # *   linux
        # *   windows
        self.os_type = os_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.os_type is not None:
            result['OsType'] = self.os_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        return self


class DescribeImageInfosResponseBodyImagesImageDiskDeviceMappingsDiskDeviceMapping(TeaModel):
    def __init__(
        self,
        format: str = None,
        size: str = None,
        type: str = None,
        image_id: str = None,
    ):
        # The format of the image.
        self.format = format
        # The size of the image. Unit: GB.
        self.size = size
        # The type of the disk. Valid values: System and Data.
        self.type = type
        # The ID of the image.
        self.image_id = image_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        if self.size is not None:
            result['Size'] = self.size
        if self.type is not None:
            result['Type'] = self.type
        if self.image_id is not None:
            result['imageId'] = self.image_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('imageId') is not None:
            self.image_id = m.get('imageId')
        return self


class DescribeImageInfosResponseBodyImagesImageDiskDeviceMappings(TeaModel):
    def __init__(
        self,
        disk_device_mapping: List[DescribeImageInfosResponseBodyImagesImageDiskDeviceMappingsDiskDeviceMapping] = None,
    ):
        self.disk_device_mapping = disk_device_mapping

    def validate(self):
        if self.disk_device_mapping:
            for k in self.disk_device_mapping:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DiskDeviceMapping'] = []
        if self.disk_device_mapping is not None:
            for k in self.disk_device_mapping:
                result['DiskDeviceMapping'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.disk_device_mapping = []
        if m.get('DiskDeviceMapping') is not None:
            for k in m.get('DiskDeviceMapping'):
                temp_model = DescribeImageInfosResponseBodyImagesImageDiskDeviceMappingsDiskDeviceMapping()
                self.disk_device_mapping.append(temp_model.from_map(k))
        return self


class DescribeImageInfosResponseBodyImagesImage(TeaModel):
    def __init__(
        self,
        compute_type: str = None,
        description: str = None,
        disk_device_mappings: DescribeImageInfosResponseBodyImagesImageDiskDeviceMappings = None,
        image_id: str = None,
        image_size: str = None,
        image_version: str = None,
        osname: str = None,
        ostype: str = None,
        region_id: str = None,
    ):
        # The computing type of the image. Valid values:
        # 
        # *   ens_vm: x86 computing.
        # *   arm_vm: ARM computing.
        # *   bare_metal: x86 bare machine.
        # *   pcfarm: heterogeneous computing.
        self.compute_type = compute_type
        # The description of the image.
        self.description = description
        # The mappings between disks and snapshots in the image.
        self.disk_device_mappings = disk_device_mappings
        # The ID of the image.
        self.image_id = image_id
        # The size of the image. Unit: GiB.
        self.image_size = image_size
        # The version of the image.
        self.image_version = image_version
        # The type of the image. Valid values: **centos**, **debian**, **ubuntu**, and **windows**.
        self.osname = osname
        # The type of the operating system.
        self.ostype = ostype
        # The ID of the region.
        self.region_id = region_id

    def validate(self):
        if self.disk_device_mappings:
            self.disk_device_mappings.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compute_type is not None:
            result['ComputeType'] = self.compute_type
        if self.description is not None:
            result['Description'] = self.description
        if self.disk_device_mappings is not None:
            result['DiskDeviceMappings'] = self.disk_device_mappings.to_map()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_size is not None:
            result['ImageSize'] = self.image_size
        if self.image_version is not None:
            result['ImageVersion'] = self.image_version
        if self.osname is not None:
            result['OSName'] = self.osname
        if self.ostype is not None:
            result['OSType'] = self.ostype
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComputeType') is not None:
            self.compute_type = m.get('ComputeType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DiskDeviceMappings') is not None:
            temp_model = DescribeImageInfosResponseBodyImagesImageDiskDeviceMappings()
            self.disk_device_mappings = temp_model.from_map(m['DiskDeviceMappings'])
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageSize') is not None:
            self.image_size = m.get('ImageSize')
        if m.get('ImageVersion') is not None:
            self.image_version = m.get('ImageVersion')
        if m.get('OSName') is not None:
            self.osname = m.get('OSName')
        if m.get('OSType') is not None:
            self.ostype = m.get('OSType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeImageInfosResponseBodyImages(TeaModel):
    def __init__(
        self,
        image: List[DescribeImageInfosResponseBodyImagesImage] = None,
    ):
        self.image = image

    def validate(self):
        if self.image:
            for k in self.image:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Image'] = []
        if self.image is not None:
            for k in self.image:
                result['Image'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.image = []
        if m.get('Image') is not None:
            for k in m.get('Image'):
                temp_model = DescribeImageInfosResponseBodyImagesImage()
                self.image.append(temp_model.from_map(k))
        return self


class DescribeImageInfosResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        images: DescribeImageInfosResponseBodyImages = None,
        request_id: str = None,
    ):
        # The HTTP status code that is returned.
        self.code = code
        # The information about images.
        self.images = images
        # The request ID.
        