# coding=utf8

# Copyright 2018-2025 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http:#www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeBackupDownloadURLRequest(JDCloudRequest):
    """
    获取备份下载链接
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DescribeBackupDownloadURLRequest, self).__init__(
            '/regions/{regionId}/backups/{backupId}/downloadURLs', 'GET', header, version)
        self.parameters = parameters


class DescribeBackupDownloadURLParameters(object):

    def __init__(self, regionId, backupId, ):
        """
        :param regionId: 地域代码
        :param backupId: 备份ID
        """

        self.regionId = regionId
        self.backupId = backupId
        self.fileName = None
        self.urlExpirationSecond = None

    def setFileName(self, fileName):
        """
        :param fileName: (Optional) MySQL：无需此参数；SQL Server：指定该备份中需要获取下载链接的文件名称，SQL Server必须输入该参数
        """
        self.fileName = fileName

    def setUrlExpirationSecond(self, urlExpirationSecond):
        """
        :param urlExpirationSecond: (Optional) 指定下载链接的有效时间，单位秒,缺省为86400秒（即24小时） 取值范围：1-864000
        """
        self.urlExpirationSecond = urlExpirationSecond

