# coding=utf8

# Copyright 2018-2025 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http:#www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeImagesRequest(JDCloudRequest):
    """
    查询镜像资源信息列表
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DescribeImagesRequest, self).__init__(
            '/regions/{regionId}/images', 'GET', header, version)
        self.parameters = parameters


class DescribeImagesParameters(object):

    def __init__(self, regionId, ):
        """
        :param regionId: Region ID
        """

        self.regionId = regionId
        self.imageSource = None
        self.platform = None
        self.ids = None

    def setImageSource(self, imageSource):
        """
        :param imageSource: (Optional) 镜像来源：public、shared、thirdparty、private，如果没有指定ids参数，此参数必传
        """
        self.imageSource = imageSource

    def setPlatform(self, platform):
        """
        :param platform: (Optional) 操作系统平台: Windows Server、CentOS、Ubuntu
        """
        self.platform = platform

    def setIds(self, ids):
        """
        :param ids: (Optional) 镜像ID列表，如果指定了此参数，其它参数可为空
        """
        self.ids = ids

