# coding=utf8

# Copyright 2018-2025 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http:#www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class ModifyInstancePasswordRequest(JDCloudRequest):
    """
    修改主机密码，主机没有未完成的任务时才可操作
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(ModifyInstancePasswordRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}:modifyInstancePassword', 'POST', header, version)
        self.parameters = parameters


class ModifyInstancePasswordParameters(object):

    def __init__(self, regionId, instanceId, password):
        """
        :param regionId: Region ID
        :param instanceId: Instance ID
        :param password: &quot;密码，长度8-30个字符&quot;
&quot;a)不能出现的字符或完整单词，如下：jd、JD、360、bug、BUG、com、COM、cloud、CLOUD、password、PASSWORD&quot;
&quot;b)不能出现连续三位及三位以上数字，例：123、987&quot;
&quot;c)不能出现连续三位及三位以上的字母，例：abc、CBA、bcde、cdef&quot;
&quot;d)不能出现三位及三位以上键位顺序（仅包括字母），例：qaz、tfc、wsx、xsw、qwert、trewq&quot;
&quot;e)密码中不能出现自己的用户名&quot;
&quot;g)至少同时包含三类（大写字母，小写字母，数字和特殊字符，特殊字符为 ** ()&#x60;~!@#$%&amp;_-+&#x3D;{}[]:\&quot;;&#39;&lt;&gt;,.?/）*|&quot;

        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.password = password

