import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DowntimeConfig extends cdktf.TerraformMetaArguments {
    /**
     * Optionally specify an end date when this downtime should expire.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime.html#end Downtime#end}
     *
     * @stability stable
     */
    readonly end?: number;
    /**
     * String representing date and time to end the downtime in RFC3339 format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime.html#end_date Downtime#end_date}
     *
     * @stability stable
     */
    readonly endDate?: string;
    /**
     * An optional message to provide when creating the downtime, can include notification handles.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime.html#message Downtime#message}
     *
     * @stability stable
     */
    readonly message?: string;
    /**
     * When specified, this downtime will only apply to this monitor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime.html#monitor_id Downtime#monitor_id}
     *
     * @stability stable
     */
    readonly monitorId?: number;
    /**
     * A list of monitor tags (up to 25), i.e. tags that are applied directly to monitors to which the downtime applies.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime.html#monitor_tags Downtime#monitor_tags}
     *
     * @stability stable
     */
    readonly monitorTags?: string[];
    /**
     * specify the group scope to which this downtime applies. For everything use '*'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime.html#scope Downtime#scope}
     *
     * @stability stable
     */
    readonly scope: string[];
    /**
     * Specify when this downtime should start.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime.html#start Downtime#start}
     *
     * @stability stable
     */
    readonly start?: number;
    /**
     * String representing date and time to start the downtime in RFC3339 format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime.html#start_date Downtime#start_date}
     *
     * @stability stable
     */
    readonly startDate?: string;
    /**
     * The timezone for the downtime, default UTC.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime.html#timezone Downtime#timezone}
     *
     * @stability stable
     */
    readonly timezone?: string;
    /**
     * recurrence block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime.html#recurrence Downtime#recurrence}
     *
     * @stability stable
     */
    readonly recurrence?: DowntimeRecurrence;
}
/**
 * @stability stable
 */
export interface DowntimeRecurrence {
    /**
     * How often to repeat as an integer.
     *
     * For example to repeat every 3 days, select a `type` of `days` and a `period` of `3`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime.html#period Downtime#period}
     *
     * @stability stable
     */
    readonly period?: number;
    /**
     * The RRULE standard for defining recurring events.
     *
     * For example, to have a recurring event on the first day of each month, use `FREQ=MONTHLY;INTERVAL=1`. Most common rrule options from the iCalendar Spec are supported. Attributes specifying the duration in RRULE are not supported (for example, `DTSTART`, `DTEND`, `DURATION`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime.html#rrule Downtime#rrule}
     *
     * @stability stable
     */
    readonly rrule?: string;
    /**
     * One of `days`, `weeks`, `months`, or `years`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime.html#type Downtime#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * The date at which the recurrence should end as a POSIX timestamp. `until_occurrences` and `until_date` are mutually exclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime.html#until_date Downtime#until_date}
     *
     * @stability stable
     */
    readonly untilDate?: number;
    /**
     * How many times the downtime will be rescheduled. `until_occurrences` and `until_date` are mutually exclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime.html#until_occurrences Downtime#until_occurrences}
     *
     * @stability stable
     */
    readonly untilOccurrences?: number;
    /**
     * A list of week days to repeat on.
     *
     * Choose from: `Mon`, `Tue`, `Wed`, `Thu`, `Fri`, `Sat` or `Sun`. Only applicable when `type` is `weeks`. First letter must be capitalized.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime.html#week_days Downtime#week_days}
     *
     * @stability stable
     */
    readonly weekDays?: string[];
}
/**
 * @stability stable
 */
export declare class DowntimeRecurrenceOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _period?;
    /**
     * @stability stable
     */
    get period(): number | undefined;
    /**
     * @stability stable
     */
    set period(value: number | undefined);
    /**
     * @stability stable
     */
    resetPeriod(): void;
    /**
     * @stability stable
     */
    get periodInput(): number | undefined;
    private _rrule?;
    /**
     * @stability stable
     */
    get rrule(): string | undefined;
    /**
     * @stability stable
     */
    set rrule(value: string | undefined);
    /**
     * @stability stable
     */
    resetRrule(): void;
    /**
     * @stability stable
     */
    get rruleInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _untilDate?;
    /**
     * @stability stable
     */
    get untilDate(): number | undefined;
    /**
     * @stability stable
     */
    set untilDate(value: number | undefined);
    /**
     * @stability stable
     */
    resetUntilDate(): void;
    /**
     * @stability stable
     */
    get untilDateInput(): number | undefined;
    private _untilOccurrences?;
    /**
     * @stability stable
     */
    get untilOccurrences(): number | undefined;
    /**
     * @stability stable
     */
    set untilOccurrences(value: number | undefined);
    /**
     * @stability stable
     */
    resetUntilOccurrences(): void;
    /**
     * @stability stable
     */
    get untilOccurrencesInput(): number | undefined;
    private _weekDays?;
    /**
     * @stability stable
     */
    get weekDays(): string[] | undefined;
    /**
     * @stability stable
     */
    set weekDays(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetWeekDays(): void;
    /**
     * @stability stable
     */
    get weekDaysInput(): string[] | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/downtime.html datadog_downtime}.
 *
 * @stability stable
 */
export declare class Downtime extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/downtime.html datadog_downtime} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DowntimeConfig);
    /**
     * @stability stable
     */
    get active(): any;
    /**
     * @stability stable
     */
    get activeChildId(): number;
    /**
     * @stability stable
     */
    get disabled(): any;
    private _end?;
    /**
     * @stability stable
     */
    get end(): number | undefined;
    /**
     * @stability stable
     */
    set end(value: number | undefined);
    /**
     * @stability stable
     */
    resetEnd(): void;
    /**
     * @stability stable
     */
    get endInput(): number | undefined;
    private _endDate?;
    /**
     * @stability stable
     */
    get endDate(): string | undefined;
    /**
     * @stability stable
     */
    set endDate(value: string | undefined);
    /**
     * @stability stable
     */
    resetEndDate(): void;
    /**
     * @stability stable
     */
    get endDateInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _message?;
    /**
     * @stability stable
     */
    get message(): string | undefined;
    /**
     * @stability stable
     */
    set message(value: string | undefined);
    /**
     * @stability stable
     */
    resetMessage(): void;
    /**
     * @stability stable
     */
    get messageInput(): string | undefined;
    private _monitorId?;
    /**
     * @stability stable
     */
    get monitorId(): number | undefined;
    /**
     * @stability stable
     */
    set monitorId(value: number | undefined);
    /**
     * @stability stable
     */
    resetMonitorId(): void;
    /**
     * @stability stable
     */
    get monitorIdInput(): number | undefined;
    private _monitorTags?;
    /**
     * @stability stable
     */
    get monitorTags(): string[] | undefined;
    /**
     * @stability stable
     */
    set monitorTags(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetMonitorTags(): void;
    /**
     * @stability stable
     */
    get monitorTagsInput(): string[] | undefined;
    private _scope?;
    /**
     * @stability stable
     */
    get scope(): string[];
    /**
     * @stability stable
     */
    set scope(value: string[]);
    /**
     * @stability stable
     */
    get scopeInput(): string[] | undefined;
    private _start?;
    /**
     * @stability stable
     */
    get start(): number | undefined;
    /**
     * @stability stable
     */
    set start(value: number | undefined);
    /**
     * @stability stable
     */
    resetStart(): void;
    /**
     * @stability stable
     */
    get startInput(): number | undefined;
    private _startDate?;
    /**
     * @stability stable
     */
    get startDate(): string | undefined;
    /**
     * @stability stable
     */
    set startDate(value: string | undefined);
    /**
     * @stability stable
     */
    resetStartDate(): void;
    /**
     * @stability stable
     */
    get startDateInput(): string | undefined;
    private _timezone?;
    /**
     * @stability stable
     */
    get timezone(): string | undefined;
    /**
     * @stability stable
     */
    set timezone(value: string | undefined);
    /**
     * @stability stable
     */
    resetTimezone(): void;
    /**
     * @stability stable
     */
    get timezoneInput(): string | undefined;
    private _recurrence?;
    private __recurrenceOutput;
    /**
     * @stability stable
     */
    get recurrence(): DowntimeRecurrenceOutputReference;
    /**
     * @stability stable
     */
    putRecurrence(value: DowntimeRecurrence | undefined): void;
    /**
     * @stability stable
     */
    resetRecurrence(): void;
    /**
     * @stability stable
     */
    get recurrenceInput(): DowntimeRecurrence | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
