import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IntegrationAwsLogCollectionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Your AWS Account ID without dashes. If your account is a GovCloud or China account, specify the `access_key_id` here.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws_log_collection.html#account_id IntegrationAwsLogCollection#account_id}
     *
     * @stability stable
     */
    readonly accountId: string;
    /**
     * A list of services to collect logs from.
     *
     * See the [api docs](https://docs.datadoghq.com/api/v1/aws-logs-integration/#get-list-of-aws-log-ready-services) for more details on which services are supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws_log_collection.html#services IntegrationAwsLogCollection#services}
     *
     * @stability stable
     */
    readonly services: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws_log_collection.html datadog_integration_aws_log_collection}.
 *
 * @stability stable
 */
export declare class IntegrationAwsLogCollection extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws_log_collection.html datadog_integration_aws_log_collection} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IntegrationAwsLogCollectionConfig);
    private _accountId?;
    /**
     * @stability stable
     */
    get accountId(): string;
    /**
     * @stability stable
     */
    set accountId(value: string);
    /**
     * @stability stable
     */
    get accountIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _services?;
    /**
     * @stability stable
     */
    get services(): string[];
    /**
     * @stability stable
     */
    set services(value: string[]);
    /**
     * @stability stable
     */
    get servicesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
