import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IntegrationAwsTagFilterConfig extends cdktf.TerraformMetaArguments {
    /**
     * Your AWS Account ID without dashes. If your account is a GovCloud or China account, specify the `access_key_id` here.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws_tag_filter.html#account_id IntegrationAwsTagFilter#account_id}
     *
     * @stability stable
     */
    readonly accountId: string;
    /**
     * The namespace associated with the tag filter entry. Valid values are `elb`, `application_elb`, `sqs`, `rds`, `custom`, `network_elb`, `lambda`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws_tag_filter.html#namespace IntegrationAwsTagFilter#namespace}
     *
     * @stability stable
     */
    readonly namespace: string;
    /**
     * The tag filter string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws_tag_filter.html#tag_filter_str IntegrationAwsTagFilter#tag_filter_str}
     *
     * @stability stable
     */
    readonly tagFilterStr: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws_tag_filter.html datadog_integration_aws_tag_filter}.
 *
 * @stability stable
 */
export declare class IntegrationAwsTagFilter extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws_tag_filter.html datadog_integration_aws_tag_filter} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IntegrationAwsTagFilterConfig);
    private _accountId?;
    /**
     * @stability stable
     */
    get accountId(): string;
    /**
     * @stability stable
     */
    set accountId(value: string);
    /**
     * @stability stable
     */
    get accountIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _namespace?;
    /**
     * @stability stable
     */
    get namespace(): string;
    /**
     * @stability stable
     */
    set namespace(value: string);
    /**
     * @stability stable
     */
    get namespaceInput(): string | undefined;
    private _tagFilterStr?;
    /**
     * @stability stable
     */
    get tagFilterStr(): string;
    /**
     * @stability stable
     */
    set tagFilterStr(value: string);
    /**
     * @stability stable
     */
    get tagFilterStrInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
