import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LogsIntegrationPipelineConfig extends cdktf.TerraformMetaArguments {
    /**
     * Boolean value to enable your pipeline.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_integration_pipeline.html#is_enabled LogsIntegrationPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/logs_integration_pipeline.html datadog_logs_integration_pipeline}.
 *
 * @stability stable
 */
export declare class LogsIntegrationPipeline extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/logs_integration_pipeline.html datadog_logs_integration_pipeline} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: LogsIntegrationPipelineConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
