import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MonitorConfig extends cdktf.TerraformMetaArguments {
    /**
     * A boolean indicating whether or not to include a list of log values which triggered the alert.
     *
     * This is only used by log monitors. Defaults to `false`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#enable_logs_sample Monitor#enable_logs_sample}
     *
     * @stability stable
     */
    readonly enableLogsSample?: boolean | cdktf.IResolvable;
    /**
     * A message to include with a re-notification. Supports the `@username` notification allowed elsewhere.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#escalation_message Monitor#escalation_message}
     *
     * @stability stable
     */
    readonly escalationMessage?: string;
    /**
     * (Only applies to metric alert) Time (in seconds) to delay evaluation, as a non-negative integer.
     *
     * For example, if the value is set to `300` (5min), the `timeframe` is set to `last_5m` and the time is 7:00, the monitor will evaluate data from 6:50 to 6:55. This is useful for AWS CloudWatch and other backfilled metrics to ensure the monitor will always have data during evaluation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#evaluation_delay Monitor#evaluation_delay}
     *
     * @stability stable
     */
    readonly evaluationDelay?: number;
    /**
     * A boolean indicating whether this monitor can be deleted even if it’s referenced by other resources (e.g. SLO, composite monitor).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#force_delete Monitor#force_delete}
     *
     * @stability stable
     */
    readonly forceDelete?: boolean | cdktf.IResolvable;
    /**
     * Whether or not to trigger one alert if any source breaches a threshold.
     *
     * This is only used by log monitors. Defaults to `false`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#groupby_simple_monitor Monitor#groupby_simple_monitor}
     *
     * @stability stable
     */
    readonly groupbySimpleMonitor?: boolean | cdktf.IResolvable;
    /**
     * A boolean indicating whether notifications from this monitor automatically insert its triggering tags into the title. Defaults to `true`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#include_tags Monitor#include_tags}
     *
     * @stability stable
     */
    readonly includeTags?: boolean | cdktf.IResolvable;
    /**
     * A boolean indicating whether changes to to this monitor should be restricted to the creator or admins.
     *
     * Defaults to `false`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#locked Monitor#locked}
     *
     * @stability stable
     */
    readonly locked?: boolean | cdktf.IResolvable;
    /**
     * A message to include with notifications for this monitor.
     *
     * Email notifications can be sent to specific users by using the same `@username` notation as events.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#message Monitor#message}
     *
     * @stability stable
     */
    readonly message: string;
    /**
     * Name of Datadog monitor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#name Monitor#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Time (in seconds) to skip evaluations for new groups.
     *
     * `new_group_delay` overrides `new_host_delay` if it is set to a nonzero value.
     *
     * To disable group delay for monitors grouped by host, `new_host_delay` must be set to zero due to the default value of `300` for that field (`new_group_delay` defaults to zero, so setting it to zero is not required).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#new_group_delay Monitor#new_group_delay}
     *
     * @stability stable
     */
    readonly newGroupDelay?: number;
    /**
     * Time (in seconds) to allow a host to boot and applications to fully start before starting the evaluation of monitor results.
     *
     * Should be a non-negative integer. Defaults to `300` (this default will be removed in a major version release and `new_host_delay` will be removed entirely in a subsequent major version release). **Deprecated.** Prefer using new_group_delay (except when setting `new_host_delay` to zero).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#new_host_delay Monitor#new_host_delay}
     *
     * @stability stable
     */
    readonly newHostDelay?: number;
    /**
     * The number of minutes before a monitor will notify when data stops reporting. Provider defaults to 10 minutes.
     *
     * We recommend at least 2x the monitor timeframe for metric alerts or 2 minutes for service checks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#no_data_timeframe Monitor#no_data_timeframe}
     *
     * @stability stable
     */
    readonly noDataTimeframe?: number;
    /**
     * A boolean indicating whether tagged users will be notified on changes to this monitor. Defaults to `false`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#notify_audit Monitor#notify_audit}
     *
     * @stability stable
     */
    readonly notifyAudit?: boolean | cdktf.IResolvable;
    /**
     * A boolean indicating whether this monitor will notify when data stops reporting. Defaults to `false`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#notify_no_data Monitor#notify_no_data}
     *
     * @stability stable
     */
    readonly notifyNoData?: boolean | cdktf.IResolvable;
    /**
     * Integer from 1 (high) to 5 (low) indicating alert severity.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#priority Monitor#priority}
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * The monitor query to notify on.
     *
     * Note this is not the same query you see in the UI and the syntax is different depending on the monitor type, please see the [API Reference](https://docs.datadoghq.com/api/v1/monitors/#create-a-monitor) for details. `terraform plan` will validate query contents unless `validate` is set to `false`.
     *
     * *Note:** APM latency data is now available as Distribution Metrics. Existing monitors have been migrated automatically but all terraformed monitors can still use the existing metrics. We strongly recommend updating monitor definitions to query the new metrics. To learn more, or to see examples of how to update your terraform definitions to utilize the new distribution metrics, see the [detailed doc](https://docs.datadoghq.com/tracing/guide/ddsketch_trace_metrics/).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#query Monitor#query}
     *
     * @stability stable
     */
    readonly query: string;
    /**
     * The number of minutes after the last notification before a monitor will re-notify on the current status.
     *
     * It will only re-notify if it's not resolved.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#renotify_interval Monitor#renotify_interval}
     *
     * @stability stable
     */
    readonly renotifyInterval?: number;
    /**
     * The number of re-notification messages that should be sent on the current status.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#renotify_occurrences Monitor#renotify_occurrences}
     *
     * @stability stable
     */
    readonly renotifyOccurrences?: number;
    /**
     * The types of statuses for which re-notification messages should be sent. Valid values are `alert`, `warn`, `no data`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#renotify_statuses Monitor#renotify_statuses}
     *
     * @stability stable
     */
    readonly renotifyStatuses?: string[];
    /**
     * A boolean indicating whether this monitor needs a full window of data before it's evaluated.
     *
     * We highly recommend you set this to `false` for sparse metrics, otherwise some evaluations will be skipped. Default: `true` for `on average`, `at all times` and `in total` aggregation. `false` otherwise.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#require_full_window Monitor#require_full_window}
     *
     * @stability stable
     */
    readonly requireFullWindow?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#restricted_roles Monitor#restricted_roles}.
     *
     * @stability stable
     */
    readonly restrictedRoles?: string[];
    /**
     * A list of tags to associate with your monitor.
     *
     * This can help you categorize and filter monitors in the manage monitors page of the UI. Note: it's not currently possible to filter by these tags when querying via the API
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#tags Monitor#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * The number of hours of the monitor not reporting data before it will automatically resolve from a triggered state.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#timeout_h Monitor#timeout_h}
     *
     * @stability stable
     */
    readonly timeoutH?: number;
    /**
     * The type of the monitor.
     *
     * The mapping from these types to the types found in the Datadog Web UI can be found in the Datadog API [documentation page](https://docs.datadoghq.com/api/v1/monitors/#create-a-monitor). Note: The monitor type cannot be changed after a monitor is created. Valid values are `composite`, `event alert`, `log alert`, `metric alert`, `process alert`, `query alert`, `rum alert`, `service check`, `synthetics alert`, `trace-analytics alert`, `slo alert`, `event-v2 alert`, `audit alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#type Monitor#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * If set to `false`, skip the validation call done during plan.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#validate Monitor#validate}
     *
     * @stability stable
     */
    readonly validate?: boolean | cdktf.IResolvable;
    /**
     * monitor_threshold_windows block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#monitor_threshold_windows Monitor#monitor_threshold_windows}
     *
     * @stability stable
     */
    readonly monitorThresholdWindows?: MonitorMonitorThresholdWindows;
    /**
     * monitor_thresholds block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#monitor_thresholds Monitor#monitor_thresholds}
     *
     * @stability stable
     */
    readonly monitorThresholds?: MonitorMonitorThresholds;
}
/**
 * @stability stable
 */
export interface MonitorMonitorThresholdWindows {
    /**
     * Describes how long an anomalous metric must be normal before the alert recovers.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#recovery_window Monitor#recovery_window}
     *
     * @stability stable
     */
    readonly recoveryWindow?: string;
    /**
     * Describes how long a metric must be anomalous before an alert triggers.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#trigger_window Monitor#trigger_window}
     *
     * @stability stable
     */
    readonly triggerWindow?: string;
}
/**
 * @stability stable
 */
export declare class MonitorMonitorThresholdWindowsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _recoveryWindow?;
    /**
     * @stability stable
     */
    get recoveryWindow(): string | undefined;
    /**
     * @stability stable
     */
    set recoveryWindow(value: string | undefined);
    /**
     * @stability stable
     */
    resetRecoveryWindow(): void;
    /**
     * @stability stable
     */
    get recoveryWindowInput(): string | undefined;
    private _triggerWindow?;
    /**
     * @stability stable
     */
    get triggerWindow(): string | undefined;
    /**
     * @stability stable
     */
    set triggerWindow(value: string | undefined);
    /**
     * @stability stable
     */
    resetTriggerWindow(): void;
    /**
     * @stability stable
     */
    get triggerWindowInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MonitorMonitorThresholds {
    /**
     * The monitor `CRITICAL` threshold. Must be a number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#critical Monitor#critical}
     *
     * @stability stable
     */
    readonly critical?: string;
    /**
     * The monitor `CRITICAL` recovery threshold. Must be a number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#critical_recovery Monitor#critical_recovery}
     *
     * @stability stable
     */
    readonly criticalRecovery?: string;
    /**
     * The monitor `OK` threshold. Must be a number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#ok Monitor#ok}
     *
     * @stability stable
     */
    readonly ok?: string;
    /**
     * The monitor `UNKNOWN` threshold. Must be a number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#unknown Monitor#unknown}
     *
     * @stability stable
     */
    readonly unknown?: string;
    /**
     * The monitor `WARNING` threshold. Must be a number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#warning Monitor#warning}
     *
     * @stability stable
     */
    readonly warning?: string;
    /**
     * The monitor `WARNING` recovery threshold. Must be a number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html#warning_recovery Monitor#warning_recovery}
     *
     * @stability stable
     */
    readonly warningRecovery?: string;
}
/**
 * @stability stable
 */
export declare class MonitorMonitorThresholdsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _critical?;
    /**
     * @stability stable
     */
    get critical(): string | undefined;
    /**
     * @stability stable
     */
    set critical(value: string | undefined);
    /**
     * @stability stable
     */
    resetCritical(): void;
    /**
     * @stability stable
     */
    get criticalInput(): string | undefined;
    private _criticalRecovery?;
    /**
     * @stability stable
     */
    get criticalRecovery(): string | undefined;
    /**
     * @stability stable
     */
    set criticalRecovery(value: string | undefined);
    /**
     * @stability stable
     */
    resetCriticalRecovery(): void;
    /**
     * @stability stable
     */
    get criticalRecoveryInput(): string | undefined;
    private _ok?;
    /**
     * @stability stable
     */
    get ok(): string | undefined;
    /**
     * @stability stable
     */
    set ok(value: string | undefined);
    /**
     * @stability stable
     */
    resetOk(): void;
    /**
     * @stability stable
     */
    get okInput(): string | undefined;
    private _unknown?;
    /**
     * @stability stable
     */
    get unknown(): string | undefined;
    /**
     * @stability stable
     */
    set unknown(value: string | undefined);
    /**
     * @stability stable
     */
    resetUnknown(): void;
    /**
     * @stability stable
     */
    get unknownInput(): string | undefined;
    private _warning?;
    /**
     * @stability stable
     */
    get warning(): string | undefined;
    /**
     * @stability stable
     */
    set warning(value: string | undefined);
    /**
     * @stability stable
     */
    resetWarning(): void;
    /**
     * @stability stable
     */
    get warningInput(): string | undefined;
    private _warningRecovery?;
    /**
     * @stability stable
     */
    get warningRecovery(): string | undefined;
    /**
     * @stability stable
     */
    set warningRecovery(value: string | undefined);
    /**
     * @stability stable
     */
    resetWarningRecovery(): void;
    /**
     * @stability stable
     */
    get warningRecoveryInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html datadog_monitor}.
 *
 * @stability stable
 */
export declare class Monitor extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/monitor.html datadog_monitor} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MonitorConfig);
    private _enableLogsSample?;
    /**
     * @stability stable
     */
    get enableLogsSample(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enableLogsSample(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnableLogsSample(): void;
    /**
     * @stability stable
     */
    get enableLogsSampleInput(): boolean | cdktf.IResolvable | undefined;
    private _escalationMessage?;
    /**
     * @stability stable
     */
    get escalationMessage(): string | undefined;
    /**
     * @stability stable
     */
    set escalationMessage(value: string | undefined);
    /**
     * @stability stable
     */
    resetEscalationMessage(): void;
    /**
     * @stability stable
     */
    get escalationMessageInput(): string | undefined;
    private _evaluationDelay?;
    /**
     * @stability stable
     */
    get evaluationDelay(): number | undefined;
    /**
     * @stability stable
     */
    set evaluationDelay(value: number | undefined);
    /**
     * @stability stable
     */
    resetEvaluationDelay(): void;
    /**
     * @stability stable
     */
    get evaluationDelayInput(): number | undefined;
    private _forceDelete?;
    /**
     * @stability stable
     */
    get forceDelete(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set forceDelete(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetForceDelete(): void;
    /**
     * @stability stable
     */
    get forceDeleteInput(): boolean | cdktf.IResolvable | undefined;
    private _groupbySimpleMonitor?;
    /**
     * @stability stable
     */
    get groupbySimpleMonitor(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set groupbySimpleMonitor(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetGroupbySimpleMonitor(): void;
    /**
     * @stability stable
     */
    get groupbySimpleMonitorInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _includeTags?;
    /**
     * @stability stable
     */
    get includeTags(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set includeTags(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIncludeTags(): void;
    /**
     * @stability stable
     */
    get includeTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _locked?;
    /**
     * @stability stable
     */
    get locked(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set locked(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetLocked(): void;
    /**
     * @stability stable
     */
    get lockedInput(): boolean | cdktf.IResolvable | undefined;
    private _message?;
    /**
     * @stability stable
     */
    get message(): string;
    /**
     * @stability stable
     */
    set message(value: string);
    /**
     * @stability stable
     */
    get messageInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _newGroupDelay?;
    /**
     * @stability stable
     */
    get newGroupDelay(): number | undefined;
    /**
     * @stability stable
     */
    set newGroupDelay(value: number | undefined);
    /**
     * @stability stable
     */
    resetNewGroupDelay(): void;
    /**
     * @stability stable
     */
    get newGroupDelayInput(): number | undefined;
    private _newHostDelay?;
    /**
     * @stability stable
     */
    get newHostDelay(): number | undefined;
    /**
     * @stability stable
     */
    set newHostDelay(value: number | undefined);
    /**
     * @stability stable
     */
    resetNewHostDelay(): void;
    /**
     * @stability stable
     */
    get newHostDelayInput(): number | undefined;
    private _noDataTimeframe?;
    /**
     * @stability stable
     */
    get noDataTimeframe(): number | undefined;
    /**
     * @stability stable
     */
    set noDataTimeframe(value: number | undefined);
    /**
     * @stability stable
     */
    resetNoDataTimeframe(): void;
    /**
     * @stability stable
     */
    get noDataTimeframeInput(): number | undefined;
    private _notifyAudit?;
    /**
     * @stability stable
     */
    get notifyAudit(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set notifyAudit(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetNotifyAudit(): void;
    /**
     * @stability stable
     */
    get notifyAuditInput(): boolean | cdktf.IResolvable | undefined;
    private _notifyNoData?;
    /**
     * @stability stable
     */
    get notifyNoData(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set notifyNoData(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetNotifyNoData(): void;
    /**
     * @stability stable
     */
    get notifyNoDataInput(): boolean | cdktf.IResolvable | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number | undefined;
    /**
     * @stability stable
     */
    set priority(value: number | undefined);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
    private _renotifyInterval?;
    /**
     * @stability stable
     */
    get renotifyInterval(): number | undefined;
    /**
     * @stability stable
     */
    set renotifyInterval(value: number | undefined);
    /**
     * @stability stable
     */
    resetRenotifyInterval(): void;
    /**
     * @stability stable
     */
    get renotifyIntervalInput(): number | undefined;
    private _renotifyOccurrences?;
    /**
     * @stability stable
     */
    get renotifyOccurrences(): number | undefined;
    /**
     * @stability stable
     */
    set renotifyOccurrences(value: number | undefined);
    /**
     * @stability stable
     */
    resetRenotifyOccurrences(): void;
    /**
     * @stability stable
     */
    get renotifyOccurrencesInput(): number | undefined;
    private _renotifyStatuses?;
    /**
     * @stability stable
     */
    get renotifyStatuses(): string[] | undefined;
    /**
     * @stability stable
     */
    set renotifyStatuses(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetRenotifyStatuses(): void;
    /**
     * @stability stable
     */
    get renotifyStatusesInput(): string[] | undefined;
    private _requireFullWindow?;
    /**
     * @stability stable
     */
    get requireFullWindow(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set requireFullWindow(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetRequireFullWindow(): void;
    /**
     * @stability stable
     */
    get requireFullWindowInput(): boolean | cdktf.IResolvable | undefined;
    private _restrictedRoles?;
    /**
     * @stability stable
     */
    get restrictedRoles(): string[] | undefined;
    /**
     * @stability stable
     */
    set restrictedRoles(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetRestrictedRoles(): void;
    /**
     * @stability stable
     */
    get restrictedRolesInput(): string[] | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[] | undefined;
    /**
     * @stability stable
     */
    set tags(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    private _timeoutH?;
    /**
     * @stability stable
     */
    get timeoutH(): number | undefined;
    /**
     * @stability stable
     */
    set timeoutH(value: number | undefined);
    /**
     * @stability stable
     */
    resetTimeoutH(): void;
    /**
     * @stability stable
     */
    get timeoutHInput(): number | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _validate?;
    /**
     * @stability stable
     */
    get validate(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set validate(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetValidate(): void;
    /**
     * @stability stable
     */
    get validateInput(): boolean | cdktf.IResolvable | undefined;
    private _monitorThresholdWindows?;
    private __monitorThresholdWindowsOutput;
    /**
     * @stability stable
     */
    get monitorThresholdWindows(): MonitorMonitorThresholdWindowsOutputReference;
    /**
     * @stability stable
     */
    putMonitorThresholdWindows(value: MonitorMonitorThresholdWindows | undefined): void;
    /**
     * @stability stable
     */
    resetMonitorThresholdWindows(): void;
    /**
     * @stability stable
     */
    get monitorThresholdWindowsInput(): MonitorMonitorThresholdWindows | undefined;
    private _monitorThresholds?;
    private __monitorThresholdsOutput;
    /**
     * @stability stable
     */
    get monitorThresholds(): MonitorMonitorThresholdsOutputReference;
    /**
     * @stability stable
     */
    putMonitorThresholds(value: MonitorMonitorThresholds | undefined): void;
    /**
     * @stability stable
     */
    resetMonitorThresholds(): void;
    /**
     * @stability stable
     */
    get monitorThresholdsInput(): MonitorMonitorThresholds | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
