import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RoleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of the role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/role.html#name Role#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * permission block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/role.html#permission Role#permission}
     *
     * @stability stable
     */
    readonly permission?: RolePermission[];
}
/**
 * @stability stable
 */
export interface RolePermission {
    /**
     * ID of the permission to assign.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/role.html#id Role#id}
     *
     * @stability stable
     */
    readonly id: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/role.html datadog_role}.
 *
 * @stability stable
 */
export declare class Role extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/role.html datadog_role} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RoleConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get userCount(): number;
    private _permission?;
    /**
     * @stability stable
     */
    get permission(): RolePermission[] | undefined;
    /**
     * @stability stable
     */
    set permission(value: RolePermission[] | undefined);
    /**
     * @stability stable
     */
    resetPermission(): void;
    /**
     * @stability stable
     */
    get permissionInput(): RolePermission[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
