import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface UserConfig extends cdktf.TerraformMetaArguments {
    /**
     * Whether the user is disabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/user.html#disabled User#disabled}
     *
     * @stability stable
     */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
     * Email address for user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/user.html#email User#email}
     *
     * @stability stable
     */
    readonly email: string;
    /**
     * Name for user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/user.html#name User#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * A list a role IDs to assign to the user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/user.html#roles User#roles}
     *
     * @stability stable
     */
    readonly roles?: string[];
    /**
     * Whether an invitation email should be sent when the user is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/user.html#send_user_invitation User#send_user_invitation}
     *
     * @stability stable
     */
    readonly sendUserInvitation?: boolean | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/user.html datadog_user}.
 *
 * @stability stable
 */
export declare class User extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/user.html datadog_user} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: UserConfig);
    private _disabled?;
    /**
     * @stability stable
     */
    get disabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set disabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetDisabled(): void;
    /**
     * @stability stable
     */
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _email?;
    /**
     * @stability stable
     */
    get email(): string;
    /**
     * @stability stable
     */
    set email(value: string);
    /**
     * @stability stable
     */
    get emailInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _roles?;
    /**
     * @stability stable
     */
    get roles(): string[] | undefined;
    /**
     * @stability stable
     */
    set roles(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetRoles(): void;
    /**
     * @stability stable
     */
    get rolesInput(): string[] | undefined;
    private _sendUserInvitation?;
    /**
     * @stability stable
     */
    get sendUserInvitation(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set sendUserInvitation(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetSendUserInvitation(): void;
    /**
     * @stability stable
     */
    get sendUserInvitationInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get userInvitationId(): string;
    /**
     * @stability stable
     */
    get verified(): any;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
