# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
import urllib.parse
from json.decoder import JSONDecodeError

import httpx

from .core.api_error import ApiError
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .core.jsonable_encoder import jsonable_encoder
from .core.remove_none_from_dict import remove_none_from_dict
from .errors.unprocessable_entity_error import UnprocessableEntityError
from .resources.apps.client import AppsClient, AsyncAppsClient
from .resources.bases.client import AsyncBasesClient, BasesClient
from .resources.configs.client import AsyncConfigsClient, ConfigsClient
from .resources.containers.client import AsyncContainersClient, ContainersClient
from .resources.environments.client import AsyncEnvironmentsClient, EnvironmentsClient
from .resources.evaluations.client import AsyncEvaluationsClient, EvaluationsClient
from .resources.evaluators.client import AsyncEvaluatorsClient, EvaluatorsClient
from .resources.observability.client import (
    AsyncObservabilityClient,
    ObservabilityClient,
)
from .resources.testsets.client import AsyncTestsetsClient, TestsetsClient
from .resources.variants.client import AsyncVariantsClient, VariantsClient
from .types.http_validation_error import HttpValidationError
from .types.invite_request import InviteRequest
from .types.list_api_keys_response import ListApiKeysResponse
from .types.organization import Organization
from .types.organization_output import OrganizationOutput
from .types.permission import Permission
from .types.workspace_response import WorkspaceResponse
from .types.workspace_role import WorkspaceRole
from .types.workspace_role_response import WorkspaceRoleResponse

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AgentaApi:
    def __init__(
        self,
        *,
        base_url: str,
        api_key: str,
        timeout: typing.Optional[float] = 60,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        self._client_wrapper = SyncClientWrapper(
            base_url=base_url,
            api_key=api_key,
            httpx_client=(
                httpx.Client(timeout=timeout) if httpx_client is None else httpx_client
            ),
        )
        self.observability = ObservabilityClient(client_wrapper=self._client_wrapper)
        self.apps = AppsClient(client_wrapper=self._client_wrapper)
        self.variants = VariantsClient(client_wrapper=self._client_wrapper)
        self.evaluations = EvaluationsClient(client_wrapper=self._client_wrapper)
        self.evaluators = EvaluatorsClient(client_wrapper=self._client_wrapper)
        self.testsets = TestsetsClient(client_wrapper=self._client_wrapper)
        self.containers = ContainersClient(client_wrapper=self._client_wrapper)
        self.environments = EnvironmentsClient(client_wrapper=self._client_wrapper)
        self.bases = BasesClient(client_wrapper=self._client_wrapper)
        self.configs = ConfigsClient(client_wrapper=self._client_wrapper)

    def list_api_keys(self) -> typing.List[ListApiKeysResponse]:
        """
        List all API keys associated with the authenticated user.

        Args:
        request (Request): The incoming request object.

        Returns:
        List[ListAPIKeysResponse]: A list of API Keys associated with the user.

        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.list_api_keys()
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "keys"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[ListApiKeysResponse], _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_api_key(self, *, workspace_id: str) -> str:
        """
        Creates an API key for a user.

        Args:
        request (Request): The request object containing the user ID in the request state.

        Returns:
        str: The created API key.

        Parameters:
            - workspace_id: str.
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.create_api_key(
            workspace_id="workspace_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "keys"),
            params=remove_none_from_dict({"workspace_id": workspace_id}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(str, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete_api_key(self, key_prefix: str) -> typing.Dict[str, typing.Any]:
        """
        Delete an API key with the given key prefix for the authenticated user.

        Args:
        key_prefix (str): The prefix of the API key to be deleted.
        request (Request): The incoming request object.

        Returns:
        dict: A dictionary containing a success message upon successful deletion.

        Raises:
        HTTPException: If the API key is not found or does not belong to the user.

        Parameters:
            - key_prefix: str.
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.delete_api_key(
            key_prefix="key_prefix",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"keys/{key_prefix}"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Dict[str, typing.Any], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def validate_api_key(self, key_prefix: str) -> bool:
        """
        This Function is called by the CLI and is used to validate an API key provided by a user in agenta init setup.
        Returns:
        bool: True. If the request reaches this point, the API key is valid.

        Parameters:
            - key_prefix: str.
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.validate_api_key(
            key_prefix="key_prefix",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"keys/{key_prefix}/validate"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(bool, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def list_organizations(self) -> typing.List[Organization]:
        """
        Returns a list of organizations associated with the user's session.

        Args:
        stoken_session (SessionContainer): The user's session token.

        Returns:
        list[Organization]: A list of organizations associated with the user's session.

        Raises:
        HTTPException: If there is an error retrieving the organizations from the database.

        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.list_organizations()
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "organizations"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[Organization], _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_organization(
        self,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        type: typing.Optional[str] = OMIT,
        owner: typing.Optional[str] = OMIT,
    ) -> typing.Any:
        """
        Parameters:
            - name: str.

            - description: typing.Optional[str].

            - type: typing.Optional[str].

            - owner: typing.Optional[str].
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.create_organization(
            name="name",
        )
        """
        _request: typing.Dict[str, typing.Any] = {"name": name}
        if description is not OMIT:
            _request["description"] = description
        if type is not OMIT:
            _request["type"] = type
        if owner is not OMIT:
            _request["owner"] = owner
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "organizations"
            ),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_own_org(self) -> OrganizationOutput:
        """
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.get_own_org()
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "organizations/own"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(OrganizationOutput, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def fetch_organization_details(self, org_id: str) -> typing.Any:
        """
        Get an organization's details.

        Raises:
        HTTPException: _description_
        Permission Denied

        Returns:
        OrganizationDB Instance

        Parameters:
            - org_id: str.
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.fetch_organization_details(
            org_id="org_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"organizations/{org_id}"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update_organization(
        self,
        org_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        updated_at: typing.Optional[dt.datetime] = OMIT,
    ) -> typing.Any:
        """
        Parameters:
            - org_id: str.

            - name: typing.Optional[str].

            - description: typing.Optional[str].

            - updated_at: typing.Optional[dt.datetime].
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.update_organization(
            org_id="org_id",
        )
        """
        _request: typing.Dict[str, typing.Any] = {}
        if name is not OMIT:
            _request["name"] = name
        if description is not OMIT:
            _request["description"] = description
        if updated_at is not OMIT:
            _request["updated_at"] = updated_at
        _response = self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"organizations/{org_id}"
            ),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def invite_user_to_workspace(
        self, org_id: str, workspace_id: str, *, request: typing.List[InviteRequest]
    ) -> typing.Any:
        """
        Parameters:
            - org_id: str.

            - workspace_id: str.

            - request: typing.List[InviteRequest].
        ---
        from agenta import InviteRequest
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.invite_user_to_workspace(
            org_id="org_id",
            workspace_id="workspace_id",
            request=[
                InviteRequest(
                    email="email",
                    roles=["roles"],
                )
            ],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"organizations/{org_id}/workspaces/{workspace_id}/invite",
            ),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def resend_invitation(
        self, org_id: str, workspace_id: str, *, email: str
    ) -> typing.Any:
        """
        Resend an invitation to a user to an Organization.

        Raises:
        HTTPException: _description_; status_code: 500
        HTTPException: Invitation not found or has expired; status_code: 400
        HTTPException: You already belong to this organization; status_code: 400

        Returns:
        JSONResponse: Resent invitation to user; status_code: 200

        Parameters:
            - org_id: str.

            - workspace_id: str.

            - email: str.
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.resend_invitation(
            org_id="org_id",
            workspace_id="workspace_id",
            email="email",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"organizations/{org_id}/workspaces/{workspace_id}/invite/resend",
            ),
            json=jsonable_encoder({"email": email}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def accept_invitation(
        self, org_id: str, workspace_id: str, *, token: str
    ) -> typing.Any:
        """
        Accept an invitation to a workspace.

        Raises:
        HTTPException: _description_; status_code: 500
        HTTPException: Invitation not found or has expired; status_code: 400
        HTTPException: You already belong to this organization; status_code: 400

        Returns:
        JSONResponse: Accepted invitation to workspace; status_code: 200

        Parameters:
            - org_id: str.

            - workspace_id: str.

            - token: str.
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.accept_invitation(
            org_id="org_id",
            workspace_id="workspace_id",
            token="token",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"organizations/{org_id}/workspaces/{workspace_id}/invite/accept",
            ),
            json=jsonable_encoder({"token": token}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_workspace(
        self,
        org_id: str,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        type: typing.Optional[str] = OMIT,
    ) -> WorkspaceResponse:
        """
        Parameters:
            - org_id: str.

            - name: str.

            - description: typing.Optional[str].

            - type: typing.Optional[str].
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.create_workspace(
            org_id="org_id",
            name="name",
        )
        """
        _request: typing.Dict[str, typing.Any] = {"name": name}
        if description is not OMIT:
            _request["description"] = description
        if type is not OMIT:
            _request["type"] = type
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"organizations/{org_id}/workspaces",
            ),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(WorkspaceResponse, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update_workspace(
        self,
        org_id: str,
        workspace_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        updated_at: typing.Optional[dt.datetime] = OMIT,
    ) -> WorkspaceResponse:
        """
        Parameters:
            - org_id: str.

            - workspace_id: str.

            - name: typing.Optional[str].

            - description: typing.Optional[str].

            - updated_at: typing.Optional[dt.datetime].
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.update_workspace(
            org_id="org_id",
            workspace_id="workspace_id",
        )
        """
        _request: typing.Dict[str, typing.Any] = {}
        if name is not OMIT:
            _request["name"] = name
        if description is not OMIT:
            _request["description"] = description
        if updated_at is not OMIT:
            _request["updated_at"] = updated_at
        _response = self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"organizations/{org_id}/workspaces/{workspace_id}",
            ),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(WorkspaceResponse, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_all_workspace_roles(self) -> typing.List[WorkspaceRoleResponse]:
        """
        Get all workspace roles.

        Returns a list of all available workspace roles.

        Returns:
        List[WorkspaceRoleResponse]: A list of WorkspaceRole objects representing the available workspace roles.

        Raises:
        HTTPException: If an error occurs while retrieving the workspace roles.

        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.get_all_workspace_roles()
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "workspaces/roles"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[WorkspaceRoleResponse], _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_all_workspace_permissions(self) -> typing.List[Permission]:
        """
        Get all workspace permissions.

        Returns a list of all available workspace permissions.

        Returns:
        List[Permission]: A list of Permission objects representing the available workspace permissions.

        Raises:
        HTTPException: If there is an error retrieving the workspace permissions.

        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.get_all_workspace_permissions()
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "workspaces/permissions"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[Permission], _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def assign_role_to_user(
        self,
        workspace_id: str,
        *,
        email: str,
        organization_id: str,
        role: typing.Optional[WorkspaceRole] = OMIT,
    ) -> bool:
        """
        Assigns a role to a user in a workspace.

        Args:
        payload (UserRole): The payload containing the organization id, user email, and role to assign.
        workspace_id (str): The ID of the workspace.
        request (Request): The FastAPI request object.

        Returns:
        bool: True if the role was successfully assigned, False otherwise.

        Raises:
        HTTPException: If the user does not have permission to perform this action.
        HTTPException: If there is an error assigning the role to the user.

        Parameters:
            - workspace_id: str.

            - email: str.

            - organization_id: str.

            - role: typing.Optional[WorkspaceRole].
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.assign_role_to_user(
            workspace_id="workspace_id",
            email="email",
            organization_id="organization_id",
        )
        """
        _request: typing.Dict[str, typing.Any] = {
            "email": email,
            "organization_id": organization_id,
        }
        if role is not OMIT:
            _request["role"] = role.value
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"workspaces/{workspace_id}/roles",
            ),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(bool, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def unassign_role_from_user(
        self, workspace_id: str, *, email: str, org_id: str, role: str
    ) -> typing.Any:
        """
        Delete a role assignment from a user in a workspace.

        Args:
        workspace_id (str): The ID of the workspace.
        email (str): The email of the user to remove the role from.
        org_id (str): The ID of the organization.
        role (str): The role to remove from the user.
        request (Request): The FastAPI request object.

        Returns:
        bool: True if the role assignment was successfully deleted.

        Raises:
        HTTPException: If there is an error in the request or the user does not have permission to perform the action.
        HTTPException: If there is an error in updating the user's roles.

        Parameters:
            - workspace_id: str.

            - email: str.

            - org_id: str.

            - role: str.
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.unassign_role_from_user(
            workspace_id="workspace_id",
            email="email",
            org_id="org_id",
            role="role",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"workspaces/{workspace_id}/roles",
            ),
            params=remove_none_from_dict(
                {"email": email, "org_id": org_id, "role": role}
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def remove_user_from_workspace(
        self, workspace_id: str, *, org_id: str, email: str
    ) -> WorkspaceResponse:
        """
        Remove a user from a workspace.

        Parameters:

        - payload (UserRole): The payload containing the user email and organization ID.
        - workspace_id (str): The ID of the workspace.
        - request (Request): The FastAPI request object.

        Returns:

        - WorkspaceResponse: The updated workspace.

        Raises:

        - HTTPException: If the user does not have permission to perform this action.
        - HTTPException: If there is an error during the removal process.

        Parameters:
            - workspace_id: str.

            - org_id: str.

            - email: str.
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.remove_user_from_workspace(
            workspace_id="workspace_id",
            org_id="org_id",
            email="email",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"workspaces/{workspace_id}/users",
            ),
            params=remove_none_from_dict({"org_id": org_id, "email": email}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(WorkspaceResponse, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def health_check(self) -> typing.Any:
        """
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.health_check()
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "health"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def user_profile(self) -> typing.Any:
        """
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.user_profile()
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "profile"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncAgentaApi:
    def __init__(
        self,
        *,
        base_url: str,
        api_key: str,
        timeout: typing.Optional[float] = 60,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        self._client_wrapper = AsyncClientWrapper(
            base_url=base_url,
            api_key=api_key,
            httpx_client=(
                httpx.AsyncClient(timeout=timeout)
                if httpx_client is None
                else httpx_client
            ),
        )
        self.observability = AsyncObservabilityClient(
            client_wrapper=self._client_wrapper
        )
        self.apps = AsyncAppsClient(client_wrapper=self._client_wrapper)
        self.variants = AsyncVariantsClient(client_wrapper=self._client_wrapper)
        self.evaluations = AsyncEvaluationsClient(client_wrapper=self._client_wrapper)
        self.evaluators = AsyncEvaluatorsClient(client_wrapper=self._client_wrapper)
        self.testsets = AsyncTestsetsClient(client_wrapper=self._client_wrapper)
        self.containers = AsyncContainersClient(client_wrapper=self._client_wrapper)
        self.environments = AsyncEnvironmentsClient(client_wrapper=self._client_wrapper)
        self.bases = AsyncBasesClient(client_wrapper=self._client_wrapper)
        self.configs = AsyncConfigsClient(client_wrapper=self._client_wrapper)

    async def list_api_keys(self) -> typing.List[ListApiKeysResponse]:
        """
        List all API keys associated with the authenticated user.

        Args:
        request (Request): The incoming request object.

        Returns:
        List[ListAPIKeysResponse]: A list of API Keys associated with the user.

        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.list_api_keys()
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "keys"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[ListApiKeysResponse], _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_api_key(self, *, workspace_id: str) -> str:
        """
        Creates an API key for a user.

        Args:
        request (Request): The request object containing the user ID in the request state.

        Returns:
        str: The created API key.

        Parameters:
            - workspace_id: str.
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.create_api_key(
            workspace_id="workspace_id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "keys"),
            params=remove_none_from_dict({"workspace_id": workspace_id}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(str, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete_api_key(self, key_prefix: str) -> typing.Dict[str, typing.Any]:
        """
        Delete an API key with the given key prefix for the authenticated user.

        Args:
        key_prefix (str): The prefix of the API key to be deleted.
        request (Request): The incoming request object.

        Returns:
        dict: A dictionary containing a success message upon successful deletion.

        Raises:
        HTTPException: If the API key is not found or does not belong to the user.

        Parameters:
            - key_prefix: str.
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.delete_api_key(
            key_prefix="key_prefix",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"keys/{key_prefix}"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Dict[str, typing.Any], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def validate_api_key(self, key_prefix: str) -> bool:
        """
        This Function is called by the CLI and is used to validate an API key provided by a user in agenta init setup.
        Returns:
        bool: True. If the request reaches this point, the API key is valid.

        Parameters:
            - key_prefix: str.
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.validate_api_key(
            key_prefix="key_prefix",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"keys/{key_prefix}/validate"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(bool, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def list_organizations(self) -> typing.List[Organization]:
        """
        Returns a list of organizations associated with the user's session.

        Args:
        stoken_session (SessionContainer): The user's session token.

        Returns:
        list[Organization]: A list of organizations associated with the user's session.

        Raises:
        HTTPException: If there is an error retrieving the organizations from the database.

        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.list_organizations()
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "organizations"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[Organization], _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_organization(
        self,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        type: typing.Optional[str] = OMIT,
        owner: typing.Optional[str] = OMIT,
    ) -> typing.Any:
        """
        Parameters:
            - name: str.

            - description: typing.Optional[str].

            - type: typing.Optional[str].

            - owner: typing.Optional[str].
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.create_organization(
            name="name",
        )
        """
        _request: typing.Dict[str, typing.Any] = {"name": name}
        if description is not OMIT:
            _request["description"] = description
        if type is not OMIT:
            _request["type"] = type
        if owner is not OMIT:
            _request["owner"] = owner
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "organizations"
            ),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_own_org(self) -> OrganizationOutput:
        """
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.get_own_org()
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "organizations/own"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(OrganizationOutput, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def fetch_organization_details(self, org_id: str) -> typing.Any:
        """
        Get an organization's details.

        Raises:
        HTTPException: _description_
        Permission Denied

        Returns:
        OrganizationDB Instance

        Parameters:
            - org_id: str.
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.fetch_organization_details(
            org_id="org_id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"organizations/{org_id}"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update_organization(
        self,
        org_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        updated_at: typing.Optional[dt.datetime] = OMIT,
    ) -> typing.Any:
        """
        Parameters:
            - org_id: str.

            - name: typing.Optional[str].

            - description: typing.Optional[str].

            - updated_at: typing.Optional[dt.datetime].
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.update_organization(
            org_id="org_id",
        )
        """
        _request: typing.Dict[str, typing.Any] = {}
        if name is not OMIT:
            _request["name"] = name
        if description is not OMIT:
            _request["description"] = description
        if updated_at is not OMIT:
            _request["updated_at"] = updated_at
        _response = await self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"organizations/{org_id}"
            ),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def invite_user_to_workspace(
        self, org_id: str, workspace_id: str, *, request: typing.List[InviteRequest]
    ) -> typing.Any:
        """
        Parameters:
            - org_id: str.

            - workspace_id: str.

            - request: typing.List[InviteRequest].
        ---
        from agenta import InviteRequest
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.invite_user_to_workspace(
            org_id="org_id",
            workspace_id="workspace_id",
            request=[
                InviteRequest(
                    email="email",
                    roles=["roles"],
                )
            ],
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"organizations/{org_id}/workspaces/{workspace_id}/invite",
            ),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def resend_invitation(
        self, org_id: str, workspace_id: str, *, email: str
    ) -> typing.Any:
        """
        Resend an invitation to a user to an Organization.

        Raises:
        HTTPException: _description_; status_code: 500
        HTTPException: Invitation not found or has expired; status_code: 400
        HTTPException: You already belong to this organization; status_code: 400

        Returns:
        JSONResponse: Resent invitation to user; status_code: 200

        Parameters:
            - org_id: str.

            - workspace_id: str.

            - email: str.
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.resend_invitation(
            org_id="org_id",
            workspace_id="workspace_id",
            email="email",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"organizations/{org_id}/workspaces/{workspace_id}/invite/resend",
            ),
            json=jsonable_encoder({"email": email}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def accept_invitation(
        self, org_id: str, workspace_id: str, *, token: str
    ) -> typing.Any:
        """
        Accept an invitation to a workspace.

        Raises:
        HTTPException: _description_; status_code: 500
        HTTPException: Invitation not found or has expired; status_code: 400
        HTTPException: You already belong to this organization; status_code: 400

        Returns:
        JSONResponse: Accepted invitation to workspace; status_code: 200

        Parameters:
            - org_id: str.

            - workspace_id: str.

            - token: str.
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.accept_invitation(
            org_id="org_id",
            workspace_id="workspace_id",
            token="token",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"organizations/{org_id}/workspaces/{workspace_id}/invite/accept",
            ),
            json=jsonable_encoder({"token": token}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_workspace(
        self,
        org_id: str,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        type: typing.Optional[str] = OMIT,
    ) -> WorkspaceResponse:
        """
        Parameters:
            - org_id: str.

            - name: str.

            - description: typing.Optional[str].

            - type: typing.Optional[str].
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.create_workspace(
            org_id="org_id",
            name="name",
        )
        """
        _request: typing.Dict[str, typing.Any] = {"name": name}
        if description is not OMIT:
            _request["description"] = description
        if type is not OMIT:
            _request["type"] = type
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"organizations/{org_id}/workspaces",
            ),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(WorkspaceResponse, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update_workspace(
        self,
        org_id: str,
        workspace_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        updated_at: typing.Optional[dt.datetime] = OMIT,
    ) -> WorkspaceResponse:
        """
        Parameters:
            - org_id: str.

            - workspace_id: str.

            - name: typing.Optional[str].

            - description: typing.Optional[str].

            - updated_at: typing.Optional[dt.datetime].
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.update_workspace(
            org_id="org_id",
            workspace_id="workspace_id",
        )
        """
        _request: typing.Dict[str, typing.Any] = {}
        if name is not OMIT:
            _request["name"] = name
        if description is not OMIT:
            _request["description"] = description
        if updated_at is not OMIT:
            _request["updated_at"] = updated_at
        _response = await self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"organizations/{org_id}/workspaces/{workspace_id}",
            ),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(WorkspaceResponse, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_all_workspace_roles(self) -> typing.List[WorkspaceRoleResponse]:
        """
        Get all workspace roles.

        Returns a list of all available workspace roles.

        Returns:
        List[WorkspaceRoleResponse]: A list of WorkspaceRole objects representing the available workspace roles.

        Raises:
        HTTPException: If an error occurs while retrieving the workspace roles.

        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.get_all_workspace_roles()
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "workspaces/roles"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[WorkspaceRoleResponse], _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_all_workspace_permissions(self) -> typing.List[Permission]:
        """
        Get all workspace permissions.

        Returns a list of all available workspace permissions.

        Returns:
        List[Permission]: A list of Permission objects representing the available workspace permissions.

        Raises:
        HTTPException: If there is an error retrieving the workspace permissions.

        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.get_all_workspace_permissions()
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "workspaces/permissions"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[Permission], _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def assign_role_to_user(
        self,
        workspace_id: str,
        *,
        email: str,
        organization_id: str,
        role: typing.Optional[WorkspaceRole] = OMIT,
    ) -> bool:
        """
        Assigns a role to a user in a workspace.

        Args:
        payload (UserRole): The payload containing the organization id, user email, and role to assign.
        workspace_id (str): The ID of the workspace.
        request (Request): The FastAPI request object.

        Returns:
        bool: True if the role was successfully assigned, False otherwise.

        Raises:
        HTTPException: If the user does not have permission to perform this action.
        HTTPException: If there is an error assigning the role to the user.

        Parameters:
            - workspace_id: str.

            - email: str.

            - organization_id: str.

            - role: typing.Optional[WorkspaceRole].
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.assign_role_to_user(
            workspace_id="workspace_id",
            email="email",
            organization_id="organization_id",
        )
        """
        _request: typing.Dict[str, typing.Any] = {
            "email": email,
            "organization_id": organization_id,
        }
        if role is not OMIT:
            _request["role"] = role.value
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"workspaces/{workspace_id}/roles",
            ),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(bool, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def unassign_role_from_user(
        self, workspace_id: str, *, email: str, org_id: str, role: str
    ) -> typing.Any:
        """
        Delete a role assignment from a user in a workspace.

        Args:
        workspace_id (str): The ID of the workspace.
        email (str): The email of the user to remove the role from.
        org_id (str): The ID of the organization.
        role (str): The role to remove from the user.
        request (Request): The FastAPI request object.

        Returns:
        bool: True if the role assignment was successfully deleted.

        Raises:
        HTTPException: If there is an error in the request or the user does not have permission to perform the action.
        HTTPException: If there is an error in updating the user's roles.

        Parameters:
            - workspace_id: str.

            - email: str.

            - org_id: str.

            - role: str.
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.unassign_role_from_user(
            workspace_id="workspace_id",
            email="email",
            org_id="org_id",
            role="role",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"workspaces/{workspace_id}/roles",
            ),
            params=remove_none_from_dict(
                {"email": email, "org_id": org_id, "role": role}
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def remove_user_from_workspace(
        self, workspace_id: str, *, org_id: str, email: str
    ) -> WorkspaceResponse:
        """
        Remove a user from a workspace.

        Parameters:

        - payload (UserRole): The payload containing the user email and organization ID.
        - workspace_id (str): The ID of the workspace.
        - request (Request): The FastAPI request object.

        Returns:

        - WorkspaceResponse: The updated workspace.

        Raises:

        - HTTPException: If the user does not have permission to perform this action.
        - HTTPException: If there is an error during the removal process.

        Parameters:
            - workspace_id: str.

            - org_id: str.

            - email: str.
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.remove_user_from_workspace(
            workspace_id="workspace_id",
            org_id="org_id",
            email="email",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"workspaces/{workspace_id}/users",
            ),
            params=remove_none_from_dict({"org_id": org_id, "email": email}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(WorkspaceResponse, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def health_check(self) -> typing.Any:
        """
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.health_check()
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "health"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def user_profile(self) -> typing.Any:
        """
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.user_profile()
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "profile"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
