# This file was auto-generated by Fern from our API Definition.

import typing
import urllib.parse
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.jsonable_encoder import jsonable_encoder
from ...core.remove_none_from_dict import remove_none_from_dict
from ...errors.unprocessable_entity_error import UnprocessableEntityError
from ...types.app import App
from ...types.app_variant_response import AppVariantResponse
from ...types.create_app_output import CreateAppOutput
from ...types.environment_output import EnvironmentOutput
from ...types.environment_output_extended import EnvironmentOutputExtended
from ...types.http_validation_error import HttpValidationError

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AppsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_app_variants(self, app_id: str) -> typing.List[AppVariantResponse]:
        """
        Retrieve a list of app variants for a given app ID.

        Args:
        app_id (str): The ID of the app to retrieve variants for.
        stoken_session (SessionContainer, optional): The session container to verify the user's session. Defaults to Depends(verify_session()).

        Returns:
        List[AppVariantResponse]: A list of app variants for the given app ID.

        Parameters:
            - app_id: str.
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.apps.list_app_variants(
            app_id="app_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"apps/{app_id}/variants"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[AppVariantResponse], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_variant_by_env(
        self, *, app_id: str, environment: str
    ) -> AppVariantResponse:
        """
        Retrieve the app variant based on the provided app_id and environment.

        Args:
        app_id (str): The ID of the app to retrieve the variant for.
        environment (str): The environment of the app variant to retrieve.
        stoken_session (SessionContainer, optional): The session token container. Defaults to Depends(verify_session()).

        Raises:
        HTTPException: If the app variant is not found (status_code=500), or if a ValueError is raised (status_code=400), or if any other exception is raised (status_code=500).

        Returns:
        AppVariantResponse: The retrieved app variant.

        Parameters:
            - app_id: str.

            - environment: str.
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.apps.get_variant_by_env(
            app_id="app_id",
            environment="environment",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "apps/get_variant_by_env"
            ),
            params=remove_none_from_dict(
                {"app_id": app_id, "environment": environment}
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(AppVariantResponse, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def list_apps(
        self,
        *,
        app_name: typing.Optional[str] = None,
        org_id: typing.Optional[str] = None,
        workspace_id: typing.Optional[str] = None,
    ) -> typing.List[App]:
        """
        Retrieve a list of apps filtered by app_name and org_id.

        Args:
        app_name (Optional[str]): The name of the app to filter by.
        org_id (Optional[str]): The ID of the organization to filter by.
        stoken_session (SessionContainer): The session container.

        Returns:
        List[App]: A list of apps filtered by app_name and org_id.

        Raises:
        HTTPException: If there was an error retrieving the list of apps.

        Parameters:
            - app_name: typing.Optional[str].

            - org_id: typing.Optional[str].

            - workspace_id: typing.Optional[str].
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.apps.list_apps()
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "apps"),
            params=remove_none_from_dict(
                {"app_name": app_name, "org_id": org_id, "workspace_id": workspace_id}
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[App], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_app(
        self,
        *,
        app_name: str,
        organization_id: typing.Optional[str] = OMIT,
        workspace_id: typing.Optional[str] = OMIT,
    ) -> CreateAppOutput:
        """
        Create a new app for a user or organization.

        Args:
        payload (CreateApp): The payload containing the app name and organization ID (optional).
        stoken_session (SessionContainer): The session container containing the user's session token.

        Returns:
        CreateAppOutput: The output containing the newly created app's ID and name.

        Raises:
        HTTPException: If there is an error creating the app or the user does not have permission to access the app.

        Parameters:
            - app_name: str.

            - organization_id: typing.Optional[str].

            - workspace_id: typing.Optional[str].
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.apps.create_app(
            app_name="app_name",
        )
        """
        _request: typing.Dict[str, typing.Any] = {"app_name": app_name}
        if organization_id is not OMIT:
            _request["organization_id"] = organization_id
        if workspace_id is not OMIT:
            _request["workspace_id"] = workspace_id
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "apps"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(CreateAppOutput, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def add_variant_from_image(
        self,
        app_id: str,
        *,
        variant_name: str,
        docker_id: str,
        tags: str,
        base_name: typing.Optional[str] = OMIT,
        config_name: typing.Optional[str] = OMIT,
    ) -> typing.Any:
        """
        Add a new variant to an app based on a Docker image.

        Args:
        app_id (str): The ID of the app to add the variant to.
        payload (AddVariantFromImagePayload): The payload containing information about the variant to add.
        stoken_session (SessionContainer, optional): The session container. Defaults to Depends(verify_session()).

        Raises:
        HTTPException: If the feature flag is set to "demo" or if the image does not have a tag starting with the registry name (agenta-server) or if the image is not found or if the user does not have access to the app.

        Returns:
        dict: The newly added variant.

        Parameters:
            - app_id: str.

            - variant_name: str.

            - docker_id: str.

            - tags: str.

            - base_name: typing.Optional[str].

            - config_name: typing.Optional[str].
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.apps.add_variant_from_image(
            app_id="app_id",
            variant_name="variant_name",
            docker_id="docker_id",
            tags="tags",
        )
        """
        _request: typing.Dict[str, typing.Any] = {
            "variant_name": variant_name,
            "docker_id": docker_id,
            "tags": tags,
        }
        if base_name is not OMIT:
            _request["base_name"] = base_name
        if config_name is not OMIT:
            _request["config_name"] = config_name
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"apps/{app_id}/variant/from-image",
            ),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def remove_app(self, app_id: str) -> typing.Any:
        """
        Remove app, all its variant, containers and images

        Arguments:
        app -- App to remove

        Parameters:
            - app_id: str.
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.apps.remove_app(
            app_id="app_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"apps/{app_id}"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_app_and_variant_from_template(
        self,
        *,
        app_name: str,
        template_id: str,
        env_vars: typing.Dict[str, str],
        organization_id: typing.Optional[str] = OMIT,
        workspace_id: typing.Optional[str] = OMIT,
    ) -> AppVariantResponse:
        """
        Create an app and variant from a template.

        Args:
        payload (CreateAppVariant): The payload containing the app and variant information.
        stoken_session (SessionContainer, optional): The session container. Defaults to Depends(verify_session()).

        Raises:
        HTTPException: If the user has reached the app limit or if an app with the same name already exists.

        Returns:
        AppVariantResponse: The output of the created app variant.

        Parameters:
            - app_name: str.

            - template_id: str.

            - env_vars: typing.Dict[str, str].

            - organization_id: typing.Optional[str].

            - workspace_id: typing.Optional[str].
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.apps.create_app_and_variant_from_template(
            app_name="app_name",
            template_id="template_id",
            env_vars={"env_vars": "env_vars"},
        )
        """
        _request: typing.Dict[str, typing.Any] = {
            "app_name": app_name,
            "template_id": template_id,
            "env_vars": env_vars,
        }
        if organization_id is not OMIT:
            _request["organization_id"] = organization_id
        if workspace_id is not OMIT:
            _request["workspace_id"] = workspace_id
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                "apps/app_and_variant_from_template",
            ),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(AppVariantResponse, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def list_environments(self, app_id: str) -> typing.List[EnvironmentOutput]:
        """
        Retrieve a list of environments for a given app ID.

        Args:
        app_id (str): The ID of the app to retrieve environments for.
        stoken_session (SessionContainer, optional): The session container. Defaults to Depends(verify_session()).

        Returns:
        List[EnvironmentOutput]: A list of environment objects.

        Parameters:
            - app_id: str.
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.apps.list_environments(
            app_id="app_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"apps/{app_id}/environments"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[EnvironmentOutput], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def environment_revisions(
        self, app_id: str, environment_name: typing.Any
    ) -> EnvironmentOutputExtended:
        """
        Parameters:
            - app_id: str.

            - environment_name: typing.Any.
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"apps/{app_id}/revisions/{environment_name}",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(EnvironmentOutputExtended, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncAppsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_app_variants(self, app_id: str) -> typing.List[AppVariantResponse]:
        """
        Retrieve a list of app variants for a given app ID.

        Args:
        app_id (str): The ID of the app to retrieve variants for.
        stoken_session (SessionContainer, optional): The session container to verify the user's session. Defaults to Depends(verify_session()).

        Returns:
        List[AppVariantResponse]: A list of app variants for the given app ID.

        Parameters:
            - app_id: str.
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.apps.list_app_variants(
            app_id="app_id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"apps/{app_id}/variants"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[AppVariantResponse], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_variant_by_env(
        self, *, app_id: str, environment: str
    ) -> AppVariantResponse:
        """
        Retrieve the app variant based on the provided app_id and environment.

        Args:
        app_id (str): The ID of the app to retrieve the variant for.
        environment (str): The environment of the app variant to retrieve.
        stoken_session (SessionContainer, optional): The session token container. Defaults to Depends(verify_session()).

        Raises:
        HTTPException: If the app variant is not found (status_code=500), or if a ValueError is raised (status_code=400), or if any other exception is raised (status_code=500).

        Returns:
        AppVariantResponse: The retrieved app variant.

        Parameters:
            - app_id: str.

            - environment: str.
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.apps.get_variant_by_env(
            app_id="app_id",
            environment="environment",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "apps/get_variant_by_env"
            ),
            params=remove_none_from_dict(
                {"app_id": app_id, "environment": environment}
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(AppVariantResponse, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def list_apps(
        self,
        *,
        app_name: typing.Optional[str] = None,
        org_id: typing.Optional[str] = None,
        workspace_id: typing.Optional[str] = None,
    ) -> typing.List[App]:
        """
        Retrieve a list of apps filtered by app_name and org_id.

        Args:
        app_name (Optional[str]): The name of the app to filter by.
        org_id (Optional[str]): The ID of the organization to filter by.
        stoken_session (SessionContainer): The session container.

        Returns:
        List[App]: A list of apps filtered by app_name and org_id.

        Raises:
        HTTPException: If there was an error retrieving the list of apps.

        Parameters:
            - app_name: typing.Optional[str].

            - org_id: typing.Optional[str].

            - workspace_id: typing.Optional[str].
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.apps.list_apps()
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "apps"),
            params=remove_none_from_dict(
                {"app_name": app_name, "org_id": org_id, "workspace_id": workspace_id}
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[App], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_app(
        self,
        *,
        app_name: str,
        organization_id: typing.Optional[str] = OMIT,
        workspace_id: typing.Optional[str] = OMIT,
    ) -> CreateAppOutput:
        """
        Create a new app for a user or organization.

        Args:
        payload (CreateApp): The payload containing the app name and organization ID (optional).
        stoken_session (SessionContainer): The session container containing the user's session token.

        Returns:
        CreateAppOutput: The output containing the newly created app's ID and name.

        Raises:
        HTTPException: If there is an error creating the app or the user does not have permission to access the app.

        Parameters:
            - app_name: str.

            - organization_id: typing.Optional[str].

            - workspace_id: typing.Optional[str].
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.apps.create_app(
            app_name="app_name",
        )
        """
        _request: typing.Dict[str, typing.Any] = {"app_name": app_name}
        if organization_id is not OMIT:
            _request["organization_id"] = organization_id
        if workspace_id is not OMIT:
            _request["workspace_id"] = workspace_id
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "apps"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(CreateAppOutput, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def add_variant_from_image(
        self,
        app_id: str,
        *,
        variant_name: str,
        docker_id: str,
        tags: str,
        base_name: typing.Optional[str] = OMIT,
        config_name: typing.Optional[str] = OMIT,
    ) -> typing.Any:
        """
        Add a new variant to an app based on a Docker image.

        Args:
        app_id (str): The ID of the app to add the variant to.
        payload (AddVariantFromImagePayload): The payload containing information about the variant to add.
        stoken_session (SessionContainer, optional): The session container. Defaults to Depends(verify_session()).

        Raises:
        HTTPException: If the feature flag is set to "demo" or if the image does not have a tag starting with the registry name (agenta-server) or if the image is not found or if the user does not have access to the app.

        Returns:
        dict: The newly added variant.

        Parameters:
            - app_id: str.

            - variant_name: str.

            - docker_id: str.

            - tags: str.

            - base_name: typing.Optional[str].

            - config_name: typing.Optional[str].
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.apps.add_variant_from_image(
            app_id="app_id",
            variant_name="variant_name",
            docker_id="docker_id",
            tags="tags",
        )
        """
        _request: typing.Dict[str, typing.Any] = {
            "variant_name": variant_name,
            "docker_id": docker_id,
            "tags": tags,
        }
        if base_name is not OMIT:
            _request["base_name"] = base_name
        if config_name is not OMIT:
            _request["config_name"] = config_name
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"apps/{app_id}/variant/from-image",
            ),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def remove_app(self, app_id: str) -> typing.Any:
        """
        Remove app, all its variant, containers and images

        Arguments:
        app -- App to remove

        Parameters:
            - app_id: str.
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.apps.remove_app(
            app_id="app_id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"apps/{app_id}"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_app_and_variant_from_template(
        self,
        *,
        app_name: str,
        template_id: str,
        env_vars: typing.Dict[str, str],
        organization_id: typing.Optional[str] = OMIT,
        workspace_id: typing.Optional[str] = OMIT,
    ) -> AppVariantResponse:
        """
        Create an app and variant from a template.

        Args:
        payload (CreateAppVariant): The payload containing the app and variant information.
        stoken_session (SessionContainer, optional): The session container. Defaults to Depends(verify_session()).

        Raises:
        HTTPException: If the user has reached the app limit or if an app with the same name already exists.

        Returns:
        AppVariantResponse: The output of the created app variant.

        Parameters:
            - app_name: str.

            - template_id: str.

            - env_vars: typing.Dict[str, str].

            - organization_id: typing.Optional[str].

            - workspace_id: typing.Optional[str].
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.apps.create_app_and_variant_from_template(
            app_name="app_name",
            template_id="template_id",
            env_vars={"env_vars": "env_vars"},
        )
        """
        _request: typing.Dict[str, typing.Any] = {
            "app_name": app_name,
            "template_id": template_id,
            "env_vars": env_vars,
        }
        if organization_id is not OMIT:
            _request["organization_id"] = organization_id
        if workspace_id is not OMIT:
            _request["workspace_id"] = workspace_id
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                "apps/app_and_variant_from_template",
            ),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(AppVariantResponse, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def list_environments(self, app_id: str) -> typing.List[EnvironmentOutput]:
        """
        Retrieve a list of environments for a given app ID.

        Args:
        app_id (str): The ID of the app to retrieve environments for.
        stoken_session (SessionContainer, optional): The session container. Defaults to Depends(verify_session()).

        Returns:
        List[EnvironmentOutput]: A list of environment objects.

        Parameters:
            - app_id: str.
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.apps.list_environments(
            app_id="app_id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"apps/{app_id}/environments"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[EnvironmentOutput], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def environment_revisions(
        self, app_id: str, environment_name: typing.Any
    ) -> EnvironmentOutputExtended:
        """
        Parameters:
            - app_id: str.

            - environment_name: typing.Any.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"apps/{app_id}/revisions/{environment_name}",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(EnvironmentOutputExtended, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
