# This file was auto-generated by Fern from our API Definition.

import typing
import urllib.parse
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.jsonable_encoder import jsonable_encoder
from ...core.remove_none_from_dict import remove_none_from_dict
from ...errors.unprocessable_entity_error import UnprocessableEntityError
from ...types.create_span import CreateSpan
from ...types.create_trace_response import CreateTraceResponse
from ...types.feedback import Feedback
from ...types.http_validation_error import HttpValidationError
from ...types.span_detail import SpanDetail
from ...types.trace_detail import TraceDetail
from ...types.with_pagination import WithPagination

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ObservabilityClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def dashboard(
        self,
        *,
        app_id: str,
        time_range: typing.Optional[str] = None,
        environment: typing.Optional[str] = None,
        variant: typing.Optional[str] = None,
    ) -> typing.Any:
        """
        Parameters:
            - app_id: str.

            - time_range: typing.Optional[str].

            - environment: typing.Optional[str].

            - variant: typing.Optional[str].
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.observability.dashboard(
            app_id="app_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "observability/dashboard"
            ),
            params=remove_none_from_dict(
                {
                    "app_id": app_id,
                    "timeRange": time_range,
                    "environment": environment,
                    "variant": variant,
                }
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_traces(
        self,
        *,
        app_id: str,
        page: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        type: typing.Optional[str] = None,
        trace_id: typing.Optional[str] = None,
        environment: typing.Optional[str] = None,
        variant: typing.Optional[str] = None,
        created_at: typing.Optional[str] = None,
    ) -> WithPagination:
        """
        Parameters:
            - app_id: str.

            - page: typing.Optional[int].

            - page_size: typing.Optional[int].

            - type: typing.Optional[str].

            - trace_id: typing.Optional[str].

            - environment: typing.Optional[str].

            - variant: typing.Optional[str].

            - created_at: typing.Optional[str].
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.observability.get_traces(
            app_id="app_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "observability/traces"
            ),
            params=remove_none_from_dict(
                {
                    "app_id": app_id,
                    "page": page,
                    "pageSize": page_size,
                    "type": type,
                    "trace_id": trace_id,
                    "environment": environment,
                    "variant": variant,
                    "created_at": created_at,
                }
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(WithPagination, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_traces(
        self, *, trace: str, spans: typing.List[CreateSpan]
    ) -> CreateTraceResponse:
        """
        Parameters:
            - trace: str.

            - spans: typing.List[CreateSpan].
        ---
        import datetime

        from agenta import CreateSpan, SpanKind, SpanStatusCode
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.observability.create_traces(
            trace="trace",
            spans=[
                CreateSpan(
                    id="id",
                    name="name",
                    spankind=SpanKind.TOOL,
                    status=SpanStatusCode.UNSET,
                    start_time=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    end_time=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                )
            ],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "observability/trace/"
            ),
            json=jsonable_encoder({"trace": trace, "spans": spans}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(CreateTraceResponse, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete_traces(self, *, request: typing.List[str]) -> bool:
        """
        Parameters:
            - request: typing.List[str].
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.observability.delete_traces(
            request=["string"],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "observability/traces"
            ),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(bool, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_trace_detail(self, trace_id: str) -> TraceDetail:
        """
        Parameters:
            - trace_id: str.
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.observability.get_trace_detail(
            trace_id="trace_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"observability/traces/{trace_id}",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(TraceDetail, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_spans_of_generation(
        self,
        *,
        app_id: str,
        page: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        type: typing.Optional[str] = None,
        trace_id: typing.Optional[str] = None,
        environment: typing.Optional[str] = None,
        variant: typing.Optional[str] = None,
        created_at: typing.Optional[str] = None,
    ) -> typing.Any:
        """
        Parameters:
            - app_id: str.

            - page: typing.Optional[int].

            - page_size: typing.Optional[int].

            - type: typing.Optional[str].

            - trace_id: typing.Optional[str].

            - environment: typing.Optional[str].

            - variant: typing.Optional[str].

            - created_at: typing.Optional[str].
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.observability.get_spans_of_generation(
            app_id="app_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "observability/spans"
            ),
            params=remove_none_from_dict(
                {
                    "app_id": app_id,
                    "page": page,
                    "pageSize": page_size,
                    "type": type,
                    "trace_id": trace_id,
                    "environment": environment,
                    "variant": variant,
                    "created_at": created_at,
                }
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete_spans_of_trace(self, *, request: typing.List[str]) -> bool:
        """
        Parameters:
            - request: typing.List[str].
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.observability.delete_spans_of_trace(
            request=["string"],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "observability/spans"
            ),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(bool, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_span_of_generation(
        self, span_id: str, *, type: typing.Optional[str] = None
    ) -> SpanDetail:
        """
        Parameters:
            - span_id: str.

            - type: typing.Optional[str].
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.observability.get_span_of_generation(
            span_id="span_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"observability/spans/{span_id}",
            ),
            params=remove_none_from_dict({"type": type}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(SpanDetail, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_feedbacks(self, trace_id: str) -> typing.List[Feedback]:
        """
        Parameters:
            - trace_id: str.
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.observability.get_feedbacks(
            trace_id="trace_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"observability/feedbacks/{trace_id}",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[Feedback], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_feedback(
        self,
        trace_id: str,
        *,
        feedback: typing.Optional[str] = OMIT,
        score: typing.Optional[float] = OMIT,
        meta: typing.Optional[typing.Dict[str, typing.Any]] = OMIT,
    ) -> str:
        """
        Parameters:
            - trace_id: str.

            - feedback: typing.Optional[str].

            - score: typing.Optional[float].

            - meta: typing.Optional[typing.Dict[str, typing.Any]].
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.observability.create_feedback(
            trace_id="trace_id",
        )
        """
        _request: typing.Dict[str, typing.Any] = {}
        if feedback is not OMIT:
            _request["feedback"] = feedback
        if score is not OMIT:
            _request["score"] = score
        if meta is not OMIT:
            _request["meta"] = meta
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"observability/feedbacks/{trace_id}",
            ),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(str, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_feedback(self, trace_id: str, feedback_id: str) -> Feedback:
        """
        Parameters:
            - trace_id: str.

            - feedback_id: str.
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.observability.get_feedback(
            trace_id="trace_id",
            feedback_id="feedback_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"observability/feedbacks/{trace_id}/{feedback_id}",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Feedback, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update_feedback(
        self,
        trace_id: str,
        feedback_id: str,
        *,
        feedback: str,
        score: typing.Optional[float] = OMIT,
        meta: typing.Optional[typing.Dict[str, typing.Any]] = OMIT,
    ) -> Feedback:
        """
        Parameters:
            - trace_id: str.

            - feedback_id: str.

            - feedback: str.

            - score: typing.Optional[float].

            - meta: typing.Optional[typing.Dict[str, typing.Any]].
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.observability.update_feedback(
            trace_id="trace_id",
            feedback_id="feedback_id",
            feedback="feedback",
        )
        """
        _request: typing.Dict[str, typing.Any] = {"feedback": feedback}
        if score is not OMIT:
            _request["score"] = score
        if meta is not OMIT:
            _request["meta"] = meta
        _response = self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"observability/feedbacks/{trace_id}/{feedback_id}",
            ),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Feedback, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncObservabilityClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def dashboard(
        self,
        *,
        app_id: str,
        time_range: typing.Optional[str] = None,
        environment: typing.Optional[str] = None,
        variant: typing.Optional[str] = None,
    ) -> typing.Any:
        """
        Parameters:
            - app_id: str.

            - time_range: typing.Optional[str].

            - environment: typing.Optional[str].

            - variant: typing.Optional[str].
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.observability.dashboard(
            app_id="app_id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "observability/dashboard"
            ),
            params=remove_none_from_dict(
                {
                    "app_id": app_id,
                    "timeRange": time_range,
                    "environment": environment,
                    "variant": variant,
                }
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_traces(
        self,
        *,
        app_id: str,
        page: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        type: typing.Optional[str] = None,
        trace_id: typing.Optional[str] = None,
        environment: typing.Optional[str] = None,
        variant: typing.Optional[str] = None,
        created_at: typing.Optional[str] = None,
    ) -> WithPagination:
        """
        Parameters:
            - app_id: str.

            - page: typing.Optional[int].

            - page_size: typing.Optional[int].

            - type: typing.Optional[str].

            - trace_id: typing.Optional[str].

            - environment: typing.Optional[str].

            - variant: typing.Optional[str].

            - created_at: typing.Optional[str].
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.observability.get_traces(
            app_id="app_id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "observability/traces"
            ),
            params=remove_none_from_dict(
                {
                    "app_id": app_id,
                    "page": page,
                    "pageSize": page_size,
                    "type": type,
                    "trace_id": trace_id,
                    "environment": environment,
                    "variant": variant,
                    "created_at": created_at,
                }
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(WithPagination, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_traces(
        self, *, trace: str, spans: typing.List[CreateSpan]
    ) -> CreateTraceResponse:
        """
        Parameters:
            - trace: str.

            - spans: typing.List[CreateSpan].
        ---
        import datetime

        from agenta import CreateSpan, SpanKind, SpanStatusCode
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.observability.create_traces(
            trace="trace",
            spans=[
                CreateSpan(
                    id="id",
                    name="name",
                    spankind=SpanKind.TOOL,
                    status=SpanStatusCode.UNSET,
                    start_time=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    end_time=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                )
            ],
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "observability/trace/"
            ),
            json=jsonable_encoder({"trace": trace, "spans": spans}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(CreateTraceResponse, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete_traces(self, *, request: typing.List[str]) -> bool:
        """
        Parameters:
            - request: typing.List[str].
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.observability.delete_traces(
            request=["string"],
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "observability/traces"
            ),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(bool, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_trace_detail(self, trace_id: str) -> TraceDetail:
        """
        Parameters:
            - trace_id: str.
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.observability.get_trace_detail(
            trace_id="trace_id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"observability/traces/{trace_id}",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(TraceDetail, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_spans_of_generation(
        self,
        *,
        app_id: str,
        page: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        type: typing.Optional[str] = None,
        trace_id: typing.Optional[str] = None,
        environment: typing.Optional[str] = None,
        variant: typing.Optional[str] = None,
        created_at: typing.Optional[str] = None,
    ) -> typing.Any:
        """
        Parameters:
            - app_id: str.

            - page: typing.Optional[int].

            - page_size: typing.Optional[int].

            - type: typing.Optional[str].

            - trace_id: typing.Optional[str].

            - environment: typing.Optional[str].

            - variant: typing.Optional[str].

            - created_at: typing.Optional[str].
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.observability.get_spans_of_generation(
            app_id="app_id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "observability/spans"
            ),
            params=remove_none_from_dict(
                {
                    "app_id": app_id,
                    "page": page,
                    "pageSize": page_size,
                    "type": type,
                    "trace_id": trace_id,
                    "environment": environment,
                    "variant": variant,
                    "created_at": created_at,
                }
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete_spans_of_trace(self, *, request: typing.List[str]) -> bool:
        """
        Parameters:
            - request: typing.List[str].
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.observability.delete_spans_of_trace(
            request=["string"],
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "observability/spans"
            ),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(bool, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_span_of_generation(
        self, span_id: str, *, type: typing.Optional[str] = None
    ) -> SpanDetail:
        """
        Parameters:
            - span_id: str.

            - type: typing.Optional[str].
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.observability.get_span_of_generation(
            span_id="span_id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"observability/spans/{span_id}",
            ),
            params=remove_none_from_dict({"type": type}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(SpanDetail, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_feedbacks(self, trace_id: str) -> typing.List[Feedback]:
        """
        Parameters:
            - trace_id: str.
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.observability.get_feedbacks(
            trace_id="trace_id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"observability/feedbacks/{trace_id}",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[Feedback], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_feedback(
        self,
        trace_id: str,
        *,
        feedback: typing.Optional[str] = OMIT,
        score: typing.Optional[float] = OMIT,
        meta: typing.Optional[typing.Dict[str, typing.Any]] = OMIT,
    ) -> str:
        """
        Parameters:
            - trace_id: str.

            - feedback: typing.Optional[str].

            - score: typing.Optional[float].

            - meta: typing.Optional[typing.Dict[str, typing.Any]].
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.observability.create_feedback(
            trace_id="trace_id",
        )
        """
        _request: typing.Dict[str, typing.Any] = {}
        if feedback is not OMIT:
            _request["feedback"] = feedback
        if score is not OMIT:
            _request["score"] = score
        if meta is not OMIT:
            _request["meta"] = meta
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"observability/feedbacks/{trace_id}",
            ),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(str, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_feedback(self, trace_id: str, feedback_id: str) -> Feedback:
        """
        Parameters:
            - trace_id: str.

            - feedback_id: str.
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.observability.get_feedback(
            trace_id="trace_id",
            feedback_id="feedback_id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"observability/feedbacks/{trace_id}/{feedback_id}",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Feedback, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update_feedback(
        self,
        trace_id: str,
        feedback_id: str,
        *,
        feedback: str,
        score: typing.Optional[float] = OMIT,
        meta: typing.Optional[typing.Dict[str, typing.Any]] = OMIT,
    ) -> Feedback:
        """
        Parameters:
            - trace_id: str.

            - feedback_id: str.

            - feedback: str.

            - score: typing.Optional[float].

            - meta: typing.Optional[typing.Dict[str, typing.Any]].
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.observability.update_feedback(
            trace_id="trace_id",
            feedback_id="feedback_id",
            feedback="feedback",
        )
        """
        _request: typing.Dict[str, typing.Any] = {"feedback": feedback}
        if score is not OMIT:
            _request["score"] = score
        if meta is not OMIT:
            _request["meta"] = meta
        _response = await self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"observability/feedbacks/{trace_id}/{feedback_id}",
            ),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Feedback, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
